/*
 * Decompiled with CFR 0.152.
 */
package org.exist;

import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import org.exist.storage.BrokerPool;
import org.exist.util.Configuration;
import org.exist.xmldb.DatabaseImpl;
import org.exist.xmldb.ShutdownListener;
import org.mortbay.jetty.Server;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Database;

public class JettyStart {
    public static void main(String[] args) {
        JettyStart start = new JettyStart();
        start.run(args);
    }

    public void run(String[] args) {
        if (args.length == 0) {
            System.out.println("No configuration file specified!");
            return;
        }
        String shutdownHookOption = System.getProperty("exist.register-shutdown-hook", "true");
        boolean registerShutdownHook = shutdownHookOption.equals("true");
        String home = System.getProperty("exist.home");
        if (home == null) {
            home = System.getProperty("user.dir");
        }
        System.out.println("Configuring eXist from " + home + File.separatorChar + "conf.xml");
        try {
            BrokerPool.setRegisterShutdownHook(false);
            Configuration config = new Configuration("conf.xml", home);
            BrokerPool.configure(1, 5, config);
            DatabaseImpl xmldb = new DatabaseImpl();
            xmldb.setProperty("create-database", "false");
            DatabaseManager.registerDatabase((Database)xmldb);
        }
        catch (Exception e) {
            System.err.println("configuration error: " + e.getMessage());
            e.printStackTrace();
            return;
        }
        try {
            final Server server = new Server(args[0]);
            BrokerPool.getInstance().registerShutdownListener(new ShutdownListenerImpl(server));
            server.start();
            if (registerShutdownHook) {
                Thread hook = new Thread(){

                    public void run() {
                        this.setName("Shutdown");
                        BrokerPool.stopAll(true);
                        try {
                            server.stop();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                Runtime.getRuntime().addShutdownHook(hook);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void shutdown() {
        BrokerPool.stopAll(false);
    }

    private static class ShutdownListenerImpl
    implements ShutdownListener {
        private Server server;

        public ShutdownListenerImpl(Server server) {
            this.server = server;
        }

        public void shutdown(String dbname, int remainingInstances) {
            System.err.println("Database shutdown: stopping server in 1sec ...");
            if (remainingInstances == 0) {
                Timer timer = new Timer();
                timer.schedule(new TimerTask(this){
                    private final /* synthetic */ ShutdownListenerImpl this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        try {
                            ShutdownListenerImpl.access$000(this.this$0).stop();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        System.exit(0);
                    }
                }, 1000L);
            }
        }

        static /* synthetic */ Server access$000(ShutdownListenerImpl x0) {
            return x0.server;
        }
    }
}

