/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.filer;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import org.dbxml.core.DBException;
import org.dbxml.core.data.Value;
import org.dbxml.core.filer.BTreeCallback;
import org.dbxml.core.filer.BTreeException;
import org.dbxml.core.filer.Paged;
import org.dbxml.core.indexer.IndexQuery;
import org.exist.storage.BufferStats;
import org.exist.storage.cache.Cache;
import org.exist.storage.cache.Cacheable;
import org.exist.storage.cache.LRDCache;
import org.exist.storage.io.VariableByteArrayInput;
import org.exist.util.ByteConversion;
import org.exist.util.Lock;
import org.exist.xquery.TerminatedException;

public class BTree
extends Paged {
    public static final long BTREE_SYNC_PERIOD = 15000L;
    protected static final byte LEAF = 1;
    protected static final byte BRANCH = 2;
    protected static final byte STREAM = 3;
    public static final long KEY_NOT_FOUND = -1L;
    private BTreeFileHeader fileHeader;
    protected int buffers = 1024;
    protected Cache cache;

    public BTree(int buffers) {
        this.buffers = buffers;
        this.fileHeader = (BTreeFileHeader)this.getFileHeader();
        this.fileHeader.setPageCount(0L);
        this.fileHeader.setTotalCount(0L);
    }

    public BTree(File file, int buffers) {
        this(buffers);
        this.setFile(file);
    }

    public boolean open(short expectedVersion, Lock lock) throws DBException {
        if (super.open(expectedVersion)) {
            this.initCache(lock);
            return true;
        }
        return false;
    }

    public boolean create(Lock lock) throws DBException {
        return this.create((short)-1, lock);
    }

    public boolean create(short fixedKeyLen, Lock lock) throws DBException {
        if (super.create()) {
            try {
                this.initCache(lock);
                this.createRootNode();
                this.fileHeader.setFixedKeyLen(fixedKeyLen);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private void initCache(Lock lock) {
        this.cache = new LRDCache(this.buffers);
        this.cache.setFileName(this.getFile().getName());
    }

    protected long getBTreeSyncPeriod() {
        return 15000L;
    }

    public short getFixedKeyLen() {
        BTreeFileHeader fileHeader = (BTreeFileHeader)this.getFileHeader();
        return fileHeader.getFixedKeyLen();
    }

    public boolean drop() throws DBException {
        try {
            return this.getFile().delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public long addValue(Value value, long pointer) throws IOException, BTreeException {
        return this.getRootNode().addValue(value, pointer);
    }

    public void remove() throws IOException, BTreeException {
        this.getRootNode().remove();
    }

    public long removeValue(Value value) throws IOException, BTreeException {
        return this.getRootNode().removeValue(value);
    }

    public long findValue(Value value) throws IOException, BTreeException {
        return this.getRootNode().findValue(value);
    }

    public void query(IndexQuery query, BTreeCallback callback) throws IOException, BTreeException, TerminatedException {
        if (query != null && query.getOperator() == 7) {
            Value val1 = query.getValue(0);
            byte[] data1 = val1.getData();
            byte[] data2 = new byte[data1.length];
            System.arraycopy(data1, 0, data2, 0, data1.length);
            int n = data2.length - 1;
            data2[n] = (byte)(data2[n] + 1);
            query = new IndexQuery(query.getOperator(), val1, new Value(data2));
        }
        this.getRootNode().query(query, callback);
    }

    public void remove(IndexQuery query, BTreeCallback callback) throws IOException, BTreeException, TerminatedException {
        if (query != null && query.getOperator() == 7) {
            Value val1 = query.getValue(0);
            byte[] data1 = val1.getData();
            byte[] data2 = new byte[data1.length];
            System.arraycopy(data1, 0, data2, 0, data1.length);
            int n = data2.length - 1;
            data2[n] = (byte)(data2[n] + 1);
            query = new IndexQuery(query.getOperator(), val1, new Value(data2));
        }
        this.getRootNode().remove(query, callback);
    }

    private BTreeNode getBTreeNode(long page, BTreeNode parent) {
        try {
            BTreeNode node = (BTreeNode)this.cache.get(page);
            if (node == null) {
                Paged.Page p = this.getPage(page);
                node = new BTreeNode(p);
                node.read();
            }
            node.parent = parent;
            int increment = node.getStatus() == 2 ? 2 : 1;
            this.cache.add(node, increment);
            return node;
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            return null;
        }
    }

    private BTreeNode createBTreeNode(byte status, BTreeNode parent) {
        try {
            Paged.Page p = this.getFreePage();
            BTreeNode node = new BTreeNode(p);
            node.ph.setStatus(status);
            node.setValues(new Value[0]);
            node.setPointers(new long[0]);
            node.parent = parent;
            node.write();
            this.fileHeader.incNodePageCount();
            return node;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void setRootNode(BTreeNode rootNode) throws IOException {
        this.fileHeader.setRootPage(rootNode.page.getPageNum());
        this.fileHeader.write();
        this.cache.add(rootNode, 2);
    }

    protected long createRootNode() throws IOException {
        BTreeNode root = this.createBTreeNode((byte)1, null);
        this.setRootNode(root);
        return root.page.getPageNum();
    }

    protected BTreeNode getRootNode() {
        try {
            BTreeNode node = (BTreeNode)this.cache.get(this.fileHeader.getRootPage());
            if (node == null) {
                Paged.Page p = this.getPage(this.fileHeader.getRootPage());
                node = new BTreeNode(p);
                node.read();
            }
            this.cache.add(node, 2);
            return node;
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            return null;
        }
    }

    public boolean flush() throws DBException {
        this.cache.flush();
        super.flush();
        return true;
    }

    public boolean close() throws DBException {
        this.flush();
        super.close();
        return true;
    }

    public Paged.FileHeader createFileHeader() {
        return new BTreeFileHeader(PAGE_SIZE);
    }

    public Paged.FileHeader createFileHeader(boolean read) throws IOException {
        return new BTreeFileHeader(read);
    }

    public Paged.FileHeader createFileHeader(long pageCount) {
        return new BTreeFileHeader(pageCount, PAGE_SIZE);
    }

    public Paged.FileHeader createFileHeader(long pageCount, int pageSize) {
        return new BTreeFileHeader(pageCount, pageSize);
    }

    public Paged.PageHeader createPageHeader() {
        return new BTreePageHeader();
    }

    public BufferStats getIndexBufferStats() {
        return new BufferStats(this.cache.getBuffers(), this.cache.getUsedBuffers(), this.cache.getHits(), this.cache.getFails());
    }

    public void printStatistics() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getFile().getName()).append(" INDEX ");
        buf.append(this.cache.getBuffers()).append(" / ");
        buf.append(this.cache.getUsedBuffers()).append(" / ");
        buf.append(this.cache.getHits()).append(" / ");
        buf.append(this.cache.getFails());
        LOG.info((Object)buf.toString());
    }

    protected static class BTreePageHeader
    extends Paged.PageHeader {
        private short valueCount = 0;

        public BTreePageHeader() {
        }

        public BTreePageHeader(byte[] data, int offset) throws IOException {
            super(data, offset);
        }

        public int read(byte[] data, int offset) throws IOException {
            offset = super.read(data, offset);
            this.valueCount = ByteConversion.byteToShort(data, offset);
            return offset + 2;
        }

        public int write(byte[] data, int offset) throws IOException {
            offset = super.write(data, offset);
            ByteConversion.shortToByte(this.valueCount, data, offset);
            return offset + 2;
        }

        public final void setValueCount(short valueCount) {
            this.valueCount = valueCount;
            this.setDirty(true);
        }

        public final short getValueCount() {
            return this.valueCount;
        }

        public final short getPointerCount() {
            if (this.getStatus() == 2) {
                return (short)(this.valueCount + 1);
            }
            return this.valueCount;
        }
    }

    protected class BTreeFileHeader
    extends Paged.FileHeader {
        private long rootPage;
        private int nodePageCount;
        private short fixedLen;

        public BTreeFileHeader() {
            super(BTree.this);
            this.rootPage = 0L;
            this.nodePageCount = 0;
            this.fixedLen = (short)-1;
        }

        public BTreeFileHeader(long pageCount) {
            super((Paged)BTree.this, pageCount);
            this.rootPage = 0L;
            this.nodePageCount = 0;
            this.fixedLen = (short)-1;
        }

        public BTreeFileHeader(long pageCount, int pageSize) {
            super(BTree.this, pageCount, pageSize);
            this.rootPage = 0L;
            this.nodePageCount = 0;
            this.fixedLen = (short)-1;
        }

        public BTreeFileHeader(long pageCount, int pageSize, byte blockSize) {
            super(BTree.this, pageCount, pageSize, blockSize);
            this.rootPage = 0L;
            this.nodePageCount = 0;
            this.fixedLen = (short)-1;
        }

        public BTreeFileHeader(int pageSize) {
            super((Paged)BTree.this, pageSize);
            this.rootPage = 0L;
            this.nodePageCount = 0;
            this.fixedLen = (short)-1;
        }

        public BTreeFileHeader(boolean read) throws IOException {
            super((Paged)BTree.this, read);
            this.rootPage = 0L;
            this.nodePageCount = 0;
            this.fixedLen = (short)-1;
        }

        public void read(RandomAccessFile raf) throws IOException {
            super.read(raf);
            this.rootPage = raf.readLong();
            this.fixedLen = raf.readShort();
            this.nodePageCount = raf.readInt();
        }

        public void write(RandomAccessFile raf) throws IOException {
            super.write(raf);
            raf.writeLong(this.rootPage);
            raf.writeShort(this.fixedLen);
            raf.writeInt(this.nodePageCount);
        }

        public final void setRootPage(long rootPage) {
            this.rootPage = rootPage;
            this.setDirty(true);
        }

        public final long getRootPage() {
            return this.rootPage;
        }

        public short getFixedKeyLen() {
            return this.fixedLen;
        }

        public void setFixedKeyLen(short keyLen) {
            this.fixedLen = keyLen;
        }

        public void incNodePageCount() {
            ++this.nodePageCount;
        }

        public int getNodePageCount() {
            return this.nodePageCount;
        }
    }

    protected final class BTreeNode
    implements Cacheable {
        private Paged.Page page;
        private BTreePageHeader ph;
        private Value[] values = null;
        private long[] ptrs = null;
        private BTreeNode parent = null;
        private int refCount = 0;
        private int timestamp = 0;
        private boolean saved = true;
        private int currentDataLen = -1;

        public BTreeNode(Paged.Page page) {
            this.page = page;
            this.ph = (BTreePageHeader)page.getPageHeader();
        }

        public int getReferenceCount() {
            return this.refCount;
        }

        public int incReferenceCount() {
            if (this.refCount < 10000) {
                ++this.refCount;
            }
            return this.refCount;
        }

        public void setReferenceCount(int count) {
            this.refCount = count;
        }

        public void setTimestamp(int timestamp) {
            this.timestamp = timestamp;
        }

        public int getTimestamp() {
            return this.timestamp;
        }

        public boolean sync() {
            if (this.isDirty()) {
                try {
                    this.write();
                    return true;
                }
                catch (IOException e) {
                    Paged.LOG.warn((Object)("IO error while writing page: " + this.page.getPageNum()), (Throwable)e);
                }
            }
            return false;
        }

        public long getKey() {
            return this.page.getPageNum();
        }

        public int decReferenceCount() {
            return this.refCount > 0 ? (this.refCount = this.refCount - 1) : 0;
        }

        public int getStatus() {
            return this.ph.getStatus();
        }

        public void setValues(Value[] values) {
            this.values = values;
            this.saved = false;
            this.ph.setValueCount((short)values.length);
        }

        public Value[] getValues() {
            return this.values;
        }

        public void setPointers(long[] ptrs) {
            this.saved = false;
            this.ptrs = ptrs;
        }

        private int getDataLen() {
            return this.currentDataLen < 0 ? this.recalculateDataLen() : this.currentDataLen;
        }

        private int recalculateDataLen() {
            int n = this.currentDataLen = this.ptrs == null ? 0 : this.ptrs.length << 3;
            if (BTree.this.fileHeader.getFixedKeyLen() < 0) {
                this.currentDataLen += 2 * this.values.length;
            }
            for (int i = 0; i < this.values.length; ++i) {
                this.currentDataLen += this.values[i].getLength();
            }
            return this.currentDataLen;
        }

        private void adjustDataLen(Value value) {
            if (this.currentDataLen < 0) {
                this.recalculateDataLen();
            }
            this.currentDataLen += value.getLength() + 8;
            if (BTree.this.fileHeader.getFixedKeyLen() < 0) {
                this.currentDataLen += 2;
            }
        }

        private boolean mustSplit() {
            return this.getDataLen() > BTree.this.fileHeader.getWorkSize();
        }

        public long[] getPointers() {
            return this.ptrs;
        }

        public boolean isDirty() {
            return !this.saved;
        }

        public void __read() throws IOException {
            int i;
            byte[] data = this.page.read();
            VariableByteArrayInput is = new VariableByteArrayInput(data);
            this.values = new Value[this.ph.getValueCount()];
            short valSize = BTree.this.fileHeader.getFixedKeyLen();
            for (i = 0; i < this.values.length; ++i) {
                if (BTree.this.fileHeader.getFixedKeyLen() < 0) {
                    valSize = is.readShort();
                }
                byte[] b = new byte[valSize];
                is.read(b, 0, valSize);
                this.values[i] = new Value(b);
            }
            this.ptrs = new long[this.ph.getPointerCount()];
            for (i = 0; i < this.ph.getPointerCount(); ++i) {
                try {
                    this.ptrs[i] = is.readLong();
                    continue;
                }
                catch (EOFException eof) {
                    break;
                }
            }
        }

        public void read() throws IOException {
            short keyLen;
            byte[] data = this.page.read();
            this.values = new Value[this.ph.getValueCount()];
            short valSize = keyLen = BTree.this.fileHeader.getFixedKeyLen();
            int p = 0;
            for (int i = 0; i < this.values.length; ++i) {
                if (keyLen < 0) {
                    valSize = ByteConversion.byteToShort(data, p);
                    p += 2;
                }
                this.values[i] = new Value(data, p, valSize);
                p += valSize;
            }
            int ptrCount = this.ph.getPointerCount();
            this.ptrs = new long[ptrCount];
            for (int i = 0; i < ptrCount; ++i) {
                this.ptrs[i] = ByteConversion.byteToLong(data, p);
                p += 8;
            }
        }

        public void _read() throws IOException {
            int i;
            byte[] data = this.page.read();
            DataInputStream is = new DataInputStream(new ByteArrayInputStream(data));
            this.values = new Value[this.ph.getValueCount()];
            short valSize = BTree.this.fileHeader.getFixedKeyLen();
            for (i = 0; i < this.values.length; ++i) {
                if (BTree.this.fileHeader.getFixedKeyLen() < 0) {
                    valSize = is.readShort();
                }
                byte[] b = new byte[valSize];
                is.read(b, 0, valSize);
                this.values[i] = new Value(b);
            }
            this.ptrs = new long[this.ph.getPointerCount()];
            for (i = 0; i < this.ph.getPointerCount(); ++i) {
                try {
                    this.ptrs[i] = is.readLong();
                    continue;
                }
                catch (EOFException eof) {
                    eof.printStackTrace();
                    if (this.ph.getStatus() == 1) {
                        System.out.println("leaf: " + this.ph.getPointerCount() + " read: " + (i + 1));
                        break;
                    }
                    System.out.println("branch: " + this.ph.getPointerCount() + " values: " + this.ph.getValueCount());
                    break;
                }
            }
        }

        public void write() throws IOException {
            int i;
            byte[] temp = new byte[BTree.this.fileHeader.getWorkSize()];
            int p = 0;
            short keyLen = BTree.this.fileHeader.getFixedKeyLen();
            for (i = 0; i < this.values.length; ++i) {
                byte[] data;
                if (keyLen < 0) {
                    ByteConversion.shortToByte((short)this.values[i].getLength(), temp, p);
                    p += 2;
                }
                if (p + (data = this.values[i].getData()).length > temp.length) {
                    throw new IOException("calculated: " + this.getDataLen() + "; required: " + (p + data.length));
                }
                System.arraycopy(data, 0, temp, p, data.length);
                p += data.length;
            }
            for (i = 0; i < this.ptrs.length; ++i) {
                ByteConversion.longToByte(this.ptrs[i], temp, p);
                p += 8;
            }
            BTree.this.writeValue(this.page, new Value(temp));
            this.saved = true;
        }

        public BTreeNode getChildNode(int idx) throws IOException {
            if (this.ph.getStatus() == 2 && idx >= 0 && idx < this.ptrs.length) {
                return BTree.this.getBTreeNode(this.ptrs[idx], this);
            }
            return null;
        }

        public void remove() throws IOException, BTreeException {
            if (this.ph.getStatus() == 2) {
                for (int i = 0; i < this.ptrs.length; ++i) {
                    this.getChildNode(i).remove();
                }
            }
            BTree.this.cache.remove(this);
            BTree.this.unlinkPages(this.page);
        }

        public long removeValue(Value value) throws IOException, BTreeException {
            int idx = Arrays.binarySearch(this.values, value);
            switch (this.ph.getStatus()) {
                case 2: {
                    if (idx < 0) {
                        idx = -(idx + 1);
                    }
                    return this.getChildNode(idx).removeValue(value);
                }
                case 1: {
                    if (idx < 0) {
                        return -1L;
                    }
                    long oldPtr = this.ptrs[idx];
                    this.setValues(Paged.deleteArrayValue(this.values, idx));
                    this.setPointers(Paged.deleteArrayLong(this.ptrs, idx));
                    this.recalculateDataLen();
                    return oldPtr;
                }
            }
            throw new BTreeException("Invalid Page Type In removeValue");
        }

        public long addValue(Value value, long pointer) throws IOException, BTreeException {
            int idx = Arrays.binarySearch(this.values, value);
            switch (this.ph.getStatus()) {
                case 2: {
                    if (idx < 0) {
                        idx = -(idx + 1);
                    }
                    return this.getChildNode(idx).addValue(value, pointer);
                }
                case 1: {
                    if (idx >= 0) {
                        long oldPtr = this.ptrs[idx];
                        this.ptrs[idx] = pointer;
                        this.setPointers(this.ptrs);
                        return oldPtr;
                    }
                    idx = -(idx + 1);
                    this.setValues(Paged.insertArrayValue(this.values, value, idx));
                    this.setPointers(Paged.insertArrayLong(this.ptrs, pointer, idx));
                    this.adjustDataLen(value);
                    if (this.getDataLen() > BTree.this.fileHeader.getWorkSize()) {
                        this.split();
                    }
                    return -1L;
                }
            }
            throw new BTreeException("Invalid Page Type In addValue");
        }

        public void promoteValue(Value value, long rightPointer) throws IOException, BTreeException {
            boolean split;
            int idx = Arrays.binarySearch(this.values, value);
            if (idx < 0) {
                idx = -(idx + 1);
            }
            this.setValues(Paged.insertArrayValue(this.values, value, idx));
            this.setPointers(Paged.insertArrayLong(this.ptrs, rightPointer, idx + 1));
            boolean bl = split = this.recalculateDataLen() > BTree.this.fileHeader.getWorkSize();
            if (split) {
                this.split();
            }
        }

        public Value getSeparator(Value value1, Value value2) {
            int idx = value1.compareTo(value2);
            byte[] b = new byte[Math.abs(idx)];
            System.arraycopy(value2.getData(), 0, b, 0, b.length);
            return new Value(b);
        }

        /*
         * WARNING - void declaration
         */
        public void split() throws IOException, BTreeException {
            void var5_7;
            void var4_6;
            void var2_5;
            void var3_4;
            void var1_3;
            short vc = this.ph.getValueCount();
            int pivot = vc / 2;
            switch (this.ph.getStatus()) {
                case 2: {
                    Value[] leftVals = new Value[pivot];
                    long[] leftPtrs = new long[leftVals.length + 1];
                    Value[] rightVals = new Value[vc - (pivot + 1)];
                    long[] rightPtrs = new long[rightVals.length + 1];
                    System.arraycopy(this.values, 0, leftVals, 0, leftVals.length);
                    System.arraycopy(this.ptrs, 0, leftPtrs, 0, leftPtrs.length);
                    System.arraycopy(this.values, leftVals.length + 1, rightVals, 0, rightVals.length);
                    System.arraycopy(this.ptrs, leftPtrs.length, rightPtrs, 0, rightPtrs.length);
                    Value separator = this.values[leftVals.length];
                    break;
                }
                case 1: {
                    Value[] leftVals = new Value[pivot];
                    long[] leftPtrs = new long[leftVals.length];
                    Value[] rightVals = new Value[vc - pivot];
                    long[] rightPtrs = new long[rightVals.length];
                    System.arraycopy(this.values, 0, leftVals, 0, leftVals.length);
                    System.arraycopy(this.ptrs, 0, leftPtrs, 0, leftPtrs.length);
                    System.arraycopy(this.values, leftVals.length, rightVals, 0, rightVals.length);
                    System.arraycopy(this.ptrs, leftPtrs.length, rightPtrs, 0, rightPtrs.length);
                    Value separator = leftVals[leftVals.length - 1];
                    break;
                }
                default: {
                    throw new BTreeException("Invalid Page Type In split");
                }
            }
            this.setValues((Value[])var1_3);
            this.setPointers((long[])var3_4);
            this.recalculateDataLen();
            if (this.parent == null) {
                this.parent = BTree.this.createBTreeNode((byte)2, null);
                BTreeNode rNode = BTree.this.createBTreeNode(this.ph.getStatus(), this.parent);
                rNode.setValues((Value[])var2_5);
                rNode.setPointers((long[])var4_6);
                rNode.recalculateDataLen();
                BTree.this.cache.add(rNode);
                this.parent.setValues(new Value[]{var5_7});
                this.parent.setPointers(new long[]{this.page.getPageNum(), rNode.page.getPageNum()});
                this.parent.recalculateDataLen();
                BTree.this.cache.add(this.parent);
                BTree.this.setRootNode(this.parent);
                if (rNode.mustSplit()) {
                    Paged.LOG.debug((Object)(BTree.this.getFile().getName() + " right node requires second split: " + rNode.getDataLen()));
                    rNode.split();
                }
            } else {
                BTreeNode rNode = BTree.this.createBTreeNode(this.ph.getStatus(), this.parent);
                rNode.setValues((Value[])var2_5);
                rNode.setPointers((long[])var4_6);
                rNode.recalculateDataLen();
                BTree.this.cache.add(rNode);
                this.parent.promoteValue((Value)var5_7, rNode.page.getPageNum());
                if (rNode.mustSplit()) {
                    Paged.LOG.debug((Object)(BTree.this.getFile().getName() + " right node requires second split: " + rNode.getDataLen()));
                    rNode.split();
                }
            }
            if (this.mustSplit()) {
                Paged.LOG.debug((Object)(BTree.this.getFile().getName() + "left node requires second split: " + this.getDataLen()));
                this.split();
            }
        }

        public long findValue(Value value) throws IOException, BTreeException {
            int idx = Arrays.binarySearch(this.values, value);
            switch (this.ph.getStatus()) {
                case 2: {
                    BTreeNode child;
                    if (idx < 0) {
                        idx = -(idx + 1);
                    }
                    if ((child = this.getChildNode(idx)) == null) {
                        throw new BTreeException("unexpected " + this.ptrs[idx] + ", " + this.page.getPageNum() + ": value '" + value.toString() + "' doesn't exist");
                    }
                    return child.findValue(value);
                }
                case 1: {
                    if (idx < 0) {
                        return -1L;
                    }
                    return this.ptrs[idx];
                }
            }
            throw new BTreeException("Invalid Page Type In findValue");
        }

        public void query(IndexQuery query, BTreeCallback callback) throws IOException, BTreeException, TerminatedException {
            block50: {
                block49: {
                    if (query == null || query.getOperator() == 0 || query.getOperator() == 8) break block49;
                    Value[] qvals = query.getValues();
                    int leftIdx = Arrays.binarySearch(this.values, qvals[0]);
                    int rightIdx = qvals.length > 1 ? Arrays.binarySearch(this.values, qvals[qvals.length - 1]) : leftIdx;
                    boolean pos = query.getOperator() >= 0;
                    switch (this.ph.getStatus()) {
                        case 2: {
                            if (leftIdx < 0) {
                                leftIdx = -(leftIdx + 1);
                            }
                            if (rightIdx < 0) {
                                rightIdx = -(rightIdx + 1);
                            }
                            switch (query.getOperator()) {
                                case -6: 
                                case -5: 
                                case -4: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        if ((i >= leftIdx && i <= rightIdx) != pos) continue;
                                        this.getChildNode(i).query(query, callback);
                                    }
                                    break block50;
                                }
                                case -1: 
                                case 1: {
                                    int i;
                                    for (i = 0; i < this.ptrs.length; ++i) {
                                        if (pos && i != leftIdx) continue;
                                        this.getChildNode(i).query(query, callback);
                                    }
                                }
                                case -3: 
                                case 3: {
                                    int i;
                                    for (i = 0; i < this.ptrs.length; ++i) {
                                        if ((!pos || i > leftIdx) && (pos || i < leftIdx)) continue;
                                        this.getChildNode(i).query(query, callback);
                                    }
                                    break block50;
                                }
                                case -2: 
                                case 2: {
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        if ((!pos || i < leftIdx) && (pos || i > leftIdx)) continue;
                                        this.getChildNode(i).query(query, callback);
                                    }
                                    break block50;
                                }
                                default: {
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        this.getChildNode(i).query(query, callback);
                                    }
                                    break block50;
                                }
                            }
                        }
                        case 1: {
                            block10 : switch (query.getOperator()) {
                                case 1: {
                                    if (leftIdx >= 0) {
                                        callback.indexInfo(this.values[leftIdx], this.ptrs[leftIdx]);
                                        break;
                                    }
                                    break block50;
                                }
                                case -1: {
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        if (i == leftIdx) continue;
                                        callback.indexInfo(this.values[i], this.ptrs[i]);
                                    }
                                    break block50;
                                }
                                case -5: 
                                case -4: 
                                case 4: 
                                case 5: {
                                    if (leftIdx < 0) {
                                        leftIdx = -(leftIdx + 1);
                                    }
                                    if (rightIdx < 0) {
                                        rightIdx = -(rightIdx + 1);
                                    }
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        if ((!pos || i < leftIdx || i > rightIdx) && (pos || i > leftIdx && i < rightIdx) || !query.testValue(this.values[i])) continue;
                                        callback.indexInfo(this.values[i], this.ptrs[i]);
                                    }
                                    break block50;
                                }
                                case 7: {
                                    if (leftIdx < 0) {
                                        leftIdx = -(leftIdx + 1);
                                    }
                                    if (rightIdx < 0) {
                                        rightIdx = -(rightIdx + 1);
                                    }
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        if ((!pos || i < leftIdx || i >= rightIdx) && (pos || i > leftIdx && i < rightIdx) || !query.testValue(this.values[i])) continue;
                                        callback.indexInfo(this.values[i], this.ptrs[i]);
                                    }
                                    break block50;
                                }
                                case -6: 
                                case 6: {
                                    if (leftIdx < 0) {
                                        leftIdx = -(leftIdx + 1);
                                    }
                                    if (rightIdx < 0) {
                                        rightIdx = -(rightIdx + 1);
                                    }
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        if (pos && (i < leftIdx || i > rightIdx) || !query.testValue(this.values[i])) continue;
                                        callback.indexInfo(this.values[i], this.ptrs[i]);
                                    }
                                    break block50;
                                }
                                case -3: 
                                case 3: {
                                    if (leftIdx < 0) {
                                        leftIdx = -(leftIdx + 1);
                                    }
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        if ((!pos || i > leftIdx) && (pos || i < leftIdx) || !query.testValue(this.values[i])) continue;
                                        callback.indexInfo(this.values[i], this.ptrs[i]);
                                    }
                                    break block50;
                                }
                                case -2: 
                                case 2: {
                                    if (leftIdx < 0) {
                                        leftIdx = -(leftIdx + 1);
                                    }
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        if ((!pos || i < leftIdx) && (pos || i > leftIdx)) continue;
                                        if (query.testValue(this.values[i])) {
                                            callback.indexInfo(this.values[i], this.ptrs[i]);
                                            continue;
                                        }
                                        if (query.getOperator() == 7) break block10;
                                    }
                                    break block50;
                                }
                                default: {
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        if (!query.testValue(this.values[i])) continue;
                                        callback.indexInfo(this.values[i], this.ptrs[i]);
                                    }
                                    break block50;
                                }
                            }
                            break block50;
                        }
                        default: {
                            throw new BTreeException("Invalid Page Type In query");
                        }
                    }
                }
                switch (this.ph.getStatus()) {
                    case 2: {
                        for (int i = 0; i < this.ptrs.length; ++i) {
                            this.getChildNode(i).query(query, callback);
                        }
                        break;
                    }
                    case 1: {
                        for (int i = 0; i < this.values.length; ++i) {
                            if (query.getOperator() == 8 && !query.testValue(this.values[i])) continue;
                            callback.indexInfo(this.values[i], this.ptrs[i]);
                        }
                        break;
                    }
                    default: {
                        throw new BTreeException("Invalid Page Type In query");
                    }
                }
            }
        }

        public void remove(IndexQuery query, BTreeCallback callback) throws IOException, BTreeException, TerminatedException {
            block60: {
                block59: {
                    if (query == null || query.getOperator() == 0 || query.getOperator() == 8) break block59;
                    Value[] qvals = query.getValues();
                    int leftIdx = Arrays.binarySearch(this.values, qvals[0]);
                    int rightIdx = qvals.length > 1 ? Arrays.binarySearch(this.values, qvals[qvals.length - 1]) : leftIdx;
                    boolean pos = query.getOperator() >= 0;
                    switch (this.ph.getStatus()) {
                        case 2: {
                            if (leftIdx < 0) {
                                leftIdx = -(leftIdx + 1);
                            }
                            if (rightIdx < 0) {
                                rightIdx = -(rightIdx + 1);
                            }
                            switch (query.getOperator()) {
                                case -6: 
                                case -5: 
                                case -4: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        if ((i >= leftIdx && i <= rightIdx) != pos) continue;
                                        this.getChildNode(i).remove(query, callback);
                                    }
                                    break block60;
                                }
                                case -1: 
                                case 1: {
                                    int i;
                                    for (i = 0; i < this.ptrs.length; ++i) {
                                        if (pos && i != leftIdx) continue;
                                        this.getChildNode(i).remove(query, callback);
                                    }
                                }
                                case -3: 
                                case 3: {
                                    int i;
                                    for (i = 0; i < this.ptrs.length; ++i) {
                                        if ((!pos || i > leftIdx) && (pos || i < leftIdx)) continue;
                                        this.getChildNode(i).remove(query, callback);
                                    }
                                    break block60;
                                }
                                case -2: 
                                case 2: {
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        if ((!pos || i < leftIdx) && (pos || i > leftIdx)) continue;
                                        this.getChildNode(i).remove(query, callback);
                                    }
                                    break block60;
                                }
                                default: {
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        this.getChildNode(i).remove(query, callback);
                                    }
                                    break block60;
                                }
                            }
                        }
                        case 1: {
                            block10 : switch (query.getOperator()) {
                                case 1: {
                                    if (leftIdx >= 0) {
                                        if (callback != null) {
                                            callback.indexInfo(this.values[leftIdx], this.ptrs[leftIdx]);
                                        }
                                        this.setValues(Paged.deleteArrayValue(this.values, leftIdx));
                                        this.setPointers(Paged.deleteArrayLong(this.ptrs, leftIdx));
                                        this.recalculateDataLen();
                                        break;
                                    }
                                    break block60;
                                }
                                case -1: {
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        if (i == leftIdx) continue;
                                        if (callback != null) {
                                            callback.indexInfo(this.values[i], this.ptrs[i]);
                                        }
                                        this.setValues(Paged.deleteArrayValue(this.values, i));
                                        this.setPointers(Paged.deleteArrayLong(this.ptrs, i));
                                        this.recalculateDataLen();
                                    }
                                    break block60;
                                }
                                case -5: 
                                case -4: 
                                case 4: 
                                case 5: {
                                    if (leftIdx < 0) {
                                        leftIdx = -(leftIdx + 1);
                                    }
                                    if (rightIdx < 0) {
                                        rightIdx = -(rightIdx + 1);
                                    }
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        if ((!pos || i < leftIdx || i > rightIdx) && (pos || i > leftIdx && i < rightIdx) || !query.testValue(this.values[i])) continue;
                                        if (callback != null) {
                                            callback.indexInfo(this.values[i], this.ptrs[i]);
                                        }
                                        this.setValues(Paged.deleteArrayValue(this.values, i));
                                        this.setPointers(Paged.deleteArrayLong(this.ptrs, i));
                                        --i;
                                        this.recalculateDataLen();
                                    }
                                    break block60;
                                }
                                case 7: {
                                    if (leftIdx < 0) {
                                        leftIdx = -(leftIdx + 1);
                                    }
                                    if (rightIdx < 0) {
                                        rightIdx = -(rightIdx + 1);
                                    }
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        if ((!pos || i < leftIdx || i >= rightIdx) && (pos || i > leftIdx && i < rightIdx) || !query.testValue(this.values[i])) continue;
                                        if (callback != null) {
                                            callback.indexInfo(this.values[i], this.ptrs[i]);
                                        }
                                        this.setValues(Paged.deleteArrayValue(this.values, i));
                                        this.setPointers(Paged.deleteArrayLong(this.ptrs, i));
                                        --i;
                                        this.recalculateDataLen();
                                    }
                                    break block60;
                                }
                                case -6: 
                                case 6: {
                                    if (leftIdx < 0) {
                                        leftIdx = -(leftIdx + 1);
                                    }
                                    if (rightIdx < 0) {
                                        rightIdx = -(rightIdx + 1);
                                    }
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        if (pos && (i < leftIdx || i > rightIdx) || !query.testValue(this.values[i])) continue;
                                        if (callback != null) {
                                            callback.indexInfo(this.values[i], this.ptrs[i]);
                                        }
                                        this.setValues(Paged.deleteArrayValue(this.values, i));
                                        this.setPointers(Paged.deleteArrayLong(this.ptrs, i));
                                        --i;
                                        this.recalculateDataLen();
                                    }
                                    break block60;
                                }
                                case -3: 
                                case 3: {
                                    if (leftIdx < 0) {
                                        leftIdx = -(leftIdx + 1);
                                    }
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        if ((!pos || i > leftIdx) && (pos || i < leftIdx) || !query.testValue(this.values[i])) continue;
                                        if (callback != null) {
                                            callback.indexInfo(this.values[i], this.ptrs[i]);
                                        }
                                        this.setValues(Paged.deleteArrayValue(this.values, i));
                                        this.setPointers(Paged.deleteArrayLong(this.ptrs, i));
                                        --i;
                                        this.recalculateDataLen();
                                    }
                                    break block60;
                                }
                                case -2: 
                                case 2: {
                                    if (leftIdx < 0) {
                                        leftIdx = -(leftIdx + 1);
                                    }
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        if ((!pos || i < leftIdx) && (pos || i > leftIdx)) continue;
                                        if (query.testValue(this.values[i])) {
                                            if (callback != null) {
                                                callback.indexInfo(this.values[i], this.ptrs[i]);
                                            }
                                            this.setValues(Paged.deleteArrayValue(this.values, i));
                                            this.setPointers(Paged.deleteArrayLong(this.ptrs, i));
                                            --i;
                                            this.recalculateDataLen();
                                            continue;
                                        }
                                        if (query.getOperator() == 7) break block10;
                                    }
                                    break block60;
                                }
                                default: {
                                    for (int i = 0; i < this.ptrs.length; ++i) {
                                        if (!query.testValue(this.values[i])) continue;
                                        if (callback != null) {
                                            callback.indexInfo(this.values[i], this.ptrs[i]);
                                        }
                                        this.setValues(Paged.deleteArrayValue(this.values, i));
                                        this.setPointers(Paged.deleteArrayLong(this.ptrs, i));
                                        --i;
                                        this.recalculateDataLen();
                                    }
                                    break block60;
                                }
                            }
                            break block60;
                        }
                        default: {
                            throw new BTreeException("Invalid Page Type In query");
                        }
                    }
                }
                switch (this.ph.getStatus()) {
                    case 2: {
                        for (int i = 0; i < this.ptrs.length; ++i) {
                            if (callback != null) {
                                callback.indexInfo(this.values[i], this.ptrs[i]);
                            }
                            this.setValues(Paged.deleteArrayValue(this.values, i));
                            this.setPointers(Paged.deleteArrayLong(this.ptrs, i));
                            --i;
                            this.recalculateDataLen();
                        }
                        break;
                    }
                    case 1: {
                        for (int i = 0; i < this.values.length; ++i) {
                            if (query.getOperator() == 8 && !query.testValue(this.values[i])) continue;
                            if (callback != null) {
                                callback.indexInfo(this.values[i], this.ptrs[i]);
                            }
                            this.setValues(Paged.deleteArrayValue(this.values, i));
                            this.setPointers(Paged.deleteArrayLong(this.ptrs, i));
                            --i;
                            this.recalculateDataLen();
                        }
                        break;
                    }
                    default: {
                        throw new BTreeException("Invalid Page Type In query");
                    }
                }
            }
        }

        public boolean allowUnload() {
            return true;
        }
    }
}

