/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.data;

import java.io.UnsupportedEncodingException;

public class Value
implements Comparable {
    protected long address = -1L;
    protected byte[] data = null;
    protected int pos = 0;
    protected int len = -1;

    public Value() {
    }

    public Value(Value value) {
        this.data = value.data;
        this.pos = value.pos;
        this.len = value.len;
    }

    public Value(byte[] data) {
        this.data = data;
        this.len = data.length;
    }

    public Value(byte[] data, int pos, int len) {
        this.data = data;
        this.pos = pos;
        this.len = len;
    }

    public Value(String data) {
        try {
            this.data = data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            this.data = data.getBytes();
        }
        this.len = this.data.length;
    }

    public void setAddress(long addr) {
        this.address = addr;
    }

    public long getAddress() {
        return this.address;
    }

    public byte[] getData() {
        if (this.pos > 0 || this.len < this.data.length) {
            byte[] b = new byte[this.len];
            System.arraycopy(this.data, this.pos, b, 0, this.len);
            return b;
        }
        return this.data;
    }

    public final byte[] data() {
        return this.data;
    }

    public final int start() {
        return this.pos;
    }

    public final int getLength() {
        return this.len;
    }

    public String toString() {
        return new String(this.getData());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Value value) {
        return this.len == value.len ? this.compareTo(value) == 0 : false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Value) {
            return this.equals((Value)obj);
        }
        return this.equals(new Value(obj.toString()));
    }

    public final int compareTo(Value value) {
        int dlen = value.len;
        int stop = this.len > dlen ? dlen : this.len;
        for (int i = 0; i < stop; ++i) {
            byte b1 = this.data[this.pos + i];
            byte b2 = value.data[value.pos + i];
            if (b1 == b2) continue;
            short s1 = (short)(b1 >>> 0);
            short s2 = (short)(b2 >>> 0);
            return s1 > s2 ? i + 1 : -(i + 1);
        }
        if (this.len == dlen) {
            return 0;
        }
        return this.len > dlen ? stop + 1 : -(stop + 1);
    }

    public final int compareTo(Object obj) {
        if (obj instanceof Value) {
            return this.compareTo((Value)obj);
        }
        return this.compareTo(new Value(obj.toString()));
    }

    public final boolean startsWith(Value value) {
        if (this.len < value.len) {
            return false;
        }
        byte[] vdata = value.data;
        int vpos = value.pos;
        for (int i = 0; i < value.len; ++i) {
            if (this.data[i + this.pos] == vdata[i + vpos]) continue;
            return false;
        }
        return true;
    }

    public final boolean endsWith(Value value) {
        if (this.len < value.len) {
            return false;
        }
        byte[] vdata = value.data;
        int vpos = value.pos;
        int d = this.len - value.len;
        for (int i = 0; i < value.len; ++i) {
            if (this.data[d + i + this.pos] == vdata[i + vpos]) continue;
            return false;
        }
        return true;
    }
}

