/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.util.stdlib;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openarchitectureware.workflow.WorkflowComponent;
import org.openarchitectureware.workflow.WorkflowContext;
import org.openarchitectureware.workflow.issues.Issues;
import org.openarchitectureware.workflow.lib.AbstractWorkflowComponent2;
import org.openarchitectureware.workflow.monitor.ProgressMonitor;

public class SlotCopier
extends AbstractWorkflowComponent2 {
    private static final String COMPONENT_NAME = "Slot Copier";
    private String fromSlot;
    private String toSlot;
    private boolean removeTopLevelList = false;
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected void checkConfigurationInternal(Issues issues) {
        if (this.fromSlot == null || this.fromSlot.trim().equals("")) {
            issues.addError((WorkflowComponent)this, "fromSlot not specified");
        }
        if (this.toSlot == null || this.toSlot.trim().equals("")) {
            issues.addError((WorkflowComponent)this, "toSlot not specified");
        }
    }

    public String getLogMessage() {
        return "slot '" + this.fromSlot + "' -> slot '" + this.toSlot + "'";
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor mon, Issues issues) {
        Object content = ctx.get(this.fromSlot);
        if (content == null) {
            issues.addWarning((WorkflowComponent)this, "fromSlot is null!");
        } else if (content instanceof List && this.removeTopLevelList) {
            this.log.info((Object)("copying first element of " + content + " [" + content.getClass().getName() + "]"));
            ctx.set(this.toSlot, ((List)content).get(0));
        } else {
            this.log.info((Object)("copying " + content + " [" + content.getClass().getName() + "]"));
            ctx.set(this.toSlot, content);
        }
    }

    public void setFromSlot(String fromSlot) {
        this.fromSlot = fromSlot;
    }

    public void setToSlot(String toSlot) {
        this.toSlot = toSlot;
    }

    public void setRemoveTopLevelList(boolean removeTopLevelList) {
        this.removeTopLevelList = removeTopLevelList;
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }
}

