/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.issues.indexed;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapSet<K, V>
implements Serializable {
    private static final long serialVersionUID = 2319752836393805017L;
    private final Map<K, Set<V>> map = new HashMap<K, Set<V>>();

    public void put(K key, V value) {
        this.getSet(key).add(value);
    }

    public Set<V> peek(K key) {
        return this.map.get(key);
    }

    public Set<V> get(K key) {
        return this.getSet(key);
    }

    public Iterator<V> iterator(K key) {
        return this.getSet(key).iterator();
    }

    public List<Object> getKeys() {
        ArrayList<Object> keys = new ArrayList<Object>();
        keys.addAll((Collection)this.map.keySet());
        return keys;
    }

    private Set<V> getSet(K key) {
        Set<V> l = this.map.get(key);
        if (l == null) {
            l = new HashSet<V>();
            this.map.put(key, l);
        }
        return l;
    }

    public Iterator<V> iterator() {
        HashSet<V> all = new HashSet<V>();
        for (Set<V> l : this.map.values()) {
            all.addAll(l);
        }
        return all.iterator();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public void remove(Object key) {
        this.map.remove(key);
    }
}

