/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openarchitectureware.workflow.ConfigurationException;
import org.openarchitectureware.workflow.Workflow;
import org.openarchitectureware.workflow.WorkflowComponent;
import org.openarchitectureware.workflow.WorkflowComponentWithID;
import org.openarchitectureware.workflow.WorkflowContext;
import org.openarchitectureware.workflow.ao.AbstractWorkflowAdvice;
import org.openarchitectureware.workflow.ast.parser.Location;
import org.openarchitectureware.workflow.config.FeatureComponent;
import org.openarchitectureware.workflow.container.ConditionEvaluationException;
import org.openarchitectureware.workflow.container.IfComponent;
import org.openarchitectureware.workflow.container.WorkflowConditional;
import org.openarchitectureware.workflow.issues.Issues;
import org.openarchitectureware.workflow.lib.AbstractWorkflowComponent;
import org.openarchitectureware.workflow.monitor.ProgressMonitor;
import org.openarchitectureware.workflow.util.ComponentPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeComponent
extends AbstractWorkflowComponent {
    private static final String COMPONENT_NAME = "Composite Component";
    protected Log log = LogFactory.getLog(this.getClass());
    private String name;
    private String resource;
    private Location location;
    private Location ownLocation;
    private CompositeComponent container;
    protected List<WorkflowComponent> components = new ArrayList<WorkflowComponent>();
    private String id;

    public CompositeComponent(String name) {
        this.name = name;
    }

    public List<WorkflowComponent> getComponents() {
        return this.components;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getLogMessage() {
        return "CompositeComponent " + (this.id != null ? this.id : "");
    }

    @Override
    public void invoke(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        this.internalInvoke(ctx, monitor, issues);
    }

    private void internalInvoke(WorkflowContext model, ProgressMonitor monitor, Issues issues) {
        Iterator<WorkflowComponent> iter = this.components.iterator();
        while (iter.hasNext()) {
            if (monitor != null && monitor.isCanceled()) break;
            WorkflowComponent comp = iter.next();
            if (comp instanceof AbstractWorkflowAdvice) continue;
            comp.setContainer(this);
            if (monitor != null) {
                monitor.preTask(comp, model);
            }
            this.log.info((Object)ComponentPrinter.getString(comp));
            comp.invoke(model, monitor, issues);
            if (monitor == null) continue;
            monitor.postTask(comp, model);
        }
    }

    @Override
    public void checkConfiguration(Issues issues) throws ConfigurationException {
        for (WorkflowComponent comp : this.components) {
            if (!(comp instanceof AbstractWorkflowAdvice)) continue;
            AbstractWorkflowAdvice advice = (AbstractWorkflowAdvice)comp;
            String adviceTargetID = advice.getAdviceTarget();
            if (adviceTargetID == null) {
                issues.addError(advice, "No 'adviceTarget' given.");
                continue;
            }
            Collection<WorkflowComponent> targetComponents = this.findComponentByID(adviceTargetID);
            if (targetComponents.size() == 0) {
                issues.addWarning(advice, "No component with ID '" + adviceTargetID + "' found.");
            }
            if (targetComponents.size() > 1) {
                issues.addWarning(advice, "More than on component with ID '" + adviceTargetID + "' found.");
            }
            if (!this.needsToWeave(comp, issues)) continue;
            for (WorkflowComponent c : targetComponents) {
                ((AbstractWorkflowAdvice)comp).weave(c, issues);
            }
        }
        for (WorkflowComponent comp : this.components) {
            if (comp instanceof AbstractWorkflowAdvice) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Checking configuration of: " + ComponentPrinter.getString(comp)));
            }
            comp.checkConfiguration(issues);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean needsToWeave(WorkflowComponent comp, Issues issues) {
        try {
            WorkflowComponent current = comp;
            while (true) {
                WorkflowConditional cond;
                if (current == null) {
                    return true;
                }
                if (current instanceof WorkflowConditional && !(cond = (WorkflowConditional)((Object)current)).evaluate()) {
                    return false;
                }
                current = current.getContainer();
            }
        }
        catch (ConditionEvaluationException ex) {
            issues.addError(this, ex.getMessage());
            return false;
        }
    }

    private Collection<WorkflowComponent> findComponentByID(String adviceTargetID) {
        ArrayList<WorkflowComponent> hits = new ArrayList<WorkflowComponent>();
        CompositeComponent c = this;
        while (c.getContainer() != null) {
            c = c.getContainer();
        }
        c.resolveComponentByID(adviceTargetID, hits);
        return hits;
    }

    private void resolveComponentByID(String adviceTargetID, List<WorkflowComponent> hits) {
        for (WorkflowComponent component : this.components) {
            if (!(component instanceof WorkflowComponentWithID) || !adviceTargetID.equals(((WorkflowComponentWithID)component).getId())) continue;
            hits.add(component);
        }
        for (WorkflowComponent component : this.components) {
            if (!(component instanceof CompositeComponent)) continue;
            ((CompositeComponent)component).resolveComponentByID(adviceTargetID, hits);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    public Location getOwnLocation() {
        return this.ownLocation;
    }

    public void setOwnLocation(Location endLocation) {
        this.ownLocation = endLocation;
    }

    public void addBean(Object obj) {
    }

    public void addComponent(WorkflowComponent component) {
        this.components.add(component);
        component.setContainer(this);
    }

    public void addCartridge(Workflow cartridge) {
        this.components.add(cartridge);
        cartridge.setContainer(this);
    }

    public void addIf(IfComponent comp) {
        this.addComponent(comp);
    }

    public void addFeature(FeatureComponent comp) {
        this.addComponent(comp);
    }

    @Override
    public CompositeComponent getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(CompositeComponent container) {
        this.container = container;
    }

    public void put(WorkflowComponent comp) {
        this.addComponent(comp);
    }

    @Override
    public String getComponentName() {
        return COMPONENT_NAME;
    }
}

