/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.ast.util;

import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openarchitectureware.workflow.ast.AbstractASTBase;
import org.openarchitectureware.workflow.ast.ComponentAST;
import org.openarchitectureware.workflow.ast.DeclaredPropertyAST;
import org.openarchitectureware.workflow.ast.DeclaredPropertyFileAST;
import org.openarchitectureware.workflow.ast.InclusionAST;
import org.openarchitectureware.workflow.ast.ReferenceAST;
import org.openarchitectureware.workflow.ast.SimpleParamAST;
import org.openarchitectureware.workflow.ast.parser.WorkflowParser;
import org.openarchitectureware.workflow.ast.util.VisitorBase;
import org.openarchitectureware.workflow.issues.Issues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisitorInitializer
extends VisitorBase {
    private Set<String> declaredPropertyNames = new HashSet<String>();
    private Issues issues = null;
    private Map<String, ComponentAST> beans = null;
    private Map<String, String> props = null;
    private Map<String, String> initialProps = null;
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{([\\w_\\.-]+)\\}");
    private static final Pattern[] PROPERTY_WARN_PATTERN = new Pattern[]{Pattern.compile("\\$\\(([\\w_\\.-]+)\\)")};
    private final Stack<String> currentProp = new Stack();

    private VisitorInitializer cloneThis() {
        VisitorInitializer newOne = new VisitorInitializer(this.issues, this.props, this.beans);
        newOne.beans = this.beans;
        newOne.initialProps = this.initialProps;
        newOne.props = this.props;
        newOne.declaredPropertyNames = this.declaredPropertyNames;
        return newOne;
    }

    public VisitorInitializer(Issues issues, Map<String, String> initialProperties, Map<String, ComponentAST> initialBeans) {
        this.issues = issues;
        this.initialProps = new HashMap<String, String>(initialProperties);
        this.props = new HashMap<String, String>();
        this.beans = new HashMap<String, ComponentAST>(initialBeans);
    }

    private void traverseChildren(ComponentAST c) {
        for (AbstractASTBase element : c.getChildren()) {
            element.accept(this.cloneThis());
        }
    }

    @Override
    public Object visitComponentAST(ComponentAST comp) {
        comp.setClazz(this.replaceProperties(comp.getClazz(), comp));
        this.handleIdentifiedAST(comp);
        this.traverseChildren(comp);
        return comp;
    }

    private void handleIdentifiedAST(ComponentAST comp) {
        if (comp.getId() != null) {
            comp.setId(this.replaceProperties(comp.getId(), comp));
            this.beans.put(comp.getId(), comp);
        }
    }

    @Override
    public Object visitInclusionAST(InclusionAST comp) {
        AbstractASTBase ref;
        comp.setFile(this.replaceProperties(comp.getFile(), comp));
        this.handleIdentifiedAST(comp);
        this.traverseChildren(comp);
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, ComponentAST> paramBeans = new HashMap<String, ComponentAST>();
        if (comp.isInheritAll()) {
            params.putAll(this.initialProps);
            params.putAll(this.props);
            paramBeans.putAll(this.beans);
        }
        for (AbstractASTBase o : comp.getChildren()) {
            AbstractASTBase p;
            if (o instanceof SimpleParamAST) {
                p = (SimpleParamAST)o;
                params.put(((SimpleParamAST)p).getName(), ((SimpleParamAST)p).getValue());
                continue;
            }
            if (o instanceof ComponentAST) {
                p = (ComponentAST)o;
                paramBeans.put(((ComponentAST)p).getName(), (ComponentAST)p);
                continue;
            }
            if (!(o instanceof ReferenceAST)) continue;
            ref = (ReferenceAST)o;
            paramBeans.put(((ReferenceAST)ref).getName(), ((ReferenceAST)ref).getReference());
        }
        comp.setPassedBeans(paramBeans);
        comp.setPassedProperties(params);
        if (comp.getFile() != null) {
            WorkflowParser p = new WorkflowParser();
            InputStream in = this.loader.getResourceAsStream(this.translateFileURI(comp.getFile()));
            if (in == null) {
                this.issues.addError("Couldn't load workflow fragment from " + comp.getFile(), comp);
                return comp;
            }
            ref = p.parse(in, comp.getFile(), this.issues);
            comp.setImportedElement(ref);
            if (ref == null) {
                this.issues.addError("Couldn't parse nested workflow file " + comp.getFile(), comp);
                return comp;
            }
            if (comp.getPassedProperties() == null) {
                this.issues.addError("Workflow not initialized! (passedProperties is null)", comp);
                return comp;
            }
            VisitorInitializer vis = new VisitorInitializer(this.issues, comp.getPassedProperties(), comp.getPassedBeans());
            ref.accept(vis);
        }
        return comp;
    }

    private String translateFileURI(String file) {
        if (file.indexOf("::") != -1) {
            file = file.replaceAll("::", "/");
        }
        if (!file.endsWith(".oaw")) {
            file = String.valueOf(file) + ".oaw";
        }
        return file;
    }

    @Override
    public Object visitReferenceAST(ReferenceAST comp) {
        comp.setIdRef(this.replaceProperties(comp.getIdRef(), comp));
        ComponentAST ref = this.beans.get(comp.getIdRef());
        if (ref == null) {
            this.issues.addError("Couldn't find bean with id '" + comp.getIdRef() + "'", comp);
        } else {
            comp.setReference(ref);
        }
        return comp;
    }

    @Override
    public Object visitSimpleParamAST(SimpleParamAST param) {
        param.setValue(this.replaceProperties(param.getValue(), param));
        return param;
    }

    @Override
    public Object visitDeclaredPropertyAST(DeclaredPropertyAST prop) {
        if (prop.getValue() != null) {
            String n = this.replaceProperties(prop.getName(), prop);
            if (!this.initialProps.containsKey(n)) {
                this.props.put(n, this.replaceProperties(prop.getValue(), prop));
            } else if (!this.declaredPropertyNames.add(n)) {
                this.issues.addError("Duplicate property " + n, prop);
            }
        }
        return this.props;
    }

    @Override
    public Object visitDeclaredPropertyFileAST(DeclaredPropertyFileAST propFile) {
        propFile.setFile(this.replaceProperties(propFile.getFile(), propFile));
        Properties properties = propFile.getProperties(this.loader);
        if (properties == null) {
            this.issues.addError("Couldn't resolve properties file!", propFile);
            return new HashMap();
        }
        Iterator<String> iter = propFile.getPropertyNames(this.loader).iterator();
        while (iter.hasNext()) {
            String name = this.replaceProperties(iter.next(), propFile);
            String val = this.replaceProperties((String)properties.get(name), propFile);
            if (!this.initialProps.containsKey(name)) {
                this.props.put(name, val);
                continue;
            }
            if (this.declaredPropertyNames.add(name)) continue;
            this.issues.addError("Duplicate property " + name, propFile);
        }
        return this.props;
    }

    protected String replaceProperties(String toResolve, AbstractASTBase ast) {
        return this.replaceProperties(toResolve, true, ast);
    }

    protected String replaceProperties(String toResolve, boolean logIssues, AbstractASTBase ast) {
        if (toResolve == null) {
            return null;
        }
        this.currentProp.push(toResolve);
        if (logIssues) {
            Pattern[] patternArray = PROPERTY_WARN_PATTERN;
            int n = PROPERTY_WARN_PATTERN.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern p = patternArray[n2];
                Matcher m = p.matcher(toResolve);
                while (m.find()) {
                    this.issues.addWarning("The expression \"" + m.group(0) + "\" is not a valid property and therefore not resolved." + " Properties need to be enclosed in curly brackets, like: ${myProperty}");
                }
                ++n2;
            }
        }
        Matcher m = PROPERTY_PATTERN.matcher(toResolve);
        StringBuffer buff = new StringBuffer();
        int index = 0;
        while (m.find()) {
            String varName = m.group(1);
            String propValue = this.propGet(varName);
            if (propValue == null) {
                if (logIssues) {
                    this.issues.addError("property " + varName + " not specified. Dereferenced at " + ast.getLocation().toString());
                }
                return null;
            }
            propValue = this.replaceProperties(propValue, logIssues, ast);
            int start = m.start();
            int end = m.end();
            buff.append(toResolve.substring(index, start));
            buff.append(propValue);
            index = end;
        }
        buff.append(toResolve.substring(index));
        return buff.toString();
    }

    private String propGet(String varName) {
        String val = this.initialProps.get(varName);
        if (val != null) {
            return val;
        }
        return this.props.get(varName);
    }
}

