/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.debug.processing.handlers;

import java.io.IOException;
import java.util.Stack;
import org.openarchitectureware.debug.communication.Connection;
import org.openarchitectureware.debug.communication.packets.ConfirmationPacket;
import org.openarchitectureware.debug.communication.packets.EventPacket;
import org.openarchitectureware.debug.communication.packets.EventPacketWithFrames;
import org.openarchitectureware.debug.model.SyntaxElementTO;
import org.openarchitectureware.debug.processing.DebugMonitor;
import org.openarchitectureware.debug.processing.IElementAdapter;
import org.openarchitectureware.debug.processing.IEventHandler;
import org.openarchitectureware.debug.processing.IRuntimeHandler;

public class EventRuntimeHandler
implements IRuntimeHandler,
IEventHandler {
    public static final int STARTED = 1;
    public static final int SUSPENDED = 2;
    public static final int RESUMED = 3;
    public static final int TERMINATED = 4;
    private Connection connection;
    private DebugMonitor monitor;
    private Stack<Frame> stackFrames = new Stack();
    private int cleanStackLevel = 0;

    public void init(DebugMonitor monitor, Connection connection) {
        this.monitor = monitor;
        this.connection = connection;
        monitor.addEventHandler(this);
    }

    public void startListener() {
    }

    public void started() throws IOException {
        this.sendEvent(1);
    }

    public void preTask(Object element, Object context, int state) {
        this.stackFrames.push(new Frame(element, context, state));
    }

    public void postTask(Object context) {
        if (this.cleanStackLevel >= this.stackFrames.size()) {
            --this.cleanStackLevel;
        }
        this.stackFrames.pop();
    }

    public void suspended() throws IOException {
        EventPacketWithFrames event = new EventPacketWithFrames(2);
        event.cleanStackLevel = this.cleanStackLevel;
        int i = this.cleanStackLevel;
        while (i < this.stackFrames.size()) {
            Frame frame = (Frame)this.stackFrames.get(i);
            IElementAdapter adapter = this.monitor.getAdapter(frame.element);
            adapter.setContext(frame.context);
            SyntaxElementTO to = frame.state == 1 ? adapter.createElementTO(frame.element) : adapter.createEndElementTO(frame.element);
            to.type = adapter.getAdapterType();
            to.frameId = i++;
            event.frames.add(to);
        }
        this.sendAndConfirm(event);
        this.cleanStackLevel = this.stackFrames.size();
    }

    public void resumed() throws IOException {
        this.sendEvent(3);
    }

    public void terminated() throws IOException {
        this.sendEvent(4);
    }

    private void sendEvent(int type) throws IOException {
        EventPacket event = new EventPacket(type);
        this.sendAndConfirm(event);
    }

    private void sendAndConfirm(EventPacket event) throws IOException {
        int refId = this.connection.sendPacket(event);
        this.connection.listenForPacket(ConfirmationPacket.class, refId);
    }

    private class Frame {
        final Object element;
        final int state;
        final Object context;

        private Frame(Object element, Object context, int state) {
            this.element = element;
            this.context = context;
            this.state = state;
        }
    }
}

