/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.debug.communication.packets;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openarchitectureware.debug.communication.packets.AbstractPacket;

public class RegisterPacket
extends AbstractPacket {
    public static final int HANDLERS = 1;
    public static final int ADAPTERS = 2;
    public int type;
    public List<String> classNames = new ArrayList<String>();

    public void readContent(DataInputStream in) throws IOException {
        this.type = in.readInt();
        int noOfHandlers = in.readInt();
        int i = 0;
        while (i < noOfHandlers) {
            this.classNames.add(in.readUTF());
            ++i;
        }
    }

    public void writeContent(DataOutputStream out) throws IOException {
        out.writeInt(this.type);
        out.writeInt(this.classNames.size());
        for (String name : this.classNames) {
            out.writeUTF(name);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " type=" + this.type + " " + this.classNames;
    }
}

