/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.debug.communication.packets;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openarchitectureware.debug.communication.packets.EventPacket;
import org.openarchitectureware.debug.model.SyntaxElementTO;

public class EventPacketWithFrames
extends EventPacket {
    public int cleanStackLevel;
    public List<SyntaxElementTO> frames = new ArrayList<SyntaxElementTO>();

    public EventPacketWithFrames(int event) {
        super(event);
    }

    public void readContent(DataInputStream in) throws IOException {
        super.readContent(in);
        this.cleanStackLevel = in.readInt();
        int noOfFrames = in.readInt();
        int i = 0;
        while (i < noOfFrames) {
            SyntaxElementTO frame = new SyntaxElementTO();
            frame.readContent(in);
            this.frames.add(frame);
            ++i;
        }
    }

    public void writeContent(DataOutputStream out) throws IOException {
        super.writeContent(out);
        out.writeInt(this.cleanStackLevel);
        out.writeInt(this.frames.size());
        for (SyntaxElementTO frame : this.frames) {
            frame.writeContent(out);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(String.valueOf(super.toString()) + " ");
        sb.append(" clean=" + this.cleanStackLevel);
        sb.append(" " + this.frames.size() + " frames");
        return sb.toString();
    }
}

