/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.debug.communication;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.ServerSocket;
import java.net.Socket;
import org.openarchitectureware.debug.communication.PacketReceiver;
import org.openarchitectureware.debug.communication.PacketSender;
import org.openarchitectureware.debug.communication.packets.AbstractPacket;
import org.openarchitectureware.debug.communication.packets.HandshakePacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connection {
    private ServerSocket ssocket;
    private Socket socket;
    private DataOutputStream out;
    private DataInputStream in;
    private PacketSender sender;
    private PacketReceiver receiver;

    public AbstractPacket listenForPacket(Class<? extends AbstractPacket> type) throws InterruptedIOException {
        return this.receiver.getPacket(type, -1L);
    }

    public AbstractPacket listenForPacket(Class<? extends AbstractPacket> type, int refId) throws InterruptedIOException {
        return this.receiver.getPacket(type, refId, -1L);
    }

    public int sendPacket(AbstractPacket packet) throws IOException {
        if (this.sender == null) {
            return -1;
        }
        return this.sender.sendPacket(packet);
    }

    public void startListeningSocket(int port) throws IOException {
        this.ssocket = new ServerSocket(port);
    }

    public void accept(int timeout) throws IOException {
        this.ssocket.setSoTimeout(timeout);
        this.socket = this.ssocket.accept();
        this.establishReaderAndWriter();
        if (!this.writeHandshake()) {
            throw new IOException("handshake failed");
        }
    }

    public void connect(int port) throws IOException {
        this.socket = new Socket("localhost", port);
        this.establishReaderAndWriter();
        this.replyHandshake();
    }

    public boolean isConnected() {
        return this.socket != null && !this.socket.isClosed();
    }

    public synchronized void close() {
        block19: {
            block17: {
                if (this.sender != null) {
                    try {
                        try {
                            this.sender.close();
                        }
                        catch (Exception exception) {
                            this.sender = null;
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        this.sender = null;
                        throw throwable;
                    }
                    this.sender = null;
                }
            }
            if (this.socket != null) {
                try {
                    try {
                        this.out.close();
                        this.in.close();
                        this.socket.close();
                    }
                    catch (Exception exception) {
                        this.out = null;
                        this.in = null;
                        this.socket = null;
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    this.out = null;
                    this.in = null;
                    this.socket = null;
                    throw throwable;
                }
                this.out = null;
                this.in = null;
                this.socket = null;
            }
        }
        if (this.ssocket != null) {
            try {
                try {
                    this.ssocket.close();
                }
                catch (Exception exception) {
                    this.ssocket = null;
                }
            }
            finally {
                this.ssocket = null;
            }
        }
    }

    protected AbstractPacket readPacket() throws IOException {
        String className = this.in.readUTF();
        AbstractPacket packet = this.instantiatePacket(className);
        packet.readContent(this.in);
        return packet;
    }

    private AbstractPacket instantiatePacket(String className) throws IOException {
        Class<?> packetClass = null;
        AbstractPacket packet = null;
        String msg = null;
        try {
            packetClass = Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            msg = "Couldn't find " + className + " in the classpath.";
        }
        if (msg == null) {
            Constructor<?> c = packetClass.getConstructors()[0];
            Class<?>[] parmTypes = c.getParameterTypes();
            Object[] initargs = new Object[parmTypes.length];
            int i = 0;
            while (i < parmTypes.length) {
                if (parmTypes[i] == Integer.TYPE) {
                    initargs[i] = 0;
                }
                ++i;
            }
            try {
                packet = (AbstractPacket)c.newInstance(initargs);
            }
            catch (IllegalArgumentException e) {
                msg = "Couldn't instantiate " + c + " : " + e;
            }
            catch (InstantiationException e) {
                msg = "Couldn't instantiate " + c + " : " + e;
            }
            catch (IllegalAccessException e) {
                msg = "Couldn't instantiate " + c + " : " + e;
            }
            catch (InvocationTargetException e) {
                msg = "Problem during instantiation of " + c + " : " + e.getTargetException();
            }
        }
        if (msg != null) {
            System.err.println(msg);
            throw new IOException(msg);
        }
        return packet;
    }

    protected void writePacket(AbstractPacket packet) throws IOException {
        this.out.writeUTF(packet.getClass().getName());
        packet.writeContent(this.out);
    }

    private void establishReaderAndWriter() throws IOException {
        this.out = new DataOutputStream(this.socket.getOutputStream());
        this.in = new DataInputStream(this.socket.getInputStream());
        this.receiver = PacketReceiver.newPacketReceiver(this);
        this.sender = PacketSender.newPacketSender(this);
    }

    private boolean writeHandshake() throws IOException {
        HandshakePacket packet = new HandshakePacket();
        this.sendPacket(packet);
        return this.listenForPacket(HandshakePacket.class).getClass().equals(HandshakePacket.class);
    }

    private void replyHandshake() throws IOException {
        if (!this.listenForPacket(HandshakePacket.class).getClass().equals(HandshakePacket.class)) {
            throw new IOException("handshake failed");
        }
        this.sendPacket(new HandshakePacket());
    }
}

