# ./pyxb/bundles/opengis/raw/_nsgroup.py
# PyXB bindings for NamespaceGroupModule
# NGM:31dc9d33ae09dae9cd9938ac948b7eee03f73812
# Incorporated namespaces:
#  http://www.isotc211.org/2005/gss gss
#  http://www.isotc211.org/2005/gco gco
#  http://www.isotc211.org/2005/gts gts
#  http://www.isotc211.org/2005/gmd gmd
#  http://www.opengis.net/gml/3.2 gml
#  http://www.isotc211.org/2005/gsr gsr

import pyxb
import pyxb.binding
import pyxb.utils.utility

# Unique identifier for bindings created at the same time
_GenerationUID = pyxb.utils.utility.UniqueIdentifier('urn:uuid:8b000326-6c12-11df-aa11-001636553c48')

# Import bindings for schemas in group
import pyxb.binding.datatypes
import pyxb.bundles.opengis.misc.xlinks

_Namespace_gml = pyxb.namespace.NamespaceForURI(u'http://www.opengis.net/gml/3.2', create_if_missing=True)
_Namespace_gml.configureCategories(['typeBinding', 'elementBinding'])
_Namespace_gco = pyxb.namespace.NamespaceForURI(u'http://www.isotc211.org/2005/gco', create_if_missing=True)
_Namespace_gco.configureCategories(['typeBinding', 'elementBinding'])
_Namespace_gmd = pyxb.namespace.NamespaceForURI(u'http://www.isotc211.org/2005/gmd', create_if_missing=True)
_Namespace_gmd.configureCategories(['typeBinding', 'elementBinding'])
_Namespace_xlink = pyxb.namespace.NamespaceForURI(u'http://www.w3.org/1999/xlink', create_if_missing=True)
_Namespace_xlink.configureCategories(['typeBinding', 'elementBinding'])
_Namespace_gts = pyxb.namespace.NamespaceForURI(u'http://www.isotc211.org/2005/gts', create_if_missing=True)
_Namespace_gts.configureCategories(['typeBinding', 'elementBinding'])
_Namespace_gss = pyxb.namespace.NamespaceForURI(u'http://www.isotc211.org/2005/gss', create_if_missing=True)
_Namespace_gss.configureCategories(['typeBinding', 'elementBinding'])
_Namespace_gsr = pyxb.namespace.NamespaceForURI(u'http://www.isotc211.org/2005/gsr', create_if_missing=True)
_Namespace_gsr.configureCategories(['typeBinding', 'elementBinding'])

# Atomic SimpleTypeDefinition
class STD_ANON (pyxb.binding.datatypes.string):

    """An atomic simple type."""

    _ExpandedName = None
    _Documentation = None
STD_ANON._CF_pattern = pyxb.binding.facets.CF_pattern()
STD_ANON._CF_pattern.addPattern(pattern=u'other:\\w{2,}')
STD_ANON._InitializeFacetMap(STD_ANON._CF_pattern)

# Atomic SimpleTypeDefinition
class STD_ANON_ (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = None
    _Documentation = None
STD_ANON_._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=STD_ANON_, enum_prefix=None)
STD_ANON_.inapplicable = STD_ANON_._CF_enumeration.addEnumeration(unicode_value=u'inapplicable')
STD_ANON_.missing = STD_ANON_._CF_enumeration.addEnumeration(unicode_value=u'missing')
STD_ANON_.template = STD_ANON_._CF_enumeration.addEnumeration(unicode_value=u'template')
STD_ANON_.unknown = STD_ANON_._CF_enumeration.addEnumeration(unicode_value=u'unknown')
STD_ANON_.withheld = STD_ANON_._CF_enumeration.addEnumeration(unicode_value=u'withheld')
STD_ANON_._InitializeFacetMap(STD_ANON_._CF_enumeration)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class NilReasonType (pyxb.binding.basis.STD_union):

    """gml:NilReasonType defines a content model that allows recording of an explanation for a void value or other exception.
gml:NilReasonType is a union of the following enumerated values:
-	inapplicable there is no value
-	missing the correct value is not readily available to the sender of this data. Furthermore, a correct value may not exist
-	template the value will be available later
-	unknown the correct value is not known to, and not computable by, the sender of this data. However, a correct value probably exists
-	withheld the value is not divulged
-	other:text other brief explanation, where text is a string of two or more characters with no included spaces
and
-	anyURI which should refer to a resource which describes the reason for the exception
A particular community may choose to assign more detailed semantics to the standard values provided. Alternatively, the URI method enables a specific or more complete explanation for the absence of a value to be provided elsewhere and indicated by-reference in an instance document.
gml:NilReasonType is used as a member of a union in a number of simple content types where it is necessary to permit a value from the NilReasonType union as an alternative to the primary type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'NilReasonType')
    _Documentation = u'gml:NilReasonType defines a content model that allows recording of an explanation for a void value or other exception.\ngml:NilReasonType is a union of the following enumerated values:\n-\tinapplicable there is no value\n-\tmissing the correct value is not readily available to the sender of this data. Furthermore, a correct value may not exist\n-\ttemplate the value will be available later\n-\tunknown the correct value is not known to, and not computable by, the sender of this data. However, a correct value probably exists\n-\twithheld the value is not divulged\n-\tother:text other brief explanation, where text is a string of two or more characters with no included spaces\nand\n-\tanyURI which should refer to a resource which describes the reason for the exception\nA particular community may choose to assign more detailed semantics to the standard values provided. Alternatively, the URI method enables a specific or more complete explanation for the absence of a value to be provided elsewhere and indicated by-reference in an instance document.\ngml:NilReasonType is used as a member of a union in a number of simple content types where it is necessary to permit a value from the NilReasonType union as an alternative to the primary type.'

    _MemberTypes = ( STD_ANON_, STD_ANON, pyxb.binding.datatypes.anyURI, )
NilReasonType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=NilReasonType)
NilReasonType._CF_pattern = pyxb.binding.facets.CF_pattern()
NilReasonType.inapplicable = u'inapplicable'      # originally STD_ANON_.inapplicable
NilReasonType.missing = u'missing'                # originally STD_ANON_.missing
NilReasonType.template = u'template'              # originally STD_ANON_.template
NilReasonType.unknown = u'unknown'                # originally STD_ANON_.unknown
NilReasonType.withheld = u'withheld'              # originally STD_ANON_.withheld
NilReasonType._InitializeFacetMap(NilReasonType._CF_enumeration,
   NilReasonType._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'NilReasonType', NilReasonType)

# Atomic SimpleTypeDefinition
class SignType (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """gml:SignType is a convenience type with values "+" (plus) and "-" (minus)."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SignType')
    _Documentation = u'gml:SignType is a convenience type with values "+" (plus) and "-" (minus).'
SignType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=SignType, enum_prefix=None)
SignType.emptyString = SignType._CF_enumeration.addEnumeration(unicode_value=u'-')
SignType.emptyString_ = SignType._CF_enumeration.addEnumeration(unicode_value=u'+')
SignType._InitializeFacetMap(SignType._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'SignType', SignType)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class NCNameList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'NCNameList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = pyxb.binding.datatypes.NCName
NCNameList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'NCNameList', NCNameList)

# Atomic SimpleTypeDefinition
class AggregationType (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AggregationType')
    _Documentation = None
AggregationType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=AggregationType, enum_prefix=None)
AggregationType.set = AggregationType._CF_enumeration.addEnumeration(unicode_value=u'set')
AggregationType.bag = AggregationType._CF_enumeration.addEnumeration(unicode_value=u'bag')
AggregationType.sequence = AggregationType._CF_enumeration.addEnumeration(unicode_value=u'sequence')
AggregationType.array = AggregationType._CF_enumeration.addEnumeration(unicode_value=u'array')
AggregationType.record = AggregationType._CF_enumeration.addEnumeration(unicode_value=u'record')
AggregationType.table = AggregationType._CF_enumeration.addEnumeration(unicode_value=u'table')
AggregationType._InitializeFacetMap(AggregationType._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'AggregationType', AggregationType)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class doubleList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'doubleList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = pyxb.binding.datatypes.double
doubleList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'doubleList', doubleList)

# Atomic SimpleTypeDefinition
class STD_ANON_2 (pyxb.binding.datatypes.string):

    """An atomic simple type."""

    _ExpandedName = None
    _Documentation = None
STD_ANON_2._CF_pattern = pyxb.binding.facets.CF_pattern()
STD_ANON_2._CF_pattern.addPattern(pattern=u'other:\\w{2,}')
STD_ANON_2._InitializeFacetMap(STD_ANON_2._CF_pattern)

# Atomic SimpleTypeDefinition
class STD_ANON_3 (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = None
    _Documentation = None
STD_ANON_3._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=STD_ANON_3, enum_prefix=None)
STD_ANON_3.year = STD_ANON_3._CF_enumeration.addEnumeration(unicode_value=u'year')
STD_ANON_3.month = STD_ANON_3._CF_enumeration.addEnumeration(unicode_value=u'month')
STD_ANON_3.day = STD_ANON_3._CF_enumeration.addEnumeration(unicode_value=u'day')
STD_ANON_3.hour = STD_ANON_3._CF_enumeration.addEnumeration(unicode_value=u'hour')
STD_ANON_3.minute = STD_ANON_3._CF_enumeration.addEnumeration(unicode_value=u'minute')
STD_ANON_3.second = STD_ANON_3._CF_enumeration.addEnumeration(unicode_value=u'second')
STD_ANON_3._InitializeFacetMap(STD_ANON_3._CF_enumeration)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class TimeUnitType (pyxb.binding.basis.STD_union):

    """Simple type that is a union of STD_ANON_3, STD_ANON_2."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeUnitType')
    _Documentation = None

    _MemberTypes = ( STD_ANON_3, STD_ANON_2, )
TimeUnitType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=TimeUnitType)
TimeUnitType._CF_pattern = pyxb.binding.facets.CF_pattern()
TimeUnitType.year = u'year'                       # originally STD_ANON_3.year
TimeUnitType.month = u'month'                     # originally STD_ANON_3.month
TimeUnitType.day = u'day'                         # originally STD_ANON_3.day
TimeUnitType.hour = u'hour'                       # originally STD_ANON_3.hour
TimeUnitType.minute = u'minute'                   # originally STD_ANON_3.minute
TimeUnitType.second = u'second'                   # originally STD_ANON_3.second
TimeUnitType._InitializeFacetMap(TimeUnitType._CF_enumeration,
   TimeUnitType._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'TimeUnitType', TimeUnitType)

# Atomic SimpleTypeDefinition
class UomURI (pyxb.binding.datatypes.anyURI):

    """This type specifies a URI, restricted such that it must start with one of the following sequences: "#", "./", "../", or a string of characters followed by a ":". These patterns ensure that the most common URI forms are supported, including absolute and relative URIs and URIs that are simple fragment identifiers, but prohibits certain forms of relative URI that could be mistaken for unit of measure symbol . 
NOTE	It is possible to re-write such a relative URI to conform to the restriction (e.g. "./m/s").
In an instance document, on elements of type gml:MeasureType the mandatory uom attribute shall carry a value corresponding to either 
-	a conventional unit of measure symbol,
-	a link to a definition of a unit of measure that does not have a conventional symbol, or when it is desired to indicate a precise or variant definition."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'UomURI')
    _Documentation = u'This type specifies a URI, restricted such that it must start with one of the following sequences: "#", "./", "../", or a string of characters followed by a ":". These patterns ensure that the most common URI forms are supported, including absolute and relative URIs and URIs that are simple fragment identifiers, but prohibits certain forms of relative URI that could be mistaken for unit of measure symbol . \nNOTE\tIt is possible to re-write such a relative URI to conform to the restriction (e.g. "./m/s").\nIn an instance document, on elements of type gml:MeasureType the mandatory uom attribute shall carry a value corresponding to either \n-\ta conventional unit of measure symbol,\n-\ta link to a definition of a unit of measure that does not have a conventional symbol, or when it is desired to indicate a precise or variant definition.'
UomURI._CF_pattern = pyxb.binding.facets.CF_pattern()
UomURI._CF_pattern.addPattern(pattern=u'([a-zA-Z][a-zA-Z0-9\\-\\+\\.]*:|\\.\\./|\\./|#).*')
UomURI._InitializeFacetMap(UomURI._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'UomURI', UomURI)

# Atomic SimpleTypeDefinition
class UomSymbol (pyxb.binding.datatypes.string):

    """This type specifies a character string of length at least one, and restricted such that it must not contain any of the following characters: ":" (colon), " " (space), (newline), (carriage return), (tab). This allows values corresponding to familiar abbreviations, such as "kg", "m/s", etc. 
It is recommended that the symbol be an identifier for a unit of measure as specified in the "Unified Code of Units of Measure" (UCUM) (http://aurora.regenstrief.org/UCUM). This provides a set of symbols and a grammar for constructing identifiers for units of measure that are unique, and may be easily entered with a keyboard supporting the limited character set known as 7-bit ASCII. ISO 2955 formerly provided a specification with this scope, but was withdrawn in 2001. UCUM largely follows ISO 2955 with modifications to remove ambiguities and other problems."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'UomSymbol')
    _Documentation = u'This type specifies a character string of length at least one, and restricted such that it must not contain any of the following characters: ":" (colon), " " (space), (newline), (carriage return), (tab). This allows values corresponding to familiar abbreviations, such as "kg", "m/s", etc. \nIt is recommended that the symbol be an identifier for a unit of measure as specified in the "Unified Code of Units of Measure" (UCUM) (http://aurora.regenstrief.org/UCUM). This provides a set of symbols and a grammar for constructing identifiers for units of measure that are unique, and may be easily entered with a keyboard supporting the limited character set known as 7-bit ASCII. ISO 2955 formerly provided a specification with this scope, but was withdrawn in 2001. UCUM largely follows ISO 2955 with modifications to remove ambiguities and other problems.'
UomSymbol._CF_pattern = pyxb.binding.facets.CF_pattern()
UomSymbol._CF_pattern.addPattern(pattern=u'[^: \\n\\r\\t]+')
UomSymbol._InitializeFacetMap(UomSymbol._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'UomSymbol', UomSymbol)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class UomIdentifier (pyxb.binding.basis.STD_union):

    """The simple type gml:UomIdentifer defines the syntax and value space of the unit of measure identifier."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'UomIdentifier')
    _Documentation = u'The simple type gml:UomIdentifer defines the syntax and value space of the unit of measure identifier.'

    _MemberTypes = ( UomSymbol, UomURI, )
UomIdentifier._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=UomIdentifier)
UomIdentifier._CF_pattern = pyxb.binding.facets.CF_pattern()
UomIdentifier._InitializeFacetMap(UomIdentifier._CF_enumeration,
   UomIdentifier._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'UomIdentifier', UomIdentifier)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class doubleOrNilReason (pyxb.binding.basis.STD_union):

    """Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'doubleOrNilReason')
    _Documentation = u'Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value.'

    _MemberTypes = ( STD_ANON_, STD_ANON, pyxb.binding.datatypes.double, pyxb.binding.datatypes.anyURI, )
doubleOrNilReason._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=doubleOrNilReason)
doubleOrNilReason._CF_pattern = pyxb.binding.facets.CF_pattern()
doubleOrNilReason.inapplicable = u'inapplicable'  # originally STD_ANON_.inapplicable
doubleOrNilReason.missing = u'missing'            # originally STD_ANON_.missing
doubleOrNilReason.template = u'template'          # originally STD_ANON_.template
doubleOrNilReason.unknown = u'unknown'            # originally STD_ANON_.unknown
doubleOrNilReason.withheld = u'withheld'          # originally STD_ANON_.withheld
doubleOrNilReason._InitializeFacetMap(doubleOrNilReason._CF_enumeration,
   doubleOrNilReason._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'doubleOrNilReason', doubleOrNilReason)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class doubleOrNilReasonList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'doubleOrNilReasonList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = doubleOrNilReason
doubleOrNilReasonList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'doubleOrNilReasonList', doubleOrNilReasonList)

# Atomic SimpleTypeDefinition
class CurveInterpolationType (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """gml:CurveInterpolationType is a list of codes that may be used to identify the interpolation mechanisms specified by an application schema."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CurveInterpolationType')
    _Documentation = u'gml:CurveInterpolationType is a list of codes that may be used to identify the interpolation mechanisms specified by an application schema.'
CurveInterpolationType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=CurveInterpolationType, enum_prefix=None)
CurveInterpolationType.linear = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'linear')
CurveInterpolationType.geodesic = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'geodesic')
CurveInterpolationType.circularArc3Points = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'circularArc3Points')
CurveInterpolationType.circularArc2PointWithBulge = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'circularArc2PointWithBulge')
CurveInterpolationType.circularArcCenterPointWithRadius = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'circularArcCenterPointWithRadius')
CurveInterpolationType.elliptical = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'elliptical')
CurveInterpolationType.clothoid = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'clothoid')
CurveInterpolationType.conic = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'conic')
CurveInterpolationType.polynomialSpline = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'polynomialSpline')
CurveInterpolationType.cubicSpline = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'cubicSpline')
CurveInterpolationType.rationalSpline = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'rationalSpline')
CurveInterpolationType._InitializeFacetMap(CurveInterpolationType._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'CurveInterpolationType', CurveInterpolationType)

# List SimpleTypeDefinition
# superclasses doubleList
class STD_ANON_4 (pyxb.binding.basis.STD_list):

    """Simple type that is a list of pyxb.binding.datatypes.double."""

    _ExpandedName = None
    _Documentation = None

    _ItemType = pyxb.binding.datatypes.double
STD_ANON_4._InitializeFacetMap()

# Atomic SimpleTypeDefinition
class CompassPointEnumeration (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """These directions are necessarily approximate, giving direction with a precision of 22.5&#176;. It is thus generally unnecessary to specify the reference frame, though this may be detailed in the definition of a GML application language."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CompassPointEnumeration')
    _Documentation = u'These directions are necessarily approximate, giving direction with a precision of 22.5\xb0. It is thus generally unnecessary to specify the reference frame, though this may be detailed in the definition of a GML application language.'
CompassPointEnumeration._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=CompassPointEnumeration, enum_prefix=None)
CompassPointEnumeration.N = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'N')
CompassPointEnumeration.NNE = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'NNE')
CompassPointEnumeration.NE = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'NE')
CompassPointEnumeration.ENE = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'ENE')
CompassPointEnumeration.E = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'E')
CompassPointEnumeration.ESE = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'ESE')
CompassPointEnumeration.SE = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'SE')
CompassPointEnumeration.SSE = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'SSE')
CompassPointEnumeration.S = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'S')
CompassPointEnumeration.SSW = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'SSW')
CompassPointEnumeration.SW = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'SW')
CompassPointEnumeration.WSW = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'WSW')
CompassPointEnumeration.W = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'W')
CompassPointEnumeration.WNW = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'WNW')
CompassPointEnumeration.NW = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'NW')
CompassPointEnumeration.NNW = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'NNW')
CompassPointEnumeration._InitializeFacetMap(CompassPointEnumeration._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'CompassPointEnumeration', CompassPointEnumeration)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class Date_Type (pyxb.binding.basis.STD_union):

    """Simple type that is a union of pyxb.binding.datatypes.date, pyxb.binding.datatypes.gYearMonth, pyxb.binding.datatypes.gYear."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Date_Type')
    _Documentation = None

    _MemberTypes = ( pyxb.binding.datatypes.date, pyxb.binding.datatypes.gYearMonth, pyxb.binding.datatypes.gYear, )
Date_Type._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=Date_Type)
Date_Type._CF_pattern = pyxb.binding.facets.CF_pattern()
Date_Type._InitializeFacetMap(Date_Type._CF_enumeration,
   Date_Type._CF_pattern)
_Namespace_gco.addCategoryObject('typeBinding', u'Date_Type', Date_Type)

# Atomic SimpleTypeDefinition
class MD_PixelOrientationCode_Type (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_PixelOrientationCode_Type')
    _Documentation = None
MD_PixelOrientationCode_Type._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=MD_PixelOrientationCode_Type, enum_prefix=None)
MD_PixelOrientationCode_Type.center = MD_PixelOrientationCode_Type._CF_enumeration.addEnumeration(unicode_value=u'center')
MD_PixelOrientationCode_Type.lowerLeft = MD_PixelOrientationCode_Type._CF_enumeration.addEnumeration(unicode_value=u'lowerLeft')
MD_PixelOrientationCode_Type.lowerRight = MD_PixelOrientationCode_Type._CF_enumeration.addEnumeration(unicode_value=u'lowerRight')
MD_PixelOrientationCode_Type.upperRight = MD_PixelOrientationCode_Type._CF_enumeration.addEnumeration(unicode_value=u'upperRight')
MD_PixelOrientationCode_Type.upperLeft = MD_PixelOrientationCode_Type._CF_enumeration.addEnumeration(unicode_value=u'upperLeft')
MD_PixelOrientationCode_Type._InitializeFacetMap(MD_PixelOrientationCode_Type._CF_enumeration)
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_PixelOrientationCode_Type', MD_PixelOrientationCode_Type)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class NameList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'NameList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = pyxb.binding.datatypes.Name
NameList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'NameList', NameList)

# Atomic SimpleTypeDefinition
class KnotTypesType (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """This enumeration type specifies values for the knots' type (see ISO 19107:2003, 6.4.25)."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'KnotTypesType')
    _Documentation = u"This enumeration type specifies values for the knots' type (see ISO 19107:2003, 6.4.25)."
KnotTypesType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=KnotTypesType, enum_prefix=None)
KnotTypesType.uniform = KnotTypesType._CF_enumeration.addEnumeration(unicode_value=u'uniform')
KnotTypesType.quasiUniform = KnotTypesType._CF_enumeration.addEnumeration(unicode_value=u'quasiUniform')
KnotTypesType.piecewiseBezier = KnotTypesType._CF_enumeration.addEnumeration(unicode_value=u'piecewiseBezier')
KnotTypesType._InitializeFacetMap(KnotTypesType._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'KnotTypesType', KnotTypesType)

# Atomic SimpleTypeDefinition
class TimeIndeterminateValueType (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """These values are interpreted as follows: 
-	"unknown" indicates that no specific value for temporal position is provided.
-	"now" indicates that the specified value shall be replaced with the current temporal position whenever the value is accessed.
-	"before" indicates that the actual temporal position is unknown, but it is known to be before the specified value.
-	"after" indicates that the actual temporal position is unknown, but it is known to be after the specified value.
A value for indeterminatePosition may 
-	be used either alone, or 
-	qualify a specific value for temporal position."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeIndeterminateValueType')
    _Documentation = u'These values are interpreted as follows: \n-\t"unknown" indicates that no specific value for temporal position is provided.\n-\t"now" indicates that the specified value shall be replaced with the current temporal position whenever the value is accessed.\n-\t"before" indicates that the actual temporal position is unknown, but it is known to be before the specified value.\n-\t"after" indicates that the actual temporal position is unknown, but it is known to be after the specified value.\nA value for indeterminatePosition may \n-\tbe used either alone, or \n-\tqualify a specific value for temporal position.'
TimeIndeterminateValueType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=TimeIndeterminateValueType, enum_prefix=None)
TimeIndeterminateValueType.after = TimeIndeterminateValueType._CF_enumeration.addEnumeration(unicode_value=u'after')
TimeIndeterminateValueType.before = TimeIndeterminateValueType._CF_enumeration.addEnumeration(unicode_value=u'before')
TimeIndeterminateValueType.now = TimeIndeterminateValueType._CF_enumeration.addEnumeration(unicode_value=u'now')
TimeIndeterminateValueType.unknown = TimeIndeterminateValueType._CF_enumeration.addEnumeration(unicode_value=u'unknown')
TimeIndeterminateValueType._InitializeFacetMap(TimeIndeterminateValueType._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'TimeIndeterminateValueType', TimeIndeterminateValueType)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class TimePositionUnion (pyxb.binding.basis.STD_union):

    """The simple type gml:TimePositionUnion is a union of XML Schema simple types which instantiate the subtypes for temporal position described in ISO 19108.
 An ordinal era may be referenced via URI.  A decimal value may be used to indicate the distance from the scale origin .  time is used for a position that recurs daily (see ISO 19108:2002 5.4.4.2).
 Finally, calendar and clock forms that support the representation of time in systems based on years, months, days, hours, minutes and seconds, in a notation following ISO 8601, are assembled by gml:CalDate"""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimePositionUnion')
    _Documentation = u'The simple type gml:TimePositionUnion is a union of XML Schema simple types which instantiate the subtypes for temporal position described in ISO 19108.\n An ordinal era may be referenced via URI.  A decimal value may be used to indicate the distance from the scale origin .  time is used for a position that recurs daily (see ISO 19108:2002 5.4.4.2).\n Finally, calendar and clock forms that support the representation of time in systems based on years, months, days, hours, minutes and seconds, in a notation following ISO 8601, are assembled by gml:CalDate'

    _MemberTypes = ( pyxb.binding.datatypes.date, pyxb.binding.datatypes.gYearMonth, pyxb.binding.datatypes.gYear, pyxb.binding.datatypes.time, pyxb.binding.datatypes.dateTime, pyxb.binding.datatypes.anyURI, pyxb.binding.datatypes.decimal, )
TimePositionUnion._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=TimePositionUnion)
TimePositionUnion._CF_pattern = pyxb.binding.facets.CF_pattern()
TimePositionUnion._InitializeFacetMap(TimePositionUnion._CF_enumeration,
   TimePositionUnion._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'TimePositionUnion', TimePositionUnion)

# Atomic SimpleTypeDefinition
class STD_ANON_5 (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = None
    _Documentation = None
STD_ANON_5._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=STD_ANON_5, enum_prefix=None)
STD_ANON_5.N = STD_ANON_5._CF_enumeration.addEnumeration(unicode_value=u'N')
STD_ANON_5.E = STD_ANON_5._CF_enumeration.addEnumeration(unicode_value=u'E')
STD_ANON_5.S = STD_ANON_5._CF_enumeration.addEnumeration(unicode_value=u'S')
STD_ANON_5.W = STD_ANON_5._CF_enumeration.addEnumeration(unicode_value=u'W')
STD_ANON_5.emptyString = STD_ANON_5._CF_enumeration.addEnumeration(unicode_value=u'+')
STD_ANON_5.emptyString_ = STD_ANON_5._CF_enumeration.addEnumeration(unicode_value=u'-')
STD_ANON_5._InitializeFacetMap(STD_ANON_5._CF_enumeration)

# Atomic SimpleTypeDefinition
class DegreeValueType (pyxb.binding.datatypes.nonNegativeInteger):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DegreeValueType')
    _Documentation = ''
DegreeValueType._CF_maxInclusive = pyxb.binding.facets.CF_maxInclusive(value_datatype=DegreeValueType, value=pyxb.binding.datatypes.nonNegativeInteger(359L))
DegreeValueType._InitializeFacetMap(DegreeValueType._CF_maxInclusive)
_Namespace_gml.addCategoryObject('typeBinding', u'DegreeValueType', DegreeValueType)

# Atomic SimpleTypeDefinition
class ArcSecondsType (pyxb.binding.datatypes.decimal):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ArcSecondsType')
    _Documentation = ''
ArcSecondsType._CF_maxExclusive = pyxb.binding.facets.CF_maxExclusive(value_datatype=pyxb.binding.datatypes.decimal, value=pyxb.binding.datatypes.anySimpleType(u'60.00'))
ArcSecondsType._CF_minInclusive = pyxb.binding.facets.CF_minInclusive(value_datatype=ArcSecondsType, value=pyxb.binding.datatypes.decimal(0.0))
ArcSecondsType._InitializeFacetMap(ArcSecondsType._CF_maxExclusive,
   ArcSecondsType._CF_minInclusive)
_Namespace_gml.addCategoryObject('typeBinding', u'ArcSecondsType', ArcSecondsType)

# Atomic SimpleTypeDefinition
class ArcMinutesType (pyxb.binding.datatypes.nonNegativeInteger):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ArcMinutesType')
    _Documentation = ''
ArcMinutesType._CF_maxInclusive = pyxb.binding.facets.CF_maxInclusive(value_datatype=ArcMinutesType, value=pyxb.binding.datatypes.nonNegativeInteger(59L))
ArcMinutesType._InitializeFacetMap(ArcMinutesType._CF_maxInclusive)
_Namespace_gml.addCategoryObject('typeBinding', u'ArcMinutesType', ArcMinutesType)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class NameOrNilReason (pyxb.binding.basis.STD_union):

    """Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'NameOrNilReason')
    _Documentation = u'Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value.'

    _MemberTypes = ( STD_ANON_, STD_ANON, pyxb.binding.datatypes.Name, pyxb.binding.datatypes.anyURI, )
NameOrNilReason._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=NameOrNilReason)
NameOrNilReason._CF_pattern = pyxb.binding.facets.CF_pattern()
NameOrNilReason.inapplicable = u'inapplicable'    # originally STD_ANON_.inapplicable
NameOrNilReason.missing = u'missing'              # originally STD_ANON_.missing
NameOrNilReason.template = u'template'            # originally STD_ANON_.template
NameOrNilReason.unknown = u'unknown'              # originally STD_ANON_.unknown
NameOrNilReason.withheld = u'withheld'            # originally STD_ANON_.withheld
NameOrNilReason._InitializeFacetMap(NameOrNilReason._CF_enumeration,
   NameOrNilReason._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'NameOrNilReason', NameOrNilReason)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class NameOrNilReasonList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'NameOrNilReasonList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = NameOrNilReason
NameOrNilReasonList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'NameOrNilReasonList', NameOrNilReasonList)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class integerOrNilReason (pyxb.binding.basis.STD_union):

    """Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'integerOrNilReason')
    _Documentation = u'Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value.'

    _MemberTypes = ( STD_ANON_, STD_ANON, pyxb.binding.datatypes.integer, pyxb.binding.datatypes.anyURI, )
integerOrNilReason._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=integerOrNilReason)
integerOrNilReason._CF_pattern = pyxb.binding.facets.CF_pattern()
integerOrNilReason.inapplicable = u'inapplicable' # originally STD_ANON_.inapplicable
integerOrNilReason.missing = u'missing'           # originally STD_ANON_.missing
integerOrNilReason.template = u'template'         # originally STD_ANON_.template
integerOrNilReason.unknown = u'unknown'           # originally STD_ANON_.unknown
integerOrNilReason.withheld = u'withheld'         # originally STD_ANON_.withheld
integerOrNilReason._InitializeFacetMap(integerOrNilReason._CF_enumeration,
   integerOrNilReason._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'integerOrNilReason', integerOrNilReason)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class integerOrNilReasonList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'integerOrNilReasonList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = integerOrNilReason
integerOrNilReasonList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'integerOrNilReasonList', integerOrNilReasonList)

# Atomic SimpleTypeDefinition
class SuccessionType (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SuccessionType')
    _Documentation = ''
SuccessionType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=SuccessionType, enum_prefix=None)
SuccessionType.substitution = SuccessionType._CF_enumeration.addEnumeration(unicode_value=u'substitution')
SuccessionType.division = SuccessionType._CF_enumeration.addEnumeration(unicode_value=u'division')
SuccessionType.fusion = SuccessionType._CF_enumeration.addEnumeration(unicode_value=u'fusion')
SuccessionType.initiation = SuccessionType._CF_enumeration.addEnumeration(unicode_value=u'initiation')
SuccessionType._InitializeFacetMap(SuccessionType._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'SuccessionType', SuccessionType)

# Atomic SimpleTypeDefinition
class SurfaceInterpolationType (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """gml:SurfaceInterpolationType is a list of codes that may be used to identify the interpolation mechanisms specified by an application schema."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SurfaceInterpolationType')
    _Documentation = u'gml:SurfaceInterpolationType is a list of codes that may be used to identify the interpolation mechanisms specified by an application schema.'
SurfaceInterpolationType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=SurfaceInterpolationType, enum_prefix=None)
SurfaceInterpolationType.none = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'none')
SurfaceInterpolationType.planar = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'planar')
SurfaceInterpolationType.spherical = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'spherical')
SurfaceInterpolationType.elliptical = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'elliptical')
SurfaceInterpolationType.conic = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'conic')
SurfaceInterpolationType.tin = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'tin')
SurfaceInterpolationType.parametricCurve = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'parametricCurve')
SurfaceInterpolationType.polynomialSpline = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'polynomialSpline')
SurfaceInterpolationType.rationalSpline = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'rationalSpline')
SurfaceInterpolationType.triangulatedSpline = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'triangulatedSpline')
SurfaceInterpolationType._InitializeFacetMap(SurfaceInterpolationType._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'SurfaceInterpolationType', SurfaceInterpolationType)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class QNameList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'QNameList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = pyxb.binding.datatypes.QName
QNameList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'QNameList', QNameList)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class integerList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'integerList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = pyxb.binding.datatypes.integer
integerList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'integerList', integerList)

# List SimpleTypeDefinition
# superclasses integerOrNilReasonList
class CountExtentType (pyxb.binding.basis.STD_list):

    """Simple type that is a list of integerOrNilReason."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CountExtentType')
    _Documentation = None

    _ItemType = integerOrNilReason
CountExtentType._CF_length = pyxb.binding.facets.CF_length(value=pyxb.binding.datatypes.nonNegativeInteger(2L))
CountExtentType._InitializeFacetMap(CountExtentType._CF_length)
_Namespace_gml.addCategoryObject('typeBinding', u'CountExtentType', CountExtentType)

# Atomic SimpleTypeDefinition
class DecimalMinutesType (pyxb.binding.datatypes.decimal):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DecimalMinutesType')
    _Documentation = ''
DecimalMinutesType._CF_maxExclusive = pyxb.binding.facets.CF_maxExclusive(value_datatype=pyxb.binding.datatypes.decimal, value=pyxb.binding.datatypes.anySimpleType(u'60.00'))
DecimalMinutesType._CF_minInclusive = pyxb.binding.facets.CF_minInclusive(value_datatype=DecimalMinutesType, value=pyxb.binding.datatypes.decimal(0.0))
DecimalMinutesType._InitializeFacetMap(DecimalMinutesType._CF_maxExclusive,
   DecimalMinutesType._CF_minInclusive)
_Namespace_gml.addCategoryObject('typeBinding', u'DecimalMinutesType', DecimalMinutesType)

# Atomic SimpleTypeDefinition
class MD_ObligationCode_Type (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ObligationCode_Type')
    _Documentation = None
MD_ObligationCode_Type._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=MD_ObligationCode_Type, enum_prefix=None)
MD_ObligationCode_Type.mandatory = MD_ObligationCode_Type._CF_enumeration.addEnumeration(unicode_value=u'mandatory')
MD_ObligationCode_Type.optional = MD_ObligationCode_Type._CF_enumeration.addEnumeration(unicode_value=u'optional')
MD_ObligationCode_Type.conditional = MD_ObligationCode_Type._CF_enumeration.addEnumeration(unicode_value=u'conditional')
MD_ObligationCode_Type._InitializeFacetMap(MD_ObligationCode_Type._CF_enumeration)
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_ObligationCode_Type', MD_ObligationCode_Type)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class CalDate (pyxb.binding.basis.STD_union):

    """Simple type that is a union of pyxb.binding.datatypes.date, pyxb.binding.datatypes.gYearMonth, pyxb.binding.datatypes.gYear."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CalDate')
    _Documentation = None

    _MemberTypes = ( pyxb.binding.datatypes.date, pyxb.binding.datatypes.gYearMonth, pyxb.binding.datatypes.gYear, )
CalDate._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=CalDate)
CalDate._CF_pattern = pyxb.binding.facets.CF_pattern()
CalDate._InitializeFacetMap(CalDate._CF_enumeration,
   CalDate._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'CalDate', CalDate)

# Atomic SimpleTypeDefinition
class STD_ANON_6 (pyxb.binding.datatypes.string):

    """An atomic simple type."""

    _ExpandedName = None
    _Documentation = None
STD_ANON_6._InitializeFacetMap()

# Atomic SimpleTypeDefinition
class STD_ANON_7 (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = None
    _Documentation = None
STD_ANON_7._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=STD_ANON_7, enum_prefix=None)
STD_ANON_7.Before = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'Before')
STD_ANON_7.After = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'After')
STD_ANON_7.Begins = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'Begins')
STD_ANON_7.Ends = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'Ends')
STD_ANON_7.During = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'During')
STD_ANON_7.Equals = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'Equals')
STD_ANON_7.Contains = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'Contains')
STD_ANON_7.Overlaps = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'Overlaps')
STD_ANON_7.Meets = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'Meets')
STD_ANON_7.OverlappedBy = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'OverlappedBy')
STD_ANON_7.MetBy = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'MetBy')
STD_ANON_7.BegunBy = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'BegunBy')
STD_ANON_7.EndedBy = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'EndedBy')
STD_ANON_7._InitializeFacetMap(STD_ANON_7._CF_enumeration)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class NilReasonEnumeration (pyxb.binding.basis.STD_union):

    """Simple type that is a union of STD_ANON_, STD_ANON."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'NilReasonEnumeration')
    _Documentation = None

    _MemberTypes = ( STD_ANON_, STD_ANON, )
NilReasonEnumeration._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=NilReasonEnumeration)
NilReasonEnumeration._CF_pattern = pyxb.binding.facets.CF_pattern()
NilReasonEnumeration.inapplicable = u'inapplicable'# originally STD_ANON_.inapplicable
NilReasonEnumeration.missing = u'missing'         # originally STD_ANON_.missing
NilReasonEnumeration.template = u'template'       # originally STD_ANON_.template
NilReasonEnumeration.unknown = u'unknown'         # originally STD_ANON_.unknown
NilReasonEnumeration.withheld = u'withheld'       # originally STD_ANON_.withheld
NilReasonEnumeration._InitializeFacetMap(NilReasonEnumeration._CF_enumeration,
   NilReasonEnumeration._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'NilReasonEnumeration', NilReasonEnumeration)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class booleanList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'booleanList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = pyxb.binding.datatypes.boolean
booleanList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'booleanList', booleanList)

# List SimpleTypeDefinition
# superclasses NameOrNilReasonList
class STD_ANON_8 (pyxb.binding.basis.STD_list):

    """Simple type that is a list of NameOrNilReason."""

    _ExpandedName = None
    _Documentation = None

    _ItemType = NameOrNilReason
STD_ANON_8._CF_length = pyxb.binding.facets.CF_length(value=pyxb.binding.datatypes.nonNegativeInteger(2L))
STD_ANON_8._InitializeFacetMap(STD_ANON_8._CF_length)

# Atomic SimpleTypeDefinition
class MD_TopicCategoryCode_Type (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """High-level geospatial data thematic classification to assist in the grouping and search of available geospatial datasets"""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_TopicCategoryCode_Type')
    _Documentation = u'High-level geospatial data thematic classification to assist in the grouping and search of available geospatial datasets'
MD_TopicCategoryCode_Type._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=MD_TopicCategoryCode_Type, enum_prefix=None)
MD_TopicCategoryCode_Type.farming = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'farming')
MD_TopicCategoryCode_Type.biota = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'biota')
MD_TopicCategoryCode_Type.boundaries = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'boundaries')
MD_TopicCategoryCode_Type.climatologyMeteorologyAtmosphere = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'climatologyMeteorologyAtmosphere')
MD_TopicCategoryCode_Type.economy = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'economy')
MD_TopicCategoryCode_Type.elevation = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'elevation')
MD_TopicCategoryCode_Type.environment = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'environment')
MD_TopicCategoryCode_Type.geoscientificInformation = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'geoscientificInformation')
MD_TopicCategoryCode_Type.health = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'health')
MD_TopicCategoryCode_Type.imageryBaseMapsEarthCover = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'imageryBaseMapsEarthCover')
MD_TopicCategoryCode_Type.intelligenceMilitary = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'intelligenceMilitary')
MD_TopicCategoryCode_Type.inlandWaters = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'inlandWaters')
MD_TopicCategoryCode_Type.location = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'location')
MD_TopicCategoryCode_Type.oceans = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'oceans')
MD_TopicCategoryCode_Type.planningCadastre = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'planningCadastre')
MD_TopicCategoryCode_Type.society = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'society')
MD_TopicCategoryCode_Type.structure = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'structure')
MD_TopicCategoryCode_Type.transportation = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'transportation')
MD_TopicCategoryCode_Type.utilitiesCommunication = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'utilitiesCommunication')
MD_TopicCategoryCode_Type._InitializeFacetMap(MD_TopicCategoryCode_Type._CF_enumeration)
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_TopicCategoryCode_Type', MD_TopicCategoryCode_Type)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class stringOrNilReason (pyxb.binding.basis.STD_union):

    """Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'stringOrNilReason')
    _Documentation = u'Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value.'

    _MemberTypes = ( STD_ANON_, STD_ANON, pyxb.binding.datatypes.string, pyxb.binding.datatypes.anyURI, )
stringOrNilReason._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=stringOrNilReason)
stringOrNilReason._CF_pattern = pyxb.binding.facets.CF_pattern()
stringOrNilReason.inapplicable = u'inapplicable'  # originally STD_ANON_.inapplicable
stringOrNilReason.missing = u'missing'            # originally STD_ANON_.missing
stringOrNilReason.template = u'template'          # originally STD_ANON_.template
stringOrNilReason.unknown = u'unknown'            # originally STD_ANON_.unknown
stringOrNilReason.withheld = u'withheld'          # originally STD_ANON_.withheld
stringOrNilReason._InitializeFacetMap(stringOrNilReason._CF_enumeration,
   stringOrNilReason._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'stringOrNilReason', stringOrNilReason)

# List SimpleTypeDefinition
# superclasses doubleOrNilReasonList
class STD_ANON_9 (pyxb.binding.basis.STD_list):

    """Simple type that is a list of doubleOrNilReason."""

    _ExpandedName = None
    _Documentation = None

    _ItemType = doubleOrNilReason
STD_ANON_9._CF_length = pyxb.binding.facets.CF_length(value=pyxb.binding.datatypes.nonNegativeInteger(2L))
STD_ANON_9._InitializeFacetMap(STD_ANON_9._CF_length)

# Atomic SimpleTypeDefinition
class IncrementOrder (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'IncrementOrder')
    _Documentation = ''
IncrementOrder._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=IncrementOrder, enum_prefix=None)
IncrementOrder.xy = IncrementOrder._CF_enumeration.addEnumeration(unicode_value=u'+x+y')
IncrementOrder.yx = IncrementOrder._CF_enumeration.addEnumeration(unicode_value=u'+y+x')
IncrementOrder.x_y = IncrementOrder._CF_enumeration.addEnumeration(unicode_value=u'+x-y')
IncrementOrder.x_y_ = IncrementOrder._CF_enumeration.addEnumeration(unicode_value=u'-x-y')
IncrementOrder._InitializeFacetMap(IncrementOrder._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'IncrementOrder', IncrementOrder)

# Atomic SimpleTypeDefinition
class SequenceRuleEnumeration (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SequenceRuleEnumeration')
    _Documentation = None
SequenceRuleEnumeration._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=SequenceRuleEnumeration, enum_prefix=None)
SequenceRuleEnumeration.Linear = SequenceRuleEnumeration._CF_enumeration.addEnumeration(unicode_value=u'Linear')
SequenceRuleEnumeration.Boustrophedonic = SequenceRuleEnumeration._CF_enumeration.addEnumeration(unicode_value=u'Boustrophedonic')
SequenceRuleEnumeration.Cantor_diagonal = SequenceRuleEnumeration._CF_enumeration.addEnumeration(unicode_value=u'Cantor-diagonal')
SequenceRuleEnumeration.Spiral = SequenceRuleEnumeration._CF_enumeration.addEnumeration(unicode_value=u'Spiral')
SequenceRuleEnumeration.Morton = SequenceRuleEnumeration._CF_enumeration.addEnumeration(unicode_value=u'Morton')
SequenceRuleEnumeration.Hilbert = SequenceRuleEnumeration._CF_enumeration.addEnumeration(unicode_value=u'Hilbert')
SequenceRuleEnumeration._InitializeFacetMap(SequenceRuleEnumeration._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'SequenceRuleEnumeration', SequenceRuleEnumeration)

# Atomic SimpleTypeDefinition
class AxisDirection (pyxb.binding.datatypes.string):

    """The value of a gml:AxisDirection indicates the incrementation order to be used on an axis of the grid."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AxisDirection')
    _Documentation = u'The value of a gml:AxisDirection indicates the incrementation order to be used on an axis of the grid.'
AxisDirection._CF_pattern = pyxb.binding.facets.CF_pattern()
AxisDirection._CF_pattern.addPattern(pattern=u'[\\+\\-][1-9][0-9]*')
AxisDirection._InitializeFacetMap(AxisDirection._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'AxisDirection', AxisDirection)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class AxisDirectionList (pyxb.binding.basis.STD_list):

    """The different values in a gml:AxisDirectionList indicate the incrementation order to be used on all axes of the grid. Each axis shall be mentioned once and only once."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AxisDirectionList')
    _Documentation = u'The different values in a gml:AxisDirectionList indicate the incrementation order to be used on all axes of the grid. Each axis shall be mentioned once and only once.'

    _ItemType = AxisDirection
AxisDirectionList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'AxisDirectionList', AxisDirectionList)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class booleanOrNilReason (pyxb.binding.basis.STD_union):

    """Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'booleanOrNilReason')
    _Documentation = u'Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value.'

    _MemberTypes = ( STD_ANON_, STD_ANON, pyxb.binding.datatypes.boolean, pyxb.binding.datatypes.anyURI, )
booleanOrNilReason._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=booleanOrNilReason)
booleanOrNilReason._CF_pattern = pyxb.binding.facets.CF_pattern()
booleanOrNilReason.inapplicable = u'inapplicable' # originally STD_ANON_.inapplicable
booleanOrNilReason.missing = u'missing'           # originally STD_ANON_.missing
booleanOrNilReason.template = u'template'         # originally STD_ANON_.template
booleanOrNilReason.unknown = u'unknown'           # originally STD_ANON_.unknown
booleanOrNilReason.withheld = u'withheld'         # originally STD_ANON_.withheld
booleanOrNilReason._InitializeFacetMap(booleanOrNilReason._CF_enumeration,
   booleanOrNilReason._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'booleanOrNilReason', booleanOrNilReason)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class booleanOrNilReasonList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'booleanOrNilReasonList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = booleanOrNilReason
booleanOrNilReasonList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'booleanOrNilReasonList', booleanOrNilReasonList)

# Complex type DirectedEdgePropertyType with content type ELEMENT_ONLY
class DirectedEdgePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectedEdgePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}Edge uses Python identifier Edge
    __Edge = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Edge'), 'Edge', '__httpwww_opengis_netgml3_2_DirectedEdgePropertyType_httpwww_opengis_netgml3_2Edge', False)

    
    Edge = property(__Edge.value, __Edge.set, None, u'gml:Edge represents the 1-dimensional primitive.\nThe topological boundary of an Edge (gml:directedNode) consists of a negatively directed start Node and a positively directed end Node.   \nThe optional coboundary of an edge (gml:directedFace) is a circular sequence of directed faces which are incident on this edge in document order. In the 2D case, the orientation of the face on the left of the edge is "+"; the orientation of the face on the right on its right is "-". \nIf provided, the aggregationType attribute shall have the value "sequence".\nAn edge may optionally be realised by a 1-dimensional geometric primitive (gml:curveProperty).')

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_DirectedEdgePropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute orientation uses Python identifier orientation
    __orientation = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'orientation'), 'orientation', '__httpwww_opengis_netgml3_2_DirectedEdgePropertyType_orientation', SignType, unicode_default=u'+')
    
    orientation = property(__orientation.value, __orientation.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_DirectedEdgePropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_DirectedEdgePropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_DirectedEdgePropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_DirectedEdgePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_DirectedEdgePropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_DirectedEdgePropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_DirectedEdgePropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_DirectedEdgePropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_DirectedEdgePropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __Edge.name() : __Edge
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason,
        __orientation.name() : __orientation,
        __actuate.name() : __actuate,
        __remoteSchema.name() : __remoteSchema,
        __title.name() : __title,
        __owns.name() : __owns,
        __role.name() : __role,
        __href.name() : __href,
        __type.name() : __type,
        __show.name() : __show,
        __arcrole.name() : __arcrole
    }
_Namespace_gml.addCategoryObject('typeBinding', u'DirectedEdgePropertyType', DirectedEdgePropertyType)


# Complex type EX_Extent_PropertyType with content type ELEMENT_ONLY
class EX_Extent_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'EX_Extent_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}EX_Extent uses Python identifier EX_Extent
    __EX_Extent = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'EX_Extent'), 'EX_Extent', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_isotc211_org2005gmdEX_Extent', False)

    
    EX_Extent = property(__EX_Extent.value, __EX_Extent.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __EX_Extent.name() : __EX_Extent
    }
    _AttributeMap = {
        __role.name() : __role,
        __title.name() : __title,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __href.name() : __href,
        __uuidref.name() : __uuidref,
        __type.name() : __type,
        __arcrole.name() : __arcrole
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'EX_Extent_PropertyType', EX_Extent_PropertyType)


# Complex type AbstractGMLType with content type ELEMENT_ONLY
class AbstractGMLType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGMLType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}description uses Python identifier description
    __description = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'description'), 'description', '__httpwww_opengis_netgml3_2_AbstractGMLType_httpwww_opengis_netgml3_2description', False)

    
    description = property(__description.value, __description.set, None, u'The value of this property is a text description of the object. gml:description uses gml:StringOrRefType as its content model, so it may contain a simple text string content, or carry a reference to an external description. The use of gml:description to reference an external description has been deprecated and replaced by the gml:descriptionReference property.')

    
    # Element {http://www.opengis.net/gml/3.2}metaDataProperty uses Python identifier metaDataProperty
    __metaDataProperty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'metaDataProperty'), 'metaDataProperty', '__httpwww_opengis_netgml3_2_AbstractGMLType_httpwww_opengis_netgml3_2metaDataProperty', True)

    
    metaDataProperty = property(__metaDataProperty.value, __metaDataProperty.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}identifier uses Python identifier identifier
    __identifier = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'identifier'), 'identifier', '__httpwww_opengis_netgml3_2_AbstractGMLType_httpwww_opengis_netgml3_2identifier', False)

    
    identifier = property(__identifier.value, __identifier.set, None, u'Often, a special identifier is assigned to an object by the maintaining authority with the intention that it is used in references to the object For such cases, the codeSpace shall be provided. That identifier is usually unique either globally or within an application domain. gml:identifier is a pre-defined property for such identifiers.')

    
    # Element {http://www.opengis.net/gml/3.2}name uses Python identifier name
    __name = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'name'), 'name', '__httpwww_opengis_netgml3_2_AbstractGMLType_httpwww_opengis_netgml3_2name', True)

    
    name = property(__name.value, __name.set, None, u'The gml:name property provides a label or identifier for the object, commonly a descriptive name. An object may have several names, typically assigned by different authorities. gml:name uses the gml:CodeType content model.  The authority for a name is indicated by the value of its (optional) codeSpace attribute.  The name may or may not be unique, as determined by the rules of the organization responsible for the codeSpace.  In common usage there will be one name per authority, so a processing application may select the name from its preferred codeSpace.')

    
    # Element {http://www.opengis.net/gml/3.2}descriptionReference uses Python identifier descriptionReference
    __descriptionReference = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'descriptionReference'), 'descriptionReference', '__httpwww_opengis_netgml3_2_AbstractGMLType_httpwww_opengis_netgml3_2descriptionReference', False)

    
    descriptionReference = property(__descriptionReference.value, __descriptionReference.set, None, u'The value of this property is a remote text description of the object. The xlink:href attribute of the gml:descriptionReference property references the external description.')

    
    # Attribute {http://www.opengis.net/gml/3.2}id uses Python identifier id
    __id = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'id'), 'id', '__httpwww_opengis_netgml3_2_AbstractGMLType_httpwww_opengis_netgml3_2id', pyxb.binding.datatypes.ID, required=True)
    
    id = property(__id.value, __id.set, None, u'The attribute gml:id supports provision of a handle for the XML element representing a GML Object. Its use is mandatory for all GML objects. It is of XML type ID, so is constrained to be unique in the XML document within which it occurs.')


    _ElementMap = {
        __description.name() : __description,
        __metaDataProperty.name() : __metaDataProperty,
        __identifier.name() : __identifier,
        __name.name() : __name,
        __descriptionReference.name() : __descriptionReference
    }
    _AttributeMap = {
        __id.name() : __id
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGMLType', AbstractGMLType)


# Complex type DefinitionBaseType with content type ELEMENT_ONLY
class DefinitionBaseType (AbstractGMLType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DefinitionBaseType')
    # Base type is AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id is restricted from parent
    
    # Attribute {http://www.opengis.net/gml/3.2}id uses Python identifier id
    __id = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'id'), 'id', '__httpwww_opengis_netgml3_2_AbstractGMLType_httpwww_opengis_netgml3_2id', pyxb.binding.datatypes.ID, required=True)
    
    id = property(__id.value, __id.set, None, u'The attribute gml:id supports provision of a handle for the XML element representing a GML Object. Its use is mandatory for all GML objects. It is of XML type ID, so is constrained to be unique in the XML document within which it occurs.')


    _ElementMap = AbstractGMLType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGMLType._AttributeMap.copy()
    _AttributeMap.update({
        __id.name() : __id
    })
_Namespace_gml.addCategoryObject('typeBinding', u'DefinitionBaseType', DefinitionBaseType)


# Complex type DefinitionType with content type ELEMENT_ONLY
class DefinitionType (DefinitionBaseType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DefinitionType')
    # Base type is DefinitionBaseType
    
    # Element {http://www.opengis.net/gml/3.2}remarks uses Python identifier remarks
    __remarks = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remarks'), 'remarks', '__httpwww_opengis_netgml3_2_DefinitionType_httpwww_opengis_netgml3_2remarks', False)

    
    remarks = property(__remarks.value, __remarks.set, None, None)

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = DefinitionBaseType._ElementMap.copy()
    _ElementMap.update({
        __remarks.name() : __remarks
    })
    _AttributeMap = DefinitionBaseType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'DefinitionType', DefinitionType)


# Complex type CharacterString_PropertyType with content type ELEMENT_ONLY
class CharacterString_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'CharacterString_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}CharacterString uses Python identifier CharacterString
    __CharacterString = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'CharacterString'), 'CharacterString', '__httpwww_isotc211_org2005gco_CharacterString_PropertyType_httpwww_isotc211_org2005gcoCharacterString', False)

    
    CharacterString = property(__CharacterString.value, __CharacterString.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_CharacterString_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __CharacterString.name() : __CharacterString
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'CharacterString_PropertyType', CharacterString_PropertyType)


# Complex type AbstractObject_Type with content type EMPTY
class AbstractObject_Type (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'AbstractObject_Type')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Attribute uuid uses Python identifier uuid
    __uuid = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuid'), 'uuid', '__httpwww_isotc211_org2005gco_AbstractObject_Type_uuid', pyxb.binding.datatypes.string)
    
    uuid = property(__uuid.value, __uuid.set, None, None)

    
    # Attribute id uses Python identifier id
    __id = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'id'), 'id', '__httpwww_isotc211_org2005gco_AbstractObject_Type_id', pyxb.binding.datatypes.ID)
    
    id = property(__id.value, __id.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __uuid.name() : __uuid,
        __id.name() : __id
    }
_Namespace_gco.addCategoryObject('typeBinding', u'AbstractObject_Type', AbstractObject_Type)


# Complex type AbstractDQ_Element_Type with content type ELEMENT_ONLY
class AbstractDQ_Element_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDQ_Element_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}measureDescription uses Python identifier measureDescription
    __measureDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'measureDescription'), 'measureDescription', '__httpwww_isotc211_org2005gmd_AbstractDQ_Element_Type_httpwww_isotc211_org2005gmdmeasureDescription', False)

    
    measureDescription = property(__measureDescription.value, __measureDescription.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}evaluationMethodType uses Python identifier evaluationMethodType
    __evaluationMethodType = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'evaluationMethodType'), 'evaluationMethodType', '__httpwww_isotc211_org2005gmd_AbstractDQ_Element_Type_httpwww_isotc211_org2005gmdevaluationMethodType', False)

    
    evaluationMethodType = property(__evaluationMethodType.value, __evaluationMethodType.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}measureIdentification uses Python identifier measureIdentification
    __measureIdentification = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'measureIdentification'), 'measureIdentification', '__httpwww_isotc211_org2005gmd_AbstractDQ_Element_Type_httpwww_isotc211_org2005gmdmeasureIdentification', False)

    
    measureIdentification = property(__measureIdentification.value, __measureIdentification.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}evaluationProcedure uses Python identifier evaluationProcedure
    __evaluationProcedure = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'evaluationProcedure'), 'evaluationProcedure', '__httpwww_isotc211_org2005gmd_AbstractDQ_Element_Type_httpwww_isotc211_org2005gmdevaluationProcedure', False)

    
    evaluationProcedure = property(__evaluationProcedure.value, __evaluationProcedure.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}dateTime uses Python identifier dateTime
    __dateTime = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'dateTime'), 'dateTime', '__httpwww_isotc211_org2005gmd_AbstractDQ_Element_Type_httpwww_isotc211_org2005gmddateTime', True)

    
    dateTime = property(__dateTime.value, __dateTime.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}result uses Python identifier result
    __result = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'result'), 'result', '__httpwww_isotc211_org2005gmd_AbstractDQ_Element_Type_httpwww_isotc211_org2005gmdresult', True)

    
    result = property(__result.value, __result.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}evaluationMethodDescription uses Python identifier evaluationMethodDescription
    __evaluationMethodDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'evaluationMethodDescription'), 'evaluationMethodDescription', '__httpwww_isotc211_org2005gmd_AbstractDQ_Element_Type_httpwww_isotc211_org2005gmdevaluationMethodDescription', False)

    
    evaluationMethodDescription = property(__evaluationMethodDescription.value, __evaluationMethodDescription.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}nameOfMeasure uses Python identifier nameOfMeasure
    __nameOfMeasure = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'nameOfMeasure'), 'nameOfMeasure', '__httpwww_isotc211_org2005gmd_AbstractDQ_Element_Type_httpwww_isotc211_org2005gmdnameOfMeasure', True)

    
    nameOfMeasure = property(__nameOfMeasure.value, __nameOfMeasure.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __measureDescription.name() : __measureDescription,
        __evaluationMethodType.name() : __evaluationMethodType,
        __measureIdentification.name() : __measureIdentification,
        __evaluationProcedure.name() : __evaluationProcedure,
        __dateTime.name() : __dateTime,
        __result.name() : __result,
        __evaluationMethodDescription.name() : __evaluationMethodDescription,
        __nameOfMeasure.name() : __nameOfMeasure
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractDQ_Element_Type', AbstractDQ_Element_Type)


# Complex type AbstractDQ_LogicalConsistency_Type with content type ELEMENT_ONLY
class AbstractDQ_LogicalConsistency_Type (AbstractDQ_Element_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDQ_LogicalConsistency_Type')
    # Base type is AbstractDQ_Element_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_Element_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_Element_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractDQ_LogicalConsistency_Type', AbstractDQ_LogicalConsistency_Type)


# Complex type DQ_FormatConsistency_Type with content type ELEMENT_ONLY
class DQ_FormatConsistency_Type (AbstractDQ_LogicalConsistency_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_FormatConsistency_Type')
    # Base type is AbstractDQ_LogicalConsistency_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_LogicalConsistency_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_LogicalConsistency_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_FormatConsistency_Type', DQ_FormatConsistency_Type)


# Complex type DQ_DataQuality_PropertyType with content type ELEMENT_ONLY
class DQ_DataQuality_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_DataQuality_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}DQ_DataQuality uses Python identifier DQ_DataQuality
    __DQ_DataQuality = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_DataQuality'), 'DQ_DataQuality', '__httpwww_isotc211_org2005gmd_DQ_DataQuality_PropertyType_httpwww_isotc211_org2005gmdDQ_DataQuality', False)

    
    DQ_DataQuality = property(__DQ_DataQuality.value, __DQ_DataQuality.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_DQ_DataQuality_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_DQ_DataQuality_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_DQ_DataQuality_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_DQ_DataQuality_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_DQ_DataQuality_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DQ_DataQuality_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_DQ_DataQuality_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_DQ_DataQuality_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_DQ_DataQuality_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __DQ_DataQuality.name() : __DQ_DataQuality
    }
    _AttributeMap = {
        __role.name() : __role,
        __title.name() : __title,
        __actuate.name() : __actuate,
        __uuidref.name() : __uuidref,
        __show.name() : __show,
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __type.name() : __type,
        __arcrole.name() : __arcrole
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_DataQuality_PropertyType', DQ_DataQuality_PropertyType)


# Complex type BoundingShapeType with content type ELEMENT_ONLY
class BoundingShapeType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'BoundingShapeType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}Null uses Python identifier Null
    __Null = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Null'), 'Null', '__httpwww_opengis_netgml3_2_BoundingShapeType_httpwww_opengis_netgml3_2Null', False)

    
    Null = property(__Null.value, __Null.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}Envelope uses Python identifier Envelope
    __Envelope = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Envelope'), 'Envelope', '__httpwww_opengis_netgml3_2_BoundingShapeType_httpwww_opengis_netgml3_2Envelope', False)

    
    Envelope = property(__Envelope.value, __Envelope.set, None, u'Envelope defines an extent using a pair of positions defining opposite corners in arbitrary dimensions. The first direct position is the "lower corner" (a coordinate position consisting of all the minimal ordinates for each dimension for all points within the envelope), the second one the "upper corner" (a coordinate position consisting of all the maximal ordinates for each dimension for all points within the envelope).\nThe use of the properties "coordinates" and "pos" has been deprecated. The explicitly named properties "lowerCorner" and "upperCorner" shall be used instead.')

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_BoundingShapeType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __Null.name() : __Null,
        __Envelope.name() : __Envelope
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gml.addCategoryObject('typeBinding', u'BoundingShapeType', BoundingShapeType)


# Complex type AbstractGeometryType with content type ELEMENT_ONLY
class AbstractGeometryType (AbstractGMLType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeometryType')
    # Base type is AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute srsDimension uses Python identifier srsDimension
    __srsDimension = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'srsDimension'), 'srsDimension', '__httpwww_opengis_netgml3_2_AbstractGeometryType_srsDimension', pyxb.binding.datatypes.positiveInteger)
    
    srsDimension = property(__srsDimension.value, __srsDimension.set, None, None)

    
    # Attribute axisLabels uses Python identifier axisLabels
    __axisLabels = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'axisLabels'), 'axisLabels', '__httpwww_opengis_netgml3_2_AbstractGeometryType_axisLabels', NCNameList)
    
    axisLabels = property(__axisLabels.value, __axisLabels.set, None, None)

    
    # Attribute uomLabels uses Python identifier uomLabels
    __uomLabels = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uomLabels'), 'uomLabels', '__httpwww_opengis_netgml3_2_AbstractGeometryType_uomLabels', NCNameList)
    
    uomLabels = property(__uomLabels.value, __uomLabels.set, None, None)

    
    # Attribute srsName uses Python identifier srsName
    __srsName = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'srsName'), 'srsName', '__httpwww_opengis_netgml3_2_AbstractGeometryType_srsName', pyxb.binding.datatypes.anyURI)
    
    srsName = property(__srsName.value, __srsName.set, None, None)

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractGMLType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGMLType._AttributeMap.copy()
    _AttributeMap.update({
        __srsDimension.name() : __srsDimension,
        __axisLabels.name() : __axisLabels,
        __uomLabels.name() : __uomLabels,
        __srsName.name() : __srsName
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGeometryType', AbstractGeometryType)


# Complex type StringOrRefType with content type SIMPLE
class StringOrRefType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = pyxb.binding.datatypes.string
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'StringOrRefType')
    # Base type is pyxb.binding.datatypes.string
    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_StringOrRefType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_StringOrRefType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_StringOrRefType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_StringOrRefType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_StringOrRefType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_StringOrRefType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_StringOrRefType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_StringOrRefType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_StringOrRefType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show,
        __role.name() : __role,
        __href.name() : __href,
        __actuate.name() : __actuate,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __title.name() : __title,
        __nilReason.name() : __nilReason
    }
_Namespace_gml.addCategoryObject('typeBinding', u'StringOrRefType', StringOrRefType)


# Complex type MD_ServiceIdentification_PropertyType with content type ELEMENT_ONLY
class MD_ServiceIdentification_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ServiceIdentification_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_ServiceIdentification uses Python identifier MD_ServiceIdentification
    __MD_ServiceIdentification = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ServiceIdentification'), 'MD_ServiceIdentification', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_isotc211_org2005gmdMD_ServiceIdentification', False)

    
    MD_ServiceIdentification = property(__MD_ServiceIdentification.value, __MD_ServiceIdentification.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __MD_ServiceIdentification.name() : __MD_ServiceIdentification
    }
    _AttributeMap = {
        __href.name() : __href,
        __type.name() : __type,
        __show.name() : __show,
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __uuidref.name() : __uuidref,
        __actuate.name() : __actuate
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_ServiceIdentification_PropertyType', MD_ServiceIdentification_PropertyType)


# Complex type MD_Dimension_Type with content type ELEMENT_ONLY
class MD_Dimension_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Dimension_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}resolution uses Python identifier resolution
    __resolution = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'resolution'), 'resolution', '__httpwww_isotc211_org2005gmd_MD_Dimension_Type_httpwww_isotc211_org2005gmdresolution', False)

    
    resolution = property(__resolution.value, __resolution.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}dimensionName uses Python identifier dimensionName
    __dimensionName = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'dimensionName'), 'dimensionName', '__httpwww_isotc211_org2005gmd_MD_Dimension_Type_httpwww_isotc211_org2005gmddimensionName', False)

    
    dimensionName = property(__dimensionName.value, __dimensionName.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}dimensionSize uses Python identifier dimensionSize
    __dimensionSize = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'dimensionSize'), 'dimensionSize', '__httpwww_isotc211_org2005gmd_MD_Dimension_Type_httpwww_isotc211_org2005gmddimensionSize', False)

    
    dimensionSize = property(__dimensionSize.value, __dimensionSize.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __resolution.name() : __resolution,
        __dimensionName.name() : __dimensionName,
        __dimensionSize.name() : __dimensionSize
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Dimension_Type', MD_Dimension_Type)


# Complex type MD_AggregateInformation_PropertyType with content type ELEMENT_ONLY
class MD_AggregateInformation_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_AggregateInformation_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_AggregateInformation uses Python identifier MD_AggregateInformation
    __MD_AggregateInformation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_AggregateInformation'), 'MD_AggregateInformation', '__httpwww_isotc211_org2005gmd_MD_AggregateInformation_PropertyType_httpwww_isotc211_org2005gmdMD_AggregateInformation', False)

    
    MD_AggregateInformation = property(__MD_AggregateInformation.value, __MD_AggregateInformation.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_AggregateInformation_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_AggregateInformation_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_AggregateInformation_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_AggregateInformation_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_AggregateInformation_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_AggregateInformation_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_AggregateInformation_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_AggregateInformation_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_AggregateInformation_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __MD_AggregateInformation.name() : __MD_AggregateInformation
    }
    _AttributeMap = {
        __role.name() : __role,
        __title.name() : __title,
        __uuidref.name() : __uuidref,
        __actuate.name() : __actuate,
        __nilReason.name() : __nilReason,
        __show.name() : __show,
        __href.name() : __href,
        __type.name() : __type,
        __arcrole.name() : __arcrole
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_AggregateInformation_PropertyType', MD_AggregateInformation_PropertyType)


# Complex type AbstractTimeObjectType with content type ELEMENT_ONLY
class AbstractTimeObjectType (AbstractGMLType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTimeObjectType')
    # Base type is AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractGMLType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGMLType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractTimeObjectType', AbstractTimeObjectType)


# Complex type AbstractTimePrimitiveType with content type ELEMENT_ONLY
class AbstractTimePrimitiveType (AbstractTimeObjectType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTimePrimitiveType')
    # Base type is AbstractTimeObjectType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}relatedTime uses Python identifier relatedTime
    __relatedTime = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'relatedTime'), 'relatedTime', '__httpwww_opengis_netgml3_2_AbstractTimePrimitiveType_httpwww_opengis_netgml3_2relatedTime', True)

    
    relatedTime = property(__relatedTime.value, __relatedTime.set, None, None)

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTimeObjectType._ElementMap.copy()
    _ElementMap.update({
        __relatedTime.name() : __relatedTime
    })
    _AttributeMap = AbstractTimeObjectType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractTimePrimitiveType', AbstractTimePrimitiveType)


# Complex type AbstractTimeGeometricPrimitiveType with content type ELEMENT_ONLY
class AbstractTimeGeometricPrimitiveType (AbstractTimePrimitiveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTimeGeometricPrimitiveType')
    # Base type is AbstractTimePrimitiveType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element relatedTime ({http://www.opengis.net/gml/3.2}relatedTime) inherited from {http://www.opengis.net/gml/3.2}AbstractTimePrimitiveType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute frame uses Python identifier frame
    __frame = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'frame'), 'frame', '__httpwww_opengis_netgml3_2_AbstractTimeGeometricPrimitiveType_frame', pyxb.binding.datatypes.anyURI, unicode_default=u'#ISO-8601')
    
    frame = property(__frame.value, __frame.set, None, None)

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTimePrimitiveType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractTimePrimitiveType._AttributeMap.copy()
    _AttributeMap.update({
        __frame.name() : __frame
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractTimeGeometricPrimitiveType', AbstractTimeGeometricPrimitiveType)


# Complex type TimeInstantType with content type ELEMENT_ONLY
class TimeInstantType (AbstractTimeGeometricPrimitiveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeInstantType')
    # Base type is AbstractTimeGeometricPrimitiveType
    
    # Element {http://www.opengis.net/gml/3.2}timePosition uses Python identifier timePosition
    __timePosition = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'timePosition'), 'timePosition', '__httpwww_opengis_netgml3_2_TimeInstantType_httpwww_opengis_netgml3_2timePosition', False)

    
    timePosition = property(__timePosition.value, __timePosition.set, None, u'This element is used directly as a property of gml:TimeInstant (see 15.2.2.3), and may also be used in application schemas.')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element relatedTime ({http://www.opengis.net/gml/3.2}relatedTime) inherited from {http://www.opengis.net/gml/3.2}AbstractTimePrimitiveType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute frame inherited from {http://www.opengis.net/gml/3.2}AbstractTimeGeometricPrimitiveType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTimeGeometricPrimitiveType._ElementMap.copy()
    _ElementMap.update({
        __timePosition.name() : __timePosition
    })
    _AttributeMap = AbstractTimeGeometricPrimitiveType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TimeInstantType', TimeInstantType)


# Complex type ReferenceType with content type EMPTY
class ReferenceType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ReferenceType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_ReferenceType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_ReferenceType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_ReferenceType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_ReferenceType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_ReferenceType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_ReferenceType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_ReferenceType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_ReferenceType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_ReferenceType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_ReferenceType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __show.name() : __show,
        __actuate.name() : __actuate,
        __title.name() : __title,
        __role.name() : __role,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __href.name() : __href,
        __nilReason.name() : __nilReason,
        __remoteSchema.name() : __remoteSchema,
        __owns.name() : __owns
    }
_Namespace_gml.addCategoryObject('typeBinding', u'ReferenceType', ReferenceType)


# Complex type IdentifiedObjectType with content type ELEMENT_ONLY
class IdentifiedObjectType (DefinitionType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'IdentifiedObjectType')
    # Base type is DefinitionType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = DefinitionType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = DefinitionType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'IdentifiedObjectType', IdentifiedObjectType)


# Complex type OperationMethodType with content type ELEMENT_ONLY
class OperationMethodType (IdentifiedObjectType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'OperationMethodType')
    # Base type is IdentifiedObjectType
    
    # Element {http://www.opengis.net/gml/3.2}parameter uses Python identifier parameter
    __parameter = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'parameter'), 'parameter', '__httpwww_opengis_netgml3_2_OperationMethodType_httpwww_opengis_netgml3_2parameter', True)

    
    parameter = property(__parameter.value, __parameter.set, None, u'gml:parameter is an association to an operation parameter or parameter group.')

    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element {http://www.opengis.net/gml/3.2}sourceDimensions uses Python identifier sourceDimensions
    __sourceDimensions = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'sourceDimensions'), 'sourceDimensions', '__httpwww_opengis_netgml3_2_OperationMethodType_httpwww_opengis_netgml3_2sourceDimensions', False)

    
    sourceDimensions = property(__sourceDimensions.value, __sourceDimensions.set, None, u'gml:sourceDimensions is the number of dimensions in the source CRS of this operation method.')

    
    # Element {http://www.opengis.net/gml/3.2}targetDimensions uses Python identifier targetDimensions
    __targetDimensions = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'targetDimensions'), 'targetDimensions', '__httpwww_opengis_netgml3_2_OperationMethodType_httpwww_opengis_netgml3_2targetDimensions', False)

    
    targetDimensions = property(__targetDimensions.value, __targetDimensions.set, None, u'gml:targetDimensions is the number of dimensions in the target CRS of this operation method.')

    
    # Element {http://www.opengis.net/gml/3.2}formulaCitation uses Python identifier formulaCitation
    __formulaCitation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'formulaCitation'), 'formulaCitation', '__httpwww_opengis_netgml3_2_OperationMethodType_httpwww_opengis_netgml3_2formulaCitation', False)

    
    formulaCitation = property(__formulaCitation.value, __formulaCitation.set, None, u'gml:formulaCitation provides a reference to a publication giving the formula(s) or procedure used by an coordinate operation method.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}formula uses Python identifier formula
    __formula = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'formula'), 'formula', '__httpwww_opengis_netgml3_2_OperationMethodType_httpwww_opengis_netgml3_2formula', False)

    
    formula = property(__formula.value, __formula.set, None, u'gml:formula Formula(s) or procedure used by an operation method. The use of the codespace attribite has been deprecated. The property value shall be a character string.')

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = IdentifiedObjectType._ElementMap.copy()
    _ElementMap.update({
        __parameter.name() : __parameter,
        __sourceDimensions.name() : __sourceDimensions,
        __targetDimensions.name() : __targetDimensions,
        __formulaCitation.name() : __formulaCitation,
        __formula.name() : __formula
    })
    _AttributeMap = IdentifiedObjectType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'OperationMethodType', OperationMethodType)


# Complex type CodeListValue_Type with content type SIMPLE
class CodeListValue_Type (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = pyxb.binding.datatypes.string
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'CodeListValue_Type')
    # Base type is pyxb.binding.datatypes.string
    
    # Attribute codeSpace uses Python identifier codeSpace
    __codeSpace = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'codeSpace'), 'codeSpace', '__httpwww_isotc211_org2005gco_CodeListValue_Type_codeSpace', pyxb.binding.datatypes.anyURI)
    
    codeSpace = property(__codeSpace.value, __codeSpace.set, None, None)

    
    # Attribute codeList uses Python identifier codeList
    __codeList = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'codeList'), 'codeList', '__httpwww_isotc211_org2005gco_CodeListValue_Type_codeList', pyxb.binding.datatypes.anyURI, required=True)
    
    codeList = property(__codeList.value, __codeList.set, None, None)

    
    # Attribute codeListValue uses Python identifier codeListValue
    __codeListValue = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'codeListValue'), 'codeListValue', '__httpwww_isotc211_org2005gco_CodeListValue_Type_codeListValue', pyxb.binding.datatypes.anyURI, required=True)
    
    codeListValue = property(__codeListValue.value, __codeListValue.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __codeSpace.name() : __codeSpace,
        __codeList.name() : __codeList,
        __codeListValue.name() : __codeListValue
    }
_Namespace_gco.addCategoryObject('typeBinding', u'CodeListValue_Type', CodeListValue_Type)


# Complex type AbstractTopologyType with content type ELEMENT_ONLY
class AbstractTopologyType (AbstractGMLType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTopologyType')
    # Base type is AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractGMLType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGMLType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractTopologyType', AbstractTopologyType)


# Complex type AbstractTopoPrimitiveType with content type ELEMENT_ONLY
class AbstractTopoPrimitiveType (AbstractTopologyType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTopoPrimitiveType')
    # Base type is AbstractTopologyType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTopologyType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractTopologyType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractTopoPrimitiveType', AbstractTopoPrimitiveType)


# Complex type TopoSolidType with content type ELEMENT_ONLY
class TopoSolidType (AbstractTopoPrimitiveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TopoSolidType')
    # Base type is AbstractTopoPrimitiveType
    
    # Element {http://www.opengis.net/gml/3.2}isolated uses Python identifier isolated
    __isolated = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'isolated'), 'isolated', '__httpwww_opengis_netgml3_2_TopoSolidType_httpwww_opengis_netgml3_2isolated', True)

    
    isolated = property(__isolated.value, __isolated.set, None, None)

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}solidProperty uses Python identifier solidProperty
    __solidProperty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'solidProperty'), 'solidProperty', '__httpwww_opengis_netgml3_2_TopoSolidType_httpwww_opengis_netgml3_2solidProperty', False)

    
    solidProperty = property(__solidProperty.value, __solidProperty.set, None, u'This property element either references a solid via the XLink-attributes or contains the solid element. solidProperty is the predefined property which may be used by GML Application Schemas whenever a GML feature has a property with a value that is substitutable for AbstractSolid.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}directedFace uses Python identifier directedFace
    __directedFace = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'directedFace'), 'directedFace', '__httpwww_opengis_netgml3_2_TopoSolidType_httpwww_opengis_netgml3_2directedFace', True)

    
    directedFace = property(__directedFace.value, __directedFace.set, None, u'The gml:directedFace property element describes the boundary of topology solids, in the coBoundary of topology edges and is used in the support of surface features via the gml:TopoSurface expression, see below. The orientation attribute of type gml:SignType expresses the sense in which the included face is used i.e. inward or outward with respect to the surface normal in any geometric realisation.')

    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_TopoSolidType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute universal uses Python identifier universal
    __universal = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'universal'), 'universal', '__httpwww_opengis_netgml3_2_TopoSolidType_universal', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    universal = property(__universal.value, __universal.set, None, u'A gml:TopoSolid must indicate whether it is a universal topo-solid or not, to ensure a lossless topology representation as defined by Kuijpers, et. al. (see OGC 05-102 Topology IPR). The optional universal attribute of type boolean is used to indicate this and the default is fault. NOTE The universal topo-solid is normally not part of any feature, and is used to represent the unbounded portion of the data set. Its interior boundary (it has no exterior boundary) would normally be considered the exterior boundary of the data set.')


    _ElementMap = AbstractTopoPrimitiveType._ElementMap.copy()
    _ElementMap.update({
        __isolated.name() : __isolated,
        __solidProperty.name() : __solidProperty,
        __directedFace.name() : __directedFace
    })
    _AttributeMap = AbstractTopoPrimitiveType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType,
        __universal.name() : __universal
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TopoSolidType', TopoSolidType)


# Complex type AbstractMD_SpatialRepresentation_Type with content type EMPTY
class AbstractMD_SpatialRepresentation_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractMD_SpatialRepresentation_Type')
    # Base type is AbstractObject_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractMD_SpatialRepresentation_Type', AbstractMD_SpatialRepresentation_Type)


# Complex type MD_GridSpatialRepresentation_Type with content type ELEMENT_ONLY
class MD_GridSpatialRepresentation_Type (AbstractMD_SpatialRepresentation_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_GridSpatialRepresentation_Type')
    # Base type is AbstractMD_SpatialRepresentation_Type
    
    # Element {http://www.isotc211.org/2005/gmd}numberOfDimensions uses Python identifier numberOfDimensions
    __numberOfDimensions = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'numberOfDimensions'), 'numberOfDimensions', '__httpwww_isotc211_org2005gmd_MD_GridSpatialRepresentation_Type_httpwww_isotc211_org2005gmdnumberOfDimensions', False)

    
    numberOfDimensions = property(__numberOfDimensions.value, __numberOfDimensions.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}transformationParameterAvailability uses Python identifier transformationParameterAvailability
    __transformationParameterAvailability = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'transformationParameterAvailability'), 'transformationParameterAvailability', '__httpwww_isotc211_org2005gmd_MD_GridSpatialRepresentation_Type_httpwww_isotc211_org2005gmdtransformationParameterAvailability', False)

    
    transformationParameterAvailability = property(__transformationParameterAvailability.value, __transformationParameterAvailability.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}cellGeometry uses Python identifier cellGeometry
    __cellGeometry = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'cellGeometry'), 'cellGeometry', '__httpwww_isotc211_org2005gmd_MD_GridSpatialRepresentation_Type_httpwww_isotc211_org2005gmdcellGeometry', False)

    
    cellGeometry = property(__cellGeometry.value, __cellGeometry.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}axisDimensionProperties uses Python identifier axisDimensionProperties
    __axisDimensionProperties = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'axisDimensionProperties'), 'axisDimensionProperties', '__httpwww_isotc211_org2005gmd_MD_GridSpatialRepresentation_Type_httpwww_isotc211_org2005gmdaxisDimensionProperties', True)

    
    axisDimensionProperties = property(__axisDimensionProperties.value, __axisDimensionProperties.set, None, None)

    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractMD_SpatialRepresentation_Type._ElementMap.copy()
    _ElementMap.update({
        __numberOfDimensions.name() : __numberOfDimensions,
        __transformationParameterAvailability.name() : __transformationParameterAvailability,
        __cellGeometry.name() : __cellGeometry,
        __axisDimensionProperties.name() : __axisDimensionProperties
    })
    _AttributeMap = AbstractMD_SpatialRepresentation_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_GridSpatialRepresentation_Type', MD_GridSpatialRepresentation_Type)


# Complex type MD_Georectified_Type with content type ELEMENT_ONLY
class MD_Georectified_Type (MD_GridSpatialRepresentation_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Georectified_Type')
    # Base type is MD_GridSpatialRepresentation_Type
    
    # Element {http://www.isotc211.org/2005/gmd}pointInPixel uses Python identifier pointInPixel
    __pointInPixel = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'pointInPixel'), 'pointInPixel', '__httpwww_isotc211_org2005gmd_MD_Georectified_Type_httpwww_isotc211_org2005gmdpointInPixel', False)

    
    pointInPixel = property(__pointInPixel.value, __pointInPixel.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}transformationDimensionDescription uses Python identifier transformationDimensionDescription
    __transformationDimensionDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'transformationDimensionDescription'), 'transformationDimensionDescription', '__httpwww_isotc211_org2005gmd_MD_Georectified_Type_httpwww_isotc211_org2005gmdtransformationDimensionDescription', False)

    
    transformationDimensionDescription = property(__transformationDimensionDescription.value, __transformationDimensionDescription.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}transformationDimensionMapping uses Python identifier transformationDimensionMapping
    __transformationDimensionMapping = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'transformationDimensionMapping'), 'transformationDimensionMapping', '__httpwww_isotc211_org2005gmd_MD_Georectified_Type_httpwww_isotc211_org2005gmdtransformationDimensionMapping', True)

    
    transformationDimensionMapping = property(__transformationDimensionMapping.value, __transformationDimensionMapping.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}checkPointAvailability uses Python identifier checkPointAvailability
    __checkPointAvailability = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'checkPointAvailability'), 'checkPointAvailability', '__httpwww_isotc211_org2005gmd_MD_Georectified_Type_httpwww_isotc211_org2005gmdcheckPointAvailability', False)

    
    checkPointAvailability = property(__checkPointAvailability.value, __checkPointAvailability.set, None, None)

    
    # Element numberOfDimensions ({http://www.isotc211.org/2005/gmd}numberOfDimensions) inherited from {http://www.isotc211.org/2005/gmd}MD_GridSpatialRepresentation_Type
    
    # Element axisDimensionProperties ({http://www.isotc211.org/2005/gmd}axisDimensionProperties) inherited from {http://www.isotc211.org/2005/gmd}MD_GridSpatialRepresentation_Type
    
    # Element {http://www.isotc211.org/2005/gmd}checkPointDescription uses Python identifier checkPointDescription
    __checkPointDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'checkPointDescription'), 'checkPointDescription', '__httpwww_isotc211_org2005gmd_MD_Georectified_Type_httpwww_isotc211_org2005gmdcheckPointDescription', False)

    
    checkPointDescription = property(__checkPointDescription.value, __checkPointDescription.set, None, None)

    
    # Element cellGeometry ({http://www.isotc211.org/2005/gmd}cellGeometry) inherited from {http://www.isotc211.org/2005/gmd}MD_GridSpatialRepresentation_Type
    
    # Element {http://www.isotc211.org/2005/gmd}cornerPoints uses Python identifier cornerPoints
    __cornerPoints = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'cornerPoints'), 'cornerPoints', '__httpwww_isotc211_org2005gmd_MD_Georectified_Type_httpwww_isotc211_org2005gmdcornerPoints', True)

    
    cornerPoints = property(__cornerPoints.value, __cornerPoints.set, None, None)

    
    # Element transformationParameterAvailability ({http://www.isotc211.org/2005/gmd}transformationParameterAvailability) inherited from {http://www.isotc211.org/2005/gmd}MD_GridSpatialRepresentation_Type
    
    # Element {http://www.isotc211.org/2005/gmd}centerPoint uses Python identifier centerPoint
    __centerPoint = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'centerPoint'), 'centerPoint', '__httpwww_isotc211_org2005gmd_MD_Georectified_Type_httpwww_isotc211_org2005gmdcenterPoint', False)

    
    centerPoint = property(__centerPoint.value, __centerPoint.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = MD_GridSpatialRepresentation_Type._ElementMap.copy()
    _ElementMap.update({
        __pointInPixel.name() : __pointInPixel,
        __transformationDimensionDescription.name() : __transformationDimensionDescription,
        __transformationDimensionMapping.name() : __transformationDimensionMapping,
        __checkPointAvailability.name() : __checkPointAvailability,
        __checkPointDescription.name() : __checkPointDescription,
        __cornerPoints.name() : __cornerPoints,
        __centerPoint.name() : __centerPoint
    })
    _AttributeMap = MD_GridSpatialRepresentation_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Georectified_Type', MD_Georectified_Type)


# Complex type HistoryPropertyType with content type ELEMENT_ONLY
class HistoryPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'HistoryPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractTimeSlice uses Python identifier AbstractTimeSlice
    __AbstractTimeSlice = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTimeSlice'), 'AbstractTimeSlice', '__httpwww_opengis_netgml3_2_HistoryPropertyType_httpwww_opengis_netgml3_2AbstractTimeSlice', True)

    
    AbstractTimeSlice = property(__AbstractTimeSlice.value, __AbstractTimeSlice.set, None, u'To describe an event \u2014 an action that occurs at an instant or over an interval of time \u2014 GML provides the gml:AbtractTimeSlice element. A timeslice encapsulates the time-varying properties of a dynamic feature -- it shall be extended to represent a time stamped projection of a specific feature. The gml:dataSource property describes how the temporal data was acquired.\nA gml:AbstractTimeSlice instance is a GML object that encapsulates updates of the dynamic\u2014or volatile\u2014properties that reflect some change event; it thus includes only those feature properties that have actually changed due to some process.\ngml:AbstractTimeSlice basically provides a facility for attribute-level time stamping, in contrast to the object-level time stamping of dynamic feature instances. \nThe time slice can thus be viewed as event or process-oriented, whereas a snapshot is more state or structure-oriented. A timeslice has richer causality, whereas a snapshot merely portrays the status of the whole. \n')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_HistoryPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)


    _ElementMap = {
        __AbstractTimeSlice.name() : __AbstractTimeSlice
    }
    _AttributeMap = {
        __owns.name() : __owns
    }
_Namespace_gml.addCategoryObject('typeBinding', u'HistoryPropertyType', HistoryPropertyType)


# Complex type TopoCurveType with content type ELEMENT_ONLY
class TopoCurveType (AbstractTopologyType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TopoCurveType')
    # Base type is AbstractTopologyType
    
    # Element {http://www.opengis.net/gml/3.2}directedEdge uses Python identifier directedEdge
    __directedEdge = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'directedEdge'), 'directedEdge', '__httpwww_opengis_netgml3_2_TopoCurveType_httpwww_opengis_netgml3_2directedEdge', True)

    
    directedEdge = property(__directedEdge.value, __directedEdge.set, None, u'A gml:directedEdge property element describes the boundary of topology faces, the coBoundary of topology nodes and is used in the support of topological line features via the gml:TopoCurve expression, see below. The orientation attribute of type gml:SignType expresses the sense in which the included edge is used, i.e. forward or reverse.')

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_TopoCurveType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTopologyType._ElementMap.copy()
    _ElementMap.update({
        __directedEdge.name() : __directedEdge
    })
    _AttributeMap = AbstractTopologyType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TopoCurveType', TopoCurveType)


# Complex type Binary_PropertyType with content type ELEMENT_ONLY
class Binary_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Binary_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}Binary uses Python identifier Binary
    __Binary = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'Binary'), 'Binary', '__httpwww_isotc211_org2005gco_Binary_PropertyType_httpwww_isotc211_org2005gcoBinary', False)

    
    Binary = property(__Binary.value, __Binary.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_Binary_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __Binary.name() : __Binary
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'Binary_PropertyType', Binary_PropertyType)


# Complex type DirectPositionType with content type SIMPLE
class DirectPositionType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = doubleList
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectPositionType')
    # Base type is doubleList
    
    # Attribute srsName uses Python identifier srsName
    __srsName = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'srsName'), 'srsName', '__httpwww_opengis_netgml3_2_DirectPositionType_srsName', pyxb.binding.datatypes.anyURI)
    
    srsName = property(__srsName.value, __srsName.set, None, None)

    
    # Attribute uomLabels uses Python identifier uomLabels
    __uomLabels = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uomLabels'), 'uomLabels', '__httpwww_opengis_netgml3_2_DirectPositionType_uomLabels', NCNameList)
    
    uomLabels = property(__uomLabels.value, __uomLabels.set, None, None)

    
    # Attribute axisLabels uses Python identifier axisLabels
    __axisLabels = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'axisLabels'), 'axisLabels', '__httpwww_opengis_netgml3_2_DirectPositionType_axisLabels', NCNameList)
    
    axisLabels = property(__axisLabels.value, __axisLabels.set, None, None)

    
    # Attribute srsDimension uses Python identifier srsDimension
    __srsDimension = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'srsDimension'), 'srsDimension', '__httpwww_opengis_netgml3_2_DirectPositionType_srsDimension', pyxb.binding.datatypes.positiveInteger)
    
    srsDimension = property(__srsDimension.value, __srsDimension.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __srsName.name() : __srsName,
        __uomLabels.name() : __uomLabels,
        __axisLabels.name() : __axisLabels,
        __srsDimension.name() : __srsDimension
    }
_Namespace_gml.addCategoryObject('typeBinding', u'DirectPositionType', DirectPositionType)


# Complex type TimeIntervalLengthType with content type SIMPLE
class TimeIntervalLengthType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = pyxb.binding.datatypes.decimal
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeIntervalLengthType')
    # Base type is pyxb.binding.datatypes.decimal
    
    # Attribute unit uses Python identifier unit
    __unit = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'unit'), 'unit', '__httpwww_opengis_netgml3_2_TimeIntervalLengthType_unit', TimeUnitType, required=True)
    
    unit = property(__unit.value, __unit.set, None, None)

    
    # Attribute radix uses Python identifier radix
    __radix = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'radix'), 'radix', '__httpwww_opengis_netgml3_2_TimeIntervalLengthType_radix', pyxb.binding.datatypes.positiveInteger)
    
    radix = property(__radix.value, __radix.set, None, None)

    
    # Attribute factor uses Python identifier factor
    __factor = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'factor'), 'factor', '__httpwww_opengis_netgml3_2_TimeIntervalLengthType_factor', pyxb.binding.datatypes.integer)
    
    factor = property(__factor.value, __factor.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __unit.name() : __unit,
        __radix.name() : __radix,
        __factor.name() : __factor
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TimeIntervalLengthType', TimeIntervalLengthType)


# Complex type OperationParameterGroupPropertyType with content type ELEMENT_ONLY
class OperationParameterGroupPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'OperationParameterGroupPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}OperationParameterGroup uses Python identifier OperationParameterGroup
    __OperationParameterGroup = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'OperationParameterGroup'), 'OperationParameterGroup', '__httpwww_opengis_netgml3_2_OperationParameterGroupPropertyType_httpwww_opengis_netgml3_2OperationParameterGroup', False)

    
    OperationParameterGroup = property(__OperationParameterGroup.value, __OperationParameterGroup.set, None, u'gml:OperationParameterGroup is the definition of a group of parameters used by an operation method. This complex type is expected to be used or extended for all applicable operation methods, without defining operation-method-specialized element names.\nThe generalOperationParameter elements are an unordered list of associations to the set of operation parameters that are members of this group.')

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_OperationParameterGroupPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_OperationParameterGroupPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_OperationParameterGroupPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_OperationParameterGroupPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_OperationParameterGroupPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_OperationParameterGroupPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_OperationParameterGroupPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_OperationParameterGroupPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_OperationParameterGroupPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __OperationParameterGroup.name() : __OperationParameterGroup
    }
    _AttributeMap = {
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __arcrole.name() : __arcrole,
        __actuate.name() : __actuate,
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show,
        __href.name() : __href,
        __title.name() : __title,
        __type.name() : __type
    }
_Namespace_gml.addCategoryObject('typeBinding', u'OperationParameterGroupPropertyType', OperationParameterGroupPropertyType)


# Complex type CTD_ANON with content type ELEMENT_ONLY
class CTD_ANON (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = None
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}EX_Extent uses Python identifier EX_Extent
    __EX_Extent = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'EX_Extent'), 'EX_Extent', '__httpwww_opengis_netgml3_2_CTD_ANON_httpwww_isotc211_org2005gmdEX_Extent', False)

    
    EX_Extent = property(__EX_Extent.value, __EX_Extent.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_CTD_ANON_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_CTD_ANON_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_CTD_ANON_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_CTD_ANON_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_CTD_ANON_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_CTD_ANON_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_CTD_ANON_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_CTD_ANON_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CTD_ANON_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __EX_Extent.name() : __EX_Extent
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __href.name() : __href,
        __show.name() : __show,
        __title.name() : __title,
        __role.name() : __role,
        __actuate.name() : __actuate,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason
    }



# Complex type MD_Keywords_Type with content type ELEMENT_ONLY
class MD_Keywords_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Keywords_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}type uses Python identifier type
    __type = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_Keywords_Type_httpwww_isotc211_org2005gmdtype', False)

    
    type = property(__type.value, __type.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}thesaurusName uses Python identifier thesaurusName
    __thesaurusName = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'thesaurusName'), 'thesaurusName', '__httpwww_isotc211_org2005gmd_MD_Keywords_Type_httpwww_isotc211_org2005gmdthesaurusName', False)

    
    thesaurusName = property(__thesaurusName.value, __thesaurusName.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}keyword uses Python identifier keyword
    __keyword = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'keyword'), 'keyword', '__httpwww_isotc211_org2005gmd_MD_Keywords_Type_httpwww_isotc211_org2005gmdkeyword', True)

    
    keyword = property(__keyword.value, __keyword.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __type.name() : __type,
        __thesaurusName.name() : __thesaurusName,
        __keyword.name() : __keyword
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Keywords_Type', MD_Keywords_Type)


# Complex type AbstractGeometricPrimitiveType with content type ELEMENT_ONLY
class AbstractGeometricPrimitiveType (AbstractGeometryType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeometricPrimitiveType')
    # Base type is AbstractGeometryType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType

    _ElementMap = AbstractGeometryType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGeometryType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGeometricPrimitiveType', AbstractGeometricPrimitiveType)


# Complex type AbstractSolidType with content type ELEMENT_ONLY
class AbstractSolidType (AbstractGeometricPrimitiveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractSolidType')
    # Base type is AbstractGeometricPrimitiveType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType

    _ElementMap = AbstractGeometricPrimitiveType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGeometricPrimitiveType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractSolidType', AbstractSolidType)


# Complex type SolidType with content type ELEMENT_ONLY
class SolidType (AbstractSolidType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SolidType')
    # Base type is AbstractSolidType
    
    # Element {http://www.opengis.net/gml/3.2}interior uses Python identifier interior
    __interior = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'interior'), 'interior', '__httpwww_opengis_netgml3_2_SolidType_httpwww_opengis_netgml3_2interior', True)

    
    interior = property(__interior.value, __interior.set, None, None)

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}exterior uses Python identifier exterior
    __exterior = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'exterior'), 'exterior', '__httpwww_opengis_netgml3_2_SolidType_httpwww_opengis_netgml3_2exterior', False)

    
    exterior = property(__exterior.value, __exterior.set, None, None)

    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractSolidType._ElementMap.copy()
    _ElementMap.update({
        __interior.name() : __interior,
        __exterior.name() : __exterior
    })
    _AttributeMap = AbstractSolidType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'SolidType', SolidType)


# Complex type CurvePropertyType with content type ELEMENT_ONLY
class CurvePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CurvePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractCurve uses Python identifier AbstractCurve
    __AbstractCurve = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCurve'), 'AbstractCurve', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_opengis_netgml3_2AbstractCurve', False)

    
    AbstractCurve = property(__AbstractCurve.value, __AbstractCurve.set, None, u'The AbstractCurve element is the abstract head of the substitution group for all (continuous) curve elements.')

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_CurvePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CurvePropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')


    _ElementMap = {
        __AbstractCurve.name() : __AbstractCurve
    }
    _AttributeMap = {
        __actuate.name() : __actuate,
        __owns.name() : __owns,
        __show.name() : __show,
        __role.name() : __role,
        __type.name() : __type,
        __href.name() : __href,
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __remoteSchema.name() : __remoteSchema
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CurvePropertyType', CurvePropertyType)


# Complex type SurfaceArrayPropertyType with content type ELEMENT_ONLY
class SurfaceArrayPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SurfaceArrayPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractSurface uses Python identifier AbstractSurface
    __AbstractSurface = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractSurface'), 'AbstractSurface', '__httpwww_opengis_netgml3_2_SurfaceArrayPropertyType_httpwww_opengis_netgml3_2AbstractSurface', True)

    
    AbstractSurface = property(__AbstractSurface.value, __AbstractSurface.set, None, u'The AbstractSurface element is the abstract head of the substitution group for all (continuous) surface elements.')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_SurfaceArrayPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)


    _ElementMap = {
        __AbstractSurface.name() : __AbstractSurface
    }
    _AttributeMap = {
        __owns.name() : __owns
    }
_Namespace_gml.addCategoryObject('typeBinding', u'SurfaceArrayPropertyType', SurfaceArrayPropertyType)


# Complex type ConcatenatedOperationPropertyType with content type ELEMENT_ONLY
class ConcatenatedOperationPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ConcatenatedOperationPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}ConcatenatedOperation uses Python identifier ConcatenatedOperation
    __ConcatenatedOperation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'ConcatenatedOperation'), 'ConcatenatedOperation', '__httpwww_opengis_netgml3_2_ConcatenatedOperationPropertyType_httpwww_opengis_netgml3_2ConcatenatedOperation', False)

    
    ConcatenatedOperation = property(__ConcatenatedOperation.value, __ConcatenatedOperation.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_ConcatenatedOperationPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_ConcatenatedOperationPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_ConcatenatedOperationPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_ConcatenatedOperationPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_ConcatenatedOperationPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_ConcatenatedOperationPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_ConcatenatedOperationPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_ConcatenatedOperationPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_ConcatenatedOperationPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __ConcatenatedOperation.name() : __ConcatenatedOperation
    }
    _AttributeMap = {
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __actuate.name() : __actuate,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show,
        __href.name() : __href
    }
_Namespace_gml.addCategoryObject('typeBinding', u'ConcatenatedOperationPropertyType', ConcatenatedOperationPropertyType)


# Complex type LanguageCode_PropertyType with content type ELEMENT_ONLY
class LanguageCode_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'LanguageCode_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}LanguageCode uses Python identifier LanguageCode
    __LanguageCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'LanguageCode'), 'LanguageCode', '__httpwww_isotc211_org2005gmd_LanguageCode_PropertyType_httpwww_isotc211_org2005gmdLanguageCode', False)

    
    LanguageCode = property(__LanguageCode.value, __LanguageCode.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_LanguageCode_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __LanguageCode.name() : __LanguageCode
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'LanguageCode_PropertyType', LanguageCode_PropertyType)


# Complex type DirectPositionListType with content type SIMPLE
class DirectPositionListType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = doubleList
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectPositionListType')
    # Base type is doubleList
    
    # Attribute srsName uses Python identifier srsName
    __srsName = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'srsName'), 'srsName', '__httpwww_opengis_netgml3_2_DirectPositionListType_srsName', pyxb.binding.datatypes.anyURI)
    
    srsName = property(__srsName.value, __srsName.set, None, None)

    
    # Attribute srsDimension uses Python identifier srsDimension
    __srsDimension = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'srsDimension'), 'srsDimension', '__httpwww_opengis_netgml3_2_DirectPositionListType_srsDimension', pyxb.binding.datatypes.positiveInteger)
    
    srsDimension = property(__srsDimension.value, __srsDimension.set, None, None)

    
    # Attribute uomLabels uses Python identifier uomLabels
    __uomLabels = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uomLabels'), 'uomLabels', '__httpwww_opengis_netgml3_2_DirectPositionListType_uomLabels', NCNameList)
    
    uomLabels = property(__uomLabels.value, __uomLabels.set, None, None)

    
    # Attribute axisLabels uses Python identifier axisLabels
    __axisLabels = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'axisLabels'), 'axisLabels', '__httpwww_opengis_netgml3_2_DirectPositionListType_axisLabels', NCNameList)
    
    axisLabels = property(__axisLabels.value, __axisLabels.set, None, None)

    
    # Attribute count uses Python identifier count
    __count = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'count'), 'count', '__httpwww_opengis_netgml3_2_DirectPositionListType_count', pyxb.binding.datatypes.positiveInteger)
    
    count = property(__count.value, __count.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __srsName.name() : __srsName,
        __srsDimension.name() : __srsDimension,
        __uomLabels.name() : __uomLabels,
        __axisLabels.name() : __axisLabels,
        __count.name() : __count
    }
_Namespace_gml.addCategoryObject('typeBinding', u'DirectPositionListType', DirectPositionListType)


# Complex type MeasureOrNilReasonListType with content type SIMPLE
class MeasureOrNilReasonListType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = doubleOrNilReasonList
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'MeasureOrNilReasonListType')
    # Base type is doubleOrNilReasonList
    
    # Attribute uom uses Python identifier uom
    __uom = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uom'), 'uom', '__httpwww_opengis_netgml3_2_MeasureOrNilReasonListType_uom', UomIdentifier, required=True)
    
    uom = property(__uom.value, __uom.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __uom.name() : __uom
    }
_Namespace_gml.addCategoryObject('typeBinding', u'MeasureOrNilReasonListType', MeasureOrNilReasonListType)


# Complex type EX_VerticalExtent_PropertyType with content type ELEMENT_ONLY
class EX_VerticalExtent_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'EX_VerticalExtent_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}EX_VerticalExtent uses Python identifier EX_VerticalExtent
    __EX_VerticalExtent = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'EX_VerticalExtent'), 'EX_VerticalExtent', '__httpwww_isotc211_org2005gmd_EX_VerticalExtent_PropertyType_httpwww_isotc211_org2005gmdEX_VerticalExtent', False)

    
    EX_VerticalExtent = property(__EX_VerticalExtent.value, __EX_VerticalExtent.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_EX_VerticalExtent_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_EX_VerticalExtent_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_EX_VerticalExtent_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_EX_VerticalExtent_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_EX_VerticalExtent_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_EX_VerticalExtent_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_EX_VerticalExtent_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_EX_VerticalExtent_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_EX_VerticalExtent_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __EX_VerticalExtent.name() : __EX_VerticalExtent
    }
    _AttributeMap = {
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __uuidref.name() : __uuidref,
        __href.name() : __href,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __title.name() : __title,
        __type.name() : __type
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'EX_VerticalExtent_PropertyType', EX_VerticalExtent_PropertyType)


# Complex type MD_Georeferenceable_Type with content type ELEMENT_ONLY
class MD_Georeferenceable_Type (MD_GridSpatialRepresentation_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Georeferenceable_Type')
    # Base type is MD_GridSpatialRepresentation_Type
    
    # Element {http://www.isotc211.org/2005/gmd}orientationParameterDescription uses Python identifier orientationParameterDescription
    __orientationParameterDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'orientationParameterDescription'), 'orientationParameterDescription', '__httpwww_isotc211_org2005gmd_MD_Georeferenceable_Type_httpwww_isotc211_org2005gmdorientationParameterDescription', False)

    
    orientationParameterDescription = property(__orientationParameterDescription.value, __orientationParameterDescription.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}georeferencedParameters uses Python identifier georeferencedParameters
    __georeferencedParameters = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'georeferencedParameters'), 'georeferencedParameters', '__httpwww_isotc211_org2005gmd_MD_Georeferenceable_Type_httpwww_isotc211_org2005gmdgeoreferencedParameters', False)

    
    georeferencedParameters = property(__georeferencedParameters.value, __georeferencedParameters.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}parameterCitation uses Python identifier parameterCitation
    __parameterCitation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'parameterCitation'), 'parameterCitation', '__httpwww_isotc211_org2005gmd_MD_Georeferenceable_Type_httpwww_isotc211_org2005gmdparameterCitation', True)

    
    parameterCitation = property(__parameterCitation.value, __parameterCitation.set, None, None)

    
    # Element numberOfDimensions ({http://www.isotc211.org/2005/gmd}numberOfDimensions) inherited from {http://www.isotc211.org/2005/gmd}MD_GridSpatialRepresentation_Type
    
    # Element axisDimensionProperties ({http://www.isotc211.org/2005/gmd}axisDimensionProperties) inherited from {http://www.isotc211.org/2005/gmd}MD_GridSpatialRepresentation_Type
    
    # Element {http://www.isotc211.org/2005/gmd}controlPointAvailability uses Python identifier controlPointAvailability
    __controlPointAvailability = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'controlPointAvailability'), 'controlPointAvailability', '__httpwww_isotc211_org2005gmd_MD_Georeferenceable_Type_httpwww_isotc211_org2005gmdcontrolPointAvailability', False)

    
    controlPointAvailability = property(__controlPointAvailability.value, __controlPointAvailability.set, None, None)

    
    # Element cellGeometry ({http://www.isotc211.org/2005/gmd}cellGeometry) inherited from {http://www.isotc211.org/2005/gmd}MD_GridSpatialRepresentation_Type
    
    # Element transformationParameterAvailability ({http://www.isotc211.org/2005/gmd}transformationParameterAvailability) inherited from {http://www.isotc211.org/2005/gmd}MD_GridSpatialRepresentation_Type
    
    # Element {http://www.isotc211.org/2005/gmd}orientationParameterAvailability uses Python identifier orientationParameterAvailability
    __orientationParameterAvailability = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'orientationParameterAvailability'), 'orientationParameterAvailability', '__httpwww_isotc211_org2005gmd_MD_Georeferenceable_Type_httpwww_isotc211_org2005gmdorientationParameterAvailability', False)

    
    orientationParameterAvailability = property(__orientationParameterAvailability.value, __orientationParameterAvailability.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = MD_GridSpatialRepresentation_Type._ElementMap.copy()
    _ElementMap.update({
        __orientationParameterDescription.name() : __orientationParameterDescription,
        __georeferencedParameters.name() : __georeferencedParameters,
        __parameterCitation.name() : __parameterCitation,
        __controlPointAvailability.name() : __controlPointAvailability,
        __orientationParameterAvailability.name() : __orientationParameterAvailability
    })
    _AttributeMap = MD_GridSpatialRepresentation_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Georeferenceable_Type', MD_Georeferenceable_Type)


# Complex type CoverageFunctionType with content type ELEMENT_ONLY
class CoverageFunctionType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CoverageFunctionType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}CoverageMappingRule uses Python identifier CoverageMappingRule
    __CoverageMappingRule = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'CoverageMappingRule'), 'CoverageMappingRule', '__httpwww_opengis_netgml3_2_CoverageFunctionType_httpwww_opengis_netgml3_2CoverageMappingRule', False)

    
    CoverageMappingRule = property(__CoverageMappingRule.value, __CoverageMappingRule.set, None, u"gml:CoverageMappingRule provides a formal or informal description of the coverage function.\nThe mapping rule may be defined as an in-line string (gml:ruleDefinition) or via a remote reference through xlink:href (gml:ruleReference).  \nIf no rule name is specified, the default is 'Linear' with respect to members of the domain in document order.")

    
    # Element {http://www.opengis.net/gml/3.2}GridFunction uses Python identifier GridFunction
    __GridFunction = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'GridFunction'), 'GridFunction', '__httpwww_opengis_netgml3_2_CoverageFunctionType_httpwww_opengis_netgml3_2GridFunction', False)

    
    GridFunction = property(__GridFunction.value, __GridFunction.set, None, u'gml:GridFunction provides an explicit mapping rule for grid geometries, i.e. the domain shall be a geometry of type grid.  It describes the mapping of grid posts (discrete point grid coverage) or grid cells (discrete surface coverage) to the values in the range set.\nThe gml:startPoint is the index position of a point in the grid that is mapped to the first point in the range set (this is also the index position of the first grid post).  If the gml:startPoint property is omitted the gml:startPoint is assumed to be equal to the value of gml:low in the gml:Grid geometry. Subsequent points in the mapping are determined by the value of the gml:sequenceRule.')

    
    # Element {http://www.opengis.net/gml/3.2}MappingRule uses Python identifier MappingRule
    __MappingRule = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'MappingRule'), 'MappingRule', '__httpwww_opengis_netgml3_2_CoverageFunctionType_httpwww_opengis_netgml3_2MappingRule', False)

    
    MappingRule = property(__MappingRule.value, __MappingRule.set, None, u'')


    _ElementMap = {
        __CoverageMappingRule.name() : __CoverageMappingRule,
        __GridFunction.name() : __GridFunction,
        __MappingRule.name() : __MappingRule
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CoverageFunctionType', CoverageFunctionType)


# Complex type AbstractDQ_TemporalAccuracy_Type with content type ELEMENT_ONLY
class AbstractDQ_TemporalAccuracy_Type (AbstractDQ_Element_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDQ_TemporalAccuracy_Type')
    # Base type is AbstractDQ_Element_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_Element_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_Element_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractDQ_TemporalAccuracy_Type', AbstractDQ_TemporalAccuracy_Type)


# Complex type DQ_TemporalValidity_Type with content type ELEMENT_ONLY
class DQ_TemporalValidity_Type (AbstractDQ_TemporalAccuracy_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_TemporalValidity_Type')
    # Base type is AbstractDQ_TemporalAccuracy_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_TemporalAccuracy_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_TemporalAccuracy_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_TemporalValidity_Type', DQ_TemporalValidity_Type)


# Complex type MD_Identifier_Type with content type ELEMENT_ONLY
class MD_Identifier_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Identifier_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}authority uses Python identifier authority
    __authority = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'authority'), 'authority', '__httpwww_isotc211_org2005gmd_MD_Identifier_Type_httpwww_isotc211_org2005gmdauthority', False)

    
    authority = property(__authority.value, __authority.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}code uses Python identifier code
    __code = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'code'), 'code', '__httpwww_isotc211_org2005gmd_MD_Identifier_Type_httpwww_isotc211_org2005gmdcode', False)

    
    code = property(__code.value, __code.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __authority.name() : __authority,
        __code.name() : __code
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Identifier_Type', MD_Identifier_Type)


# Complex type PointType with content type ELEMENT_ONLY
class PointType (AbstractGeometricPrimitiveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'PointType')
    # Base type is AbstractGeometricPrimitiveType
    
    # Element {http://www.opengis.net/gml/3.2}pos uses Python identifier pos
    __pos = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pos'), 'pos', '__httpwww_opengis_netgml3_2_PointType_httpwww_opengis_netgml3_2pos', False)

    
    pos = property(__pos.value, __pos.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}coordinates uses Python identifier coordinates
    __coordinates = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coordinates'), 'coordinates', '__httpwww_opengis_netgml3_2_PointType_httpwww_opengis_netgml3_2coordinates', False)

    
    coordinates = property(__coordinates.value, __coordinates.set, None, u'')

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType

    _ElementMap = AbstractGeometricPrimitiveType._ElementMap.copy()
    _ElementMap.update({
        __pos.name() : __pos,
        __coordinates.name() : __coordinates
    })
    _AttributeMap = AbstractGeometricPrimitiveType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'PointType', PointType)


# Complex type ScopedName_PropertyType with content type ELEMENT_ONLY
class ScopedName_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'ScopedName_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}ScopedName uses Python identifier ScopedName
    __ScopedName = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'ScopedName'), 'ScopedName', '__httpwww_isotc211_org2005gco_ScopedName_PropertyType_httpwww_isotc211_org2005gcoScopedName', False)

    
    ScopedName = property(__ScopedName.value, __ScopedName.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_ScopedName_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __ScopedName.name() : __ScopedName
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'ScopedName_PropertyType', ScopedName_PropertyType)


# Complex type PT_FreeText_Type with content type ELEMENT_ONLY
class PT_FreeText_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'PT_FreeText_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}textGroup uses Python identifier textGroup
    __textGroup = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'textGroup'), 'textGroup', '__httpwww_isotc211_org2005gmd_PT_FreeText_Type_httpwww_isotc211_org2005gmdtextGroup', True)

    
    textGroup = property(__textGroup.value, __textGroup.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __textGroup.name() : __textGroup
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'PT_FreeText_Type', PT_FreeText_Type)


# Complex type MD_Constraints_PropertyType with content type ELEMENT_ONLY
class MD_Constraints_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Constraints_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_Constraints uses Python identifier MD_Constraints
    __MD_Constraints = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Constraints'), 'MD_Constraints', '__httpwww_isotc211_org2005gmd_MD_Constraints_PropertyType_httpwww_isotc211_org2005gmdMD_Constraints', False)

    
    MD_Constraints = property(__MD_Constraints.value, __MD_Constraints.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_Constraints_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_Constraints_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_Constraints_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_Constraints_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_Constraints_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_Constraints_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_Constraints_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_Constraints_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_Constraints_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __MD_Constraints.name() : __MD_Constraints
    }
    _AttributeMap = {
        __arcrole.name() : __arcrole,
        __show.name() : __show,
        __nilReason.name() : __nilReason,
        __uuidref.name() : __uuidref,
        __role.name() : __role,
        __title.name() : __title,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __type.name() : __type
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Constraints_PropertyType', MD_Constraints_PropertyType)


# Complex type AbstractCurveSegmentType with content type EMPTY
class AbstractCurveSegmentType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCurveSegmentType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Attribute numDerivativeInterior uses Python identifier numDerivativeInterior
    __numDerivativeInterior = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'numDerivativeInterior'), 'numDerivativeInterior', '__httpwww_opengis_netgml3_2_AbstractCurveSegmentType_numDerivativeInterior', pyxb.binding.datatypes.integer, unicode_default=u'0')
    
    numDerivativeInterior = property(__numDerivativeInterior.value, __numDerivativeInterior.set, None, None)

    
    # Attribute numDerivativesAtEnd uses Python identifier numDerivativesAtEnd
    __numDerivativesAtEnd = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'numDerivativesAtEnd'), 'numDerivativesAtEnd', '__httpwww_opengis_netgml3_2_AbstractCurveSegmentType_numDerivativesAtEnd', pyxb.binding.datatypes.integer, unicode_default=u'0')
    
    numDerivativesAtEnd = property(__numDerivativesAtEnd.value, __numDerivativesAtEnd.set, None, None)

    
    # Attribute numDerivativesAtStart uses Python identifier numDerivativesAtStart
    __numDerivativesAtStart = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'numDerivativesAtStart'), 'numDerivativesAtStart', '__httpwww_opengis_netgml3_2_AbstractCurveSegmentType_numDerivativesAtStart', pyxb.binding.datatypes.integer, unicode_default=u'0')
    
    numDerivativesAtStart = property(__numDerivativesAtStart.value, __numDerivativesAtStart.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __numDerivativeInterior.name() : __numDerivativeInterior,
        __numDerivativesAtEnd.name() : __numDerivativesAtEnd,
        __numDerivativesAtStart.name() : __numDerivativesAtStart
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractCurveSegmentType', AbstractCurveSegmentType)


# Complex type LineStringSegmentType with content type ELEMENT_ONLY
class LineStringSegmentType (AbstractCurveSegmentType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'LineStringSegmentType')
    # Base type is AbstractCurveSegmentType
    
    # Element {http://www.opengis.net/gml/3.2}coordinates uses Python identifier coordinates
    __coordinates = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coordinates'), 'coordinates', '__httpwww_opengis_netgml3_2_LineStringSegmentType_httpwww_opengis_netgml3_2coordinates', False)

    
    coordinates = property(__coordinates.value, __coordinates.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}pointRep uses Python identifier pointRep
    __pointRep = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pointRep'), 'pointRep', '__httpwww_opengis_netgml3_2_LineStringSegmentType_httpwww_opengis_netgml3_2pointRep', True)

    
    pointRep = property(__pointRep.value, __pointRep.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}posList uses Python identifier posList
    __posList = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'posList'), 'posList', '__httpwww_opengis_netgml3_2_LineStringSegmentType_httpwww_opengis_netgml3_2posList', False)

    
    posList = property(__posList.value, __posList.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}pointProperty uses Python identifier pointProperty
    __pointProperty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pointProperty'), 'pointProperty', '__httpwww_opengis_netgml3_2_LineStringSegmentType_httpwww_opengis_netgml3_2pointProperty', True)

    
    pointProperty = property(__pointProperty.value, __pointProperty.set, None, u'This property element either references a point via the XLink-attributes or contains the point element. pointProperty is the predefined property which may be used by GML Application Schemas whenever a GML feature has a property with a value that is substitutable for Point.')

    
    # Element {http://www.opengis.net/gml/3.2}pos uses Python identifier pos
    __pos = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pos'), 'pos', '__httpwww_opengis_netgml3_2_LineStringSegmentType_httpwww_opengis_netgml3_2pos', True)

    
    pos = property(__pos.value, __pos.set, None, None)

    
    # Attribute numDerivativesAtStart inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType
    
    # Attribute numDerivativesAtEnd inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType
    
    # Attribute interpolation uses Python identifier interpolation
    __interpolation = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'interpolation'), 'interpolation', '__httpwww_opengis_netgml3_2_LineStringSegmentType_interpolation', CurveInterpolationType, fixed=True, unicode_default=u'linear')
    
    interpolation = property(__interpolation.value, __interpolation.set, None, None)

    
    # Attribute numDerivativeInterior inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType

    _ElementMap = AbstractCurveSegmentType._ElementMap.copy()
    _ElementMap.update({
        __coordinates.name() : __coordinates,
        __pointRep.name() : __pointRep,
        __posList.name() : __posList,
        __pointProperty.name() : __pointProperty,
        __pos.name() : __pos
    })
    _AttributeMap = AbstractCurveSegmentType._AttributeMap.copy()
    _AttributeMap.update({
        __interpolation.name() : __interpolation
    })
_Namespace_gml.addCategoryObject('typeBinding', u'LineStringSegmentType', LineStringSegmentType)


# Complex type CI_ResponsibleParty_PropertyType with content type ELEMENT_ONLY
class CI_ResponsibleParty_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_ResponsibleParty_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}CI_ResponsibleParty uses Python identifier CI_ResponsibleParty
    __CI_ResponsibleParty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_ResponsibleParty'), 'CI_ResponsibleParty', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_isotc211_org2005gmdCI_ResponsibleParty', False)

    
    CI_ResponsibleParty = property(__CI_ResponsibleParty.value, __CI_ResponsibleParty.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __CI_ResponsibleParty.name() : __CI_ResponsibleParty
    }
    _AttributeMap = {
        __type.name() : __type,
        __nilReason.name() : __nilReason,
        __arcrole.name() : __arcrole,
        __title.name() : __title,
        __role.name() : __role,
        __uuidref.name() : __uuidref,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __href.name() : __href
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_ResponsibleParty_PropertyType', CI_ResponsibleParty_PropertyType)


# Complex type AbstractFeatureType with content type ELEMENT_ONLY
class AbstractFeatureType (AbstractGMLType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractFeatureType')
    # Base type is AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}boundedBy uses Python identifier boundedBy
    __boundedBy = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'boundedBy'), 'boundedBy', '__httpwww_opengis_netgml3_2_AbstractFeatureType_httpwww_opengis_netgml3_2boundedBy', False)

    
    boundedBy = property(__boundedBy.value, __boundedBy.set, None, u'This property describes the minimum bounding box or rectangle that encloses the entire feature.')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}location uses Python identifier location
    __location = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'location'), 'location', '__httpwww_opengis_netgml3_2_AbstractFeatureType_httpwww_opengis_netgml3_2location', False)

    
    location = property(__location.value, __location.set, None, u'')

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractGMLType._ElementMap.copy()
    _ElementMap.update({
        __boundedBy.name() : __boundedBy,
        __location.name() : __location
    })
    _AttributeMap = AbstractGMLType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractFeatureType', AbstractFeatureType)


# Complex type AbstractCoverageType with content type ELEMENT_ONLY
class AbstractCoverageType (AbstractFeatureType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCoverageType')
    # Base type is AbstractFeatureType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}domainSet uses Python identifier domainSet
    __domainSet = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'domainSet'), 'domainSet', '__httpwww_opengis_netgml3_2_AbstractCoverageType_httpwww_opengis_netgml3_2domainSet', False)

    
    domainSet = property(__domainSet.value, __domainSet.set, None, u'The gml:domainSet property element describes the spatio-temporal region of interest, within which the coverage is defined. Its content model is given by gml:DomainSetType.\nThe value of the domain is thus a choice between a gml:AbstractGeometry and a gml:AbstractTimeObject.  In the instance these abstract elements will normally be substituted by a geometry complex or temporal complex, to represent spatial coverages and time-series, respectively.  \nThe presence of the gml:AssociationAttributeGroup means that domainSet follows the usual GML property model and may use the xlink:href attribute to point to the domain, as an alternative to describing the domain inline. Ownership semantics may be provided using the gml:OwnershipAttributeGroup.\n')

    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}rangeSet uses Python identifier rangeSet
    __rangeSet = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'rangeSet'), 'rangeSet', '__httpwww_opengis_netgml3_2_AbstractCoverageType_httpwww_opengis_netgml3_2rangeSet', False)

    
    rangeSet = property(__rangeSet.value, __rangeSet.set, None, u'The gml:rangeSet property element contains the values of the coverage (sometimes called the attribute values).  Its content model is given by gml:RangeSetType.\nThis content model supports a structural description of the range.  The semantic information describing the range set is embedded using a uniform method, as part of the explicit values, or as a template value accompanying the representation using gml:DataBlock and gml:File.\nThe values from each component (or "band") in the range may be encoded within a gml:ValueArray element or a concrete member of the gml:AbstractScalarValueList substitution group . Use of these elements satisfies the value-type homogeneity requirement.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element boundedBy ({http://www.opengis.net/gml/3.2}boundedBy) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element location ({http://www.opengis.net/gml/3.2}location) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractFeatureType._ElementMap.copy()
    _ElementMap.update({
        __domainSet.name() : __domainSet,
        __rangeSet.name() : __rangeSet
    })
    _AttributeMap = AbstractFeatureType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractCoverageType', AbstractCoverageType)


# Complex type DiscreteCoverageType with content type ELEMENT_ONLY
class DiscreteCoverageType (AbstractCoverageType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DiscreteCoverageType')
    # Base type is AbstractCoverageType
    
    # Element domainSet ({http://www.opengis.net/gml/3.2}domainSet) inherited from {http://www.opengis.net/gml/3.2}AbstractCoverageType
    
    # Element {http://www.opengis.net/gml/3.2}coverageFunction uses Python identifier coverageFunction
    __coverageFunction = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coverageFunction'), 'coverageFunction', '__httpwww_opengis_netgml3_2_DiscreteCoverageType_httpwww_opengis_netgml3_2coverageFunction', False)

    
    coverageFunction = property(__coverageFunction.value, __coverageFunction.set, None, u'The gml:coverageFunction property describes the mapping function from the domain to the range of the coverage.\nThe value of the CoverageFunction is one of gml:CoverageMappingRule and gml:GridFunction.\nIf the gml:coverageFunction property is omitted for a gridded coverage (including rectified gridded coverages) the gml:startPoint is assumed to be the value of the gml:low property in the gml:Grid geometry, and the gml:sequenceRule is assumed to be linear and the gml:axisOrder property is assumed to be "+1 +2".')

    
    # Element rangeSet ({http://www.opengis.net/gml/3.2}rangeSet) inherited from {http://www.opengis.net/gml/3.2}AbstractCoverageType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element boundedBy ({http://www.opengis.net/gml/3.2}boundedBy) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element location ({http://www.opengis.net/gml/3.2}location) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractCoverageType._ElementMap.copy()
    _ElementMap.update({
        __coverageFunction.name() : __coverageFunction
    })
    _AttributeMap = AbstractCoverageType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'DiscreteCoverageType', DiscreteCoverageType)


# Complex type CI_Telephone_PropertyType with content type ELEMENT_ONLY
class CI_Telephone_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_Telephone_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}CI_Telephone uses Python identifier CI_Telephone
    __CI_Telephone = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_Telephone'), 'CI_Telephone', '__httpwww_isotc211_org2005gmd_CI_Telephone_PropertyType_httpwww_isotc211_org2005gmdCI_Telephone', False)

    
    CI_Telephone = property(__CI_Telephone.value, __CI_Telephone.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_CI_Telephone_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_CI_Telephone_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_CI_Telephone_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_CI_Telephone_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_CI_Telephone_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_CI_Telephone_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_CI_Telephone_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_CI_Telephone_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_CI_Telephone_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __CI_Telephone.name() : __CI_Telephone
    }
    _AttributeMap = {
        __type.name() : __type,
        __href.name() : __href,
        __show.name() : __show,
        __nilReason.name() : __nilReason,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __uuidref.name() : __uuidref,
        __title.name() : __title,
        __actuate.name() : __actuate
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_Telephone_PropertyType', CI_Telephone_PropertyType)


# Complex type DS_ProductionSeries_PropertyType with content type ELEMENT_ONLY
class DS_ProductionSeries_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DS_ProductionSeries_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}DS_ProductionSeries uses Python identifier DS_ProductionSeries
    __DS_ProductionSeries = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'DS_ProductionSeries'), 'DS_ProductionSeries', '__httpwww_isotc211_org2005gmd_DS_ProductionSeries_PropertyType_httpwww_isotc211_org2005gmdDS_ProductionSeries', False)

    
    DS_ProductionSeries = property(__DS_ProductionSeries.value, __DS_ProductionSeries.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_DS_ProductionSeries_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_DS_ProductionSeries_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_DS_ProductionSeries_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DS_ProductionSeries_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_DS_ProductionSeries_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_DS_ProductionSeries_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_DS_ProductionSeries_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_DS_ProductionSeries_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_DS_ProductionSeries_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __DS_ProductionSeries.name() : __DS_ProductionSeries
    }
    _AttributeMap = {
        __role.name() : __role,
        __title.name() : __title,
        __uuidref.name() : __uuidref,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __show.name() : __show,
        __type.name() : __type,
        __arcrole.name() : __arcrole
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DS_ProductionSeries_PropertyType', DS_ProductionSeries_PropertyType)


# Complex type DQ_ConceptualConsistency_Type with content type ELEMENT_ONLY
class DQ_ConceptualConsistency_Type (AbstractDQ_LogicalConsistency_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_ConceptualConsistency_Type')
    # Base type is AbstractDQ_LogicalConsistency_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_LogicalConsistency_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_LogicalConsistency_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_ConceptualConsistency_Type', DQ_ConceptualConsistency_Type)


# Complex type AbstractSurfaceType with content type ELEMENT_ONLY
class AbstractSurfaceType (AbstractGeometricPrimitiveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractSurfaceType')
    # Base type is AbstractGeometricPrimitiveType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType

    _ElementMap = AbstractGeometricPrimitiveType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGeometricPrimitiveType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractSurfaceType', AbstractSurfaceType)


# Complex type SurfaceType with content type ELEMENT_ONLY
class SurfaceType (AbstractSurfaceType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SurfaceType')
    # Base type is AbstractSurfaceType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}patches uses Python identifier patches
    __patches = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'patches'), 'patches', '__httpwww_opengis_netgml3_2_SurfaceType_httpwww_opengis_netgml3_2patches', False)

    
    patches = property(__patches.value, __patches.set, None, u'The patches property element contains the sequence of surface patches. The order of the elements is significant and shall be preserved when processing the array.')

    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractSurfaceType._ElementMap.copy()
    _ElementMap.update({
        __patches.name() : __patches
    })
    _AttributeMap = AbstractSurfaceType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'SurfaceType', SurfaceType)


# Complex type DQ_TemporalAccuracy_PropertyType with content type ELEMENT_ONLY
class DQ_TemporalAccuracy_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_TemporalAccuracy_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}AbstractDQ_TemporalAccuracy uses Python identifier AbstractDQ_TemporalAccuracy
    __AbstractDQ_TemporalAccuracy = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDQ_TemporalAccuracy'), 'AbstractDQ_TemporalAccuracy', '__httpwww_isotc211_org2005gmd_DQ_TemporalAccuracy_PropertyType_httpwww_isotc211_org2005gmdAbstractDQ_TemporalAccuracy', False)

    
    AbstractDQ_TemporalAccuracy = property(__AbstractDQ_TemporalAccuracy.value, __AbstractDQ_TemporalAccuracy.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_DQ_TemporalAccuracy_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DQ_TemporalAccuracy_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_DQ_TemporalAccuracy_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_DQ_TemporalAccuracy_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_DQ_TemporalAccuracy_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_DQ_TemporalAccuracy_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_DQ_TemporalAccuracy_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_DQ_TemporalAccuracy_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_DQ_TemporalAccuracy_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __AbstractDQ_TemporalAccuracy.name() : __AbstractDQ_TemporalAccuracy
    }
    _AttributeMap = {
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __show.name() : __show,
        __uuidref.name() : __uuidref,
        __arcrole.name() : __arcrole,
        __title.name() : __title,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __type.name() : __type
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_TemporalAccuracy_PropertyType', DQ_TemporalAccuracy_PropertyType)


# Complex type Boolean_PropertyType with content type ELEMENT_ONLY
class Boolean_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Boolean_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}Boolean uses Python identifier Boolean
    __Boolean = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'Boolean'), 'Boolean', '__httpwww_isotc211_org2005gco_Boolean_PropertyType_httpwww_isotc211_org2005gcoBoolean', False)

    
    Boolean = property(__Boolean.value, __Boolean.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_Boolean_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __Boolean.name() : __Boolean
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'Boolean_PropertyType', Boolean_PropertyType)


# Complex type TopoPointType with content type ELEMENT_ONLY
class TopoPointType (AbstractTopologyType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TopoPointType')
    # Base type is AbstractTopologyType
    
    # Element {http://www.opengis.net/gml/3.2}directedNode uses Python identifier directedNode
    __directedNode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'directedNode'), 'directedNode', '__httpwww_opengis_netgml3_2_TopoPointType_httpwww_opengis_netgml3_2directedNode', False)

    
    directedNode = property(__directedNode.value, __directedNode.set, None, u'A gml:directedNode property element describes the boundary of topology edges and is used in the support of topological point features via the gml:TopoPoint expression, see below. The orientation attribute of type gml:SignType expresses the sense in which the included node is used: start ("-") or end ("+") node.')

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTopologyType._ElementMap.copy()
    _ElementMap.update({
        __directedNode.name() : __directedNode
    })
    _AttributeMap = AbstractTopologyType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TopoPointType', TopoPointType)


# Complex type DQ_Scope_Type with content type ELEMENT_ONLY
class DQ_Scope_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_Scope_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}levelDescription uses Python identifier levelDescription
    __levelDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'levelDescription'), 'levelDescription', '__httpwww_isotc211_org2005gmd_DQ_Scope_Type_httpwww_isotc211_org2005gmdlevelDescription', True)

    
    levelDescription = property(__levelDescription.value, __levelDescription.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}level uses Python identifier level
    __level = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'level'), 'level', '__httpwww_isotc211_org2005gmd_DQ_Scope_Type_httpwww_isotc211_org2005gmdlevel', False)

    
    level = property(__level.value, __level.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}extent uses Python identifier extent
    __extent = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'extent'), 'extent', '__httpwww_isotc211_org2005gmd_DQ_Scope_Type_httpwww_isotc211_org2005gmdextent', False)

    
    extent = property(__extent.value, __extent.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __levelDescription.name() : __levelDescription,
        __level.name() : __level,
        __extent.name() : __extent
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_Scope_Type', DQ_Scope_Type)


# Complex type MultiGeometryPropertyType with content type ELEMENT_ONLY
class MultiGeometryPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'MultiGeometryPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractGeometricAggregate uses Python identifier AbstractGeometricAggregate
    __AbstractGeometricAggregate = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeometricAggregate'), 'AbstractGeometricAggregate', '__httpwww_opengis_netgml3_2_MultiGeometryPropertyType_httpwww_opengis_netgml3_2AbstractGeometricAggregate', False)

    
    AbstractGeometricAggregate = property(__AbstractGeometricAggregate.value, __AbstractGeometricAggregate.set, None, u'gml:AbstractGeometricAggregate is the abstract head of the substitution group for all geometric aggregates.')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_MultiGeometryPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_MultiGeometryPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_MultiGeometryPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_MultiGeometryPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_MultiGeometryPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_MultiGeometryPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_MultiGeometryPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_MultiGeometryPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_MultiGeometryPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_MultiGeometryPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')


    _ElementMap = {
        __AbstractGeometricAggregate.name() : __AbstractGeometricAggregate
    }
    _AttributeMap = {
        __owns.name() : __owns,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __title.name() : __title,
        __role.name() : __role,
        __href.name() : __href,
        __arcrole.name() : __arcrole,
        __type.name() : __type,
        __nilReason.name() : __nilReason,
        __remoteSchema.name() : __remoteSchema
    }
_Namespace_gml.addCategoryObject('typeBinding', u'MultiGeometryPropertyType', MultiGeometryPropertyType)


# Complex type TemporalCSPropertyType with content type ELEMENT_ONLY
class TemporalCSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TemporalCSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TemporalCS uses Python identifier TemporalCS
    __TemporalCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TemporalCS'), 'TemporalCS', '__httpwww_opengis_netgml3_2_TemporalCSPropertyType_httpwww_opengis_netgml3_2TemporalCS', False)

    
    TemporalCS = property(__TemporalCS.value, __TemporalCS.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TemporalCSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TemporalCSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TemporalCSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TemporalCSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TemporalCSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TemporalCSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TemporalCSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TemporalCSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TemporalCSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __TemporalCS.name() : __TemporalCS
    }
    _AttributeMap = {
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __show.name() : __show,
        __role.name() : __role,
        __title.name() : __title,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __remoteSchema.name() : __remoteSchema,
        __href.name() : __href
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TemporalCSPropertyType', TemporalCSPropertyType)


# Complex type UnlimitedInteger_Type with content type SIMPLE
class UnlimitedInteger_Type (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = pyxb.binding.datatypes.nonNegativeInteger
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'UnlimitedInteger_Type')
    # Base type is pyxb.binding.datatypes.nonNegativeInteger
    
    # Attribute isInfinite uses Python identifier isInfinite
    __isInfinite = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'isInfinite'), 'isInfinite', '__httpwww_isotc211_org2005gco_UnlimitedInteger_Type_isInfinite', pyxb.binding.datatypes.boolean)
    
    isInfinite = property(__isInfinite.value, __isInfinite.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __isInfinite.name() : __isInfinite
    }
_Namespace_gco.addCategoryObject('typeBinding', u'UnlimitedInteger_Type', UnlimitedInteger_Type)


# Complex type MD_ContentInformation_PropertyType with content type ELEMENT_ONLY
class MD_ContentInformation_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ContentInformation_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}AbstractMD_ContentInformation uses Python identifier AbstractMD_ContentInformation
    __AbstractMD_ContentInformation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractMD_ContentInformation'), 'AbstractMD_ContentInformation', '__httpwww_isotc211_org2005gmd_MD_ContentInformation_PropertyType_httpwww_isotc211_org2005gmdAbstractMD_ContentInformation', False)

    
    AbstractMD_ContentInformation = property(__AbstractMD_ContentInformation.value, __AbstractMD_ContentInformation.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_ContentInformation_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_ContentInformation_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_ContentInformation_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_ContentInformation_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_ContentInformation_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_ContentInformation_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_ContentInformation_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_ContentInformation_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_ContentInformation_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __AbstractMD_ContentInformation.name() : __AbstractMD_ContentInformation
    }
    _AttributeMap = {
        __show.name() : __show,
        __href.name() : __href,
        __type.name() : __type,
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __role.name() : __role,
        __uuidref.name() : __uuidref,
        __actuate.name() : __actuate
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_ContentInformation_PropertyType', MD_ContentInformation_PropertyType)


# Complex type AbstractCoordinateSystemType with content type ELEMENT_ONLY
class AbstractCoordinateSystemType (IdentifiedObjectType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCoordinateSystemType')
    # Base type is IdentifiedObjectType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}axis uses Python identifier axis
    __axis = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'axis'), 'axis', '__httpwww_opengis_netgml3_2_AbstractCoordinateSystemType_httpwww_opengis_netgml3_2axis', True)

    
    axis = property(__axis.value, __axis.set, None, u'The gml:axis property is an association role (ordered sequence) to the coordinate system axes included in this coordinate system. The coordinate values in a coordinate tuple shall be recorded in the order in which the coordinate system axes associations are recorded, whenever those coordinates use a coordinate reference system that uses this coordinate system. The gml:AggregationAttributeGroup should be used to specify that the axis objects are ordered.')

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_AbstractCoordinateSystemType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)

    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = IdentifiedObjectType._ElementMap.copy()
    _ElementMap.update({
        __axis.name() : __axis
    })
    _AttributeMap = IdentifiedObjectType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractCoordinateSystemType', AbstractCoordinateSystemType)


# Complex type LinearCSType with content type ELEMENT_ONLY
class LinearCSType (AbstractCoordinateSystemType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'LinearCSType')
    # Base type is AbstractCoordinateSystemType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element axis ({http://www.opengis.net/gml/3.2}axis) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute aggregationType inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCoordinateSystemType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractCoordinateSystemType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'LinearCSType', LinearCSType)


# Complex type TargetPropertyType with content type ELEMENT_ONLY
class TargetPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TargetPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractGeometry uses Python identifier AbstractGeometry
    __AbstractGeometry = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeometry'), 'AbstractGeometry', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_opengis_netgml3_2AbstractGeometry', False)

    
    AbstractGeometry = property(__AbstractGeometry.value, __AbstractGeometry.set, None, u'The AbstractGeometry element is the abstract head of the substitution group for all geometry elements of GML. This includes pre-defined and user-defined geometry elements. Any geometry element shall be a direct or indirect extension/restriction of AbstractGeometryType and shall be directly or indirectly in the substitution group of AbstractGeometry.')

    
    # Element {http://www.opengis.net/gml/3.2}AbstractFeature uses Python identifier AbstractFeature
    __AbstractFeature = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractFeature'), 'AbstractFeature', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_opengis_netgml3_2AbstractFeature', False)

    
    AbstractFeature = property(__AbstractFeature.value, __AbstractFeature.set, None, u'This abstract element serves as the head of a substitution group which may contain any elements whose content model is derived from gml:AbstractFeatureType.  This may be used as a variable in the construction of content models.  \ngml:AbstractFeature may be thought of as "anything that is a GML feature" and may be used to define variables or templates in which the value of a GML property is "any feature". This occurs in particular in a GML feature collection where the feature member properties contain one or multiple copies of gml:AbstractFeature respectively.')

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TargetPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_TargetPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __AbstractGeometry.name() : __AbstractGeometry,
        __AbstractFeature.name() : __AbstractFeature
    }
    _AttributeMap = {
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __show.name() : __show,
        __nilReason.name() : __nilReason,
        __role.name() : __role,
        __remoteSchema.name() : __remoteSchema,
        __title.name() : __title,
        __owns.name() : __owns,
        __actuate.name() : __actuate,
        __href.name() : __href
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TargetPropertyType', TargetPropertyType)


# Complex type Real_PropertyType with content type ELEMENT_ONLY
class Real_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Real_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}Real uses Python identifier Real
    __Real = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'Real'), 'Real', '__httpwww_isotc211_org2005gco_Real_PropertyType_httpwww_isotc211_org2005gcoReal', False)

    
    Real = property(__Real.value, __Real.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_Real_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __Real.name() : __Real
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'Real_PropertyType', Real_PropertyType)


# Complex type OperationParameterPropertyType with content type ELEMENT_ONLY
class OperationParameterPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'OperationParameterPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}OperationParameter uses Python identifier OperationParameter
    __OperationParameter = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'OperationParameter'), 'OperationParameter', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_opengis_netgml3_2OperationParameter', False)

    
    OperationParameter = property(__OperationParameter.value, __OperationParameter.set, None, u'gml:OperationParameter is the definition of a parameter used by an operation method. Most parameter values are numeric, but other types of parameter values are possible. This complex type is expected to be used or extended for all operation methods, without defining operation-method-specialized element names.')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __OperationParameter.name() : __OperationParameter
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show,
        __href.name() : __href,
        __title.name() : __title,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __type.name() : __type
    }
_Namespace_gml.addCategoryObject('typeBinding', u'OperationParameterPropertyType', OperationParameterPropertyType)


# Complex type CodeType with content type SIMPLE
class CodeType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = pyxb.binding.datatypes.string
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CodeType')
    # Base type is pyxb.binding.datatypes.string
    
    # Attribute codeSpace uses Python identifier codeSpace
    __codeSpace = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'codeSpace'), 'codeSpace', '__httpwww_opengis_netgml3_2_CodeType_codeSpace', pyxb.binding.datatypes.anyURI)
    
    codeSpace = property(__codeSpace.value, __codeSpace.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __codeSpace.name() : __codeSpace
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CodeType', CodeType)


# Complex type CodeWithAuthorityType with content type SIMPLE
class CodeWithAuthorityType (CodeType):
    _TypeDefinition = STD_ANON_6
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CodeWithAuthorityType')
    # Base type is CodeType
    
    # Attribute codeSpace is restricted from parent
    
    # Attribute codeSpace uses Python identifier codeSpace
    __codeSpace = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'codeSpace'), 'codeSpace', '__httpwww_opengis_netgml3_2_CodeType_codeSpace', pyxb.binding.datatypes.anyURI, required=True)
    
    codeSpace = property(__codeSpace.value, __codeSpace.set, None, None)


    _ElementMap = CodeType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = CodeType._AttributeMap.copy()
    _AttributeMap.update({
        __codeSpace.name() : __codeSpace
    })
_Namespace_gml.addCategoryObject('typeBinding', u'CodeWithAuthorityType', CodeWithAuthorityType)


# Complex type MD_ScopeDescription_PropertyType with content type ELEMENT_ONLY
class MD_ScopeDescription_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ScopeDescription_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_ScopeDescription uses Python identifier MD_ScopeDescription
    __MD_ScopeDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ScopeDescription'), 'MD_ScopeDescription', '__httpwww_isotc211_org2005gmd_MD_ScopeDescription_PropertyType_httpwww_isotc211_org2005gmdMD_ScopeDescription', False)

    
    MD_ScopeDescription = property(__MD_ScopeDescription.value, __MD_ScopeDescription.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_ScopeDescription_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __MD_ScopeDescription.name() : __MD_ScopeDescription
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_ScopeDescription_PropertyType', MD_ScopeDescription_PropertyType)


# Complex type MD_Resolution_PropertyType with content type ELEMENT_ONLY
class MD_Resolution_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Resolution_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_Resolution uses Python identifier MD_Resolution
    __MD_Resolution = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Resolution'), 'MD_Resolution', '__httpwww_isotc211_org2005gmd_MD_Resolution_PropertyType_httpwww_isotc211_org2005gmdMD_Resolution', False)

    
    MD_Resolution = property(__MD_Resolution.value, __MD_Resolution.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_Resolution_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __MD_Resolution.name() : __MD_Resolution
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Resolution_PropertyType', MD_Resolution_PropertyType)


# Complex type SurfacePropertyType with content type ELEMENT_ONLY
class SurfacePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SurfacePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractSurface uses Python identifier AbstractSurface
    __AbstractSurface = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractSurface'), 'AbstractSurface', '__httpwww_opengis_netgml3_2_SurfacePropertyType_httpwww_opengis_netgml3_2AbstractSurface', False)

    
    AbstractSurface = property(__AbstractSurface.value, __AbstractSurface.set, None, u'The AbstractSurface element is the abstract head of the substitution group for all (continuous) surface elements.')

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_SurfacePropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_SurfacePropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_SurfacePropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_SurfacePropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_SurfacePropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_SurfacePropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_SurfacePropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_SurfacePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_SurfacePropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_SurfacePropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __AbstractSurface.name() : __AbstractSurface
    }
    _AttributeMap = {
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __title.name() : __title,
        __nilReason.name() : __nilReason,
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show,
        __actuate.name() : __actuate,
        __owns.name() : __owns,
        __href.name() : __href,
        __type.name() : __type
    }
_Namespace_gml.addCategoryObject('typeBinding', u'SurfacePropertyType', SurfacePropertyType)


# Complex type TM_Primitive_PropertyType with content type ELEMENT_ONLY
class TM_Primitive_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gts, u'TM_Primitive_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractTimePrimitive uses Python identifier AbstractTimePrimitive
    __AbstractTimePrimitive = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTimePrimitive'), 'AbstractTimePrimitive', '__httpwww_isotc211_org2005gts_TM_Primitive_PropertyType_httpwww_opengis_netgml3_2AbstractTimePrimitive', False)

    
    AbstractTimePrimitive = property(__AbstractTimePrimitive.value, __AbstractTimePrimitive.set, None, u'gml:AbstractTimePrimitive acts as the head of a substitution group for geometric and topological temporal primitives.')

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gts_TM_Primitive_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gts_TM_Primitive_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gts_TM_Primitive_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gts_TM_Primitive_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gts_TM_Primitive_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gts_TM_Primitive_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gts_TM_Primitive_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gts_TM_Primitive_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gts_TM_Primitive_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)


    _ElementMap = {
        __AbstractTimePrimitive.name() : __AbstractTimePrimitive
    }
    _AttributeMap = {
        __actuate.name() : __actuate,
        __role.name() : __role,
        __show.name() : __show,
        __href.name() : __href,
        __type.name() : __type,
        __nilReason.name() : __nilReason,
        __arcrole.name() : __arcrole,
        __uuidref.name() : __uuidref,
        __title.name() : __title
    }
_Namespace_gts.addCategoryObject('typeBinding', u'TM_Primitive_PropertyType', TM_Primitive_PropertyType)


# Complex type MD_ExtendedElementInformation_PropertyType with content type ELEMENT_ONLY
class MD_ExtendedElementInformation_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ExtendedElementInformation_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_ExtendedElementInformation uses Python identifier MD_ExtendedElementInformation
    __MD_ExtendedElementInformation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ExtendedElementInformation'), 'MD_ExtendedElementInformation', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_PropertyType_httpwww_isotc211_org2005gmdMD_ExtendedElementInformation', False)

    
    MD_ExtendedElementInformation = property(__MD_ExtendedElementInformation.value, __MD_ExtendedElementInformation.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __MD_ExtendedElementInformation.name() : __MD_ExtendedElementInformation
    }
    _AttributeMap = {
        __href.name() : __href,
        __type.name() : __type,
        __nilReason.name() : __nilReason,
        __show.name() : __show,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __title.name() : __title,
        __uuidref.name() : __uuidref,
        __actuate.name() : __actuate
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_ExtendedElementInformation_PropertyType', MD_ExtendedElementInformation_PropertyType)


# Complex type LocationPropertyType with content type ELEMENT_ONLY
class LocationPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'LocationPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}LocationKeyWord uses Python identifier LocationKeyWord
    __LocationKeyWord = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'LocationKeyWord'), 'LocationKeyWord', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_opengis_netgml3_2LocationKeyWord', False)

    
    LocationKeyWord = property(__LocationKeyWord.value, __LocationKeyWord.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}LocationString uses Python identifier LocationString
    __LocationString = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'LocationString'), 'LocationString', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_opengis_netgml3_2LocationString', False)

    
    LocationString = property(__LocationString.value, __LocationString.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}AbstractGeometry uses Python identifier AbstractGeometry
    __AbstractGeometry = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeometry'), 'AbstractGeometry', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_opengis_netgml3_2AbstractGeometry', False)

    
    AbstractGeometry = property(__AbstractGeometry.value, __AbstractGeometry.set, None, u'The AbstractGeometry element is the abstract head of the substitution group for all geometry elements of GML. This includes pre-defined and user-defined geometry elements. Any geometry element shall be a direct or indirect extension/restriction of AbstractGeometryType and shall be directly or indirectly in the substitution group of AbstractGeometry.')

    
    # Element {http://www.opengis.net/gml/3.2}Null uses Python identifier Null
    __Null = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Null'), 'Null', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_opengis_netgml3_2Null', False)

    
    Null = property(__Null.value, __Null.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_LocationPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __LocationKeyWord.name() : __LocationKeyWord,
        __LocationString.name() : __LocationString,
        __AbstractGeometry.name() : __AbstractGeometry,
        __Null.name() : __Null
    }
    _AttributeMap = {
        __href.name() : __href,
        __arcrole.name() : __arcrole,
        __type.name() : __type,
        __role.name() : __role,
        __show.name() : __show,
        __nilReason.name() : __nilReason,
        __remoteSchema.name() : __remoteSchema,
        __title.name() : __title,
        __actuate.name() : __actuate
    }
_Namespace_gml.addCategoryObject('typeBinding', u'LocationPropertyType', LocationPropertyType)


# Complex type MD_DigitalTransferOptions_PropertyType with content type ELEMENT_ONLY
class MD_DigitalTransferOptions_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_DigitalTransferOptions_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_DigitalTransferOptions uses Python identifier MD_DigitalTransferOptions
    __MD_DigitalTransferOptions = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_DigitalTransferOptions'), 'MD_DigitalTransferOptions', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_PropertyType_httpwww_isotc211_org2005gmdMD_DigitalTransferOptions', False)

    
    MD_DigitalTransferOptions = property(__MD_DigitalTransferOptions.value, __MD_DigitalTransferOptions.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __MD_DigitalTransferOptions.name() : __MD_DigitalTransferOptions
    }
    _AttributeMap = {
        __arcrole.name() : __arcrole,
        __show.name() : __show,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __uuidref.name() : __uuidref,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __type.name() : __type
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_DigitalTransferOptions_PropertyType', MD_DigitalTransferOptions_PropertyType)


# Complex type CI_Citation_PropertyType with content type ELEMENT_ONLY
class CI_Citation_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_Citation_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}CI_Citation uses Python identifier CI_Citation
    __CI_Citation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_Citation'), 'CI_Citation', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_isotc211_org2005gmdCI_Citation', False)

    
    CI_Citation = property(__CI_Citation.value, __CI_Citation.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)


    _ElementMap = {
        __CI_Citation.name() : __CI_Citation
    }
    _AttributeMap = {
        __uuidref.name() : __uuidref,
        __actuate.name() : __actuate,
        __nilReason.name() : __nilReason,
        __show.name() : __show,
        __href.name() : __href,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __title.name() : __title
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_Citation_PropertyType', CI_Citation_PropertyType)


# Complex type ShellPropertyType with content type ELEMENT_ONLY
class ShellPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ShellPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}Shell uses Python identifier Shell
    __Shell = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Shell'), 'Shell', '__httpwww_opengis_netgml3_2_ShellPropertyType_httpwww_opengis_netgml3_2Shell', False)

    
    Shell = property(__Shell.value, __Shell.set, None, u'A shell is used to represent a single connected component of a solid boundary as specified in ISO 19107:2003, 6.3.8.\nEvery gml:surfaceMember references or contains one surface, i.e. any element which is substitutable for gml:AbstractSurface. In the context of a shell, the surfaces describe the boundary of the solid. \nIf provided, the aggregationType attribute shall have the value "set".\n')


    _ElementMap = {
        __Shell.name() : __Shell
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'ShellPropertyType', ShellPropertyType)


# Complex type GeodeticDatumPropertyType with content type ELEMENT_ONLY
class GeodeticDatumPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'GeodeticDatumPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}GeodeticDatum uses Python identifier GeodeticDatum
    __GeodeticDatum = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'GeodeticDatum'), 'GeodeticDatum', '__httpwww_opengis_netgml3_2_GeodeticDatumPropertyType_httpwww_opengis_netgml3_2GeodeticDatum', False)

    
    GeodeticDatum = property(__GeodeticDatum.value, __GeodeticDatum.set, None, u'gml:GeodeticDatum is a geodetic datum defines the precise location and orientation in 3-dimensional space of a defined ellipsoid (or sphere), or of a Cartesian coordinate system centered in this ellipsoid (or sphere).')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_GeodeticDatumPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_GeodeticDatumPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_GeodeticDatumPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_GeodeticDatumPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_GeodeticDatumPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_GeodeticDatumPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_GeodeticDatumPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_GeodeticDatumPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_GeodeticDatumPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')


    _ElementMap = {
        __GeodeticDatum.name() : __GeodeticDatum
    }
    _AttributeMap = {
        __title.name() : __title,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __role.name() : __role,
        __show.name() : __show,
        __href.name() : __href,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __remoteSchema.name() : __remoteSchema
    }
_Namespace_gml.addCategoryObject('typeBinding', u'GeodeticDatumPropertyType', GeodeticDatumPropertyType)


# Complex type Integer_PropertyType with content type ELEMENT_ONLY
class Integer_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Integer_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}Integer uses Python identifier Integer
    __Integer = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'Integer'), 'Integer', '__httpwww_isotc211_org2005gco_Integer_PropertyType_httpwww_isotc211_org2005gcoInteger', False)

    
    Integer = property(__Integer.value, __Integer.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_Integer_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __Integer.name() : __Integer
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'Integer_PropertyType', Integer_PropertyType)


# Complex type AbstractCurveType with content type ELEMENT_ONLY
class AbstractCurveType (AbstractGeometricPrimitiveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCurveType')
    # Base type is AbstractGeometricPrimitiveType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType

    _ElementMap = AbstractGeometricPrimitiveType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGeometricPrimitiveType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractCurveType', AbstractCurveType)


# Complex type LineStringType with content type ELEMENT_ONLY
class LineStringType (AbstractCurveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'LineStringType')
    # Base type is AbstractCurveType
    
    # Element {http://www.opengis.net/gml/3.2}pointRep uses Python identifier pointRep
    __pointRep = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pointRep'), 'pointRep', '__httpwww_opengis_netgml3_2_LineStringType_httpwww_opengis_netgml3_2pointRep', True)

    
    pointRep = property(__pointRep.value, __pointRep.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}posList uses Python identifier posList
    __posList = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'posList'), 'posList', '__httpwww_opengis_netgml3_2_LineStringType_httpwww_opengis_netgml3_2posList', False)

    
    posList = property(__posList.value, __posList.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}coordinates uses Python identifier coordinates
    __coordinates = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coordinates'), 'coordinates', '__httpwww_opengis_netgml3_2_LineStringType_httpwww_opengis_netgml3_2coordinates', False)

    
    coordinates = property(__coordinates.value, __coordinates.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}pointProperty uses Python identifier pointProperty
    __pointProperty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pointProperty'), 'pointProperty', '__httpwww_opengis_netgml3_2_LineStringType_httpwww_opengis_netgml3_2pointProperty', True)

    
    pointProperty = property(__pointProperty.value, __pointProperty.set, None, u'This property element either references a point via the XLink-attributes or contains the point element. pointProperty is the predefined property which may be used by GML Application Schemas whenever a GML feature has a property with a value that is substitutable for Point.')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}pos uses Python identifier pos
    __pos = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pos'), 'pos', '__httpwww_opengis_netgml3_2_LineStringType_httpwww_opengis_netgml3_2pos', True)

    
    pos = property(__pos.value, __pos.set, None, None)

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractCurveType._ElementMap.copy()
    _ElementMap.update({
        __pointRep.name() : __pointRep,
        __posList.name() : __posList,
        __coordinates.name() : __coordinates,
        __pointProperty.name() : __pointProperty,
        __pos.name() : __pos
    })
    _AttributeMap = AbstractCurveType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'LineStringType', LineStringType)


# Complex type EllipsoidPropertyType with content type ELEMENT_ONLY
class EllipsoidPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'EllipsoidPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}Ellipsoid uses Python identifier Ellipsoid
    __Ellipsoid = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Ellipsoid'), 'Ellipsoid', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_opengis_netgml3_2Ellipsoid', False)

    
    Ellipsoid = property(__Ellipsoid.value, __Ellipsoid.set, None, u'A gml:Ellipsoid is a geometric figure that may be used to describe the approximate shape of the earth. In mathematical terms, it is a surface formed by the rotation of an ellipse about its minor axis.')

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __Ellipsoid.name() : __Ellipsoid
    }
    _AttributeMap = {
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __title.name() : __title,
        __href.name() : __href,
        __actuate.name() : __actuate,
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show,
        __nilReason.name() : __nilReason,
        __type.name() : __type
    }
_Namespace_gml.addCategoryObject('typeBinding', u'EllipsoidPropertyType', EllipsoidPropertyType)


# Complex type AbstractTimeSliceType with content type ELEMENT_ONLY
class AbstractTimeSliceType (AbstractGMLType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTimeSliceType')
    # Base type is AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}validTime uses Python identifier validTime
    __validTime = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'validTime'), 'validTime', '__httpwww_opengis_netgml3_2_AbstractTimeSliceType_httpwww_opengis_netgml3_2validTime', False)

    
    validTime = property(__validTime.value, __validTime.set, None, u'gml:validTime is a convenience property element.')

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}dataSource uses Python identifier dataSource
    __dataSource = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'dataSource'), 'dataSource', '__httpwww_opengis_netgml3_2_AbstractTimeSliceType_httpwww_opengis_netgml3_2dataSource', False)

    
    dataSource = property(__dataSource.value, __dataSource.set, None, u'Evidence is represented by a simple gml:dataSource or gml:dataSourceReference property that indicates the source of the temporal data. The remote link attributes of the gml:dataSource element have been deprecated along with its current type.')

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractGMLType._ElementMap.copy()
    _ElementMap.update({
        __validTime.name() : __validTime,
        __dataSource.name() : __dataSource
    })
    _AttributeMap = AbstractGMLType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractTimeSliceType', AbstractTimeSliceType)


# Complex type MD_VectorSpatialRepresentation_PropertyType with content type ELEMENT_ONLY
class MD_VectorSpatialRepresentation_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_VectorSpatialRepresentation_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_VectorSpatialRepresentation uses Python identifier MD_VectorSpatialRepresentation
    __MD_VectorSpatialRepresentation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_VectorSpatialRepresentation'), 'MD_VectorSpatialRepresentation', '__httpwww_isotc211_org2005gmd_MD_VectorSpatialRepresentation_PropertyType_httpwww_isotc211_org2005gmdMD_VectorSpatialRepresentation', False)

    
    MD_VectorSpatialRepresentation = property(__MD_VectorSpatialRepresentation.value, __MD_VectorSpatialRepresentation.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_VectorSpatialRepresentation_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_VectorSpatialRepresentation_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_VectorSpatialRepresentation_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_VectorSpatialRepresentation_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_VectorSpatialRepresentation_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_VectorSpatialRepresentation_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_VectorSpatialRepresentation_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_VectorSpatialRepresentation_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_VectorSpatialRepresentation_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __MD_VectorSpatialRepresentation.name() : __MD_VectorSpatialRepresentation
    }
    _AttributeMap = {
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __role.name() : __role,
        __show.name() : __show,
        __uuidref.name() : __uuidref,
        __title.name() : __title,
        __actuate.name() : __actuate,
        __href.name() : __href
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_VectorSpatialRepresentation_PropertyType', MD_VectorSpatialRepresentation_PropertyType)


# Complex type DQ_PositionalAccuracy_PropertyType with content type ELEMENT_ONLY
class DQ_PositionalAccuracy_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_PositionalAccuracy_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}AbstractDQ_PositionalAccuracy uses Python identifier AbstractDQ_PositionalAccuracy
    __AbstractDQ_PositionalAccuracy = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDQ_PositionalAccuracy'), 'AbstractDQ_PositionalAccuracy', '__httpwww_isotc211_org2005gmd_DQ_PositionalAccuracy_PropertyType_httpwww_isotc211_org2005gmdAbstractDQ_PositionalAccuracy', False)

    
    AbstractDQ_PositionalAccuracy = property(__AbstractDQ_PositionalAccuracy.value, __AbstractDQ_PositionalAccuracy.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_DQ_PositionalAccuracy_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_DQ_PositionalAccuracy_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_DQ_PositionalAccuracy_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DQ_PositionalAccuracy_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_DQ_PositionalAccuracy_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_DQ_PositionalAccuracy_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_DQ_PositionalAccuracy_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_DQ_PositionalAccuracy_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_DQ_PositionalAccuracy_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)


    _ElementMap = {
        __AbstractDQ_PositionalAccuracy.name() : __AbstractDQ_PositionalAccuracy
    }
    _AttributeMap = {
        __actuate.name() : __actuate,
        __show.name() : __show,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __type.name() : __type,
        __href.name() : __href,
        __arcrole.name() : __arcrole,
        __uuidref.name() : __uuidref,
        __title.name() : __title
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_PositionalAccuracy_PropertyType', DQ_PositionalAccuracy_PropertyType)


# Complex type CoordinateOperationPropertyType with content type ELEMENT_ONLY
class CoordinateOperationPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CoordinateOperationPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractCoordinateOperation uses Python identifier AbstractCoordinateOperation
    __AbstractCoordinateOperation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCoordinateOperation'), 'AbstractCoordinateOperation', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_opengis_netgml3_2AbstractCoordinateOperation', False)

    
    AbstractCoordinateOperation = property(__AbstractCoordinateOperation.value, __AbstractCoordinateOperation.set, None, u'gml:AbstractCoordinateOperation is a mathematical operation on coordinates that transforms or converts coordinates to another coordinate reference system. Many but not all coordinate operations (from CRS A to CRS B) also uniquely define the inverse operation (from CRS B to CRS A). In some cases, the operation method algorithm for the inverse operation is the same as for the forward algorithm, but the signs of some operation parameter values shall be reversed. In other cases, different algorithms are required for the forward and inverse operations, but the same operation parameter values are used. If (some) entirely different parameter values are needed, a different coordinate operation shall be defined.\nThe optional coordinateOperationAccuracy property elements provide estimates of the impact of this coordinate operation on point position accuracy.')

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __AbstractCoordinateOperation.name() : __AbstractCoordinateOperation
    }
    _AttributeMap = {
        __actuate.name() : __actuate,
        __nilReason.name() : __nilReason,
        __remoteSchema.name() : __remoteSchema,
        __role.name() : __role,
        __href.name() : __href,
        __title.name() : __title,
        __show.name() : __show,
        __type.name() : __type,
        __arcrole.name() : __arcrole
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CoordinateOperationPropertyType', CoordinateOperationPropertyType)


# Complex type DirectionPropertyType with content type ELEMENT_ONLY
class DirectionPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectionPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}DirectionKeyword uses Python identifier DirectionKeyword
    __DirectionKeyword = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectionKeyword'), 'DirectionKeyword', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_opengis_netgml3_2DirectionKeyword', False)

    
    DirectionKeyword = property(__DirectionKeyword.value, __DirectionKeyword.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}DirectionDescription uses Python identifier DirectionDescription
    __DirectionDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectionDescription'), 'DirectionDescription', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_opengis_netgml3_2DirectionDescription', False)

    
    DirectionDescription = property(__DirectionDescription.value, __DirectionDescription.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}DirectionString uses Python identifier DirectionString
    __DirectionString = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectionString'), 'DirectionString', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_opengis_netgml3_2DirectionString', False)

    
    DirectionString = property(__DirectionString.value, __DirectionString.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}DirectionVector uses Python identifier DirectionVector
    __DirectionVector = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectionVector'), 'DirectionVector', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_opengis_netgml3_2DirectionVector', False)

    
    DirectionVector = property(__DirectionVector.value, __DirectionVector.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}CompassPoint uses Python identifier CompassPoint
    __CompassPoint = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'CompassPoint'), 'CompassPoint', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_opengis_netgml3_2CompassPoint', False)

    
    CompassPoint = property(__CompassPoint.value, __CompassPoint.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_DirectionPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_DirectionPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __DirectionKeyword.name() : __DirectionKeyword,
        __DirectionDescription.name() : __DirectionDescription,
        __DirectionString.name() : __DirectionString,
        __DirectionVector.name() : __DirectionVector,
        __CompassPoint.name() : __CompassPoint
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __owns.name() : __owns,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __href.name() : __href,
        __type.name() : __type
    }
_Namespace_gml.addCategoryObject('typeBinding', u'DirectionPropertyType', DirectionPropertyType)


# Complex type DQ_AccuracyOfATimeMeasurement_PropertyType with content type ELEMENT_ONLY
class DQ_AccuracyOfATimeMeasurement_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_AccuracyOfATimeMeasurement_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}DQ_AccuracyOfATimeMeasurement uses Python identifier DQ_AccuracyOfATimeMeasurement
    __DQ_AccuracyOfATimeMeasurement = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_AccuracyOfATimeMeasurement'), 'DQ_AccuracyOfATimeMeasurement', '__httpwww_isotc211_org2005gmd_DQ_AccuracyOfATimeMeasurement_PropertyType_httpwww_isotc211_org2005gmdDQ_AccuracyOfATimeMeasurement', False)

    
    DQ_AccuracyOfATimeMeasurement = property(__DQ_AccuracyOfATimeMeasurement.value, __DQ_AccuracyOfATimeMeasurement.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_DQ_AccuracyOfATimeMeasurement_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DQ_AccuracyOfATimeMeasurement_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_DQ_AccuracyOfATimeMeasurement_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_DQ_AccuracyOfATimeMeasurement_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_DQ_AccuracyOfATimeMeasurement_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_DQ_AccuracyOfATimeMeasurement_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_DQ_AccuracyOfATimeMeasurement_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_DQ_AccuracyOfATimeMeasurement_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_DQ_AccuracyOfATimeMeasurement_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __DQ_AccuracyOfATimeMeasurement.name() : __DQ_AccuracyOfATimeMeasurement
    }
    _AttributeMap = {
        __uuidref.name() : __uuidref,
        __nilReason.name() : __nilReason,
        __role.name() : __role,
        __href.name() : __href,
        __title.name() : __title,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __type.name() : __type,
        __arcrole.name() : __arcrole
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_AccuracyOfATimeMeasurement_PropertyType', DQ_AccuracyOfATimeMeasurement_PropertyType)


# Complex type TimeNodePropertyType with content type ELEMENT_ONLY
class TimeNodePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeNodePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TimeNode uses Python identifier TimeNode
    __TimeNode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeNode'), 'TimeNode', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_opengis_netgml3_2TimeNode', False)

    
    TimeNode = property(__TimeNode.value, __TimeNode.set, None, u'A time node is a zero-dimensional topological primitive that represents an identifiable node in time (it is equivalent to a point in space). A node may act as the termination or initiation of any number of time edges. A time node may be realised as a geometry, its position, whose value is a time instant.')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __TimeNode.name() : __TimeNode
    }
    _AttributeMap = {
        __owns.name() : __owns,
        __type.name() : __type,
        __href.name() : __href,
        __role.name() : __role,
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TimeNodePropertyType', TimeNodePropertyType)


# Complex type MD_Constraints_Type with content type ELEMENT_ONLY
class MD_Constraints_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Constraints_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}useLimitation uses Python identifier useLimitation
    __useLimitation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'useLimitation'), 'useLimitation', '__httpwww_isotc211_org2005gmd_MD_Constraints_Type_httpwww_isotc211_org2005gmduseLimitation', True)

    
    useLimitation = property(__useLimitation.value, __useLimitation.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __useLimitation.name() : __useLimitation
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Constraints_Type', MD_Constraints_Type)


# Complex type MD_LegalConstraints_Type with content type ELEMENT_ONLY
class MD_LegalConstraints_Type (MD_Constraints_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_LegalConstraints_Type')
    # Base type is MD_Constraints_Type
    
    # Element {http://www.isotc211.org/2005/gmd}otherConstraints uses Python identifier otherConstraints
    __otherConstraints = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'otherConstraints'), 'otherConstraints', '__httpwww_isotc211_org2005gmd_MD_LegalConstraints_Type_httpwww_isotc211_org2005gmdotherConstraints', True)

    
    otherConstraints = property(__otherConstraints.value, __otherConstraints.set, None, None)

    
    # Element useLimitation ({http://www.isotc211.org/2005/gmd}useLimitation) inherited from {http://www.isotc211.org/2005/gmd}MD_Constraints_Type
    
    # Element {http://www.isotc211.org/2005/gmd}useConstraints uses Python identifier useConstraints
    __useConstraints = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'useConstraints'), 'useConstraints', '__httpwww_isotc211_org2005gmd_MD_LegalConstraints_Type_httpwww_isotc211_org2005gmduseConstraints', True)

    
    useConstraints = property(__useConstraints.value, __useConstraints.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}accessConstraints uses Python identifier accessConstraints
    __accessConstraints = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'accessConstraints'), 'accessConstraints', '__httpwww_isotc211_org2005gmd_MD_LegalConstraints_Type_httpwww_isotc211_org2005gmdaccessConstraints', True)

    
    accessConstraints = property(__accessConstraints.value, __accessConstraints.set, None, None)

    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = MD_Constraints_Type._ElementMap.copy()
    _ElementMap.update({
        __otherConstraints.name() : __otherConstraints,
        __useConstraints.name() : __useConstraints,
        __accessConstraints.name() : __accessConstraints
    })
    _AttributeMap = MD_Constraints_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_LegalConstraints_Type', MD_LegalConstraints_Type)


# Complex type MeasureType with content type SIMPLE
class MeasureType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = pyxb.binding.datatypes.double
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'MeasureType')
    # Base type is pyxb.binding.datatypes.double
    
    # Attribute uom uses Python identifier uom
    __uom = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uom'), 'uom', '__httpwww_opengis_netgml3_2_MeasureType_uom', UomIdentifier, required=True)
    
    uom = property(__uom.value, __uom.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __uom.name() : __uom
    }
_Namespace_gml.addCategoryObject('typeBinding', u'MeasureType', MeasureType)


# Complex type LengthType with content type SIMPLE
class LengthType (MeasureType):
    _TypeDefinition = pyxb.binding.datatypes.double
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'LengthType')
    # Base type is MeasureType
    
    # Attribute uom inherited from {http://www.opengis.net/gml/3.2}MeasureType

    _ElementMap = MeasureType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = MeasureType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'LengthType', LengthType)


# Complex type GeneralTransformationPropertyType with content type ELEMENT_ONLY
class GeneralTransformationPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'GeneralTransformationPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractGeneralTransformation uses Python identifier AbstractGeneralTransformation
    __AbstractGeneralTransformation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeneralTransformation'), 'AbstractGeneralTransformation', '__httpwww_opengis_netgml3_2_GeneralTransformationPropertyType_httpwww_opengis_netgml3_2AbstractGeneralTransformation', False)

    
    AbstractGeneralTransformation = property(__AbstractGeneralTransformation.value, __AbstractGeneralTransformation.set, None, u'gml:AbstractGeneralTransformation is an abstract operation on coordinates that usually includes a change of Datum. The parameters of a coordinate transformation are empirically derived from data containing the coordinates of a series of points in both coordinate reference systems. This computational process is usually "over-determined", allowing derivation of error (or accuracy) estimates for the transformation. Also, the stochastic nature of the parameters may result in multiple (different) versions of the same coordinate transformation. The operationVersion, sourceCRS, and targetCRS proeprty elements are mandatory in a coordinate transformation.\nThis abstract complex type is expected to be extended for well-known operation methods with many Transformation instances, in Application Schemas that define operation-method-specialized value element names and contents. This transformation uses an operation method with associated parameter values. However, operation methods and parameter values are directly associated with concrete subtypes, not with this abstract type. All concrete types derived from this type shall extend this type to include a "usesMethod" element that references one "OperationMethod" element. Similarly, all concrete types derived from this type shall extend this type to include one or more elements each named "uses...Value" that each use the type of an element substitutable for the "AbstractGeneralParameterValue" element.')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_GeneralTransformationPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_GeneralTransformationPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_GeneralTransformationPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_GeneralTransformationPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_GeneralTransformationPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_GeneralTransformationPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_GeneralTransformationPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_GeneralTransformationPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_GeneralTransformationPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __AbstractGeneralTransformation.name() : __AbstractGeneralTransformation
    }
    _AttributeMap = {
        __href.name() : __href,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __actuate.name() : __actuate,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __remoteSchema.name() : __remoteSchema,
        __title.name() : __title,
        __show.name() : __show
    }
_Namespace_gml.addCategoryObject('typeBinding', u'GeneralTransformationPropertyType', GeneralTransformationPropertyType)


# Complex type CTD_ANON_ with content type ELEMENT_ONLY
class CTD_ANON_ (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = None
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}Row uses Python identifier Row
    __Row = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Row'), 'Row', '__httpwww_opengis_netgml3_2_CTD_ANON__httpwww_opengis_netgml3_2Row', True)

    
    Row = property(__Row.value, __Row.set, None, None)


    _ElementMap = {
        __Row.name() : __Row
    }
    _AttributeMap = {
        
    }



# Complex type CI_Contact_PropertyType with content type ELEMENT_ONLY
class CI_Contact_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_Contact_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}CI_Contact uses Python identifier CI_Contact
    __CI_Contact = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_Contact'), 'CI_Contact', '__httpwww_isotc211_org2005gmd_CI_Contact_PropertyType_httpwww_isotc211_org2005gmdCI_Contact', False)

    
    CI_Contact = property(__CI_Contact.value, __CI_Contact.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_CI_Contact_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_CI_Contact_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_CI_Contact_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_CI_Contact_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_CI_Contact_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_CI_Contact_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_CI_Contact_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_CI_Contact_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_CI_Contact_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __CI_Contact.name() : __CI_Contact
    }
    _AttributeMap = {
        __type.name() : __type,
        __show.name() : __show,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __uuidref.name() : __uuidref,
        __actuate.name() : __actuate,
        __role.name() : __role,
        __href.name() : __href
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_Contact_PropertyType', CI_Contact_PropertyType)


# Complex type MD_Format_Type with content type ELEMENT_ONLY
class MD_Format_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Format_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}specification uses Python identifier specification
    __specification = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'specification'), 'specification', '__httpwww_isotc211_org2005gmd_MD_Format_Type_httpwww_isotc211_org2005gmdspecification', False)

    
    specification = property(__specification.value, __specification.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}fileDecompressionTechnique uses Python identifier fileDecompressionTechnique
    __fileDecompressionTechnique = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'fileDecompressionTechnique'), 'fileDecompressionTechnique', '__httpwww_isotc211_org2005gmd_MD_Format_Type_httpwww_isotc211_org2005gmdfileDecompressionTechnique', False)

    
    fileDecompressionTechnique = property(__fileDecompressionTechnique.value, __fileDecompressionTechnique.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}formatDistributor uses Python identifier formatDistributor
    __formatDistributor = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'formatDistributor'), 'formatDistributor', '__httpwww_isotc211_org2005gmd_MD_Format_Type_httpwww_isotc211_org2005gmdformatDistributor', True)

    
    formatDistributor = property(__formatDistributor.value, __formatDistributor.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}name uses Python identifier name
    __name = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'name'), 'name', '__httpwww_isotc211_org2005gmd_MD_Format_Type_httpwww_isotc211_org2005gmdname', False)

    
    name = property(__name.value, __name.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}version uses Python identifier version
    __version = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'version'), 'version', '__httpwww_isotc211_org2005gmd_MD_Format_Type_httpwww_isotc211_org2005gmdversion', False)

    
    version = property(__version.value, __version.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}amendmentNumber uses Python identifier amendmentNumber
    __amendmentNumber = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'amendmentNumber'), 'amendmentNumber', '__httpwww_isotc211_org2005gmd_MD_Format_Type_httpwww_isotc211_org2005gmdamendmentNumber', False)

    
    amendmentNumber = property(__amendmentNumber.value, __amendmentNumber.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __specification.name() : __specification,
        __fileDecompressionTechnique.name() : __fileDecompressionTechnique,
        __formatDistributor.name() : __formatDistributor,
        __name.name() : __name,
        __version.name() : __version,
        __amendmentNumber.name() : __amendmentNumber
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Format_Type', MD_Format_Type)


# Complex type PointPropertyType with content type ELEMENT_ONLY
class PointPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'PointPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}Point uses Python identifier Point
    __Point = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Point'), 'Point', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_opengis_netgml3_2Point', False)

    
    Point = property(__Point.value, __Point.set, None, u'A Point is defined by a single coordinate tuple. The direct position of a point is specified by the pos element which is of type DirectPositionType.')

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_PointPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_PointPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)


    _ElementMap = {
        __Point.name() : __Point
    }
    _AttributeMap = {
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __remoteSchema.name() : __remoteSchema,
        __owns.name() : __owns,
        __show.name() : __show,
        __href.name() : __href,
        __type.name() : __type,
        __title.name() : __title
    }
_Namespace_gml.addCategoryObject('typeBinding', u'PointPropertyType', PointPropertyType)


# Complex type MD_LegalConstraints_PropertyType with content type ELEMENT_ONLY
class MD_LegalConstraints_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_LegalConstraints_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_LegalConstraints uses Python identifier MD_LegalConstraints
    __MD_LegalConstraints = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_LegalConstraints'), 'MD_LegalConstraints', '__httpwww_isotc211_org2005gmd_MD_LegalConstraints_PropertyType_httpwww_isotc211_org2005gmdMD_LegalConstraints', False)

    
    MD_LegalConstraints = property(__MD_LegalConstraints.value, __MD_LegalConstraints.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_LegalConstraints_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_LegalConstraints_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_LegalConstraints_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_LegalConstraints_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_LegalConstraints_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_LegalConstraints_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_LegalConstraints_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_LegalConstraints_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_LegalConstraints_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)


    _ElementMap = {
        __MD_LegalConstraints.name() : __MD_LegalConstraints
    }
    _AttributeMap = {
        __uuidref.name() : __uuidref,
        __show.name() : __show,
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __actuate.name() : __actuate,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __title.name() : __title
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_LegalConstraints_PropertyType', MD_LegalConstraints_PropertyType)


# Complex type CoordinatesType with content type SIMPLE
class CoordinatesType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = pyxb.binding.datatypes.string
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CoordinatesType')
    # Base type is pyxb.binding.datatypes.string
    
    # Attribute decimal uses Python identifier decimal
    __decimal = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'decimal'), 'decimal', '__httpwww_opengis_netgml3_2_CoordinatesType_decimal', pyxb.binding.datatypes.string, unicode_default=u'.')
    
    decimal = property(__decimal.value, __decimal.set, None, None)

    
    # Attribute ts uses Python identifier ts
    __ts = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'ts'), 'ts', '__httpwww_opengis_netgml3_2_CoordinatesType_ts', pyxb.binding.datatypes.string, unicode_default=u' ')
    
    ts = property(__ts.value, __ts.set, None, None)

    
    # Attribute cs uses Python identifier cs
    __cs = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'cs'), 'cs', '__httpwww_opengis_netgml3_2_CoordinatesType_cs', pyxb.binding.datatypes.string, unicode_default=u',')
    
    cs = property(__cs.value, __cs.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __decimal.name() : __decimal,
        __ts.name() : __ts,
        __cs.name() : __cs
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CoordinatesType', CoordinatesType)


# Complex type NodePropertyType with content type ELEMENT_ONLY
class NodePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'NodePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}Node uses Python identifier Node
    __Node = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Node'), 'Node', '__httpwww_opengis_netgml3_2_NodePropertyType_httpwww_opengis_netgml3_2Node', False)

    
    Node = property(__Node.value, __Node.set, None, u'gml:Node represents the 0-dimensional primitive.\nThe optional coboundary of a node (gml:directedEdge) is a sequence of directed edges which are incident on this node. Edges emanating from this node appear in the node coboundary with a negative orientation. \nIf provided, the aggregationType attribute shall have the value "sequence".\nA node may optionally be realised by a 0-dimensional geometric primitive (gml:pointProperty).')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_NodePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_NodePropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_NodePropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_NodePropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_NodePropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_NodePropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_NodePropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_NodePropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_NodePropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_NodePropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __Node.name() : __Node
    }
    _AttributeMap = {
        __owns.name() : __owns,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema,
        __role.name() : __role,
        __href.name() : __href,
        __show.name() : __show,
        __actuate.name() : __actuate,
        __type.name() : __type,
        __arcrole.name() : __arcrole
    }
_Namespace_gml.addCategoryObject('typeBinding', u'NodePropertyType', NodePropertyType)


# Complex type GeocentricCRSPropertyType with content type ELEMENT_ONLY
class GeocentricCRSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'GeocentricCRSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}GeocentricCRS uses Python identifier GeocentricCRS
    __GeocentricCRS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'GeocentricCRS'), 'GeocentricCRS', '__httpwww_opengis_netgml3_2_GeocentricCRSPropertyType_httpwww_opengis_netgml3_2GeocentricCRS', False)

    
    GeocentricCRS = property(__GeocentricCRS.value, __GeocentricCRS.set, None, u'')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_GeocentricCRSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_GeocentricCRSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_GeocentricCRSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_GeocentricCRSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_GeocentricCRSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_GeocentricCRSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_GeocentricCRSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_GeocentricCRSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_GeocentricCRSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __GeocentricCRS.name() : __GeocentricCRS
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show,
        __role.name() : __role,
        __href.name() : __href,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __title.name() : __title,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate
    }
_Namespace_gml.addCategoryObject('typeBinding', u'GeocentricCRSPropertyType', GeocentricCRSPropertyType)


# Complex type AbstractCoordinateOperationType with content type ELEMENT_ONLY
class AbstractCoordinateOperationType (IdentifiedObjectType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCoordinateOperationType')
    # Base type is IdentifiedObjectType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element {http://www.opengis.net/gml/3.2}targetCRS uses Python identifier targetCRS
    __targetCRS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'targetCRS'), 'targetCRS', '__httpwww_opengis_netgml3_2_AbstractCoordinateOperationType_httpwww_opengis_netgml3_2targetCRS', False)

    
    targetCRS = property(__targetCRS.value, __targetCRS.set, None, u'gml:targetCRS is an association role to the target CRS (coordinate reference system) of this coordinate operation.')

    
    # Element {http://www.opengis.net/gml/3.2}domainOfValidity uses Python identifier domainOfValidity
    __domainOfValidity = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'domainOfValidity'), 'domainOfValidity', '__httpwww_opengis_netgml3_2_AbstractCoordinateOperationType_httpwww_opengis_netgml3_2domainOfValidity', False)

    
    domainOfValidity = property(__domainOfValidity.value, __domainOfValidity.set, None, u'The gml:domainOfValidity property implements an association role to an EX_Extent object as encoded in ISO/TS 19139, either referencing or containing the definition of that extent.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}scope uses Python identifier scope
    __scope = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'scope'), 'scope', '__httpwww_opengis_netgml3_2_AbstractCoordinateOperationType_httpwww_opengis_netgml3_2scope', True)

    
    scope = property(__scope.value, __scope.set, None, u'The gml:scope property provides a description of the usage, or limitations of usage, for which this CRS-related object is valid. If unknown, enter "not known".')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}operationVersion uses Python identifier operationVersion
    __operationVersion = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'operationVersion'), 'operationVersion', '__httpwww_opengis_netgml3_2_AbstractCoordinateOperationType_httpwww_opengis_netgml3_2operationVersion', False)

    
    operationVersion = property(__operationVersion.value, __operationVersion.set, None, u'gml:operationVersion is the version of the coordinate transformation (i.e., instantiation due to the stochastic nature of the parameters). Mandatory when describing a transformation, and should not be supplied for a conversion.')

    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}coordinateOperationAccuracy uses Python identifier coordinateOperationAccuracy
    __coordinateOperationAccuracy = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coordinateOperationAccuracy'), 'coordinateOperationAccuracy', '__httpwww_opengis_netgml3_2_AbstractCoordinateOperationType_httpwww_opengis_netgml3_2coordinateOperationAccuracy', True)

    
    coordinateOperationAccuracy = property(__coordinateOperationAccuracy.value, __coordinateOperationAccuracy.set, None, u'gml:coordinateOperationAccuracy is an association role to a DQ_PositionalAccuracy object as encoded in ISO/TS 19139, either referencing or containing the definition of that positional accuracy. That object contains an estimate of the impact of this coordinate operation on point accuracy. That is, it gives position error estimates for the target coordinates of this coordinate operation, assuming no errors in the source coordinates.')

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}sourceCRS uses Python identifier sourceCRS
    __sourceCRS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'sourceCRS'), 'sourceCRS', '__httpwww_opengis_netgml3_2_AbstractCoordinateOperationType_httpwww_opengis_netgml3_2sourceCRS', False)

    
    sourceCRS = property(__sourceCRS.value, __sourceCRS.set, None, u'gml:sourceCRS is an association role to the source CRS (coordinate reference system) of this coordinate operation.')

    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = IdentifiedObjectType._ElementMap.copy()
    _ElementMap.update({
        __targetCRS.name() : __targetCRS,
        __domainOfValidity.name() : __domainOfValidity,
        __scope.name() : __scope,
        __operationVersion.name() : __operationVersion,
        __coordinateOperationAccuracy.name() : __coordinateOperationAccuracy,
        __sourceCRS.name() : __sourceCRS
    })
    _AttributeMap = IdentifiedObjectType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractCoordinateOperationType', AbstractCoordinateOperationType)


# Complex type AbstractGeneralConversionType with content type ELEMENT_ONLY
class AbstractGeneralConversionType (AbstractCoordinateOperationType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeneralConversionType')
    # Base type is AbstractCoordinateOperationType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element coordinateOperationAccuracy ({http://www.opengis.net/gml/3.2}coordinateOperationAccuracy) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id is restricted from parent
    
    # Attribute {http://www.opengis.net/gml/3.2}id uses Python identifier id
    __id = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'id'), 'id', '__httpwww_opengis_netgml3_2_AbstractGMLType_httpwww_opengis_netgml3_2id', pyxb.binding.datatypes.ID, required=True)
    
    id = property(__id.value, __id.set, None, u'The attribute gml:id supports provision of a handle for the XML element representing a GML Object. Its use is mandatory for all GML objects. It is of XML type ID, so is constrained to be unique in the XML document within which it occurs.')


    _ElementMap = AbstractCoordinateOperationType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractCoordinateOperationType._AttributeMap.copy()
    _AttributeMap.update({
        __id.name() : __id
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGeneralConversionType', AbstractGeneralConversionType)


# Complex type AbstractDQ_ThematicAccuracy_Type with content type ELEMENT_ONLY
class AbstractDQ_ThematicAccuracy_Type (AbstractDQ_Element_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDQ_ThematicAccuracy_Type')
    # Base type is AbstractDQ_Element_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_Element_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_Element_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractDQ_ThematicAccuracy_Type', AbstractDQ_ThematicAccuracy_Type)


# Complex type DQ_ThematicClassificationCorrectness_Type with content type ELEMENT_ONLY
class DQ_ThematicClassificationCorrectness_Type (AbstractDQ_ThematicAccuracy_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_ThematicClassificationCorrectness_Type')
    # Base type is AbstractDQ_ThematicAccuracy_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_ThematicAccuracy_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_ThematicAccuracy_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_ThematicClassificationCorrectness_Type', DQ_ThematicClassificationCorrectness_Type)


# Complex type AbstractCRSType with content type ELEMENT_ONLY
class AbstractCRSType (IdentifiedObjectType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCRSType')
    # Base type is IdentifiedObjectType
    
    # Element {http://www.opengis.net/gml/3.2}domainOfValidity uses Python identifier domainOfValidity
    __domainOfValidity = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'domainOfValidity'), 'domainOfValidity', '__httpwww_opengis_netgml3_2_AbstractCRSType_httpwww_opengis_netgml3_2domainOfValidity', True)

    
    domainOfValidity = property(__domainOfValidity.value, __domainOfValidity.set, None, u'The gml:domainOfValidity property implements an association role to an EX_Extent object as encoded in ISO/TS 19139, either referencing or containing the definition of that extent.')

    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}scope uses Python identifier scope
    __scope = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'scope'), 'scope', '__httpwww_opengis_netgml3_2_AbstractCRSType_httpwww_opengis_netgml3_2scope', True)

    
    scope = property(__scope.value, __scope.set, None, u'The gml:scope property provides a description of the usage, or limitations of usage, for which this CRS-related object is valid. If unknown, enter "not known".')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = IdentifiedObjectType._ElementMap.copy()
    _ElementMap.update({
        __domainOfValidity.name() : __domainOfValidity,
        __scope.name() : __scope
    })
    _AttributeMap = IdentifiedObjectType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractCRSType', AbstractCRSType)


# Complex type ArcStringByBulgeType with content type ELEMENT_ONLY
class ArcStringByBulgeType (AbstractCurveSegmentType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ArcStringByBulgeType')
    # Base type is AbstractCurveSegmentType
    
    # Element {http://www.opengis.net/gml/3.2}coordinates uses Python identifier coordinates
    __coordinates = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coordinates'), 'coordinates', '__httpwww_opengis_netgml3_2_ArcStringByBulgeType_httpwww_opengis_netgml3_2coordinates', False)

    
    coordinates = property(__coordinates.value, __coordinates.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}posList uses Python identifier posList
    __posList = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'posList'), 'posList', '__httpwww_opengis_netgml3_2_ArcStringByBulgeType_httpwww_opengis_netgml3_2posList', False)

    
    posList = property(__posList.value, __posList.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}bulge uses Python identifier bulge
    __bulge = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'bulge'), 'bulge', '__httpwww_opengis_netgml3_2_ArcStringByBulgeType_httpwww_opengis_netgml3_2bulge', True)

    
    bulge = property(__bulge.value, __bulge.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}pos uses Python identifier pos
    __pos = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pos'), 'pos', '__httpwww_opengis_netgml3_2_ArcStringByBulgeType_httpwww_opengis_netgml3_2pos', True)

    
    pos = property(__pos.value, __pos.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}pointProperty uses Python identifier pointProperty
    __pointProperty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pointProperty'), 'pointProperty', '__httpwww_opengis_netgml3_2_ArcStringByBulgeType_httpwww_opengis_netgml3_2pointProperty', True)

    
    pointProperty = property(__pointProperty.value, __pointProperty.set, None, u'This property element either references a point via the XLink-attributes or contains the point element. pointProperty is the predefined property which may be used by GML Application Schemas whenever a GML feature has a property with a value that is substitutable for Point.')

    
    # Element {http://www.opengis.net/gml/3.2}pointRep uses Python identifier pointRep
    __pointRep = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pointRep'), 'pointRep', '__httpwww_opengis_netgml3_2_ArcStringByBulgeType_httpwww_opengis_netgml3_2pointRep', True)

    
    pointRep = property(__pointRep.value, __pointRep.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}normal uses Python identifier normal
    __normal = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'normal'), 'normal', '__httpwww_opengis_netgml3_2_ArcStringByBulgeType_httpwww_opengis_netgml3_2normal', True)

    
    normal = property(__normal.value, __normal.set, None, None)

    
    # Attribute numDerivativesAtStart inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType
    
    # Attribute interpolation uses Python identifier interpolation
    __interpolation = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'interpolation'), 'interpolation', '__httpwww_opengis_netgml3_2_ArcStringByBulgeType_interpolation', CurveInterpolationType, fixed=True, unicode_default=u'circularArc2PointWithBulge')
    
    interpolation = property(__interpolation.value, __interpolation.set, None, None)

    
    # Attribute numDerivativesAtEnd inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType
    
    # Attribute numDerivativeInterior inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType
    
    # Attribute numArc uses Python identifier numArc
    __numArc = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'numArc'), 'numArc', '__httpwww_opengis_netgml3_2_ArcStringByBulgeType_numArc', pyxb.binding.datatypes.integer)
    
    numArc = property(__numArc.value, __numArc.set, None, None)


    _ElementMap = AbstractCurveSegmentType._ElementMap.copy()
    _ElementMap.update({
        __coordinates.name() : __coordinates,
        __posList.name() : __posList,
        __bulge.name() : __bulge,
        __pos.name() : __pos,
        __pointProperty.name() : __pointProperty,
        __pointRep.name() : __pointRep,
        __normal.name() : __normal
    })
    _AttributeMap = AbstractCurveSegmentType._AttributeMap.copy()
    _AttributeMap.update({
        __interpolation.name() : __interpolation,
        __numArc.name() : __numArc
    })
_Namespace_gml.addCategoryObject('typeBinding', u'ArcStringByBulgeType', ArcStringByBulgeType)


# Complex type ArcByBulgeType with content type ELEMENT_ONLY
class ArcByBulgeType (ArcStringByBulgeType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ArcByBulgeType')
    # Base type is ArcStringByBulgeType
    
    # Element coordinates ({http://www.opengis.net/gml/3.2}coordinates) inherited from {http://www.opengis.net/gml/3.2}ArcStringByBulgeType
    
    # Element posList ({http://www.opengis.net/gml/3.2}posList) inherited from {http://www.opengis.net/gml/3.2}ArcStringByBulgeType
    
    # Element bulge ({http://www.opengis.net/gml/3.2}bulge) inherited from {http://www.opengis.net/gml/3.2}ArcStringByBulgeType
    
    # Element pos ({http://www.opengis.net/gml/3.2}pos) inherited from {http://www.opengis.net/gml/3.2}ArcStringByBulgeType
    
    # Element pointProperty ({http://www.opengis.net/gml/3.2}pointProperty) inherited from {http://www.opengis.net/gml/3.2}ArcStringByBulgeType
    
    # Element pointRep ({http://www.opengis.net/gml/3.2}pointRep) inherited from {http://www.opengis.net/gml/3.2}ArcStringByBulgeType
    
    # Element normal ({http://www.opengis.net/gml/3.2}normal) inherited from {http://www.opengis.net/gml/3.2}ArcStringByBulgeType
    
    # Attribute numDerivativesAtStart inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType
    
    # Attribute numArc is restricted from parent
    
    # Attribute numArc uses Python identifier numArc
    __numArc = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'numArc'), 'numArc', '__httpwww_opengis_netgml3_2_ArcStringByBulgeType_numArc', pyxb.binding.datatypes.integer, fixed=True, unicode_default=u'1')
    
    numArc = property(__numArc.value, __numArc.set, None, None)

    
    # Attribute interpolation inherited from {http://www.opengis.net/gml/3.2}ArcStringByBulgeType
    
    # Attribute numDerivativesAtEnd inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType
    
    # Attribute numDerivativeInterior inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType

    _ElementMap = ArcStringByBulgeType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = ArcStringByBulgeType._AttributeMap.copy()
    _AttributeMap.update({
        __numArc.name() : __numArc
    })
_Namespace_gml.addCategoryObject('typeBinding', u'ArcByBulgeType', ArcByBulgeType)


# Complex type MD_Medium_Type with content type ELEMENT_ONLY
class MD_Medium_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Medium_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}mediumNote uses Python identifier mediumNote
    __mediumNote = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'mediumNote'), 'mediumNote', '__httpwww_isotc211_org2005gmd_MD_Medium_Type_httpwww_isotc211_org2005gmdmediumNote', False)

    
    mediumNote = property(__mediumNote.value, __mediumNote.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}name uses Python identifier name
    __name = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'name'), 'name', '__httpwww_isotc211_org2005gmd_MD_Medium_Type_httpwww_isotc211_org2005gmdname', False)

    
    name = property(__name.value, __name.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}density uses Python identifier density
    __density = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'density'), 'density', '__httpwww_isotc211_org2005gmd_MD_Medium_Type_httpwww_isotc211_org2005gmddensity', True)

    
    density = property(__density.value, __density.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}densityUnits uses Python identifier densityUnits
    __densityUnits = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'densityUnits'), 'densityUnits', '__httpwww_isotc211_org2005gmd_MD_Medium_Type_httpwww_isotc211_org2005gmddensityUnits', False)

    
    densityUnits = property(__densityUnits.value, __densityUnits.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}volumes uses Python identifier volumes
    __volumes = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'volumes'), 'volumes', '__httpwww_isotc211_org2005gmd_MD_Medium_Type_httpwww_isotc211_org2005gmdvolumes', False)

    
    volumes = property(__volumes.value, __volumes.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}mediumFormat uses Python identifier mediumFormat
    __mediumFormat = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'mediumFormat'), 'mediumFormat', '__httpwww_isotc211_org2005gmd_MD_Medium_Type_httpwww_isotc211_org2005gmdmediumFormat', True)

    
    mediumFormat = property(__mediumFormat.value, __mediumFormat.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __mediumNote.name() : __mediumNote,
        __name.name() : __name,
        __density.name() : __density,
        __densityUnits.name() : __densityUnits,
        __volumes.name() : __volumes,
        __mediumFormat.name() : __mediumFormat
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Medium_Type', MD_Medium_Type)


# Complex type CTD_ANON_2 with content type ELEMENT_ONLY
class CTD_ANON_2 (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = None
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}pos uses Python identifier pos
    __pos = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pos'), 'pos', '__httpwww_opengis_netgml3_2_CTD_ANON_2_httpwww_opengis_netgml3_2pos', True)

    
    pos = property(__pos.value, __pos.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}posList uses Python identifier posList
    __posList = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'posList'), 'posList', '__httpwww_opengis_netgml3_2_CTD_ANON_2_httpwww_opengis_netgml3_2posList', False)

    
    posList = property(__posList.value, __posList.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}pointProperty uses Python identifier pointProperty
    __pointProperty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pointProperty'), 'pointProperty', '__httpwww_opengis_netgml3_2_CTD_ANON_2_httpwww_opengis_netgml3_2pointProperty', True)

    
    pointProperty = property(__pointProperty.value, __pointProperty.set, None, u'This property element either references a point via the XLink-attributes or contains the point element. pointProperty is the predefined property which may be used by GML Application Schemas whenever a GML feature has a property with a value that is substitutable for Point.')


    _ElementMap = {
        __pos.name() : __pos,
        __posList.name() : __posList,
        __pointProperty.name() : __pointProperty
    }
    _AttributeMap = {
        
    }



# Complex type CI_Contact_Type with content type ELEMENT_ONLY
class CI_Contact_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_Contact_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}hoursOfService uses Python identifier hoursOfService
    __hoursOfService = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'hoursOfService'), 'hoursOfService', '__httpwww_isotc211_org2005gmd_CI_Contact_Type_httpwww_isotc211_org2005gmdhoursOfService', False)

    
    hoursOfService = property(__hoursOfService.value, __hoursOfService.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}onlineResource uses Python identifier onlineResource
    __onlineResource = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'onlineResource'), 'onlineResource', '__httpwww_isotc211_org2005gmd_CI_Contact_Type_httpwww_isotc211_org2005gmdonlineResource', False)

    
    onlineResource = property(__onlineResource.value, __onlineResource.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}phone uses Python identifier phone
    __phone = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'phone'), 'phone', '__httpwww_isotc211_org2005gmd_CI_Contact_Type_httpwww_isotc211_org2005gmdphone', False)

    
    phone = property(__phone.value, __phone.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}contactInstructions uses Python identifier contactInstructions
    __contactInstructions = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'contactInstructions'), 'contactInstructions', '__httpwww_isotc211_org2005gmd_CI_Contact_Type_httpwww_isotc211_org2005gmdcontactInstructions', False)

    
    contactInstructions = property(__contactInstructions.value, __contactInstructions.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}address uses Python identifier address
    __address = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'address'), 'address', '__httpwww_isotc211_org2005gmd_CI_Contact_Type_httpwww_isotc211_org2005gmdaddress', False)

    
    address = property(__address.value, __address.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __hoursOfService.name() : __hoursOfService,
        __onlineResource.name() : __onlineResource,
        __phone.name() : __phone,
        __contactInstructions.name() : __contactInstructions,
        __address.name() : __address
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_Contact_Type', CI_Contact_Type)


# Complex type EllipsoidalCSPropertyType with content type ELEMENT_ONLY
class EllipsoidalCSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'EllipsoidalCSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}EllipsoidalCS uses Python identifier EllipsoidalCS
    __EllipsoidalCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'EllipsoidalCS'), 'EllipsoidalCS', '__httpwww_opengis_netgml3_2_EllipsoidalCSPropertyType_httpwww_opengis_netgml3_2EllipsoidalCS', False)

    
    EllipsoidalCS = property(__EllipsoidalCS.value, __EllipsoidalCS.set, None, u'gml:EllipsoidalCS is a two- or three-dimensional coordinate system in which position is specified by geodetic latitude, geodetic longitude, and (in the three-dimensional case) ellipsoidal height. An EllipsoidalCS shall have two or three gml:axis property elements; the number of associations shall equal the dimension of the CS.')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_EllipsoidalCSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_EllipsoidalCSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_EllipsoidalCSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_EllipsoidalCSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_EllipsoidalCSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_EllipsoidalCSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_EllipsoidalCSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_EllipsoidalCSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_EllipsoidalCSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __EllipsoidalCS.name() : __EllipsoidalCS
    }
    _AttributeMap = {
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __role.name() : __role,
        __show.name() : __show,
        __href.name() : __href,
        __type.name() : __type,
        __arcrole.name() : __arcrole
    }
_Namespace_gml.addCategoryObject('typeBinding', u'EllipsoidalCSPropertyType', EllipsoidalCSPropertyType)


# Complex type AbstractDQ_PositionalAccuracy_Type with content type ELEMENT_ONLY
class AbstractDQ_PositionalAccuracy_Type (AbstractDQ_Element_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDQ_PositionalAccuracy_Type')
    # Base type is AbstractDQ_Element_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_Element_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_Element_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractDQ_PositionalAccuracy_Type', AbstractDQ_PositionalAccuracy_Type)


# Complex type UomVelocity_PropertyType with content type ELEMENT_ONLY
class UomVelocity_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'UomVelocity_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}UnitDefinition uses Python identifier UnitDefinition
    __UnitDefinition = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'UnitDefinition'), 'UnitDefinition', '__httpwww_isotc211_org2005gco_UomVelocity_PropertyType_httpwww_opengis_netgml3_2UnitDefinition', False)

    
    UnitDefinition = property(__UnitDefinition.value, __UnitDefinition.set, None, u'A gml:UnitDefinition is a general definition of a unit of measure. This generic element is used only for units for which no relationship with other units or units systems is known.\nThe content model of gml:UnitDefinition adds three additional properties to gml:Definition, gml:quantityType, gml:quantityTypeReference and gml:catalogSymbol.  \nThe gml:catalogSymbol property optionally gives the short symbol used for this unit. This element is usually used when the relationship of this unit to other units or units systems is unknown.')

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gco_UomVelocity_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gco_UomVelocity_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_UomVelocity_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gco_UomVelocity_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gco_UomVelocity_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gco_UomVelocity_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gco_UomVelocity_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gco_UomVelocity_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gco_UomVelocity_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)


    _ElementMap = {
        __UnitDefinition.name() : __UnitDefinition
    }
    _AttributeMap = {
        __actuate.name() : __actuate,
        __show.name() : __show,
        __nilReason.name() : __nilReason,
        __type.name() : __type,
        __href.name() : __href,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __uuidref.name() : __uuidref,
        __title.name() : __title
    }
_Namespace_gco.addCategoryObject('typeBinding', u'UomVelocity_PropertyType', UomVelocity_PropertyType)


# Complex type MD_GeometricObjectTypeCode_PropertyType with content type ELEMENT_ONLY
class MD_GeometricObjectTypeCode_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_GeometricObjectTypeCode_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_GeometricObjectTypeCode uses Python identifier MD_GeometricObjectTypeCode
    __MD_GeometricObjectTypeCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_GeometricObjectTypeCode'), 'MD_GeometricObjectTypeCode', '__httpwww_isotc211_org2005gmd_MD_GeometricObjectTypeCode_PropertyType_httpwww_isotc211_org2005gmdMD_GeometricObjectTypeCode', False)

    
    MD_GeometricObjectTypeCode = property(__MD_GeometricObjectTypeCode.value, __MD_GeometricObjectTypeCode.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_GeometricObjectTypeCode_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __MD_GeometricObjectTypeCode.name() : __MD_GeometricObjectTypeCode
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_GeometricObjectTypeCode_PropertyType', MD_GeometricObjectTypeCode_PropertyType)


# Complex type CompoundCRSPropertyType with content type ELEMENT_ONLY
class CompoundCRSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CompoundCRSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}CompoundCRS uses Python identifier CompoundCRS
    __CompoundCRS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'CompoundCRS'), 'CompoundCRS', '__httpwww_opengis_netgml3_2_CompoundCRSPropertyType_httpwww_opengis_netgml3_2CompoundCRS', False)

    
    CompoundCRS = property(__CompoundCRS.value, __CompoundCRS.set, None, u'gml:CompundCRS is a coordinate reference system describing the position of points through two or more independent coordinate reference systems. It is associated with a non-repeating sequence of two or more instances of SingleCRS.')

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_CompoundCRSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_CompoundCRSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CompoundCRSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_CompoundCRSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_CompoundCRSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_CompoundCRSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_CompoundCRSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_CompoundCRSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_CompoundCRSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __CompoundCRS.name() : __CompoundCRS
    }
    _AttributeMap = {
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show,
        __href.name() : __href,
        __type.name() : __type
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CompoundCRSPropertyType', CompoundCRSPropertyType)


# Complex type SurfacePatchArrayPropertyType with content type ELEMENT_ONLY
class SurfacePatchArrayPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SurfacePatchArrayPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractSurfacePatch uses Python identifier AbstractSurfacePatch
    __AbstractSurfacePatch = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractSurfacePatch'), 'AbstractSurfacePatch', '__httpwww_opengis_netgml3_2_SurfacePatchArrayPropertyType_httpwww_opengis_netgml3_2AbstractSurfacePatch', True)

    
    AbstractSurfacePatch = property(__AbstractSurfacePatch.value, __AbstractSurfacePatch.set, None, u'A surface patch defines a homogenuous portion of a surface. \nThe AbstractSurfacePatch element is the abstract head of the substituition group for all surface patch elements describing a continuous portion of a surface.\nAll surface patches shall have an attribute interpolation (declared in the types derived from gml:AbstractSurfacePatchType) specifying the interpolation mechanism used for the patch using gml:SurfaceInterpolationType.')


    _ElementMap = {
        __AbstractSurfacePatch.name() : __AbstractSurfacePatch
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'SurfacePatchArrayPropertyType', SurfacePatchArrayPropertyType)


# Complex type AbstractDS_Aggregate_Type with content type ELEMENT_ONLY
class AbstractDS_Aggregate_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDS_Aggregate_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}composedOf uses Python identifier composedOf
    __composedOf = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'composedOf'), 'composedOf', '__httpwww_isotc211_org2005gmd_AbstractDS_Aggregate_Type_httpwww_isotc211_org2005gmdcomposedOf', True)

    
    composedOf = property(__composedOf.value, __composedOf.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}superset uses Python identifier superset
    __superset = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'superset'), 'superset', '__httpwww_isotc211_org2005gmd_AbstractDS_Aggregate_Type_httpwww_isotc211_org2005gmdsuperset', True)

    
    superset = property(__superset.value, __superset.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}seriesMetadata uses Python identifier seriesMetadata
    __seriesMetadata = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'seriesMetadata'), 'seriesMetadata', '__httpwww_isotc211_org2005gmd_AbstractDS_Aggregate_Type_httpwww_isotc211_org2005gmdseriesMetadata', True)

    
    seriesMetadata = property(__seriesMetadata.value, __seriesMetadata.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}subset uses Python identifier subset
    __subset = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'subset'), 'subset', '__httpwww_isotc211_org2005gmd_AbstractDS_Aggregate_Type_httpwww_isotc211_org2005gmdsubset', True)

    
    subset = property(__subset.value, __subset.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __composedOf.name() : __composedOf,
        __superset.name() : __superset,
        __seriesMetadata.name() : __seriesMetadata,
        __subset.name() : __subset
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractDS_Aggregate_Type', AbstractDS_Aggregate_Type)


# Complex type DS_OtherAggregate_Type with content type ELEMENT_ONLY
class DS_OtherAggregate_Type (AbstractDS_Aggregate_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DS_OtherAggregate_Type')
    # Base type is AbstractDS_Aggregate_Type
    
    # Element composedOf ({http://www.isotc211.org/2005/gmd}composedOf) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Element superset ({http://www.isotc211.org/2005/gmd}superset) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Element seriesMetadata ({http://www.isotc211.org/2005/gmd}seriesMetadata) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Element subset ({http://www.isotc211.org/2005/gmd}subset) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDS_Aggregate_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDS_Aggregate_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DS_OtherAggregate_Type', DS_OtherAggregate_Type)


# Complex type DS_StereoMate_Type with content type ELEMENT_ONLY
class DS_StereoMate_Type (DS_OtherAggregate_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DS_StereoMate_Type')
    # Base type is DS_OtherAggregate_Type
    
    # Element composedOf ({http://www.isotc211.org/2005/gmd}composedOf) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Element superset ({http://www.isotc211.org/2005/gmd}superset) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Element seriesMetadata ({http://www.isotc211.org/2005/gmd}seriesMetadata) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Element subset ({http://www.isotc211.org/2005/gmd}subset) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = DS_OtherAggregate_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = DS_OtherAggregate_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DS_StereoMate_Type', DS_StereoMate_Type)


# Complex type TopoPointPropertyType with content type ELEMENT_ONLY
class TopoPointPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TopoPointPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TopoPoint uses Python identifier TopoPoint
    __TopoPoint = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TopoPoint'), 'TopoPoint', '__httpwww_opengis_netgml3_2_TopoPointPropertyType_httpwww_opengis_netgml3_2TopoPoint', False)

    
    TopoPoint = property(__TopoPoint.value, __TopoPoint.set, None, u'The intended use of gml:TopoPoint is to appear within a point feature to express the structural and possibly geometric relationships of this feature to other features via shared node definitions.')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_TopoPointPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)


    _ElementMap = {
        __TopoPoint.name() : __TopoPoint
    }
    _AttributeMap = {
        __owns.name() : __owns
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TopoPointPropertyType', TopoPointPropertyType)


# Complex type MD_Distributor_PropertyType with content type ELEMENT_ONLY
class MD_Distributor_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Distributor_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_Distributor uses Python identifier MD_Distributor
    __MD_Distributor = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Distributor'), 'MD_Distributor', '__httpwww_isotc211_org2005gmd_MD_Distributor_PropertyType_httpwww_isotc211_org2005gmdMD_Distributor', False)

    
    MD_Distributor = property(__MD_Distributor.value, __MD_Distributor.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_Distributor_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_Distributor_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_Distributor_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_Distributor_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_Distributor_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_Distributor_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_Distributor_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_Distributor_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_Distributor_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)


    _ElementMap = {
        __MD_Distributor.name() : __MD_Distributor
    }
    _AttributeMap = {
        __uuidref.name() : __uuidref,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __href.name() : __href,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __role.name() : __role
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Distributor_PropertyType', MD_Distributor_PropertyType)


# Complex type DQ_GriddedDataPositionalAccuracy_Type with content type ELEMENT_ONLY
class DQ_GriddedDataPositionalAccuracy_Type (AbstractDQ_PositionalAccuracy_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_GriddedDataPositionalAccuracy_Type')
    # Base type is AbstractDQ_PositionalAccuracy_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_PositionalAccuracy_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_PositionalAccuracy_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_GriddedDataPositionalAccuracy_Type', DQ_GriddedDataPositionalAccuracy_Type)


# Complex type LocalisedCharacterString_Type with content type SIMPLE
class LocalisedCharacterString_Type (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = pyxb.binding.datatypes.string
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'LocalisedCharacterString_Type')
    # Base type is pyxb.binding.datatypes.string
    
    # Attribute id uses Python identifier id
    __id = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'id'), 'id', '__httpwww_isotc211_org2005gmd_LocalisedCharacterString_Type_id', pyxb.binding.datatypes.ID)
    
    id = property(__id.value, __id.set, None, None)

    
    # Attribute locale uses Python identifier locale
    __locale = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'locale'), 'locale', '__httpwww_isotc211_org2005gmd_LocalisedCharacterString_Type_locale', pyxb.binding.datatypes.anyURI)
    
    locale = property(__locale.value, __locale.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __id.name() : __id,
        __locale.name() : __locale
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'LocalisedCharacterString_Type', LocalisedCharacterString_Type)


# Complex type UnitOfMeasureType with content type EMPTY
class UnitOfMeasureType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'UnitOfMeasureType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Attribute uom uses Python identifier uom
    __uom = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uom'), 'uom', '__httpwww_opengis_netgml3_2_UnitOfMeasureType_uom', UomIdentifier, required=True)
    
    uom = property(__uom.value, __uom.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __uom.name() : __uom
    }
_Namespace_gml.addCategoryObject('typeBinding', u'UnitOfMeasureType', UnitOfMeasureType)


# Complex type ConversionToPreferredUnitType with content type ELEMENT_ONLY
class ConversionToPreferredUnitType (UnitOfMeasureType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ConversionToPreferredUnitType')
    # Base type is UnitOfMeasureType
    
    # Element {http://www.opengis.net/gml/3.2}formula uses Python identifier formula
    __formula = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'formula'), 'formula', '__httpwww_opengis_netgml3_2_ConversionToPreferredUnitType_httpwww_opengis_netgml3_2formula', False)

    
    formula = property(__formula.value, __formula.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}factor uses Python identifier factor
    __factor = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'factor'), 'factor', '__httpwww_opengis_netgml3_2_ConversionToPreferredUnitType_httpwww_opengis_netgml3_2factor', False)

    
    factor = property(__factor.value, __factor.set, None, None)

    
    # Attribute uom inherited from {http://www.opengis.net/gml/3.2}UnitOfMeasureType

    _ElementMap = UnitOfMeasureType._ElementMap.copy()
    _ElementMap.update({
        __formula.name() : __formula,
        __factor.name() : __factor
    })
    _AttributeMap = UnitOfMeasureType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'ConversionToPreferredUnitType', ConversionToPreferredUnitType)


# Complex type KnotType with content type ELEMENT_ONLY
class KnotType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'KnotType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}weight uses Python identifier weight
    __weight = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'weight'), 'weight', '__httpwww_opengis_netgml3_2_KnotType_httpwww_opengis_netgml3_2weight', False)

    
    weight = property(__weight.value, __weight.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}value uses Python identifier value_
    __value = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'value'), 'value_', '__httpwww_opengis_netgml3_2_KnotType_httpwww_opengis_netgml3_2value', False)

    
    value_ = property(__value.value, __value.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}multiplicity uses Python identifier multiplicity
    __multiplicity = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'multiplicity'), 'multiplicity', '__httpwww_opengis_netgml3_2_KnotType_httpwww_opengis_netgml3_2multiplicity', False)

    
    multiplicity = property(__multiplicity.value, __multiplicity.set, None, None)


    _ElementMap = {
        __weight.name() : __weight,
        __value.name() : __value,
        __multiplicity.name() : __multiplicity
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'KnotType', KnotType)


# Complex type AbstractMemberType with content type EMPTY
class AbstractMemberType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractMemberType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_AbstractMemberType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __owns.name() : __owns
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractMemberType', AbstractMemberType)


# Complex type DictionaryEntryType with content type ELEMENT_ONLY
class DictionaryEntryType (AbstractMemberType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DictionaryEntryType')
    # Base type is AbstractMemberType
    
    # Element {http://www.opengis.net/gml/3.2}Definition uses Python identifier Definition
    __Definition = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Definition'), 'Definition', '__httpwww_opengis_netgml3_2_DictionaryEntryType_httpwww_opengis_netgml3_2Definition', False)

    
    Definition = property(__Definition.value, __Definition.set, None, u'The basic gml:Definition element specifies a definition, which can be included in or referenced by a dictionary. \nThe content model for a generic definition is a derivation from gml:AbstractGMLType.  \nThe gml:description property element shall hold the definition if this can be captured in a simple text string, or the gml:descriptionReference property element may carry a link to a description elsewhere.\nThe gml:identifier element shall provide one identifier identifying this definition. The identifier shall be unique within the dictionaries using this definition. \nThe gml:name elements shall provide zero or more terms and synonyms for which this is the definition.\nThe gml:remarks element shall be used to hold additional textual information that is not conceptually part of the definition but is useful in understanding the definition.')

    
    # Attribute owns inherited from {http://www.opengis.net/gml/3.2}AbstractMemberType
    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_DictionaryEntryType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_DictionaryEntryType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_DictionaryEntryType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_DictionaryEntryType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_DictionaryEntryType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_DictionaryEntryType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_DictionaryEntryType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_DictionaryEntryType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_DictionaryEntryType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = AbstractMemberType._ElementMap.copy()
    _ElementMap.update({
        __Definition.name() : __Definition
    })
    _AttributeMap = AbstractMemberType._AttributeMap.copy()
    _AttributeMap.update({
        __actuate.name() : __actuate,
        __show.name() : __show,
        __role.name() : __role,
        __href.name() : __href,
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason
    })
_Namespace_gml.addCategoryObject('typeBinding', u'DictionaryEntryType', DictionaryEntryType)


# Complex type AbstractDatumType with content type ELEMENT_ONLY
class AbstractDatumType (IdentifiedObjectType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractDatumType')
    # Base type is IdentifiedObjectType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}scope uses Python identifier scope
    __scope = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'scope'), 'scope', '__httpwww_opengis_netgml3_2_AbstractDatumType_httpwww_opengis_netgml3_2scope', True)

    
    scope = property(__scope.value, __scope.set, None, u'The gml:scope property provides a description of the usage, or limitations of usage, for which this CRS-related object is valid. If unknown, enter "not known".')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}domainOfValidity uses Python identifier domainOfValidity
    __domainOfValidity = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'domainOfValidity'), 'domainOfValidity', '__httpwww_opengis_netgml3_2_AbstractDatumType_httpwww_opengis_netgml3_2domainOfValidity', False)

    
    domainOfValidity = property(__domainOfValidity.value, __domainOfValidity.set, None, u'The gml:domainOfValidity property implements an association role to an EX_Extent object as encoded in ISO/TS 19139, either referencing or containing the definition of that extent.')

    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}anchorDefinition uses Python identifier anchorDefinition
    __anchorDefinition = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'anchorDefinition'), 'anchorDefinition', '__httpwww_opengis_netgml3_2_AbstractDatumType_httpwww_opengis_netgml3_2anchorDefinition', False)

    
    anchorDefinition = property(__anchorDefinition.value, __anchorDefinition.set, None, u'gml:anchorDefinition is a description, possibly including coordinates, of the definition used to anchor the datum to the Earth. Also known as the "origin", especially for engineering and image datums. The codeSpace attribute may be used to reference a source of more detailed on this point or surface, or on a set of such descriptions.\n-\tFor a geodetic datum, this point is also known as the fundamental point, which is traditionally the point where the relationship between geoid and ellipsoid is defined. In some cases, the "fundamental point" may consist of a number of points. In those cases, the parameters defining the geoid/ellipsoid relationship have been averaged for these points, and the averages adopted as the datum definition.\n-\tFor an engineering datum, the anchor definition may be a physical point, or it may be a point with defined coordinates in another CRS.may\n-\tFor an image datum, the anchor definition is usually either the centre of the image or the corner of the image.\n-\tFor a temporal datum, this attribute is not defined. Instead of the anchor definition, a temporal datum carries a separate time origin of type DateTime.')

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}realizationEpoch uses Python identifier realizationEpoch
    __realizationEpoch = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'realizationEpoch'), 'realizationEpoch', '__httpwww_opengis_netgml3_2_AbstractDatumType_httpwww_opengis_netgml3_2realizationEpoch', False)

    
    realizationEpoch = property(__realizationEpoch.value, __realizationEpoch.set, None, u'gml:realizationEpoch is the time after which this datum definition is valid. See ISO 19111 Table 32 for details.')

    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = IdentifiedObjectType._ElementMap.copy()
    _ElementMap.update({
        __scope.name() : __scope,
        __domainOfValidity.name() : __domainOfValidity,
        __anchorDefinition.name() : __anchorDefinition,
        __realizationEpoch.name() : __realizationEpoch
    })
    _AttributeMap = IdentifiedObjectType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractDatumType', AbstractDatumType)


# Complex type ImageDatumType with content type ELEMENT_ONLY
class ImageDatumType (AbstractDatumType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ImageDatumType')
    # Base type is AbstractDatumType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element anchorDefinition ({http://www.opengis.net/gml/3.2}anchorDefinition) inherited from {http://www.opengis.net/gml/3.2}AbstractDatumType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractDatumType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}pixelInCell uses Python identifier pixelInCell
    __pixelInCell = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pixelInCell'), 'pixelInCell', '__httpwww_opengis_netgml3_2_ImageDatumType_httpwww_opengis_netgml3_2pixelInCell', False)

    
    pixelInCell = property(__pixelInCell.value, __pixelInCell.set, None, u'gml:pixelInCell is a specification of the way an image grid is associated with the image data attributes. The required codeSpace attribute shall reference a source of information specifying the values and meanings of all the allowed string values for this property.')

    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractDatumType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element realizationEpoch ({http://www.opengis.net/gml/3.2}realizationEpoch) inherited from {http://www.opengis.net/gml/3.2}AbstractDatumType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractDatumType._ElementMap.copy()
    _ElementMap.update({
        __pixelInCell.name() : __pixelInCell
    })
    _AttributeMap = AbstractDatumType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'ImageDatumType', ImageDatumType)


# Complex type UserDefinedCSType with content type ELEMENT_ONLY
class UserDefinedCSType (AbstractCoordinateSystemType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'UserDefinedCSType')
    # Base type is AbstractCoordinateSystemType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element axis ({http://www.opengis.net/gml/3.2}axis) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute aggregationType inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCoordinateSystemType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractCoordinateSystemType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'UserDefinedCSType', UserDefinedCSType)


# Complex type AbstractRingPropertyType with content type ELEMENT_ONLY
class AbstractRingPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractRingPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractRing uses Python identifier AbstractRing
    __AbstractRing = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractRing'), 'AbstractRing', '__httpwww_opengis_netgml3_2_AbstractRingPropertyType_httpwww_opengis_netgml3_2AbstractRing', False)

    
    AbstractRing = property(__AbstractRing.value, __AbstractRing.set, None, u'An abstraction of a ring to support surface boundaries of different complexity.\nThe AbstractRing element is the abstract head of the substituition group for all closed boundaries of a surface patch.')


    _ElementMap = {
        __AbstractRing.name() : __AbstractRing
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractRingPropertyType', AbstractRingPropertyType)


# Complex type AbstractRingType with content type EMPTY
class AbstractRingType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractRingType')
    # Base type is pyxb.binding.datatypes.anyType

    _ElementMap = {
        
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractRingType', AbstractRingType)


# Complex type CI_OnlineResource_Type with content type ELEMENT_ONLY
class CI_OnlineResource_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_OnlineResource_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}applicationProfile uses Python identifier applicationProfile
    __applicationProfile = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'applicationProfile'), 'applicationProfile', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_Type_httpwww_isotc211_org2005gmdapplicationProfile', False)

    
    applicationProfile = property(__applicationProfile.value, __applicationProfile.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}linkage uses Python identifier linkage
    __linkage = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'linkage'), 'linkage', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_Type_httpwww_isotc211_org2005gmdlinkage', False)

    
    linkage = property(__linkage.value, __linkage.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}protocol uses Python identifier protocol
    __protocol = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'protocol'), 'protocol', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_Type_httpwww_isotc211_org2005gmdprotocol', False)

    
    protocol = property(__protocol.value, __protocol.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}name uses Python identifier name
    __name = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'name'), 'name', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_Type_httpwww_isotc211_org2005gmdname', False)

    
    name = property(__name.value, __name.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}description uses Python identifier description
    __description = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'description'), 'description', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_Type_httpwww_isotc211_org2005gmddescription', False)

    
    description = property(__description.value, __description.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}function uses Python identifier function
    __function = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'function'), 'function', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_Type_httpwww_isotc211_org2005gmdfunction', False)

    
    function = property(__function.value, __function.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __applicationProfile.name() : __applicationProfile,
        __linkage.name() : __linkage,
        __protocol.name() : __protocol,
        __name.name() : __name,
        __description.name() : __description,
        __function.name() : __function
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_OnlineResource_Type', CI_OnlineResource_Type)


# Complex type ImageCRSPropertyType with content type ELEMENT_ONLY
class ImageCRSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ImageCRSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}ImageCRS uses Python identifier ImageCRS
    __ImageCRS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'ImageCRS'), 'ImageCRS', '__httpwww_opengis_netgml3_2_ImageCRSPropertyType_httpwww_opengis_netgml3_2ImageCRS', False)

    
    ImageCRS = property(__ImageCRS.value, __ImageCRS.set, None, u'gml:ImageCRS is an engineering coordinate reference system applied to locations in images. Image coordinate reference systems are treated as a separate sub-type because the definition of the associated image datum contains two attributes not relevant to other engineering datums.')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_ImageCRSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_ImageCRSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_ImageCRSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_ImageCRSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_ImageCRSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_ImageCRSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_ImageCRSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_ImageCRSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_ImageCRSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)


    _ElementMap = {
        __ImageCRS.name() : __ImageCRS
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show,
        __role.name() : __role,
        __href.name() : __href,
        __actuate.name() : __actuate,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __title.name() : __title
    }
_Namespace_gml.addCategoryObject('typeBinding', u'ImageCRSPropertyType', ImageCRSPropertyType)


# Complex type ImageCRSType with content type ELEMENT_ONLY
class ImageCRSType (AbstractCRSType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ImageCRSType')
    # Base type is AbstractCRSType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element {http://www.opengis.net/gml/3.2}cartesianCS uses Python identifier cartesianCS
    __cartesianCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'cartesianCS'), 'cartesianCS', '__httpwww_opengis_netgml3_2_ImageCRSType_httpwww_opengis_netgml3_2cartesianCS', False)

    
    cartesianCS = property(__cartesianCS.value, __cartesianCS.set, None, u'gml:cartesianCS is an association role to the Cartesian coordinate system used by this CRS.')

    
    # Element {http://www.opengis.net/gml/3.2}affineCS uses Python identifier affineCS
    __affineCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'affineCS'), 'affineCS', '__httpwww_opengis_netgml3_2_ImageCRSType_httpwww_opengis_netgml3_2affineCS', False)

    
    affineCS = property(__affineCS.value, __affineCS.set, None, u'gml:affineCS is an association role to the affine coordinate system used by this CRS.')

    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element {http://www.opengis.net/gml/3.2}imageDatum uses Python identifier imageDatum
    __imageDatum = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'imageDatum'), 'imageDatum', '__httpwww_opengis_netgml3_2_ImageCRSType_httpwww_opengis_netgml3_2imageDatum', False)

    
    imageDatum = property(__imageDatum.value, __imageDatum.set, None, u'gml:imageDatum is an association role to the image datum used by this CRS.')

    
    # Element {http://www.opengis.net/gml/3.2}usesObliqueCartesianCS uses Python identifier usesObliqueCartesianCS
    __usesObliqueCartesianCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'usesObliqueCartesianCS'), 'usesObliqueCartesianCS', '__httpwww_opengis_netgml3_2_ImageCRSType_httpwww_opengis_netgml3_2usesObliqueCartesianCS', False)

    
    usesObliqueCartesianCS = property(__usesObliqueCartesianCS.value, __usesObliqueCartesianCS.set, None, u'')

    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCRSType._ElementMap.copy()
    _ElementMap.update({
        __cartesianCS.name() : __cartesianCS,
        __affineCS.name() : __affineCS,
        __imageDatum.name() : __imageDatum,
        __usesObliqueCartesianCS.name() : __usesObliqueCartesianCS
    })
    _AttributeMap = AbstractCRSType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'ImageCRSType', ImageCRSType)


# Complex type TopoPrimitiveMemberType with content type ELEMENT_ONLY
class TopoPrimitiveMemberType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TopoPrimitiveMemberType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractTopoPrimitive uses Python identifier AbstractTopoPrimitive
    __AbstractTopoPrimitive = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTopoPrimitive'), 'AbstractTopoPrimitive', '__httpwww_opengis_netgml3_2_TopoPrimitiveMemberType_httpwww_opengis_netgml3_2AbstractTopoPrimitive', False)

    
    AbstractTopoPrimitive = property(__AbstractTopoPrimitive.value, __AbstractTopoPrimitive.set, None, u'gml:AbstractTopoPrimitive acts as the base type for all topological primitives. Topology primitives are the atomic (smallest possible) units of a topology complex. \nEach topology primitive may contain references to other topology primitives of codimension 2 or more (gml:isolated). Conversely, nodes may have faces as containers and nodes and edges may have solids as containers (gml:container).')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_TopoPrimitiveMemberType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TopoPrimitiveMemberType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TopoPrimitiveMemberType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TopoPrimitiveMemberType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TopoPrimitiveMemberType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TopoPrimitiveMemberType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TopoPrimitiveMemberType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TopoPrimitiveMemberType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TopoPrimitiveMemberType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TopoPrimitiveMemberType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __AbstractTopoPrimitive.name() : __AbstractTopoPrimitive
    }
    _AttributeMap = {
        __owns.name() : __owns,
        __href.name() : __href,
        __title.name() : __title,
        __show.name() : __show,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __remoteSchema.name() : __remoteSchema,
        __type.name() : __type,
        __actuate.name() : __actuate
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TopoPrimitiveMemberType', TopoPrimitiveMemberType)


# Complex type PolygonType with content type ELEMENT_ONLY
class PolygonType (AbstractSurfaceType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'PolygonType')
    # Base type is AbstractSurfaceType
    
    # Element {http://www.opengis.net/gml/3.2}exterior uses Python identifier exterior
    __exterior = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'exterior'), 'exterior', '__httpwww_opengis_netgml3_2_PolygonType_httpwww_opengis_netgml3_2exterior', False)

    
    exterior = property(__exterior.value, __exterior.set, None, u'A boundary of a surface consists of a number of rings. In the normal 2D case, one of these rings is distinguished as being the exterior boundary. In a general manifold this is not always possible, in which case all boundaries shall be listed as interior boundaries, and the exterior will be empty.')

    
    # Element {http://www.opengis.net/gml/3.2}interior uses Python identifier interior
    __interior = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'interior'), 'interior', '__httpwww_opengis_netgml3_2_PolygonType_httpwww_opengis_netgml3_2interior', True)

    
    interior = property(__interior.value, __interior.set, None, u'A boundary of a surface consists of a number of rings. The "interior" rings separate the surface / surface patch from the area enclosed by the rings.')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractSurfaceType._ElementMap.copy()
    _ElementMap.update({
        __exterior.name() : __exterior,
        __interior.name() : __interior
    })
    _AttributeMap = AbstractSurfaceType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'PolygonType', PolygonType)


# Complex type MappingRuleType with content type ELEMENT_ONLY
class MappingRuleType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'MappingRuleType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}ruleReference uses Python identifier ruleReference
    __ruleReference = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'ruleReference'), 'ruleReference', '__httpwww_opengis_netgml3_2_MappingRuleType_httpwww_opengis_netgml3_2ruleReference', False)

    
    ruleReference = property(__ruleReference.value, __ruleReference.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}ruleDefinition uses Python identifier ruleDefinition
    __ruleDefinition = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'ruleDefinition'), 'ruleDefinition', '__httpwww_opengis_netgml3_2_MappingRuleType_httpwww_opengis_netgml3_2ruleDefinition', False)

    
    ruleDefinition = property(__ruleDefinition.value, __ruleDefinition.set, None, None)


    _ElementMap = {
        __ruleReference.name() : __ruleReference,
        __ruleDefinition.name() : __ruleDefinition
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'MappingRuleType', MappingRuleType)


# Complex type MD_CharacterSetCode_PropertyType with content type ELEMENT_ONLY
class MD_CharacterSetCode_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_CharacterSetCode_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_CharacterSetCode uses Python identifier MD_CharacterSetCode
    __MD_CharacterSetCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_CharacterSetCode'), 'MD_CharacterSetCode', '__httpwww_isotc211_org2005gmd_MD_CharacterSetCode_PropertyType_httpwww_isotc211_org2005gmdMD_CharacterSetCode', False)

    
    MD_CharacterSetCode = property(__MD_CharacterSetCode.value, __MD_CharacterSetCode.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_CharacterSetCode_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __MD_CharacterSetCode.name() : __MD_CharacterSetCode
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_CharacterSetCode_PropertyType', MD_CharacterSetCode_PropertyType)


# Complex type DQ_DataQuality_Type with content type ELEMENT_ONLY
class DQ_DataQuality_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_DataQuality_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}lineage uses Python identifier lineage
    __lineage = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'lineage'), 'lineage', '__httpwww_isotc211_org2005gmd_DQ_DataQuality_Type_httpwww_isotc211_org2005gmdlineage', False)

    
    lineage = property(__lineage.value, __lineage.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}report uses Python identifier report
    __report = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'report'), 'report', '__httpwww_isotc211_org2005gmd_DQ_DataQuality_Type_httpwww_isotc211_org2005gmdreport', True)

    
    report = property(__report.value, __report.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}scope uses Python identifier scope
    __scope = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'scope'), 'scope', '__httpwww_isotc211_org2005gmd_DQ_DataQuality_Type_httpwww_isotc211_org2005gmdscope', False)

    
    scope = property(__scope.value, __scope.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __lineage.name() : __lineage,
        __report.name() : __report,
        __scope.name() : __scope
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_DataQuality_Type', DQ_DataQuality_Type)


# Complex type OrientableCurveType with content type ELEMENT_ONLY
class OrientableCurveType (AbstractCurveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'OrientableCurveType')
    # Base type is AbstractCurveType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}baseCurve uses Python identifier baseCurve
    __baseCurve = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'baseCurve'), 'baseCurve', '__httpwww_opengis_netgml3_2_OrientableCurveType_httpwww_opengis_netgml3_2baseCurve', False)

    
    baseCurve = property(__baseCurve.value, __baseCurve.set, None, u'The property baseCurve references or contains the base curve, i.e. it either references the base curve via the XLink-attributes or contains the curve element. A curve element is any element which is substitutable for AbstractCurve. The base curve has positive orientation.')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute orientation uses Python identifier orientation
    __orientation = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'orientation'), 'orientation', '__httpwww_opengis_netgml3_2_OrientableCurveType_orientation', SignType, unicode_default=u'+')
    
    orientation = property(__orientation.value, __orientation.set, None, None)

    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType

    _ElementMap = AbstractCurveType._ElementMap.copy()
    _ElementMap.update({
        __baseCurve.name() : __baseCurve
    })
    _AttributeMap = AbstractCurveType._AttributeMap.copy()
    _AttributeMap.update({
        __orientation.name() : __orientation
    })
_Namespace_gml.addCategoryObject('typeBinding', u'OrientableCurveType', OrientableCurveType)


# Complex type TemporalCRSPropertyType with content type ELEMENT_ONLY
class TemporalCRSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TemporalCRSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TemporalCRS uses Python identifier TemporalCRS
    __TemporalCRS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TemporalCRS'), 'TemporalCRS', '__httpwww_opengis_netgml3_2_TemporalCRSPropertyType_httpwww_opengis_netgml3_2TemporalCRS', False)

    
    TemporalCRS = property(__TemporalCRS.value, __TemporalCRS.set, None, u'gml:TemporalCRS is a 1D coordinate reference system used for the recording of time.')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TemporalCRSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TemporalCRSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TemporalCRSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TemporalCRSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TemporalCRSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TemporalCRSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TemporalCRSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TemporalCRSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TemporalCRSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')


    _ElementMap = {
        __TemporalCRS.name() : __TemporalCRS
    }
    _AttributeMap = {
        __title.name() : __title,
        __href.name() : __href,
        __role.name() : __role,
        __type.name() : __type,
        __show.name() : __show,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __remoteSchema.name() : __remoteSchema
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TemporalCRSPropertyType', TemporalCRSPropertyType)


# Complex type GridLimitsType with content type ELEMENT_ONLY
class GridLimitsType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'GridLimitsType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}GridEnvelope uses Python identifier GridEnvelope
    __GridEnvelope = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'GridEnvelope'), 'GridEnvelope', '__httpwww_opengis_netgml3_2_GridLimitsType_httpwww_opengis_netgml3_2GridEnvelope', False)

    
    GridEnvelope = property(__GridEnvelope.value, __GridEnvelope.set, None, None)


    _ElementMap = {
        __GridEnvelope.name() : __GridEnvelope
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'GridLimitsType', GridLimitsType)


# Complex type UnitDefinitionType with content type ELEMENT_ONLY
class UnitDefinitionType (DefinitionType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'UnitDefinitionType')
    # Base type is DefinitionType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element {http://www.opengis.net/gml/3.2}catalogSymbol uses Python identifier catalogSymbol
    __catalogSymbol = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'catalogSymbol'), 'catalogSymbol', '__httpwww_opengis_netgml3_2_UnitDefinitionType_httpwww_opengis_netgml3_2catalogSymbol', False)

    
    catalogSymbol = property(__catalogSymbol.value, __catalogSymbol.set, None, u'The catalogSymbol is the preferred lexical symbol used for this unit of measure.\nThe codeSpace attribute in gml:CodeType identifies a namespace for the catalog symbol value, and might reference the external catalog. The string value in gml:CodeType contains the value of a symbol that should be unique within this catalog namespace. This symbol often appears explicitly in the catalog, but it could be a combination of symbols using a specified algebra of units.')

    
    # Element {http://www.opengis.net/gml/3.2}quantityType uses Python identifier quantityType
    __quantityType = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'quantityType'), 'quantityType', '__httpwww_opengis_netgml3_2_UnitDefinitionType_httpwww_opengis_netgml3_2quantityType', False)

    
    quantityType = property(__quantityType.value, __quantityType.set, None, u'The gml:quantityType property indicates the phenomenon to which the units apply. This element contains an informal description of the phenomenon or type of physical quantity that is measured or observed. When the physical quantity is the result of an observation or measurement, this term is known as observable type or measurand.\nThe use of gml:quantityType for references to remote values is deprecated.')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}quantityTypeReference uses Python identifier quantityTypeReference
    __quantityTypeReference = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'quantityTypeReference'), 'quantityTypeReference', '__httpwww_opengis_netgml3_2_UnitDefinitionType_httpwww_opengis_netgml3_2quantityTypeReference', False)

    
    quantityTypeReference = property(__quantityTypeReference.value, __quantityTypeReference.set, None, u'The gml:quantityTypeReference property indicates the phenomenon to which the units apply. The content is a reference to a remote value.')

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = DefinitionType._ElementMap.copy()
    _ElementMap.update({
        __catalogSymbol.name() : __catalogSymbol,
        __quantityType.name() : __quantityType,
        __quantityTypeReference.name() : __quantityTypeReference
    })
    _AttributeMap = DefinitionType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'UnitDefinitionType', UnitDefinitionType)


# Complex type Angle_PropertyType with content type ELEMENT_ONLY
class Angle_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Angle_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}Angle uses Python identifier Angle
    __Angle = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'Angle'), 'Angle', '__httpwww_isotc211_org2005gco_Angle_PropertyType_httpwww_isotc211_org2005gcoAngle', False)

    
    Angle = property(__Angle.value, __Angle.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_Angle_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __Angle.name() : __Angle
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'Angle_PropertyType', Angle_PropertyType)


# Complex type AbstractFeatureMemberType with content type EMPTY
class AbstractFeatureMemberType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractFeatureMemberType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_AbstractFeatureMemberType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __owns.name() : __owns
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractFeatureMemberType', AbstractFeatureMemberType)


# Complex type DynamicFeatureMemberType with content type ELEMENT_ONLY
class DynamicFeatureMemberType (AbstractFeatureMemberType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DynamicFeatureMemberType')
    # Base type is AbstractFeatureMemberType
    
    # Element {http://www.opengis.net/gml/3.2}DynamicFeature uses Python identifier DynamicFeature
    __DynamicFeature = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'DynamicFeature'), 'DynamicFeature', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_opengis_netgml3_2DynamicFeature', True)

    
    DynamicFeature = property(__DynamicFeature.value, __DynamicFeature.set, None, u"States are captured by time-stamped instances of a feature. The content model extends the standard gml:AbstractFeatureType with the gml:dynamicProperties model group.\nEach time-stamped instance represents a 'snapshot' of a feature. The dynamic feature classes will normally be extended to suit particular applications.  A dynamic feature bears either a time stamp or a history.")

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute owns inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureMemberType
    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = AbstractFeatureMemberType._ElementMap.copy()
    _ElementMap.update({
        __DynamicFeature.name() : __DynamicFeature
    })
    _AttributeMap = AbstractFeatureMemberType._AttributeMap.copy()
    _AttributeMap.update({
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __remoteSchema.name() : __remoteSchema,
        __role.name() : __role,
        __show.name() : __show,
        __title.name() : __title,
        __type.name() : __type,
        __actuate.name() : __actuate,
        __arcrole.name() : __arcrole
    })
_Namespace_gml.addCategoryObject('typeBinding', u'DynamicFeatureMemberType', DynamicFeatureMemberType)


# Complex type MultiplicityRange_Type with content type ELEMENT_ONLY
class MultiplicityRange_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'MultiplicityRange_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gco}lower uses Python identifier lower
    __lower = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'lower'), 'lower', '__httpwww_isotc211_org2005gco_MultiplicityRange_Type_httpwww_isotc211_org2005gcolower', False)

    
    lower = property(__lower.value, __lower.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gco}upper uses Python identifier upper
    __upper = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'upper'), 'upper', '__httpwww_isotc211_org2005gco_MultiplicityRange_Type_httpwww_isotc211_org2005gcoupper', False)

    
    upper = property(__upper.value, __upper.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __lower.name() : __lower,
        __upper.name() : __upper
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gco.addCategoryObject('typeBinding', u'MultiplicityRange_Type', MultiplicityRange_Type)


# Complex type DS_Initiative_Type with content type ELEMENT_ONLY
class DS_Initiative_Type (AbstractDS_Aggregate_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DS_Initiative_Type')
    # Base type is AbstractDS_Aggregate_Type
    
    # Element composedOf ({http://www.isotc211.org/2005/gmd}composedOf) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Element superset ({http://www.isotc211.org/2005/gmd}superset) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Element seriesMetadata ({http://www.isotc211.org/2005/gmd}seriesMetadata) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Element subset ({http://www.isotc211.org/2005/gmd}subset) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDS_Aggregate_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDS_Aggregate_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DS_Initiative_Type', DS_Initiative_Type)


# Complex type CartesianCSPropertyType with content type ELEMENT_ONLY
class CartesianCSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CartesianCSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}CartesianCS uses Python identifier CartesianCS
    __CartesianCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'CartesianCS'), 'CartesianCS', '__httpwww_opengis_netgml3_2_CartesianCSPropertyType_httpwww_opengis_netgml3_2CartesianCS', False)

    
    CartesianCS = property(__CartesianCS.value, __CartesianCS.set, None, u'gml:CartesianCS is a 1-, 2-, or 3-dimensional coordinate system. In the 1-dimensional case, it contains a single straight coordinate axis. In the 2- and 3-dimensional cases gives the position of points relative to orthogonal straight axes. In the multi-dimensional case, all axes shall have the same length unit of measure. A CartesianCS shall have one, two, or three gml:axis property elements.')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_CartesianCSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_CartesianCSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_CartesianCSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_CartesianCSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_CartesianCSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_CartesianCSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_CartesianCSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_CartesianCSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CartesianCSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __CartesianCS.name() : __CartesianCS
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __role.name() : __role,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __title.name() : __title,
        __nilReason.name() : __nilReason
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CartesianCSPropertyType', CartesianCSPropertyType)


# Complex type DynamicFeatureType with content type ELEMENT_ONLY
class DynamicFeatureType (AbstractFeatureType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DynamicFeatureType')
    # Base type is AbstractFeatureType
    
    # Element {http://www.opengis.net/gml/3.2}validTime uses Python identifier validTime
    __validTime = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'validTime'), 'validTime', '__httpwww_opengis_netgml3_2_DynamicFeatureType_httpwww_opengis_netgml3_2validTime', False)

    
    validTime = property(__validTime.value, __validTime.set, None, u'gml:validTime is a convenience property element.')

    
    # Element {http://www.opengis.net/gml/3.2}dataSource uses Python identifier dataSource
    __dataSource = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'dataSource'), 'dataSource', '__httpwww_opengis_netgml3_2_DynamicFeatureType_httpwww_opengis_netgml3_2dataSource', False)

    
    dataSource = property(__dataSource.value, __dataSource.set, None, u'Evidence is represented by a simple gml:dataSource or gml:dataSourceReference property that indicates the source of the temporal data. The remote link attributes of the gml:dataSource element have been deprecated along with its current type.')

    
    # Element {http://www.opengis.net/gml/3.2}history uses Python identifier history
    __history = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'history'), 'history', '__httpwww_opengis_netgml3_2_DynamicFeatureType_httpwww_opengis_netgml3_2history', False)

    
    history = property(__history.value, __history.set, None, u'A generic sequence of events constitute a gml:history of an object.\nThe gml:history element contains a set of elements in the substitution group headed by the abstract element gml:AbstractTimeSlice, representing the time-varying properties of interest. The history property of a dynamic feature associates a feature instance with a sequence of time slices (i.e. change events) that encapsulate the evolution of the feature.')

    
    # Element {http://www.opengis.net/gml/3.2}dataSourceReference uses Python identifier dataSourceReference
    __dataSourceReference = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'dataSourceReference'), 'dataSourceReference', '__httpwww_opengis_netgml3_2_DynamicFeatureType_httpwww_opengis_netgml3_2dataSourceReference', False)

    
    dataSourceReference = property(__dataSourceReference.value, __dataSourceReference.set, None, u'Evidence is represented by a simple gml:dataSource or gml:dataSourceReference property that indicates the source of the temporal data.')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element boundedBy ({http://www.opengis.net/gml/3.2}boundedBy) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element location ({http://www.opengis.net/gml/3.2}location) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractFeatureType._ElementMap.copy()
    _ElementMap.update({
        __validTime.name() : __validTime,
        __dataSource.name() : __dataSource,
        __history.name() : __history,
        __dataSourceReference.name() : __dataSourceReference
    })
    _AttributeMap = AbstractFeatureType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'DynamicFeatureType', DynamicFeatureType)


# Complex type EX_SpatialTemporalExtent_PropertyType with content type ELEMENT_ONLY
class EX_SpatialTemporalExtent_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'EX_SpatialTemporalExtent_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}EX_SpatialTemporalExtent uses Python identifier EX_SpatialTemporalExtent
    __EX_SpatialTemporalExtent = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'EX_SpatialTemporalExtent'), 'EX_SpatialTemporalExtent', '__httpwww_isotc211_org2005gmd_EX_SpatialTemporalExtent_PropertyType_httpwww_isotc211_org2005gmdEX_SpatialTemporalExtent', False)

    
    EX_SpatialTemporalExtent = property(__EX_SpatialTemporalExtent.value, __EX_SpatialTemporalExtent.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_EX_SpatialTemporalExtent_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_EX_SpatialTemporalExtent_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_EX_SpatialTemporalExtent_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_EX_SpatialTemporalExtent_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_EX_SpatialTemporalExtent_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_EX_SpatialTemporalExtent_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_EX_SpatialTemporalExtent_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_EX_SpatialTemporalExtent_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_EX_SpatialTemporalExtent_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __EX_SpatialTemporalExtent.name() : __EX_SpatialTemporalExtent
    }
    _AttributeMap = {
        __uuidref.name() : __uuidref,
        __role.name() : __role,
        __title.name() : __title,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __show.name() : __show,
        __type.name() : __type,
        __arcrole.name() : __arcrole
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'EX_SpatialTemporalExtent_PropertyType', EX_SpatialTemporalExtent_PropertyType)


# Complex type CodeListType with content type SIMPLE
class CodeListType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = NameList
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CodeListType')
    # Base type is NameList
    
    # Attribute codeSpace uses Python identifier codeSpace
    __codeSpace = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'codeSpace'), 'codeSpace', '__httpwww_opengis_netgml3_2_CodeListType_codeSpace', pyxb.binding.datatypes.anyURI)
    
    codeSpace = property(__codeSpace.value, __codeSpace.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __codeSpace.name() : __codeSpace
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CodeListType', CodeListType)


# Complex type CompositeSurfaceType with content type ELEMENT_ONLY
class CompositeSurfaceType (AbstractSurfaceType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CompositeSurfaceType')
    # Base type is AbstractSurfaceType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}surfaceMember uses Python identifier surfaceMember
    __surfaceMember = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'surfaceMember'), 'surfaceMember', '__httpwww_opengis_netgml3_2_CompositeSurfaceType_httpwww_opengis_netgml3_2surfaceMember', True)

    
    surfaceMember = property(__surfaceMember.value, __surfaceMember.set, None, u'This property element either references a surface via the XLink-attributes or contains the surface element. A surface element is any element, which is substitutable for gml:AbstractSurface.')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_CompositeSurfaceType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)

    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType

    _ElementMap = AbstractSurfaceType._ElementMap.copy()
    _ElementMap.update({
        __surfaceMember.name() : __surfaceMember
    })
    _AttributeMap = AbstractSurfaceType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'CompositeSurfaceType', CompositeSurfaceType)


# Complex type MetaDataPropertyType with content type ELEMENT_ONLY
class MetaDataPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'MetaDataPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractMetaData uses Python identifier AbstractMetaData
    __AbstractMetaData = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractMetaData'), 'AbstractMetaData', '__httpwww_opengis_netgml3_2_MetaDataPropertyType_httpwww_opengis_netgml3_2AbstractMetaData', False)

    
    AbstractMetaData = property(__AbstractMetaData.value, __AbstractMetaData.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_MetaDataPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_MetaDataPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute about uses Python identifier about
    __about = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'about'), 'about', '__httpwww_opengis_netgml3_2_MetaDataPropertyType_about', pyxb.binding.datatypes.anyURI)
    
    about = property(__about.value, __about.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_MetaDataPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_MetaDataPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_MetaDataPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_MetaDataPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_MetaDataPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_MetaDataPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_MetaDataPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __AbstractMetaData.name() : __AbstractMetaData
    }
    _AttributeMap = {
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __about.name() : __about,
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema,
        __actuate.name() : __actuate,
        __nilReason.name() : __nilReason,
        __show.name() : __show,
        __href.name() : __href,
        __type.name() : __type
    }
_Namespace_gml.addCategoryObject('typeBinding', u'MetaDataPropertyType', MetaDataPropertyType)


# Complex type CoordinateSystemPropertyType with content type ELEMENT_ONLY
class CoordinateSystemPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CoordinateSystemPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractCoordinateSystem uses Python identifier AbstractCoordinateSystem
    __AbstractCoordinateSystem = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCoordinateSystem'), 'AbstractCoordinateSystem', '__httpwww_opengis_netgml3_2_CoordinateSystemPropertyType_httpwww_opengis_netgml3_2AbstractCoordinateSystem', False)

    
    AbstractCoordinateSystem = property(__AbstractCoordinateSystem.value, __AbstractCoordinateSystem.set, None, u'gml:AbstractCoordinateSystem is a coordinate system (CS) is the non-repeating sequence of coordinate system axes that spans a given coordinate space. A CS is derived from a set of mathematical rules for specifying how coordinates in a given space are to be assigned to points. The coordinate values in a coordinate tuple shall be recorded in the order in which the coordinate system axes associations are recorded. This abstract complex type shall not be used, extended, or restricted, in an Application Schema, to define a concrete subtype with a meaning equivalent to a concrete subtype specified in this document.')

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CoordinateSystemPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_CoordinateSystemPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_CoordinateSystemPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_CoordinateSystemPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_CoordinateSystemPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_CoordinateSystemPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_CoordinateSystemPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_CoordinateSystemPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_CoordinateSystemPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __AbstractCoordinateSystem.name() : __AbstractCoordinateSystem
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason,
        __role.name() : __role,
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __remoteSchema.name() : __remoteSchema,
        __href.name() : __href,
        __type.name() : __type
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CoordinateSystemPropertyType', CoordinateSystemPropertyType)


# Complex type MemberName_Type with content type ELEMENT_ONLY
class MemberName_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'MemberName_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gco}aName uses Python identifier aName
    __aName = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'aName'), 'aName', '__httpwww_isotc211_org2005gco_MemberName_Type_httpwww_isotc211_org2005gcoaName', False)

    
    aName = property(__aName.value, __aName.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gco}attributeType uses Python identifier attributeType
    __attributeType = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'attributeType'), 'attributeType', '__httpwww_isotc211_org2005gco_MemberName_Type_httpwww_isotc211_org2005gcoattributeType', False)

    
    attributeType = property(__attributeType.value, __attributeType.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __aName.name() : __aName,
        __attributeType.name() : __attributeType
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gco.addCategoryObject('typeBinding', u'MemberName_Type', MemberName_Type)


# Complex type LinearRingType with content type ELEMENT_ONLY
class LinearRingType (AbstractRingType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'LinearRingType')
    # Base type is AbstractRingType
    
    # Element {http://www.opengis.net/gml/3.2}pointRep uses Python identifier pointRep
    __pointRep = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pointRep'), 'pointRep', '__httpwww_opengis_netgml3_2_LinearRingType_httpwww_opengis_netgml3_2pointRep', True)

    
    pointRep = property(__pointRep.value, __pointRep.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}pos uses Python identifier pos
    __pos = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pos'), 'pos', '__httpwww_opengis_netgml3_2_LinearRingType_httpwww_opengis_netgml3_2pos', True)

    
    pos = property(__pos.value, __pos.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}posList uses Python identifier posList
    __posList = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'posList'), 'posList', '__httpwww_opengis_netgml3_2_LinearRingType_httpwww_opengis_netgml3_2posList', False)

    
    posList = property(__posList.value, __posList.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}pointProperty uses Python identifier pointProperty
    __pointProperty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pointProperty'), 'pointProperty', '__httpwww_opengis_netgml3_2_LinearRingType_httpwww_opengis_netgml3_2pointProperty', True)

    
    pointProperty = property(__pointProperty.value, __pointProperty.set, None, u'This property element either references a point via the XLink-attributes or contains the point element. pointProperty is the predefined property which may be used by GML Application Schemas whenever a GML feature has a property with a value that is substitutable for Point.')

    
    # Element {http://www.opengis.net/gml/3.2}coordinates uses Python identifier coordinates
    __coordinates = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coordinates'), 'coordinates', '__httpwww_opengis_netgml3_2_LinearRingType_httpwww_opengis_netgml3_2coordinates', False)

    
    coordinates = property(__coordinates.value, __coordinates.set, None, u'')


    _ElementMap = AbstractRingType._ElementMap.copy()
    _ElementMap.update({
        __pointRep.name() : __pointRep,
        __pos.name() : __pos,
        __posList.name() : __posList,
        __pointProperty.name() : __pointProperty,
        __coordinates.name() : __coordinates
    })
    _AttributeMap = AbstractRingType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'LinearRingType', LinearRingType)


# Complex type TopoSurfaceType with content type ELEMENT_ONLY
class TopoSurfaceType (AbstractTopologyType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TopoSurfaceType')
    # Base type is AbstractTopologyType
    
    # Element {http://www.opengis.net/gml/3.2}directedFace uses Python identifier directedFace
    __directedFace = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'directedFace'), 'directedFace', '__httpwww_opengis_netgml3_2_TopoSurfaceType_httpwww_opengis_netgml3_2directedFace', True)

    
    directedFace = property(__directedFace.value, __directedFace.set, None, u'The gml:directedFace property element describes the boundary of topology solids, in the coBoundary of topology edges and is used in the support of surface features via the gml:TopoSurface expression, see below. The orientation attribute of type gml:SignType expresses the sense in which the included face is used i.e. inward or outward with respect to the surface normal in any geometric realisation.')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_TopoSurfaceType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTopologyType._ElementMap.copy()
    _ElementMap.update({
        __directedFace.name() : __directedFace
    })
    _AttributeMap = AbstractTopologyType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TopoSurfaceType', TopoSurfaceType)


# Complex type PT_Locale_PropertyType with content type ELEMENT_ONLY
class PT_Locale_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'PT_Locale_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}PT_Locale uses Python identifier PT_Locale
    __PT_Locale = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'PT_Locale'), 'PT_Locale', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_isotc211_org2005gmdPT_Locale', False)

    
    PT_Locale = property(__PT_Locale.value, __PT_Locale.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __PT_Locale.name() : __PT_Locale
    }
    _AttributeMap = {
        __href.name() : __href,
        __nilReason.name() : __nilReason,
        __type.name() : __type,
        __show.name() : __show,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __title.name() : __title,
        __uuidref.name() : __uuidref,
        __actuate.name() : __actuate
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'PT_Locale_PropertyType', PT_Locale_PropertyType)


# Complex type MultiSolidPropertyType with content type ELEMENT_ONLY
class MultiSolidPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'MultiSolidPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}MultiSolid uses Python identifier MultiSolid
    __MultiSolid = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'MultiSolid'), 'MultiSolid', '__httpwww_opengis_netgml3_2_MultiSolidPropertyType_httpwww_opengis_netgml3_2MultiSolid', False)

    
    MultiSolid = property(__MultiSolid.value, __MultiSolid.set, None, u'A gml:MultiSolid is defined by one or more gml:AbstractSolids.\nThe members of the geometric aggregate may be specified either using the "standard" property (gml:solidMember) or the array property (gml:solidMembers). It is also valid to use both the "standard" and the array properties in the same collection.')

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_MultiSolidPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_MultiSolidPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_MultiSolidPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_MultiSolidPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_MultiSolidPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_MultiSolidPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_MultiSolidPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_MultiSolidPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_MultiSolidPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_MultiSolidPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __MultiSolid.name() : __MultiSolid
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason,
        __remoteSchema.name() : __remoteSchema,
        __role.name() : __role,
        __href.name() : __href,
        __owns.name() : __owns,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __type.name() : __type,
        __title.name() : __title,
        __arcrole.name() : __arcrole
    }
_Namespace_gml.addCategoryObject('typeBinding', u'MultiSolidPropertyType', MultiSolidPropertyType)


# Complex type MD_GeometricObjects_Type with content type ELEMENT_ONLY
class MD_GeometricObjects_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_GeometricObjects_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}geometricObjectType uses Python identifier geometricObjectType
    __geometricObjectType = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'geometricObjectType'), 'geometricObjectType', '__httpwww_isotc211_org2005gmd_MD_GeometricObjects_Type_httpwww_isotc211_org2005gmdgeometricObjectType', False)

    
    geometricObjectType = property(__geometricObjectType.value, __geometricObjectType.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}geometricObjectCount uses Python identifier geometricObjectCount
    __geometricObjectCount = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'geometricObjectCount'), 'geometricObjectCount', '__httpwww_isotc211_org2005gmd_MD_GeometricObjects_Type_httpwww_isotc211_org2005gmdgeometricObjectCount', False)

    
    geometricObjectCount = property(__geometricObjectCount.value, __geometricObjectCount.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __geometricObjectType.name() : __geometricObjectType,
        __geometricObjectCount.name() : __geometricObjectCount
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_GeometricObjects_Type', MD_GeometricObjects_Type)


# Complex type PrimeMeridianPropertyType with content type ELEMENT_ONLY
class PrimeMeridianPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'PrimeMeridianPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}PrimeMeridian uses Python identifier PrimeMeridian
    __PrimeMeridian = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'PrimeMeridian'), 'PrimeMeridian', '__httpwww_opengis_netgml3_2_PrimeMeridianPropertyType_httpwww_opengis_netgml3_2PrimeMeridian', False)

    
    PrimeMeridian = property(__PrimeMeridian.value, __PrimeMeridian.set, None, u'A gml:PrimeMeridian defines the origin from which longitude values are determined. The default value for the prime meridian gml:identifier value is "Greenwich".')

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_PrimeMeridianPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_PrimeMeridianPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_PrimeMeridianPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_PrimeMeridianPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_PrimeMeridianPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_PrimeMeridianPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_PrimeMeridianPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_PrimeMeridianPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_PrimeMeridianPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __PrimeMeridian.name() : __PrimeMeridian
    }
    _AttributeMap = {
        __arcrole.name() : __arcrole,
        __show.name() : __show,
        __nilReason.name() : __nilReason,
        __role.name() : __role,
        __actuate.name() : __actuate,
        __remoteSchema.name() : __remoteSchema,
        __title.name() : __title,
        __href.name() : __href,
        __type.name() : __type
    }
_Namespace_gml.addCategoryObject('typeBinding', u'PrimeMeridianPropertyType', PrimeMeridianPropertyType)


# Complex type BSplineType with content type ELEMENT_ONLY
class BSplineType (AbstractCurveSegmentType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'BSplineType')
    # Base type is AbstractCurveSegmentType
    
    # Element {http://www.opengis.net/gml/3.2}coordinates uses Python identifier coordinates
    __coordinates = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coordinates'), 'coordinates', '__httpwww_opengis_netgml3_2_BSplineType_httpwww_opengis_netgml3_2coordinates', False)

    
    coordinates = property(__coordinates.value, __coordinates.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}pointProperty uses Python identifier pointProperty
    __pointProperty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pointProperty'), 'pointProperty', '__httpwww_opengis_netgml3_2_BSplineType_httpwww_opengis_netgml3_2pointProperty', True)

    
    pointProperty = property(__pointProperty.value, __pointProperty.set, None, u'This property element either references a point via the XLink-attributes or contains the point element. pointProperty is the predefined property which may be used by GML Application Schemas whenever a GML feature has a property with a value that is substitutable for Point.')

    
    # Element {http://www.opengis.net/gml/3.2}knot uses Python identifier knot
    __knot = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'knot'), 'knot', '__httpwww_opengis_netgml3_2_BSplineType_httpwww_opengis_netgml3_2knot', True)

    
    knot = property(__knot.value, __knot.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}pos uses Python identifier pos
    __pos = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pos'), 'pos', '__httpwww_opengis_netgml3_2_BSplineType_httpwww_opengis_netgml3_2pos', True)

    
    pos = property(__pos.value, __pos.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}degree uses Python identifier degree
    __degree = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'degree'), 'degree', '__httpwww_opengis_netgml3_2_BSplineType_httpwww_opengis_netgml3_2degree', False)

    
    degree = property(__degree.value, __degree.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}pointRep uses Python identifier pointRep
    __pointRep = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pointRep'), 'pointRep', '__httpwww_opengis_netgml3_2_BSplineType_httpwww_opengis_netgml3_2pointRep', True)

    
    pointRep = property(__pointRep.value, __pointRep.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}posList uses Python identifier posList
    __posList = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'posList'), 'posList', '__httpwww_opengis_netgml3_2_BSplineType_httpwww_opengis_netgml3_2posList', False)

    
    posList = property(__posList.value, __posList.set, None, None)

    
    # Attribute interpolation uses Python identifier interpolation
    __interpolation = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'interpolation'), 'interpolation', '__httpwww_opengis_netgml3_2_BSplineType_interpolation', CurveInterpolationType, unicode_default=u'polynomialSpline')
    
    interpolation = property(__interpolation.value, __interpolation.set, None, None)

    
    # Attribute isPolynomial uses Python identifier isPolynomial
    __isPolynomial = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'isPolynomial'), 'isPolynomial', '__httpwww_opengis_netgml3_2_BSplineType_isPolynomial', pyxb.binding.datatypes.boolean)
    
    isPolynomial = property(__isPolynomial.value, __isPolynomial.set, None, None)

    
    # Attribute numDerivativesAtEnd inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType
    
    # Attribute knotType uses Python identifier knotType
    __knotType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'knotType'), 'knotType', '__httpwww_opengis_netgml3_2_BSplineType_knotType', KnotTypesType)
    
    knotType = property(__knotType.value, __knotType.set, None, None)

    
    # Attribute numDerivativesAtStart inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType
    
    # Attribute numDerivativeInterior inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType

    _ElementMap = AbstractCurveSegmentType._ElementMap.copy()
    _ElementMap.update({
        __coordinates.name() : __coordinates,
        __pointProperty.name() : __pointProperty,
        __knot.name() : __knot,
        __pos.name() : __pos,
        __degree.name() : __degree,
        __pointRep.name() : __pointRep,
        __posList.name() : __posList
    })
    _AttributeMap = AbstractCurveSegmentType._AttributeMap.copy()
    _AttributeMap.update({
        __interpolation.name() : __interpolation,
        __isPolynomial.name() : __isPolynomial,
        __knotType.name() : __knotType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'BSplineType', BSplineType)


# Complex type MD_Identifier_PropertyType with content type ELEMENT_ONLY
class MD_Identifier_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Identifier_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_Identifier uses Python identifier MD_Identifier
    __MD_Identifier = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Identifier'), 'MD_Identifier', '__httpwww_isotc211_org2005gmd_MD_Identifier_PropertyType_httpwww_isotc211_org2005gmdMD_Identifier', False)

    
    MD_Identifier = property(__MD_Identifier.value, __MD_Identifier.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_Identifier_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_Identifier_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_Identifier_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_Identifier_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_Identifier_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_Identifier_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_Identifier_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_Identifier_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_Identifier_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)


    _ElementMap = {
        __MD_Identifier.name() : __MD_Identifier
    }
    _AttributeMap = {
        __uuidref.name() : __uuidref,
        __arcrole.name() : __arcrole,
        __title.name() : __title,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __show.name() : __show,
        __type.name() : __type,
        __role.name() : __role
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Identifier_PropertyType', MD_Identifier_PropertyType)


# Complex type PT_Locale_Type with content type ELEMENT_ONLY
class PT_Locale_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'PT_Locale_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}characterEncoding uses Python identifier characterEncoding
    __characterEncoding = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'characterEncoding'), 'characterEncoding', '__httpwww_isotc211_org2005gmd_PT_Locale_Type_httpwww_isotc211_org2005gmdcharacterEncoding', False)

    
    characterEncoding = property(__characterEncoding.value, __characterEncoding.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}languageCode uses Python identifier languageCode
    __languageCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'languageCode'), 'languageCode', '__httpwww_isotc211_org2005gmd_PT_Locale_Type_httpwww_isotc211_org2005gmdlanguageCode', False)

    
    languageCode = property(__languageCode.value, __languageCode.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}country uses Python identifier country
    __country = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'country'), 'country', '__httpwww_isotc211_org2005gmd_PT_Locale_Type_httpwww_isotc211_org2005gmdcountry', False)

    
    country = property(__country.value, __country.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __characterEncoding.name() : __characterEncoding,
        __languageCode.name() : __languageCode,
        __country.name() : __country
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'PT_Locale_Type', PT_Locale_Type)


# Complex type DateTime_PropertyType with content type ELEMENT_ONLY
class DateTime_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'DateTime_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}DateTime uses Python identifier DateTime
    __DateTime = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'DateTime'), 'DateTime', '__httpwww_isotc211_org2005gco_DateTime_PropertyType_httpwww_isotc211_org2005gcoDateTime', False)

    
    DateTime = property(__DateTime.value, __DateTime.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_DateTime_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __DateTime.name() : __DateTime
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'DateTime_PropertyType', DateTime_PropertyType)


# Complex type ArrayAssociationType with content type ELEMENT_ONLY
class ArrayAssociationType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ArrayAssociationType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractObject uses Python identifier AbstractObject
    __AbstractObject = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractObject'), 'AbstractObject', '__httpwww_opengis_netgml3_2_ArrayAssociationType_httpwww_opengis_netgml3_2AbstractObject', True)

    
    AbstractObject = property(__AbstractObject.value, __AbstractObject.set, None, u'This element has no type defined, and is therefore implicitly (according to the rules of W3C XML Schema) an XML Schema anyType. It is used as the head of an XML Schema substitution group which unifies complex content and certain simple content elements used for datatypes in GML, including the gml:AbstractGML substitution group.')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_ArrayAssociationType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)


    _ElementMap = {
        __AbstractObject.name() : __AbstractObject
    }
    _AttributeMap = {
        __owns.name() : __owns
    }
_Namespace_gml.addCategoryObject('typeBinding', u'ArrayAssociationType', ArrayAssociationType)


# Complex type MD_ExtendedElementInformation_Type with content type ELEMENT_ONLY
class MD_ExtendedElementInformation_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ExtendedElementInformation_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}rationale uses Python identifier rationale
    __rationale = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'rationale'), 'rationale', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmdrationale', True)

    
    rationale = property(__rationale.value, __rationale.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}obligation uses Python identifier obligation
    __obligation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'obligation'), 'obligation', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmdobligation', False)

    
    obligation = property(__obligation.value, __obligation.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}source uses Python identifier source
    __source = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'source'), 'source', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmdsource', True)

    
    source = property(__source.value, __source.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}domainCode uses Python identifier domainCode
    __domainCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'domainCode'), 'domainCode', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmddomainCode', False)

    
    domainCode = property(__domainCode.value, __domainCode.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}definition uses Python identifier definition
    __definition = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'definition'), 'definition', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmddefinition', False)

    
    definition = property(__definition.value, __definition.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}condition uses Python identifier condition
    __condition = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'condition'), 'condition', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmdcondition', False)

    
    condition = property(__condition.value, __condition.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}dataType uses Python identifier dataType
    __dataType = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'dataType'), 'dataType', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmddataType', False)

    
    dataType = property(__dataType.value, __dataType.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}maximumOccurrence uses Python identifier maximumOccurrence
    __maximumOccurrence = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'maximumOccurrence'), 'maximumOccurrence', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmdmaximumOccurrence', False)

    
    maximumOccurrence = property(__maximumOccurrence.value, __maximumOccurrence.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}name uses Python identifier name
    __name = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'name'), 'name', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmdname', False)

    
    name = property(__name.value, __name.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}domainValue uses Python identifier domainValue
    __domainValue = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'domainValue'), 'domainValue', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmddomainValue', False)

    
    domainValue = property(__domainValue.value, __domainValue.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}parentEntity uses Python identifier parentEntity
    __parentEntity = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'parentEntity'), 'parentEntity', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmdparentEntity', True)

    
    parentEntity = property(__parentEntity.value, __parentEntity.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}shortName uses Python identifier shortName
    __shortName = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'shortName'), 'shortName', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmdshortName', False)

    
    shortName = property(__shortName.value, __shortName.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}rule uses Python identifier rule
    __rule = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'rule'), 'rule', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmdrule', False)

    
    rule = property(__rule.value, __rule.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __rationale.name() : __rationale,
        __obligation.name() : __obligation,
        __source.name() : __source,
        __domainCode.name() : __domainCode,
        __definition.name() : __definition,
        __condition.name() : __condition,
        __dataType.name() : __dataType,
        __maximumOccurrence.name() : __maximumOccurrence,
        __name.name() : __name,
        __domainValue.name() : __domainValue,
        __parentEntity.name() : __parentEntity,
        __shortName.name() : __shortName,
        __rule.name() : __rule
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_ExtendedElementInformation_Type', MD_ExtendedElementInformation_Type)


# Complex type TimeOrdinalEraPropertyType with content type ELEMENT_ONLY
class TimeOrdinalEraPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeOrdinalEraPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TimeOrdinalEra uses Python identifier TimeOrdinalEra
    __TimeOrdinalEra = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeOrdinalEra'), 'TimeOrdinalEra', '__httpwww_opengis_netgml3_2_TimeOrdinalEraPropertyType_httpwww_opengis_netgml3_2TimeOrdinalEra', False)

    
    TimeOrdinalEra = property(__TimeOrdinalEra.value, __TimeOrdinalEra.set, None, u'Its content model follows the pattern of gml:TimeEdge, inheriting standard properties from gml:DefinitionType, and adding gml:start, gml:end and gml:extent properties, a set of gml:member properties which indicate ordered gml:TimeOrdinalEra elements, and a gml:group property which points to the parent era.\nThe recursive inclusion of gml:TimeOrdinalEra elements allow the construction of an arbitrary depth hierarchical ordinal reference schema, such that an ordinal era at a given level of the hierarchy includes a sequence of shorter, coterminous ordinal eras.')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TimeOrdinalEraPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TimeOrdinalEraPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TimeOrdinalEraPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TimeOrdinalEraPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TimeOrdinalEraPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TimeOrdinalEraPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_TimeOrdinalEraPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TimeOrdinalEraPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TimeOrdinalEraPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TimeOrdinalEraPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)


    _ElementMap = {
        __TimeOrdinalEra.name() : __TimeOrdinalEra
    }
    _AttributeMap = {
        __show.name() : __show,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __remoteSchema.name() : __remoteSchema,
        __role.name() : __role,
        __href.name() : __href,
        __owns.name() : __owns,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __title.name() : __title
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TimeOrdinalEraPropertyType', TimeOrdinalEraPropertyType)


# Complex type TimeCalendarPropertyType with content type ELEMENT_ONLY
class TimeCalendarPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeCalendarPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TimeCalendar uses Python identifier TimeCalendar
    __TimeCalendar = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeCalendar'), 'TimeCalendar', '__httpwww_opengis_netgml3_2_TimeCalendarPropertyType_httpwww_opengis_netgml3_2TimeCalendar', False)

    
    TimeCalendar = property(__TimeCalendar.value, __TimeCalendar.set, None, u'A calendar is a discrete temporal reference system that provides a basis for defining temporal position to a resolution of one day.\ngml:TimeCalendar adds one property to those inherited from gml:TimeReferenceSystem. A gml:referenceFrame provides a link to a gml:TimeCalendarEra that it uses. A  gml:TimeCalendar may reference more than one calendar era. \nThe referenceFrame element follows the standard GML property model, allowing the association to be instantiated either using an inline description using the gml:TimeCalendarEra element, or a link to a gml:TimeCalendarEra which is explicit elsewhere.')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TimeCalendarPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TimeCalendarPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TimeCalendarPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TimeCalendarPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TimeCalendarPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TimeCalendarPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TimeCalendarPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_TimeCalendarPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TimeCalendarPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TimeCalendarPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __TimeCalendar.name() : __TimeCalendar
    }
    _AttributeMap = {
        __title.name() : __title,
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __remoteSchema.name() : __remoteSchema,
        __role.name() : __role,
        __show.name() : __show,
        __actuate.name() : __actuate,
        __owns.name() : __owns,
        __type.name() : __type,
        __arcrole.name() : __arcrole
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TimeCalendarPropertyType', TimeCalendarPropertyType)


# Complex type CTD_ANON_3 with content type ELEMENT_ONLY
class CTD_ANON_3 (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = None
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}SecondDefiningParameter uses Python identifier SecondDefiningParameter
    __SecondDefiningParameter = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'SecondDefiningParameter'), 'SecondDefiningParameter', '__httpwww_opengis_netgml3_2_CTD_ANON_3_httpwww_opengis_netgml3_2SecondDefiningParameter', False)

    
    SecondDefiningParameter = property(__SecondDefiningParameter.value, __SecondDefiningParameter.set, None, None)


    _ElementMap = {
        __SecondDefiningParameter.name() : __SecondDefiningParameter
    }
    _AttributeMap = {
        
    }



# Complex type MD_PixelOrientationCode_PropertyType with content type ELEMENT_ONLY
class MD_PixelOrientationCode_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_PixelOrientationCode_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_PixelOrientationCode uses Python identifier MD_PixelOrientationCode
    __MD_PixelOrientationCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_PixelOrientationCode'), 'MD_PixelOrientationCode', '__httpwww_isotc211_org2005gmd_MD_PixelOrientationCode_PropertyType_httpwww_isotc211_org2005gmdMD_PixelOrientationCode', False)

    
    MD_PixelOrientationCode = property(__MD_PixelOrientationCode.value, __MD_PixelOrientationCode.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_PixelOrientationCode_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __MD_PixelOrientationCode.name() : __MD_PixelOrientationCode
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_PixelOrientationCode_PropertyType', MD_PixelOrientationCode_PropertyType)


# Complex type DQ_AbsoluteExternalPositionalAccuracy_PropertyType with content type ELEMENT_ONLY
class DQ_AbsoluteExternalPositionalAccuracy_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_AbsoluteExternalPositionalAccuracy_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}DQ_AbsoluteExternalPositionalAccuracy uses Python identifier DQ_AbsoluteExternalPositionalAccuracy
    __DQ_AbsoluteExternalPositionalAccuracy = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_AbsoluteExternalPositionalAccuracy'), 'DQ_AbsoluteExternalPositionalAccuracy', '__httpwww_isotc211_org2005gmd_DQ_AbsoluteExternalPositionalAccuracy_PropertyType_httpwww_isotc211_org2005gmdDQ_AbsoluteExternalPositionalAccuracy', False)

    
    DQ_AbsoluteExternalPositionalAccuracy = property(__DQ_AbsoluteExternalPositionalAccuracy.value, __DQ_AbsoluteExternalPositionalAccuracy.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_DQ_AbsoluteExternalPositionalAccuracy_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_DQ_AbsoluteExternalPositionalAccuracy_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_DQ_AbsoluteExternalPositionalAccuracy_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_DQ_AbsoluteExternalPositionalAccuracy_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DQ_AbsoluteExternalPositionalAccuracy_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_DQ_AbsoluteExternalPositionalAccuracy_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_DQ_AbsoluteExternalPositionalAccuracy_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_DQ_AbsoluteExternalPositionalAccuracy_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_DQ_AbsoluteExternalPositionalAccuracy_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __DQ_AbsoluteExternalPositionalAccuracy.name() : __DQ_AbsoluteExternalPositionalAccuracy
    }
    _AttributeMap = {
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __show.name() : __show,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __uuidref.name() : __uuidref,
        __title.name() : __title,
        __actuate.name() : __actuate,
        __href.name() : __href
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_AbsoluteExternalPositionalAccuracy_PropertyType', DQ_AbsoluteExternalPositionalAccuracy_PropertyType)


# Complex type UomArea_PropertyType with content type ELEMENT_ONLY
class UomArea_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'UomArea_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}UnitDefinition uses Python identifier UnitDefinition
    __UnitDefinition = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'UnitDefinition'), 'UnitDefinition', '__httpwww_isotc211_org2005gco_UomArea_PropertyType_httpwww_opengis_netgml3_2UnitDefinition', False)

    
    UnitDefinition = property(__UnitDefinition.value, __UnitDefinition.set, None, u'A gml:UnitDefinition is a general definition of a unit of measure. This generic element is used only for units for which no relationship with other units or units systems is known.\nThe content model of gml:UnitDefinition adds three additional properties to gml:Definition, gml:quantityType, gml:quantityTypeReference and gml:catalogSymbol.  \nThe gml:catalogSymbol property optionally gives the short symbol used for this unit. This element is usually used when the relationship of this unit to other units or units systems is unknown.')

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gco_UomArea_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gco_UomArea_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gco_UomArea_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gco_UomArea_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_UomArea_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gco_UomArea_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gco_UomArea_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gco_UomArea_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gco_UomArea_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __UnitDefinition.name() : __UnitDefinition
    }
    _AttributeMap = {
        __uuidref.name() : __uuidref,
        __role.name() : __role,
        __title.name() : __title,
        __href.name() : __href,
        __nilReason.name() : __nilReason,
        __show.name() : __show,
        __actuate.name() : __actuate,
        __type.name() : __type,
        __arcrole.name() : __arcrole
    }
_Namespace_gco.addCategoryObject('typeBinding', u'UomArea_PropertyType', UomArea_PropertyType)


# Complex type GeneralConversionPropertyType with content type ELEMENT_ONLY
class GeneralConversionPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'GeneralConversionPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractGeneralConversion uses Python identifier AbstractGeneralConversion
    __AbstractGeneralConversion = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeneralConversion'), 'AbstractGeneralConversion', '__httpwww_opengis_netgml3_2_GeneralConversionPropertyType_httpwww_opengis_netgml3_2AbstractGeneralConversion', False)

    
    AbstractGeneralConversion = property(__AbstractGeneralConversion.value, __AbstractGeneralConversion.set, None, u'gm:AbstractGeneralConversion is an abstract operation on coordinates that does not include any change of datum. The best-known example of a coordinate conversion is a map projection. The parameters describing coordinate conversions are defined rather than empirically derived. Note that some conversions have no parameters. The operationVersion, sourceCRS, and targetCRS elements are omitted in a coordinate conversion.\nThis abstract complex type is expected to be extended for well-known operation methods with many Conversion instances, in GML Application Schemas that define operation-method-specialized element names and contents. This conversion uses an operation method, usually with associated parameter values. However, operation methods and parameter values are directly associated with concrete subtypes, not with this abstract type. All concrete types derived from this type shall extend this type to include a "usesMethod" element that references the "OperationMethod" element. Similarly, all concrete types derived from this type shall extend this type to include zero or more elements each named "uses...Value" that each use the type of an element substitutable for the "AbstractGeneralParameterValue" element.')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_GeneralConversionPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_GeneralConversionPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_GeneralConversionPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_GeneralConversionPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_GeneralConversionPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_GeneralConversionPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_GeneralConversionPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_GeneralConversionPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_GeneralConversionPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __AbstractGeneralConversion.name() : __AbstractGeneralConversion
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __title.name() : __title,
        __actuate.name() : __actuate,
        __role.name() : __role,
        __show.name() : __show,
        __href.name() : __href,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason
    }
_Namespace_gml.addCategoryObject('typeBinding', u'GeneralConversionPropertyType', GeneralConversionPropertyType)


# Complex type DQ_ThematicClassificationCorrectness_PropertyType with content type ELEMENT_ONLY
class DQ_ThematicClassificationCorrectness_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_ThematicClassificationCorrectness_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}DQ_ThematicClassificationCorrectness uses Python identifier DQ_ThematicClassificationCorrectness
    __DQ_ThematicClassificationCorrectness = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_ThematicClassificationCorrectness'), 'DQ_ThematicClassificationCorrectness', '__httpwww_isotc211_org2005gmd_DQ_ThematicClassificationCorrectness_PropertyType_httpwww_isotc211_org2005gmdDQ_ThematicClassificationCorrectness', False)

    
    DQ_ThematicClassificationCorrectness = property(__DQ_ThematicClassificationCorrectness.value, __DQ_ThematicClassificationCorrectness.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_DQ_ThematicClassificationCorrectness_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DQ_ThematicClassificationCorrectness_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_DQ_ThematicClassificationCorrectness_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_DQ_ThematicClassificationCorrectness_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_DQ_ThematicClassificationCorrectness_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_DQ_ThematicClassificationCorrectness_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_DQ_ThematicClassificationCorrectness_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_DQ_ThematicClassificationCorrectness_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_DQ_ThematicClassificationCorrectness_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)


    _ElementMap = {
        __DQ_ThematicClassificationCorrectness.name() : __DQ_ThematicClassificationCorrectness
    }
    _AttributeMap = {
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __uuidref.name() : __uuidref,
        __show.name() : __show,
        __title.name() : __title,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __type.name() : __type,
        __role.name() : __role
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_ThematicClassificationCorrectness_PropertyType', DQ_ThematicClassificationCorrectness_PropertyType)


# Complex type GeometryArrayPropertyType with content type ELEMENT_ONLY
class GeometryArrayPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'GeometryArrayPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractGeometry uses Python identifier AbstractGeometry
    __AbstractGeometry = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeometry'), 'AbstractGeometry', '__httpwww_opengis_netgml3_2_GeometryArrayPropertyType_httpwww_opengis_netgml3_2AbstractGeometry', True)

    
    AbstractGeometry = property(__AbstractGeometry.value, __AbstractGeometry.set, None, u'The AbstractGeometry element is the abstract head of the substitution group for all geometry elements of GML. This includes pre-defined and user-defined geometry elements. Any geometry element shall be a direct or indirect extension/restriction of AbstractGeometryType and shall be directly or indirectly in the substitution group of AbstractGeometry.')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_GeometryArrayPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)


    _ElementMap = {
        __AbstractGeometry.name() : __AbstractGeometry
    }
    _AttributeMap = {
        __owns.name() : __owns
    }
_Namespace_gml.addCategoryObject('typeBinding', u'GeometryArrayPropertyType', GeometryArrayPropertyType)


# Complex type TimePositionType with content type SIMPLE
class TimePositionType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = TimePositionUnion
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimePositionType')
    # Base type is TimePositionUnion
    
    # Attribute indeterminatePosition uses Python identifier indeterminatePosition
    __indeterminatePosition = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'indeterminatePosition'), 'indeterminatePosition', '__httpwww_opengis_netgml3_2_TimePositionType_indeterminatePosition', TimeIndeterminateValueType)
    
    indeterminatePosition = property(__indeterminatePosition.value, __indeterminatePosition.set, None, None)

    
    # Attribute frame uses Python identifier frame
    __frame = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'frame'), 'frame', '__httpwww_opengis_netgml3_2_TimePositionType_frame', pyxb.binding.datatypes.anyURI, unicode_default=u'#ISO-8601')
    
    frame = property(__frame.value, __frame.set, None, None)

    
    # Attribute calendarEraName uses Python identifier calendarEraName
    __calendarEraName = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'calendarEraName'), 'calendarEraName', '__httpwww_opengis_netgml3_2_TimePositionType_calendarEraName', pyxb.binding.datatypes.string)
    
    calendarEraName = property(__calendarEraName.value, __calendarEraName.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __indeterminatePosition.name() : __indeterminatePosition,
        __frame.name() : __frame,
        __calendarEraName.name() : __calendarEraName
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TimePositionType', TimePositionType)


# Complex type RS_Identifier_PropertyType with content type ELEMENT_ONLY
class RS_Identifier_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'RS_Identifier_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}RS_Identifier uses Python identifier RS_Identifier
    __RS_Identifier = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'RS_Identifier'), 'RS_Identifier', '__httpwww_isotc211_org2005gmd_RS_Identifier_PropertyType_httpwww_isotc211_org2005gmdRS_Identifier', False)

    
    RS_Identifier = property(__RS_Identifier.value, __RS_Identifier.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_RS_Identifier_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_RS_Identifier_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_RS_Identifier_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_RS_Identifier_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_RS_Identifier_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_RS_Identifier_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_RS_Identifier_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_RS_Identifier_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_RS_Identifier_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __RS_Identifier.name() : __RS_Identifier
    }
    _AttributeMap = {
        __role.name() : __role,
        __uuidref.name() : __uuidref,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __title.name() : __title,
        __show.name() : __show,
        __href.name() : __href,
        __type.name() : __type,
        __arcrole.name() : __arcrole
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'RS_Identifier_PropertyType', RS_Identifier_PropertyType)


# Complex type GeodeticCRSType with content type ELEMENT_ONLY
class GeodeticCRSType (AbstractCRSType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'GeodeticCRSType')
    # Base type is AbstractCRSType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element {http://www.opengis.net/gml/3.2}ellipsoidalCS uses Python identifier ellipsoidalCS
    __ellipsoidalCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'ellipsoidalCS'), 'ellipsoidalCS', '__httpwww_opengis_netgml3_2_GeodeticCRSType_httpwww_opengis_netgml3_2ellipsoidalCS', False)

    
    ellipsoidalCS = property(__ellipsoidalCS.value, __ellipsoidalCS.set, None, u'gml:ellipsoidalCS is an association role to the ellipsoidal coordinate system used by this CRS.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}cartesianCS uses Python identifier cartesianCS
    __cartesianCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'cartesianCS'), 'cartesianCS', '__httpwww_opengis_netgml3_2_GeodeticCRSType_httpwww_opengis_netgml3_2cartesianCS', False)

    
    cartesianCS = property(__cartesianCS.value, __cartesianCS.set, None, u'gml:cartesianCS is an association role to the Cartesian coordinate system used by this CRS.')

    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}sphericalCS uses Python identifier sphericalCS
    __sphericalCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'sphericalCS'), 'sphericalCS', '__httpwww_opengis_netgml3_2_GeodeticCRSType_httpwww_opengis_netgml3_2sphericalCS', False)

    
    sphericalCS = property(__sphericalCS.value, __sphericalCS.set, None, u'gml:sphericalCS is an association role to the spherical coordinate system used by this CRS.')

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}geodeticDatum uses Python identifier geodeticDatum
    __geodeticDatum = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'geodeticDatum'), 'geodeticDatum', '__httpwww_opengis_netgml3_2_GeodeticCRSType_httpwww_opengis_netgml3_2geodeticDatum', False)

    
    geodeticDatum = property(__geodeticDatum.value, __geodeticDatum.set, None, u'gml:geodeticDatum is an association role to the geodetic datum used by this CRS.\n')

    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCRSType._ElementMap.copy()
    _ElementMap.update({
        __ellipsoidalCS.name() : __ellipsoidalCS,
        __cartesianCS.name() : __cartesianCS,
        __sphericalCS.name() : __sphericalCS,
        __geodeticDatum.name() : __geodeticDatum
    })
    _AttributeMap = AbstractCRSType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'GeodeticCRSType', GeodeticCRSType)


# Complex type VectorType with content type SIMPLE
class VectorType (DirectPositionType):
    _TypeDefinition = STD_ANON_4
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'VectorType')
    # Base type is DirectPositionType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}DirectPositionType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}DirectPositionType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}DirectPositionType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}DirectPositionType

    _ElementMap = DirectPositionType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = DirectPositionType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'VectorType', VectorType)


# Complex type MD_ScopeCode_PropertyType with content type ELEMENT_ONLY
class MD_ScopeCode_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ScopeCode_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_ScopeCode uses Python identifier MD_ScopeCode
    __MD_ScopeCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ScopeCode'), 'MD_ScopeCode', '__httpwww_isotc211_org2005gmd_MD_ScopeCode_PropertyType_httpwww_isotc211_org2005gmdMD_ScopeCode', False)

    
    MD_ScopeCode = property(__MD_ScopeCode.value, __MD_ScopeCode.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_ScopeCode_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __MD_ScopeCode.name() : __MD_ScopeCode
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_ScopeCode_PropertyType', MD_ScopeCode_PropertyType)


# Complex type EnvelopeType with content type ELEMENT_ONLY
class EnvelopeType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'EnvelopeType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}lowerCorner uses Python identifier lowerCorner
    __lowerCorner = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'lowerCorner'), 'lowerCorner', '__httpwww_opengis_netgml3_2_EnvelopeType_httpwww_opengis_netgml3_2lowerCorner', False)

    
    lowerCorner = property(__lowerCorner.value, __lowerCorner.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}upperCorner uses Python identifier upperCorner
    __upperCorner = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'upperCorner'), 'upperCorner', '__httpwww_opengis_netgml3_2_EnvelopeType_httpwww_opengis_netgml3_2upperCorner', False)

    
    upperCorner = property(__upperCorner.value, __upperCorner.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}pos uses Python identifier pos
    __pos = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pos'), 'pos', '__httpwww_opengis_netgml3_2_EnvelopeType_httpwww_opengis_netgml3_2pos', True)

    
    pos = property(__pos.value, __pos.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}coordinates uses Python identifier coordinates
    __coordinates = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coordinates'), 'coordinates', '__httpwww_opengis_netgml3_2_EnvelopeType_httpwww_opengis_netgml3_2coordinates', False)

    
    coordinates = property(__coordinates.value, __coordinates.set, None, u'')

    
    # Attribute axisLabels uses Python identifier axisLabels
    __axisLabels = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'axisLabels'), 'axisLabels', '__httpwww_opengis_netgml3_2_EnvelopeType_axisLabels', NCNameList)
    
    axisLabels = property(__axisLabels.value, __axisLabels.set, None, None)

    
    # Attribute uomLabels uses Python identifier uomLabels
    __uomLabels = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uomLabels'), 'uomLabels', '__httpwww_opengis_netgml3_2_EnvelopeType_uomLabels', NCNameList)
    
    uomLabels = property(__uomLabels.value, __uomLabels.set, None, None)

    
    # Attribute srsName uses Python identifier srsName
    __srsName = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'srsName'), 'srsName', '__httpwww_opengis_netgml3_2_EnvelopeType_srsName', pyxb.binding.datatypes.anyURI)
    
    srsName = property(__srsName.value, __srsName.set, None, None)

    
    # Attribute srsDimension uses Python identifier srsDimension
    __srsDimension = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'srsDimension'), 'srsDimension', '__httpwww_opengis_netgml3_2_EnvelopeType_srsDimension', pyxb.binding.datatypes.positiveInteger)
    
    srsDimension = property(__srsDimension.value, __srsDimension.set, None, None)


    _ElementMap = {
        __lowerCorner.name() : __lowerCorner,
        __upperCorner.name() : __upperCorner,
        __pos.name() : __pos,
        __coordinates.name() : __coordinates
    }
    _AttributeMap = {
        __axisLabels.name() : __axisLabels,
        __uomLabels.name() : __uomLabels,
        __srsName.name() : __srsName,
        __srsDimension.name() : __srsDimension
    }
_Namespace_gml.addCategoryObject('typeBinding', u'EnvelopeType', EnvelopeType)


# Complex type EnvelopeWithTimePeriodType with content type ELEMENT_ONLY
class EnvelopeWithTimePeriodType (EnvelopeType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'EnvelopeWithTimePeriodType')
    # Base type is EnvelopeType
    
    # Element pos ({http://www.opengis.net/gml/3.2}pos) inherited from {http://www.opengis.net/gml/3.2}EnvelopeType
    
    # Element lowerCorner ({http://www.opengis.net/gml/3.2}lowerCorner) inherited from {http://www.opengis.net/gml/3.2}EnvelopeType
    
    # Element upperCorner ({http://www.opengis.net/gml/3.2}upperCorner) inherited from {http://www.opengis.net/gml/3.2}EnvelopeType
    
    # Element {http://www.opengis.net/gml/3.2}beginPosition uses Python identifier beginPosition
    __beginPosition = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'beginPosition'), 'beginPosition', '__httpwww_opengis_netgml3_2_EnvelopeWithTimePeriodType_httpwww_opengis_netgml3_2beginPosition', False)

    
    beginPosition = property(__beginPosition.value, __beginPosition.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}endPosition uses Python identifier endPosition
    __endPosition = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'endPosition'), 'endPosition', '__httpwww_opengis_netgml3_2_EnvelopeWithTimePeriodType_httpwww_opengis_netgml3_2endPosition', False)

    
    endPosition = property(__endPosition.value, __endPosition.set, None, None)

    
    # Element coordinates ({http://www.opengis.net/gml/3.2}coordinates) inherited from {http://www.opengis.net/gml/3.2}EnvelopeType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}EnvelopeType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}EnvelopeType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}EnvelopeType
    
    # Attribute frame uses Python identifier frame
    __frame = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'frame'), 'frame', '__httpwww_opengis_netgml3_2_EnvelopeWithTimePeriodType_frame', pyxb.binding.datatypes.anyURI, unicode_default=u'#ISO-8601')
    
    frame = property(__frame.value, __frame.set, None, None)

    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}EnvelopeType

    _ElementMap = EnvelopeType._ElementMap.copy()
    _ElementMap.update({
        __beginPosition.name() : __beginPosition,
        __endPosition.name() : __endPosition
    })
    _AttributeMap = EnvelopeType._AttributeMap.copy()
    _AttributeMap.update({
        __frame.name() : __frame
    })
_Namespace_gml.addCategoryObject('typeBinding', u'EnvelopeWithTimePeriodType', EnvelopeWithTimePeriodType)


# Complex type AbstractMD_Identification_Type with content type ELEMENT_ONLY
class AbstractMD_Identification_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractMD_Identification_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}purpose uses Python identifier purpose
    __purpose = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'purpose'), 'purpose', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmdpurpose', False)

    
    purpose = property(__purpose.value, __purpose.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}resourceConstraints uses Python identifier resourceConstraints
    __resourceConstraints = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'resourceConstraints'), 'resourceConstraints', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmdresourceConstraints', True)

    
    resourceConstraints = property(__resourceConstraints.value, __resourceConstraints.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}credit uses Python identifier credit
    __credit = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'credit'), 'credit', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmdcredit', True)

    
    credit = property(__credit.value, __credit.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}resourceSpecificUsage uses Python identifier resourceSpecificUsage
    __resourceSpecificUsage = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'resourceSpecificUsage'), 'resourceSpecificUsage', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmdresourceSpecificUsage', True)

    
    resourceSpecificUsage = property(__resourceSpecificUsage.value, __resourceSpecificUsage.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}pointOfContact uses Python identifier pointOfContact
    __pointOfContact = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'pointOfContact'), 'pointOfContact', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmdpointOfContact', True)

    
    pointOfContact = property(__pointOfContact.value, __pointOfContact.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}resourceMaintenance uses Python identifier resourceMaintenance
    __resourceMaintenance = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'resourceMaintenance'), 'resourceMaintenance', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmdresourceMaintenance', True)

    
    resourceMaintenance = property(__resourceMaintenance.value, __resourceMaintenance.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}status uses Python identifier status
    __status = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'status'), 'status', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmdstatus', True)

    
    status = property(__status.value, __status.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}graphicOverview uses Python identifier graphicOverview
    __graphicOverview = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'graphicOverview'), 'graphicOverview', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmdgraphicOverview', True)

    
    graphicOverview = property(__graphicOverview.value, __graphicOverview.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}citation uses Python identifier citation
    __citation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'citation'), 'citation', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmdcitation', False)

    
    citation = property(__citation.value, __citation.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}aggregationInfo uses Python identifier aggregationInfo
    __aggregationInfo = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'aggregationInfo'), 'aggregationInfo', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmdaggregationInfo', True)

    
    aggregationInfo = property(__aggregationInfo.value, __aggregationInfo.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}resourceFormat uses Python identifier resourceFormat
    __resourceFormat = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'resourceFormat'), 'resourceFormat', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmdresourceFormat', True)

    
    resourceFormat = property(__resourceFormat.value, __resourceFormat.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}abstract uses Python identifier abstract
    __abstract = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'abstract'), 'abstract', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmdabstract', False)

    
    abstract = property(__abstract.value, __abstract.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}descriptiveKeywords uses Python identifier descriptiveKeywords
    __descriptiveKeywords = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'descriptiveKeywords'), 'descriptiveKeywords', '__httpwww_isotc211_org2005gmd_AbstractMD_Identification_Type_httpwww_isotc211_org2005gmddescriptiveKeywords', True)

    
    descriptiveKeywords = property(__descriptiveKeywords.value, __descriptiveKeywords.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __purpose.name() : __purpose,
        __resourceConstraints.name() : __resourceConstraints,
        __credit.name() : __credit,
        __resourceSpecificUsage.name() : __resourceSpecificUsage,
        __pointOfContact.name() : __pointOfContact,
        __resourceMaintenance.name() : __resourceMaintenance,
        __status.name() : __status,
        __graphicOverview.name() : __graphicOverview,
        __citation.name() : __citation,
        __aggregationInfo.name() : __aggregationInfo,
        __resourceFormat.name() : __resourceFormat,
        __abstract.name() : __abstract,
        __descriptiveKeywords.name() : __descriptiveKeywords
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractMD_Identification_Type', AbstractMD_Identification_Type)


# Complex type MD_ServiceIdentification_Type with content type ELEMENT_ONLY
class MD_ServiceIdentification_Type (AbstractMD_Identification_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ServiceIdentification_Type')
    # Base type is AbstractMD_Identification_Type
    
    # Element purpose ({http://www.isotc211.org/2005/gmd}purpose) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Element resourceConstraints ({http://www.isotc211.org/2005/gmd}resourceConstraints) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Element credit ({http://www.isotc211.org/2005/gmd}credit) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Element resourceSpecificUsage ({http://www.isotc211.org/2005/gmd}resourceSpecificUsage) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Element pointOfContact ({http://www.isotc211.org/2005/gmd}pointOfContact) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Element resourceMaintenance ({http://www.isotc211.org/2005/gmd}resourceMaintenance) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Element status ({http://www.isotc211.org/2005/gmd}status) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Element graphicOverview ({http://www.isotc211.org/2005/gmd}graphicOverview) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Element citation ({http://www.isotc211.org/2005/gmd}citation) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Element aggregationInfo ({http://www.isotc211.org/2005/gmd}aggregationInfo) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Element resourceFormat ({http://www.isotc211.org/2005/gmd}resourceFormat) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Element abstract ({http://www.isotc211.org/2005/gmd}abstract) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Element descriptiveKeywords ({http://www.isotc211.org/2005/gmd}descriptiveKeywords) inherited from {http://www.isotc211.org/2005/gmd}AbstractMD_Identification_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractMD_Identification_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractMD_Identification_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_ServiceIdentification_Type', MD_ServiceIdentification_Type)


# Complex type UnlimitedInteger_PropertyType with content type ELEMENT_ONLY
class UnlimitedInteger_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'UnlimitedInteger_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}UnlimitedInteger uses Python identifier UnlimitedInteger
    __UnlimitedInteger = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'UnlimitedInteger'), 'UnlimitedInteger', '__httpwww_isotc211_org2005gco_UnlimitedInteger_PropertyType_httpwww_isotc211_org2005gcoUnlimitedInteger', False)

    
    UnlimitedInteger = property(__UnlimitedInteger.value, __UnlimitedInteger.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_UnlimitedInteger_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __UnlimitedInteger.name() : __UnlimitedInteger
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'UnlimitedInteger_PropertyType', UnlimitedInteger_PropertyType)


# Complex type AbstractGeneralParameterValuePropertyType with content type ELEMENT_ONLY
class AbstractGeneralParameterValuePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeneralParameterValuePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractGeneralParameterValue uses Python identifier AbstractGeneralParameterValue
    __AbstractGeneralParameterValue = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeneralParameterValue'), 'AbstractGeneralParameterValue', '__httpwww_opengis_netgml3_2_AbstractGeneralParameterValuePropertyType_httpwww_opengis_netgml3_2AbstractGeneralParameterValue', False)

    
    AbstractGeneralParameterValue = property(__AbstractGeneralParameterValue.value, __AbstractGeneralParameterValue.set, None, u'gml:AbstractGeneralParameterValue is an abstract parameter value or group of parameter values.\nThis abstract complexType is expected to be extended and restricted for well-known operation methods with many instances, in Application Schemas that define operation-method-specialized element names and contents. Specific parameter value elements are directly contained in concrete subtypes, not in this abstract type. All concrete types derived from this type shall extend this type to include one "...Value" element with an appropriate type, which should be one of the element types allowed in the ParameterValueType. In addition, all derived concrete types shall extend this type to include a "operationParameter" property element that references one element substitutable for the "OperationParameter" object element.')


    _ElementMap = {
        __AbstractGeneralParameterValue.name() : __AbstractGeneralParameterValue
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGeneralParameterValuePropertyType', AbstractGeneralParameterValuePropertyType)


# Complex type GeodeticDatumType with content type ELEMENT_ONLY
class GeodeticDatumType (AbstractDatumType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'GeodeticDatumType')
    # Base type is AbstractDatumType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractDatumType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}primeMeridian uses Python identifier primeMeridian
    __primeMeridian = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'primeMeridian'), 'primeMeridian', '__httpwww_opengis_netgml3_2_GeodeticDatumType_httpwww_opengis_netgml3_2primeMeridian', False)

    
    primeMeridian = property(__primeMeridian.value, __primeMeridian.set, None, u'gml:primeMeridian is an association role to the prime meridian used by this geodetic datum.')

    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}ellipsoid uses Python identifier ellipsoid
    __ellipsoid = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'ellipsoid'), 'ellipsoid', '__httpwww_opengis_netgml3_2_GeodeticDatumType_httpwww_opengis_netgml3_2ellipsoid', False)

    
    ellipsoid = property(__ellipsoid.value, __ellipsoid.set, None, u'gml:ellipsoid is an association role to the ellipsoid used by this geodetic datum.')

    
    # Element anchorDefinition ({http://www.opengis.net/gml/3.2}anchorDefinition) inherited from {http://www.opengis.net/gml/3.2}AbstractDatumType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractDatumType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element realizationEpoch ({http://www.opengis.net/gml/3.2}realizationEpoch) inherited from {http://www.opengis.net/gml/3.2}AbstractDatumType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractDatumType._ElementMap.copy()
    _ElementMap.update({
        __primeMeridian.name() : __primeMeridian,
        __ellipsoid.name() : __ellipsoid
    })
    _AttributeMap = AbstractDatumType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'GeodeticDatumType', GeodeticDatumType)


# Complex type DQ_ConceptualConsistency_PropertyType with content type ELEMENT_ONLY
class DQ_ConceptualConsistency_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_ConceptualConsistency_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}DQ_ConceptualConsistency uses Python identifier DQ_ConceptualConsistency
    __DQ_ConceptualConsistency = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_ConceptualConsistency'), 'DQ_ConceptualConsistency', '__httpwww_isotc211_org2005gmd_DQ_ConceptualConsistency_PropertyType_httpwww_isotc211_org2005gmdDQ_ConceptualConsistency', False)

    
    DQ_ConceptualConsistency = property(__DQ_ConceptualConsistency.value, __DQ_ConceptualConsistency.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_DQ_ConceptualConsistency_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DQ_ConceptualConsistency_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_DQ_ConceptualConsistency_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_DQ_ConceptualConsistency_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_DQ_ConceptualConsistency_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_DQ_ConceptualConsistency_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_DQ_ConceptualConsistency_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_DQ_ConceptualConsistency_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_DQ_ConceptualConsistency_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __DQ_ConceptualConsistency.name() : __DQ_ConceptualConsistency
    }
    _AttributeMap = {
        __uuidref.name() : __uuidref,
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __title.name() : __title,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __role.name() : __role,
        __type.name() : __type,
        __arcrole.name() : __arcrole
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_ConceptualConsistency_PropertyType', DQ_ConceptualConsistency_PropertyType)


# Complex type AbstractGeometricAggregateType with content type ELEMENT_ONLY
class AbstractGeometricAggregateType (AbstractGeometryType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeometricAggregateType')
    # Base type is AbstractGeometryType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_AbstractGeometricAggregateType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType

    _ElementMap = AbstractGeometryType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGeometryType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGeometricAggregateType', AbstractGeometricAggregateType)


# Complex type MultiCurveType with content type ELEMENT_ONLY
class MultiCurveType (AbstractGeometricAggregateType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'MultiCurveType')
    # Base type is AbstractGeometricAggregateType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}curveMembers uses Python identifier curveMembers
    __curveMembers = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'curveMembers'), 'curveMembers', '__httpwww_opengis_netgml3_2_MultiCurveType_httpwww_opengis_netgml3_2curveMembers', False)

    
    curveMembers = property(__curveMembers.value, __curveMembers.set, None, u'This property element contains a list of curves. The order of the elements is significant and shall be preserved when processing the array.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}curveMember uses Python identifier curveMember
    __curveMember = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'curveMember'), 'curveMember', '__httpwww_opengis_netgml3_2_MultiCurveType_httpwww_opengis_netgml3_2curveMember', True)

    
    curveMember = property(__curveMember.value, __curveMember.set, None, None)

    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute aggregationType inherited from {http://www.opengis.net/gml/3.2}AbstractGeometricAggregateType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType

    _ElementMap = AbstractGeometricAggregateType._ElementMap.copy()
    _ElementMap.update({
        __curveMembers.name() : __curveMembers,
        __curveMember.name() : __curveMember
    })
    _AttributeMap = AbstractGeometricAggregateType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'MultiCurveType', MultiCurveType)


# Complex type DQ_TopologicalConsistency_PropertyType with content type ELEMENT_ONLY
class DQ_TopologicalConsistency_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_TopologicalConsistency_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}DQ_TopologicalConsistency uses Python identifier DQ_TopologicalConsistency
    __DQ_TopologicalConsistency = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_TopologicalConsistency'), 'DQ_TopologicalConsistency', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_isotc211_org2005gmdDQ_TopologicalConsistency', False)

    
    DQ_TopologicalConsistency = property(__DQ_TopologicalConsistency.value, __DQ_TopologicalConsistency.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __DQ_TopologicalConsistency.name() : __DQ_TopologicalConsistency
    }
    _AttributeMap = {
        __uuidref.name() : __uuidref,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __role.name() : __role,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __href.name() : __href,
        __type.name() : __type,
        __arcrole.name() : __arcrole
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_TopologicalConsistency_PropertyType', DQ_TopologicalConsistency_PropertyType)


# Complex type AbstractGeneralOperationParameterType with content type ELEMENT_ONLY
class AbstractGeneralOperationParameterType (IdentifiedObjectType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeneralOperationParameterType')
    # Base type is IdentifiedObjectType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}minimumOccurs uses Python identifier minimumOccurs
    __minimumOccurs = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'minimumOccurs'), 'minimumOccurs', '__httpwww_opengis_netgml3_2_AbstractGeneralOperationParameterType_httpwww_opengis_netgml3_2minimumOccurs', False)

    
    minimumOccurs = property(__minimumOccurs.value, __minimumOccurs.set, None, u'gml:minimumOccurs is the minimum number of times that values for this parameter group or parameter are required. If this attribute is omitted, the minimum number shall be one.')

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = IdentifiedObjectType._ElementMap.copy()
    _ElementMap.update({
        __minimumOccurs.name() : __minimumOccurs
    })
    _AttributeMap = IdentifiedObjectType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGeneralOperationParameterType', AbstractGeneralOperationParameterType)


# Complex type DegreesType with content type SIMPLE
class DegreesType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = DegreeValueType
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DegreesType')
    # Base type is DegreeValueType
    
    # Attribute direction uses Python identifier direction
    __direction = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'direction'), 'direction', '__httpwww_opengis_netgml3_2_DegreesType_direction', STD_ANON_5)
    
    direction = property(__direction.value, __direction.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __direction.name() : __direction
    }
_Namespace_gml.addCategoryObject('typeBinding', u'DegreesType', DegreesType)


# Complex type ImageDatumPropertyType with content type ELEMENT_ONLY
class ImageDatumPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ImageDatumPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}ImageDatum uses Python identifier ImageDatum
    __ImageDatum = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'ImageDatum'), 'ImageDatum', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_opengis_netgml3_2ImageDatum', False)

    
    ImageDatum = property(__ImageDatum.value, __ImageDatum.set, None, u'gml:ImageDatum defines the origin of an image coordinate reference system, and is used in a local context only. For an image datum, the anchor definition is usually either the centre of the image or the corner of the image. For more information, see ISO 19111 B.3.5.')

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __ImageDatum.name() : __ImageDatum
    }
    _AttributeMap = {
        __actuate.name() : __actuate,
        __role.name() : __role,
        __show.name() : __show,
        __remoteSchema.name() : __remoteSchema,
        __href.name() : __href,
        __title.name() : __title,
        __nilReason.name() : __nilReason,
        __type.name() : __type,
        __arcrole.name() : __arcrole
    }
_Namespace_gml.addCategoryObject('typeBinding', u'ImageDatumPropertyType', ImageDatumPropertyType)


# Complex type AbstractTimeTopologyPrimitiveType with content type ELEMENT_ONLY
class AbstractTimeTopologyPrimitiveType (AbstractTimePrimitiveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTimeTopologyPrimitiveType')
    # Base type is AbstractTimePrimitiveType
    
    # Element relatedTime ({http://www.opengis.net/gml/3.2}relatedTime) inherited from {http://www.opengis.net/gml/3.2}AbstractTimePrimitiveType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}complex uses Python identifier complex
    __complex = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'complex'), 'complex', '__httpwww_opengis_netgml3_2_AbstractTimeTopologyPrimitiveType_httpwww_opengis_netgml3_2complex', False)

    
    complex = property(__complex.value, __complex.set, None, None)

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTimePrimitiveType._ElementMap.copy()
    _ElementMap.update({
        __complex.name() : __complex
    })
    _AttributeMap = AbstractTimePrimitiveType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractTimeTopologyPrimitiveType', AbstractTimeTopologyPrimitiveType)


# Complex type DomainSetType with content type ELEMENT_ONLY
class DomainSetType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DomainSetType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractTimeObject uses Python identifier AbstractTimeObject
    __AbstractTimeObject = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTimeObject'), 'AbstractTimeObject', '__httpwww_opengis_netgml3_2_DomainSetType_httpwww_opengis_netgml3_2AbstractTimeObject', False)

    
    AbstractTimeObject = property(__AbstractTimeObject.value, __AbstractTimeObject.set, None, u'gml:AbstractTimeObject acts as the head of a substitution group for all temporal primitives and complexes.')

    
    # Element {http://www.opengis.net/gml/3.2}AbstractGeometry uses Python identifier AbstractGeometry
    __AbstractGeometry = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeometry'), 'AbstractGeometry', '__httpwww_opengis_netgml3_2_DomainSetType_httpwww_opengis_netgml3_2AbstractGeometry', False)

    
    AbstractGeometry = property(__AbstractGeometry.value, __AbstractGeometry.set, None, u'The AbstractGeometry element is the abstract head of the substitution group for all geometry elements of GML. This includes pre-defined and user-defined geometry elements. Any geometry element shall be a direct or indirect extension/restriction of AbstractGeometryType and shall be directly or indirectly in the substitution group of AbstractGeometry.')

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_DomainSetType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_DomainSetType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_DomainSetType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_DomainSetType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_DomainSetType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_DomainSetType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_DomainSetType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_DomainSetType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_DomainSetType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_DomainSetType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __AbstractTimeObject.name() : __AbstractTimeObject,
        __AbstractGeometry.name() : __AbstractGeometry
    }
    _AttributeMap = {
        __arcrole.name() : __arcrole,
        __title.name() : __title,
        __show.name() : __show,
        __nilReason.name() : __nilReason,
        __role.name() : __role,
        __actuate.name() : __actuate,
        __remoteSchema.name() : __remoteSchema,
        __owns.name() : __owns,
        __href.name() : __href,
        __type.name() : __type
    }
_Namespace_gml.addCategoryObject('typeBinding', u'DomainSetType', DomainSetType)


# Complex type DS_DataSet_Type with content type ELEMENT_ONLY
class DS_DataSet_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DS_DataSet_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}has uses Python identifier has
    __has = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'has'), 'has', '__httpwww_isotc211_org2005gmd_DS_DataSet_Type_httpwww_isotc211_org2005gmdhas', True)

    
    has = property(__has.value, __has.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}partOf uses Python identifier partOf
    __partOf = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'partOf'), 'partOf', '__httpwww_isotc211_org2005gmd_DS_DataSet_Type_httpwww_isotc211_org2005gmdpartOf', True)

    
    partOf = property(__partOf.value, __partOf.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __has.name() : __has,
        __partOf.name() : __partOf
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DS_DataSet_Type', DS_DataSet_Type)


# Complex type MD_Format_PropertyType with content type ELEMENT_ONLY
class MD_Format_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Format_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_Format uses Python identifier MD_Format
    __MD_Format = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Format'), 'MD_Format', '__httpwww_isotc211_org2005gmd_MD_Format_PropertyType_httpwww_isotc211_org2005gmdMD_Format', False)

    
    MD_Format = property(__MD_Format.value, __MD_Format.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_Format_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_Format_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_Format_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_Format_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_Format_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_Format_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_Format_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_Format_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_Format_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __MD_Format.name() : __MD_Format
    }
    _AttributeMap = {
        __show.name() : __show,
        __type.name() : __type,
        __href.name() : __href,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __uuidref.name() : __uuidref,
        __actuate.name() : __actuate
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Format_PropertyType', MD_Format_PropertyType)


# Complex type ProcedurePropertyType with content type ELEMENT_ONLY
class ProcedurePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ProcedurePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractFeature uses Python identifier AbstractFeature
    __AbstractFeature = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractFeature'), 'AbstractFeature', '__httpwww_opengis_netgml3_2_ProcedurePropertyType_httpwww_opengis_netgml3_2AbstractFeature', False)

    
    AbstractFeature = property(__AbstractFeature.value, __AbstractFeature.set, None, u'This abstract element serves as the head of a substitution group which may contain any elements whose content model is derived from gml:AbstractFeatureType.  This may be used as a variable in the construction of content models.  \ngml:AbstractFeature may be thought of as "anything that is a GML feature" and may be used to define variables or templates in which the value of a GML property is "any feature". This occurs in particular in a GML feature collection where the feature member properties contain one or multiple copies of gml:AbstractFeature respectively.')

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_ProcedurePropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_ProcedurePropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_ProcedurePropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_ProcedurePropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_ProcedurePropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_ProcedurePropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_ProcedurePropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_ProcedurePropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_ProcedurePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_ProcedurePropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __AbstractFeature.name() : __AbstractFeature
    }
    _AttributeMap = {
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __actuate.name() : __actuate,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show,
        __owns.name() : __owns,
        __href.name() : __href
    }
_Namespace_gml.addCategoryObject('typeBinding', u'ProcedurePropertyType', ProcedurePropertyType)


# Complex type MD_AggregateInformation_Type with content type ELEMENT_ONLY
class MD_AggregateInformation_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_AggregateInformation_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}aggregateDataSetName uses Python identifier aggregateDataSetName
    __aggregateDataSetName = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'aggregateDataSetName'), 'aggregateDataSetName', '__httpwww_isotc211_org2005gmd_MD_AggregateInformation_Type_httpwww_isotc211_org2005gmdaggregateDataSetName', False)

    
    aggregateDataSetName = property(__aggregateDataSetName.value, __aggregateDataSetName.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}initiativeType uses Python identifier initiativeType
    __initiativeType = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'initiativeType'), 'initiativeType', '__httpwww_isotc211_org2005gmd_MD_AggregateInformation_Type_httpwww_isotc211_org2005gmdinitiativeType', False)

    
    initiativeType = property(__initiativeType.value, __initiativeType.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}aggregateDataSetIdentifier uses Python identifier aggregateDataSetIdentifier
    __aggregateDataSetIdentifier = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'aggregateDataSetIdentifier'), 'aggregateDataSetIdentifier', '__httpwww_isotc211_org2005gmd_MD_AggregateInformation_Type_httpwww_isotc211_org2005gmdaggregateDataSetIdentifier', False)

    
    aggregateDataSetIdentifier = property(__aggregateDataSetIdentifier.value, __aggregateDataSetIdentifier.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}associationType uses Python identifier associationType
    __associationType = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'associationType'), 'associationType', '__httpwww_isotc211_org2005gmd_MD_AggregateInformation_Type_httpwww_isotc211_org2005gmdassociationType', False)

    
    associationType = property(__associationType.value, __associationType.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __aggregateDataSetName.name() : __aggregateDataSetName,
        __initiativeType.name() : __initiativeType,
        __aggregateDataSetIdentifier.name() : __aggregateDataSetIdentifier,
        __associationType.name() : __associationType
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_AggregateInformation_Type', MD_AggregateInformation_Type)


# Complex type CI_ResponsibleParty_Type with content type ELEMENT_ONLY
class CI_ResponsibleParty_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_ResponsibleParty_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}individualName uses Python identifier individualName
    __individualName = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'individualName'), 'individualName', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_Type_httpwww_isotc211_org2005gmdindividualName', False)

    
    individualName = property(__individualName.value, __individualName.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}positionName uses Python identifier positionName
    __positionName = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'positionName'), 'positionName', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_Type_httpwww_isotc211_org2005gmdpositionName', False)

    
    positionName = property(__positionName.value, __positionName.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}role uses Python identifier role
    __role = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'role'), 'role', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_Type_httpwww_isotc211_org2005gmdrole', False)

    
    role = property(__role.value, __role.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}contactInfo uses Python identifier contactInfo
    __contactInfo = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'contactInfo'), 'contactInfo', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_Type_httpwww_isotc211_org2005gmdcontactInfo', False)

    
    contactInfo = property(__contactInfo.value, __contactInfo.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}organisationName uses Python identifier organisationName
    __organisationName = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'organisationName'), 'organisationName', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_Type_httpwww_isotc211_org2005gmdorganisationName', False)

    
    organisationName = property(__organisationName.value, __organisationName.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __individualName.name() : __individualName,
        __positionName.name() : __positionName,
        __role.name() : __role,
        __contactInfo.name() : __contactInfo,
        __organisationName.name() : __organisationName
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_ResponsibleParty_Type', CI_ResponsibleParty_Type)


# Complex type CTD_ANON_4 with content type ELEMENT_ONLY
class CTD_ANON_4 (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = None
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}AbstractDQ_PositionalAccuracy uses Python identifier AbstractDQ_PositionalAccuracy
    __AbstractDQ_PositionalAccuracy = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDQ_PositionalAccuracy'), 'AbstractDQ_PositionalAccuracy', '__httpwww_opengis_netgml3_2_CTD_ANON_4_httpwww_isotc211_org2005gmdAbstractDQ_PositionalAccuracy', False)

    
    AbstractDQ_PositionalAccuracy = property(__AbstractDQ_PositionalAccuracy.value, __AbstractDQ_PositionalAccuracy.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_CTD_ANON_4_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_CTD_ANON_4_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_CTD_ANON_4_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_CTD_ANON_4_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CTD_ANON_4_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_CTD_ANON_4_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_CTD_ANON_4_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_CTD_ANON_4_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_CTD_ANON_4_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __AbstractDQ_PositionalAccuracy.name() : __AbstractDQ_PositionalAccuracy
    }
    _AttributeMap = {
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __title.name() : __title,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show,
        __href.name() : __href
    }



# Complex type SolidArrayPropertyType with content type ELEMENT_ONLY
class SolidArrayPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SolidArrayPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractSolid uses Python identifier AbstractSolid
    __AbstractSolid = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractSolid'), 'AbstractSolid', '__httpwww_opengis_netgml3_2_SolidArrayPropertyType_httpwww_opengis_netgml3_2AbstractSolid', True)

    
    AbstractSolid = property(__AbstractSolid.value, __AbstractSolid.set, None, u'The AbstractSolid element is the abstract head of the substituition group for all (continuous) solid elements.')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_SolidArrayPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)


    _ElementMap = {
        __AbstractSolid.name() : __AbstractSolid
    }
    _AttributeMap = {
        __owns.name() : __owns
    }
_Namespace_gml.addCategoryObject('typeBinding', u'SolidArrayPropertyType', SolidArrayPropertyType)


# Complex type CubicSplineType with content type ELEMENT_ONLY
class CubicSplineType (AbstractCurveSegmentType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CubicSplineType')
    # Base type is AbstractCurveSegmentType
    
    # Element {http://www.opengis.net/gml/3.2}pointProperty uses Python identifier pointProperty
    __pointProperty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pointProperty'), 'pointProperty', '__httpwww_opengis_netgml3_2_CubicSplineType_httpwww_opengis_netgml3_2pointProperty', True)

    
    pointProperty = property(__pointProperty.value, __pointProperty.set, None, u'This property element either references a point via the XLink-attributes or contains the point element. pointProperty is the predefined property which may be used by GML Application Schemas whenever a GML feature has a property with a value that is substitutable for Point.')

    
    # Element {http://www.opengis.net/gml/3.2}vectorAtStart uses Python identifier vectorAtStart
    __vectorAtStart = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'vectorAtStart'), 'vectorAtStart', '__httpwww_opengis_netgml3_2_CubicSplineType_httpwww_opengis_netgml3_2vectorAtStart', False)

    
    vectorAtStart = property(__vectorAtStart.value, __vectorAtStart.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}pointRep uses Python identifier pointRep
    __pointRep = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pointRep'), 'pointRep', '__httpwww_opengis_netgml3_2_CubicSplineType_httpwww_opengis_netgml3_2pointRep', True)

    
    pointRep = property(__pointRep.value, __pointRep.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}posList uses Python identifier posList
    __posList = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'posList'), 'posList', '__httpwww_opengis_netgml3_2_CubicSplineType_httpwww_opengis_netgml3_2posList', False)

    
    posList = property(__posList.value, __posList.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}coordinates uses Python identifier coordinates
    __coordinates = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coordinates'), 'coordinates', '__httpwww_opengis_netgml3_2_CubicSplineType_httpwww_opengis_netgml3_2coordinates', False)

    
    coordinates = property(__coordinates.value, __coordinates.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}pos uses Python identifier pos
    __pos = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pos'), 'pos', '__httpwww_opengis_netgml3_2_CubicSplineType_httpwww_opengis_netgml3_2pos', True)

    
    pos = property(__pos.value, __pos.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}vectorAtEnd uses Python identifier vectorAtEnd
    __vectorAtEnd = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'vectorAtEnd'), 'vectorAtEnd', '__httpwww_opengis_netgml3_2_CubicSplineType_httpwww_opengis_netgml3_2vectorAtEnd', False)

    
    vectorAtEnd = property(__vectorAtEnd.value, __vectorAtEnd.set, None, None)

    
    # Attribute degree uses Python identifier degree
    __degree = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'degree'), 'degree', '__httpwww_opengis_netgml3_2_CubicSplineType_degree', pyxb.binding.datatypes.integer, fixed=True, unicode_default=u'3')
    
    degree = property(__degree.value, __degree.set, None, None)

    
    # Attribute numDerivativesAtStart inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType
    
    # Attribute numDerivativesAtEnd inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType
    
    # Attribute numDerivativeInterior inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType
    
    # Attribute interpolation uses Python identifier interpolation
    __interpolation = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'interpolation'), 'interpolation', '__httpwww_opengis_netgml3_2_CubicSplineType_interpolation', CurveInterpolationType, fixed=True, unicode_default=u'cubicSpline')
    
    interpolation = property(__interpolation.value, __interpolation.set, None, None)


    _ElementMap = AbstractCurveSegmentType._ElementMap.copy()
    _ElementMap.update({
        __pointProperty.name() : __pointProperty,
        __vectorAtStart.name() : __vectorAtStart,
        __pointRep.name() : __pointRep,
        __posList.name() : __posList,
        __coordinates.name() : __coordinates,
        __pos.name() : __pos,
        __vectorAtEnd.name() : __vectorAtEnd
    })
    _AttributeMap = AbstractCurveSegmentType._AttributeMap.copy()
    _AttributeMap.update({
        __degree.name() : __degree,
        __interpolation.name() : __interpolation
    })
_Namespace_gml.addCategoryObject('typeBinding', u'CubicSplineType', CubicSplineType)


# Complex type SphericalCSPropertyType with content type ELEMENT_ONLY
class SphericalCSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SphericalCSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}SphericalCS uses Python identifier SphericalCS
    __SphericalCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'SphericalCS'), 'SphericalCS', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_opengis_netgml3_2SphericalCS', False)

    
    SphericalCS = property(__SphericalCS.value, __SphericalCS.set, None, u'gml:SphericalCS is a three-dimensional coordinate system with one distance measured from the origin and two angular coordinates. A SphericalCS shall have three gml:axis property elements.')

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __SphericalCS.name() : __SphericalCS
    }
    _AttributeMap = {
        __actuate.name() : __actuate,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __arcrole.name() : __arcrole,
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show,
        __title.name() : __title,
        __href.name() : __href,
        __type.name() : __type
    }
_Namespace_gml.addCategoryObject('typeBinding', u'SphericalCSPropertyType', SphericalCSPropertyType)


# Complex type TimeReferenceSystemType with content type ELEMENT_ONLY
class TimeReferenceSystemType (DefinitionType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeReferenceSystemType')
    # Base type is DefinitionType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}domainOfValidity uses Python identifier domainOfValidity
    __domainOfValidity = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'domainOfValidity'), 'domainOfValidity', '__httpwww_opengis_netgml3_2_TimeReferenceSystemType_httpwww_opengis_netgml3_2domainOfValidity', False)

    
    domainOfValidity = property(__domainOfValidity.value, __domainOfValidity.set, None, None)

    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = DefinitionType._ElementMap.copy()
    _ElementMap.update({
        __domainOfValidity.name() : __domainOfValidity
    })
    _AttributeMap = DefinitionType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TimeReferenceSystemType', TimeReferenceSystemType)


# Complex type TimeOrdinalReferenceSystemType with content type ELEMENT_ONLY
class TimeOrdinalReferenceSystemType (TimeReferenceSystemType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeOrdinalReferenceSystemType')
    # Base type is TimeReferenceSystemType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element {http://www.opengis.net/gml/3.2}component uses Python identifier component
    __component = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'component'), 'component', '__httpwww_opengis_netgml3_2_TimeOrdinalReferenceSystemType_httpwww_opengis_netgml3_2component', True)

    
    component = property(__component.value, __component.set, None, None)

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}TimeReferenceSystemType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = TimeReferenceSystemType._ElementMap.copy()
    _ElementMap.update({
        __component.name() : __component
    })
    _AttributeMap = TimeReferenceSystemType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TimeOrdinalReferenceSystemType', TimeOrdinalReferenceSystemType)


# Complex type LI_Lineage_Type with content type ELEMENT_ONLY
class LI_Lineage_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'LI_Lineage_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}source uses Python identifier source
    __source = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'source'), 'source', '__httpwww_isotc211_org2005gmd_LI_Lineage_Type_httpwww_isotc211_org2005gmdsource', True)

    
    source = property(__source.value, __source.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}statement uses Python identifier statement
    __statement = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'statement'), 'statement', '__httpwww_isotc211_org2005gmd_LI_Lineage_Type_httpwww_isotc211_org2005gmdstatement', False)

    
    statement = property(__statement.value, __statement.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}processStep uses Python identifier processStep
    __processStep = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'processStep'), 'processStep', '__httpwww_isotc211_org2005gmd_LI_Lineage_Type_httpwww_isotc211_org2005gmdprocessStep', True)

    
    processStep = property(__processStep.value, __processStep.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __source.name() : __source,
        __statement.name() : __statement,
        __processStep.name() : __processStep
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'LI_Lineage_Type', LI_Lineage_Type)


# Complex type LI_Source_PropertyType with content type ELEMENT_ONLY
class LI_Source_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'LI_Source_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}LI_Source uses Python identifier LI_Source
    __LI_Source = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'LI_Source'), 'LI_Source', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_isotc211_org2005gmdLI_Source', False)

    
    LI_Source = property(__LI_Source.value, __LI_Source.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)


    _ElementMap = {
        __LI_Source.name() : __LI_Source
    }
    _AttributeMap = {
        __show.name() : __show,
        __href.name() : __href,
        __nilReason.name() : __nilReason,
        __type.name() : __type,
        __actuate.name() : __actuate,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __title.name() : __title,
        __uuidref.name() : __uuidref
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'LI_Source_PropertyType', LI_Source_PropertyType)


# Complex type MD_FeatureCatalogueDescription_PropertyType with content type ELEMENT_ONLY
class MD_FeatureCatalogueDescription_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_FeatureCatalogueDescription_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_FeatureCatalogueDescription uses Python identifier MD_FeatureCatalogueDescription
    __MD_FeatureCatalogueDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_FeatureCatalogueDescription'), 'MD_FeatureCatalogueDescription', '__httpwww_isotc211_org2005gmd_MD_FeatureCatalogueDescription_PropertyType_httpwww_isotc211_org2005gmdMD_FeatureCatalogueDescription', False)

    
    MD_FeatureCatalogueDescription = property(__MD_FeatureCatalogueDescription.value, __MD_FeatureCatalogueDescription.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_FeatureCatalogueDescription_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_FeatureCatalogueDescription_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_FeatureCatalogueDescription_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_FeatureCatalogueDescription_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_FeatureCatalogueDescription_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_FeatureCatalogueDescription_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_FeatureCatalogueDescription_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_FeatureCatalogueDescription_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_FeatureCatalogueDescription_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __MD_FeatureCatalogueDescription.name() : __MD_FeatureCatalogueDescription
    }
    _AttributeMap = {
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __show.name() : __show,
        __title.name() : __title,
        __role.name() : __role,
        __uuidref.name() : __uuidref,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __href.name() : __href
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_FeatureCatalogueDescription_PropertyType', MD_FeatureCatalogueDescription_PropertyType)


# Complex type IndirectEntryType with content type ELEMENT_ONLY
class IndirectEntryType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'IndirectEntryType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}DefinitionProxy uses Python identifier DefinitionProxy
    __DefinitionProxy = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'DefinitionProxy'), 'DefinitionProxy', '__httpwww_opengis_netgml3_2_IndirectEntryType_httpwww_opengis_netgml3_2DefinitionProxy', False)

    
    DefinitionProxy = property(__DefinitionProxy.value, __DefinitionProxy.set, None, u'')


    _ElementMap = {
        __DefinitionProxy.name() : __DefinitionProxy
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'IndirectEntryType', IndirectEntryType)


# Complex type ConversionType with content type ELEMENT_ONLY
class ConversionType (AbstractGeneralConversionType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ConversionType')
    # Base type is AbstractGeneralConversionType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element {http://www.opengis.net/gml/3.2}parameterValue uses Python identifier parameterValue
    __parameterValue = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'parameterValue'), 'parameterValue', '__httpwww_opengis_netgml3_2_ConversionType_httpwww_opengis_netgml3_2parameterValue', True)

    
    parameterValue = property(__parameterValue.value, __parameterValue.set, None, u'gml:parameterValue is a composition association to a parameter value or group of parameter values used by a coordinate operation.')

    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}method uses Python identifier method
    __method = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'method'), 'method', '__httpwww_opengis_netgml3_2_ConversionType_httpwww_opengis_netgml3_2method', False)

    
    method = property(__method.value, __method.set, None, u'gml:method is an association role to the operation method used by a coordinate operation.')

    
    # Element coordinateOperationAccuracy ({http://www.opengis.net/gml/3.2}coordinateOperationAccuracy) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id_2 inherited from {http://www.opengis.net/gml/3.2}AbstractGeneralConversionType

    _ElementMap = AbstractGeneralConversionType._ElementMap.copy()
    _ElementMap.update({
        __parameterValue.name() : __parameterValue,
        __method.name() : __method
    })
    _AttributeMap = AbstractGeneralConversionType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'ConversionType', ConversionType)


# Complex type MD_RangeDimension_Type with content type ELEMENT_ONLY
class MD_RangeDimension_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_RangeDimension_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}sequenceIdentifier uses Python identifier sequenceIdentifier
    __sequenceIdentifier = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'sequenceIdentifier'), 'sequenceIdentifier', '__httpwww_isotc211_org2005gmd_MD_RangeDimension_Type_httpwww_isotc211_org2005gmdsequenceIdentifier', False)

    
    sequenceIdentifier = property(__sequenceIdentifier.value, __sequenceIdentifier.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}descriptor uses Python identifier descriptor
    __descriptor = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'descriptor'), 'descriptor', '__httpwww_isotc211_org2005gmd_MD_RangeDimension_Type_httpwww_isotc211_org2005gmddescriptor', False)

    
    descriptor = property(__descriptor.value, __descriptor.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __sequenceIdentifier.name() : __sequenceIdentifier,
        __descriptor.name() : __descriptor
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_RangeDimension_Type', MD_RangeDimension_Type)


# Complex type MD_Band_Type with content type ELEMENT_ONLY
class MD_Band_Type (MD_RangeDimension_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Band_Type')
    # Base type is MD_RangeDimension_Type
    
    # Element descriptor ({http://www.isotc211.org/2005/gmd}descriptor) inherited from {http://www.isotc211.org/2005/gmd}MD_RangeDimension_Type
    
    # Element {http://www.isotc211.org/2005/gmd}peakResponse uses Python identifier peakResponse
    __peakResponse = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'peakResponse'), 'peakResponse', '__httpwww_isotc211_org2005gmd_MD_Band_Type_httpwww_isotc211_org2005gmdpeakResponse', False)

    
    peakResponse = property(__peakResponse.value, __peakResponse.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}bitsPerValue uses Python identifier bitsPerValue
    __bitsPerValue = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'bitsPerValue'), 'bitsPerValue', '__httpwww_isotc211_org2005gmd_MD_Band_Type_httpwww_isotc211_org2005gmdbitsPerValue', False)

    
    bitsPerValue = property(__bitsPerValue.value, __bitsPerValue.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}units uses Python identifier units
    __units = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'units'), 'units', '__httpwww_isotc211_org2005gmd_MD_Band_Type_httpwww_isotc211_org2005gmdunits', False)

    
    units = property(__units.value, __units.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}toneGradation uses Python identifier toneGradation
    __toneGradation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'toneGradation'), 'toneGradation', '__httpwww_isotc211_org2005gmd_MD_Band_Type_httpwww_isotc211_org2005gmdtoneGradation', False)

    
    toneGradation = property(__toneGradation.value, __toneGradation.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}scaleFactor uses Python identifier scaleFactor
    __scaleFactor = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'scaleFactor'), 'scaleFactor', '__httpwww_isotc211_org2005gmd_MD_Band_Type_httpwww_isotc211_org2005gmdscaleFactor', False)

    
    scaleFactor = property(__scaleFactor.value, __scaleFactor.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}offset uses Python identifier offset
    __offset = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'offset'), 'offset', '__httpwww_isotc211_org2005gmd_MD_Band_Type_httpwww_isotc211_org2005gmdoffset', False)

    
    offset = property(__offset.value, __offset.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}maxValue uses Python identifier maxValue
    __maxValue = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'maxValue'), 'maxValue', '__httpwww_isotc211_org2005gmd_MD_Band_Type_httpwww_isotc211_org2005gmdmaxValue', False)

    
    maxValue = property(__maxValue.value, __maxValue.set, None, None)

    
    # Element sequenceIdentifier ({http://www.isotc211.org/2005/gmd}sequenceIdentifier) inherited from {http://www.isotc211.org/2005/gmd}MD_RangeDimension_Type
    
    # Element {http://www.isotc211.org/2005/gmd}minValue uses Python identifier minValue
    __minValue = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'minValue'), 'minValue', '__httpwww_isotc211_org2005gmd_MD_Band_Type_httpwww_isotc211_org2005gmdminValue', False)

    
    minValue = property(__minValue.value, __minValue.set, None, None)

    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = MD_RangeDimension_Type._ElementMap.copy()
    _ElementMap.update({
        __peakResponse.name() : __peakResponse,
        __bitsPerValue.name() : __bitsPerValue,
        __units.name() : __units,
        __toneGradation.name() : __toneGradation,
        __scaleFactor.name() : __scaleFactor,
        __offset.name() : __offset,
        __maxValue.name() : __maxValue,
        __minValue.name() : __minValue
    })
    _AttributeMap = MD_RangeDimension_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Band_Type', MD_Band_Type)


# Complex type AffineCSType with content type ELEMENT_ONLY
class AffineCSType (AbstractCoordinateSystemType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AffineCSType')
    # Base type is AbstractCoordinateSystemType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element axis ({http://www.opengis.net/gml/3.2}axis) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute aggregationType inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCoordinateSystemType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractCoordinateSystemType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AffineCSType', AffineCSType)


# Complex type TimePeriodPropertyType with content type ELEMENT_ONLY
class TimePeriodPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimePeriodPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TimePeriod uses Python identifier TimePeriod
    __TimePeriod = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TimePeriod'), 'TimePeriod', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_opengis_netgml3_2TimePeriod', False)

    
    TimePeriod = property(__TimePeriod.value, __TimePeriod.set, None, u'gml:TimePeriod acts as a one-dimensional geometric primitive that represents an identifiable extent in time.\nThe location in of a gml:TimePeriod is described by the temporal positions of the instants at which it begins and ends. The length of the period is equal to the temporal distance between the two bounding temporal positions. \nBoth beginning and end may be described in terms of their direct position using gml:TimePositionType which is an XML Schema simple content type, or by reference to an indentifiable time instant using gml:TimeInstantPropertyType.\nAlternatively a limit of a gml:TimePeriod may use the conventional GML property model to make a reference to a time instant described elsewhere, or a limit may be indicated as a direct position.')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)


    _ElementMap = {
        __TimePeriod.name() : __TimePeriod
    }
    _AttributeMap = {
        __href.name() : __href,
        __type.name() : __type,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __actuate.name() : __actuate,
        __title.name() : __title,
        __nilReason.name() : __nilReason,
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show,
        __owns.name() : __owns
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TimePeriodPropertyType', TimePeriodPropertyType)


# Complex type LI_Source_Type with content type ELEMENT_ONLY
class LI_Source_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'LI_Source_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}sourceExtent uses Python identifier sourceExtent
    __sourceExtent = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'sourceExtent'), 'sourceExtent', '__httpwww_isotc211_org2005gmd_LI_Source_Type_httpwww_isotc211_org2005gmdsourceExtent', True)

    
    sourceExtent = property(__sourceExtent.value, __sourceExtent.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}sourceStep uses Python identifier sourceStep
    __sourceStep = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'sourceStep'), 'sourceStep', '__httpwww_isotc211_org2005gmd_LI_Source_Type_httpwww_isotc211_org2005gmdsourceStep', True)

    
    sourceStep = property(__sourceStep.value, __sourceStep.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}scaleDenominator uses Python identifier scaleDenominator
    __scaleDenominator = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'scaleDenominator'), 'scaleDenominator', '__httpwww_isotc211_org2005gmd_LI_Source_Type_httpwww_isotc211_org2005gmdscaleDenominator', False)

    
    scaleDenominator = property(__scaleDenominator.value, __scaleDenominator.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}description uses Python identifier description
    __description = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'description'), 'description', '__httpwww_isotc211_org2005gmd_LI_Source_Type_httpwww_isotc211_org2005gmddescription', False)

    
    description = property(__description.value, __description.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}sourceReferenceSystem uses Python identifier sourceReferenceSystem
    __sourceReferenceSystem = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'sourceReferenceSystem'), 'sourceReferenceSystem', '__httpwww_isotc211_org2005gmd_LI_Source_Type_httpwww_isotc211_org2005gmdsourceReferenceSystem', False)

    
    sourceReferenceSystem = property(__sourceReferenceSystem.value, __sourceReferenceSystem.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}sourceCitation uses Python identifier sourceCitation
    __sourceCitation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'sourceCitation'), 'sourceCitation', '__httpwww_isotc211_org2005gmd_LI_Source_Type_httpwww_isotc211_org2005gmdsourceCitation', False)

    
    sourceCitation = property(__sourceCitation.value, __sourceCitation.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __sourceExtent.name() : __sourceExtent,
        __sourceStep.name() : __sourceStep,
        __scaleDenominator.name() : __scaleDenominator,
        __description.name() : __description,
        __sourceReferenceSystem.name() : __sourceReferenceSystem,
        __sourceCitation.name() : __sourceCitation
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'LI_Source_Type', LI_Source_Type)


# Complex type SingleCRSPropertyType with content type ELEMENT_ONLY
class SingleCRSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SingleCRSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractSingleCRS uses Python identifier AbstractSingleCRS
    __AbstractSingleCRS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractSingleCRS'), 'AbstractSingleCRS', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_opengis_netgml3_2AbstractSingleCRS', False)

    
    AbstractSingleCRS = property(__AbstractSingleCRS.value, __AbstractSingleCRS.set, None, u'gml:AbstractSingleCRS implements a coordinate reference system consisting of one coordinate system and one datum (as opposed to a Compound CRS).')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __AbstractSingleCRS.name() : __AbstractSingleCRS
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __title.name() : __title,
        __href.name() : __href,
        __role.name() : __role,
        __show.name() : __show,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __actuate.name() : __actuate,
        __nilReason.name() : __nilReason
    }
_Namespace_gml.addCategoryObject('typeBinding', u'SingleCRSPropertyType', SingleCRSPropertyType)


# Complex type DQ_TemporalConsistency_Type with content type ELEMENT_ONLY
class DQ_TemporalConsistency_Type (AbstractDQ_TemporalAccuracy_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_TemporalConsistency_Type')
    # Base type is AbstractDQ_TemporalAccuracy_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_TemporalAccuracy_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_TemporalAccuracy_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_TemporalConsistency_Type', DQ_TemporalConsistency_Type)


# Complex type ObjectReference_PropertyType with content type EMPTY
class ObjectReference_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'ObjectReference_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gco_ObjectReference_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gco_ObjectReference_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gco_ObjectReference_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gco_ObjectReference_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_ObjectReference_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gco_ObjectReference_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gco_ObjectReference_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gco_ObjectReference_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gco_ObjectReference_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        
    }
    _AttributeMap = {
        __href.name() : __href,
        __type.name() : __type,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __show.name() : __show,
        __uuidref.name() : __uuidref,
        __title.name() : __title,
        __actuate.name() : __actuate
    }
_Namespace_gco.addCategoryObject('typeBinding', u'ObjectReference_PropertyType', ObjectReference_PropertyType)


# Complex type LocalisedCharacterString_PropertyType with content type ELEMENT_ONLY
class LocalisedCharacterString_PropertyType (ObjectReference_PropertyType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'LocalisedCharacterString_PropertyType')
    # Base type is ObjectReference_PropertyType
    
    # Element {http://www.isotc211.org/2005/gmd}LocalisedCharacterString uses Python identifier LocalisedCharacterString
    __LocalisedCharacterString = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'LocalisedCharacterString'), 'LocalisedCharacterString', '__httpwww_isotc211_org2005gmd_LocalisedCharacterString_PropertyType_httpwww_isotc211_org2005gmdLocalisedCharacterString', False)

    
    LocalisedCharacterString = property(__LocalisedCharacterString.value, __LocalisedCharacterString.set, None, None)

    
    # Attribute href inherited from {http://www.isotc211.org/2005/gco}ObjectReference_PropertyType
    
    # Attribute type inherited from {http://www.isotc211.org/2005/gco}ObjectReference_PropertyType
    
    # Attribute role inherited from {http://www.isotc211.org/2005/gco}ObjectReference_PropertyType
    
    # Attribute arcrole inherited from {http://www.isotc211.org/2005/gco}ObjectReference_PropertyType
    
    # Attribute nilReason inherited from {http://www.isotc211.org/2005/gco}ObjectReference_PropertyType
    
    # Attribute show inherited from {http://www.isotc211.org/2005/gco}ObjectReference_PropertyType
    
    # Attribute uuidref inherited from {http://www.isotc211.org/2005/gco}ObjectReference_PropertyType
    
    # Attribute title inherited from {http://www.isotc211.org/2005/gco}ObjectReference_PropertyType
    
    # Attribute actuate inherited from {http://www.isotc211.org/2005/gco}ObjectReference_PropertyType

    _ElementMap = ObjectReference_PropertyType._ElementMap.copy()
    _ElementMap.update({
        __LocalisedCharacterString.name() : __LocalisedCharacterString
    })
    _AttributeMap = ObjectReference_PropertyType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'LocalisedCharacterString_PropertyType', LocalisedCharacterString_PropertyType)


# Complex type CoordinateSystemAxisPropertyType with content type ELEMENT_ONLY
class CoordinateSystemAxisPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CoordinateSystemAxisPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}CoordinateSystemAxis uses Python identifier CoordinateSystemAxis
    __CoordinateSystemAxis = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'CoordinateSystemAxis'), 'CoordinateSystemAxis', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_opengis_netgml3_2CoordinateSystemAxis', False)

    
    CoordinateSystemAxis = property(__CoordinateSystemAxis.value, __CoordinateSystemAxis.set, None, u'gml:CoordinateSystemAxis is a definition of a coordinate system axis.')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __CoordinateSystemAxis.name() : __CoordinateSystemAxis
    }
    _AttributeMap = {
        __title.name() : __title,
        __actuate.name() : __actuate,
        __remoteSchema.name() : __remoteSchema,
        __role.name() : __role,
        __show.name() : __show,
        __arcrole.name() : __arcrole,
        __href.name() : __href,
        __type.name() : __type,
        __nilReason.name() : __nilReason
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CoordinateSystemAxisPropertyType', CoordinateSystemAxisPropertyType)


# Complex type EX_GeographicExtent_PropertyType with content type ELEMENT_ONLY
class EX_GeographicExtent_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'EX_GeographicExtent_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}AbstractEX_GeographicExtent uses Python identifier AbstractEX_GeographicExtent
    __AbstractEX_GeographicExtent = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractEX_GeographicExtent'), 'AbstractEX_GeographicExtent', '__httpwww_isotc211_org2005gmd_EX_GeographicExtent_PropertyType_httpwww_isotc211_org2005gmdAbstractEX_GeographicExtent', False)

    
    AbstractEX_GeographicExtent = property(__AbstractEX_GeographicExtent.value, __AbstractEX_GeographicExtent.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_EX_GeographicExtent_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_EX_GeographicExtent_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_EX_GeographicExtent_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_EX_GeographicExtent_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_EX_GeographicExtent_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_EX_GeographicExtent_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_EX_GeographicExtent_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_EX_GeographicExtent_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_EX_GeographicExtent_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __AbstractEX_GeographicExtent.name() : __AbstractEX_GeographicExtent
    }
    _AttributeMap = {
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __uuidref.name() : __uuidref,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __href.name() : __href,
        __type.name() : __type,
        __arcrole.name() : __arcrole
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'EX_GeographicExtent_PropertyType', EX_GeographicExtent_PropertyType)


# Complex type AbstractMD_ContentInformation_Type with content type EMPTY
class AbstractMD_ContentInformation_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractMD_ContentInformation_Type')
    # Base type is AbstractObject_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractMD_ContentInformation_Type', AbstractMD_ContentInformation_Type)


# Complex type MD_CoverageDescription_Type with content type ELEMENT_ONLY
class MD_CoverageDescription_Type (AbstractMD_ContentInformation_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_CoverageDescription_Type')
    # Base type is AbstractMD_ContentInformation_Type
    
    # Element {http://www.isotc211.org/2005/gmd}attributeDescription uses Python identifier attributeDescription
    __attributeDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'attributeDescription'), 'attributeDescription', '__httpwww_isotc211_org2005gmd_MD_CoverageDescription_Type_httpwww_isotc211_org2005gmdattributeDescription', False)

    
    attributeDescription = property(__attributeDescription.value, __attributeDescription.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}contentType uses Python identifier contentType
    __contentType = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'contentType'), 'contentType', '__httpwww_isotc211_org2005gmd_MD_CoverageDescription_Type_httpwww_isotc211_org2005gmdcontentType', False)

    
    contentType = property(__contentType.value, __contentType.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}dimension uses Python identifier dimension
    __dimension = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'dimension'), 'dimension', '__httpwww_isotc211_org2005gmd_MD_CoverageDescription_Type_httpwww_isotc211_org2005gmddimension', True)

    
    dimension = property(__dimension.value, __dimension.set, None, None)

    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractMD_ContentInformation_Type._ElementMap.copy()
    _ElementMap.update({
        __attributeDescription.name() : __attributeDescription,
        __contentType.name() : __contentType,
        __dimension.name() : __dimension
    })
    _AttributeMap = AbstractMD_ContentInformation_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_CoverageDescription_Type', MD_CoverageDescription_Type)


# Complex type MD_ImageDescription_Type with content type ELEMENT_ONLY
class MD_ImageDescription_Type (MD_CoverageDescription_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ImageDescription_Type')
    # Base type is MD_CoverageDescription_Type
    
    # Element {http://www.isotc211.org/2005/gmd}filmDistortionInformationAvailability uses Python identifier filmDistortionInformationAvailability
    __filmDistortionInformationAvailability = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'filmDistortionInformationAvailability'), 'filmDistortionInformationAvailability', '__httpwww_isotc211_org2005gmd_MD_ImageDescription_Type_httpwww_isotc211_org2005gmdfilmDistortionInformationAvailability', False)

    
    filmDistortionInformationAvailability = property(__filmDistortionInformationAvailability.value, __filmDistortionInformationAvailability.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}processingLevelCode uses Python identifier processingLevelCode
    __processingLevelCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'processingLevelCode'), 'processingLevelCode', '__httpwww_isotc211_org2005gmd_MD_ImageDescription_Type_httpwww_isotc211_org2005gmdprocessingLevelCode', False)

    
    processingLevelCode = property(__processingLevelCode.value, __processingLevelCode.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}illuminationAzimuthAngle uses Python identifier illuminationAzimuthAngle
    __illuminationAzimuthAngle = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'illuminationAzimuthAngle'), 'illuminationAzimuthAngle', '__httpwww_isotc211_org2005gmd_MD_ImageDescription_Type_httpwww_isotc211_org2005gmdilluminationAzimuthAngle', False)

    
    illuminationAzimuthAngle = property(__illuminationAzimuthAngle.value, __illuminationAzimuthAngle.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}compressionGenerationQuantity uses Python identifier compressionGenerationQuantity
    __compressionGenerationQuantity = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'compressionGenerationQuantity'), 'compressionGenerationQuantity', '__httpwww_isotc211_org2005gmd_MD_ImageDescription_Type_httpwww_isotc211_org2005gmdcompressionGenerationQuantity', False)

    
    compressionGenerationQuantity = property(__compressionGenerationQuantity.value, __compressionGenerationQuantity.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}cloudCoverPercentage uses Python identifier cloudCoverPercentage
    __cloudCoverPercentage = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'cloudCoverPercentage'), 'cloudCoverPercentage', '__httpwww_isotc211_org2005gmd_MD_ImageDescription_Type_httpwww_isotc211_org2005gmdcloudCoverPercentage', False)

    
    cloudCoverPercentage = property(__cloudCoverPercentage.value, __cloudCoverPercentage.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}triangulationIndicator uses Python identifier triangulationIndicator
    __triangulationIndicator = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'triangulationIndicator'), 'triangulationIndicator', '__httpwww_isotc211_org2005gmd_MD_ImageDescription_Type_httpwww_isotc211_org2005gmdtriangulationIndicator', False)

    
    triangulationIndicator = property(__triangulationIndicator.value, __triangulationIndicator.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}illuminationElevationAngle uses Python identifier illuminationElevationAngle
    __illuminationElevationAngle = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'illuminationElevationAngle'), 'illuminationElevationAngle', '__httpwww_isotc211_org2005gmd_MD_ImageDescription_Type_httpwww_isotc211_org2005gmdilluminationElevationAngle', False)

    
    illuminationElevationAngle = property(__illuminationElevationAngle.value, __illuminationElevationAngle.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}radiometricCalibrationDataAvailability uses Python identifier radiometricCalibrationDataAvailability
    __radiometricCalibrationDataAvailability = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'radiometricCalibrationDataAvailability'), 'radiometricCalibrationDataAvailability', '__httpwww_isotc211_org2005gmd_MD_ImageDescription_Type_httpwww_isotc211_org2005gmdradiometricCalibrationDataAvailability', False)

    
    radiometricCalibrationDataAvailability = property(__radiometricCalibrationDataAvailability.value, __radiometricCalibrationDataAvailability.set, None, None)

    
    # Element attributeDescription ({http://www.isotc211.org/2005/gmd}attributeDescription) inherited from {http://www.isotc211.org/2005/gmd}MD_CoverageDescription_Type
    
    # Element {http://www.isotc211.org/2005/gmd}lensDistortionInformationAvailability uses Python identifier lensDistortionInformationAvailability
    __lensDistortionInformationAvailability = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'lensDistortionInformationAvailability'), 'lensDistortionInformationAvailability', '__httpwww_isotc211_org2005gmd_MD_ImageDescription_Type_httpwww_isotc211_org2005gmdlensDistortionInformationAvailability', False)

    
    lensDistortionInformationAvailability = property(__lensDistortionInformationAvailability.value, __lensDistortionInformationAvailability.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}cameraCalibrationInformationAvailability uses Python identifier cameraCalibrationInformationAvailability
    __cameraCalibrationInformationAvailability = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'cameraCalibrationInformationAvailability'), 'cameraCalibrationInformationAvailability', '__httpwww_isotc211_org2005gmd_MD_ImageDescription_Type_httpwww_isotc211_org2005gmdcameraCalibrationInformationAvailability', False)

    
    cameraCalibrationInformationAvailability = property(__cameraCalibrationInformationAvailability.value, __cameraCalibrationInformationAvailability.set, None, None)

    
    # Element contentType ({http://www.isotc211.org/2005/gmd}contentType) inherited from {http://www.isotc211.org/2005/gmd}MD_CoverageDescription_Type
    
    # Element {http://www.isotc211.org/2005/gmd}imagingCondition uses Python identifier imagingCondition
    __imagingCondition = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'imagingCondition'), 'imagingCondition', '__httpwww_isotc211_org2005gmd_MD_ImageDescription_Type_httpwww_isotc211_org2005gmdimagingCondition', False)

    
    imagingCondition = property(__imagingCondition.value, __imagingCondition.set, None, None)

    
    # Element dimension ({http://www.isotc211.org/2005/gmd}dimension) inherited from {http://www.isotc211.org/2005/gmd}MD_CoverageDescription_Type
    
    # Element {http://www.isotc211.org/2005/gmd}imageQualityCode uses Python identifier imageQualityCode
    __imageQualityCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'imageQualityCode'), 'imageQualityCo