/*
* Copyright (C) The Community OpenORB Project. All rights reserved.
*
* This software is published under the terms of The OpenORB Community Software
* License version 1.0, a copy of which has been included with this distribution
* in the LICENSE.txt file.
*/
package org.openorb.util;

import org.apache.avalon.framework.logger.Logger;

import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextExtHelper;

/**
 * This class is the implementation of tools in order to use simply Corba
 * CosNaming.
 *
 * @author Marina Daniel
 * @version $Revision: 1.11 $ $Date: 2002/06/28 08:59:06 $
 * @deprecated Deprecated, methods do not throw exceptions. Use 
 * {@link MapNamingContext} from the new Transient Name Service (TNS),
 * see NamingService package (openorb_tns-x.y.z.jar). This class will
 * be removed very soon now, please follow the recommendations above.
 */
public class ContextUtilities
{
    /**
     * Reference to the ORB
     */
    private org.omg.CORBA.ORB m_orb;

    /**
     * Reference to the Logger
     */
    private Logger m_logger = null;

    /**
     * Reference to the initial context of Corba Naming Service
     */
    private NamingContextExt m_initalContext;


    /**
     * Constructor.
     * @param orb the orb reference
     */
    public ContextUtilities( org.omg.CORBA.ORB orb )
    {
        m_orb = orb;
    }


    /**
     * Return the initial context of the Naming Service.
     * @return the initial context
     */
    public NamingContextExt getInitialContext()
    {
        if ( m_initalContext != null )
            return m_initalContext;

        try
        {
            org.omg.CORBA.Object m_initalContext_obj =
                m_orb.resolve_initial_references( "NameService" );
            m_initalContext = NamingContextExtHelper.narrow(
                m_initalContext_obj );

            return m_initalContext;
        }
        catch ( org.omg.CORBA.ORBPackage.InvalidName in )
        {
            if ( getLogger().isErrorEnabled() )
                getLogger().error("InvalidName NameService!", in);

            return null;
        }

    }


    /**
     * Creates a binding of a name and an object in the naming context.
     *
     * @param name The compound name for the object to bind. 
     * The syntax is ContextA.kindA/ContextB.kindB/obj_name you can specify
     * all the hierarchical naming contexts (the kind of each context is
     * optional). If a naming context do not exist, it will be created
     * @param object The object to bind
     * @return false if a problem occurs 
     */
    public boolean bind( String name, org.omg.CORBA.Object object )
    {

        try
        {
            if ( ( name.indexOf( "/" ) == -1 ) &&
                 ( name.indexOf( "." ) == -1 ) )
            {
                NameComponent[] nameComponent = NamingUtils.to_name ( name );

                ( ( org.omg.CosNaming.NamingContext )
                    getInitialContext() ).bind( nameComponent, object );
            }
            else
                return full_bind( name, object );
        }
        catch ( Exception e )
        {
            return false;
        }

        return true;
    }


    /**
     * Creates a binding of a name and an object in the naming context
     * even if the name is already bound in the context.
     * @param name The compound name for the object to bind. The syntax is
     * ContextA.kindA/ContextB.kindB/obj_name you can specify all the
     * hierarchical naming contexts (the kind of each context is optional).
     * If a naming context do not exist, it will be created
     * @param object The object to bind
     * @return false if a problem occurs
     */
    public boolean rebind( String name, org.omg.CORBA.Object object )
    {
        try
        {
            if ( ( name.indexOf( "/" ) == -1 ) &&
                 ( name.indexOf( "." ) == -1 ) )
            {
                NameComponent[] nameComponent = NamingUtils.to_name ( name );

                ( ( NamingContext ) getInitialContext() ).rebind( 
                    nameComponent, object );
            }
            else
            {

                return full_rebind( name, object, getInitialContext() );
            }
        }
        catch ( Exception e )
        {
            return false;
        }

        return true;
    }


    /**
     * Find and return the object that is store in the directory.
     * Name resolution can have multiple contexts.
     * @param name The coumpond name for the object to resolve. The syntax
     * of this parameter is simple : ContextA.kindA/ContextB.kindB/obj_name
     * the kind value of each context is optional
     * @return The resolved object
     */
    public org.omg.CORBA.Object resolve( String name )
    {
        try
        {
            if ( ( name.indexOf( "/" ) == -1 ) &&
                 ( name.indexOf( "." ) == -1 ) )
            {
                NameComponent[] nameComponent = NamingUtils.to_name ( name );

                return ( ( NamingContext ) getInitialContext() ).resolve(
                    nameComponent );
            }
            else
            {
                NameComponent[] full_context = getInitialContext().to_name(
                    name );
                return ( ( NamingContext ) getInitialContext() ).resolve(
                    full_context );
            }
        }
        catch ( Exception e )
        {
            return null;
        }
    }


    /**
     * create all the naming contexts until the object to rebind
     * @return false if a problem occurs
     */
    private boolean full_rebind( String name,
                                 org.omg.CORBA.Object object,
                                 NamingContextExt init_context )
    {
        try
        {
            NameComponent[] nameComponent = NamingUtils.to_name( name );
            NamingContext prev_context = init_context;
            boolean not_found = false;

            for ( int i = 0; i < nameComponent.length - 1 ; i++ )
            {
                NameComponent context = nameComponent[ i ];
                if ( not_found )
                {
                    prev_context = createNewContext( prev_context, context );
                }
                else
                {
                    try
                    {
                        NameComponent[] tempNameComponent = 
                            new NameComponent[ 1 ];
                        tempNameComponent[ 0 ] = context;
                        org.omg.CORBA.Object prev_context_obj =
                            prev_context.resolve( tempNameComponent );
                        prev_context = NamingContextHelper.narrow(
                            prev_context_obj );

                    }
                    catch ( org.omg.CosNaming.NamingContextPackage.NotFound nf )
                    {
                        prev_context = createNewContext( prev_context,
                            context );
                        not_found = true;
                    }
                    catch ( Exception e )
                    {
                        return false;
                    }
                }

            }

            NameComponent[] objectNameComponent = new NameComponent[ 1 ];
            objectNameComponent[ 0 ] =
                nameComponent[ nameComponent.length - 1 ];
            prev_context.rebind( objectNameComponent, object );
        }
        catch ( Exception ex )
        {
            return false;
        }
        return true;
    }

    /**
     * create all the naming contexts until the object to rebind
     * return false if a problem occurs
     */
    private boolean full_bind( String name, org.omg.CORBA.Object object_value )
    {
        try
        {
            NameComponent[] nameComponent = NamingUtils.to_name( name );
            NamingContext prev_context = getInitialContext();
            boolean not_found = false;

            for ( int i = 0; i < nameComponent.length - 1; i++ )
            {
                NameComponent context = nameComponent[ i ];
                if ( not_found )
                    prev_context = createNewContext( prev_context, context );
                else
                {
                    try
                    {
                        NameComponent[] tempNameComponent =
                            new NameComponent[ 1 ];
                        tempNameComponent[ 0 ] = context;
                        org.omg.CORBA.Object prev_context_obj =
                            prev_context.resolve( tempNameComponent );
                        prev_context = NamingContextHelper.narrow(
                            prev_context_obj );

                    }
                    catch ( org.omg.CosNaming.NamingContextPackage.NotFound nf )
                    {
                        prev_context = createNewContext( prev_context,
                            context );
                        not_found = true;
                    }
                    catch ( Exception e )
                    {
                        return false;
                    }
                }
            }

            NameComponent[] objectNameComponent = new NameComponent[ 1 ];
            objectNameComponent[ 0 ] =
                nameComponent[ nameComponent.length - 1 ];
            prev_context.bind( objectNameComponent, object_value );
        }
        catch ( Exception ex )
        {
            return false;
        }

        return true;

    }


    /**
     * create a new context
     */
    private NamingContext createNewContext( NamingContext prev_context, 
                                            NameComponent context )
    {
        try
        {
            NameComponent[] tempNameComponent = new NameComponent[ 1 ];
            tempNameComponent[ 0 ] = context;
            return prev_context.bind_new_context( tempNameComponent );
        }
        catch ( Exception e )
        {
            return getInitialContext();
        }
    }

    private Logger getLogger()
    {
        if ( null == m_logger )
        {
            m_logger = ( ( org.openorb.CORBA.ORBSingleton ) m_orb ).getLogger();
        }
        return m_logger;
    };

}

