/*
* Copyright (C) The Community OpenORB Project. All rights reserved.
*
* This software is published under the terms of The OpenORB Community Software
* License version 1.0, a copy of which has been included with this distribution
* in the LICENSE.txt file.
*/
package org.openorb.adapter.fwd;

import org.openorb.PI.FeatureInitInfo;
import org.openorb.net.ServerManager;
import org.openorb.adapter.IORUtil;
import org.openorb.corbaloc.CorbalocServiceHelper;
import org.openorb.corbaloc._CorbalocServiceStub;

/**
 * This is the initializer for the forward adapter.
 *
 * @author Unknown
 */
public class ForwardInitializer
    extends org.omg.CORBA.LocalObject
    implements org.openorb.PI.FeatureInitializer, org.omg.PortableInterceptor.ORBInitializer
{
    private ServerManager m_svr_mgr;

    public void pre_init( org.omg.PortableInterceptor.ORBInitInfo info )
    {
    }

    public void init( org.omg.PortableInterceptor.ORBInitInfo orbinfo, FeatureInitInfo featureinfo )
    {
        m_svr_mgr = ( ServerManager ) featureinfo.getFeature( "ServerCPCManager" );

        if ( m_svr_mgr != null )
            new ForwardAdapter( m_svr_mgr );
    }

    public void post_init( org.omg.PortableInterceptor.ORBInitInfo info )
    {
        if ( m_svr_mgr != null )
        {
            org.openorb.CORBA.ORB orb = ( org.openorb.CORBA.ORB ) m_svr_mgr.orb();

            org.openorb.PI.ComponentSet cset = new org.openorb.PI.ComponentSet( orb, null, null );
            cset.interception_point();

            org.omg.IOP.IOR ior = IORUtil.construct_ior( CorbalocServiceHelper.id(),
                    ForwardAdapter.CORBALOC_SVC_ID, cset, m_svr_mgr.get_protocol_ids(), orb );

            org.omg.CORBA.portable.Delegate delegate = new org.openorb.CORBA.Delegate( orb, ior );

            _CorbalocServiceStub service = new _CorbalocServiceStub();

            service._set_delegate( delegate );

            orb.addInitialReference( ForwardAdapter.CORBALOC_SVC_NAME, service );
        }
    }
}

