/*
* Copyright (C) The Community OpenORB Project. All rights reserved.
*
* This software is published under the terms of The OpenORB Community Software
* License version 1.0, a copy of which has been included with this distribution
* in the LICENSE.txt file.
*/
package org.openorb.CORBA;

/**
 *
 * @author Jerome Daniel
 * @version $Revision: 1.5 $ $Date: 2002/07/16 11:17:13 $ 
 */
public class Principal
    extends org.omg.CORBA.Principal
{
    private byte[] m_name;

    /**
     * Constructor with fields initialization
     * @param name name struct member
     */
    public Principal( byte[] name )
    {
        m_name = name;
    }

    public void name( byte [] m_name )
    {
        this.m_name = m_name;
    }

    public byte [] name()
    {
        return m_name;
    }

    public boolean equals( Object obj )
    {
        Principal o2 = ( Principal ) obj;

        if ( m_name.length != o2.m_name.length )
            return false;

        for ( int i = 0; i < m_name.length; ++i )
            if ( m_name[ i ] != o2.m_name[ i ] )
                return false;

        return true;
    }
}
