/* 
 * Copyright (C) 2002-2008 XimpleWare, info@ximpleware.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


package com.ximpleware.xpath;
import java_cup.runtime.Symbol;

import com.ximpleware.XPathParseException;
import com.ximpleware.parser.*;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 4/26/07 1:33 PM from the specification file
 * <tt>scanner.flex</tt>
 */
class Yylex extends sym implements java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\1\1\1\2\0\1\1\22\0\1\1\1\20\1\51\1\0"+
    "\1\3\1\0\1\0\1\52\1\11\1\12\1\21\1\6\1\10\1\4"+
    "\1\5\1\22\12\2\1\54\1\0\1\16\1\17\1\15\1\0\1\7"+
    "\32\0\1\13\1\0\1\14\1\0\1\0\1\0\1\30\1\46\1\40"+
    "\1\23\1\42\1\47\1\43\1\45\1\24\2\0\1\34\1\26\1\31"+
    "\1\27\1\37\1\0\1\32\1\35\1\36\1\41\1\25\1\44\1\53"+
    "\1\0\1\50\1\0\1\33\uff83\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\1\2\1\3\1\4\1\5\1\6\1\7"+
    "\1\10\1\11\1\12\1\13\1\14\1\15\1\16\1\17"+
    "\1\20\1\4\1\21\1\22\6\1\1\23\7\1\2\4"+
    "\1\0\2\3\1\24\1\25\1\26\1\27\1\30\3\1"+
    "\1\31\27\1\1\0\1\32\1\0\1\1\1\33\1\34"+
    "\1\1\1\35\1\36\45\1\1\0\1\37\10\1\1\0"+
    "\1\40\26\1\2\0\1\1\1\0\1\41\4\1\1\0"+
    "\1\42\1\0\1\43\3\1\2\0\1\1\1\0\1\44"+
    "\2\0\21\1\1\45\3\1\1\0\1\46\4\1\1\0"+
    "\1\47\1\1\1\50\7\1\1\0\1\51\1\1\2\0"+
    "\2\1\1\0\1\52\1\0\1\53\5\1\1\0\1\54"+
    "\2\1\1\0\1\1\1\55\3\1\2\0\4\1\1\0"+
    "\1\56\1\1\1\0\1\57\15\1\1\0\1\60\2\1"+
    "\2\0\1\1\1\0\1\61\1\0\1\62\2\1\1\0"+
    "\1\1\1\0\10\1\1\0\1\63\2\1\1\64\1\0"+
    "\1\65\2\1\1\0\1\1\1\66\2\0\1\1\1\0"+
    "\1\1\1\0\3\1\1\0\1\1\1\67\1\0\1\70"+
    "\1\1\1\0\1\1\2\0\1\1\2\0\1\1\1\0"+
    "\1\1\1\0\1\71\1\1\1\0\1\1\1\72\1\0"+
    "\1\73\5\1\1\0\1\1\1\74\1\0\1\1\1\75"+
    "\1\0\1\1\1\76\3\1\1\0\1\77\23\1\1\0"+
    "\1\100\1\0\1\101\17\1\1\0\1\102\1\0\1\103"+
    "\5\1\3\0\1\104\4\1\1\0\1\105\1\1\6\0"+
    "\1\1\1\0\1\106\1\0\1\107\1\0\1\110\3\1"+
    "\2\0\1\111";

  private static int [] zzUnpackAction() {
    int [] result = new int[427];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\55\0\132\0\207\0\264\0\264\0\341\0\264"+
    "\0\264\0\264\0\264\0\264\0\264\0\264\0\u010e\0\u013b"+
    "\0\264\0\u0168\0\264\0\u0195\0\u01c2\0\u01ef\0\u021c\0\u0249"+
    "\0\u0276\0\u02a3\0\264\0\u02d0\0\u02fd\0\u032a\0\u0357\0\u0384"+
    "\0\u03b1\0\u03de\0\u040b\0\u0438\0\u0465\0\u0492\0\u04bf\0\55"+
    "\0\264\0\264\0\264\0\264\0\u04ec\0\u0519\0\u0546\0\55"+
    "\0\u0573\0\u05a0\0\u05cd\0\u05fa\0\u0627\0\u0654\0\u0681\0\u06ae"+
    "\0\u06db\0\u0708\0\u0735\0\u0762\0\u078f\0\u07bc\0\u07e9\0\u0816"+
    "\0\u0843\0\u0870\0\u089d\0\u08ca\0\u08f7\0\u0924\0\u0951\0\u040b"+
    "\0\264\0\u0438\0\u097e\0\264\0\55\0\u09ab\0\55\0\55"+
    "\0\u09d8\0\u0a05\0\u0a32\0\u0a5f\0\u0a8c\0\u0ab9\0\u0ae6\0\u0b13"+
    "\0\u0b40\0\u0b6d\0\u0b9a\0\u0bc7\0\u0bf4\0\u0c21\0\u0c4e\0\u0c7b"+
    "\0\u0ca8\0\u0cd5\0\u0d02\0\u0d2f\0\u0d5c\0\u0d89\0\u0db6\0\u0de3"+
    "\0\u0e10\0\u0e3d\0\u0e6a\0\u0e97\0\u0ec4\0\u0ef1\0\u0f1e\0\u0f4b"+
    "\0\u0f78\0\u0fa5\0\u0fd2\0\u0fff\0\u102c\0\u1059\0\264\0\u1086"+
    "\0\u10b3\0\u10e0\0\u110d\0\u113a\0\u1167\0\u1194\0\u11c1\0\u11ee"+
    "\0\264\0\u121b\0\u1248\0\u1275\0\u12a2\0\u12cf\0\u12fc\0\u1329"+
    "\0\u1356\0\u1383\0\u13b0\0\u13dd\0\u140a\0\u1437\0\u1464\0\u1491"+
    "\0\u14be\0\u14eb\0\u1518\0\u1545\0\u1572\0\u159f\0\u15cc\0\u15f9"+
    "\0\u1626\0\u1653\0\u1680\0\264\0\u16ad\0\u16da\0\u1707\0\u1734"+
    "\0\u1761\0\264\0\u178e\0\264\0\u17bb\0\u17e8\0\u1815\0\u1842"+
    "\0\u186f\0\u189c\0\u18c9\0\264\0\u18f6\0\u1923\0\u1950\0\u197d"+
    "\0\u19aa\0\u19d7\0\u1a04\0\u1a31\0\u1a5e\0\u1a8b\0\u1ab8\0\u1ae5"+
    "\0\u1b12\0\u1b3f\0\u1b6c\0\u1b99\0\u1bc6\0\u1bf3\0\u1c20\0\264"+
    "\0\u1c4d\0\u1c7a\0\u1ca7\0\u1cd4\0\264\0\u1d01\0\u1d2e\0\u1d5b"+
    "\0\u1d88\0\u1db5\0\264\0\u1de2\0\264\0\u1e0f\0\u1e3c\0\u1e69"+
    "\0\u1e96\0\u1ec3\0\u1ef0\0\u1f1d\0\u1f4a\0\264\0\u1f77\0\u1fa4"+
    "\0\u1fd1\0\u1ffe\0\u202b\0\u2058\0\264\0\u2085\0\264\0\u20b2"+
    "\0\u20df\0\u210c\0\u2139\0\u2166\0\u2193\0\264\0\u21c0\0\u21ed"+
    "\0\u221a\0\u2247\0\264\0\u2274\0\u22a1\0\u22ce\0\u22fb\0\u2328"+
    "\0\u2355\0\u2382\0\u23af\0\u23dc\0\u2409\0\264\0\u2436\0\u2463"+
    "\0\264\0\u2490\0\u24bd\0\u24ea\0\u2517\0\u2544\0\u2571\0\u259e"+
    "\0\u25cb\0\u25f8\0\u2625\0\u2652\0\u267f\0\u26ac\0\u26d9\0\264"+
    "\0\u2706\0\u2733\0\u2760\0\u278d\0\u27ba\0\u27e7\0\264\0\u2814"+
    "\0\264\0\u2841\0\u286e\0\u289b\0\u28c8\0\u28f5\0\u2922\0\u294f"+
    "\0\u297c\0\u29a9\0\u29d6\0\u2a03\0\u2a30\0\u2a5d\0\u2a8a\0\264"+
    "\0\u2ab7\0\u2ae4\0\264\0\u2b11\0\264\0\u2b3e\0\u2b6b\0\u2b98"+
    "\0\u2bc5\0\264\0\u2bf2\0\u2c1f\0\u2c4c\0\u2c79\0\u2ca6\0\u2cd3"+
    "\0\u2d00\0\u2d2d\0\u2d5a\0\u2d87\0\u2db4\0\264\0\u2de1\0\264"+
    "\0\u2e0e\0\u2e3b\0\u2e68\0\u2e95\0\u2ec2\0\u2eef\0\u2f1c\0\u2f49"+
    "\0\u2f76\0\u2fa3\0\u2fd0\0\u2ffd\0\264\0\u302a\0\u3057\0\u3084"+
    "\0\264\0\u30b1\0\264\0\u30de\0\u310b\0\u3138\0\u3165\0\u3192"+
    "\0\u31bf\0\u31ec\0\264\0\u3219\0\u3246\0\264\0\u3273\0\u32a0"+
    "\0\264\0\u32cd\0\u32fa\0\u3327\0\u3354\0\264\0\u3381\0\u33ae"+
    "\0\u33db\0\u3408\0\u3435\0\u3462\0\u348f\0\u34bc\0\u34e9\0\u3516"+
    "\0\u3543\0\u3570\0\u359d\0\u35ca\0\u35f7\0\u3624\0\u3651\0\u367e"+
    "\0\u36ab\0\u36d8\0\264\0\u3705\0\264\0\u3732\0\u375f\0\u378c"+
    "\0\u37b9\0\u37e6\0\u3813\0\u3840\0\u386d\0\u389a\0\u38c7\0\u38f4"+
    "\0\u3921\0\u394e\0\u397b\0\u39a8\0\u39d5\0\264\0\u3a02\0\264"+
    "\0\u3a2f\0\u3a5c\0\u3a89\0\u3ab6\0\u3ae3\0\u3b10\0\u3b3d\0\u3b6a"+
    "\0\264\0\u3b97\0\u3bc4\0\u3bf1\0\u3c1e\0\u3c4b\0\264\0\u3c78"+
    "\0\u3ca5\0\u3cd2\0\u3cff\0\u3d2c\0\u3d59\0\u3d86\0\u3db3\0\u3de0"+
    "\0\264\0\u3e0d\0\264\0\u3e3a\0\264\0\u3e67\0\u3e94\0\u3ec1"+
    "\0\u3eee\0\u3f1b\0\264";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[427];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\1\3\1\4\1\5\1\6\1\7\1\10\1\11"+
    "\1\12\1\13\1\14\1\15\1\16\1\17\1\20\1\21"+
    "\1\22\1\23\1\24\1\25\2\2\1\26\1\27\1\30"+
    "\1\31\1\32\1\33\1\34\1\35\1\36\1\37\1\40"+
    "\5\2\1\41\1\42\1\2\1\43\1\44\1\2\1\5"+
    "\1\2\1\0\1\2\1\0\2\2\15\0\10\2\1\0"+
    "\15\2\2\0\1\2\1\45\1\0\1\3\55\0\1\4"+
    "\2\0\1\46\124\0\1\2\1\0\1\47\1\0\1\2"+
    "\1\50\15\0\10\2\1\0\15\2\2\0\1\2\1\45"+
    "\17\0\1\51\54\0\1\52\54\0\1\53\57\0\1\54"+
    "\32\0\1\2\1\0\1\2\1\0\2\2\15\0\1\2"+
    "\1\55\6\2\1\0\6\2\1\56\6\2\2\0\1\2"+
    "\1\45\1\2\1\0\1\2\1\0\2\2\15\0\4\2"+
    "\1\57\3\2\1\0\15\2\2\0\1\2\1\45\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\7\2\1\60\1\0"+
    "\15\2\2\0\1\2\1\45\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\6\2\1\61\1\2\1\0\2\2\1\62"+
    "\12\2\2\0\1\2\1\45\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\4\2\1\63\1\64\2\2\1\0\5\2"+
    "\1\65\7\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\4\2\1\66\3\2\1\0\15\2"+
    "\2\0\1\2\1\45\1\2\1\0\1\2\1\0\2\2"+
    "\15\0\4\2\1\67\1\70\2\2\1\0\15\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\10\2\1\0\2\2\1\71\2\2\1\72\1\73\6\2"+
    "\2\0\1\2\1\45\1\2\1\0\1\2\1\0\2\2"+
    "\15\0\7\2\1\74\1\0\6\2\1\75\6\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\4\2\1\76\1\77\1\2\1\100\1\0\15\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\4\2\1\101\3\2\1\0\6\2\1\102\2\2\1\103"+
    "\3\2\2\0\1\2\1\45\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\4\2\1\104\3\2\1\0\15\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\4\2\1\105\1\106\2\2\1\0\1\107\14\2\2\0"+
    "\1\2\1\45\51\110\1\111\3\110\52\112\1\111\2\112"+
    "\1\113\1\0\1\113\1\0\2\113\13\0\1\114\1\0"+
    "\10\113\1\0\15\113\2\0\1\113\3\0\1\46\52\0"+
    "\1\2\1\0\1\47\1\0\2\2\15\0\10\2\1\0"+
    "\15\2\2\0\1\2\1\45\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\2\2\1\115\5\2\1\0\15\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\10\2\1\0\1\2\1\116\13\2\2\0\1\2\1\45"+
    "\1\2\1\0\1\2\1\0\2\2\15\0\1\117\7\2"+
    "\1\0\15\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\1\120\7\2\1\0\4\2\1\121"+
    "\10\2\2\0\1\2\1\45\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\10\2\1\0\2\2\1\122\12\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\1\123\6\2\1\124\1\0\2\2\1\125\12\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\3\2\1\126\4\2\1\0\15\2\2\0\1\2\1\45"+
    "\1\2\1\0\1\2\1\0\2\2\15\0\3\2\1\127"+
    "\4\2\1\0\15\2\2\0\1\2\1\45\1\2\1\0"+
    "\1\2\1\0\2\2\15\0\10\2\1\0\5\2\1\130"+
    "\7\2\2\0\1\2\1\45\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\10\2\1\0\4\2\1\131\10\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\6\2\1\132\1\2\1\0\1\2\1\133\13\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\5\2\1\134\1\2\1\135\1\0\15\2\2\0\1\2"+
    "\1\45\1\2\1\0\1\2\1\0\2\2\15\0\3\2"+
    "\1\136\4\2\1\0\12\2\1\137\2\2\2\0\1\2"+
    "\1\45\1\2\1\0\1\2\1\0\2\2\15\0\10\2"+
    "\1\0\1\140\14\2\2\0\1\2\1\45\1\2\1\0"+
    "\1\2\1\0\2\2\15\0\5\2\1\141\2\2\1\0"+
    "\5\2\1\142\7\2\2\0\1\2\1\45\1\2\1\0"+
    "\1\2\1\0\2\2\15\0\10\2\1\0\15\2\2\0"+
    "\1\143\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\10\2\1\0\1\2\1\144\13\2\2\0\1\2\1\45"+
    "\1\2\1\0\1\2\1\0\2\2\15\0\7\2\1\145"+
    "\1\0\15\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\4\2\1\146\3\2\1\0\6\2"+
    "\1\147\6\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\3\2\1\150\2\2\1\151\1\2"+
    "\1\0\5\2\1\152\7\2\2\0\1\2\1\45\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\1\2\1\153\6\2"+
    "\1\0\15\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\1\2\1\154\6\2\1\0\15\2"+
    "\2\0\1\2\1\45\1\2\1\0\1\2\1\0\2\2"+
    "\15\0\4\2\1\155\3\2\1\0\15\2\2\0\1\2"+
    "\1\45\1\2\1\0\1\2\1\0\2\2\15\0\10\2"+
    "\1\0\1\156\14\2\2\0\1\2\1\45\1\2\1\0"+
    "\1\2\1\0\2\2\15\0\10\2\1\0\1\157\14\2"+
    "\2\0\1\2\1\45\1\2\1\0\1\2\1\0\2\2"+
    "\15\0\4\2\1\160\3\2\1\0\15\2\2\0\1\2"+
    "\1\45\1\113\1\0\1\113\1\0\2\113\15\0\10\113"+
    "\1\0\15\113\2\0\1\113\1\0\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\10\2\1\0\4\2\1\161\10\2"+
    "\2\0\1\2\1\45\1\2\1\0\1\2\1\0\2\2"+
    "\15\0\10\2\1\0\6\2\1\162\6\2\2\0\1\2"+
    "\1\45\1\2\1\0\1\2\1\0\2\2\15\0\7\2"+
    "\1\163\1\0\15\2\2\0\1\2\1\45\1\2\1\0"+
    "\1\2\1\0\2\2\15\0\10\2\1\0\6\2\1\164"+
    "\6\2\2\0\1\2\1\45\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\3\2\1\165\4\2\1\0\15\2\2\0"+
    "\1\2\1\45\1\2\1\166\1\2\1\0\2\2\3\0"+
    "\1\167\11\0\10\2\1\0\15\2\2\0\1\2\1\45"+
    "\1\2\1\0\1\2\1\0\2\2\15\0\10\2\1\0"+
    "\6\2\1\170\6\2\2\0\1\2\1\45\1\2\1\0"+
    "\1\2\1\0\2\2\15\0\10\2\1\0\12\2\1\171"+
    "\2\2\2\0\1\2\1\45\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\6\2\1\172\1\2\1\0\15\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\5\2\1\173\2\2\1\0\15\2\2\0\1\2\1\45"+
    "\1\2\1\0\1\2\1\0\2\2\15\0\10\2\1\0"+
    "\7\2\1\174\5\2\2\0\1\2\1\45\1\2\1\0"+
    "\1\2\1\0\2\2\15\0\10\2\1\0\2\2\1\175"+
    "\12\2\2\0\1\2\1\45\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\7\2\1\176\1\0\15\2\2\0\1\2"+
    "\1\45\1\2\1\0\1\2\1\0\2\2\15\0\1\2"+
    "\1\177\6\2\1\0\15\2\2\0\1\2\1\45\1\2"+
    "\1\200\1\2\1\0\2\2\3\0\1\201\11\0\10\2"+
    "\1\0\15\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\10\2\1\0\1\2\1\202\13\2"+
    "\2\0\1\2\1\45\1\2\1\0\1\2\1\0\2\2"+
    "\15\0\10\2\1\0\13\2\1\203\1\2\2\0\1\2"+
    "\1\45\1\2\1\0\1\2\1\0\2\2\15\0\6\2"+
    "\1\204\1\2\1\0\15\2\2\0\1\2\1\45\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\10\2\1\0\6\2"+
    "\1\205\6\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\10\2\1\0\2\2\1\206\12\2"+
    "\2\0\1\2\1\45\1\2\1\0\1\2\1\0\2\2"+
    "\15\0\1\2\1\207\6\2\1\0\15\2\2\0\1\2"+
    "\1\45\1\2\1\0\1\2\1\0\2\2\15\0\10\2"+
    "\1\0\6\2\1\210\6\2\2\0\1\2\1\45\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\10\2\1\0\4\2"+
    "\1\211\10\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\10\2\1\0\4\2\1\212\10\2"+
    "\2\0\1\2\1\45\1\2\1\0\1\2\1\0\2\2"+
    "\15\0\3\2\1\213\4\2\1\0\15\2\2\0\1\2"+
    "\1\45\1\2\1\0\1\2\1\0\2\2\15\0\10\2"+
    "\1\0\2\2\1\214\1\2\1\215\10\2\2\0\1\2"+
    "\1\45\1\2\1\0\1\2\1\0\2\2\15\0\6\2"+
    "\1\216\1\2\1\0\15\2\2\0\1\2\1\45\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\10\2\1\0\1\217"+
    "\14\2\2\0\1\2\1\45\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\10\2\1\0\1\220\14\2\2\0\1\2"+
    "\1\45\1\2\1\0\1\2\1\0\2\2\15\0\10\2"+
    "\1\0\1\221\14\2\2\0\1\2\1\45\1\2\1\0"+
    "\1\2\1\0\2\2\15\0\10\2\1\0\1\222\14\2"+
    "\2\0\1\2\1\45\1\2\1\0\1\2\1\0\2\2"+
    "\15\0\10\2\1\0\1\2\1\223\13\2\2\0\1\2"+
    "\1\45\1\2\1\0\1\2\1\0\2\2\15\0\4\2"+
    "\1\224\3\2\1\0\15\2\2\0\1\2\1\45\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\10\2\1\0\6\2"+
    "\1\225\6\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\10\2\1\0\1\2\1\226\13\2"+
    "\2\0\1\2\1\45\1\2\1\0\1\2\1\0\2\2"+
    "\15\0\1\2\1\227\6\2\1\0\15\2\2\0\1\2"+
    "\1\45\1\2\1\230\1\2\1\0\2\2\3\0\1\231"+
    "\11\0\10\2\1\0\15\2\2\0\1\2\1\45\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\5\2\1\232\2\2"+
    "\1\0\15\2\2\0\1\2\1\45\1\0\1\166\7\0"+
    "\1\167\43\0\1\2\1\233\1\2\1\0\2\2\3\0"+
    "\1\234\11\0\10\2\1\0\1\2\1\235\13\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\10\2\1\0\6\2\1\236\6\2\2\0\1\2\1\45"+
    "\1\2\1\0\1\2\1\0\2\2\15\0\1\237\7\2"+
    "\1\0\15\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\10\2\1\0\1\240\14\2\2\0"+
    "\1\2\1\45\1\2\1\241\1\2\1\0\2\2\3\0"+
    "\1\242\11\0\10\2\1\0\15\2\2\0\1\2\1\45"+
    "\1\2\1\243\1\2\1\0\2\2\3\0\1\244\11\0"+
    "\10\2\1\0\15\2\2\0\1\2\1\45\1\2\1\0"+
    "\1\2\1\0\2\2\15\0\10\2\1\0\2\2\1\245"+
    "\12\2\2\0\1\2\1\45\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\6\2\1\246\1\2\1\0\15\2\2\0"+
    "\1\2\1\45\1\0\1\200\7\0\1\201\43\0\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\10\2\1\0\2\2"+
    "\1\247\12\2\2\0\1\2\1\45\1\2\1\250\1\2"+
    "\1\0\2\2\15\0\10\2\1\0\15\2\2\0\1\2"+
    "\1\251\1\2\1\0\1\2\1\0\2\2\15\0\10\2"+
    "\1\0\1\2\1\252\13\2\2\0\1\2\1\45\1\2"+
    "\1\253\1\2\1\0\2\2\3\0\1\254\11\0\10\2"+
    "\1\0\15\2\2\0\1\2\1\45\1\2\1\255\1\2"+
    "\1\0\2\2\3\0\1\256\11\0\10\2\1\0\15\2"+
    "\2\0\1\2\1\45\1\2\1\0\1\2\1\0\2\2"+
    "\15\0\10\2\1\0\2\2\1\257\12\2\2\0\1\2"+
    "\1\45\1\2\1\0\1\2\1\0\2\2\15\0\6\2"+
    "\1\260\1\2\1\0\15\2\2\0\1\2\1\45\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\10\2\1\0\6\2"+
    "\1\261\6\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\10\2\1\0\6\2\1\262\6\2"+
    "\2\0\1\2\1\45\1\2\1\0\1\2\1\0\2\2"+
    "\15\0\10\2\1\0\6\2\1\263\6\2\2\0\1\2"+
    "\1\45\1\2\1\0\1\2\1\0\2\2\15\0\5\2"+
    "\1\264\2\2\1\0\15\2\2\0\1\2\1\45\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\5\2\1\265\2\2"+
    "\1\0\15\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\10\2\1\0\2\2\1\266\12\2"+
    "\2\0\1\2\1\45\1\2\1\0\1\2\1\0\2\2"+
    "\15\0\1\2\1\267\6\2\1\0\15\2\2\0\1\2"+
    "\1\45\1\2\1\0\1\2\1\0\2\2\15\0\1\270"+
    "\7\2\1\0\15\2\2\0\1\2\1\45\1\2\1\0"+
    "\1\2\1\0\2\2\15\0\10\2\1\0\6\2\1\271"+
    "\6\2\2\0\1\2\1\45\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\4\2\1\272\3\2\1\0\15\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\10\2\1\0\6\2\1\273\6\2\2\0\1\2\1\45"+
    "\1\2\1\0\1\2\1\0\2\2\15\0\7\2\1\274"+
    "\1\0\15\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\6\2\1\275\1\2\1\0\15\2"+
    "\2\0\1\2\1\45\1\2\1\0\1\2\1\0\2\2"+
    "\15\0\10\2\1\0\2\2\1\276\12\2\2\0\1\2"+
    "\1\45\1\2\1\0\1\2\1\0\2\2\15\0\10\2"+
    "\1\0\12\2\1\277\2\2\2\0\1\2\1\45\1\0"+
    "\1\230\7\0\1\231\44\0\1\231\10\0\1\300\42\0"+
    "\1\2\1\0\1\2\1\0\2\2\15\0\10\2\1\0"+
    "\1\301\14\2\2\0\1\2\1\45\1\0\1\233\7\0"+
    "\1\234\43\0\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\10\2\1\0\3\2\1\302\11\2\2\0\1\2\1\45"+
    "\1\2\1\0\1\2\1\0\2\2\15\0\7\2\1\303"+
    "\1\0\15\2\2\0\1\2\1\45\1\2\1\304\1\2"+
    "\1\0\2\2\3\0\1\305\11\0\10\2\1\0\15\2"+
    "\2\0\1\2\1\45\1\2\1\0\1\2\1\0\1\306"+
    "\1\2\15\0\10\2\1\0\15\2\2\0\1\2\1\45"+
    "\1\0\1\241\7\0\1\242\44\0\1\243\7\0\1\244"+
    "\43\0\1\2\1\0\1\2\1\0\2\2\15\0\10\2"+
    "\1\0\1\2\1\307\13\2\2\0\1\2\1\45\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\10\2\1\0\7\2"+
    "\1\310\5\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\7\2\1\311\1\0\15\2\2\0"+
    "\1\2\1\45\1\0\1\250\52\0\1\312\1\113\1\0"+
    "\1\113\1\0\2\113\13\0\1\114\1\0\10\113\1\0"+
    "\15\113\2\0\1\113\1\313\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\10\2\1\0\1\314\14\2\2\0\1\2"+
    "\1\45\1\0\1\253\7\0\1\254\44\0\1\255\7\0"+
    "\1\256\44\0\1\256\10\0\1\315\42\0\1\2\1\0"+
    "\1\2\1\0\2\2\15\0\1\2\1\316\6\2\1\0"+
    "\15\2\2\0\1\2\1\45\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\10\2\1\0\2\2\1\317\12\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\10\2\1\0\1\2\1\320\13\2\2\0\1\2\1\45"+
    "\1\2\1\0\1\2\1\0\2\2\15\0\1\321\7\2"+
    "\1\0\15\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\6\2\1\322\1\2\1\0\15\2"+
    "\2\0\1\2\1\45\1\2\1\0\1\2\1\0\2\2"+
    "\15\0\1\2\1\323\6\2\1\0\15\2\2\0\1\2"+
    "\1\45\1\2\1\0\1\2\1\0\2\2\15\0\10\2"+
    "\1\0\2\2\1\324\12\2\2\0\1\2\1\45\1\2"+
    "\1\325\1\2\1\0\2\2\3\0\1\326\11\0\10\2"+
    "\1\0\15\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\6\2\1\327\1\2\1\0\15\2"+
    "\2\0\1\2\1\45\1\2\1\330\1\2\1\0\2\2"+
    "\15\0\10\2\1\0\15\2\2\0\1\2\1\331\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\5\2\1\332\2\2"+
    "\1\0\15\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\10\2\1\0\10\2\1\333\4\2"+
    "\2\0\1\2\1\45\1\2\1\334\1\2\1\0\2\2"+
    "\3\0\1\335\11\0\10\2\1\0\15\2\2\0\1\2"+
    "\1\45\1\2\1\336\1\2\1\0\2\2\3\0\1\337"+
    "\11\0\10\2\1\0\15\2\2\0\1\2\1\45\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\1\340\7\2\1\0"+
    "\15\2\2\0\1\2\1\45\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\4\2\1\341\3\2\1\0\15\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\10\2\1\0\5\2\1\342\7\2\2\0\1\2\1\45"+
    "\1\2\1\0\1\2\1\0\2\2\15\0\1\2\1\343"+
    "\6\2\1\0\15\2\2\0\1\2\1\45\1\2\1\0"+
    "\1\2\1\0\2\2\15\0\5\2\1\344\2\2\1\0"+
    "\15\2\2\0\1\2\1\45\1\2\1\345\1\2\1\0"+
    "\2\2\3\0\1\346\11\0\10\2\1\0\15\2\2\0"+
    "\1\2\1\45\1\0\1\304\7\0\1\305\43\0\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\6\2\1\347\1\2"+
    "\1\0\15\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\1\350\1\2\15\0\10\2\1\0\15\2\2\0"+
    "\1\2\1\45\1\2\1\351\1\2\1\0\1\352\1\2"+
    "\3\0\1\353\11\0\10\2\1\0\15\2\2\0\1\2"+
    "\1\45\1\2\1\0\1\2\1\0\2\2\15\0\1\2"+
    "\1\354\6\2\1\0\15\2\2\0\1\2\1\45\54\0"+
    "\1\313\1\2\1\0\1\2\1\0\2\2\15\0\5\2"+
    "\1\355\2\2\1\0\15\2\2\0\1\2\1\45\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\4\2\1\356\3\2"+
    "\1\0\15\2\2\0\1\2\1\45\1\2\1\357\1\2"+
    "\1\0\2\2\15\0\10\2\1\0\15\2\2\0\1\2"+
    "\1\360\1\2\1\0\1\2\1\0\2\2\15\0\10\2"+
    "\1\0\1\2\1\361\13\2\2\0\1\2\1\45\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\1\2\1\362\6\2"+
    "\1\0\15\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\10\2\1\0\2\2\1\363\12\2"+
    "\2\0\1\2\1\45\1\2\1\0\1\2\1\0\2\2"+
    "\15\0\6\2\1\364\1\2\1\0\15\2\2\0\1\2"+
    "\1\45\1\2\1\365\1\2\1\0\2\2\3\0\1\366"+
    "\11\0\10\2\1\0\15\2\2\0\1\2\1\45\1\0"+
    "\1\325\7\0\1\326\43\0\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\10\2\1\0\7\2\1\367\5\2\2\0"+
    "\1\2\1\45\1\0\1\330\52\0\1\370\1\113\1\0"+
    "\1\113\1\0\2\113\13\0\1\114\1\0\10\113\1\0"+
    "\15\113\2\0\1\113\1\371\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\6\2\1\372\1\2\1\0\15\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\1\2\1\373\6\2\1\0\15\2\2\0\1\2\1\45"+
    "\1\0\1\334\7\0\1\335\44\0\1\336\7\0\1\337"+
    "\43\0\1\2\1\0\1\2\1\0\2\2\15\0\5\2"+
    "\1\374\2\2\1\0\15\2\2\0\1\2\1\45\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\7\2\1\375\1\0"+
    "\15\2\2\0\1\2\1\45\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\10\2\1\0\2\2\1\376\12\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\10\2\1\0\14\2\1\377\2\0\1\2\1\45\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\10\2\1\0\4\2"+
    "\1\u0100\10\2\2\0\1\2\1\45\1\0\1\345\7\0"+
    "\1\346\43\0\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\5\2\1\u0101\2\2\1\0\15\2\2\0\1\2\1\45"+
    "\1\2\1\0\1\2\1\0\2\2\15\0\10\2\1\0"+
    "\10\2\1\u0102\4\2\2\0\1\2\1\45\1\0\1\351"+
    "\7\0\1\353\43\0\1\2\1\0\1\2\1\0\2\2"+
    "\15\0\10\2\1\0\1\u0103\14\2\2\0\1\2\1\45"+
    "\1\2\1\0\1\2\1\0\2\2\15\0\6\2\1\u0104"+
    "\1\2\1\0\15\2\2\0\1\2\1\45\1\2\1\0"+
    "\1\2\1\0\2\2\15\0\10\2\1\0\2\2\1\u0105"+
    "\12\2\2\0\1\2\1\45\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\6\2\1\u0106\1\2\1\0\15\2\2\0"+
    "\1\2\1\45\1\0\1\357\52\0\1\u0107\1\113\1\0"+
    "\1\113\1\0\2\113\13\0\1\114\1\0\10\113\1\0"+
    "\15\113\2\0\1\113\1\u0108\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\1\2\1\u0109\6\2\1\0\15\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\6\2\1\u010a\1\2\1\0\15\2\2\0\1\2\1\45"+
    "\1\2\1\u010b\1\2\1\0\2\2\3\0\1\u010c\11\0"+
    "\10\2\1\0\15\2\2\0\1\2\1\45\1\2\1\0"+
    "\1\2\1\0\2\2\15\0\10\2\1\0\1\2\1\u010d"+
    "\13\2\2\0\1\2\1\45\1\0\1\365\7\0\1\366"+
    "\43\0\1\2\1\u010e\1\2\1\0\2\2\3\0\1\u010f"+
    "\11\0\10\2\1\0\15\2\2\0\1\2\1\45\54\0"+
    "\1\371\1\2\1\u0110\1\2\1\0\2\2\3\0\1\u0111"+
    "\11\0\10\2\1\0\15\2\2\0\1\2\1\45\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\6\2\1\u0112\1\2"+
    "\1\0\15\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\6\2\1\u0113\1\2\1\0\15\2"+
    "\2\0\1\2\1\45\1\2\1\u0114\1\2\1\0\1\u0115"+
    "\1\2\15\0\10\2\1\0\15\2\2\0\1\2\1\u0116"+
    "\1\2\1\0\1\2\1\0\2\2\15\0\10\2\1\0"+
    "\6\2\1\u0117\6\2\2\0\1\2\1\45\1\2\1\0"+
    "\1\2\1\0\2\2\15\0\10\2\1\0\6\2\1\u0118"+
    "\6\2\2\0\1\2\1\45\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\10\2\1\0\6\2\1\u0119\6\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\3\2\1\u011a\4\2\1\0\15\2\2\0\1\2\1\45"+
    "\1\2\1\0\1\2\1\0\2\2\15\0\1\2\1\u011b"+
    "\6\2\1\0\15\2\2\0\1\2\1\45\1\2\1\0"+
    "\1\2\1\0\2\2\15\0\10\2\1\0\6\2\1\u011c"+
    "\6\2\2\0\1\2\1\45\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\10\2\1\0\7\2\1\u011d\5\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\10\2\1\0\6\2\1\u011e\6\2\2\0\1\2\1\45"+
    "\1\2\1\u011f\1\2\1\0\2\2\3\0\1\u0120\11\0"+
    "\10\2\1\0\15\2\2\0\1\2\1\45\54\0\1\u0108"+
    "\1\2\1\0\1\2\1\0\2\2\15\0\6\2\1\u0121"+
    "\1\2\1\0\15\2\2\0\1\2\1\45\1\2\1\0"+
    "\1\2\1\0\2\2\15\0\10\2\1\0\7\2\1\u0122"+
    "\5\2\2\0\1\2\1\45\1\0\1\u010b\7\0\1\u010c"+
    "\44\0\1\u010c\10\0\1\u0123\42\0\1\2\1\u0124\1\2"+
    "\1\0\2\2\3\0\1\u0125\11\0\10\2\1\0\15\2"+
    "\2\0\1\2\1\45\1\0\1\u010e\7\0\1\u010f\44\0"+
    "\1\u0110\7\0\1\u0111\43\0\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\10\2\1\0\7\2\1\u0126\5\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\10\2\1\0\2\2\1\u0127\12\2\2\0\1\2\1\45"+
    "\1\0\1\u0114\52\0\1\u0128\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\4\2\1\u0129\3\2\1\0\15\2\2\0"+
    "\1\2\1\45\1\113\1\0\1\113\1\0\2\113\13\0"+
    "\1\114\1\0\10\113\1\0\15\113\2\0\1\113\1\u012a"+
    "\1\2\1\u012b\1\2\1\0\2\2\15\0\10\2\1\0"+
    "\15\2\2\0\1\2\1\u012c\1\2\1\0\1\2\1\0"+
    "\1\u012d\1\2\15\0\10\2\1\0\15\2\2\0\1\2"+
    "\1\45\1\2\1\u012e\1\2\1\0\1\u012f\1\2\15\0"+
    "\10\2\1\0\15\2\2\0\1\2\1\u0130\1\2\1\0"+
    "\1\2\1\0\2\2\15\0\10\2\1\0\6\2\1\u0131"+
    "\6\2\2\0\1\2\1\45\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\10\2\1\0\2\2\1\u0132\12\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\6\2\1\u0133\1\2\1\0\15\2\2\0\1\2\1\45"+
    "\1\2\1\u0134\1\2\1\0\1\u0135\1\2\3\0\1\u0136"+
    "\11\0\10\2\1\0\15\2\2\0\1\2\1\45\1\2"+
    "\1\u0137\1\2\1\0\2\2\3\0\1\u0138\11\0\10\2"+
    "\1\0\15\2\2\0\1\2\1\45\1\0\1\u011f\7\0"+
    "\1\u0120\43\0\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\10\2\1\0\7\2\1\u0139\5\2\2\0\1\2\1\45"+
    "\1\2\1\u013a\1\2\1\0\1\u013b\1\2\15\0\10\2"+
    "\1\0\15\2\2\0\1\2\1\u013c\1\0\1\u0124\7\0"+
    "\1\u0125\43\0\1\2\1\u013d\1\2\1\0\1\u013e\1\2"+
    "\15\0\10\2\1\0\15\2\2\0\1\2\1\u013f\1\2"+
    "\1\u0140\1\2\1\0\1\u0141\1\2\15\0\10\2\1\0"+
    "\15\2\2\0\1\2\1\u0142\54\0\1\u012a\1\2\1\0"+
    "\1\2\1\0\2\2\15\0\7\2\1\u0143\1\0\15\2"+
    "\2\0\1\2\1\45\1\0\1\u012b\52\0\1\u0144\1\113"+
    "\1\0\1\113\1\0\2\113\13\0\1\114\1\0\10\113"+
    "\1\0\15\113\2\0\1\113\1\u0145\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\10\2\1\0\1\2\1\u0146\13\2"+
    "\2\0\1\2\1\45\1\0\1\u012e\52\0\1\u0147\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\10\2\1\0\5\2"+
    "\1\u0148\7\2\2\0\1\2\1\45\1\113\1\0\1\113"+
    "\1\0\2\113\13\0\1\114\1\0\10\113\1\0\15\113"+
    "\2\0\1\113\1\u0149\1\2\1\u014a\1\2\1\0\2\2"+
    "\3\0\1\u014b\11\0\10\2\1\0\15\2\2\0\1\2"+
    "\1\45\1\2\1\0\1\2\1\0\2\2\15\0\10\2"+
    "\1\0\11\2\1\u014c\3\2\2\0\1\2\1\45\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\10\2\1\0\7\2"+
    "\1\u014d\5\2\2\0\1\2\1\45\1\0\1\u0134\7\0"+
    "\1\u0136\43\0\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\5\2\1\u014e\2\2\1\0\12\2\1\u014f\2\2\2\0"+
    "\1\2\1\45\1\0\1\u0137\7\0\1\u0138\43\0\1\2"+
    "\1\0\1\2\1\0\1\u0150\1\2\15\0\10\2\1\0"+
    "\15\2\2\0\1\2\1\45\1\0\1\u013a\52\0\1\u0151"+
    "\1\2\1\0\1\2\1\0\2\2\15\0\10\2\1\0"+
    "\1\2\1\u0152\13\2\2\0\1\2\1\45\1\113\1\0"+
    "\1\113\1\0\2\113\13\0\1\114\1\0\10\113\1\0"+
    "\15\113\2\0\1\113\1\u0153\1\0\1\u013d\52\0\1\u0154"+
    "\1\2\1\0\1\2\1\0\2\2\15\0\10\2\1\0"+
    "\1\2\1\u0155\13\2\2\0\1\2\1\45\1\113\1\0"+
    "\1\113\1\0\2\113\13\0\1\114\1\0\10\113\1\0"+
    "\15\113\2\0\1\113\1\u0156\1\0\1\u0140\52\0\1\u0157"+
    "\1\2\1\0\1\2\1\0\2\2\15\0\4\2\1\u0158"+
    "\3\2\1\0\15\2\2\0\1\2\1\45\1\113\1\0"+
    "\1\113\1\0\2\113\13\0\1\114\1\0\10\113\1\0"+
    "\15\113\2\0\1\113\1\u0159\1\2\1\0\1\2\1\0"+
    "\1\u015a\1\2\15\0\10\2\1\0\15\2\2\0\1\2"+
    "\1\45\54\0\1\u0145\1\2\1\0\1\2\1\0\2\2"+
    "\15\0\10\2\1\0\3\2\1\u015b\11\2\2\0\1\2"+
    "\1\45\54\0\1\u0149\1\2\1\0\1\2\1\0\2\2"+
    "\15\0\7\2\1\u015c\1\0\15\2\2\0\1\2\1\45"+
    "\1\0\1\u014a\7\0\1\u014b\43\0\1\2\1\u015d\1\2"+
    "\1\0\2\2\3\0\1\u015e\11\0\10\2\1\0\15\2"+
    "\2\0\1\2\1\45\1\2\1\0\1\2\1\0\2\2"+
    "\15\0\10\2\1\0\2\2\1\u015f\12\2\2\0\1\2"+
    "\1\45\1\2\1\0\1\2\1\0\2\2\15\0\10\2"+
    "\1\0\13\2\1\u0160\1\2\2\0\1\2\1\45\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\10\2\1\0\6\2"+
    "\1\u0161\6\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\1\2\1\u0162\6\2\1\0\15\2"+
    "\2\0\1\2\1\45\54\0\1\u0153\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\1\2\1\u0163\6\2\1\0\15\2"+
    "\2\0\1\2\1\45\54\0\1\u0156\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\1\2\1\u0164\6\2\1\0\15\2"+
    "\2\0\1\2\1\45\54\0\1\u0159\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\7\2\1\u0165\1\0\15\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\10\2\1\0\1\2\1\u0166\13\2\2\0\1\2\1\45"+
    "\1\2\1\0\1\2\1\0\2\2\15\0\5\2\1\u0167"+
    "\2\2\1\0\15\2\2\0\1\2\1\45\1\2\1\0"+
    "\1\2\1\0\2\2\15\0\1\2\1\u0168\6\2\1\0"+
    "\15\2\2\0\1\2\1\45\1\0\1\u015d\7\0\1\u015e"+
    "\43\0\1\2\1\0\1\2\1\0\2\2\15\0\10\2"+
    "\1\0\11\2\1\u0169\3\2\2\0\1\2\1\45\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\10\2\1\0\2\2"+
    "\1\u016a\12\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\10\2\1\0\13\2\1\u016b\1\2"+
    "\2\0\1\2\1\45\1\2\1\0\1\2\1\0\2\2"+
    "\15\0\6\2\1\u016c\1\2\1\0\15\2\2\0\1\2"+
    "\1\45\1\2\1\0\1\2\1\0\2\2\15\0\10\2"+
    "\1\0\12\2\1\u016d\2\2\2\0\1\2\1\45\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\10\2\1\0\12\2"+
    "\1\u016e\2\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\1\u016f\1\2\15\0\10\2\1\0\15\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\10\2\1\0\6\2\1\u0170\6\2\2\0\1\2\1\45"+
    "\1\2\1\0\1\2\1\0\2\2\15\0\10\2\1\0"+
    "\4\2\1\u0171\10\2\2\0\1\2\1\45\1\2\1\u0172"+
    "\1\2\1\0\2\2\3\0\1\u0173\11\0\10\2\1\0"+
    "\15\2\2\0\1\2\1\45\1\2\1\u0174\1\2\1\0"+
    "\2\2\3\0\1\u0175\11\0\10\2\1\0\15\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\10\2\1\0\6\2\1\u0176\6\2\2\0\1\2\1\45"+
    "\1\2\1\0\1\2\1\0\2\2\15\0\4\2\1\u0177"+
    "\3\2\1\0\15\2\2\0\1\2\1\45\1\2\1\0"+
    "\1\2\1\0\2\2\15\0\10\2\1\0\1\2\1\u0178"+
    "\13\2\2\0\1\2\1\45\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\10\2\1\0\1\u0179\14\2\2\0\1\2"+
    "\1\45\1\2\1\0\1\2\1\0\2\2\15\0\10\2"+
    "\1\0\1\u017a\14\2\2\0\1\2\1\45\1\2\1\0"+
    "\1\2\1\0\2\2\15\0\10\2\1\0\1\2\1\u017b"+
    "\13\2\2\0\1\2\1\45\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\10\2\1\0\1\u017c\14\2\2\0\1\2"+
    "\1\45\1\2\1\0\1\2\1\0\2\2\15\0\10\2"+
    "\1\0\6\2\1\u017d\6\2\2\0\1\2\1\45\1\0"+
    "\1\u0172\7\0\1\u0173\44\0\1\u0174\7\0\1\u0175\43\0"+
    "\1\2\1\0\1\2\1\0\2\2\15\0\7\2\1\u017e"+
    "\1\0\15\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\7\2\1\u017f\1\0\15\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\10\2\1\0\2\2\1\u0180\12\2\2\0\1\2\1\45"+
    "\1\2\1\0\1\2\1\0\2\2\15\0\1\2\1\u0181"+
    "\6\2\1\0\15\2\2\0\1\2\1\45\1\2\1\0"+
    "\1\2\1\0\2\2\15\0\1\2\1\u0182\6\2\1\0"+
    "\15\2\2\0\1\2\1\45\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\10\2\1\0\6\2\1\u0183\6\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\10\2\1\0\13\2\1\u0184\1\2\2\0\1\2\1\45"+
    "\1\2\1\u0185\1\2\1\0\2\2\3\0\1\u0186\11\0"+
    "\10\2\1\0\15\2\2\0\1\2\1\45\1\2\1\u0187"+
    "\1\2\1\0\2\2\3\0\1\u0188\11\0\10\2\1\0"+
    "\15\2\2\0\1\2\1\45\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\10\2\1\0\6\2\1\u0189\6\2\2\0"+
    "\1\2\1\45\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\7\2\1\u018a\1\0\15\2\2\0\1\2\1\45\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\6\2\1\u018b\1\2"+
    "\1\0\15\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\6\2\1\u018c\1\2\1\0\15\2"+
    "\2\0\1\2\1\45\1\2\1\0\1\2\1\0\2\2"+
    "\15\0\10\2\1\0\1\u018d\14\2\2\0\1\2\1\45"+
    "\1\2\1\u018e\1\2\1\0\2\2\15\0\10\2\1\0"+
    "\15\2\2\0\1\2\1\u018f\1\0\1\u0185\7\0\1\u0186"+
    "\44\0\1\u0187\7\0\1\u0188\43\0\1\2\1\u0190\1\2"+
    "\1\0\2\2\3\0\1\u0191\11\0\10\2\1\0\15\2"+
    "\2\0\1\2\1\45\1\2\1\0\1\2\1\0\2\2"+
    "\15\0\10\2\1\0\5\2\1\u0192\7\2\2\0\1\2"+
    "\1\45\1\2\1\0\1\2\1\0\2\2\15\0\10\2"+
    "\1\0\7\2\1\u0193\5\2\2\0\1\2\1\45\1\2"+
    "\1\0\1\2\1\0\2\2\15\0\10\2\1\0\7\2"+
    "\1\u0194\5\2\2\0\1\2\1\45\1\2\1\0\1\2"+
    "\1\0\2\2\15\0\10\2\1\0\13\2\1\u0195\1\2"+
    "\2\0\1\2\1\45\1\0\1\u018e\52\0\1\u0196\1\113"+
    "\1\0\1\113\1\0\2\113\13\0\1\114\1\0\10\113"+
    "\1\0\15\113\2\0\1\113\1\u0197\1\0\1\u0190\7\0"+
    "\1\u0191\43\0\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\10\2\1\0\4\2\1\u0198\10\2\2\0\1\2\1\45"+
    "\1\2\1\u0199\1\2\1\0\2\2\15\0\10\2\1\0"+
    "\15\2\2\0\1\2\1\u019a\1\2\1\u019b\1\2\1\0"+
    "\2\2\15\0\10\2\1\0\15\2\2\0\1\2\1\u019c"+
    "\1\2\1\u019d\1\2\1\0\2\2\15\0\10\2\1\0"+
    "\15\2\2\0\1\2\1\u019e\54\0\1\u0197\1\2\1\0"+
    "\1\2\1\0\2\2\15\0\10\2\1\0\2\2\1\u019f"+
    "\12\2\2\0\1\2\1\45\1\0\1\u0199\52\0\1\u01a0"+
    "\1\113\1\0\1\113\1\0\2\113\13\0\1\114\1\0"+
    "\10\113\1\0\15\113\2\0\1\113\1\u01a1\1\0\1\u019b"+
    "\52\0\1\u01a2\1\113\1\0\1\113\1\0\2\113\13\0"+
    "\1\114\1\0\10\113\1\0\15\113\2\0\1\113\1\u01a3"+
    "\1\0\1\u019d\52\0\1\u01a4\1\113\1\0\1\113\1\0"+
    "\2\113\13\0\1\114\1\0\10\113\1\0\15\113\2\0"+
    "\1\113\1\u01a5\1\2\1\0\1\2\1\0\2\2\15\0"+
    "\1\2\1\u01a6\6\2\1\0\15\2\2\0\1\2\1\45"+
    "\54\0\1\u01a1\54\0\1\u01a3\54\0\1\u01a5\1\2\1\0"+
    "\1\2\1\0\2\2\15\0\4\2\1\u01a7\3\2\1\0"+
    "\15\2\2\0\1\2\1\45\1\2\1\0\1\2\1\0"+
    "\2\2\15\0\6\2\1\u01a8\1\2\1\0\15\2\2\0"+
    "\1\2\1\45\1\2\1\u01a9\1\2\1\0\2\2\3\0"+
    "\1\u01aa\11\0\10\2\1\0\15\2\2\0\1\2\1\45"+
    "\1\0\1\u01a9\7\0\1\u01aa\44\0\1\u01aa\10\0\1\u01ab"+
    "\42\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[16200];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\3\1\2\11\1\1\7\11\2\1\1\11\1\1"+
    "\1\11\7\1\1\11\11\1\1\0\3\1\4\11\33\1"+
    "\1\0\1\11\1\0\1\1\1\11\51\1\1\0\1\11"+
    "\10\1\1\0\1\11\26\1\2\0\1\1\1\0\1\11"+
    "\4\1\1\0\1\11\1\0\1\11\3\1\2\0\1\1"+
    "\1\0\1\11\2\0\21\1\1\11\3\1\1\0\1\11"+
    "\4\1\1\0\1\11\1\1\1\11\7\1\1\0\1\11"+
    "\1\1\2\0\2\1\1\0\1\11\1\0\1\11\5\1"+
    "\1\0\1\11\2\1\1\0\1\1\1\11\3\1\2\0"+
    "\4\1\1\0\1\11\1\1\1\0\1\11\15\1\1\0"+
    "\1\11\2\1\2\0\1\1\1\0\1\11\1\0\1\11"+
    "\2\1\1\0\1\1\1\0\10\1\1\0\1\11\2\1"+
    "\1\11\1\0\1\11\2\1\1\0\1\1\1\11\2\0"+
    "\1\1\1\0\1\1\1\0\3\1\1\0\1\1\1\11"+
    "\1\0\1\11\1\1\1\0\1\1\2\0\1\1\2\0"+
    "\1\1\1\0\1\1\1\0\1\11\1\1\1\0\1\1"+
    "\1\11\1\0\1\11\5\1\1\0\1\1\1\11\1\0"+
    "\1\1\1\11\1\0\1\1\1\11\3\1\1\0\1\11"+
    "\23\1\1\0\1\11\1\0\1\11\17\1\1\0\1\11"+
    "\1\0\1\11\5\1\3\0\1\11\4\1\1\0\1\11"+
    "\1\1\6\0\1\1\1\0\1\11\1\0\1\11\1\0"+
    "\1\11\3\1\2\0\1\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[427];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */

  private Symbol sym(int sym) {
    return new Symbol(sym);
  }

  private Symbol sym(int sym, Object val) {
    return new Symbol(sym, val);
  }

  int isName; 
  NameType name;
  FuncName fname; 
  Ntest ntest;
  AxisType at;
  int len;
  String literal;
  Double number; 
  int colonPosition;

  /* public void report_error(String message, Object info) {
	//throw new XPathParseException("Syntax error during parsing");
  }

  public void report_fatal_error(String message, Object info) throws XPathParseException{
	throw new XPathParseException("Syntax error during parsing: "+ message);
  }

  public void syntax_error(Symbol cur_token) {
	
  }
  
  public void unrecovered_syntax_error(Symbol cur_token) throws XPathParseException{
	throw new XPathParseException("XPath Syntax error: "+cur_token);
  }*/



  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  Yylex(java.io.Reader in) {
  	isName = 1;
	colonPosition = -1;
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  Yylex(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 130) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException, XPathParseException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 53: 
          { isName = 1; 
			 	yypushback(1);
				//yyparser.yylval.fname.i = FuncName.CONTAINS;
				fname = new FuncName();
				fname.i = FuncName.CONTAINS;
				return sym(FNAME,fname);
          }
        case 74: break;
        case 65: 
          { isName = 1; 
			 	yypushback(1);
				//yyparser.yylval.fname.i = FuncName.STRING_LENGTH;
				fname = new FuncName();
				fname.i = FuncName.STRING_LENGTH;
				return sym(FNAME,fname);
          }
        case 75: break;
        case 51: 
          { isName = 1; 
			 	yypushback(1);
				//yyparser.yylval.fname.i =  FuncName.POSITION;
				fname = new FuncName();
				fname.i = FuncName.POSITION;
				return sym(FNAME,fname);
          }
        case 76: break;
        case 25: 
          { if (isName == 0) {	
		 isName = 1 ;
		 return sym(OR);
	      } else {
		 isName = 0;
		 name = new NameType();
		 name.qname = "or";
		 return sym(NAME,name);
	      }
          }
        case 77: break;
        case 23: 
          { isName = 1 ; return sym(NE);
          }
        case 78: break;
        case 30: 
          { if (isName == 0) {
		isName = 1 ;
		 return sym(AND);
	      } else {
		 isName = 0;
		 name = new NameType();
		 name.qname = "add";
		 return sym(NAME,name);
	      }
          }
        case 79: break;
        case 12: 
          { isName = 1 ; /*System.out.println( "[ returned");*/ return sym(LB);
          }
        case 80: break;
        case 72: 
          { isName = 1;
				at = new AxisType();
				at.i = AxisType.DESCENDANT_OR_SELF;
				return sym(AXISNAME,at);
          }
        case 81: break;
        case 11: 
          { isName = 0 ; return sym(RP);
          }
        case 82: break;
        case 58: 
          { isName =0;
				at = new AxisType();
				at.i = AxisType.NAMESPACE;
				return sym(AXISNAME,at);
          }
        case 83: break;
        case 35: 
          { isName = 1; 
			 	yypushback(1);
				fname = new FuncName();
				fname.i = FuncName.LAST;
				return sym(FNAME,fname);
          }
        case 84: break;
        case 17: 
          { if (isName ==0){
		isName = 1;
		//System.out.println("returned a MULT");
		return  sym(MULT);
	}
	 else {
		isName = 0;
		name = new NameType();
		name.qname = "*";
		return sym(NAME,name);
	 }
          }
        case 85: break;
        case 63: 
          { isName = 1; 
			 	yypushback(1);
				//yyparser.yylval.fname.i = FuncName.STARTS_WITH;
				fname = new FuncName();
				fname.i = FuncName.STARTS_WITH;
				return sym(FNAME,fname);
          }
        case 86: break;
        case 8: 
          { isName = 1 ; return sym(AT);
          }
        case 87: break;
        case 6: 
          { isName = 0 ; /*System.out.println(". returned ");*/ return sym(DOT);
          }
        case 88: break;
        case 27: 
          { isName = 0;
				len = yytext().length();
				name = new NameType();
                               if (!XMLChar.isNCNameStartChar(yytext().charAt(0)))
					throw new XPathParseException("Invalid char in name token:  "+yytext()+ "@position 0");
				
				for(int i=1;i<len-2;i++){
					if (!XMLChar.isNCNameChar(yytext().charAt(i)))
						throw new XPathParseException("Invalid char in name token:  "+yytext()+ "@position "+i);
				}

				name.prefix = yytext().substring(0,len-2);
				name.localname = "*";
				//System.out.println("NAME "+name+ " returned");
				return sym(NAME,name);
          }
        case 89: break;
        case 34: 
          { isName = 1; 
			 	yypushback(1);
				//yyparser.yylval.fname.i = FuncName.LANG;
				fname = new FuncName();
				fname.i = FuncName.LANG;
				return sym(FNAME,fname);
          }
        case 90: break;
        case 68: 
          { isName = 1; 
			 	yypushback(1);
				//yyparser.yylval.fname.i = FuncName.SUBSTRING_BEFORE;
				fname = new FuncName();
				fname.i = FuncName.SUBSTRING_BEFORE;
				return sym(FNAME,fname);
          }
        case 91: break;
        case 33: 
          { isName = 1; 
			 	yypushback(1);
				//yyparser.yylval.fname.i =  FuncName.NAME;
				fname = new FuncName();
				fname.i = FuncName.NAME;
				return sym(FNAME,fname);
          }
        case 92: break;
        case 37: 
          { isName = 0;
				ntest = new Ntest();
				ntest.i = Ntest.NODE;
				ntest.arg = null;
				return sym(NTEST,ntest);
          }
        case 93: break;
        case 42: 
          { isName = 1; 
			 	yypushback(1);
				//yyparser.yylval.fname.i = FuncName.FALSE;
				fname = new FuncName();
				fname.i = FuncName.FALSE;
				return sym(FNAME,fname);
          }
        case 94: break;
        case 59: 
          { isName = 1; 
			 	yypushback(1);
				//yyparser.yylval.fname.i =  FuncName.LOCAL_NAME;
				fname = new FuncName();
				fname.i = FuncName.LOCAL_NAME;
				return sym(FNAME,fname);
          }
        case 95: break;
        case 45: 
          { isName = 1; 
			 	yypushback(1);
				//yyparser.yylval.fname.i =  FuncName.STRING;
				fname = new FuncName();
				fname.i = FuncName.STRING;
				return sym(FNAME,fname);
          }
        case 96: break;
        case 14: 
          { isName = 1 ; return sym(GT);
          }
        case 97: break;
        case 52: 
          { isName = 0;
				ntest = new Ntest();
				ntest.i = Ntest.COMMENT;
				ntest.arg =  null;
				return sym(NTEST,ntest);
          }
        case 98: break;
        case 50: 
          { isName = 1; 
			 	yypushback(1);
				//yyparser.yylval.fname.i = FuncName.BOOLEAN;
				fname = new FuncName();
				fname.i = FuncName.BOOLEAN;
				return sym(FNAME,fname);
          }
        case 99: break;
        case 1: 
          { isName = 0;
				name = new NameType();
				//name.qname = new String(yytext());
				//System.out.println("returned a NAME ==>" + yytext());
				//if (yytext().charAt(0) =='-'){
				//    throw new XPathParseException("Invalid char in name token:"+yytext());
				//}
				
				name.qname = new String(yytext());
				if (!XMLChar.isNCNameStartChar(name.qname.charAt(0)))
					throw new XPathParseException("Invalid char in name token:  "+yytext()+ "@position 0");
				
				for(int i=1;i<name.qname.length();i++){
					if (!XMLChar.isNCNameChar(name.qname.charAt(i)) 
						&& name.qname.charAt(i)!=':' )
						throw new XPathParseException("Invalid char in name token:  "+yytext()+ "@position "+i);
					if (name.qname.charAt(i)==':'){
						colonPosition = i;
					}
				}
		
				if (colonPosition != -1){
					name.prefix = yytext().substring(0,colonPosition);
					name.localname = yytext().substring(colonPosition+1);				
				}
				
				colonPosition = -1;
				return sym(NAME,name);
          }
        case 100: break;
        case 16: 
          { isName = 1 ; return sym(EQ);
          }
        case 101: break;
        case 4: 
          { throw new XPathParseException("Invalid char in XPath Expression");
          }
        case 102: break;
        case 57: 
          { isName = 1;
				at = new AxisType();
				at.i = AxisType.ATTRIBUTE;
				return sym(AXISNAME,at);
          }
        case 103: break;
        case 3: 
          { isName = 0;
				number = new Double(yytext());
				//System.out.println("number returned ==> "+ Double.parseDouble(yytext()));
				return sym(NUMBER,number);
          }
        case 104: break;
        case 43: 
          { isName = 1; 
			 	yypushback(1);
				//yyparser.yylval.fname.i = FuncName.FLOOR;
				fname = new FuncName();
				fname.i = FuncName.FLOOR;
				return sym(FNAME,fname);
          }
        case 105: break;
        case 32: 
          { isName = 1; 
			 	yypushback(1);
				//yyparser.yylval.fname.i = FuncName.SUM;
				fname = new FuncName();
				fname.i = FuncName.SUM;
				return sym(FNAME,fname);
          }
        case 106: break;
        case 29: 
          { if (isName == 0) {
		  isName = 1 ;
		 return sym(MOD);
	      } else {
		 isName = 0;
		 name = new NameType();
		 name.qname = "mod";
		 //System.out.println("returned a NAME "+yytext());
		 return sym(NAME,name);
	      }
          }
        case 107: break;
        case 28: 
          { if (isName == 0 ) {
		  isName = 1 ;
		 return sym(DIV);
	      } else {
		 isName = 0;
		 name = new NameType();
		 name.qname = "div";
		 return sym(NAME,name);
	      }
          }
        case 108: break;
        case 26: 
          { isName = 0;
				len = yytext().length();
				literal = yytext().substring(1, len-1);
				return sym(LITERAL,literal);
          }
        case 109: break;
        case 18: 
          { isName = 1 ; 
	 //System.out.println("SLASH returned ");
	 return sym(SLASH);
          }
        case 110: break;
        case 15: 
          { isName = 1 ; return sym(LT);
          }
        case 111: break;
        case 24: 
          { isName = 1 ; 
	 //System.out.println("DSLASH returned "); 
	 return sym(DSLASH);
          }
        case 112: break;
        case 73: 
          { isName = 0;
						ntest = new Ntest();
						ntest.i = Ntest.PROCESSING_INSTRUCTION;
						ntest.arg = null;
						return sym(NTEST,ntest);
          }
        case 113: break;
        case 13: 
          { isName = 0 ; return sym(RB);
          }
        case 114: break;
        case 67: 
          { isName = 1; 
			 	yypushback(1);
				//yyparser.yylval.fname.i = FuncName.SUBSTRING_AFTER;
				fname = new FuncName();
				fname.i = FuncName.SUBSTRING_AFTER;
				return sym(FNAME,fname);
          }
        case 115: break;
        case 36: 
          { isName = 1; 
			 	yypushback(1);
				//yyparser.yylval.fname.i = FuncName.TRUE;
				fname = new FuncName();
				fname.i = FuncName.TRUE;
				return sym(FNAME,fname);
          }
        case 116: break;
        case 49: 
          { isName = 1; 
			 	yypushback(1);
				//yyparser.yylval.fname.i = FuncName.CEILING;
				fname = new FuncName();
				fname.i = FuncName.CEILING;
				return sym(FNAME,fname);
          }
        case 117: break;
        case 20: 
          { isName = 0 ; return sym(DDOT);
          }
        case 118: break;
        case 70: 
          { isName = 1;
				at = new AxisType();
				at.i = AxisType.PRECEDING_SIBLING;
				return sym(AXISNAME,at);
          }
        case 119: break;
        case 64: 
          { isName = 1; 
			 	yypushback(1);
				//yyparser.yylval.fname.i =  FuncName.NAMESPACE_URI;
				fname = new FuncName();
				fname.i = FuncName.NAMESPACE_URI;
				return sym(FNAME,fname);
          }
        case 120: break;
        case 10: 
          { isName = 1 ; return sym(LP);
          }
        case 121: break;
        case 7: 
          { isName = 1 ; return sym(ADD);
          }
        case 122: break;
        case 56: 
          { isName = 1; 
			 	yypushback(1);
				//yyparser.yylval.fname.i = FuncName.TRANSLATE;
				fname = new FuncName();
				fname.i = FuncName.TRANSLATE;
				return sym(FNAME,fname);
          }
        case 123: break;
        case 41: 
          { isName = 1; 
			 	yypushback(1);
				//yyparser.yylval.fname.i =  FuncName.COUNT;
				fname = new FuncName();
				fname.i = FuncName.COUNT;
				return sym(FNAME,fname);
          }
        case 124: break;
        case 60: 
          { isName = 1;
				at = new AxisType();
				at.i = AxisType.PRECEDING;
				return sym(AXISNAME,at);
          }
        case 125: break;
        case 9: 
          { isName = 1 ; return sym(COMMA);
          }
        case 126: break;
        case 46: 
          { isName = 1; 
			 	yypushback(1);
				//yyparser.yylval.fname.i = FuncName.CONCAT;
				fname = new FuncName();
				fname.i = FuncName.CONCAT;
				return sym(FNAME,fname);
          }
        case 127: break;
        case 54: 
          { isName = 1;
				at = new AxisType();
				at.i = AxisType.ANCESTOR;
				return sym(AXISNAME,at);
          }
        case 128: break;
        case 47: 
          { isName = 1;
				at = new AxisType();
				at.i = AxisType.CHILD;
				return sym(AXISNAME,at);
          }
        case 129: break;
        case 19: 
          { isName = 1 ; return sym(UNION) ;
          }
        case 130: break;
        case 71: 
          { isName = 1;
				at = new AxisType();
				at.i = AxisType.FOLLOWING_SIBLING;
				return sym(AXISNAME,at);
          }
        case 131: break;
        case 5: 
          { isName = 1 ; return sym(SUB);
          }
        case 132: break;
        case 31: 
          { isName = 1; 
			 	yypushback(1);
				//yyparser.yylval.fname.i = FuncName.NOT;
				fname = new FuncName();
				fname.i = FuncName.NOT;
				return sym(FNAME,fname);
          }
        case 133: break;
        case 44: 
          { isName = 1; 
			 	yypushback(1);
				//yyparser.yylval.fname.i = FuncName.NUMBER;
				fname = new FuncName();
				fname.i = FuncName.NUMBER;
				return sym(FNAME,fname);
          }
        case 134: break;
        case 40: 
          { isName = 0;
				ntest = new Ntest();
				ntest.i = Ntest.TEXT;
				ntest.arg = null;
				return sym(NTEST,ntest);
          }
        case 135: break;
        case 61: 
          { isName = 1;
				at = new AxisType();
				at.i = AxisType.FOLLOWING;
				return sym(AXISNAME,at);
          }
        case 136: break;
        case 21: 
          { isName = 1 ; return sym(GE);
          }
        case 137: break;
        case 48: 
          { isName = 1;
				at = new AxisType();
				at.i = AxisType.PARENT;
				return sym(AXISNAME,at);
          }
        case 138: break;
        case 2: 
          { /* eat white space */
          }
        case 139: break;
        case 69: 
          { isName = 1;
				at = new AxisType();
				at.i = AxisType.ANCESTOR_OR_SELF;
				return sym(AXISNAME,at);
          }
        case 140: break;
        case 66: 
          { isName =1; 
			 	yypushback(1);
				//yyparser.yylval.fname.i = FuncName.NORMALIZE_SPACE;
				fname = new FuncName();
				fname.i = FuncName.NORMALIZE_SPACE;
				return sym(FNAME,fname);
          }
        case 141: break;
        case 38: 
          { isName = 1; 
			 	yypushback(1);
				//yyparser.yylval.fname.i = FuncName.ROUND;
				fname = new FuncName();
				fname.i = FuncName.ROUND;
				return sym(FNAME,fname);
          }
        case 142: break;
        case 39: 
          { isName = 1;
				at = new AxisType();
				at.i = AxisType.SELF;
				//System.out.println("SELF:: returned");
				return sym(AXISNAME,at);
          }
        case 143: break;
        case 55: 
          { isName = 1; 
			 	yypushback(1);
				//yyparser.yylval.fname.i = FuncName.SUBSTRING;
				fname = new FuncName();
				fname.i = FuncName.SUBSTRING;
				return sym(FNAME,fname);
          }
        case 144: break;
        case 62: 
          { isName = 1;
				at = new AxisType();
				at.i = AxisType.DESCENDANT;
				return sym(AXISNAME,at);
          }
        case 145: break;
        case 22: 
          { isName = 1 ; return sym(LE);
          }
        case 146: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
              { return new java_cup.runtime.Symbol(sym.EOF); }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
