/*************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: lcubootVersion.c,v 1.1 2004/10/18 15:38:51 bjeram Exp $" 
*
* lcubootVersion.c
*
* who        when       what
* ---------  ---------- ---------------------------------------------------
* S.Sandrock 18.02.1995 created
*/

/*************************************************************************
*   NAME
*       lcubootVersion,
*       lcubootSysVersion - Extract/Print System versions
* 
*   SYNOPSIS
*       void lcubootVersion(void)
*       void lcubootSysVersion(void)
* 
*   DESCRIPTION
*	lcubootVersion - Print the version of the module 'lcuboot' to stdout
*           and logged to the logging system
*
*	lcubootSysVersion - Print the system versions
*               the Boot ROM Version and Creation Date
*               the VxWorks version
*               the BSP version & date
*               the CPU Model
*               the available RAM in MB
*           the information is displayed on the stdout  
*           and logged to the logging system.
*
*   EXAMPLES 
*       on MVME167 with VLTSW Release MAR2002:
*       lte50->lcubootSysVersion
*       System Versions: 
*           vxWorks: 5.4.2 
*               CPU: Proc #0 (Motorola MVME167 - 16MB)
*               ROM:          Compiled Older than MAR2002
*               BSP: 1.2/0    Compiled 2001-Dec-11T17:01
*
*       on MVME2600 with VLTSW Release MAR2002 and updated Boot ROM:
*       lte66->lcubootSysVersion
*       System Versions: 
*           vxWorks: 5.4.2
*               CPU: Proc #0 (Motorola MVME2600 - MPC 604e - 64MB)
*               ROM: 1.0/1    Compiled 2002-Apr-23T09:54
*               BSP: 1.2/1    Compiled 2002-Apr-23T10:01
*
*--------------------------------------------------------------------------
*/

#include "lcuboot.h"
#include "lccVxwArch.h"
#include "sysLib.h"

void lcubootVersion(void)
{
    printf("@(#) lcuboot $Revision: 1.1 $\n");
    lcubootLogMsg("@(#) lcuboot $Revision: 1.1 $\n",0,0,0,0,0,0);
}

extern char *vxWorksVersion,*creationDate;
void lcubootSysVersion ( void )
{
    int         memSize;
    FUNCPTR     fctAddr;

    char        bspCreationDate[32];
    char        mm[4]="Jan";
    int         dd=0,yy=1970,hr=0,mn=0;

    char       *bootromVersion = "",
               *bootromCreation="Older than MAR2002";

    char        txt1[100],txt2[100];
    char        rom[80],bsp[80],cpu[80];

    sscanf(creationDate,"%s %d %d, %d:%d",mm,&dd,&yy,&hr,&mn);
    mm[3] = 0;
    sprintf(bspCreationDate,"%4d-%3s-%02d %02d:%02d",yy,mm,dd,hr,mn);

    memSize = (int)sysPhysMemTop() / (1024*1024);
    if (lccFindFunctionEntry("romBootRevision",&fctAddr) == OK)
	bootromVersion = (char *)(*fctAddr)();
    if (lccFindFunctionEntry("romBootCreation",&fctAddr) == OK)
	bootromCreation = (char *)(*fctAddr)();
    if (sscanf(bootromCreation,"%d-%c%c%c-%d %d:%d",&yy,mm,mm+1,mm+2,&dd,&hr,&mn) != 7)
	{
	bootromCreation="Older than MAR2002";
	sprintf(rom,"%s",bootromCreation);
	}
    else if (strlen(bootromVersion))
	sprintf(rom,"%-8s Compiled %s",bootromVersion,bootromCreation);
    else 
	sprintf(rom,"%s",bootromCreation);
	
    sprintf(cpu,"Proc #%1d  %s - %dMB",sysProcNumGet(),sysModel(),memSize);
    sprintf(bsp,"%-8s Compiled %s",sysBspRev(),bspCreationDate);
    printf("\n\tSystem : vxWorks %s\n\tCPU %s\n\tROM %s\n\tBSP %s\n\n",
	   vxWorksVersion,cpu,rom,bsp);

    sprintf(txt1,"System  : vxWorks %s - CPU Proc #%1d (%s - %dMB)",
	    vxWorksVersion,sysProcNumGet(),sysModel(),memSize);
    if (strlen(bootromVersion))
	sprintf(txt2,"Versions: ROM %s Compiled %s - BSP %s Compiled %s",
		bootromVersion,bootromCreation,sysBspRev(),bspCreationDate);
    else
	sprintf(txt2,"Versions: ROM %s - BSP %s Compiled %s",
		bootromCreation,sysBspRev(),bspCreationDate);

    if (lccFindFunctionEntry("logData",&fctAddr) != OK) return;
    (*fctAddr)("lcc",101,txt1);
    (*fctAddr)("lcc",101,txt2);
}


