#ifndef LCUBOOT_PRIVATE_H
#define LCUBOOT_PRIVATE_H
/******************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: lcubootPrivate.h,v 1.1 2004/10/18 15:38:51 bjeram Exp $" 
*
* lcubootPrivate.h   -	Private data and functions of module lcuboot
*
* who        when       what
* ---------  ---------- ---------------------------------------------------
* S.Sandrock 23.04.1995 New
* imunoz     11.10.1996 RETURN_ABORT now logs to lcubootLogFile
*/

/*
 * System header files, necessary for common functions
 */

#include "lcuboot.h"

#include "loadLib.h"
#include "symLib.h"
#include "shellLib.h"
#include "bootLib.h"
#include "envLib.h"
#include "logLib.h"

#include "lccVxwArch.h"

/*
 * Limits and Defaults:
 * NOTE: propagate any changes to the stated man-pages!
 */
#define DEV_LIST_SIZE	64	/* maximum number of devices in the LCU      */
				/* used to allocate lcubootAutoDevList       */
				/* --> man-page lcubootAutoDrv CAUTIONS      */

#define DRV_ARG2	25		/* default for lcubootAutoDrvArg2    */
					/* usually the number of channels    */
					/* --> lcubootAutoDrv VARIABLES      */

#define DRV_ARG3	100		/* default for lcubootAutoDrvArg3    */
					/* usually the timeout in ticks      */
					/* --> lcubootAutoDrv VARIABLES      */

#define DRV_FUNC_SUFFIX	"Drv"		/* default lcubootAutoDrvFuncSuffix  */
					/* suffix of driver install function */
					/* --> lcubootAutoDrv VARIABLES      */

#define DEV_FUNC_SUFFIX	"DevCreate"	/* default lcubootAutoDevFuncSuffix  */
					/* suffix of device install function */
					/* --> lcubootAutoDrv VARIABLES      */


/*
 * Return from function due to abnormal condition, with script-abort:
 */
#define RETURN_ABORT(msgStr, argStr)\
    return\
	lcubootLogMsg("lcuboot: %s: %s: %d=0x%x=\"%s\"\n",\
	       (int)msgStr, (int)argStr, errno,errno,(int)strerror(errno), 0),\
	lcubootLogMsg("--- SCRIPT ABORTED ---\n",0,0,0,0,0,0),\
	shellScriptAbort(),\
	errno


extern int lcubootProbeCount;

/*
 * Device List:
 */
typedef struct 
{
    const char *devName;
    void *probeAddr;
    int lccArg1, lccArg2, lccArg3;
} lcubootDEV_LIST;

extern lcubootDEV_LIST lcubootAutoDevList[DEV_LIST_SIZE];
extern int lcubootAutoDevListCount;


extern int lcubootProbeAddress(void * address);

/*
 * lcubootErrorLoad.c
 */
typedef struct errorIdxEntry {
    int errNumber;
    char severity;
    long offset;
} errorIdxEntry;


struct errorIdx {
    char *modName;
    errorIdxEntry  *idxEntry;
    char *txtEntry;
    int errCount;
};

int readIDXFile (int fd, errorIdxEntry **erridx, int *count); 
int readERRORSFile (int fd, char **txt);

#endif  /* !LCUBOOT_PRIVATE_H */

