#ifndef LCUBOOT_H
#define LCUBOOT_H
/******************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: lcuboot.h,v 1.1 2004/10/18 15:38:51 bjeram Exp $" 
*
* who       when      what
* --------  --------  ----------------------------------------------
* bgustafs 2000-12-20 added function lcubootAutoLoadNoAbort
* bgustafs  05/07/99  made it C++ compliant
* S.Sandrock 23.04.1995 New
*/

#ifdef __cplusplus
extern "C" {
#endif

/*
 * System header files, necessary for common functions
 */

#include "vxWorks.h"
#include "vxLib.h"
#include "iosLib.h"
#include "stdioLib.h"
#include "string.h"
#include "stdlib.h"

#define lcubootOK	OK
#define lcubootERROR	ERROR

/*
 * Automatic installation functions, for use form the VxWorks shell
 */
void lcubootVersion    ( void );
void lcubootSysVersion ( void );

/*
 * lcubootAutoGen.c:
 */
extern int lcubootAutoProbe(char *probeAddr0,
			   char *probeAddr1,
			   char *probeAddr2,
			   char *probeAddr3,
			   char *probeAddr4,
			   char *probeAddr5,
			   char *probeAddr6,
			   char *probeAddr7,
			   char *probeAddr8,
			   char *probeAddr9);

extern int lcubootAutoLoad(BOOL cond, const char *moduleName, 
			   int reldFlag, int symFlag);

extern int lcubootAutoLoadNoAbort(BOOL cond, const char *moduleName, 
				  int reldFlag, int symFlag);

extern int lcubootAutoExec(BOOL cond, const char *funcName, 
			  int arg1, int arg2, int arg3, int arg4, int arg5,
			  int arg6, int arg7, int arg8);

extern int lcubootAutoSpawn(BOOL cond, const char *taskName, 
			    int priority, int options, int stackSize,
			    const char *funcName, 
			    int arg1, int arg2, int arg3, int arg4);

extern int lcubootAutoCd(BOOL cond,
			 const char *searchPath,
			 const char *fileName);

extern int lcubootAutoCdBoot(BOOL cond, const char *scriptName);

/*
 * lcubootAutoDrv.c:
 */
extern int lcubootAutoDrvArg2;		/* usually the number of channels  */
extern int lcubootAutoDrvArg3;		/* usually the timeout in ticks    */
extern const char lcubootAutoDrvFuncSuffix[16];	/* driver install function */
extern const char lcubootAutoDevFuncSuffix[16];	/* device install function */

extern int lcubootAutoDevRegister(const char *devName, 
				  int addrSpace, void *busAddr,
				  int arg1, int arg2, int arg3);

extern int lcubootAutoDevInit(const char *funcName, int numDevices);

extern int lcubootAutoDrvInstall(const char *moduleName, 
				int numDevices, 
				const char *drvFuncName, 
				const char *devFuncName, 
				int drvArg1, int drvArg2, int drvArg3, 
				int drvArg4, int drvArg5, int drvArg6);

extern int lcubootAutoDevCreate(const char *devName, 
			       int arg1, int arg2, int arg3, int arg4,int arg5,
			       int arg6, int arg7, int arg8, int arg9);

extern int lcubootAutoDevCheck(const char *devBaseName, int nominalCount);

/*
 * lcubootAutoLcc.c:
 */
extern int lcubootAutoLccRegisterDevs(void);

/*
 * lcubootAutoEnv.c:
 */
extern int lcubootAutoEnvInit(void);

/*
 * lcubootFile.c:
 */
extern int lcubootFileOpen(const char *searchPath,
			   const char *fileName, 
			   int openMode);
/*
 * lcubootError.c
 */
enum lcubootErrorERRORS { lcubootError_MOD_NOT_FOUND=-1,
                          lcubootError_ERR_NOT_FOUND=-2,
                          lcubootError_INTERNAL = -3};
	
int lcubootErrorLoad(const char *modName);
int lcubootErrorGetFormat(const char *modName, 
			  int errNumber, 
			  char *severity, 
			  char *format);

/*
 * lcubootLogInit.c
 */
STATUS lcubootLogInit(void);
STATUS lcubootLogFinish(void);
STATUS lcubootLogMsg(const char *fmt, int arg1, int arg2, int arg3, 
		     int arg4, int arg5, int arg6);
/*
 * lcubootVxWorks.c
 */
int lcubootNfsMount(char *host, char *fileSystem, char *localName);

#ifdef __cplusplus
}
#endif

#endif  /* !LCUBOOT_H */
