/* i8237.h - i8237 device Header Module */

/* Copyright 1984-1998 Wind River Systems, Inc. */
/* Copyright 1996,1997,1998 Motorola, Inc. */

/*
modification history
--------------------
01a,29Oct97,rbb  created by Motorola.
*/

/*
DESCRIPTION
This header file contains definitions for all of the registers
in the 8237 device, including bit definitions, and structure
'overlays' for the registers.
*/

#ifndef INCi8237h
#define INCi8237h

#ifdef __cplusplus
extern "C" {
#endif

/* defines */

#define I8237_DMA1_OFFSET	0x000	/* channel 0 - 3 */
#define I8237_DMA2_OFFSET	0x0C0	/* channel 4 - 7 */
#define I8237_PAGE_OFFSET	0x080	/* page registers */
#define I8237_HIGH_OFFSET	0x480	/* high-page registers */

/* command/status register bit definitions */

#define I8237_CS_COM_DACKAL	(1<<7)	/* DACK# assert level */
#define I8237_CS_COM_DREQSAL	(1<<6)	/* DREQ sense assert level */
#define I8237_CS_COM_GAP	(1<<4)	/* group arbitration priority */
#define I8237_CS_COM_CGE	(1<<2)	/* channel group enable */

#define I8237_CS_STAT_CH0REQ	(1<<4)	/* channel 0 (4) DREQ status */
#define I8237_CS_STAT_CH1REQ	(1<<5)	/* channel 1 (5) DREQ status */
#define I8237_CS_STAT_CH2REQ	(1<<6)	/* channel 2 (6) DREQ status */
#define I8237_CS_STAT_CH3REQ	(1<<7)	/* channel 3 (7) DREQ status */

#define I8237_CS_STAT_CH0TC	(1<<0)	/* channel 0 (4) TC status */
#define I8237_CS_STAT_CH1TC	(1<<1)	/* channel 1 (5) TC status */
#define I8237_CS_STAT_CH2TC	(1<<2)	/* channel 2 (6) TC status */
#define I8237_CS_STAT_CH3TC	(1<<3)	/* channel 3 (7) TC status */

/* mode register bit definitions */

#define I8237_MODE_TM_DEMAND	(0<<6)	/* transfer mode - demand */
#define I8237_MODE_TM_SINGLE	(1<<6)	/* transfer mode - single */
#define I8237_MODE_TM_BLOCK	(2<<6)	/* transfer mode - block */
#define I8237_MODE_TM_CASCADE	(3<<6)	/* transfer mode - cascade */
#define I8237_MODE_ADDRDEC	(1<<5)	/* address increment/decrement select */
#define I8237_MODE_AUTOINIT	(1<<4)	/* autoinitialize enable */
#define I8237_MODE_TT_VERIFY	(0<<2)	/* transfer type - verify */
#define I8237_MODE_TT_WRITE	(1<<2)	/* transfer type - write */
#define I8237_MODE_TT_READ	(2<<2)	/* transfer type - read */
#define I8237_MODE_TT_ILLEGAL	(3<<2)	/* transfer type - illegal */
#define I8237_MODE_CH0SEL	(0<<0)	/* channel 0 (4) select */
#define I8237_MODE_CH1SEL	(1<<0)	/* channel 1 (5) select */
#define I8237_MODE_CH2SEL	(2<<0)	/* channel 2 (6) select */
#define I8237_MODE_CH3SEL	(3<<0)	/* channel 3 (7) select */

/* request register bit definitions */

#define I8237_REQ_CHSERREQ	(1<<2)	/* channel service request */
#define I8237_REQ_CH0SEL	(0<<0)	/* channel 0 (4) select */
#define I8237_REQ_CH1SEL	(1<<0)	/* channel 1 (5) select */
#define I8237_REQ_CH2SEL	(2<<0)	/* channel 2 (6) select */
#define I8237_REQ_CH3SEL	(3<<0)	/* channel 3 (7) select */

/* write single mask bit register bit definitions */

#define I8237_WSMB_CHMASKSEL	(1<<2)	/* channel mask select */
#define I8237_WSMB_CH0SEL	(0<<0)	/* channel 0 (4) select */
#define I8237_WSMB_CH1SEL	(1<<0)	/* channel 1 (5) select */
#define I8237_WSMB_CH2SEL	(2<<0)	/* channel 2 (6) select */
#define I8237_WSMB_CH3SEL	(3<<0)	/* channel 3 (7) select */

/* read/write all mask bits register bit definitions */

#define I8237_RWAMB_CH0MASK	(1<<0)	/* channel 0 (4) mask */
#define I8237_RWAMB_CH1MASK	(1<<1)	/* channel 1 (5) mask */
#define I8237_RWAMB_CH2MASK	(1<<2)	/* channel 2 (6) mask */
#define I8237_RWAMB_CH3MASK	(1<<3)	/* channel 3 (7) mask */

/* typedefs */

typedef struct i8237_legacy_bac 
    {
    UCHAR bca;			/* base/current address */
    UCHAR bcc;			/* base/current count */
    } I8237_LEGACY_BAC;

typedef struct i8237_eisa_bac 
    {
    UCHAR bca;			/* base/current address */
    UCHAR r0;
    UCHAR bcc;			/* base/current count */
    UCHAR r1;
    } I8237_EISA_BAC;

typedef struct i8237_legacy 
    {
    I8237_LEGACY_BAC bac[4];	/* base/current address/count */
    UCHAR cs;			/* command/status */
    UCHAR wr;			/* write request */
    UCHAR wsmb;			/* write single mask bit */
    UCHAR wm;			/* write mode */
    UCHAR cbp;			/* clear byte pointer */
    UCHAR mc;			/* master clear */
    UCHAR cm;			/* clear mask */
    UCHAR rwamb;			/* read/write all mask bits */
    } I8237_LEGACY;

typedef struct i8237_eisa 
    {
    I8237_EISA_BAC bac[4];	/* base/current address/count */
    UCHAR cs;			/* command/status */
    UCHAR r0;
    UCHAR wr;			/* write request */
    UCHAR r1;
    UCHAR wsmb;			/* write single mask bit */
    UCHAR r2;
    UCHAR wm;			/* write mode */
    UCHAR r3;
    UCHAR cbp;			/* clear byte pointer */
    UCHAR r4;
    UCHAR mc;			/* master clear */
    UCHAR r5;
    UCHAR cm;			/* clear mask */
    UCHAR r6;
    UCHAR rwamb;			/* read/write all mask bits */
    UCHAR r7;
    } I8237_EISA;

typedef struct i8237_legacy I8237_DMA1;
typedef struct i8237_eisa I8237_DMA2;

typedef struct i8237_page 
    {
    UCHAR p_r80;		/* page register reserved */
    UCHAR p_ch2;		/* channel 2 page */
    UCHAR p_ch3;		/* channel 3 page */
    UCHAR p_ch1;		/* channel 1 page */

    UCHAR p_r84;		/* page register reserved */
    UCHAR p_r85;		/* page register reserved */
    UCHAR p_r86;		/* page register reserved */
    UCHAR p_ch0;		/* channel 0 page */
    UCHAR p_r88;		/* page register reserved */
    UCHAR p_ch6;		/* channel 6 page */
    UCHAR p_ch7;		/* channel 7 page */
    UCHAR p_ch5;		/* channel 5 page */
    } I8237_PAGE;

typedef struct i8237_highpage 
    {
    UCHAR p_r00;		/* 0x00 - reserved */
    UCHAR p_ch2;		/* 0x01 - channel 2 page */
    UCHAR p_ch3;		/* 0x02 - channel 3 page */
    UCHAR p_ch1;		/* 0x03 - channel 1 page */

    UCHAR p_r04;		/* 0x04 - reserved */
    UCHAR p_r05;		/* 0x05 - reserved */
    UCHAR p_r06;		/* 0x06 - reserved */
    UCHAR p_ch0;		/* 0x07 - channel 0 page */

    UCHAR p_r08;		/* 0x08 - reserved */
    UCHAR p_ch6;		/* 0x09 - channel 6 page */
    UCHAR p_ch7;		/* 0x0A - channel 7 page */
    UCHAR p_ch5;		/* 0x0B - channel 5 page */
    } I8237_HIGHPAGE;

#ifdef __cplusplus
}
#endif

#endif  /* INCi8237h */
