/* fdcDrv.h - Floppy Disk Controller (FDC) Input/Output Header Module */

/* Copyright 1984-1998 Wind River Systems, Inc. */
/* Copyright 1996,1997,1998 Motorola, Inc. */

/*
modification history
--------------------
01a,29Oct97,rb   created by Motorola.
*/

/*
DESCRIPTION
This file contains structures used by the floppy driver to maintain
information about the disk drive and for the command packet used to
transfer requests to the disk.
*/

#ifndef INCfdcDrvh
#define INCfdcDrvh

#ifdef __cplusplus
extern "C" {
#endif

#define AESSIZE	32	/* error status data buffer size in bytes */

#ifdef MBX860
#  undef FDC_ENHANCED		/* enhanced floppy disk controller */
#else
#  define FDC_ENHANCED          /* enhanced floppy disk controller */
#endif
#define FDC_DMAALIGN	0x10000	/* DMA alignment (modulus of) */
#define FDC_NDRIVES	4	/* number of supported drives */

/* controller dependent error codes */

#define FDC_ERROR_READ		0x01	/* error during read operation */
#define FDC_ERROR_WRITE		0x02	/* error during write operation */
#define FDC_ERROR_ILLDREQ	0x03	/* illegal data request */
#define FDC_ERROR_DATACOUNT	0x04	/* data count (expected != actual) */
#define FDC_ERROR_FORMAT	0x05	/* format failed */
#define FDC_ERROR_SEEK		0x06	/* seek failed */
#define FDC_ERROR_CLEARRESET	0x07	/* clear reset status failed */

/*
 * timeout definitions
 *
 * these timeout definitions are hardware specific, and must be measured
 * (or known), the access time definition basically states the maximum
 * time it would take to access the FIFO, its granularity is in
 * micro-seconds, which would suffice for most products, but just in case
 * the definition is "ifdef"'d
 */

#define	FDC_TIMEOUT		2000000	/* time out in US */

#define	FDC_ACCESSTIME		1	/* access time to FIFO in US */

#define FDC_TIMEOUTCOUNT	(FDC_TIMEOUT/FDC_ACCESSTIME)

/* command identifiers */

#define FDC_READOP	0	/* read operation */
#define FDC_WRITOP	1	/* write operation */
#define FDC_FRMTOP	2	/* format operation */
#define FDC_CHCKOP	3	/* check operation */

/* typedefs
 *
 * position calculation structure template
 */

typedef struct fdc_pos 
    {
    UINT lsector;	/* logical sector number */
    USHORT cylndrno;	/* cylinder number */
    UCHAR headno;	/* head number */
    UCHAR sectorno;	/* sector number */
    } FDC_POS;

/* command/result data structure template */

typedef struct fdc_crdata 
    {
    FDC_COMMAND c_data;	/* command data */
    FDC_RESULT r_data;	/* result data */
    } FDC_CRDATA;

/* driver command packet */

typedef struct fdc_cmdpckt 
    {
    UINT command;		/* command identifier */
    UINT status;			/* status (error code) */
    UINT memaddr;		/* memory address */
    UINT blcknum;		/* block number */
    UINT nblcks;			/* number of blocks to transfer */
    UINT tdflg;			/* track/disk flag, format operations */
    UINT e_count;		/* expected data count */
    UINT a_count;		/* actual data count */
    UINT aescount;		/* additional error status count */
    UCHAR aesdata[AESSIZE];	/* additional error status data buffer */
    } FDC_CMDPCKT;

/* floppy device/disk type structure template */

typedef struct fdc_type {
    UINT numberofheads;	/* number of heads (sides) */
    UINT numberoftracks;	/* number of tracks */
    UINT sectorstrack;	/* sectors (blocks) per track */
    UINT sectorsize;	/* sector (block) size in bytes */
    UINT ratestep;	/* step rate */
    UINT ratedata;	/* data rate */
    UINT gaprw;		/* read/write sector gap */
    UINT gapformat;	/* format gap */
    } FDC_TYPE;

/* driver device data template */

typedef struct fdc_dev 
    {
    BLK_DEV fdcBlockDev;/* block device descriptor (vxWorks - must be first) */
    FDC_TYPE fdcType;	/* floppy disk/device type */
    UINT driveNumber;	/* drive/device number */
    UINT blockSize;	/* logical block size in bytes */
    UINT blockOffset;	/* logical block offset from zero of start */
    UINT blockTotal;	/* number of logical blocks from offset */
    UINT dmaBuffer;	/* DMA buffer address */
    SEM_ID intSemId;	/* interrupt to task level semaphore */
    int sysClkRate;	/* system clock rate */
    } FDC_DEV;

/* interrupt arguments data template */

typedef struct fdc_iargs 
    {
    FDC_DEV *pDev;		/* device descriptor pointer */
    FDC_CMDPCKT *pCmd;		/* command packet pointer */
    FDC *pFdc;			/* FDC registers pointer */
    FDC_CRDATA *cr_data_p;	/* command/result data pointer */
    } FDC_IARGS;

#ifdef __cplusplus
}
#endif

#endif  /* INCfdcDrvh */
