/* fdc.h - Floppy Disk Controller (FDC) Header File */

/* Copyright 1984-1998 Wind River Systems, Inc. */
/* Copyright 1996,1997,1998 Motorola, Inc. */

/*
modification history
--------------------
01a,29Oct97,rbb  created by Motorola.
*/

/*
DESCRIPTION
This file contains definitions for the bit fields of the FDC registers
in ISA IO space, and for the structures that define the floppy disk
commands.
*/


#ifndef INCxxxXh
#define INCxxxXh

#ifdef __cplusplus
extern "C" {
#endif

/* defines
 *
 * SRA - status register A bit definitions
 */

#define FDC_SRA_PS2_IP		(1<<7)	/* IRQ6 signal state status */
#define FDC_SRA_PS2_DRV2	(1<<6)	/* DRV2* disk interface input status */
#define FDC_SRA_PS2_STEP	(1<<5)	/* STEP disk interface output status */
#define FDC_SRA_PS2_TRK0	(1<<4)	/* TRK0* disk interface output status */
#define FDC_SRA_PS2_HDSEL	(1<<3)	/* HDSEL disk interface output status */
#define FDC_SRA_PS2_INDX	(1<<2)	/* INDEX* disk interface input status */
#define FDC_SRA_PS2_WP		(1<<1)	/* WP* disk interface input status */
#define FDC_SRA_PS2_DIR		(1<<0)	/* DIR disk interface output status */

#define FDC_SRA_M30_IP		(1<<7)	/* IRQ6 signal state status */
#define FDC_SRA_M30_FDRQ	(1<<6)	/* DMA request signal state status */
#define FDC_SRA_M30_STEP	(1<<5)	/* STEP disk interface output status */
#define FDC_SRA_M30_TRK0	(1<<4)	/* TRK0 disk interface output status */
#define FDC_SRA_M30_HDSEL	(1<<3)	/* HDSEL* disk IF output status */
#define FDC_SRA_M30_INDX	(1<<2)	/* INDEX disk interface input status */
#define FDC_SRA_M30_WP		(1<<1)	/* WP disk interface input status */
#define FDC_SRA_M30_DIR		(1<<0)	/* DIR* disk interface output status */

/* SRB - status register B bit definitions */

#define FDC_SRB_PS2_DR0		(1<<5)	/* DR0* select status of DOR */
#define FDC_SRB_PS2_WDATA	(1<<4)	/* WDATA disk interface output status */
#define FDC_SRB_PS2_RDATA	(1<<3)	/* RDATA disk interface output status */
#define FDC_SRB_PS2_WGATE	(1<<2)	/* INDEX* disk interface input status */
#define FDC_SRB_PS2_MTR1	(1<<1)	/* MTR1 disk interface output status */
#define FDC_SRB_PS2_MTR0	(1<<0)	/* MTR0 disk interface output status */

#define FDC_SRB_M30_DRV2	(1<<7)	/* DRV2* disk interface input status */
#define FDC_SRB_M30_DR1		(1<<6)	/* DR1* disk interface output status */
#define FDC_SRB_M30_DR0		(1<<5)	/* DR0* disk interface output status */
#define FDC_SRB_M30_WDATA	(1<<4)	/* WDATA disk interface output status */
#define FDC_SRB_M30_RDATA	(1<<3)	/* RDATA disk interface output status */
#define FDC_SRB_M30_WGATE	(1<<2)	/* INDEX disk interface input status */
#define FDC_SRB_M30_DR3		(1<<1)	/* DR3* disk interface output status */
#define FDC_SRB_M30_DR2		(1<<0)	/* DR2* disk interface output status */

/* DOR - digital output register bit definitions */

#define FDC_DOR_MTR3		(1<<7)	/* motor enable 3 */
#define FDC_DOR_MTR2		(1<<6)	/* motor enable 2 */
#define FDC_DOR_MTR1		(1<<5)	/* motor enable 1 */
#define FDC_DOR_MTR0		(1<<4)	/* motor enable 0 */
#define FDC_DOR_DMAEN		(1<<3)	/* DMA enable (PC-AT or Model 30) */
#define FDC_DOR_RESET		(1<<2)	/* reset controller */
#define FDC_DOR_DRIVESEL1	(1<<1)	/* drive select, bit #1 */
#define FDC_DOR_DRIVESEL0	(1<<0)	/* drive select, bit #0 */

/* TDR - tape drive register bit definitions */

#define FDC_TDR_ED		(1<<7)	/* extra density */
#define FDC_TDR_HD		(1<<6)	/* high density */
#define FDC_TDR_VLDX		(1<<5)	/* valid data */
#define FDC_TDR_DRID1		(1<<5)	/* drive identifier #0 */
#define FDC_TDR_DRID0		(1<<4)	/* drive identifier #1 */
#define FDC_TDR_SWP1		(1<<3)	/* logical drive exchange bit #1 */
#define FDC_TDR_SWP0		(1<<2)	/* logical drive exchange bit #0 */
#define FDC_TDR_TAPESEL1	(1<<1)	/* tape select, bit #1 */
#define FDC_TDR_TAPESEL0	(1<<0)	/* tape select, bit #0 */

/* MSR - main status register bit definitions */

#define FDC_MSR_RQM		(1<<7)	/* request for master */
#define FDC_MSR_DIO		(1<<6)	/* data I/O direction */
#define FDC_MSR_NONDMA		(1<<5)	/* non-DMA execution */
#define FDC_MSR_CMDPROG		(1<<4)	/* command in progress */
#define FDC_MSR_DRV3BUSY	(1<<3)	/* drive 3 busy */
#define FDC_MSR_DRV2BUSY	(1<<2)	/* drive 2 busy */
#define FDC_MSR_DRV1BUSY	(1<<1)	/* drive 1 busy */
#define FDC_MSR_DRV0BUSY	(1<<0)	/* drive 0 busy */

/* DSR - data rate select register bit definitions */

#define FDC_DSR_SWRESET		(1<<7)	/* software reset */
#define FDC_DSR_LOWPOWER	(1<<6)	/* low power */
#define FDC_DSR_PRECOMP2	(1<<4)	/* precompensation select, bit #2 */
#define FDC_DSR_PRECOMP1	(1<<3)	/* precompensation select, bit #1 */
#define FDC_DSR_PRECOMP0	(1<<2)	/* precompensation select, bit #0 */
#define FDC_DSR_DRATE1		(1<<1)	/* date rate select, bit #1 */
#define FDC_DSR_DRATE0		(1<<0)	/* date rate select, bit #0 */

/* DIR - digital input register bit definitions */

#define FDC_DIR_AT_DSKCHG	(1<<7)	/* disk changed */

#define FDC_DIR_PS2_DSKCHG	(1<<7)	/* disk changed */
#define FDC_DIR_PS2_DRATE1	(1<<2)	/* data rate select #1 */
#define FDC_DIR_PS2_DRATE0	(1<<1)	/* data rate select #0 */
#define FDC_DIR_PS2_HIGHDEN	(1<<0)	/* high density selected */

#define FDC_DIR_M30_DSKCHG	(1<<7)	/* disk changed */
#define FDC_DIR_M30_DMAEN	(1<<3)	/* DMA enable */
#define FDC_DIR_M30_NOPRE	(1<<2)	/* no precompensation */
#define FDC_DIR_M30_DRATE1	(1<<1)	/* data rate select #1 */
#define FDC_DIR_M30_DRATE0	(1<<0)	/* data rate select #0 */

/* CCR - configuration control register bit definitions */

#define FDC_CCR_DRATE1		(1<<1)	/* data rate select #1 */
#define FDC_CCR_DRATE0		(1<<0)	/* data rate select #0 */

/* ST0 - status register 0 bit definitions */

#define FDC_ST0_IC1		(1<<7)	/* interrupt code bit #1 */
#define FDC_ST0_IC0		(1<<6)	/* interrupt code bit #0 */
#define FDC_ST0_SE		(1<<5)	/* seek end */
#define FDC_ST0_EC		(1<<4)	/* equipment check */
#define FDC_ST0_HDS		(1<<2)	/* head select */
#define FDC_ST0_DS1		(1<<1)	/* drive select #1 */
#define FDC_ST0_DS0		(1<<0)	/* drive select #0 */

/* ST1 - status register 1 bit definitions */

#define FDC_ST1_ET		(1<<7)	/* end of track */
#define FDC_ST1_CE		(1<<5)	/* CRC error */
#define FDC_ST1_OR		(1<<4)	/* overrun */
#define FDC_ST1_ND		(1<<2)	/* no data */
#define FDC_ST1_NW		(1<<1)	/* not writable */
#define FDC_ST1_MA		(1<<0)	/* missing address mark */

/* ST2 - status register 2 bit definitions */

#define FDC_ST2_CM		(1<<6)	/* control mark */
#define FDC_ST2_CD		(1<<5)	/* CRC error in data field */
#define FDC_ST2_WT		(1<<4)	/* wrong track */
#define FDC_ST2_SEH		(1<<3)	/* scan equal hit */
#define FDC_ST2_SNS		(1<<2)	/* scan not satisfied */
#define FDC_ST2_BT		(1<<1)	/* bad track */
#define FDC_ST2_MD		(1<<0)	/* missing address mark in data field */

/* ST3 - status register 3 bit definitions */

#define FDC_ST3_WP		(1<<6)	/* write protect */
#define FDC_ST3_TK0		(1<<4)	/* track 0 */
#define FDC_ST3_HDS		(1<<2)	/* head select */
#define FDC_ST3_DS1		(1<<1)	/* drive select #1 */
#define FDC_ST3_DS0		(1<<0)	/* drive select #0 */

/* FDC command set definitions */

#define FDC_CS_CONFIGURE	0x13	/* configure */
#define FDC_CS_DUMPREG		0x0E	/* dump registers */
#define FDC_CS_FORMATTRACK	0x0D	/* format track */
#define FDC_CS_LOCK		0x14	/* lock */
#define FDC_CS_MODE		0x01	/* mode */
#define FDC_CS_NSC		0x18	/* NSC */
#define FDC_CS_PRPNDCLRMODE	0x12	/* perpendicular mode */
#define FDC_CS_READDATA		0x06	/* read data */
#define FDC_CS_READDELDATA	0x0C	/* read deleted data */
#define FDC_CS_READID		0x0A	/* read identifier */
#define FDC_CS_READATRACK	0x02	/* read a track */
#define FDC_CS_RECALIBRATE	0x07	/* recalibrate */
#define FDC_CS_RELATIVESEEK	0x8F	/* relative seek */
#define FDC_CS_SCANEQUAL	0x11	/* scan equal */
#define FDC_CS_SCANHIOREQUAL	0x1D	/* scan high or equal */
#define FDC_CS_SCANLOOREQUAL	0x19	/* scan low or equal */
#define FDC_CS_SEEK		0x0F	/* seek */
#define FDC_CS_SENSEDRVSTAT	0x04	/* sense drive status */
#define FDC_CS_SENSEINT		0x08	/* sense interrupt */
#define FDC_CS_SETTRACK		0x21	/* set track */
#define FDC_CS_SPECIFY		0x03	/* specify */
#define FDC_CS_VERIFY		0x16	/* verify */
#define FDC_CS_VERSION		0x10	/* version */
#define FDC_CS_WRITEDATA	0x05	/* write data */
#define FDC_CS_WRITEDELDATA	0x09	/* write deleted data */

/* command/result phase bit definitions */

#define FDC_CP_EIS	(1<<6)	/* enable implied seeks */
#define FDC_CP_FIFO	(1<<5)	/* enable FIFO for execution phase */
#define FDC_CP_POLL	(1<<4)	/* disable drive polling */

#define FDC_CP_TMR	(1<<7)	/* motor timer mode */
#define FDC_CP_IAF	(1<<6)	/* index address format */
#define FDC_CP_IPS_M	(1<<5)	/* implied seek */
#define FDC_CP_ETR	(1<<0)	/* extended track range */

#define FDC_CP_FWR	(1<<7)	/* FIFO write disable */
#define FDC_CP_FRD	(1<<6)	/* FIFO read disable */
#define FDC_CP_BST	(1<<5)	/* burst mode disable */
#define FDC_CP_R255	(1<<4)	/* recalibrate step pulses */

#define FDC_CP_BFR	(1<<5)	/* CMOS disk interface buffer enable */
#define FDC_CP_WLD	(1<<4)	/* scan wild card */
#define FDC_CP_RG	(1<<2)	/* read gate diagnostic */
#define FDC_CP_PU	(1<<0)	/* PUMP pulse output diagnostic */

#define FDC_CP_MT	(1<<7)	/* multi-track sector */
#define FDC_CP_MFM	(1<<6)	/* MFM mode */
#define FDC_CP_WNR	(1<<6)
#define FDC_CP_SK	(1<<5)	/* sector skip */

#define FDC_CP_EC	(1<<7)	/* enable count */
#define FDC_CP_IPS	(1<<7)	/* implied seek */
#define FDC_CP_HD	(1<<2)	/* head address */
#define FDC_CP_MSB	(1<<2)
#define FDC_CP_DR1	(1<<1)	/* disk drive select, bit #1 */
#define FDC_CP_DR0	(1<<0)	/* disk drive select, bit #0 */
#define FDC_CP_DMA	(1<<0)	/* non-DMA mode flag */

#define FDC_CP_OW	(1<<7)	/* overwrite */
#define FDC_CP_DC3	(1<<5)
#define FDC_CP_DC2	(1<<4)
#define FDC_CP_DC1	(1<<3)
#define FDC_CP_DC0	(1<<2)
#define FDC_CP_GAP	(1<<1)
#define FDC_CP_WG	(1<<0)	/* write gate */

/* 
 * typedefs
 *
 * command (command phase) structure definitions
 */

typedef union fdc_command 
    {
    struct c_justdata 
	{
        UCHAR databytes[32];
	} c_justdata;
    struct c_configure 
	{
        UCHAR opcode;
        UCHAR cbyte1;
        UCHAR cbyte2;
        UCHAR pretrk;
	} c_configure;
    struct c_dumpreg 
	{
        UCHAR opcode;
	} c_dumpreg;
    struct c_formattrack 
	{
        UCHAR opcode;
        UCHAR cbyte1;
        UCHAR bytes_per_sector;
        UCHAR sectors_per_track;
        UCHAR format_gap;
        UCHAR data_pattern;
	} c_formattrack;
    struct c_lock 
	{
        UCHAR opcode;
	} c_lock;
    struct c_mode 
	{
        UCHAR opcode;
        UCHAR cbyte1;
        UCHAR cbyte2;
        UCHAR cbyte3;
        UCHAR cbyte4;
	} c_mode;
    struct c_nsc 
	{
      UCHAR opcode;
	} c_nsc;
    struct c_pmode 
	{
        UCHAR opcode;
        UCHAR cbyte1;
	} c_pmode;
    struct c_readdata 
	{
        UCHAR opcode;
        UCHAR cbyte1;
        UCHAR track_number;
        UCHAR drive_head_number;
        UCHAR sector_number;
        UCHAR bytes_per_sector;
        UCHAR end_of_track_sector_number;
        UCHAR intersector_gap_length;
        UCHAR data_length;
	} c_readdata;
    struct c_readdeleteddata 
	{
        UCHAR opcode;
        UCHAR cbyte1;
        UCHAR track_number;
        UCHAR drive_head_number;
        UCHAR sector_number;
        UCHAR bytes_per_sector;
        UCHAR end_of_track_sector_number;
        UCHAR intersector_gap_length;
        UCHAR data_length;
	} c_readdeleteddata;
    struct c_readid 
	{
        UCHAR opcode;
        UCHAR cbyte1;
	} c_readid;
    struct c_readtrack 
	{
        UCHAR opcode;
        UCHAR cbyte1;
        UCHAR track_number;
        UCHAR drive_head_number;
        UCHAR sector_number;
        UCHAR bytes_per_sector;
        UCHAR end_of_track_sector_number;
        UCHAR intersector_gap_length;
        UCHAR data_length;
	} c_readtrack;
    struct c_recalibrate 
	{
        UCHAR opcode;
        UCHAR cbyte1;
	} c_recalibrate;
    struct c_relativeseek 
	{
        UCHAR opcode;
        UCHAR cbyte1;
	} c_relativeseek;
    struct c_scanequal 
	{
        UCHAR opcode;
        UCHAR cbyte1;
        UCHAR track_number;
        UCHAR drive_head_number;
        UCHAR sector_number;
        UCHAR bytes_per_sector;
        UCHAR end_of_track_sector_number;
        UCHAR intersector_gap_length;
        UCHAR sector_step_size;
	} c_scanequal;
    struct c_scanhighorequal 
	{
        UCHAR opcode;
        UCHAR cbyte1;
        UCHAR track_number;
        UCHAR drive_head_number;
        UCHAR sector_number;
        UCHAR bytes_per_sector;
        UCHAR end_of_track_sector_number;
        UCHAR intersector_gap_length;
        UCHAR sector_step_size;
	} c_scanhighorequal;
    struct c_scanloworequal 
	{
        UCHAR opcode;
        UCHAR cbyte1;
        UCHAR track_number;
        UCHAR drive_head_number;
        UCHAR sector_number;
        UCHAR bytes_per_sector;
        UCHAR end_of_track_sector_number;
        UCHAR intersector_gap_length;
        UCHAR sector_step_size;
	} c_scanloworequal;
    struct c_seek 
	{
        UCHAR opcode;
        UCHAR cbyte1;
        UCHAR cbyte2;
        UCHAR cbyte3;
	} c_seek;
    struct c_sensedrivestatus 
	{
        UCHAR opcode;
        UCHAR cbyte1;
	} c_sensedrivestatus;
    struct c_senseinterrupt 
	{
        UCHAR opcode;
	} c_senseinterrupt;
    struct c_settrack 
	{
        UCHAR opcode;
        UCHAR cbyte1;
        UCHAR cbyte2;
	} c_settrack;
    struct c_specify 
	{
        UCHAR opcode;
        UCHAR cbyte1;
        UCHAR cbyte2;
	} c_specify;
    struct c_verify 
	{
        UCHAR opcode;
        UCHAR cbyte1;
        UCHAR track_number;
        UCHAR drive_head_number;
        UCHAR sector_number;
        UCHAR bytes_per_sector;
        UCHAR end_of_track_sector_number;
        UCHAR intersector_gap_length;
        UCHAR data_length_sector_count;
	} c_verify;
    struct c_version 
	{
        UCHAR opcode;
	} c_version;
    struct c_writedata 
	{
        UCHAR opcode;
        UCHAR cbyte1;
        UCHAR track_number;
        UCHAR drive_head_number;
        UCHAR sector_number;
        UCHAR bytes_per_sector;
        UCHAR end_of_track_sector_number;
        UCHAR intersector_gap_length;
        UCHAR data_length;
	} c_writedata;
    struct c_writedeleteddata 
	{
        UCHAR opcode;
        UCHAR cbyte1;
        UCHAR track_number;
        UCHAR drive_head_number;
        UCHAR sector_number;
        UCHAR bytes_per_sector;
        UCHAR end_of_track_sector_number;
        UCHAR intersector_gap_length;
        UCHAR data_length;
	} c_writedeledteddata;
    } FDC_COMMAND;

/* result (result phase) structure definitions */

typedef union fdc_result 
    {
    struct r_justdata 
	{
        UCHAR databytes[32];
	} r_justdata;
    struct r_dumpreg 
	{
        UCHAR registers[10];
	} r_dumpreg;
    struct r_formattrack 
	{
        UCHAR status_register_0;
        UCHAR status_register_1;
        UCHAR status_register_2;
        UCHAR track_number;
        UCHAR head_number;
        UCHAR sector_number;
        UCHAR bytes_per_sector;
	} r_formattrack;
    struct r_lock 
	{
        UCHAR sbyte1;
	} r_lock;
    struct r_nsc 
	{
        UCHAR sbyte1;
	} r_nsc;
    struct r_readdata 
	{
        UCHAR status_register_0;
        UCHAR status_register_1;
        UCHAR status_register_2;
        UCHAR track_number;
        UCHAR head_number;
        UCHAR sector_number;
        UCHAR bytes_per_sector;
	} r_readdata;
    struct r_readdeleteddata 
	{
        UCHAR status_register_0;
        UCHAR status_register_1;
        UCHAR status_register_2;
        UCHAR track_number;
        UCHAR head_number;
        UCHAR sector_number;
        UCHAR bytes_per_sector;
	} r_readdeleteddata;
    struct r_readid 
	{
        UCHAR status_register_0;
        UCHAR status_register_1;
        UCHAR status_register_2;
        UCHAR track_number;
        UCHAR head_number;
        UCHAR sector_number;
        UCHAR bytes_per_sector;
	} r_readid;
    struct r_readtrack 
	{
        UCHAR status_register_0;
        UCHAR status_register_1;
        UCHAR status_register_2;
        UCHAR track_number;
        UCHAR head_number;
        UCHAR sector_number;
        UCHAR bytes_per_sector;
	} r_readtrack;
    struct r_scanequal 
	{
        UCHAR status_register_0;
        UCHAR status_register_1;
        UCHAR status_register_2;
        UCHAR track_number;
        UCHAR head_number;
        UCHAR sector_number;
        UCHAR bytes_per_sector;
	} r_scanequal;
    struct r_scanhighorequal 
	{
        UCHAR status_register_0;
        UCHAR status_register_1;
        UCHAR status_register_2;
        UCHAR track_number;
        UCHAR head_number;
        UCHAR sector_number;
        UCHAR bytes_per_sector;
	} r_scanhighorequal;
    struct r_scanloworequal 
	{
        UCHAR status_register_0;
        UCHAR status_register_1;
        UCHAR status_register_2;
        UCHAR track_number;
        UCHAR head_number;
        UCHAR sector_number;
        UCHAR bytes_per_sector;
	} r_scanloworequal;
    struct r_seek 
	{
        UCHAR opcode;
        UCHAR cbyte1;
        UCHAR cbyte2;
        UCHAR cbyte3;
	} r_seek;
    struct r_sensedrivestatus 
	{
        UCHAR status_register_3;
	} r_sensedrivestatus;
    struct r_senseinterrupt 
	{
        UCHAR status_register_0;
        UCHAR present_track_number;
        UCHAR msnofptr;
	} r_senseinterrupt;
    struct r_settrack 
	{
        UCHAR value;
	} r_settrack;
    struct r_verify 
	{
        UCHAR status_register_0;
        UCHAR status_register_1;
        UCHAR status_register_2;
        UCHAR track_number;
        UCHAR head_number;
        UCHAR sector_number;
        UCHAR bytes_per_sector;
	} r_verify;
    struct r_version 
	{
        UCHAR sbyte1;
	} r_version;
    struct r_writedata 
	{
        UCHAR status_register_0;
        UCHAR status_register_1;
        UCHAR status_register_2;
        UCHAR track_number;
        UCHAR head_number;
        UCHAR sector_number;
        UCHAR bytes_per_sector;
	} r_writedata;
    struct r_writedeleteddata 
	{
        UCHAR status_register_0;
        UCHAR status_register_1;
        UCHAR status_register_2;
        UCHAR track_number;
        UCHAR head_number;
        UCHAR sector_number;
        UCHAR bytes_per_sector;
	} r_writedeledteddata;
    } FDC_RESULT;

/* register map structure template definition */

typedef struct fdc 
    {
    UCHAR sra;		/* status register A */
    UCHAR srb;		/* status register B */
    UCHAR dor;		/* digital output register */
    UCHAR tdr;		/* tape drive register */
    UCHAR msr_dsr;	/* main-status/data-rate-select register */
    UCHAR fifo;		/* data register (FIFO) */
    UCHAR none;		/* none (bus tristate) */
    UCHAR dir_ccr;	/* digital-input/configuration-control register */
    } FDC;

#ifdef __cplusplus
}
#endif

#endif  /* INCfdch */
