#*******************************************************************************
# E.S.O. - VLT project
#
# "@(#) $Id: accData.sql,v 1.6 2008/02/13 11:41:25 bjeram Exp $"
#
# who       when      what
# --------  --------  ----------------------------------------------
# gfilippi  30/11/99  created
#
#************************************************************************
#   NAME
#       accData.sql - ASCII copy of the ACC database
#
#   SYNOPSIS
#       $VLTDATA/msql/accData.sql
#
#   DESCRIPTION
#       database definition for some machines currently part 
#       of the VLT development pool
# 
#       To load this file:
#                           $VLTDATA/msql/accLoadData
#       after having replaced
#           %%INSTALL_HOST%%     with the name of the installation host
#           %%INSTALL_HOST_IP%%  with the IP of the installation host
#       This is done automatically by the accdbConfig script.
#
#
#  CAUTION
#
#------------------------------------------------------------------------

# **************
# *  Subnets   *
# **************
#
# enable_status  -> accENABLED | accDISABLED
# telescope_unit -> UT1 | UT2 | UT3 | UT4 | VLTI | (null)
#
#        subnet_name     Subnet name
#        description     Short description
#        ip_address      IP address (x.y.z.0)
#        router_name     DNS router name (gateway)
#        router_ip_addr  router (gateway) IP address
#        enable_status   '' (not used)
#        instrument      '' (not used)
#        telescope_unit  '' (not used)
#

# Examples:
# INSERT INTO subnet VALUES ('a1','UT1 acquisition       LAN','134.171.208.0','esohq-r1-atm0-12','134.171.208.254','','','')\g
INSERT INTO subnet VALUES ('almasoft','ALMA software subnet','134.171.18.0','esohq-r1-atm0-12','134.171.18.199','','','')\g
INSERT INTO subnet VALUES ('vltsoft','VLT software subnet','134.171.12.0','esohq-r1-atm0-12','134.171.12.199','','','')\g
INSERT INTO subnet VALUES ('esofs','ESO file server subnet','134.171.7.0','eso-gw-vlan7','134.171.7.199','','','')\g

# **************
# *  stations  *
# **************

#
# define  stations (hosts)
#    station_name   host name (e.g.: te39) 
#    station_type   '' 
#    subnet_name    ''  
#    ip_address     IP address of the host (x.y.z.w)
#    active_status  ''
#    location       ''
#    responsible    ''
#    telephone      ''
#    email          ''
#    station_arch   hp9700 | solaris | 68k     | ppc
#    station_cpu    hppa   | sparc   | MC68040 | PPC604
#    station_bsp           |         | mv167   | mv2604   (for LCU host type only)
#    attic          1=do not show it in host list | 0=visible
#
#
#
INSERT INTO station VALUES ('%%INSTALL_HOST%%' ,'','as','%%INSTALL_HOST_IP%%' ,'','ALMA SW WORKSTATION              ','','','','linux','x86' ,''  ,0)\g
########### added by BGU 2002-03-18 ##########################################
INSERT INTO station VALUES ('te36' ,'','almasoft','134.171.18.24','', 'LCU',                'BJE','','','ppc','PPC604','mv2700' ,0)\g
INSERT INTO station VALUES ('te39' ,'','vltsoft','134.171.12.82','', 'LCU',                'BGU','','','ppc','PPC604','mv2700' ,0)\g
INSERT INTO station VALUES ('te44' ,'','vltsoft','134.171.12.220','', 'LCU',                'BGU','','','ppc','PPC604','mv2604' ,0)\g
INSERT INTO station VALUES ('te54' ,'','almasoft','134.171.18.31','', 'LCU',                'BJE','','','ppc','PPC604','mv2700' ,0)\g
INSERT INTO station VALUES ('te13'   ,'','vltsoft','134.171.12.222','','HP755/99 056 TCS development ','VLT','','','hp9700' ,'hppa'  ,''  ,0)\g
INSERT INTO station VALUES ('te30'  ,'','vltsoft','134.171.12.154' ,'','HP-C110 072 ','VLT','','','hp9700' ,'hppa'  ,''  ,0)\g
INSERT INTO station VALUES ('homehost'   ,'','esofs','134.171.7.44','','ESO Home File Server 1', 'ALMA','','','pc' ,'i686'  ,''  ,0)\g

# ******************
# *  environments  *
# ******************

# define environments (RTAP, CCS-lite, LCU)
#
#    progenv_name   environment name
#    description    ''
#    env_type       RTAP | LCU | QSEMU
#    tcp_port       TCP port number (as in /etc/services)
#    station_name   host where the environment is running
#    attic          1 (do not show it in environment list) | 0 (visible)

# Example
INSERT INTO prog_environment VALUES ('walma'  ,'','QSEMU',2303,'%%INSTALL_HOST%%','','','',0 )\g
############################## TAT ENVIRONMENTS #######################################
INSERT INTO prog_environment VALUES ('w%%INSTALL_HOST%%a'  ,'','QSEMU',2240,'%%INSTALL_HOST%%','','','',1 )\g
INSERT INTO prog_environment VALUES ('w%%INSTALL_HOST%%b'  ,'','QSEMU',2241,'%%INSTALL_HOST%%','','','',1 )\g
INSERT INTO prog_environment VALUES ('w%%INSTALL_HOST%%c'  ,'','QSEMU',2242,'%%INSTALL_HOST%%','','','',1 )\g
INSERT INTO prog_environment VALUES ('w%%INSTALL_HOST%%d'  ,'','QSEMU',2243,'%%INSTALL_HOST%%','','','',1 )\g
INSERT INTO prog_environment VALUES ('w%%INSTALL_HOST%%e'  ,'','QSEMU',2244,'%%INSTALL_HOST%%','','','',1 )\g
########### added by BGU 2002-03-18 ##########################################
INSERT INTO prog_environment VALUES ('lte36'  ,'','LCU',2160,'te36'   ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('lte39'  ,'','LCU',2160,'te39'   ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('lte44'  ,'','LCU',2160,'te44'   ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('lte54'  ,'','LCU',2160,'te54'   ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('labm'  ,'','LCU',2160,'te39'   ,'','','',0 ) \g

#######################################################################################

# ******************
# *  progenv_name  *
# ******************

#
# Default RTAP(or ','QSEMU) environment from which an LCU environment boots
# (also log reporting node)
#
#    progenv_name   "client" LCU environment name
#    bootenv_name   "host" RTAP (or ','QSEMU) environment name
  
# Examples
#### Added by BGU ############################################################
INSERT INTO lcu_progenv VALUES ('lte36', 'walma' ) \g
INSERT INTO lcu_progenv VALUES ('lte39', 'walma' ) \g
INSERT INTO lcu_progenv VALUES ('lte44', 'walma' ) \g
INSERT INTO lcu_progenv VALUES ('lte54', 'walma' ) \g
INSERT INTO lcu_progenv VALUES ('labm', 'walma' ) \g


#
#___oOo___
