/*****************************************************************************
**
* E.S.O. - VLT project
*
* @(#) $ID: $
*
* who       when      what
* --------  --------  ----------------------------------------------
* mnastvog  27/06/95  created
*/
/*************************************************************************/
#include "vltPort.h"


static char *rcsId="@(#) $Id: x_pm.c,v 1.1.1.1 2003/05/28 16:58:56 gchiozzi Exp $";
static void *use_rcsId = (&use_rcsId,(void *) &rcsId);
/* file: x_pm.c
** sccs: @(#)x_pm.c UW-SAL 1.1 (1/2/94)
** Copyright 1992,1993 University of Wisconsin
** *******************************************************************
** Space Astronomy Laboratory
** University of Wisconsin
** 1150 University Avenue
** Madison, WI 53706 USA
** *******************************************************************
** Do not use this software without permission.
** Do not use this software without attribution.
** Do not remove or alter any of the lines above.
** *******************************************************************
*/
#ifndef lint
static char *sccs = "@(#)x_pm.c UW-SAL 1.1 (1/2/94)";
#endif

/*
** *******************************************************************
** x_timing - test the pointing machine
** *******************************************************************
*/

#include "astro.h"
#include "slalib.h"
#include "slamac.h"
#undef DEBUG
#define TIMER_BACKGROUND
/*
** *******************************************************************
** global data structures required by slalib
** *******************************************************************
*/

double amprms[21]; /* global data array */
double aoprms[14]; /* global data array */

/*
** *******************************************************************
** first some subroutines to adapt functions to a timexN'able form
** *******************************************************************
*/
void loop_mapqk(double * rm,double * dm,double * ra,double * da)
    {
    slaMapqk(*rm,*dm,0.0,0.0,0.0,0.0,amprms,ra,da);
    }
void loop_aoppat(struct s_tstate * p)
    {
    slaAoppat(p->utc,aoprms);
    }
void loop_aopqk(double * ra,double * da)
    {
    double aob,hob,zob,rob,dob;

    slaAopqk(*ra,*da,aoprms,&aob,&zob,&hob,&dob,&rob);
    }

void slaMappa_loop(struct s_tstate * p,double * amprms)
{
    slaMappa(slaEpj2d (1995.0),p->tdb,amprms);
}

void slaAoppa_loop(struct s_tstate * p,double * aoprms)
{
    slaAoppa(p->tdb,p->delta_ut,p->lon,p->lat,p->alt,p->xpole,p->ypole,
             p->T,p->P,p->H,p->wavelength,0.0065,aoprms);
}
/*
** *******************************************************************
** get_tstate: background computations
** *******************************************************************
*/
void get_tstate(struct s_tstate  *p)
{
    time_t tv;
#ifdef DEBUG
    (void)fprintf(stdout, "x_pm: compute the tstate\n");
#endif

    /*************************/
    /* fetch the current UTC */
    /*************************/
#if 0
    time(&tv);
    (void)fprintf(stdout, "x_pm: time: %d\n",tv);
    /*  constant for 1 Jan 1970! */
    p->utc = 2440587.5 + ((double)tv / 86400) - 2400000.5;
#else
    /* for now 1984.5 as MJD*/
    p->utc = slaEpj2d(1984.5) - 2;
    (void)fprintf(stdout, "x_pm: tstate %7s: %.15e %s\n",
	"utc", p->utc, fmt_j(p->utc));
#endif
    /*******************************/
    /* compute the dynamical times */
    /*******************************/
    p->tai = p->utc + (p->delta_at/86400.0);
    p->tdt = p->tai + (32.184/86400);
    p->tdb = tdt2tdb(p->tdt);  
    (void)fprintf(stdout, "x_pm: tdb: %f\n",p->tdb);
#ifdef DEBUG
    (void)fprintf(stdout, "x_pm: tstate %7s: %.15e %s\n",
	"tai", p->tai, fmt_j(p->tai));
    (void)fprintf(stdout, "x_pm: tstate %7s: %.15e %s\n",
	"tdt", p->tdt, fmt_j(p->tdt));
    (void)fprintf(stdout, "x_pm: tstate %7s: %.15e %s\n",
	"tdb", p->tdb, fmt_j(p->tdb));
#endif

    /**************************************/
    /* compute the geometrical quantities */
    /**************************************/

#ifdef TIMER_BACKGROUND

    (void)fprintf(stdout, "x_pm: timing slaMappa\n");
    timexN(slaMappa_loop,p,amprms,NULL,NULL,NULL,NULL,NULL,NULL);
    (void)fprintf(stdout, "x_pm: timing slaAoppa\n");
    timexN(slaAoppa_loop,p,aoprms,NULL,NULL,NULL,NULL,NULL,NULL);
#endif
    slaMappa(2000.0,p->tdb + 10000.0/86400.0,amprms);
    slaAoppa(p->utc + 10000.0/86400.0,p->delta_ut,p->lon,p->lat,p->alt,p->xpole,p->ypole,
             p->T,p->P,p->H,p->wavelength,0.0065,aoprms);
    (void)fprintf(stdout, "x_pm: tstate %7s: %.15e %s\n",
	"gast", aoprms[12], fmt_j(aoprms[12]));
    (void)fprintf(stdout, "x_pm: tstate %7s: %.15e %s\n",
	"last", aoprms[13], fmt_j(aoprms[13]));
    return;
}


x_pm()
{
    double ep;
    double eq;
    time_t tv;
    char timeBuffer[80];
    int i;
    struct s_tstate tstate;
    int status;
    char sign;
    int idmsf[4];
    double rm,dm,ra,da,aob,hob,zob,rob,dob;
    /**********************/
    /* compute the tstate */
    /**********************/
    tstate.delta_at = 28;
    tstate.delta_ut = 0.5;
    tstate.lon = -1.5;
    tstate.lat = 0.8;
    tstate.alt = 359.0;
    tstate.xpole = 0.0;
    tstate.ypole = 0.0;
    tstate.T = 273.0;
    tstate.P = 960.0;
    tstate.H = 0.1;
    tstate.wavelength = 0.55;
#ifdef DEBUG
    (void)fprintf(stdout, "x_pm: delta_at %d\n", tstate.delta_at);
    (void)fprintf(stdout, "x_pm: delta_ut %.15e\n", tstate.delta_ut);
    (void)fprintf(stdout, "x_pm: lon %.15e\n", tstate.lon);
    (void)fprintf(stdout, "x_pm: lat %.15e\n", tstate.lat);
    (void)fprintf(stdout, "x_pm: alt %.15e\n", tstate.alt);
    (void)fprintf(stdout, "x_pm: xpole %.15e\n", tstate.xpole);
    (void)fprintf(stdout, "x_pm: ypole %.15e\n", tstate.ypole);
    (void)fprintf(stdout, "x_pm: T %.15e\n", tstate.T);
    (void)fprintf(stdout, "x_pm: P %.15e\n", tstate.P);
    (void)fprintf(stdout, "x_pm: H %.15e\n", tstate.H);
    (void)fprintf(stdout, "x_pm: wavelength %.15e\n", tstate.wavelength);
#endif
    (void)fprintf(stdout, "x_pm: Measurement of timing slalib\n");
#ifdef TIMER_BACKGROUND
    (void)fprintf(stdout, "x_pm:  ...get_tstate function\n");
#endif
    get_tstate(&tstate);
    eq = y2j(1995.5); /* to get the actual value */
    ep = eq;
    /**************************************/
    /* use one of 2 predefined star coords*/
    /**************************************/

#if 0
    slaDtf2r(0,48,40.95,&rm,&status); /*delta pisc*/
    slaDaf2r(7,35,6.14,&dm,&status);
#endif
#if 1
    slaDtf2r(12,11,44.014,&rm,&status); /*theta scl*/
    slaDaf2r(35,7,59.17,&dm,&status);
    dm = dm - 2 * DPI;
#endif
#if 0
    slaDtf2r(0,14,36.169,&rm,&status); /*chi peg*/
    slaDaf2r(20,12,24.06,&dm,&status);
#endif
    (void)fprintf(stdout, "x_pm: timing slaMapqk\n");
    timexN(loop_mapqk,&rm,&dm,&ra,&da,NULL,NULL,NULL,NULL);
    (void)fprintf(stdout, "x_pm: timing slaAoppat\n");
    timexN(loop_aoppat,&tstate,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
    (void)fprintf(stdout, "x_pm: timing slaAopqk\n");
    timexN(loop_aopqk,&ra,&da,NULL,NULL,NULL,NULL,NULL,NULL);
#if 1
    /**************************************/
    /* output also what we have done      */
    /**************************************/

    (void)fprintf(stdout, "x_pm: refa: %e refb: %e\n",
             aoprms[10],aoprms[11]);
    slaMapqk(rm,dm,0.0,0.0,0.0,0.0,amprms,&ra,&da);
    slaDr2tf(3,ra,&sign,idmsf);
    (void)fprintf(stdout, "x_pm: mean: %e %e,last %e\n",rm,dm,aoprms[13]);
    slaAoppat(tstate.utc,aoprms);
    (void)fprintf(stdout, "x_pm: tstate %7s: %.15e %s\n",
	"last", aoprms[13], fmt_j(aoprms[13]));
    (void)fprintf(stdout, "x_pm: apparent d %f %c%02dd %02dm %02ds.%03d\n",
                  ra,sign,idmsf[0],idmsf[1],idmsf[2],idmsf[3]);
    slaDr2af(3,da,&sign,idmsf);
    (void)fprintf(stdout, 
                  "x_pm: apparent r %f %c%02dd %02dm %02ds.%03d\n",
                  da,sign,idmsf[0],idmsf[1],idmsf[2],idmsf[3]);
        slaAopqk(ra,da,aoprms,&aob,&zob,&hob,&dob,&rob);
    (void)fprintf(stdout, "x_pm: az %f,zd %f, ha %f, d %f r %f\n",
		aob,zob,hob,dob,rob);
#endif
    return(0);
}





