/*******************************************************************************
*
* "@(#) $Id: rtlogTest_k.c,v 1.9 2007/10/11 13:43:30 bjeram Exp $"
*
* ALMA - Atacama Large Millimiter Array
* (c) Associated Universities Inc., 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* who       when        what
* --------  --------    ----------------------------------------------
* ramestic  2004-03-03  created
*/

/* 
 * System Headers
 */
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/delay.h>
#include <linux/time.h>

/*
 * RTAI specific
 */
#include <rtai_lxrt.h>

/* 
 * Local Headers
 */
#include "rtLog.h"

MODULE_AUTHOR("Bogdan Jeram");
MODULE_DESCRIPTION("RTLog Test");
MODULE_LICENSE("GPL");

/*
 * global variables
 */
int debug = 0;
RT_TASK	task;

#define MODULENAME	"rtlogTest"
#define N		10

void test_task(int not_used)
{
    int i;
    rtlogRecord_t logRecord;
    rt_printk("rtlogTest debug level: (%d %d %d)\n", RTLOG_DEBUG_LEVEL, RTLOG_INFO_LEVEL, RTLOG_ERROR_LEVEL);
    rt_printk("rtlogTest: %lld\n", rt_get_time());

    for ( i = 0; i < N; i++ )
	{
	RTLOG(MODULENAME, RTLOG_INFO, "N: %s", "hola mundo!");
	rt_sleep(nano2count(1000000000));
	}

    for ( i = 0; i < N; i++ )
	{
	RTLOG(MODULENAME, RTLOG_ERROR, "E: hola mundo (%d)!", i);
	rt_sleep(nano2count(1000000000));
	}

    for ( i = 0; i < N; i++ )
	{
	RTLOG(MODULENAME, RTLOG_DEBUG, "D: hola mundo (%d)!", i);
	rt_sleep(nano2count(1000000000));
	}

    RTLOG(MODULENAME, RTLOG_ERROR,"test test!");

    RTLOG_TRACE(MODULENAME, "%s", "Trace: hola mundo !");
    RTLOG_DEBUG(MODULENAME, "Debug: hola mundo !");
    RTLOG_INFO(MODULENAME, "Info: hola mundo !");
    RTLOG_NOTICE(MODULENAME, "Notice: hola mundo !");
    RTLOG_WARNING(MODULENAME, "Warning: hola mundo !");
    RTLOG_ERROR(MODULENAME, "Error: hola mundo !");
    RTLOG_CRITICAL(MODULENAME, "Critical: hola mundo !");
    RTLOG_ALERT(MODULENAME, "Alert: hola mundo !");
    RTLOG_EMERGENCY(MODULENAME, "Emergency: hola mundo !");

    rt_printk("rtlogTest: task finished!\n");
}

/*
 * kernel module handling
 */
int init_module(void)
{


    /*
     * spawn the main task
     */
    if ( rt_task_init(&task, test_task, 0, 8000, 10, 1, 0)
	 != 0 )
	{
	rt_printk("rtlogTest: CANNOT SPAWN THE TEST TASK #1.\n");
	return 0;
	}

    /*
     * set the just created task as 'ready to run'
     */
    rt_set_oneshot_mode();
    start_rt_timer_ns(0);
    rt_task_resume(&task);

    return 0;
}

//-----------------------------------------------------------------------------
void cleanup_module(void)
{
    rt_printk("rtlogTest: MODULE CLEANING UP...\n");

    /*
     * delete our main task
     */
    stop_rt_timer();
    rt_task_delete(&task);

    rt_printk("rtlogTest: MODULE CLEANED UP.\n");
}

/*___oOo___*/
