/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) Associated Universities Inc., 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* who       when      what
* --------  --------  ----------------------------------------------
* ramestic  2003-10-14  created
*/

#include <stdlib.h>
#include <sys/mman.h>

#define KEEP_STATIC_INLINE

#include <rtai_lxrt.h>
#include <rtai_fifos.h>
//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

/* 
 * Local Headers
 */
#include "rtLog.h"

#define N	16

int main(int argc, char** argv) 
{
    rtlogRecord_t logRecord;
    RT_TASK *task;
    int i;

    //
    // avoid memory paging and allow execution as non-root user.
    rt_allow_nonroot_hrt();
    mlockall(MCL_CURRENT | MCL_FUTURE);
    
    //
    // creates the buddy
    if ( !(task = rt_task_init_schmod(getpid(), 
				      10,
				      0,
				      0,
				      SCHED_FIFO,
				      0xFF)))
	{
	printf("CANNOT INIT MASTER TASK\n");
	exit(1);
        }

    //
    // goes into RTAI scheduler.
    rt_make_hard_real_time();
    rt_task_resume(task);

    // 
    // do some logging
    for ( i = 0; i < N; i++ )
	{
	RTLOG("rtlogTest(LXRT)", RTLOG_INFO, "%s", "hola mundo!");
	RTLOG("rtlogTest(LXRT)", RTLOG_ERROR,  "hola mundo (%d)!", i);
	}

    RTLOG("rtlogTest(LXRT)", RTLOG_ERROR,"test test!");

    RTLOG_TRACE("rtlogTest(LXRT)", "%s", "Trace: hola mundo !");
    RTLOG_DEBUG("rtlogTest(LXRT)", "Debug: hola mundo !");
    RTLOG_INFO("rtlogTest(LXRT)", "Info: hola mundo !");
    RTLOG_NOTICE("rtlogTest(LXRT)", "Notice: hola mundo !");
    RTLOG_WARNING("rtlogTest(LXRT)", "Warning: hola mundo !");
    RTLOG_ERROR("rtlogTest(LXRT)", "Error: hola mundo !");
    RTLOG_CRITICAL("rtlogTest(LXRT)", "Critical: hola mundo !");
    RTLOG_ALERT("rtlogTest(LXRT)", "Alert: hola mundo !");
    RTLOG_EMERGENCY("rtlogTest(LXRT)", "Emergency: hola mundo !");

    rt_printk("rtlogTest(LXRT): task finished!\n");
    //
    // goes back to Linux scheduler
    rt_make_soft_real_time();
    
    //
    // clean-up
    rt_task_delete(task);
   
    // wait that all log messages are actually sent 
    sleep(5);

    return 0;
}

/*___oOo___*/
