/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) Associated Universities Inc., 2005 
* 
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
* 
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: unloadcalibrationTest.cpp,v 1.4 2008/09/22 14:01:46 bjeram Exp $"
*
* who       when      what
* --------  --------  ----------------------------------------------
* jkern  2005-01-04  created 
*/

/************************************************************************
*   NAME
*    unloadcalibrationTest
* 
*   SYNOPSIS
*    See loadcalibrationTest for a description of this file.
*------------------------------------------------------------------------
*/

static char *rcsId="@(#) $Id: unloadcalibrationTest.cpp,v 1.4 2008/09/22 14:01:46 bjeram Exp $"; 
static void *use_rcsId = ((void)&use_rcsId,(void *) &rcsId);

#include <stdio.h>
#include <LKM.h>

/* No arguments used */
int main(int argc, char* argv[]) {
  LKM lkm;

  /* Set the uid of the process to root as well */
  try {
    lkm.becomeRoot();
  }
  catch (LKMerror ex) {
    fprintf(stderr,"unloadcalibrationTest: Error setting user ID to root\n");
    ex.printErr();
    return -1;
  }

  /* Unload the kernel modules needed to run the test, if one fails 
   * continue trying to unload
   */
  try 
      {
//    lkm.unloadMod("calibrate_rt");
      }
  catch (LKMerror ex) {
    fprintf(stderr,"unloadcalibrationTest: Error unloading Kernel module %s\n",
	    "calibrate_rt");
  }


  try {
    lkm.unloadMod("rtai_fifos");
  }
  catch (LKMerror ex) {
    fprintf(stderr,"unloadcalibrationTest: Error unloading Kernel module %s\n",
	    "rtai_fifos");
  }

  try {
    lkm.unloadMod("rtai_sched");
  }
  catch (LKMerror ex) {
    fprintf(stderr,"unloadcalibrationTest: Error unloading Kernel module %s\n",
	    "rtai_ksched");
  }

  try {
    lkm.unloadMod("rtai_hal");
  }
  catch (LKMerror ex) {
    fprintf(stderr,"unloadcalibrationTest: Error unloading Kernel module %s\n",
	    "rtai_hal");
  }
}





