/*******************************************************************************
*
* "@(#) $Id: rtStartTimer.c,v 1.1 2007/07/12 09:29:41 bjeram Exp $"
*
* ALMA - Atacama Large Millimiter Array
* (c) Associated Universities Inc., 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* who       when        what
* --------  --------    ----------------------------------------------
* ramestic  2004-03-03  created
*/

/* 
 * System Headers
 */
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/delay.h>
#include <linux/time.h>

/*
 * RTAI specific
 */
#include <rtai_lxrt.h>

MODULE_AUTHOR("Bogdan Jeram");
MODULE_DESCRIPTION("rtStartTimer");
MODULE_LICENSE("GPL");


#define MODULENAME	"rtStartTimer"


/*
 * kernel module handling
 */
int init_module(void)
{ 
    rt_printk("rtStartTimer: MODULE INITALIZING ...\n");

    /*
     * start timer
     */
    rt_set_oneshot_mode();
    start_rt_timer_ns(0);

    return 0;
}

//-----------------------------------------------------------------------------
void cleanup_module(void)
{
    rt_printk("rtStartTimer: MODULE CLEANING UP...\n");


    stop_rt_timer();


    rt_printk("rtStartTimer: MODULE CLEANED UP.\n");
}

/*___oOo___*/
