/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) Associated Universities Inc., 2003 
*
*This library is free software; you can redistribute it and/or
*modify it under the terms of the GNU Lesser General Public
*License as published by the Free Software Foundation; either
*version 2.1 of the License, or (at your option) any later version.
*
*This library is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*Lesser General Public License for more details.
*
*You should have received a copy of the GNU Lesser General Public
*License along with this library; if not, write to the Free Software
*Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* who       when      what
* --------  --------  ----------------------------------------------
* ramestic  2003-10-14  created
*/

#include <stdlib.h>
#include <sys/mman.h>

#define KEEP_STATIC_INLINE

#include <rtai_lxrt.h>
#include <rtai_fifos.h>
//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

#include <rtLog.h>
/* 
 * Local Headers
 */
#include "rtAlarm.h"

#define N	16
int iterNum=50;

int main(int argc, char** argv) 
{
    RT_TASK *task;
    int i;

    //
    // avoid memory paging and allow execution as non-root user.
    rt_allow_nonroot_hrt();
    mlockall(MCL_CURRENT | MCL_FUTURE);
    
    //
    // creates the buddy
    if ( !(task = rt_task_init_schmod(getpid(), 
				      10,
				      0,
				      0,
				      SCHED_FIFO,
				      0xFF)))
	{
	printf("CANNOT INIT MASTER TASK\n");
	exit(1);
        }

   rt_make_hard_real_time();
    rt_task_resume(task);


    rtAlarmSource_t *rtas;
    rtas = rtAlarmSourceInit("rtAl1", 0); // test creating of Alarm Source (MBX)

    if (!rtas)
	{
	rt_make_soft_real_time();
	printf("RT Alarm souce could not be initialized\n");
	
	return -1;
	}//if

    for ( i = 0; i < iterNum; i++ )
	{
	rtAlarmPush(rtas, i+1, rtAlarm_ACTIVE);
	rtAlarmWithPropertyPush(rtas, i+1, rtAlarm_TERMINATE, "alarm property");
	
	printf("rtAlarmTest-1: sent an alarm %d!\n", i+1);
	}/*for*/

    rt_sleep(nano2count(1000000000)); //waita bit that alarms are read
    rtAlarmSourceDelete(rtas, 1);
 


    rtas = rtAlarmSourceInit("rtAl2", 1); //test creating of Alarm source where MBX has to be already created
 
    if (!rtas)
	{
	rt_make_soft_real_time();
	printf("RT Alarm souce 2 could not be initialized\n");
	
	return -1;
	}//if

    for ( i = 0; i < iterNum; i++ )
	{
	rtAlarmPush(rtas, i+1, rtAlarm_ACTIVE);
	rtAlarmWithPropertyPush(rtas, i+1, rtAlarm_TERMINATE, "alarm property");
	
	printf("rtAlarmTest-2: sent an alarm %d!\n", i+1);
	}//for

    rt_sleep(nano2count(1000000000)); //waita bit that alarms are read
    rtAlarmSourceDelete(rtas, 1);

    rt_make_soft_real_time();
    // clean-up
    rt_task_delete(task);
   
    sleep(1);

    return 0;
}//main

/*___oOo___*/
