#ifndef _rtAlarm_H_
#define _rtAlarm_H_
/*******************************************************************************
* ALMA - Atacama Large Millimiter Array
* (c) European Southern Observatory, 2007 
* 
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
* 
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*
* "@(#) $Id: rtAlarm.h,v 1.2 2007/07/12 09:24:15 bjeram Exp $"
*
* who       when      what
* --------  --------  ----------------------------------------------
* bjeram  2007-06-27  created
*/

#ifndef RTAI_HOME
#warning "Compiling for NO RTAI"
#define NO_RTAI_HOME
#endif

#ifndef NO_RTAI_HOME
#include <rtai_mbx.h>
#endif

#include "rtAlarmData.h"

/**
 * Structure that represents RT source in RTAI
 */
typedef struct rtAlarmSource
{
    MBX* mbx; /**< pointer to MBX */
    char name[25]; /**< name of RT alarm source = name of MBX */
} rtAlarmSource_t;


#ifdef __cplusplus
extern "C" {
#endif /* !__cplusplus */

/** 
 * Creates RT alrm source. It creates MBX with given name.
 * @param alarmSource name of the source. It should match with the name of the RT alarm source in user space.
 * @parma alreadyCreated. If it is set to 1 the function will try to get already created MBX instead creating one.If MBX does not exist it fails.
 * @return pointer to the RT source which can be used by other functions. In case of an error it returns 0.
 *
 * @tbd should we have also version that just initalize the structure, so w/o memory allocation:
static void rtAlarmSourceInit(rtAlarmSource_t *as, char *alarmSourceName);
*/ 
rtAlarmSource_t *rtAlarmSourceInit(char *alarmSourceName, int alreadyCreated);

/**
 * Deletes given RT alarm source.
 * @parma alarmSource pointer to the RT alarm source
 * @param flush If flush is 1 all alarms that are still in the source (MBX) will be logged otherwise not.
 */
void rtAlarmSourceDelete(rtAlarmSource_t *alarmSource, int flush);

/**
 * Sends an alarm.
 * @param as pointer to the RT alarm source
 * @param alarmCode code of the alarm (a number or an ENUM)
 * @param state alarm state or description: ACTIVE or TERMINATE
 * @return 0 if succeed.
 */
int rtAlarmPush(rtAlarmSource_t *as, rtAlarmCode_t alarmCode, rtAlarmState_t state);

/**
 * Sends an alarm with property - additional description.
 * @param as pointer to the RT alarm source
 * @param alarmCode code of the alarm (a number or an ENUM)
 * @param state alarm state or description: ACTIVE or TERMINATE
 * @param pointer to addtional additional description (property) of the alarm. Max length is 255 characters.
 * @return 0 if succeed,
 */
int rtAlarmWithPropertyPush(rtAlarmSource_t *as, rtAlarmCode_t alarmCode, rtAlarmState_t state, char *property);

/**
 * Sends an alarm with property. This function is used by: #rtAlarmPush and #rtAlarmWithPropertyPush.
 * @param as pointer to the RT alarm source
 * @param alarm pointer to alarm structure #rtAlarm_t
 * @return 0 if succeed,
 */
int _rtAlarmPush(rtAlarmSource_t *as, rtAlarm_t *alarm);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /*!_rtAlarm_H_*/
