/*
 * ExampleBean.java
 *
 * Created on December 10, 2002, 3:14 PM
 */

package gpcourse;

import cern.gp.actions.OpenLocalExplorerAction;
import cern.gp.explorer.test.helpers.SimpleDemoBean;
import cern.gp.util.GPManager;
import gp.example.actions.SmileCapability;
import java.awt.Image;
import org.openide.NotifyDescriptor;

/**
 *
 * @author  ksigerud
 */
public class ExampleBean extends SimpleDemoBean implements SmileCapability {
  boolean niceExercise;
  long startTime;
  
  /** Creates a new instance of ExampleBean */
  public ExampleBean() {
    super();
  }
  
  /** Creates a new instance of ExampleBean */
  public ExampleBean(String name) {
    super(name);
  }
  
  public long getStartTime() {
    return startTime;
  }
  public void setStartTime(long time) {
    startTime = time;
  }
  
  public boolean getNiceExercise() {
    return niceExercise;
  }
  
  public void setNiceExercise(boolean nice) {
    niceExercise = nice;
  }
  
  public Image getNodeIcon() {
    return getNodeIconFromPathname("exampleIcon.gif");
  }
  
  public String getDisplayName() {
    return "My example " + getName();
  }
  public String getShortDescription() {
    return "This is an example bean for the GP course";
  }
  
  public String[] getNodeActions() {
    return new String[] {
      "cern.gp.actions.PropertiesAction",
      null,
      "cern.gp.actions.OpenLocalExplorerAction",
      "gp.example.actions.SmileAction",
    };
  }
  
  public String getNodeDefaultAction() {
    return "cern.gp.actions.OpenLocalExplorerAction";
  }
  
  /**
   * Tell the object that implements this capability to smile!
   *
   */
  public void smile() {
  NotifyDescriptor dialog = new NotifyDescriptor.Message("Smiling! :)",
  																				NotifyDescriptor.INFORMATION_MESSAGE);
  GPManager.notify(dialog);
  }
  
}
