/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.ContextSensitiveCellEditor;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.spinner.SpinnerWheelSupport;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.ParseException;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.TableCellEditor;

public class SpinnerCellEditor
extends ContextSensitiveCellEditor
implements TableCellEditor {
    public static EditorContext CONTEXT = new EditorContext("Spinner");
    protected JSpinner _spinner;

    public SpinnerCellEditor() {
        this._spinner = this.createSpinner(new SpinnerNumberModel());
        this._spinner.setOpaque(false);
        this._spinner.setBorder(DEFAULT_CELL_EDITOR_BORDER);
    }

    public SpinnerCellEditor(SpinnerModel spinnerModel) {
        this._spinner = this.createSpinner(spinnerModel);
        this._spinner.setOpaque(false);
        this._spinner.setBorder(DEFAULT_CELL_EDITOR_BORDER);
    }

    protected JSpinner createSpinner(SpinnerModel spinnerModel) {
        JSpinner jSpinner = new JSpinner(spinnerModel);
        SpinnerWheelSupport.installMouseWheelSupport((JSpinner)jSpinner);
        return jSpinner;
    }

    public Object getCellEditorValue() {
        try {
            this._spinner.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return this._spinner.getValue();
    }

    public void setCellEditorValue(Object object) {
        this._spinner.setValue(object);
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (jTable != null) {
            JideSwingUtilities.installColorsAndFont((Component)this._spinner, (Color)jTable.getBackground(), (Color)jTable.getForeground(), (Font)jTable.getFont());
        }
        this.setCellEditorValue(object);
        return this._spinner;
    }

    public JSpinner getSpinner() {
        return this._spinner;
    }
}

