/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.CORBA.kernel;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.INITIALIZE;
import org.openorb.CORBA.kernel.Property;
import org.openorb.CORBA.kernel.PropertyNotFoundException;
import org.openorb.util.ExceptionTool;

public class Properties
implements LogEnabled {
    private Logger m_logger = null;
    private SortedMap m_properties = Collections.synchronizedSortedMap(new TreeMap(new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((String)o1).compareToIgnoreCase((String)o2);
        }
    }));

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public void addProperty(String name, String value) {
        if (value == null) {
            this.m_properties.remove(name);
        } else {
            this.m_properties.put(name, new Property(name, value, this));
        }
    }

    public void addProperty(String name, int value) {
        this.m_properties.put(name, new Property(name, Integer.toString(value), new Integer(value)));
    }

    public void addProperty(String name, boolean value) {
        Boolean booleanValue = value ? Boolean.TRUE : Boolean.FALSE;
        this.m_properties.put(name, new Property(name, booleanValue.toString(), booleanValue));
    }

    public void addProperty(String name, URL value) {
        this.m_properties.put(name, new Property(name, value.toString(), value));
    }

    public void addProperty(String name, Class clz) {
        if (clz == null) {
            this.m_properties.remove(name);
        } else {
            this.m_properties.put(name, new Property(name, clz.getName(), clz));
        }
    }

    public Iterator properties(String name) {
        if (name == null) {
            return Collections.unmodifiableCollection(this.m_properties.values()).iterator();
        }
        if (!name.endsWith(".")) {
            name = name + ".";
        }
        return Collections.unmodifiableCollection(this.m_properties.subMap(name + "\u0000", name + "\uffff").values()).iterator();
    }

    public void display() {
        Iterator itt = this.properties(null);
        while (itt.hasNext()) {
            Property prop = (Property)itt.next();
            this.getLogger().info(prop.getName() + "=" + prop.getValue());
        }
    }

    public void display(Logger logger) {
        Iterator itt = this.properties(null);
        while (itt.hasNext()) {
            Property prop = (Property)itt.next();
            logger.debug(prop.getName() + "=" + prop.getValue());
        }
    }

    public String formatString(String str) {
        int ix;
        int in;
        URL base = null;
        String spec = str;
        if (str.startsWith("${")) {
            in = str.indexOf("}");
            if (in < 0) {
                throw new IllegalArgumentException("Unbalanced ${ } in \"" + str);
            }
            try {
                base = this.getURLProperty(str.substring(2, in), null);
                spec = str.substring(in + 1);
                if (base != null && spec.startsWith("#")) {
                    return base.toString() + spec;
                }
            }
            catch (INITIALIZE ex) {
                // empty catch block
            }
        }
        if ((ix = spec.indexOf("${")) >= 0) {
            in = 0;
            StringBuffer sb = new StringBuffer();
            do {
                sb.append(spec.substring(in, ix));
                in = spec.indexOf("}", ix);
                if (in < 0) {
                    throw new IllegalArgumentException("Unbalanced ${ } in \"" + str + "\"");
                }
                String prop = spec.substring(ix + 2, in);
                String exp = this.getStringProperty(prop, null);
                if (exp == null) {
                    return null;
                }
                sb.append(exp);
            } while ((ix = spec.indexOf("${", in)) >= 0);
            spec = sb.toString();
        }
        if (base != null) {
            try {
                return new URL(base, spec).toString();
            }
            catch (MalformedURLException ex) {
                return base.toString() + spec;
            }
        }
        return spec;
    }

    public Property getProperty(String name) {
        return (Property)this.m_properties.get(name);
    }

    public String getStringProperty(String name, String defl) {
        Property prop = (Property)this.m_properties.get(name);
        if (prop == null) {
            return defl;
        }
        return prop.getValue();
    }

    public String getStringProperty(String name) throws PropertyNotFoundException {
        Property prop = (Property)this.m_properties.get(name);
        if (prop == null) {
            throw new PropertyNotFoundException();
        }
        return prop.getValue();
    }

    public int getIntProperty(String name, int defl) {
        Property prop = (Property)this.m_properties.get(name);
        if (prop == null) {
            return defl;
        }
        return prop.getIntValue();
    }

    public int getIntProperty(String name) throws PropertyNotFoundException {
        Property prop = (Property)this.m_properties.get(name);
        if (prop == null) {
            throw new PropertyNotFoundException();
        }
        return prop.getIntValue();
    }

    public boolean getBooleanProperty(String name, boolean defl) {
        Property prop = (Property)this.m_properties.get(name);
        if (prop == null) {
            return defl;
        }
        return prop.getBooleanValue();
    }

    public boolean getBooleanProperty(String name) throws PropertyNotFoundException {
        Property prop = (Property)this.m_properties.get(name);
        if (prop == null) {
            throw new PropertyNotFoundException();
        }
        return prop.getBooleanValue();
    }

    public URL getURLProperty(String name, URL defl) {
        Property prop = (Property)this.m_properties.get(name);
        if (prop == null) {
            return defl;
        }
        return prop.getURLValue();
    }

    public URL getURLProperty(String name) throws PropertyNotFoundException {
        Property prop = (Property)this.m_properties.get(name);
        if (prop == null) {
            throw new PropertyNotFoundException();
        }
        return prop.getURLValue();
    }

    public Class getClassProperty(String name, Class defl) {
        Property prop = (Property)this.m_properties.get(name);
        if (prop == null) {
            return defl;
        }
        return prop.getClassValue();
    }

    public Class getClassProperty(String name, String defl) {
        Property prop = (Property)this.m_properties.get(name);
        if (prop == null) {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass(defl);
            }
            catch (ClassNotFoundException ex) {
                String msg = "Unable to load default class \"" + defl + "\"";
                this.getLogger().error(msg, ex);
                throw ExceptionTool.initCause(new INITIALIZE(msg + " (" + ex + ")"), (Throwable)ex);
            }
        }
        return prop.getClassValue();
    }

    public Class getClassProperty(String name) throws PropertyNotFoundException {
        Property prop = (Property)this.m_properties.get(name);
        if (prop == null) {
            throw new PropertyNotFoundException();
        }
        return prop.getClassValue();
    }

    private Logger getLogger() {
        return this.m_logger;
    }
}

