/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.taskDemo;

import EDU.oswego.cs.dl.util.concurrent.FJTask;
import EDU.oswego.cs.dl.util.concurrent.FJTaskRunnerGroup;

class NQueens
extends FJTask {
    static int boardSize;
    static final Result result;
    final int[] sofar;

    static {
        result = new Result();
    }

    public static void main(String[] args) {
        try {
            int procs;
            try {
                procs = Integer.parseInt(args[0]);
                boardSize = Integer.parseInt(args[1]);
            }
            catch (Exception e) {
                System.out.println("Usage: java NQueens <threads> <boardSize>");
                return;
            }
            if (boardSize <= 3) {
                System.out.println("There is no solution for board size <= 3");
                return;
            }
            FJTaskRunnerGroup g = new FJTaskRunnerGroup(procs);
            NQueens f = new NQueens(new int[0]);
            g.execute(f);
            int[] board = result.await();
            g.stats();
            System.out.print("Result:");
            int i = 0;
            while (i < board.length) {
                System.out.print(" " + board[i]);
                ++i;
            }
            System.out.println();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    NQueens(int[] a) {
        this.sofar = a;
    }

    public void run() {
        if (result.get() == null) {
            int row = this.sofar.length;
            if (row >= boardSize) {
                result.set(this.sofar);
            } else {
                int q = 0;
                while (q < boardSize) {
                    boolean attacked = false;
                    int i = 0;
                    while (i < row) {
                        int p = this.sofar[i];
                        if (q == p || q == p - (row - i) || q == p + (row - i)) {
                            attacked = true;
                            break;
                        }
                        ++i;
                    }
                    if (!attacked) {
                        int[] next = new int[row + 1];
                        int k = 0;
                        while (k < row) {
                            next[k] = this.sofar[k];
                            ++k;
                        }
                        next[row] = q;
                        new NQueens(next).fork();
                    }
                    ++q;
                }
            }
        }
    }

    static final class Result {
        private int[] board = null;

        Result() {
        }

        synchronized int[] get() {
            return this.board;
        }

        synchronized void set(int[] b) {
            if (this.board == null) {
                this.board = b;
                this.notifyAll();
            }
        }

        synchronized int[] await() throws InterruptedException {
            while (this.board == null) {
                this.wait();
            }
            return this.board;
        }
    }
}

