/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Sync;

public class CondVar {
    protected final Sync mutex_;

    public CondVar(Sync mutex) {
        this.mutex_ = mutex;
    }

    public void await() throws InterruptedException {
        block15: {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            try {
                CondVar condVar = this;
                synchronized (condVar) {
                    this.mutex_.release();
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        this.notify();
                        throw ex;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                boolean interrupted = false;
                while (true) {
                    try {
                        this.mutex_.acquire();
                    }
                    catch (InterruptedException ex) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
            Object var4_7 = null;
            boolean interrupted = false;
            while (true) {
                try {
                    this.mutex_.acquire();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            if (!interrupted) break block15;
            Thread.currentThread().interrupt();
        }
    }

    public boolean timedwait(long msecs) throws InterruptedException {
        boolean success;
        block16: {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            success = false;
            try {
                CondVar condVar = this;
                synchronized (condVar) {
                    this.mutex_.release();
                    try {
                        if (msecs > 0L) {
                            long start = System.currentTimeMillis();
                            this.wait(msecs);
                            success = System.currentTimeMillis() - start <= msecs;
                        }
                    }
                    catch (InterruptedException ex) {
                        this.notify();
                        throw ex;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                boolean interrupted = false;
                while (true) {
                    try {
                        this.mutex_.acquire();
                    }
                    catch (InterruptedException ex) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
            Object var7_10 = null;
            boolean interrupted = false;
            while (true) {
                try {
                    this.mutex_.acquire();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            if (!interrupted) break block16;
            Thread.currentThread().interrupt();
        }
        return success;
    }

    public synchronized void signal() {
        this.notify();
    }

    public synchronized void broadcast() {
        this.notifyAll();
    }
}

