/*
 * Decompiled with CFR 0.152.
 */
package com.codestreet.selector.parser;

import com.codestreet.selector.parser.IExpression;
import com.codestreet.selector.parser.IExpressionString;
import com.codestreet.selector.parser.IValueProvider;
import com.codestreet.selector.parser.Result;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

class OpLIKE
implements IExpressionString {
    private final IExpression lhs_;
    private final IExpression esc_;
    private final IExpression pattern_;
    private final Pattern compiledPattern_;

    public OpLIKE(IExpression lhs, IExpression pattern, IExpression escape) {
        this.lhs_ = lhs;
        this.pattern_ = pattern;
        this.esc_ = escape;
        String esc = null;
        if (this.esc_ != null && (esc = ((String)this.esc_.eval(null)).trim()).length() != 1) {
            throw new IllegalStateException("ESCAPE pattern must be one character: ;" + esc + "'");
        }
        try {
            this.compiledPattern_ = OpLIKE.compilePattern((String)pattern.eval(null), esc);
        }
        catch (PatternSyntaxException ex) {
            throw new IllegalStateException("Invalid match pattern: " + pattern);
        }
    }

    public Object eval(Map identifiers) {
        Object oLhs = this.lhs_.eval(identifiers);
        if (!(oLhs instanceof String)) {
            return Result.RESULT_UNKNOWN;
        }
        return this.compiledPattern_.matcher((String)oLhs).matches() ? Result.RESULT_TRUE : Result.RESULT_FALSE;
    }

    public Object eval(IValueProvider provider, Object corr) {
        Object oLhs = this.lhs_.eval(provider, corr);
        if (!(oLhs instanceof String)) {
            return Result.RESULT_UNKNOWN;
        }
        return this.compiledPattern_.matcher((String)oLhs).matches() ? Result.RESULT_TRUE : Result.RESULT_FALSE;
    }

    public String toString() {
        if (this.esc_ != null) {
            return this.lhs_.toString() + " LIKE '" + this.pattern_.toString() + "'";
        }
        return this.lhs_.toString() + " LIKE '" + this.pattern_.toString() + "' ESCAPE '" + this.esc_.toString() + "'";
    }

    private static Pattern compilePattern(String pattern, String esc) {
        String regExp = null;
        if (esc == null) {
            regExp = pattern.replaceAll("_", ".{1}").replaceAll("%", ".*");
        } else {
            char cEsc = '\u0000';
            StringBuffer buf = new StringBuffer();
            cEsc = esc.charAt(0);
            for (int i = 0; i < pattern.length(); ++i) {
                char nextChar = pattern.charAt(i);
                if (nextChar != cEsc) {
                    if (nextChar == '_') {
                        buf.append(".{1}");
                        continue;
                    }
                    if (nextChar == '%') {
                        buf.append(".*");
                        continue;
                    }
                    buf.append(nextChar);
                    continue;
                }
                buf.append('\\');
                if (++i >= pattern.length()) continue;
                buf.append(pattern.charAt(i));
            }
            regExp = buf.toString();
        }
        return Pattern.compile(regExp);
    }
}

