/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.io.IOException;
import java.util.TooManyListenersException;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_MEMORY;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.UnknownException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.ServiceContext;
import org.omg.Messaging.SyncScopePolicy;
import org.openorb.CORBA.ORB;
import org.openorb.CORBA.ObjectStub;
import org.openorb.CORBA.SystemExceptionHelper;
import org.openorb.PI.ClientManager;
import org.openorb.PI.RequestCallback;
import org.openorb.iiop.CDROutputStream;
import org.openorb.iiop.IIOPClientChannel;
import org.openorb.io.BufferSource;
import org.openorb.net.AbstractClientRequest;
import org.openorb.net.Address;
import org.openorb.util.Trace;

class IIOPClientRequest
extends AbstractClientRequest {
    private static final short REPLY_STATUS_UNSET = Short.MIN_VALUE;
    private IIOPClientChannel m_channel;
    private boolean m_response_expected;
    private String m_operation;
    private short m_sync_scope;
    private ClientManager m_client_manager = null;
    private RequestCallback m_callback = null;
    private java.lang.Object m_sync_state = new java.lang.Object();
    private int m_state = 0;
    private OutputStream m_request_stream;
    private short m_reply_status = Short.MIN_VALUE;
    private ServiceContext[] m_reply_service_contexts;
    private InputStream m_response_stream;
    private boolean m_response_arrived = false;
    private boolean m_last_response_arrived = false;
    private Object m_forward_reference;
    private IOR m_forward_reference_ior;
    private SystemException m_received_exception;
    private Any m_received_exception_any = null;
    private String m_received_exception_id;
    private BufferSource m_reply_source = null;

    IIOPClientRequest(int req_id, Object target, Address address, java.lang.Object tpAssc, IIOPClientChannel channel, String operation, boolean response_expected) {
        super(req_id, target, address, tpAssc, channel);
        this.m_channel = channel;
        this.m_operation = operation;
        this.m_response_expected = response_expected;
        if (this.m_response_expected) {
            this.m_sync_scope = (short)3;
        } else {
            this.m_sync_scope = (short)2;
            if (this.requestPolicyExists(24)) {
                try {
                    SyncScopePolicy pol = (SyncScopePolicy)this.get_request_policy(24);
                    if (null != pol) {
                        this.m_sync_scope = pol.synchronization();
                    }
                }
                catch (INV_POLICY ex) {
                    // empty catch block
                }
            }
        }
        this.m_client_manager = (ClientManager)((ORB)this.orb()).getFeature("ClientInterceptorManager");
        if (this.m_client_manager != null) {
            this.m_callback = new IIOPRequestCallback();
        }
    }

    IIOPClientRequest(int req_id, Object target, Address address, java.lang.Object tpAssc, IIOPClientChannel channel) {
        super(req_id, target, address, tpAssc, channel);
        this.m_channel = channel;
        this.m_operation = null;
        this.m_response_expected = true;
        this.m_sync_scope = (short)-1;
    }

    public int state() {
        return this.m_state;
    }

    public boolean is_request() {
        return this.m_operation != null;
    }

    public boolean is_locate() {
        return this.m_operation == null;
    }

    public boolean is_poll() {
        return false;
    }

    public short sync_scope() {
        return this.m_sync_scope;
    }

    public boolean response_expected() {
        return this.m_response_expected;
    }

    public String operation() {
        return this.m_operation == null ? "" : this.m_operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(SystemException ex) {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_state == 4) {
                return false;
            }
            switch (this.m_state) {
                case 1: {
                    this.m_reply_status = 1;
                    this.m_state = 4;
                    ex.completed = CompletionStatus.COMPLETED_NO;
                    this.handle_system_exception(ex);
                    if (this.m_client_manager != null) {
                        this.m_client_manager.receive_exception(this, this.m_callback);
                        this.m_client_manager = null;
                    }
                    if (this.m_request_stream instanceof CDROutputStream) {
                        try {
                            ((CDROutputStream)this.m_request_stream).cancel(ex);
                        }
                        catch (SystemException ex1) {}
                        break;
                    }
                    this.m_channel.cancel_request(this, true);
                    break;
                }
                case 2: {
                    if (this.m_reply_source != null) {
                        ex.completed = CompletionStatus.COMPLETED_YES;
                        this.m_reply_source.setException(ex);
                        break;
                    }
                    this.m_state = 4;
                    ex.completed = this.m_channel.cancel_request(this, true) ? CompletionStatus.COMPLETED_MAYBE : CompletionStatus.COMPLETED_NO;
                    this.handle_system_exception(ex);
                    if (this.m_client_manager != null) {
                        this.m_client_manager.receive_exception(this, this.m_callback);
                        this.m_client_manager = null;
                    }
                    this.m_sync_state.notifyAll();
                    break;
                }
                case 3: {
                    ex.completed = CompletionStatus.COMPLETED_YES;
                    this.m_reply_source.setException(ex);
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.omg.CORBA.portable.OutputStream begin_marshal() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            switch (this.m_state) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
                }
                case 4: {
                    return null;
                }
                default: {
                    Trace.signalIllegalCondition(this.getLogger(), "Invalid state of the state machine.");
                }
            }
            if (this.m_client_manager != null) {
                this.m_client_manager.send_request(this, this.m_callback);
                if (this.m_reply_status != Short.MIN_VALUE) {
                    this.m_state = 4;
                    this.m_channel.cancel_request(this, false);
                    return null;
                }
            }
            try {
                this.m_request_stream = this.m_channel.begin_marshal(this);
            }
            catch (SystemException ex) {
                this.m_state = 4;
                ex.completed = CompletionStatus.COMPLETED_NO;
                this.handle_system_exception(ex);
                if (this.m_client_manager != null) {
                    this.m_client_manager.receive_exception(this, this.m_callback);
                    this.m_client_manager = null;
                }
                return null;
            }
            if (this.m_state == 0) {
                this.m_state = 1;
                return this.m_request_stream;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send_request() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            block15: {
                switch (this.m_state) {
                    case 1: {
                        break;
                    }
                    case 0: 
                    case 3: {
                        throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
                    }
                    case 2: 
                    case 4: {
                        return this.m_state;
                    }
                    default: {
                        Trace.signalIllegalCondition(this.getLogger(), "Invalid state of the state machine.");
                    }
                }
                try {
                    this.m_request_stream.close();
                    this.m_state = 2;
                }
                catch (SystemException ex) {
                    if (this.m_state != 4) {
                        this.m_state = 4;
                        ex.completed = CompletionStatus.COMPLETED_NO;
                        this.handle_system_exception((SystemException)ex.fillInStackTrace());
                        if (this.m_client_manager != null) {
                            this.m_client_manager.receive_exception(this, this.m_callback);
                            this.m_client_manager = null;
                        }
                    }
                }
                catch (IOException ex) {
                    if (!this.getLogger().isErrorEnabled()) break block15;
                    this.getLogger().error("Error while closing RequestStream.", ex);
                }
            }
            if (this.m_sync_scope != 0 || this.m_state == 4) {
                return this.m_state;
            }
            this.m_state = 4;
            this.m_reply_status = 0;
            if (this.m_client_manager != null) {
                this.m_client_manager.receive_reply(this, this.m_callback);
                this.m_client_manager = null;
            }
            this.m_response_stream = (InputStream)this.orb().create_output_stream().create_input_stream();
            this.m_reply_service_contexts = new ServiceContext[0];
        }
        this.m_channel.cancel_request(this, false);
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean poll_response() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            switch (this.m_state) {
                case 2: {
                    return this.m_response_arrived;
                }
                case 0: 
                case 1: {
                    throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
                }
                case 3: 
                case 4: {
                    return true;
                }
            }
            Trace.signalIllegalCondition(this.getLogger(), "Invalid state of the state machine.");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int wait_for_response(long timeout) {
        var3_2 = this.m_sync_state;
        synchronized (var3_2) {
            switch (this.m_state) {
                case 2: {
                    break;
                }
                case 0: 
                case 1: {
                    throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
                }
                case 3: 
                case 4: {
                    return this.m_state;
                }
                default: {
                    Trace.signalIllegalCondition(this.getLogger(), "Invalid state of the state machine.");
                }
            }
            if (!this.m_response_arrived) {
                try {
                    this.m_sync_state.wait(timeout <= 0L ? 0L : timeout);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                switch (this.m_state) {
                    case 2: {
                        if (this.m_response_arrived) break;
                        return this.m_state;
                    }
                    case 3: 
                    case 4: {
                        return this.m_state;
                    }
                    default: {
                        Trace.signalIllegalCondition(this.getLogger(), "Invalid state of the state machine.");
                    }
                }
            }
            this.m_response_arrived = false;
            switch (this.m_reply_status) {
                case 0: {
                    if (this.m_last_response_arrived) break;
                    this.m_state = 3;
                    return this.m_state;
                }
                case 2: {
                    this.m_response_stream.mark(0);
                    this.m_received_exception_id = this.m_response_stream.read_string();
                    try {
                        this.m_response_stream.reset();
                    }
                    catch (IOException ex) {
                        if (!this.getLogger().isErrorEnabled()) ** GOTO lbl44
                        this.getLogger().error("Error while resetting RequestStream.", ex);
                    }
lbl44:
                    // 3 sources

                    if (this.m_last_response_arrived) break;
                    this.m_state = 3;
                    return this.m_state;
                }
                case 1: {
                    this.m_received_exception_id = this.m_response_stream.read_string();
                    this.m_received_exception = SystemExceptionHelper.create(this.m_received_exception_id, "Server Exception", this.m_response_stream.read_ulong(), CompletionStatus.from_int(this.m_response_stream.read_ulong()));
                    this.m_received_exception_any = null;
                    break;
                }
                case 3: {
                    this.m_forward_reference_ior = IORHelper.read(this.m_response_stream);
                    this.m_forward_reference = null;
                }
                case -2: 
                case -1: 
                case 4: {
                    break;
                }
                default: {
                    Trace.signalIllegalCondition(this.getLogger(), "Invalid state of the state machine.");
                }
            }
            if (!this.m_last_response_arrived) {
                Trace.signalIllegalCondition(this.getLogger(), "Last response arrived.");
            }
            this.m_state = 3;
            this.lastReplyMessage(this.m_reply_source);
            return this.m_state;
        }
    }

    public org.omg.CORBA.portable.InputStream receive_response() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            switch (this.m_state) {
                case 3: 
                case 4: {
                    return this.m_response_stream;
                }
            }
            throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
        }
    }

    private void handle_system_exception(SystemException ex) {
        this.m_received_exception_any = null;
        this.m_received_exception = ex;
        this.m_received_exception_id = SystemExceptionHelper.id(ex);
        this.m_reply_status = 1;
    }

    private void handle_location_forward(Object forward, boolean permanent) {
        this.m_forward_reference = forward;
        this.m_forward_reference_ior = null;
        this.m_reply_status = (short)3;
    }

    void setReplySource(BufferSource replySource) {
        block3: {
            if (this.m_reply_source != null) {
                this.m_reply_source.setException(new MARSHAL("Multiple replies received", 0, CompletionStatus.COMPLETED_YES));
                return;
            }
            this.m_reply_source = replySource;
            try {
                this.m_reply_source.addLastMessageProcessedListener(new BufferSource.LastMessageProcessedListener(){

                    public void lastMessageProcessed(BufferSource source) {
                        IIOPClientRequest.this.lastReplyMessage(source);
                    }
                });
            }
            catch (TooManyListenersException ex) {
                if (!this.getLogger().isErrorEnabled()) break block3;
                this.getLogger().error("Unable to handle too many listeners", ex);
            }
        }
    }

    BufferSource getReplySource() {
        return this.m_reply_source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handle_reply(int reply_status, ServiceContext[] reply_service_contexts, InputStream response_stream) {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            this.m_reply_service_contexts = reply_service_contexts;
            this.m_response_stream = response_stream;
            this.m_response_arrived = true;
            if (this.m_operation == null) {
                switch (reply_status) {
                    case 1: {
                        this.m_reply_status = (short)-1;
                        break;
                    }
                    case 0: {
                        this.m_reply_status = (short)-2;
                        break;
                    }
                    case 4: {
                        this.m_reply_status = 1;
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.m_reply_status = (short)3;
                        break;
                    }
                    case 5: {
                        this.m_reply_status = (short)4;
                    }
                }
            } else {
                switch (reply_status) {
                    case 0: {
                        this.m_reply_status = 0;
                        break;
                    }
                    case 1: {
                        this.m_reply_status = (short)2;
                        break;
                    }
                    case 2: {
                        this.m_reply_status = 1;
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.m_reply_status = (short)3;
                        break;
                    }
                    case 5: {
                        this.m_reply_status = (short)4;
                    }
                }
            }
            this.m_sync_state.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lastReplyMessage(BufferSource source) {
        SystemException ex = source.getException();
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            boolean notify = false;
            this.m_last_response_arrived = true;
            if (this.m_state == 2) {
                if (ex == null) {
                    return;
                }
                notify = true;
            }
            this.m_state = 4;
            if (ex != null) {
                this.handle_system_exception(ex);
            }
            if (this.m_client_manager != null) {
                switch (this.m_reply_status) {
                    case 0: {
                        this.m_client_manager.receive_reply(this, this.m_callback);
                        break;
                    }
                    case 1: 
                    case 2: {
                        this.m_client_manager.receive_exception(this, this.m_callback);
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.m_client_manager.receive_other(this, this.m_callback);
                        break;
                    }
                    case -2: 
                    case -1: {
                        break;
                    }
                    default: {
                        Trace.signalIllegalCondition(this.getLogger(), "Invalid state of the state machine.");
                    }
                }
                if (this.m_reply_status == 1) {
                    source.setException(this.m_received_exception);
                }
            }
            if (notify) {
                this.m_response_arrived = true;
                this.m_sync_state.notifyAll();
            }
        }
    }

    public short reply_status() {
        if (this.m_reply_status == Short.MIN_VALUE) {
            throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
        }
        return this.m_reply_status;
    }

    public ServiceContext get_reply_service_context(int id) {
        if (this.m_reply_service_contexts == null) {
            throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
        }
        switch (this.m_state) {
            case 3: 
            case 4: {
                int i = 0;
                while (i < this.m_reply_service_contexts.length) {
                    if (this.m_reply_service_contexts[i].context_id == id) {
                        return this.m_reply_service_contexts[i];
                    }
                    ++i;
                }
                throw new BAD_PARAM(1330446359, this.state_completion_status());
            }
        }
        throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
    }

    public Object forward_reference() {
        switch (this.reply_status()) {
            case 3: {
                if (this.m_forward_reference == null) {
                    this.m_forward_reference = new ObjectStub(this.orb(), this.m_forward_reference_ior);
                }
                return this.m_forward_reference;
            }
        }
        throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
    }

    public IOR forward_reference_ior() {
        switch (this.reply_status()) {
            case 3: {
                if (this.m_forward_reference_ior == null) {
                    if (this.m_forward_reference == null || !(this.m_forward_reference instanceof ObjectImpl)) {
                        throw new INTERNAL("Forward object is unknown type");
                    }
                    Delegate deleg = ((ObjectImpl)this.m_forward_reference)._get_delegate();
                    if (deleg == null || !(deleg instanceof org.openorb.CORBA.Delegate)) {
                        throw new INTERNAL("Object delegate is unknown type");
                    }
                    this.m_forward_reference_ior = ((org.openorb.CORBA.Delegate)deleg).ior();
                }
                return this.m_forward_reference_ior;
            }
        }
        throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemException received_system_exception() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.reply_status() == 1) {
                return this.m_received_exception;
            }
        }
        throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
    }

    public Any received_exception() {
        switch (this.reply_status()) {
            case 1: {
                if (this.m_received_exception_any == null) {
                    this.m_received_exception_any = this.orb().create_any();
                    SystemExceptionHelper.insert(this.m_received_exception_any, this.m_received_exception);
                }
                return this.m_received_exception_any;
            }
            case 2: {
                throw new NO_RESOURCES(1330446337, this.state_completion_status());
            }
        }
        throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
    }

    public String received_exception_id() {
        switch (this.reply_status()) {
            case 1: 
            case 2: {
                return this.m_received_exception_id;
            }
        }
        throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            java.lang.Object object = this.m_sync_state;
            synchronized (object) {
                if (this.m_state != 4) {
                    this.cancel(new TIMEOUT());
                }
            }
            java.lang.Object var4_3 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var4_4 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    private class IIOPRequestCallback
    implements RequestCallback {
        private IIOPRequestCallback() {
        }

        public void reply_system_exception(SystemException ex) {
            IIOPClientRequest.this.handle_system_exception(ex);
        }

        public void reply_location_forward(Object forward, boolean permanent) {
            IIOPClientRequest.this.handle_location_forward(forward, permanent);
        }

        public void reply_runtime_exception(RuntimeException ex) {
            UnknownException uex = new UnknownException(ex);
            uex.completed = IIOPClientRequest.this.state_completion_status();
            IIOPClientRequest.this.handle_system_exception(uex);
        }

        public void reply_error(Error ex) {
            if (ex instanceof ThreadDeath) {
                throw ex;
            }
            if (ex instanceof OutOfMemoryError) {
                IIOPClientRequest.this.handle_system_exception(new NO_MEMORY());
            } else if (ex instanceof StackOverflowError) {
                IIOPClientRequest.this.handle_system_exception(new NO_RESOURCES("Stack Overflow", 1146056983, IIOPClientRequest.this.state_completion_status()));
            } else {
                UnknownException uex = new UnknownException(ex);
                uex.completed = IIOPClientRequest.this.state_completion_status();
                IIOPClientRequest.this.handle_system_exception(uex);
            }
        }
    }
}

