/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CODESET_INCOMPATIBLE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NVList;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.Principal;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.ORB;
import org.omg.GIOP.Version;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.SendingContext.RunTime;
import org.openorb.CORBA.DataInputStream;
import org.openorb.CORBA.Delegate;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.CORBA.ObjectStub;
import org.openorb.iiop.CodeSetDatabase;
import org.openorb.io.AbstractInputStream;
import org.openorb.io.BufferSource;
import org.openorb.io.HexPrintStream;
import org.openorb.io.StorageBuffer;
import org.openorb.util.ExceptionTool;
import org.openorb.util.NumberCache;
import org.openorb.util.RepoIDHelper;
import org.openorb.util.Trace;

public class CDRInputStream
extends AbstractInputStream
implements LogEnabled {
    private static final int CODEBASE = 1;
    private static final int NO_TYPE_INFORMATION = 0;
    private static final int SINGLE_TYPE_INFORMATION = 2;
    private static final int MULTIPLE_TYPE_INFORMATION = 6;
    private static final int MASK_TYPE_INFORMATION = 6;
    private static final int CHUNK = 8;
    private org.omg.CORBA.ORB m_orb;
    private Version m_version;
    private Map m_value_cache;
    private MarkState m_mark = null;
    private String m_char_enc = "ISO-8859-1";
    private String m_wchar_enc = "UnicodeBig";
    private int m_wchar_align = 2;
    private boolean m_wchar_reverse = false;
    private int m_index = 0;
    private boolean m_swap = false;
    private int m_encaps_remain = -1;
    private int m_pending_encaps_close = 0;
    private LinkedList m_encaps_stack = new LinkedList();
    private int m_value_level = 0;
    private boolean m_pending_value_reopen = false;
    private boolean m_in_chunked_value = false;
    private int m_value_indirect = -1;
    private int m_continue_level = 0;
    private Logger m_logger;
    private OctetSeqHolder m_tmp_buf = new OctetSeqHolder();
    private IntHolder m_tmp_off = new IntHolder();
    private IntHolder m_tmp_len = new IntHolder();
    static /* synthetic */ Class class$org$omg$CORBA$Object;

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    private Logger getLogger() {
        if (null == this.m_logger) {
            this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
        }
        return this.m_logger;
    }

    public CDRInputStream(org.omg.CORBA.ORB orb, boolean bigEndian, Version version, StorageBuffer buf) {
        super(buf);
        this.m_orb = orb;
        this.bigEndian(bigEndian);
        this.m_version = version;
        if (this.m_version.minor == 0) {
            this.m_char_enc = "ISO-8859-1";
            this.m_wchar_enc = null;
        }
    }

    public CDRInputStream(org.omg.CORBA.ORB orb, boolean bigEndian, Version version, BufferSource source) {
        super(source);
        this.m_orb = orb;
        this.bigEndian(bigEndian);
        this.m_version = version;
        if (this.m_version.minor == 0) {
            this.m_char_enc = "ISO-8859-1";
            this.m_wchar_enc = null;
        }
    }

    public org.omg.CORBA.ORB orb() {
        return this.m_orb;
    }

    public void setCodesets(int tcsc, int tcsw) {
        if (tcsc != 0) {
            this.m_char_enc = CodeSetDatabase.getNameFromId(tcsc);
            if (CodeSetDatabase.getAlignmentFromId(tcsc) > 1) {
                throw new CODESET_INCOMPATIBLE(0, CompletionStatus.COMPLETED_NO);
            }
        }
        if (tcsw == 0) {
            this.m_wchar_enc = null;
        } else {
            this.m_wchar_enc = CodeSetDatabase.getNameFromId(tcsw);
            if (this.m_wchar_enc.equals("UnicodeBigUnmarked")) {
                this.m_wchar_enc = "UnicodeBig";
            }
            this.m_wchar_align = CodeSetDatabase.getAlignmentFromId(tcsw);
            if (this.m_version.minor == 1 && this.m_wchar_align != 2) {
                throw new CODESET_INCOMPATIBLE(0, CompletionStatus.COMPLETED_NO);
            }
            if (this.m_swap && this.m_wchar_align > 1) {
                String canonical = CodeSetDatabase.getCanonicalNameFromId(tcsw);
                if (canonical.startsWith("Unicode")) {
                    if (this.m_version.minor == 1) {
                        this.m_wchar_enc = "UnicodeLittle";
                    }
                } else {
                    this.m_wchar_reverse = true;
                }
            }
        }
        if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug("New codesets for input stream set to [" + this.m_char_enc + "] and [" + this.m_wchar_enc + "].");
        }
    }

    public int index() {
        return this.m_index;
    }

    public void reset_index() {
        this.m_index = 0;
    }

    public Version version() {
        return this.m_version;
    }

    public boolean bigEndian() {
        return !this.m_swap;
    }

    public void bigEndian(boolean bigEndian) {
        this.m_swap = !bigEndian;
    }

    public void alignment(int size) {
        int tmp;
        if (this.m_pending_value_reopen) {
            this.m_pending_value_reopen = false;
            int len = this.peek_long();
            if (len < 0x7FFFFF00 || len > Integer.MAX_VALUE) {
                this.begin_value_chunk(this.read_long());
            }
        }
        if (size > 1 && (tmp = this.m_index % size) != 0) {
            this.force_skip(size - tmp);
        }
    }

    public void begin_encapsulation() {
        int len = this.read_ulong();
        this.m_encaps_stack.addLast(this.m_swap ? Boolean.TRUE : Boolean.FALSE);
        this.m_encaps_stack.addLast(NumberCache.getInteger(this.m_encaps_remain));
        this.m_encaps_stack.addLast(NumberCache.getInteger(this.m_index));
        this.m_encaps_stack.addLast(Boolean.FALSE);
        this.m_encaps_remain = len;
        this.m_in_chunked_value = false;
        this.m_swap = this.read_boolean();
    }

    public void end_encapsulation() {
        if (this.m_pending_encaps_close == 0) {
            this.force_skip(this.m_encaps_remain);
        }
        --this.m_pending_encaps_close;
    }

    public long skip(long count) {
        long total = super.skip(count);
        this.postread((int)total);
        return total;
    }

    public void mark(int readlimit) {
        super.mark(readlimit);
        this.m_mark = new MarkState();
    }

    public void reset() throws IOException {
        super.reset();
        this.m_mark.reset();
        this.m_mark = null;
    }

    public boolean read_boolean() {
        return this.read_octet() == 1;
    }

    public char read_char() {
        this.alignment(1);
        this.m_tmp_len.value = 1;
        this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
        this.postread(1);
        try {
            String s = new String(this.m_tmp_buf.value, this.m_tmp_off.value, 1, this.m_char_enc);
            if (s.length() == 1) {
                return s.charAt(0);
            }
            this.cancel(new MARSHAL("Unable to decode char value", 1146056976, CompletionStatus.COMPLETED_MAYBE));
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().error("Unsupported encoding should be impossible.", ex);
        }
        return '\u0000';
    }

    public char read_wchar() {
        if (this.m_wchar_enc == null) {
            if (this.m_version.minor == 0) {
                this.cancel(new BAD_OPERATION("Wchar not supported in IIOP 1.0", 1146056961, CompletionStatus.COMPLETED_MAYBE));
            } else {
                this.cancel(new MARSHAL("Missing wchar encoder.", 1146056977, CompletionStatus.COMPLETED_MAYBE));
            }
            return '\u0000';
        }
        byte[] buf = null;
        int off = 0;
        int len = 0;
        switch (this.m_version.minor) {
            case 0: {
                this.cancel(new BAD_OPERATION("Wchar not supported in IIOP 1.0", 1146056961, CompletionStatus.COMPLETED_MAYBE));
                return '\u0000';
            }
            case 1: {
                this.alignment(2);
                this.m_tmp_len.value = 2;
                len = 2;
                this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
                if (this.m_tmp_len.value != 0) {
                    buf = new byte[2];
                    if (this.m_wchar_reverse) {
                        buf[1] = this.m_tmp_buf.value[this.m_tmp_off.value];
                        this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
                        buf[0] = this.m_tmp_buf.value[this.m_tmp_off.value];
                    } else {
                        buf[0] = this.m_tmp_buf.value[this.m_tmp_off.value];
                        this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
                        buf[1] = this.m_tmp_buf.value[this.m_tmp_off.value];
                    }
                    off = 0;
                } else if (this.m_wchar_reverse) {
                    buf = new byte[]{this.m_tmp_buf.value[1], this.m_tmp_buf.value[0]};
                    off = 0;
                } else {
                    buf = this.m_tmp_buf.value;
                    off = this.m_tmp_off.value;
                }
                this.postread(2);
                break;
            }
            case 2: {
                this.alignment(1);
                this.m_tmp_len.value = 1;
                this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
                len = this.m_tmp_len.value = this.m_tmp_buf.value[this.m_tmp_off.value];
                this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
                this.postread(len - this.m_tmp_len.value + 1);
                if (this.m_tmp_len.value != 0) {
                    buf = new byte[len];
                    off = 0;
                    System.arraycopy(this.m_tmp_buf.value, this.m_tmp_off.value, buf, 0, len - this.m_tmp_len.value);
                    this.read_octet_array(buf, len - this.m_tmp_len.value, this.m_tmp_len.value);
                    if (!this.m_wchar_reverse) break;
                    int i = 0;
                    while (i < this.m_wchar_align / 2) {
                        byte tmp = buf[i];
                        buf[i] = buf[this.m_wchar_align - i];
                        buf[this.m_wchar_align - i] = tmp;
                        ++i;
                    }
                    break;
                }
                if (this.m_wchar_reverse) {
                    buf = new byte[len];
                    off = 0;
                    int i = 0;
                    while (i < this.m_wchar_align) {
                        buf[i] = this.m_tmp_buf.value[this.m_tmp_off.value + this.m_wchar_align - i];
                        ++i;
                    }
                    break;
                }
                buf = this.m_tmp_buf.value;
                off = this.m_tmp_off.value;
            }
        }
        try {
            String s = new String(buf, off, len, this.m_wchar_enc);
            if (s.length() == 1) {
                return s.charAt(0);
            }
            this.cancel(new MARSHAL("Unable to decode wchar value", 1146056977, CompletionStatus.COMPLETED_MAYBE));
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().error("Unsupported encoding should be impossible.", ex);
        }
        return '\u0000';
    }

    public byte read_octet() {
        this.alignment(1);
        this.m_tmp_len.value = 1;
        this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
        byte b = this.m_tmp_buf.value[this.m_tmp_off.value];
        this.postread(1);
        return b;
    }

    public short read_short() {
        int val;
        this.alignment(2);
        this.m_tmp_len.value = 2;
        if (this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len) == 2) {
            val = (this.m_tmp_buf.value[this.m_tmp_off.value] & 0xFF) << (this.m_swap ? 0 : 8) | (this.m_tmp_buf.value[this.m_tmp_off.value + 1] & 0xFF) << (this.m_swap ? 8 : 0);
        } else {
            val = (this.m_tmp_buf.value[this.m_tmp_off.value] & 0xFF) << (this.m_swap ? 0 : 8);
            this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
            val |= (this.m_tmp_buf.value[this.m_tmp_off.value] & 0xFF) << (this.m_swap ? 8 : 0);
        }
        this.postread(2);
        return (short)val;
    }

    public short read_ushort() {
        return this.read_short();
    }

    public int read_long() {
        int val;
        this.alignment(4);
        this.m_tmp_len.value = 4;
        int got = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
        if (got == 4) {
            val = (this.m_tmp_buf.value[this.m_tmp_off.value] & 0xFF) << (this.m_swap ? 0 : 24) | (this.m_tmp_buf.value[this.m_tmp_off.value + 1] & 0xFF) << (this.m_swap ? 8 : 16) | (this.m_tmp_buf.value[this.m_tmp_off.value + 2] & 0xFF) << (this.m_swap ? 16 : 8) | (this.m_tmp_buf.value[this.m_tmp_off.value + 3] & 0xFF) << (this.m_swap ? 24 : 0);
        } else {
            val = 0;
            int shf = this.m_swap ? 0 : 24;
            while (true) {
                int i = 0;
                while (i < got) {
                    val |= (this.m_tmp_buf.value[this.m_tmp_off.value + i] & 0xFF) << shf;
                    shf += this.m_swap ? 8 : -8;
                    ++i;
                }
                if (!(this.m_swap ? shf < 24 : shf > 0)) break;
                got = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
            }
        }
        this.postread(4);
        return val;
    }

    private int peek_long() {
        this.mark(4);
        int ret = this.read_long();
        try {
            this.reset();
        }
        catch (IOException ex) {
            this.getLogger().error("IOException during reset().", ex);
        }
        return ret;
    }

    public int read_ulong() {
        return this.read_long();
    }

    public long read_longlong() {
        long val;
        this.alignment(8);
        this.m_tmp_len.value = 8;
        int got = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
        if (got == 8) {
            val = ((long)this.m_tmp_buf.value[this.m_tmp_off.value] & 0xFFL) << (int)(this.m_swap ? 0L : 56L) | ((long)this.m_tmp_buf.value[this.m_tmp_off.value + 1] & 0xFFL) << (int)(this.m_swap ? 8L : 48L) | ((long)this.m_tmp_buf.value[this.m_tmp_off.value + 2] & 0xFFL) << (int)(this.m_swap ? 16L : 40L) | ((long)this.m_tmp_buf.value[this.m_tmp_off.value + 3] & 0xFFL) << (int)(this.m_swap ? 24L : 32L) | ((long)this.m_tmp_buf.value[this.m_tmp_off.value + 4] & 0xFFL) << (int)(this.m_swap ? 32L : 24L) | ((long)this.m_tmp_buf.value[this.m_tmp_off.value + 5] & 0xFFL) << (int)(this.m_swap ? 40L : 16L) | ((long)this.m_tmp_buf.value[this.m_tmp_off.value + 6] & 0xFFL) << (int)(this.m_swap ? 48L : 8L) | ((long)this.m_tmp_buf.value[this.m_tmp_off.value + 7] & 0xFFL) << (int)(this.m_swap ? 56L : 0L);
        } else {
            val = 0L;
            long shf = this.m_swap ? 0L : 56L;
            while (true) {
                int i = 0;
                while (i < got) {
                    val |= (long)(this.m_tmp_buf.value[this.m_tmp_off.value + i] & 0xFF) << (int)shf;
                    shf += this.m_swap ? 8L : -8L;
                    ++i;
                }
                if (!(this.m_swap ? shf < 56L : shf > 0L)) break;
                got = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
            }
        }
        this.postread(8);
        return val;
    }

    public long read_ulonglong() {
        return this.read_longlong();
    }

    public float read_float() {
        return Float.intBitsToFloat(this.read_long());
    }

    public double read_double() {
        return Double.longBitsToDouble(this.read_longlong());
    }

    public String read_string() {
        int off;
        byte[] buf;
        int len;
        this.m_tmp_len.value = len = this.read_ulong();
        this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
        this.postread(len - this.m_tmp_len.value);
        if (this.m_tmp_len.value == 0) {
            buf = this.m_tmp_buf.value;
            off = this.m_tmp_off.value;
        } else {
            buf = new byte[len];
            off = 0;
            System.arraycopy(this.m_tmp_buf.value, this.m_tmp_off.value, buf, 0, len - this.m_tmp_len.value);
            this.read_octet_array(buf, len - this.m_tmp_len.value, this.m_tmp_len.value);
        }
        try {
            return new String(buf, off, len - 1, this.m_char_enc);
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().error("Unsupported encoding should be impossible.", ex);
            return null;
        }
    }

    public String read_wstring() {
        int off;
        byte[] buf;
        if (this.m_version.minor == 0) {
            this.cancel(new BAD_OPERATION("Wchar not supported in IIOP 1.0", 1146056961, CompletionStatus.COMPLETED_MAYBE));
            return null;
        }
        if (this.m_wchar_enc == null) {
            this.cancel(new MARSHAL("Missing wchar encoder.", 1146056977, CompletionStatus.COMPLETED_MAYBE));
            return null;
        }
        int len = this.read_ulong();
        if (this.m_version.minor == 1 && this.m_wchar_align > 1) {
            len *= this.m_wchar_align;
        }
        this.m_tmp_len.value = len;
        this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
        this.postread(len - this.m_tmp_len.value);
        if (this.m_tmp_len.value != 0) {
            buf = new byte[len];
            off = 0;
            System.arraycopy(this.m_tmp_buf.value, this.m_tmp_off.value, buf, 0, len - this.m_tmp_len.value);
            this.read_octet_array(buf, len - this.m_tmp_len.value, this.m_tmp_len.value);
            if (this.m_wchar_reverse) {
                int i = 0;
                while (i < len) {
                    int j = 0;
                    while (j < this.m_wchar_align / 2) {
                        byte tmp = buf[off + i + j];
                        buf[off + i + j] = buf[off + i + this.m_wchar_align - j];
                        buf[off + i + this.m_wchar_align - j] = tmp;
                        ++j;
                    }
                    i += this.m_wchar_align;
                }
            }
        } else if (this.m_wchar_reverse) {
            buf = new byte[len];
            off = 0;
            int i = 0;
            while (i < len) {
                int j = 0;
                while (j < this.m_wchar_align) {
                    buf[i + j] = this.m_tmp_buf.value[this.m_tmp_off.value + i + this.m_wchar_align - j];
                    ++j;
                }
                i += this.m_wchar_align;
            }
        } else {
            buf = this.m_tmp_buf.value;
            off = this.m_tmp_off.value;
        }
        if (this.m_version.minor == 1) {
            len -= this.m_wchar_align == 0 ? 1 : this.m_wchar_align;
        }
        if (buf[off] == -2 && buf[off + 1] == -1 || buf[off] == -1 && buf[off + 1] == -2) {
            off += 2;
            len -= 2;
        }
        if (len == 0) {
            return "";
        }
        try {
            return new String(buf, off, len, this.m_wchar_enc);
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().error("Unsupported encoding should be impossible.", ex);
            return null;
        }
    }

    public void read_boolean_array(boolean[] val, int off, int len) {
        this.alignment(1);
        this.m_tmp_len.value = len;
        while (this.m_tmp_len.value > 0) {
            int rd = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
            int i = 0;
            while (i < rd) {
                val[off + i] = this.m_tmp_buf.value[this.m_tmp_off.value + i] == 1;
                ++i;
            }
            off += rd;
        }
        this.postread(len);
    }

    public void read_char_array(char[] val, int voff, int len) {
        int off;
        byte[] buf;
        this.alignment(1);
        this.m_tmp_len.value = len;
        this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
        this.postread(len - this.m_tmp_len.value);
        if (this.m_tmp_len.value == 0) {
            buf = this.m_tmp_buf.value;
            off = this.m_tmp_off.value;
        } else {
            buf = new byte[len];
            off = 0;
            System.arraycopy(this.m_tmp_buf.value, this.m_tmp_off.value, buf, 0, len - this.m_tmp_len.value);
            this.read_octet_array(buf, len - this.m_tmp_len.value, this.m_tmp_len.value);
        }
        try {
            String s = new String(buf, off, len, this.m_char_enc);
            if (s.length() != len) {
                this.cancel(new MARSHAL("Unable to decode char value", 1146056976, CompletionStatus.COMPLETED_MAYBE));
            }
            s.getChars(0, len, val, voff);
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().error("Unsupported encoding should be impossible.", ex);
        }
    }

    public void read_wchar_array(char[] val, int voff, int vlen) {
        if (this.m_wchar_enc == null) {
            if (this.m_version.minor == 0) {
                this.cancel(new BAD_OPERATION("Wchar not supported in IIOP 1.0", 1146056961, CompletionStatus.COMPLETED_MAYBE));
            } else {
                this.cancel(new MARSHAL("Missing wchar encoder.", 1146056977, CompletionStatus.COMPLETED_MAYBE));
            }
            return;
        }
        switch (this.m_version.minor) {
            case 0: {
                this.cancel(new MARSHAL("Wchar not supported in IIOP 1.0", 1146056961, CompletionStatus.COMPLETED_MAYBE));
                break;
            }
            case 1: {
                int off;
                byte[] buf;
                this.alignment(2);
                int len = this.m_tmp_len.value = 2 * vlen;
                this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
                this.postread(len - this.m_tmp_len.value);
                if (this.m_tmp_len.value != 0) {
                    buf = new byte[len];
                    off = 0;
                    System.arraycopy(this.m_tmp_buf.value, this.m_tmp_off.value, buf, 0, len - this.m_tmp_len.value);
                    this.read_octet_array(buf, len - this.m_tmp_len.value, this.m_tmp_len.value);
                    if (this.m_wchar_reverse) {
                        int i = 0;
                        while (i < len) {
                            byte tmp = buf[i];
                            buf[i] = buf[i + 1];
                            buf[i + 1] = tmp;
                            i += 2;
                        }
                    }
                } else if (this.m_wchar_reverse) {
                    buf = new byte[len];
                    off = 0;
                    int i = 0;
                    while (i < len) {
                        buf[0] = this.m_tmp_buf.value[this.m_tmp_off.value + i + 1];
                        buf[1] = this.m_tmp_buf.value[this.m_tmp_off.value + i];
                        i += 2;
                    }
                } else {
                    buf = this.m_tmp_buf.value;
                    off = this.m_tmp_off.value;
                }
                try {
                    String s = new String(buf, off, len, this.m_wchar_enc);
                    if (s.length() != vlen) {
                        this.cancel(new MARSHAL("Unable to decode char value", 1146056976, CompletionStatus.COMPLETED_MAYBE));
                    }
                    s.getChars(0, vlen, val, voff);
                }
                catch (UnsupportedEncodingException ex) {
                    this.getLogger().error("Unsupported encoding should be impossible.", ex);
                }
                return;
            }
            case 2: {
                this.alignment(1);
                int post = 0;
                int c = 0;
                while (c < vlen) {
                    int off;
                    byte[] buf;
                    this.m_tmp_len.value = 1;
                    this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
                    int len = this.m_tmp_len.value = this.m_tmp_buf.value[this.m_tmp_off.value];
                    this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
                    if (this.m_tmp_len.value != 0) {
                        this.postread(post + len + 1 - this.m_tmp_len.value);
                        post = 0;
                        buf = new byte[len];
                        off = 0;
                        System.arraycopy(this.m_tmp_buf.value, this.m_tmp_off.value, buf, 0, len - this.m_tmp_len.value);
                        this.read_octet_array(buf, len - this.m_tmp_len.value, this.m_tmp_len.value);
                        if (this.m_wchar_reverse) {
                            int i = 0;
                            while (i < this.m_wchar_align / 2) {
                                byte tmp = buf[off + i];
                                buf[off + i] = buf[off + this.m_wchar_align - i];
                                buf[off + this.m_wchar_align - i] = tmp;
                                ++i;
                            }
                        }
                    } else if (this.m_wchar_reverse) {
                        buf = new byte[len];
                        off = 0;
                        int i = 0;
                        while (i < this.m_wchar_align) {
                            buf[i] = this.m_tmp_buf.value[this.m_tmp_off.value + this.m_wchar_align - 1];
                            ++i;
                        }
                    } else {
                        post += len + 1;
                        buf = this.m_tmp_buf.value;
                        off = this.m_tmp_off.value;
                    }
                    try {
                        String s = new String(buf, off, len, this.m_wchar_enc);
                        if (s.length() != 1) {
                            this.cancel(new MARSHAL("Unable to decode wchar value", 1146056977, CompletionStatus.COMPLETED_MAYBE));
                        }
                        val[voff + c] = s.charAt(0);
                    }
                    catch (UnsupportedEncodingException ex) {
                        this.getLogger().error("Unsupported encoding should be impossible.", ex);
                    }
                    ++c;
                }
                if (post <= 0) break;
                this.postread(post);
            }
        }
    }

    public void read_octet_array(byte[] val, int off, int len) {
        this.alignment(1);
        this.m_tmp_len.value = len;
        while (this.m_tmp_len.value > 0) {
            int rd = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
            System.arraycopy(this.m_tmp_buf.value, this.m_tmp_off.value, val, off, rd);
            off += rd;
        }
        this.postread(len);
    }

    public void read_short_array(short[] val, int off, int len) {
        this.alignment(2);
        this.m_tmp_len.value = len * 2;
        while (this.m_tmp_len.value > 0) {
            int rd = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
            int i = 0;
            while (i < rd - 1) {
                val[off] = (short)((this.m_tmp_buf.value[this.m_tmp_off.value + i] & 0xFF) << (this.m_swap ? 0 : 8) | (this.m_tmp_buf.value[this.m_tmp_off.value + i + 1] & 0xFF) << (this.m_swap ? 8 : 0));
                i += 2;
                ++off;
            }
            if (rd % 2 == 0) continue;
            int hlf = (this.m_tmp_buf.value[this.m_tmp_off.value + rd] & 0xFF) << (this.m_swap ? 0 : 8);
            int tmp = this.m_tmp_len.value;
            this.m_tmp_len.value = 1;
            this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
            val[off] = (short)(hlf | (this.m_tmp_buf.value[this.m_tmp_off.value] & 0xFF) << (this.m_swap ? 8 : 0));
            ++off;
            this.m_tmp_len.value = tmp - 1;
        }
        this.postread(len * 2);
    }

    public void read_ushort_array(short[] val, int off, int len) {
        this.read_short_array(val, off, len);
    }

    public void read_long_array(int[] val, int off, int len) {
        this.alignment(4);
        this.m_tmp_len.value = len * 4;
        while (this.m_tmp_len.value > 0) {
            int rd = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
            int i = 0;
            while (i < rd - 3) {
                val[off] = (this.m_tmp_buf.value[this.m_tmp_off.value + i] & 0xFF) << (this.m_swap ? 0 : 24) | (this.m_tmp_buf.value[this.m_tmp_off.value + i + 1] & 0xFF) << (this.m_swap ? 8 : 16) | (this.m_tmp_buf.value[this.m_tmp_off.value + i + 2] & 0xFF) << (this.m_swap ? 16 : 8) | (this.m_tmp_buf.value[this.m_tmp_off.value + i + 3] & 0xFF) << (this.m_swap ? 24 : 0);
                i += 4;
                ++off;
            }
            if (rd % 4 == 0) continue;
            val[off] = 0;
            int rcvd = rd % 4;
            rd -= rd % 4;
            int s = 0;
            while (s < rcvd) {
                val[off] = val[off] | (this.m_tmp_buf.value[this.m_tmp_off.value + rd + s] & 0xFF) << (this.m_swap ? 8 * s : 24 - 8 * s);
                ++s;
            }
            int tmp = this.m_tmp_len.value - (4 - s);
            while (s < 4) {
                this.m_tmp_len.value = 4 - s;
                rd = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
                int i2 = 0;
                while (i2 < rd) {
                    val[off] = val[off] | (this.m_tmp_buf.value[this.m_tmp_off.value + i2] & 0xFF) << (this.m_swap ? 8 * s : 24 - 8 * s);
                    ++i2;
                    ++s;
                }
            }
            this.m_tmp_len.value = tmp;
        }
        this.postread(len * 4);
    }

    public void read_ulong_array(int[] val, int off, int len) {
        this.read_long_array(val, off, len);
    }

    public void read_longlong_array(long[] val, int off, int len) {
        this.alignment(8);
        this.m_tmp_len.value = len * 8;
        while (this.m_tmp_len.value > 0) {
            int rd = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
            int i = 0;
            while (i < rd - 7) {
                val[off] = (long)(this.m_tmp_buf.value[this.m_tmp_off.value + i] & 0xFF) << (int)((long)(this.m_swap ? 0 : 56)) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + i + 1] & 0xFF) << (int)((long)(this.m_swap ? 8 : 48)) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + i + 2] & 0xFF) << (int)((long)(this.m_swap ? 16 : 40)) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + i + 3] & 0xFF) << (int)((long)(this.m_swap ? 24 : 32)) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + i + 4] & 0xFF) << (int)((long)(this.m_swap ? 32 : 24)) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + i + 5] & 0xFF) << (int)((long)(this.m_swap ? 40 : 16)) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + i + 6] & 0xFF) << (int)((long)(this.m_swap ? 48 : 8)) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + i + 7] & 0xFF) << (int)((long)(this.m_swap ? 56 : 0));
                i += 8;
                ++off;
            }
            if (rd % 8 == 0) continue;
            val[off] = 0L;
            int rcvd = rd % 8;
            rd -= rd % 8;
            int s = 0;
            while (s < rcvd) {
                val[off] = val[off] | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + rd + s] & 0xFF) << (int)((long)(this.m_swap ? 8 * s : 56 - 8 * s));
                ++s;
            }
            int tmp = this.m_tmp_len.value - (8 - s);
            while (s < 8) {
                this.m_tmp_len.value = 8 - s;
                rd = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
                int i2 = 0;
                while (i2 < rd) {
                    val[off] = val[off] | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + i2] & 0xFF) << (int)((long)(this.m_swap ? 8 * s : 56 - 8 * s));
                    ++i2;
                    ++s;
                }
            }
            this.m_tmp_len.value = tmp;
        }
        this.postread(len * 8);
    }

    public void read_ulonglong_array(long[] val, int off, int len) {
        this.read_longlong_array(val, off, len);
    }

    public void read_float_array(float[] val, int off, int len) {
        this.alignment(4);
        this.m_tmp_len.value = len * 4;
        while (this.m_tmp_len.value > 0) {
            int rd = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
            int i = 0;
            while (i < rd - 3) {
                val[off] = Float.intBitsToFloat((this.m_tmp_buf.value[this.m_tmp_off.value + i] & 0xFF) << (this.m_swap ? 0 : 24) | (this.m_tmp_buf.value[this.m_tmp_off.value + i + 1] & 0xFF) << (this.m_swap ? 8 : 16) | (this.m_tmp_buf.value[this.m_tmp_off.value + i + 2] & 0xFF) << (this.m_swap ? 16 : 8) | (this.m_tmp_buf.value[this.m_tmp_off.value + i + 3] & 0xFF) << (this.m_swap ? 24 : 0));
                i += 4;
                ++off;
            }
            if (rd % 4 == 0) continue;
            int m_tmpval = 0;
            val[off] = 0.0f;
            int rcvd = rd % 4;
            rd -= rd % 4;
            int s = 0;
            while (s < rcvd) {
                m_tmpval |= (this.m_tmp_buf.value[this.m_tmp_off.value + rd + s] & 0xFF) << (this.m_swap ? 8 * s : 24 - 8 * s);
                ++s;
            }
            val[off] = Float.intBitsToFloat(m_tmpval);
            int tmp = this.m_tmp_len.value - (4 - s);
            while (s < 4) {
                this.m_tmp_len.value = 4 - s;
                rd = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
                int i2 = 0;
                while (i2 < rd) {
                    m_tmpval |= (this.m_tmp_buf.value[this.m_tmp_off.value + i2] & 0xFF) << (this.m_swap ? 8 * s : 24 - 8 * s);
                    ++i2;
                    ++s;
                }
                val[off] = Float.intBitsToFloat(m_tmpval);
            }
            this.m_tmp_len.value = tmp;
        }
        this.postread(len * 4);
    }

    public void read_double_array(double[] val, int off, int len) {
        this.alignment(8);
        this.m_tmp_len.value = len * 8;
        while (this.m_tmp_len.value > 0) {
            int rd = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
            int i = 0;
            while (i < rd - 7) {
                val[off] = Double.longBitsToDouble((long)(this.m_tmp_buf.value[this.m_tmp_off.value + i] & 0xFF) << (int)((long)(this.m_swap ? 0 : 56)) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + i + 1] & 0xFF) << (int)((long)(this.m_swap ? 8 : 48)) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + i + 2] & 0xFF) << (int)((long)(this.m_swap ? 16 : 40)) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + i + 3] & 0xFF) << (int)((long)(this.m_swap ? 24 : 32)) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + i + 4] & 0xFF) << (int)((long)(this.m_swap ? 32 : 24)) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + i + 5] & 0xFF) << (int)((long)(this.m_swap ? 40 : 16)) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + i + 6] & 0xFF) << (int)((long)(this.m_swap ? 48 : 8)) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + i + 7] & 0xFF) << (int)((long)(this.m_swap ? 56 : 0)));
                i += 8;
                ++off;
            }
            if (rd % 8 == 0) continue;
            long tmpval = 0L;
            val[off] = 0.0;
            int rcvd = rd % 8;
            rd -= rd % 8;
            int s = 0;
            while (s < rcvd) {
                tmpval |= (long)(this.m_tmp_buf.value[this.m_tmp_off.value + rd + s] & 0xFF) << (int)((long)(this.m_swap ? 8 * s : 56 - 8 * s));
                ++s;
            }
            val[off] = Double.longBitsToDouble(tmpval);
            int tmp = this.m_tmp_len.value - (8 - s);
            while (s < 8) {
                this.m_tmp_len.value = 8 - s;
                rd = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
                int i2 = 0;
                while (i2 < rd) {
                    tmpval |= (long)(this.m_tmp_buf.value[this.m_tmp_off.value + i2] & 0xFF) << (int)((long)(this.m_swap ? 8 * s : 56 - 8 * s));
                    ++i2;
                    ++s;
                }
                val[off] = Double.longBitsToDouble(tmpval);
            }
            this.m_tmp_len.value = tmp;
        }
        this.postread(len * 8);
    }

    public TypeCode read_TypeCode() {
        return this.read_TypeCodeValue(new HashMap());
    }

    private TypeCode read_TypeCodeValue(HashMap cache) {
        TypeCode typeco = null;
        this.alignment(4);
        Integer kind_index = NumberCache.getInteger(this.m_index);
        int kind = this.read_ulong();
        switch (kind) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                typeco = this.m_orb.get_primitive_tc(TCKind.from_int(kind));
                break;
            }
            case 14: {
                this.begin_encapsulation();
                String id = this.read_string();
                String name = this.read_string();
                this.end_encapsulation();
                typeco = this.m_orb.create_interface_tc(id, name);
                break;
            }
            case 15: {
                this.begin_encapsulation();
                String id = this.read_string();
                String name = this.read_string();
                cache.put(kind_index, id);
                int length = this.read_ulong();
                StructMember[] sm = new StructMember[length];
                int i = 0;
                while (i < length) {
                    sm[i] = new StructMember();
                    sm[i].name = this.read_string();
                    sm[i].type = this.read_TypeCodeValue(cache);
                    ++i;
                }
                this.end_encapsulation();
                typeco = this.m_orb.create_struct_tc(id, name, sm);
                break;
            }
            case 16: {
                this.begin_encapsulation();
                String id = this.read_string();
                String name = this.read_string();
                cache.put(kind_index, id);
                TypeCode disc = this.read_TypeCodeValue(cache);
                int defaultused = this.read_long();
                int length = this.read_ulong();
                UnionMember[] um = new UnionMember[length];
                int i = 0;
                while (i < length) {
                    um[i] = new UnionMember();
                    um[i].label = this.m_orb.create_any();
                    um[i].label.read_value(this, disc);
                    if (i == defaultused) {
                        um[i].label.insert_octet((byte)0);
                    }
                    um[i].name = this.read_string();
                    um[i].type = this.read_TypeCodeValue(cache);
                    ++i;
                }
                this.end_encapsulation();
                typeco = this.m_orb.create_union_tc(id, name, disc, um);
                break;
            }
            case 17: {
                this.begin_encapsulation();
                String id = this.read_string();
                String name = this.read_string();
                int length = this.read_ulong();
                String[] members = new String[length];
                int i = 0;
                while (i < length) {
                    members[i] = this.read_string();
                    ++i;
                }
                this.end_encapsulation();
                typeco = this.m_orb.create_enum_tc(id, name, members);
                break;
            }
            case 18: {
                int length = this.read_ulong();
                typeco = this.m_orb.create_string_tc(length);
                break;
            }
            case 19: {
                this.begin_encapsulation();
                TypeCode contain = this.read_TypeCodeValue(cache);
                int length = this.read_ulong();
                this.end_encapsulation();
                typeco = this.m_orb.create_sequence_tc(length, contain);
                break;
            }
            case 20: {
                this.begin_encapsulation();
                TypeCode contain = this.read_TypeCodeValue(cache);
                int length = this.read_ulong();
                this.end_encapsulation();
                typeco = this.m_orb.create_array_tc(length, contain);
                break;
            }
            case 21: {
                this.begin_encapsulation();
                String id = this.read_string();
                String name = this.read_string();
                cache.put(kind_index, id);
                TypeCode contain = this.read_TypeCodeValue(cache);
                this.end_encapsulation();
                typeco = this.m_orb.create_alias_tc(id, name, contain);
                break;
            }
            case 22: {
                this.begin_encapsulation();
                String id = this.read_string();
                String name = this.read_string();
                cache.put(kind_index, id);
                int length = this.read_ulong();
                StructMember[] sm = new StructMember[length];
                int i = 0;
                while (i < length) {
                    sm[i] = new StructMember();
                    sm[i].name = this.read_string();
                    sm[i].type = this.read_TypeCodeValue(cache);
                    ++i;
                }
                this.end_encapsulation();
                typeco = this.m_orb.create_exception_tc(id, name, sm);
                cache.put(kind_index, typeco);
                break;
            }
            case 27: {
                int length = this.read_ulong();
                typeco = this.m_orb.create_wstring_tc(length);
                break;
            }
            case 28: {
                short digits = this.read_ushort();
                short scale = this.read_ushort();
                typeco = this.m_orb.create_fixed_tc(digits, scale);
                break;
            }
            case 29: {
                this.begin_encapsulation();
                String id = this.read_string();
                String name = this.read_string();
                cache.put(kind_index, id);
                short modifier = this.read_short();
                TypeCode contain = this.read_TypeCodeValue(cache);
                int length = this.read_ulong();
                ValueMember[] vm = new ValueMember[length];
                int i = 0;
                while (i < length) {
                    vm[i] = new ValueMember();
                    vm[i].name = this.read_string();
                    vm[i].type = this.read_TypeCodeValue(cache);
                    vm[i].access = this.read_short();
                    ++i;
                }
                this.end_encapsulation();
                typeco = this.m_orb.create_value_tc(id, name, modifier, contain, vm);
                break;
            }
            case 30: {
                this.begin_encapsulation();
                String id = this.read_string();
                String name = this.read_string();
                cache.put(kind_index, id);
                TypeCode contain = this.read_TypeCodeValue(cache);
                this.end_encapsulation();
                typeco = this.m_orb.create_value_box_tc(id, name, contain);
                break;
            }
            case 31: {
                this.begin_encapsulation();
                String id = this.read_string();
                String name = this.read_string();
                this.end_encapsulation();
                typeco = this.m_orb.create_native_tc(id, name);
                break;
            }
            case 32: {
                this.begin_encapsulation();
                String id = this.read_string();
                String name = this.read_string();
                this.end_encapsulation();
                typeco = this.m_orb.create_abstract_interface_tc(id, name);
                break;
            }
            case -1: {
                int oldidx = this.m_index + this.read_long();
                java.lang.Object lookup = cache.get(NumberCache.getInteger(oldidx));
                if (lookup instanceof String) {
                    typeco = this.m_orb.create_recursive_tc((String)lookup);
                    break;
                }
                if (lookup != null) {
                    typeco = (TypeCode)lookup;
                    break;
                }
                this.cancel(new MARSHAL("Invalid typecode offset", 1146056978, CompletionStatus.COMPLETED_MAYBE));
                break;
            }
            default: {
                this.cancel(new MARSHAL("Invalid typecode kind", 1146056979, CompletionStatus.COMPLETED_MAYBE));
            }
        }
        cache.put(kind_index, typeco);
        return typeco;
    }

    public Any read_any() {
        TypeCode typeco = this.read_TypeCode();
        Any any = this.m_orb.create_any();
        any.read_value(this, typeco);
        return any;
    }

    public Principal read_Principal() {
        byte[] b = new byte[this.read_ulong()];
        this.read_octet_array(b, 0, b.length);
        return new org.openorb.CORBA.Principal(b);
    }

    public Object read_Object() {
        IOR ior = IORHelper.read(this);
        if (ior.type_id.length() == 0 && ior.profiles.length == 0) {
            return null;
        }
        return new ObjectStub(this.m_orb, ior);
    }

    public Object read_Object(Class clz) {
        IOR ior = IORHelper.read(this);
        if (ior.type_id.length() == 0 && ior.profiles.length == 0) {
            return null;
        }
        if (clz == null || !(class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = CDRInputStream.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object).isAssignableFrom(clz)) {
            return new ObjectStub(this.m_orb, ior);
        }
        ObjectImpl ret = null;
        try {
            ret = (ObjectImpl)clz.newInstance();
        }
        catch (Exception ex) {
            this.cancel(ExceptionTool.initCause(new BAD_PARAM("Unable to instantiate class", 1146056962, CompletionStatus.COMPLETED_NO), (Throwable)ex));
        }
        Delegate ndeleg = new Delegate(this.m_orb, ior);
        ret._set_delegate(ndeleg);
        return ret;
    }

    public Context read_Context() {
        NVList nv = this.m_orb.create_list(0);
        int max = this.read_ulong() / 2;
        int i = 0;
        while (i < max) {
            Any a = this.m_orb.create_any();
            String name = this.read_string();
            a.insert_string(this.read_string());
            nv.add_value(name, a, 0);
            ++i;
        }
        org.openorb.CORBA.dii.Context context = new org.openorb.CORBA.dii.Context("", null, this.m_orb);
        ((Context)context).set_values(nv);
        return context;
    }

    public BigDecimal read_fixed() {
        return this.read_fixed((short)-1, (short)-1);
    }

    public BigDecimal read_fixed(TypeCode type) {
        try {
            return this.read_fixed(type.fixed_digits(), type.fixed_scale());
        }
        catch (BadKind ex) {
            this.cancel(ExceptionTool.initCause(new BAD_PARAM("Typecode is not fixed type", 1146056963, CompletionStatus.COMPLETED_NO), (Throwable)ex));
            return null;
        }
    }

    public BigDecimal read_fixed(short digits, short scale) {
        BigDecimal ret;
        StringBuffer value = new StringBuffer("0");
        short count = 0;
        boolean body = false;
        boolean negative = false;
        while (true) {
            byte v = this.read_octet();
            int hi = v >> 4 & 0xF;
            int lo = v & 0xF;
            if (hi > 9) {
                this.cancel(new MARSHAL("Error in fixed format", 1146056980, CompletionStatus.COMPLETED_MAYBE));
            }
            if (body || hi > 0) {
                value.append((char)(48 + hi));
                ++count;
            }
            if (lo < 10) {
                value.append((char)(48 + lo));
                ++count;
            } else {
                if (lo == 13) {
                    negative = true;
                    break;
                }
                if (lo == 12) break;
                this.cancel(new MARSHAL("Error in fixed format", 1146056980, CompletionStatus.COMPLETED_MAYBE));
            }
            body = true;
        }
        if (digits >= 0 && count > digits) {
            this.cancel(new MARSHAL("Fixed data does not match type", 1146056980, CompletionStatus.COMPLETED_MAYBE));
        }
        try {
            ret = new BigDecimal(value.toString());
        }
        catch (NumberFormatException ex) {
            this.cancel(ExceptionTool.initCause(new MARSHAL("Error in fixed format", 1146056980, CompletionStatus.COMPLETED_MAYBE), (Throwable)ex));
            return null;
        }
        if (negative) {
            ret = ret.negate();
        }
        if (scale > 0) {
            ret = ret.movePointLeft(scale);
        }
        return ret;
    }

    public Serializable read_value() {
        return this.read_value(this.read_long(), null, null, null, null);
    }

    public Serializable read_value(String rep_id) {
        return this.read_value(this.read_long(), rep_id, null, null, null);
    }

    public Serializable read_value(Class clz) {
        return this.read_value(this.read_long(), null, clz, null, null);
    }

    public Serializable read_value(BoxedValueHelper boxhelp) {
        return this.read_value(this.read_long(), null, null, boxhelp, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Serializable read_value(int tag, String arg_repo_id, Class clz, BoxedValueHelper boxhelp, Serializable target) {
        Serializable serializable;
        int enclosing_level;
        boolean old_in_chunked_value;
        block48: {
            if (tag == 0) {
                return null;
            }
            if (this.m_value_cache == null) {
                this.m_value_cache = new HashMap();
            }
            if (tag == -1) {
                int loc = this.m_index + this.read_long();
                java.lang.Object val = this.m_value_cache.get(NumberCache.getInteger(loc));
                if (val instanceof MARSHAL) {
                    this.cancel((MARSHAL)val);
                }
                if (val instanceof Serializable) {
                    return (Serializable)val;
                }
                this.cancel(new IndirectionException(loc));
            }
            if (tag < 0x7FFFFF00 || tag > Integer.MAX_VALUE) {
                this.cancel(new MARSHAL("Invalid value tag: 0x" + HexPrintStream.toHex(tag), 1146056981, CompletionStatus.COMPLETED_MAYBE));
            }
            int tag_index = this.m_index - 4;
            String codeBase = null;
            if ((tag & 1) == 1) {
                if (this.peek_long() == -1) {
                    this.read_long();
                    int loc = this.m_index + this.read_long();
                    java.lang.Object val = this.m_value_cache.get(NumberCache.getInteger(loc));
                    if (val == null || !(val instanceof String)) {
                        this.cancel(new IndirectionException(loc));
                    }
                    codeBase = (String)val;
                } else {
                    int codebase_index = this.m_index;
                    codeBase = this.read_string();
                    this.m_value_cache.put(NumberCache.getInteger(codebase_index), codeBase);
                }
            }
            String[] ids = this.read_typeids(tag);
            old_in_chunked_value = this.m_in_chunked_value;
            enclosing_level = this.m_value_level;
            if ((tag & 8) == 8) {
                int len = this.peek_long();
                if (len < 0x7FFFFF00 || len > Integer.MAX_VALUE) {
                    this.begin_value_chunk(this.read_ulong());
                }
                this.m_in_chunked_value = true;
            }
            ++this.m_value_level;
            this.m_value_indirect = tag_index;
            try {
                if (boxhelp != null) {
                    Serializable ret = boxhelp.read_value(this);
                    this.m_value_cache.put(NumberCache.getInteger(this.m_value_indirect), ret);
                    this.m_value_indirect = -1;
                    serializable = ret;
                    return serializable;
                }
                if (target != null) {
                    Serializable ret = this.read_value(target);
                    return ret;
                }
                Serializable ret = null;
                if (ids != null) {
                    int i = 0;
                    while (!(i >= ids.length || (ret = this.read_value_withtype(ids[i], codeBase, clz)) != null || arg_repo_id != null && ids[i].equals(arg_repo_id))) {
                        ++i;
                    }
                } else if (arg_repo_id != null) {
                    ret = this.read_value_withtype(arg_repo_id, codeBase, clz);
                }
                if (ret == null) {
                    MARSHAL ex = new MARSHAL("Unable to locate value factory", 1330446337, CompletionStatus.COMPLETED_YES);
                    this.m_value_cache.put(NumberCache.getInteger(this.m_value_indirect), ex);
                    this.m_value_indirect = -1;
                    if (this.m_continue_level > 0) {
                        throw ex;
                    }
                    this.cancel(ex);
                }
                if (clz != null && !clz.isInstance(ret)) {
                    this.cancel(new BAD_PARAM("Returned type does not match expected type", 1146056964, CompletionStatus.COMPLETED_YES));
                }
                Serializable serializable2 = ret;
                return serializable2;
            }
            finally {
                if ((tag & 8) == 8) break block48;
                this.m_value_level = enclosing_level;
                return serializable;
            }
        }
        while (true) {
            if (this.m_value_level <= enclosing_level) {
                this.m_pending_value_reopen = this.m_in_chunked_value = old_in_chunked_value;
                return serializable;
            }
            if (this.m_encaps_remain > 0) {
                this.force_skip(this.m_encaps_remain);
            }
            this.m_pending_value_reopen = false;
            int endtag = this.read_long();
            if (endtag >= 0x7FFFFF00 && endtag <= Integer.MAX_VALUE) {
                java.lang.Object var17_30;
                int exception_index = this.m_index - 4;
                try {
                    try {
                        ++this.m_continue_level;
                        this.read_value(endtag, null, null, null, null);
                    }
                    catch (MARSHAL ex) {
                        if (ex.minor != 1330446337) {
                            throw ExceptionTool.initCause(new MARSHAL(ex.getMessage(), ex.minor, ex.completed), (Throwable)ex);
                        }
                        var17_30 = null;
                        --this.m_continue_level;
                    }
                    var17_30 = null;
                    --this.m_continue_level;
                }
                catch (Throwable throwable) {
                    var17_30 = null;
                    --this.m_continue_level;
                    throw throwable;
                }
            }
            if (endtag > 0) {
                this.begin_value_chunk(endtag);
                continue;
            }
            this.m_value_level = -endtag - 1;
        }
    }

    private void begin_value_chunk(int len) {
        this.m_encaps_stack.addLast(NumberCache.getInteger(this.m_encaps_remain));
        this.m_encaps_stack.addLast(NumberCache.getInteger(this.m_index));
        this.m_encaps_stack.addLast(Boolean.TRUE);
        this.m_encaps_remain = len;
    }

    public String[] read_typeids(int tag) {
        String[] ids;
        block5: {
            block8: {
                block6: {
                    int count;
                    block7: {
                        ids = null;
                        if ((tag & 6) == 0) break block5;
                        if ((tag & 6) != 6) break block6;
                        count = this.read_long();
                        if (count != -1) break block7;
                        int loc = this.m_index + this.read_long();
                        java.lang.Object val = this.m_value_cache.get(NumberCache.getInteger(loc));
                        if (val == null || !(val instanceof String[])) {
                            this.cancel(new IndirectionException(loc));
                        }
                        ids = (String[])val;
                        this.m_value_cache.put(NumberCache.getInteger(this.m_index - 4), ids);
                        break block5;
                    }
                    ids = new String[count];
                    this.m_value_cache.put(NumberCache.getInteger(this.m_index - 4), ids);
                    break block8;
                }
                ids = new String[1];
            }
            int i = 0;
            while (i < ids.length) {
                if (this.peek_long() == -1) {
                    this.read_long();
                    int loc = this.m_index + this.read_long();
                    java.lang.Object val = this.m_value_cache.get(NumberCache.getInteger(loc));
                    if (val == null || !(val instanceof String)) {
                        this.cancel(new IndirectionException(loc));
                    }
                    ids[i] = (String)val;
                    this.m_value_cache.put(NumberCache.getInteger(this.m_index - 4), ids[i]);
                } else {
                    this.alignment(4);
                    int type_index = this.m_index;
                    ids[i] = this.read_string();
                    this.m_value_cache.put(NumberCache.getInteger(type_index), ids[i]);
                }
                ++i;
            }
        }
        return ids;
    }

    private Serializable read_value_withtype(String repo_id, String codeBase, Class clz) {
        ValueFactory factory = ((ORB)this.m_orb).lookup_value_factory(repo_id);
        if (factory != null) {
            return factory.read_value(this);
        }
        int temp = this.m_value_indirect;
        Serializable ret = this.value_extended_unmarshal(this.m_value_indirect, clz, repo_id, codeBase, null);
        if (ret != null) {
            this.m_value_cache.put(NumberCache.getInteger(temp), ret);
            return ret;
        }
        BoxedValueHelper boxhelp = null;
        try {
            String boxname = RepoIDHelper.idToClass(repo_id, 2);
            boxhelp = (BoxedValueHelper)Thread.currentThread().getContextClassLoader().loadClass(boxname).newInstance();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (boxhelp != null) {
            ret = boxhelp.read_value(this);
            this.m_value_cache.put(NumberCache.getInteger(this.m_value_indirect), ret);
            this.m_value_indirect = -1;
            return ret;
        }
        if (codeBase != null && (factory = this.loadFactoryWithID(repo_id, codeBase)) != null) {
            return factory.read_value(this);
        }
        return null;
    }

    public Serializable read_value(Serializable value) {
        if (this.m_value_indirect < 0) {
            return this.read_value(this.read_long(), null, null, null, value);
        }
        this.m_value_cache.put(NumberCache.getInteger(this.m_value_indirect), value);
        if (value instanceof CustomValue) {
            ((CustomValue)value).unmarshal(new DataInputStream(this));
        } else if (value instanceof StreamableValue) {
            ((StreamableValue)value)._read(this);
        } else {
            this.cancel(new BAD_PARAM("Unable to read value into class", 1146056964, CompletionStatus.COMPLETED_YES));
        }
        return value;
    }

    protected Serializable value_extended_unmarshal(int offset, Class clz, String repo_id, String codeBase, RunTime runTime) {
        return null;
    }

    public java.lang.Object read_abstract_interface() {
        if (this.read_boolean()) {
            return this.read_Object();
        }
        return this.read_value();
    }

    public java.lang.Object read_abstract_interface(Class clz) {
        if (this.read_boolean()) {
            return this.read_Object(clz);
        }
        return this.read_value();
    }

    private void postread(int len) {
        this.m_index += len;
        if (this.m_encaps_remain > 0) {
            this.m_encaps_remain -= len;
            while (this.m_encaps_remain == 0) {
                boolean value_chunk = (Boolean)this.m_encaps_stack.removeLast();
                int enclen = this.m_index - (Integer)this.m_encaps_stack.removeLast();
                this.m_encaps_remain = (Integer)this.m_encaps_stack.removeLast() - enclen;
                if (value_chunk) {
                    this.m_pending_value_reopen = true;
                } else {
                    this.m_swap = (Boolean)this.m_encaps_stack.removeLast();
                    if (!this.m_encaps_stack.isEmpty()) {
                        this.m_in_chunked_value = (Boolean)this.m_encaps_stack.getLast();
                    }
                    ++this.m_pending_encaps_close;
                }
                if (this.m_encaps_remain >= 0) continue;
                this.m_encaps_remain = -1;
            }
        }
    }

    protected ValueFactory loadFactoryWithID(String id, String url) {
        String factoryName = RepoIDHelper.idToClass(id, 4);
        try {
            Class<java.lang.Object> clzHelper = this.loadClassFromURL(factoryName, url);
            clzHelper = url != null ? this.loadClassFromURL(factoryName, url) : Thread.currentThread().getContextClassLoader().loadClass(factoryName);
            if (clzHelper != null) {
                return (ValueFactory)clzHelper.newInstance();
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Unexpected exception", ex);
        }
        return null;
    }

    private Class loadClassFromURL(String className, String url) {
        try {
            if (url == null) {
                return Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            ClassLoader loader = (ClassLoader)this.m_value_cache.get(url);
            if (loader == null) {
                StringTokenizer token = new StringTokenizer(url, " ");
                URL[] urls = new URL[token.countTokens()];
                int pos = 0;
                int i = 0;
                while (i < urls.length) {
                    try {
                        urls[pos] = new URL(token.nextToken());
                        ++pos;
                    }
                    catch (MalformedURLException ex) {
                        // empty catch block
                    }
                    ++i;
                }
                if (pos != urls.length) {
                    URL[] old = urls;
                    urls = new URL[pos];
                    System.arraycopy(old, 0, urls, 0, pos);
                }
                loader = new URLClassLoader(urls);
                this.m_value_cache.put(url, loader);
            }
            Class<?> clz = loader.loadClass(className);
            return clz;
        }
        catch (ClassNotFoundException ex) {
            this.getLogger().error("Unable to find class from an URL : " + className, new Error());
            return null;
        }
    }

    protected Map getValueCache() {
        return this.m_value_cache;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MarkState {
        private int m_index;
        private boolean m_swap;
        private int m_encaps_remain = -1;
        private int m_pending_encaps_close;
        private LinkedList m_encaps_stack;
        private int m_value_level;
        private boolean m_pending_value_reopen;
        private boolean m_in_chunked_value;
        private int m_value_indirect;

        MarkState() {
            this.m_index = CDRInputStream.this.m_index;
            this.m_swap = CDRInputStream.this.m_swap;
            this.m_encaps_remain = CDRInputStream.this.m_encaps_remain;
            this.m_pending_encaps_close = CDRInputStream.this.m_pending_encaps_close;
            this.m_encaps_stack = new LinkedList(CDRInputStream.this.m_encaps_stack);
            this.m_value_level = CDRInputStream.this.m_value_level;
            this.m_pending_value_reopen = CDRInputStream.this.m_pending_value_reopen;
            this.m_in_chunked_value = CDRInputStream.this.m_in_chunked_value;
            this.m_value_indirect = CDRInputStream.this.m_value_indirect;
        }

        void reset() {
            CDRInputStream.this.m_index = this.m_index;
            CDRInputStream.this.m_swap = this.m_swap;
            CDRInputStream.this.m_encaps_remain = this.m_encaps_remain;
            CDRInputStream.this.m_pending_encaps_close = this.m_pending_encaps_close;
            CDRInputStream.this.m_encaps_stack = this.m_encaps_stack;
            CDRInputStream.this.m_value_level = this.m_value_level;
            CDRInputStream.this.m_pending_value_reopen = this.m_pending_value_reopen;
            CDRInputStream.this.m_in_chunked_value = this.m_in_chunked_value;
            CDRInputStream.this.m_value_indirect = this.m_value_indirect;
        }
    }
}

