/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.adapter.poa;

import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.omg.CORBA.Policy;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.openorb.PI.FeatureInitInfo;
import org.openorb.PI.FeatureInitializer;
import org.openorb.adapter.poa.CurrentImpl;
import org.openorb.adapter.poa.DelegateImpl;
import org.openorb.adapter.poa.POA;
import org.openorb.adapter.poa.PolicyFactoryImpl;
import org.openorb.adapter.poa.RootPOA;
import org.openorb.net.ServerManager;
import org.openorb.util.Trace;

public class POAInitializer
extends AbstractLogEnabled
implements FeatureInitializer {
    public void init(ORBInitInfo orbinfo, FeatureInitInfo featureinfo) {
        block9: {
            ServerManager svrmgr;
            if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
                this.getLogger().debug("init");
            }
            if ((svrmgr = (ServerManager)featureinfo.getFeature("ServerCPCManager")) != null) {
                try {
                    orbinfo.resolve_initial_references("RootPOA");
                    return;
                }
                catch (InvalidName ex) {
                    String error;
                    block8: {
                        try {
                            CurrentImpl curr = new CurrentImpl();
                            curr.enableLogging(featureinfo.orb().getLogger());
                            orbinfo.register_initial_reference("POACurrent", curr);
                        }
                        catch (InvalidName ex2) {
                            error = "Unable to register initial reference POACurrent.";
                            if (!this.getLogger().isErrorEnabled()) break block8;
                            this.getLogger().error("Unable to register initial reference POACurrent.", ex2);
                        }
                    }
                    try {
                        DelegateImpl deleg = new DelegateImpl(featureinfo.orb());
                        featureinfo.setFeature("POADelegate", deleg);
                        POA root = RootPOA.create_root_poa(svrmgr, new Policy[0]);
                        orbinfo.register_initial_reference("RootPOA", root);
                        deleg.init();
                        PolicyFactoryImpl pf = PolicyFactoryImpl.getInstance();
                        orbinfo.register_policy_factory(16, pf);
                        orbinfo.register_policy_factory(17, pf);
                        orbinfo.register_policy_factory(18, pf);
                        orbinfo.register_policy_factory(19, pf);
                        orbinfo.register_policy_factory(21, pf);
                        orbinfo.register_policy_factory(22, pf);
                        orbinfo.register_policy_factory(20, pf);
                    }
                    catch (InvalidName ex3) {
                        error = "Illegal attempt to initialize two root POAs.";
                        if (!this.getLogger().isErrorEnabled()) break block9;
                        this.getLogger().error("Illegal attempt to initialize two root POAs.", ex3);
                    }
                }
            }
        }
    }
}

