/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.CORBA.typecode;

import java.util.Map;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.UnionMember;
import org.openorb.CORBA.typecode.TypeCodeBase;
import org.openorb.CORBA.typecode.TypeCodeRecursive;

public class TypeCodeUnion
extends TypeCodeBase {
    private String m_id;
    private String m_name = null;
    private TypeCodeBase m_discriminator_type;
    private UnionMember[] m_members;
    private int m_default_index = -1;
    private TypeCodeUnion m_compact = null;
    private boolean m_fixed = false;

    TypeCodeUnion(String id, String name, TypeCode discriminator_type, UnionMember[] members) {
        int i;
        this.m_id = id;
        this.m_discriminator_type = (TypeCodeBase)discriminator_type;
        this.m_members = members;
        if (name != null && name.length() > 0) {
            this.m_name = name;
        } else {
            this.m_compact = this;
            i = 0;
            while (i < members.length) {
                if (members[i].name != null && members[i].name.length() != 0 || !((TypeCodeBase)members[i].type)._is_compact()) {
                    this.m_compact = null;
                    break;
                }
                ++i;
            }
        }
        i = 0;
        while (i < members.length) {
            if (members[i].label.type().kind() == TCKind.tk_octet && members[i].label.extract_octet() == 0) {
                this.m_default_index = i;
                break;
            }
            ++i;
        }
    }

    private TypeCodeUnion(String id, TypeCode discriminator_type, UnionMember[] members, int default_index) {
        this.m_id = id;
        this.m_discriminator_type = (TypeCodeBase)discriminator_type;
        this.m_members = members;
        this.m_default_index = default_index;
        this.m_compact = this;
    }

    boolean _is_recursive() {
        return false;
    }

    boolean _fix_recursive(Map recursive) {
        recursive.put(this.m_id, this);
        if (this.m_fixed) {
            return true;
        }
        this.m_fixed = true;
        int i = 0;
        while (i < this.m_members.length) {
            if (this.m_members[i].type instanceof TypeCodeRecursive) {
                TypeCodeRecursive tmp = (TypeCodeRecursive)this.m_members[i].type;
                String tmp_id = "";
                try {
                    tmp_id = tmp.id();
                }
                catch (BadKind ex) {
                    // empty catch block
                }
                this.m_members[i].type = (TypeCodeBase)recursive.get(tmp_id);
                if (this.m_members[i].type == null) {
                    this.m_fixed = false;
                    this.m_members[i].type = tmp;
                    return false;
                }
            } else {
                TypeCodeBase tcb = (TypeCodeBase)this.m_members[i].type;
                if (tcb != null) {
                    this.m_fixed = tcb._fix_recursive(recursive);
                    if (!this.m_fixed) {
                        return false;
                    }
                }
            }
            ++i;
        }
        return this.m_fixed;
    }

    public boolean _is_compact() {
        return this.m_compact == this;
    }

    public TypeCodeBase _base_type() {
        return this;
    }

    public TCKind kind() {
        return TCKind.tk_union;
    }

    public boolean equivalent(TypeCode tc) {
        return this.equal(((TypeCodeBase)tc)._base_type());
    }

    public boolean equal(TypeCode tc) {
        if (this == tc) {
            return true;
        }
        if (tc.kind() != TCKind.tk_union) {
            return false;
        }
        TypeCodeUnion tc2 = (TypeCodeUnion)tc;
        if (this.m_id.length() > 0 && tc2.m_id.length() > 0) {
            return this.m_id.equals(tc2.m_id);
        }
        if (this.m_members.length != tc2.m_members.length || this.m_default_index != tc2.m_default_index || !this.m_discriminator_type.equal(tc2.m_discriminator_type)) {
            return false;
        }
        int i = 0;
        while (i < this.m_members.length) {
            if (this.m_members[i].name != null && this.m_members[i].name.length() != 0 && tc2.m_members[i].name != null && tc2.m_members[i].name.length() != 0 && !this.m_members[i].name.equals(tc2.m_members[i].name) || !this.m_members[i].type.equal(tc2.m_members[i].type) || !this.m_members[i].label.equal(tc2.m_members[i].label)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        if (this.m_id == null || this.m_id.length() == 0) {
            return super.hashCode();
        }
        return this.m_id.hashCode();
    }

    public TypeCode get_compact_typecode() {
        if (this.m_name == null) {
            return this;
        }
        if (this.m_compact == null) {
            this.m_compact = new TypeCodeUnion(this.m_id, this.m_discriminator_type, (UnionMember[])this.m_members.clone(), this.m_default_index);
            int i = 0;
            while (i < this.m_members.length) {
                this.m_compact.m_members[i].name = null;
                this.m_compact.m_members[i].type = this.m_members[i].type.get_compact_typecode();
                ++i;
            }
        }
        return this.m_compact;
    }

    public String id() throws BadKind {
        return this.m_id;
    }

    public String name() throws BadKind {
        if (this.m_name == null) {
            return "";
        }
        return this.m_name;
    }

    public int member_count() throws BadKind {
        return this.m_members.length;
    }

    public TypeCode member_type(int index) throws BadKind, Bounds {
        if (index >= this.m_members.length || index < 0) {
            throw new Bounds();
        }
        if (this.m_members[index].type instanceof TypeCodeRecursive) {
            throw new BAD_TYPECODE("Attempt to access incomplete typecode", 1330446337, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.m_members[index].type;
    }

    public String member_name(int index) throws BadKind, Bounds {
        if (index >= this.m_members.length || index < 0) {
            throw new Bounds();
        }
        return this.m_members[index].name == null ? "" : this.m_members[index].name;
    }

    public Any member_label(int index) throws BadKind, Bounds {
        if (index >= this.m_members.length || index < 0) {
            throw new Bounds();
        }
        return this.m_members[index].label;
    }

    public TypeCode discriminator_type() throws BadKind {
        return this.m_discriminator_type;
    }

    public int default_index() throws BadKind {
        return this.m_default_index;
    }

    public int length() throws BadKind {
        throw new BadKind();
    }

    public TypeCode content_type() throws BadKind {
        throw new BadKind();
    }

    public short fixed_digits() throws BadKind {
        throw new BadKind();
    }

    public short fixed_scale() throws BadKind {
        throw new BadKind();
    }

    public short member_visibility(int index) throws BadKind, Bounds {
        throw new BadKind();
    }

    public short type_modifier() throws BadKind {
        throw new BadKind();
    }

    public TypeCode concrete_base_type() throws BadKind {
        throw new BadKind();
    }
}

