/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.layers;

import java.awt.EventQueue;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.DeferredPerformer;
import org.netbeans.core.windows.LazyUpdater;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.PersistenceManager;
import org.netbeans.core.windows.UIModeManager;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.frames.TCCTabbedAreaImpl;
import org.netbeans.core.windows.frames.TopComponentContainer;
import org.netbeans.core.windows.layers.ICFolderImpl;
import org.netbeans.core.windows.layers.InvalidDataException;
import org.netbeans.core.windows.layers.ProducerCookie;
import org.netbeans.core.windows.layers.TCRef;
import org.netbeans.core.windows.layers.TCRefImpl;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.modules.ModuleInfo;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;
import org.openide.util.io.FoldingIOException;
import org.openide.util.io.SafeException;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ModeData
extends DataFolder
implements CookieSet.Factory {
    private static final String INSTANCE_DTD_ID_1_0 = "-//NetBeans//DTD Mode Properties 1.0//EN";
    private static final String INSTANCE_DTD_ID_1_1 = "-//NetBeans//DTD Mode Properties 1.1//EN";
    private static final String INSTANCE_DTD_ID_1_2 = "-//NetBeans//DTD Mode Properties 1.2//EN";
    private FileObject modeConfigFO;
    private CookiesImpl cookiesImpl;
    private boolean initDone = false;
    static /* synthetic */ Class class$org$netbeans$core$windows$layers$ModeData;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;
    static /* synthetic */ Class class$org$netbeans$core$windows$layers$ResetCookie;

    public ModeData(FileObject fo, FileObject siblink, MultiFileLoader loader) throws DataObjectExistsException {
        super(fo, loader);
        this.initCookies();
        this.initDone = true;
        this.modeConfigFO = siblink;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$core$windows$layers$ModeData == null ? (class$org$netbeans$core$windows$layers$ModeData = ModeData.class$("org.netbeans.core.windows.layers.ModeData")) : class$org$netbeans$core$windows$layers$ModeData);
    }

    public boolean isRenameAllowed() {
        return false;
    }

    private void initCookies() {
        this.getCookieSet().add(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = ModeData.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie, (CookieSet.Factory)this);
        this.getCookieSet().add(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = ModeData.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie, (CookieSet.Factory)this);
        this.getCookieSet().add(class$org$netbeans$core$windows$layers$ResetCookie == null ? (class$org$netbeans$core$windows$layers$ResetCookie = ModeData.class$("org.netbeans.core.windows.layers.ResetCookie")) : class$org$netbeans$core$windows$layers$ResetCookie, (CookieSet.Factory)this);
    }

    public Node.Cookie getCookie(Class klass) {
        if (!this.initDone) {
            this.initCookies();
            this.initDone = true;
        }
        return super.getCookie(klass);
    }

    ModeImpl getModeImpl() throws IOException {
        return this.cookiesImpl().obtainModeImpl();
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz == (class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = ModeData.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie) || clazz == (class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = ModeData.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie) || clazz == (class$org$netbeans$core$windows$layers$ResetCookie == null ? (class$org$netbeans$core$windows$layers$ResetCookie = ModeData.class$("org.netbeans.core.windows.layers.ResetCookie")) : class$org$netbeans$core$windows$layers$ResetCookie)) {
            return this.cookiesImpl();
        }
        return null;
    }

    private synchronized CookiesImpl cookiesImpl() {
        if (this.cookiesImpl != null) {
            return this.cookiesImpl;
        }
        this.cookiesImpl = new CookiesImpl(this, this.modeConfigFO);
        return this.cookiesImpl;
    }

    FileObject getModeConfigFO() {
        if (this.modeConfigFO == null) {
            Iterator iter = this.secondaryEntries().iterator();
            while (iter.hasNext()) {
                this.modeConfigFO = ((MultiDataObject.Entry)iter.next()).getFile();
            }
        }
        return this.modeConfigFO;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class PropertyHandler
    extends DefaultHandler {
        private ModeData folder;
        private FileObject fo;
        private ModeConfig modeConfig;
        private boolean rightProps;
        private boolean ignoreFurther;
        private boolean ignoreCurrent;
        private boolean shouldParse;
        private final Object RW_LOCK = new Object();
        static /* synthetic */ Class class$org$netbeans$core$windows$layers$ModeData;

        public PropertyHandler(ModeData folder) {
            this.folder = folder;
            this.fo = folder.getModeConfigFO();
            this.shouldParse = true;
        }

        public ModeConfig readData() throws SAXException, IOException {
            if (this.shouldParse) {
                this.modeConfig = new ModeConfig();
                this.ignoreCurrent = false;
                this.ignoreFurther = false;
                this.rightProps = false;
                this.modeConfig.invalid = true;
                Object object = this.RW_LOCK;
                synchronized (object) {
                    this.getXMLParser().parse(new InputSource(this.fo.getInputStream()));
                }
            }
            return this.modeConfig;
        }

        public void startElement(String nameSpace, String name, String qname, Attributes attrs) throws SAXException {
            if (!this.ignoreCurrent && !this.ignoreFurther) {
                if ("other".equals(qname)) {
                    this.handleOther(attrs);
                } else if ("icon".equals(qname)) {
                    this.handleIcon(attrs);
                } else if ("bounds".equals(qname)) {
                    this.handleBounds(attrs);
                } else if ("maximized-bounds".equals(qname)) {
                    this.handleMaximizedBounds(attrs);
                } else if ("relative-bounds".equals(qname)) {
                    this.handleRelativeBounds(attrs);
                } else if ("frame".equals(qname)) {
                    this.handleFrame(attrs);
                } else if ("area".equals(qname)) {
                    this.handleDominance(attrs);
                } else if ("container".equals(qname)) {
                    this.startContainer(attrs);
                }
            }
            if ("mode".equals(qname)) {
                this.startMode(attrs);
            } else if ("ui-type".equals(qname)) {
                this.startUIType(attrs);
            } else if ("name".equals(qname)) {
                this.handleName(attrs);
            } else if ("module".equals(qname)) {
                this.handleModule(attrs);
            } else if ("description".equals(qname)) {
                this.handleDescription(attrs);
            }
        }

        public void endElement(String nameSpace, String name, String qname) throws SAXException {
            if ("ui-type".equals(qname)) {
                this.endUIType();
            }
        }

        public void error(SAXParseException ex) throws SAXException {
            throw ex;
        }

        public void fatalError(SAXParseException ex) throws SAXException {
            throw ex;
        }

        public void warning(SAXParseException ex) throws SAXException {
        }

        private void handleOther(Attributes attrs) {
            String value = attrs.getValue("defined-by");
            this.modeConfig.userDefined = "user".equals(value) ? 1 : ("module".equals(value) ? 0 : -1);
            value = attrs.getValue("mode-state");
            this.modeConfig.modeState = "visible".equals(value) || value == null ? 1 : ("hidden".equals(value) ? 0 : -1);
        }

        private void handleName(Attributes attrs) {
            this.modeConfig.name = attrs.getValue("unique");
            this.modeConfig.displayName = attrs.getValue("display");
            String value = attrs.getValue("from-bundle");
            if ("true".equals(value)) {
                this.modeConfig.fromBundle = 1;
                this.modeConfig.nameBundle = attrs.getValue("bundle");
            } else {
                this.modeConfig.fromBundle = "false".equals(value) ? 0 : -1;
            }
        }

        private void handleDescription(Attributes attrs) {
            this.modeConfig.description = attrs.getValue("display");
            this.modeConfig.descriptionBundle = attrs.getValue("bundle");
        }

        private void handleModule(Attributes attrs) {
            String moduleCodeName = attrs.getValue("name");
            this.modeConfig.moduleCodeNameBase = null;
            this.modeConfig.moduleCodeNameRelease = null;
            this.modeConfig.moduleSpecificationVersion = null;
            if (moduleCodeName != null) {
                int i = moduleCodeName.indexOf(47);
                if (i != -1) {
                    this.modeConfig.moduleCodeNameBase = moduleCodeName.substring(0, i);
                    this.modeConfig.moduleCodeNameRelease = moduleCodeName.substring(i + 1);
                    PropertyHandler.checkReleaseCode(this.modeConfig);
                } else {
                    this.modeConfig.moduleCodeNameBase = moduleCodeName;
                }
                this.modeConfig.moduleSpecificationVersion = attrs.getValue("spec");
            }
        }

        private static void checkReleaseCode(ModeConfig modeConfig) {
            if ("null".equals(modeConfig.moduleCodeNameRelease)) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Module release code was saved as null string for module " + modeConfig.moduleCodeNameBase + "! Repairing."));
                modeConfig.moduleCodeNameRelease = null;
            }
        }

        private void handleIcon(Attributes attrs) {
            try {
                this.modeConfig.iconURL = new URL(attrs.getValue("url"));
            }
            catch (MalformedURLException exc) {
                this.modeConfig.iconURL = null;
                String annotation = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$core$windows$layers$ModeData == null ? (class$org$netbeans$core$windows$layers$ModeData = PropertyHandler.class$("org.netbeans.core.windows.layers.ModeData")) : class$org$netbeans$core$windows$layers$ModeData), (String)"EXC_ModeIcon"), this.fo.getName());
                ErrorManager.getDefault().annotate((Throwable)exc, annotation);
                ErrorManager.getDefault().notify(1, (Throwable)exc);
            }
        }

        private void handleBounds(Attributes attrs) {
            if (this.modeConfig.bounds == null) {
                this.modeConfig.bounds = new Rectangle();
            }
            try {
                this.modeConfig.bounds.x = Integer.parseInt(attrs.getValue("x"));
                this.modeConfig.bounds.y = Integer.parseInt(attrs.getValue("y"));
                this.modeConfig.bounds.width = Integer.parseInt(attrs.getValue("width"));
                this.modeConfig.bounds.height = Integer.parseInt(attrs.getValue("height"));
            }
            catch (NumberFormatException exc) {
                this.modeConfig.bounds = null;
                String annotation = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$core$windows$layers$ModeData == null ? (class$org$netbeans$core$windows$layers$ModeData = PropertyHandler.class$("org.netbeans.core.windows.layers.ModeData")) : class$org$netbeans$core$windows$layers$ModeData), (String)"EXC_ModeBounds"), this.fo.getName());
                ErrorManager.getDefault().annotate((Throwable)exc, annotation);
                ErrorManager.getDefault().notify(1, (Throwable)exc);
            }
            this.checkBounds();
        }

        private void checkBounds() {
            Rectangle rect = this.modeConfig.bounds;
            if (rect == null) {
                return;
            }
            rect = (Rectangle)rect.clone();
            boolean invalid = false;
            if (rect.x < 0) {
                rect.x = 0;
                invalid = true;
            }
            if (rect.y < 0) {
                rect.y = 0;
                invalid = true;
            }
            if (rect.width < 30) {
                rect.width = 200;
                invalid = true;
            }
            if (rect.height < 30) {
                rect.height = 200;
                invalid = true;
            }
            if (invalid) {
                ErrorManager.getDefault().log(16, "[WinSys:ModeData] Bounds " + this.modeConfig.bounds + " are invalid in " + (Object)((Object)this.folder) + ". Repaired to " + rect);
                this.modeConfig.bounds = rect;
            }
        }

        private void handleMaximizedBounds(Attributes attrs) {
            if (this.modeConfig.maximizedBounds == null) {
                this.modeConfig.maximizedBounds = new Rectangle();
            }
            try {
                this.modeConfig.maximizedBounds.x = Integer.parseInt(attrs.getValue("x"));
                this.modeConfig.maximizedBounds.y = Integer.parseInt(attrs.getValue("y"));
                this.modeConfig.maximizedBounds.width = Integer.parseInt(attrs.getValue("width"));
                this.modeConfig.maximizedBounds.height = Integer.parseInt(attrs.getValue("height"));
            }
            catch (NumberFormatException exc) {
                this.modeConfig.maximizedBounds = null;
                String annotation = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$core$windows$layers$ModeData == null ? (class$org$netbeans$core$windows$layers$ModeData = PropertyHandler.class$("org.netbeans.core.windows.layers.ModeData")) : class$org$netbeans$core$windows$layers$ModeData), (String)"EXC_ModeMaximizedBounds"), this.fo.getName());
                ErrorManager.getDefault().annotate((Throwable)exc, annotation);
                ErrorManager.getDefault().notify(1, (Throwable)exc);
            }
            this.checkMaximizedBounds();
        }

        private void checkMaximizedBounds() {
            Rectangle rect = this.modeConfig.maximizedBounds;
            if (rect != null && (rect.x < 0 || rect.y < 0 || rect.width < 20 || rect.height < 20)) {
                ErrorManager.getDefault().log(16, "[WinSys:ModeData] Maximized bounds " + rect + " are invalid in " + (Object)((Object)this.folder) + ". Ignoring");
                this.modeConfig.maximizedBounds = null;
            }
        }

        private void handleRelativeBounds(Attributes attrs) {
            if (this.modeConfig.relativeBounds == null) {
                this.modeConfig.relativeBounds = new Rectangle();
            }
            try {
                this.modeConfig.relativeBounds.x = Integer.parseInt(attrs.getValue("x"));
                this.modeConfig.relativeBounds.y = Integer.parseInt(attrs.getValue("y"));
                this.modeConfig.relativeBounds.width = Integer.parseInt(attrs.getValue("width"));
                this.modeConfig.relativeBounds.height = Integer.parseInt(attrs.getValue("height"));
            }
            catch (NumberFormatException exc) {
                this.modeConfig.relativeBounds = null;
                String annotation = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$core$windows$layers$ModeData == null ? (class$org$netbeans$core$windows$layers$ModeData = PropertyHandler.class$("org.netbeans.core.windows.layers.ModeData")) : class$org$netbeans$core$windows$layers$ModeData), (String)"EXC_ModeRelativeBounds"), this.fo.getName());
                ErrorManager.getDefault().annotate((Throwable)exc, annotation);
                ErrorManager.getDefault().notify(1, (Throwable)exc);
            }
            this.checkRelativeBounds();
        }

        private void checkRelativeBounds() {
            Rectangle rect = this.modeConfig.relativeBounds;
            if (rect == null) {
                return;
            }
            rect = (Rectangle)rect.clone();
            boolean invalid = false;
            if (rect.x < 0) {
                rect.x = 0;
                invalid = true;
            }
            if (rect.y < 0) {
                rect.y = 0;
                invalid = true;
            }
            if (rect.width < 0) {
                rect.width = 50;
                invalid = true;
            }
            if (rect.height < 0) {
                rect.height = 50;
                invalid = true;
            }
            if (invalid) {
                ErrorManager.getDefault().log(16, "[WinSys:ModeData] Relative bounds " + this.modeConfig.relativeBounds + " are invalid in " + (Object)((Object)this.folder) + ". Repaired to " + rect);
                this.modeConfig.relativeBounds = rect;
            }
        }

        private void handleFrame(Attributes attrs) {
            String frameType = attrs.getValue("type");
            this.modeConfig.frameType = "internal".equals(frameType) ? "org.netbeans.core.windows.frames.InternalFrameTypeImpl" : ("desktop".equals(frameType) ? "org.netbeans.core.windows.frames.DesktopFrameTypeImpl" : ("window".equals(frameType) ? "org.netbeans.core.windows.frames.TopFrameTypeImpl" : null));
            this.modeConfig.constraints = WindowUtils.convertConstraint2Perim(attrs.getValue("constraints"));
            String state = attrs.getValue("state");
            if ("iconified".equals(state)) {
                this.modeConfig.frameState = 1;
            } else if ("maximized".equals(state)) {
                this.modeConfig.frameState = 6;
                String restoredState = attrs.getValue("restored-state");
                this.modeConfig.restoredFrameState = "iconified".equals(restoredState) ? 1 : ("normal".equals(restoredState) ? 0 : -1);
            } else {
                this.modeConfig.frameState = "normal".equals(state) ? 0 : -1;
            }
        }

        private void handleDominance(Attributes attrs) {
            DominanceEntry curEntry = new DominanceEntry();
            if (this.modeConfig.dominance == null) {
                this.modeConfig.dominance = new ArrayList(5);
            }
            curEntry.constraint = WindowUtils.convertConstraint2Perim(attrs.getValue("constraint"));
            try {
                String attribute = attrs.getValue("x");
                if (attribute != null && attribute.length() > 0) {
                    curEntry.absBounds = new Rectangle();
                    curEntry.relBounds = null;
                    curEntry.absBounds.x = Integer.parseInt(attrs.getValue("x"));
                    curEntry.absBounds.y = Integer.parseInt(attrs.getValue("y"));
                    curEntry.absBounds.width = Integer.parseInt(attrs.getValue("width"));
                    curEntry.absBounds.height = Integer.parseInt(attrs.getValue("height"));
                } else {
                    curEntry.relBounds = new Rectangle();
                    curEntry.absBounds = null;
                    curEntry.relBounds.x = Integer.parseInt(attrs.getValue("relative-x"));
                    curEntry.relBounds.y = Integer.parseInt(attrs.getValue("relative-y"));
                    curEntry.relBounds.width = Integer.parseInt(attrs.getValue("relative-width"));
                    curEntry.relBounds.height = Integer.parseInt(attrs.getValue("relative-height"));
                }
            }
            catch (NumberFormatException exc) {
                curEntry.absBounds = null;
                curEntry.relBounds = null;
                String annotation = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$core$windows$layers$ModeData == null ? (class$org$netbeans$core$windows$layers$ModeData = PropertyHandler.class$("org.netbeans.core.windows.layers.ModeData")) : class$org$netbeans$core$windows$layers$ModeData), (String)"EXC_WrongAreaBounds"), this.fo.getName());
                ErrorManager.getDefault().annotate((Throwable)exc, annotation);
                ErrorManager.getDefault().notify(1, (Throwable)exc);
            }
            this.modeConfig.dominance.add(curEntry);
        }

        private void startMode(Attributes attrs) {
        }

        private void startContainer(Attributes attrs) {
            String type = attrs.getValue("type");
            this.modeConfig.containerType = "split".equals(type) ? "org.netbeans.core.windows.frames.SplitContainerImpl" : ("tabbed".equals(type) ? "org.netbeans.core.windows.frames.MultiTabbedContainerImpl" : null);
            this.modeConfig.activeTc = attrs.getValue("active-tc");
        }

        private void startUIType(Attributes attrs) {
            String type = attrs.getValue("type");
            int uiMode = UIModeManager.getDefault().getUIMode();
            if (uiMode == WindowUtils.parseUIType(type)) {
                this.rightProps = true;
                this.modeConfig.invalid = false;
                this.modeConfig.clear();
            } else if ("any".equals(type)) {
                this.modeConfig.invalid = false;
            } else {
                this.ignoreCurrent = true;
            }
        }

        private void endUIType() {
            if (this.rightProps) {
                this.ignoreFurther = true;
            }
            this.ignoreCurrent = false;
        }

        public void writeData() throws IOException {
            StringBuffer buff = this.fillBuffer();
            Object object = this.RW_LOCK;
            synchronized (object) {
                this.fo.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(this, buff){
                    private final /* synthetic */ StringBuffer val$buff;
                    private final /* synthetic */ PropertyHandler this$0;
                    {
                        this.this$0 = this$0;
                        this.val$buff = val$buff;
                    }

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() throws IOException {
                        FileLock lock;
                        block3: {
                            lock = PropertyHandler.access$100(this.this$0).lock();
                            OutputStreamWriter osw = null;
                            try {
                                OutputStream os = PropertyHandler.access$100(this.this$0).getOutputStream(lock);
                                osw = new OutputStreamWriter(os, "UTF-8");
                                osw.write(this.val$buff.toString());
                                Object var5_4 = null;
                                if (osw == null) break block3;
                            }
                            catch (Throwable throwable) {
                                Object var5_5 = null;
                                if (osw != null) {
                                    osw.close();
                                }
                                lock.releaseLock();
                                throw throwable;
                            }
                            osw.close();
                        }
                        lock.releaseLock();
                    }
                });
            }
        }

        private StringBuffer fillBuffer() throws IOException {
            ModeImpl mi = this.folder.getModeImpl();
            StringBuffer buff = new StringBuffer(800);
            Object curValue = null;
            buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
            buff.append("<mode version=\"1.2\">\n");
            this.appendName(mi, buff);
            this.appendDescription(mi, buff);
            this.appendModule(mi, buff);
            buff.append("    <ui-type type=\"any\" >\n");
            Rectangle relativeBounds = mi.getRelativeBoundsXML();
            if (relativeBounds != null) {
                this.appendRelativeBoundsXML(mi, buff);
            } else {
                this.appendBounds(mi, buff);
                if (mi.isMaxMode() && "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(mi.getFrameType())) {
                    this.appendMaximizedBounds(mi, buff);
                }
            }
            this.appendFrame(mi, buff);
            this.appendDominance(mi, buff);
            this.appendRest(mi, buff);
            buff.append("    </ui-type>\n");
            buff.append("</mode>\n");
            return buff;
        }

        private void appendName(ModeImpl modeImpl, StringBuffer buff) throws CharConversionException {
            buff.append("    <name unique=\"");
            buff.append(XMLUtil.toAttributeValue((String)modeImpl.getName()));
            String displayName = modeImpl.getDisplayNameXML();
            if (displayName != null) {
                buff.append("\" display=\"");
                buff.append(XMLUtil.toAttributeValue((String)displayName));
            }
            buff.append("\" from-bundle=\"");
            if (modeImpl.isNameFromBundle()) {
                buff.append("true");
                buff.append("\" bundle=\"");
                buff.append(modeImpl.getNameBundle());
            } else {
                buff.append("false");
            }
            buff.append("\" />\n");
        }

        private void appendDescription(ModeImpl modeImpl, StringBuffer buff) throws CharConversionException {
            if (modeImpl.getDescriptionXML() == null) {
                return;
            }
            buff.append("    <description display=\"");
            buff.append(XMLUtil.toAttributeValue((String)modeImpl.getDescriptionXML()));
            buff.append("\" bundle=\"");
            buff.append(modeImpl.getDescriptionBundle());
            buff.append("\" />\n");
        }

        private void appendModule(ModeImpl modeImpl, StringBuffer buff) {
            if (this.modeConfig == null) {
                return;
            }
            if (this.modeConfig.moduleCodeNameBase != null) {
                buff.append("    <module");
                buff.append(" name=\"");
                buff.append(this.modeConfig.moduleCodeNameBase);
                if (this.modeConfig.moduleCodeNameRelease != null) {
                    buff.append("/" + this.modeConfig.moduleCodeNameRelease);
                }
                if (this.modeConfig.moduleSpecificationVersion != null) {
                    buff.append("\" spec=\"");
                    buff.append(this.modeConfig.moduleSpecificationVersion);
                }
                buff.append("\" />\n");
            }
        }

        private void appendBounds(ModeImpl modeImpl, StringBuffer buff) {
            Rectangle bounds = modeImpl.getNormalBounds();
            if (bounds == null) {
                return;
            }
            buff.append("        <bounds x=\"");
            buff.append(bounds.x);
            buff.append("\" y=\"");
            buff.append(bounds.y);
            buff.append("\" width=\"");
            buff.append(bounds.width);
            buff.append("\" height=\"");
            buff.append(bounds.height);
            buff.append("\" />\n");
        }

        private void appendMaximizedBounds(ModeImpl modeImpl, StringBuffer buff) {
            Rectangle bounds = modeImpl.getBounds();
            if (bounds == null) {
                return;
            }
            buff.append("        <maximized-bounds x=\"");
            buff.append(bounds.x);
            buff.append("\" y=\"");
            buff.append(bounds.y);
            buff.append("\" width=\"");
            buff.append(bounds.width);
            buff.append("\" height=\"");
            buff.append(bounds.height);
            buff.append("\" />\n");
        }

        private void appendRelativeBoundsXML(ModeImpl modeImpl, StringBuffer buff) {
            Rectangle rBounds = modeImpl.getRelativeBoundsXML();
            if (rBounds == null) {
                return;
            }
            buff.append("        <relative-bounds x=\"");
            buff.append(rBounds.x);
            buff.append("\" y=\"");
            buff.append(rBounds.y);
            buff.append("\" width=\"");
            buff.append(rBounds.width);
            buff.append("\" height=\"");
            buff.append(rBounds.height);
            buff.append("\" />\n");
        }

        private void appendFrame(ModeImpl modeImpl, StringBuffer buff) {
            buff.append("        <frame type=\"");
            String curValue = modeImpl.getFrameType();
            if ("org.netbeans.core.windows.frames.TopFrameTypeImpl".equals(curValue)) {
                buff.append("window");
            } else if ("org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(curValue)) {
                buff.append("internal");
            } else if ("org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(curValue)) {
                buff.append("desktop");
            } else {
                buff.append("dialog");
            }
            Object constraints = modeImpl.getConstraints();
            if (constraints != null) {
                buff.append("\" constraints=\"");
                buff.append(WindowUtils.convertConstraint2Xml((String)constraints));
            }
            buff.append("\" state=\"");
            int frameState = modeImpl.getFrameState();
            if (0 == frameState) {
                buff.append("normal");
            } else if (1 == frameState) {
                buff.append("iconified");
            } else {
                buff.append("maximized");
            }
            if (6 == frameState) {
                int restoredFrameState = modeImpl.getRestoredFrameState();
                buff.append("\" restored-state=\"");
                if (0 == restoredFrameState) {
                    buff.append("normal");
                } else {
                    buff.append("iconified");
                }
            }
            buff.append("\" />\n");
        }

        private void appendRest(ModeImpl modeImpl, StringBuffer buff) {
            URL iconURL = modeImpl.getIconURL();
            if (iconURL != null) {
                buff.append("        <icon url=\"");
                buff.append(iconURL.toString());
                buff.append("\" />\n");
            }
            buff.append("        <other defined-by=\"");
            buff.append(modeImpl.isUserDefined() ? "user" : "module");
            buff.append("\" mode-state=\"");
            buff.append(modeImpl.isHidden() ? "hidden" : "visible");
            buff.append("\" />\n");
        }

        private void appendDominance(ModeImpl modeImpl, StringBuffer buff) throws IOException {
            TopComponentContainer tcc;
            buff.append("        <container type=\"");
            String curValue = modeImpl.getContainerType();
            if ("org.netbeans.core.windows.frames.SplitContainerImpl".equals(curValue)) {
                buff.append("split");
            } else {
                buff.append("tabbed");
            }
            List<Object> areas = null;
            Map modeAreas = modeImpl.getAreas();
            if (modeAreas != null) {
                areas = new ArrayList(modeAreas.values());
            }
            if ((tcc = modeImpl.getContainerInstance()) != null) {
                TopComponent activeTc = tcc.getSelectedTopComponent();
                if (activeTc != null) {
                    PersistenceManager pm = PersistenceManager.getDefault();
                    ModeImpl mi = this.folder.getModeImpl();
                    String curId = pm.lookupIdWithoutCreation(activeTc);
                    if (!pm.isPersistent(activeTc, curId, mi.getWorkspace())) {
                        activeTc = null;
                    } else {
                        try {
                            curId = pm.lookupTCStringId(activeTc);
                        }
                        catch (NotSerializableException nse) {
                            activeTc = null;
                        }
                    }
                }
                if (activeTc != null) {
                    buff.append("\" active-tc=\"");
                    buff.append(XMLUtil.toAttributeValue((String)PersistenceManager.getDefault().lookupTCStringId(activeTc)));
                }
            }
            buff.append("\" >\n");
            if ("org.netbeans.core.windows.frames.SplitContainerImpl".equals(curValue) && (tcc != null || areas != null)) {
                List tccAreas;
                List list = tccAreas = tcc != null ? tcc.getAreas() : null;
                if (areas == null) {
                    areas = tccAreas;
                } else if (tccAreas != null) {
                    Iterator it = tccAreas.iterator();
                    while (it.hasNext()) {
                        Object area = it.next();
                        if (areas.contains(area)) continue;
                        areas.add(area);
                    }
                }
                if (areas != null) {
                    String curConstraint = null;
                    Rectangle curBounds = null;
                    boolean isMaxMode = modeImpl.isMaxMode();
                    String frameType = modeImpl.getFrameType();
                    Rectangle modeBounds = null;
                    Rectangle modeNormalBounds = null;
                    if (isMaxMode && "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(frameType)) {
                        modeBounds = modeImpl.getBounds();
                        modeNormalBounds = modeImpl.getNormalBounds();
                    }
                    TopComponentContainer.Area area = null;
                    int i = 0;
                    while (i < areas.size()) {
                        area = (TopComponentContainer.Area)areas.get(i);
                        curConstraint = (String)area.getConstraint();
                        curBounds = area.getBounds();
                        if (curBounds != null) {
                            if (isMaxMode && "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(frameType)) {
                                float coef = (float)modeNormalBounds.width / (float)modeBounds.width;
                                curBounds.x = (int)((float)curBounds.x * coef);
                                curBounds.width = (int)((float)curBounds.width * coef);
                                coef = (float)modeNormalBounds.height / (float)modeBounds.height;
                                curBounds.y = (int)((float)curBounds.y * coef);
                                curBounds.height = (int)((float)curBounds.height * coef);
                            }
                            buff.append("            <area constraint=\"");
                            curConstraint = WindowUtils.convertConstraint2Xml(curConstraint);
                            buff.append(curConstraint);
                            buff.append("\" x=\"" + curBounds.x);
                            buff.append("\" y=\"" + curBounds.y);
                            buff.append("\" width=\"" + curBounds.width);
                            buff.append("\" height=\"" + curBounds.height);
                            buff.append("\" />\n");
                        }
                        ++i;
                    }
                }
            }
            buff.append("        </container>\n");
        }

        private Map obtainConstraintsBounds(ModeImpl modeImpl, TopComponentContainer tcc) {
            TopComponent[] topComps = modeImpl.getOpenedTopComponents();
            HashMap<Object, Rectangle> constr2Bounds = new HashMap<Object, Rectangle>(10);
            Object curConstr = null;
            int i = 0;
            while (i < topComps.length) {
                curConstr = tcc.getConstraints(topComps[i]);
                if (curConstr == null) {
                    curConstr = "CENTER";
                }
                if (constr2Bounds.get(curConstr) == null) {
                    constr2Bounds.put(curConstr, topComps[i].getBounds());
                }
                ++i;
            }
            return constr2Bounds;
        }

        private XMLReader getXMLParser() throws SAXException {
            XMLReader parser = XMLUtil.createXMLReader();
            parser.setContentHandler(this);
            parser.setErrorHandler(this);
            parser.setEntityResolver(this);
            return parser;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if (ModeData.INSTANCE_DTD_ID_1_0.equals(publicId) || ModeData.INSTANCE_DTD_ID_1_1.equals(publicId) || ModeData.INSTANCE_DTD_ID_1_2.equals(publicId)) {
                ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
                return new InputSource(is);
            }
            return null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static /* synthetic */ FileObject access$100(PropertyHandler x0) {
            return x0.fo;
        }
    }

    private static final class CookiesImpl
    extends ICFolderImpl
    implements SaveCookie,
    LazyUpdater,
    DeferredPerformer.DeferredCommand,
    PropertyChangeListener {
        private ModeImpl modeImpl;
        private PropertyHandler propertyHandler;
        ModeConfig mc;
        private int loadedSections;
        private int currLoadedSections;
        private PropertyChangeListener weakPropertyChangeL;
        private boolean visualUpdate = true;
        private boolean wasCompsLoaded = false;
        private ThreadLocal componentsUpdated;
        private final Object DATA_ID_LOCK = new Object();
        static /* synthetic */ Class class$org$netbeans$core$windows$layers$TCRef;
        static /* synthetic */ Class class$org$netbeans$core$windows$ModeImpl;
        static /* synthetic */ Class class$org$netbeans$core$windows$layers$ProducerCookie;
        static /* synthetic */ Class class$org$netbeans$core$windows$layers$ModeData;
        static /* synthetic */ Class class$org$netbeans$core$windows$layers$ModeData$CookiesImpl;
        static /* synthetic */ Class class$org$openide$cookies$SaveCookie;

        public CookiesImpl(DataFolder df, FileObject props) {
            super(df, props, class$org$netbeans$core$windows$layers$TCRef == null ? (class$org$netbeans$core$windows$layers$TCRef = CookiesImpl.class$("org.netbeans.core.windows.layers.TCRef")) : class$org$netbeans$core$windows$layers$TCRef);
            this.componentsUpdated = new ThreadLocal();
        }

        public String instanceName() {
            return (class$org$netbeans$core$windows$ModeImpl == null ? (class$org$netbeans$core$windows$ModeImpl = CookiesImpl.class$("org.netbeans.core.windows.ModeImpl")) : class$org$netbeans$core$windows$ModeImpl).getName();
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return class$org$netbeans$core$windows$ModeImpl == null ? (class$org$netbeans$core$windows$ModeImpl = CookiesImpl.class$("org.netbeans.core.windows.ModeImpl")) : class$org$netbeans$core$windows$ModeImpl;
        }

        protected void clean() {
            this.childrenCookies = null;
            if (this.modeImpl != null) {
                this.modeImpl.close();
                ((WorkspaceImpl)this.modeImpl.getWorkspace()).removeMode(this.modeImpl);
                this.modeImpl.attachUpdater(null);
                this.modeImpl = null;
            }
        }

        protected InstanceCookie acceptCookie(InstanceCookie cookie) throws IOException, ClassNotFoundException {
            Class c;
            if ((class$org$netbeans$core$windows$layers$TCRef == null ? (class$org$netbeans$core$windows$layers$TCRef = CookiesImpl.class$("org.netbeans.core.windows.layers.TCRef")) : class$org$netbeans$core$windows$layers$TCRef).isAssignableFrom(c = cookie.instanceClass())) {
                return cookie;
            }
            return null;
        }

        protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
            if (!(this.folder.isValid() && this.folder.getPrimaryFile().isValid() && ((ModeData)this.folder).getModeConfigFO().isValid() && this.folder.getPrimaryFile().getParent().isValid() && DataObject.find((FileObject)this.folder.getPrimaryFile().getParent()).getCookie(class$org$netbeans$core$windows$layers$ProducerCookie == null ? (class$org$netbeans$core$windows$layers$ProducerCookie = CookiesImpl.class$("org.netbeans.core.windows.layers.ProducerCookie")) : class$org$netbeans$core$windows$layers$ProducerCookie) != null)) {
                throw new InvalidDataException((Object)this.folder.getName());
            }
            ModeImpl mi = this.obtainModeImpl();
            if (this.childrenCookies == null) {
                mi.attachUpdater(this);
            }
            InstanceCookie[] oldCookies = this.childrenCookies;
            this.childrenCookies = cookies;
            if (this.underCurrentWS()) {
                Object object = this.DATA_ID_LOCK;
                synchronized (object) {
                    this.loadedSections |= 1;
                }
            }
            try {
                this.updateAll(oldCookies, cookies, this.loadedSections);
                Object var7_6 = null;
                this.currLoadedSections = this.loadedSections;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.currLoadedSections = this.loadedSections;
                throw throwable;
            }
            this.installListeners();
            return mi;
        }

        public void resetComponents() {
            this.childrenCookies = null;
        }

        public void reset() {
            super.reset();
            this.modeImpl = null;
            this.loadedSections = 0;
            this.currLoadedSections = 0;
            this.childrenCookies = null;
            this.wasCompsLoaded = false;
        }

        private void deleteFiles(boolean cleanAll) {
            WindowUtils.deleteOneFO(((ModeData)this.folder).getModeConfigFO());
            if (cleanAll) {
                WindowUtils.deleteOneFO(this.folder.getPrimaryFile());
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("enabled".equals(evt.getPropertyName())) {
                ModuleInfo src = (ModuleInfo)evt.getSource();
                if (!((Boolean)evt.getNewValue()).booleanValue()) {
                    if (this.modeImpl != null) {
                        this.modeImpl.setValidForSaving(false);
                    }
                    this.deleteFiles(false);
                }
            }
        }

        private void updateAll(InstanceCookie[] oldCookies, InstanceCookie[] newCookies, int data_id) throws IOException {
            if (ICFolderImpl.simpleArrayCompare(oldCookies, newCookies)) {
                return;
            }
            this.componentsUpdated.set(Boolean.TRUE);
            this.updateProperties(oldCookies, newCookies, data_id);
            if (this.componentsUpdated.get() == Boolean.TRUE) {
                this.componentsUpdated.set(Boolean.FALSE);
                this.updateComponents(this.mc, oldCookies, newCookies, data_id);
            }
        }

        protected void updateProperties() throws IOException {
            try {
                InstanceCookie[] oldCookies = this.childrenCookies;
                this.childrenCookies = this.createCookies();
                this.updateProperties(oldCookies, this.childrenCookies, 1);
            }
            catch (ClassNotFoundException e) {
                IOException ioe = new IOException();
                throw (IOException)ErrorManager.getDefault().annotate((Throwable)ioe, (Throwable)e);
            }
        }

        protected Object getDataLock() {
            return this.DATA_ID_LOCK;
        }

        private void updateProperties(InstanceCookie[] oldC, InstanceCookie[] newC, int data_id) throws IOException {
            if ((data_id & 1) != 0) {
                this.mc = this.readProperties();
                if (this.mc == null) {
                    return;
                }
                if (this.mc.moduleCodeNameBase != null) {
                    ModuleInfo curModuleInfo = WindowUtils.findModule(this.mc.moduleCodeNameBase, this.mc.moduleCodeNameRelease, this.mc.moduleSpecificationVersion);
                    if (curModuleInfo != null && curModuleInfo.isEnabled()) {
                        if (this.weakPropertyChangeL == null) {
                            this.weakPropertyChangeL = WeakListener.propertyChange((PropertyChangeListener)this, (Object)curModuleInfo);
                            curModuleInfo.addPropertyChangeListener(this.weakPropertyChangeL);
                        }
                    } else {
                        this.deleteFiles(false);
                        return;
                    }
                }
                if (this.setProps2Mode(this.mc)) {
                    // empty if block
                }
            } else {
                this.childrenCookies = oldC;
                return;
            }
        }

        private boolean underCurrentWS() throws IOException {
            FileObject primaryFile = this.folder.getPrimaryFile();
            ProducerCookie pc = (ProducerCookie)DataObject.find((FileObject)primaryFile.getParent()).getCookie(class$org$netbeans$core$windows$layers$ProducerCookie == null ? (class$org$netbeans$core$windows$layers$ProducerCookie = CookiesImpl.class$("org.netbeans.core.windows.layers.ProducerCookie")) : class$org$netbeans$core$windows$layers$ProducerCookie);
            Workspace w = (Workspace)pc.getProduct();
            WindowManagerImpl wmi = WindowManagerImpl.getInstance();
            Workspace curWS = wmi.getCurrentWorkspaceNoLoad();
            if (curWS == null) {
                return false;
            }
            return curWS.equals(w);
        }

        private ModeConfig readProperties() throws IOException {
            if (this.propertyHandler == null) {
                this.propertyHandler = new PropertyHandler((ModeData)this.folder);
            }
            ModeConfig mc = null;
            try {
                mc = this.propertyHandler.readData();
            }
            catch (SAXException exc) {
                exc.printStackTrace();
                String msg = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$layers$ModeData == null ? (class$org$netbeans$core$windows$layers$ModeData = CookiesImpl.class$("org.netbeans.core.windows.layers.ModeData")) : class$org$netbeans$core$windows$layers$ModeData), (String)"EXC_ModeParse", (Object[])new Object[]{this.folder.getName()});
                IOException ioe = new IOException(msg);
                ErrorManager.getDefault().annotate((Throwable)ioe, (Throwable)exc);
                throw ioe;
            }
            return mc;
        }

        private void updateComponentIds() throws IOException {
            ModeImpl mi = this.obtainModeImpl();
            FileObject fo = this.folder.getPrimaryFile();
            FileObject[] children = fo.getChildren();
            String[] tc_ids = new String[children.length];
            int i = 0;
            while (i < children.length) {
                tc_ids[i] = children[i].getName();
                ++i;
            }
            mi.setTopComponentIds(tc_ids);
        }

        private boolean setProps2Mode(ModeConfig mc) throws IOException {
            if (mc.invalid) {
                return false;
            }
            boolean shouldLoadCompos = false;
            ModeImpl mi = this.obtainModeImpl();
            if (mc.displayName != null) {
                mi.setDisplayName(mc.displayName);
            }
            if (mc.description != null) {
                mi.setDescriptionXML(mc.description);
            }
            if (mc.descriptionBundle != null) {
                mi.setDescriptionBundle(mc.descriptionBundle);
            }
            if (mc.frameType != null) {
                WindowManagerImpl wmi;
                int curUIMode = UIModeManager.getDefault().getUIMode();
                boolean doConvert = curUIMode != (wmi = WindowManagerImpl.getInstance()).getSavedUIMode();
                String frameType = mc.frameType;
                if (doConvert) {
                    frameType = WindowUtils.convertFrameType(curUIMode, mc.constraints);
                }
                if (!frameType.equals(mc.frameType)) {
                    mi.restoreFrameType(mc.frameType, frameType);
                } else {
                    mi.setFrameType(frameType);
                }
            }
            if (SwingUtilities.isEventDispatchThread()) {
                CookiesImpl.doSetBounds(mc, mi);
            } else {
                SwingUtilities.invokeLater(new Runnable(this, mc, mi){
                    private final /* synthetic */ ModeConfig val$mc;
                    private final /* synthetic */ ModeImpl val$mi;
                    private final /* synthetic */ CookiesImpl this$0;
                    {
                        this.this$0 = this$0;
                        this.val$mc = val$mc;
                        this.val$mi = val$mi;
                    }

                    public void run() {
                        CookiesImpl.access$000(this.val$mc, this.val$mi);
                    }
                });
            }
            if (mc.containerType != null) {
                mi.setContainerType(mc.containerType);
            }
            if (mc.constraints != null) {
                WindowUtils.changeModeConstraints(mi, mc.constraints, mc.modeState == 0);
            }
            if (mc.iconURL != null) {
                mi.setIconURL(mc.iconURL);
            }
            if (mc.frameState >= 0) {
                mi.setFrameState(mc.frameState);
                if (mc.frameState == 6) {
                    // empty if block
                }
            }
            if (mc.userDefined >= 0) {
                mi.setUserDefined(mc.userDefined > 0);
            }
            if (mc.fromBundle >= 0) {
                mi.setNameFromBundle(mc.fromBundle > 0);
                if (mc.fromBundle > 0) {
                    mi.setNameBundle(mc.nameBundle);
                }
            }
            if (mc.modeState >= 0 && mi.isHidden() != (mc.modeState == 0)) {
                mi.setHidden(mc.modeState == 0);
                if ((mc.modeState != 0 || mi.isVisible()) && (this.loadedSections & 2) == 0) {
                    shouldLoadCompos = true;
                }
            }
            return shouldLoadCompos;
        }

        private static void doSetBounds(ModeConfig mc, ModeImpl mi) {
            Rectangle bounds = mc.relativeBounds;
            if (bounds != null) {
                mi.setRelativeBounds(bounds);
            } else {
                bounds = mc.bounds;
                if (bounds != null) {
                    mi.setNormalBounds(bounds);
                }
            }
        }

        private void updateComponents(ModeConfig mc, InstanceCookie[] oldCookies, InstanceCookie[] newCookies, int data_id) throws IOException {
            if ((data_id & 2) == 0) {
                this.childrenCookies = oldCookies;
                return;
            }
            if (newCookies == null || mc == null || mc.invalid) {
                this.childrenCookies = oldCookies;
                return;
            }
            if (mc.dominance != null && this.isVisualUpdate()) {
                this.setAreaBounds(mc);
            }
            Set[] sets = CookiesImpl.computeSets(oldCookies, newCookies);
            if (this.isVisualUpdate()) {
                this.removeComponents(sets[0]);
            }
            Map cookies2Refs = this.createTCRefs(newCookies);
            if (this.isVisualUpdate()) {
                if (sets[1].size() > 0) {
                    List addedRefs = this.addComponents(sets[1], newCookies, cookies2Refs);
                    this.reorderComps(addedRefs);
                }
                this.setDominance(newCookies);
                if (mc.activeTc != null && WindowManagerImpl.isProjectOpen()) {
                    DeferredPerformer.getDefault().putRequest((DeferredPerformer.DeferredCommand)this, new DeferredPerformer.DeferredContext(null, true));
                }
                this.wasCompsLoaded = true;
            }
        }

        public void performCommand(DeferredPerformer.DeferredContext dc) {
            try {
                if (this.mc == null || this.mc.invalid || this.mc.activeTc == null) {
                    return;
                }
                ModeImpl mi = this.obtainModeImpl();
                if (!mi.isVisible()) {
                    return;
                }
                TopComponentContainer tcc = mi.getContainerInstance();
                TopComponent tc = PersistenceManager.getDefault().lookupTCInstance(this.mc.activeTc);
                if (tc != null && tcc != null && tcc.containsTopComponent(tc)) {
                    tcc.setSelectedTopComponent(tc);
                } else {
                    ErrorManager em = ErrorManager.getDefault();
                    if (tc == null) {
                        em.log(16, "Core, window system warning: Cannot find component with ID " + this.mc.activeTc + " for activation!");
                    } else {
                        em.log(16, "Core, window system warning: cannot set component with ID " + this.mc.activeTc + " as active in mode " + mi.getName() + ", component not present!");
                    }
                }
            }
            catch (SafeException exc) {
                ErrorManager.getDefault().notify(1, (Throwable)exc);
            }
            catch (IOException exc) {
                ErrorManager em = ErrorManager.getDefault();
                em.notify(1, (Throwable)exc);
            }
        }

        private void setDominance(InstanceCookie[] newCookies) throws IOException {
            ArrayList<Object> constrList = new ArrayList<Object>();
            Object constr = null;
            int i = 0;
            while (i < newCookies.length) {
                try {
                    TCRef curRef = (TCRef)newCookies[i].instanceCreate();
                    Object curConstr = ((TCRefImpl)curRef).getConstraint();
                    if (curConstr != null && !curConstr.equals(constr)) {
                        constr = curConstr;
                        constrList.add(curConstr);
                    }
                }
                catch (ClassNotFoundException exc) {
                    exc.printStackTrace();
                    ((WindowManagerImpl)WindowManager.getDefault()).annotatePersistenceError(exc, "");
                }
                ++i;
            }
            ModeImpl mi = this.obtainModeImpl();
            TopComponentContainer tcc = mi.getContainerInstance();
            if (tcc != null) {
                tcc.setConstraintsOrder(constrList);
            }
        }

        private void removeComponents(Set cookieSet) throws IOException {
            ModeImpl mi = this.obtainModeImpl();
            Iterator it = cookieSet.iterator();
            while (it.hasNext()) {
                try {
                    TCRef curRef = (TCRef)((InstanceCookie)it.next()).instanceCreate();
                    if (EventQueue.isDispatchThread()) {
                        try {
                            TopComponent tc = curRef.getTopComponent();
                            if (tc == null) continue;
                            mi.release(tc);
                        }
                        catch (SafeException exc) {
                            ErrorManager.getDefault().notify(1, (Throwable)exc);
                        }
                        catch (FileNotFoundException exc) {
                            ErrorManager.getDefault().notify(1, (Throwable)exc);
                        }
                        continue;
                    }
                    EventQueue.invokeLater(new Runnable(this, curRef, mi){
                        private final /* synthetic */ TCRef val$curRef;
                        private final /* synthetic */ ModeImpl val$mi;
                        private final /* synthetic */ CookiesImpl this$0;
                        {
                            this.this$0 = this$0;
                            this.val$curRef = val$curRef;
                            this.val$mi = val$mi;
                        }

                        public void run() {
                            try {
                                TopComponent tc = this.val$curRef.getTopComponent();
                                if (tc != null) {
                                    this.val$mi.release(tc);
                                }
                            }
                            catch (SafeException exc) {
                                ErrorManager.getDefault().notify(1, (Throwable)exc);
                            }
                            catch (FileNotFoundException exc) {
                                ErrorManager.getDefault().notify(1, (Throwable)exc);
                            }
                            catch (IOException exc) {
                                ErrorManager.getDefault().notify(4096, (Throwable)exc);
                            }
                        }
                    });
                }
                catch (ClassNotFoundException exc) {
                    exc.printStackTrace();
                    ((WindowManagerImpl)WindowManager.getDefault()).annotatePersistenceError(exc, "");
                }
            }
        }

        private Map createTCRefs(InstanceCookie[] newCookies) {
            HashMap<InstanceCookie, TCRef> cookies2Refs = new HashMap<InstanceCookie, TCRef>(newCookies.length * 2);
            int i = 0;
            while (i < newCookies.length) {
                try {
                    TCRef curRef = (TCRef)newCookies[i].instanceCreate();
                    cookies2Refs.put(newCookies[i], curRef);
                }
                catch (IOException exc) {
                    this.notifyTCCreationFailure(exc, newCookies[i]);
                }
                catch (ClassNotFoundException exc) {
                    this.notifyTCCreationFailure(exc, newCookies[i]);
                }
                ++i;
            }
            return cookies2Refs;
        }

        /*
         * Unable to fully structure code
         */
        private List addComponents(Set cookieSet, InstanceCookie[] newCookies, Map cookies2Refs) throws IOException {
            refs = new ArrayList<TCRef>(cookieSet.size());
            i = 0;
            while (i < newCookies.length) {
                block9: {
                    curRef = (TCRef)cookies2Refs.get(newCookies[i]);
                    if (cookieSet.contains(newCookies[i]) && curRef != null) {
                        block10: {
                            try {
                                curRef.updateMode();
                                ((TCRefImpl)curRef).setOrderWeight(10 * (i + 1));
                                refs.add(curRef);
                                break block9;
                            }
                            catch (SafeException exc) {
                                curRef.destroy();
                                ErrorManager.getDefault().notify(1, (Throwable)exc);
                                break block9;
                            }
                            catch (IOException exc) {
                                em = ErrorManager.getDefault();
                                arr = em.findAnnotations((Throwable)exc);
                                dnfe = null;
                                if (arr.length <= 0) break block10;
                                ind = 0;
                                ** while (ind < arr.length)
                            }
lbl-1000:
                            // 1 sources

                            {
                                t = arr[ind].getStackTrace();
                                if (t != null && t instanceof DataObjectNotFoundException) {
                                    dnfe = (DataObjectNotFoundException)t;
                                    break;
                                }
                                ++ind;
                                continue;
                            }
                        }
                        if (dnfe == null) {
                            em.annotate((Throwable)exc, NbBundle.getMessage((Class)(CookiesImpl.class$org$netbeans$core$windows$layers$ModeData$CookiesImpl == null ? CookiesImpl.class$("org.netbeans.core.windows.layers.ModeData$CookiesImpl") : CookiesImpl.class$org$netbeans$core$windows$layers$ModeData$CookiesImpl), (String)"EXC_LoadTCRef", (Object[])new Object[]{curRef, exc.getMessage()}));
                            em.notify(4096, (Throwable)exc);
                        } else {
                            em.log(16, "[WinSys] Can not work with top component reference " + curRef + ". Referenced data object was not found!" + " File " + dnfe.getFileObject() + " might have been deleted.");
                        }
                        curRef.destroy();
                    }
                }
                ++i;
            }
            return refs;
        }

        private void reorderComps(List refs) throws IOException {
            List orderedTcs = this.updateCompOrder(refs);
            ModeImpl mi = this.obtainModeImpl();
            TopComponentContainer tcc = mi.getContainerInstance();
            if (tcc != null) {
                DeferredPerformer.getDefault().putRequest(new DeferredPerformer.DeferredCommand(this, tcc, orderedTcs){
                    private final /* synthetic */ TopComponentContainer val$tcc;
                    private final /* synthetic */ List val$orderedTcs;
                    private final /* synthetic */ CookiesImpl this$0;
                    {
                        this.this$0 = this$0;
                        this.val$tcc = val$tcc;
                        this.val$orderedTcs = val$orderedTcs;
                    }

                    public void performCommand(DeferredPerformer.DeferredContext context) {
                        this.val$tcc.reorder(this.val$orderedTcs);
                    }
                }, new DeferredPerformer.DeferredContext(null, true));
            }
        }

        private final void notifyTCCreationFailure(Exception exc, InstanceCookie cookie) {
            String excAnnotation = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$core$windows$layers$ModeData == null ? (class$org$netbeans$core$windows$layers$ModeData = CookiesImpl.class$("org.netbeans.core.windows.layers.ModeData")) : class$org$netbeans$core$windows$layers$ModeData), (String)"EXC_CreateTCRef"), cookie);
            ErrorManager em = ErrorManager.getDefault();
            em.annotate((Throwable)exc, excAnnotation);
            em.notify(16, (Throwable)exc);
        }

        private static Set[] computeSets(InstanceCookie[] oldCookies, InstanceCookie[] newCookies) {
            Set[] ret = new Set[]{new HashSet(), new HashSet()};
            CookiesImpl.fillSet(ret[0], oldCookies);
            CookiesImpl.fillSet(ret[1], newCookies);
            Set tmp = (Set)((HashSet)ret[0]).clone();
            ret[0].removeAll(ret[1]);
            ret[1].removeAll(tmp);
            return ret;
        }

        private static void fillSet(Set set, Object[] array) {
            if (array == null) {
                return;
            }
            int i = 0;
            while (i < array.length) {
                set.add(array[i]);
                ++i;
            }
        }

        private void setAreaBounds(ModeConfig mc) throws IOException {
            ModeImpl mi = this.obtainModeImpl();
            TopComponentContainer tcc = mi.getContainerInstance();
            HashMap<String, TopComponentContainer.Area> areas = new HashMap<String, TopComponentContainer.Area>(20);
            Iterator iter = ((AbstractList)mc.dominance).iterator();
            while (iter.hasNext()) {
                Rectangle absBounds;
                TopComponentContainer.Area curArea;
                DominanceEntry curEntry = (DominanceEntry)iter.next();
                if (tcc != null) {
                    curArea = tcc.getArea(curEntry.constraint);
                    if (curArea == null) {
                        curArea = new TCCTabbedAreaImpl(curEntry.constraint);
                        areas.put(curEntry.constraint, curArea);
                    }
                } else {
                    curArea = new TCCTabbedAreaImpl(curEntry.constraint);
                    areas.put(curEntry.constraint, curArea);
                }
                if (curEntry.relBounds != null) {
                    if (mi.isBoundsSet()) {
                        Rectangle modeBounds = mi.getBounds();
                        absBounds = new Rectangle();
                        absBounds.x = curEntry.relBounds.x * modeBounds.width / 100;
                        absBounds.y = curEntry.relBounds.y * modeBounds.height / 100;
                        absBounds.width = curEntry.relBounds.width * modeBounds.width / 100;
                        absBounds.height = curEntry.relBounds.height * modeBounds.height / 100;
                        this.convert2Maximized(absBounds, mc);
                        curArea.setBounds(absBounds);
                        continue;
                    }
                    curArea.setRelativeBounds(curEntry.relBounds);
                    continue;
                }
                if (curEntry.absBounds == null) continue;
                absBounds = new Rectangle(curEntry.absBounds);
                this.convert2Maximized(absBounds, mc);
                curArea.setBounds(absBounds);
            }
            mi.setAreas(areas);
        }

        private void convert2Maximized(Rectangle bounds, ModeConfig mc) throws IOException {
            ModeImpl mi = this.obtainModeImpl();
            WorkspaceImpl wi = (WorkspaceImpl)mi.getWorkspace();
            if (!wi.getWasMaxMode() || !"org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(mi.getFrameType())) {
                return;
            }
            if (mc.maximizedBounds == null) {
                return;
            }
            float coef = (float)mc.maximizedBounds.width / (float)mc.bounds.width;
            bounds.x = (int)((float)bounds.x * coef);
            bounds.width = (int)((float)bounds.width * coef);
            coef = (float)mc.maximizedBounds.height / (float)mc.bounds.height;
            bounds.y = (int)((float)bounds.y * coef);
            bounds.height = (int)((float)bounds.height * coef);
        }

        private List updateCompOrder(List tcRefs) throws IOException {
            TCRef curRef = null;
            ArrayList<TCRef> result = new ArrayList<TCRef>(tcRefs.size());
            Iterator iter = tcRefs.iterator();
            while (iter.hasNext()) {
                curRef = (TCRef)iter.next();
                if (!curRef.isOpened()) continue;
                result.add(curRef);
            }
            Collections.sort(result);
            return result;
        }

        ModeImpl obtainModeImpl() throws IOException {
            if (this.modeImpl == null) {
                FileObject primaryFile = this.folder.getPrimaryFile();
                ProducerCookie pc = (ProducerCookie)DataObject.find((FileObject)primaryFile.getParent()).getCookie(class$org$netbeans$core$windows$layers$ProducerCookie == null ? (class$org$netbeans$core$windows$layers$ProducerCookie = CookiesImpl.class$("org.netbeans.core.windows.layers.ProducerCookie")) : class$org$netbeans$core$windows$layers$ProducerCookie);
                Workspace w = (Workspace)pc.getProduct();
                if (w == null) {
                    String annotation = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$core$windows$layers$ModeData == null ? (class$org$netbeans$core$windows$layers$ModeData = CookiesImpl.class$("org.netbeans.core.windows.layers.ModeData")) : class$org$netbeans$core$windows$layers$ModeData), (String)"EXC_NoWorkspace"), primaryFile.getName());
                    throw new IOException(annotation);
                }
                this.modeImpl = (ModeImpl)w.createMode(WindowUtils.unescape(primaryFile.getName()), null, null);
            }
            return this.modeImpl;
        }

        public void save() throws IOException {
            if (this.mc != null && this.mc.invalid) {
                return;
            }
            if (this.propertyHandler == null) {
                this.propertyHandler = new PropertyHandler((ModeData)this.folder);
            }
            this.propertyHandler.writeData();
            Set savedFO = this.saveComponents();
            this.removeUnusedComponents(savedFO);
            DataObject[] arrUnsorted = this.folder.getChildren();
            arrUnsorted = CookiesImpl.validateDataObjects(arrUnsorted);
            DataObject[] arrSorted = this.sortTCRefData(this.obtainModeImpl().getLoadedTopComponents(), arrUnsorted);
            arrSorted = CookiesImpl.validateDataObjects(arrSorted);
            this.folder.setOrder(arrSorted);
            try {
                try {
                    this.setVisualUpdate(false);
                    InstanceCookie[] oldCookies = this.childrenCookies;
                    this.childrenCookies = this.createCookies();
                    this.updateComponents(this.mc, oldCookies, this.childrenCookies, 2);
                }
                catch (ClassNotFoundException e) {
                    this.childrenCookies = null;
                    FoldingIOException ioe = new FoldingIOException((Throwable)e);
                    ErrorManager.getDefault().annotate((Throwable)e, (Throwable)ioe);
                    throw ioe;
                }
                Object var7_6 = null;
                this.setVisualUpdate(true);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.setVisualUpdate(true);
                throw throwable;
            }
        }

        private void setVisualUpdate(boolean visualUpdate) {
            this.visualUpdate = visualUpdate;
        }

        private boolean isVisualUpdate() {
            return this.visualUpdate;
        }

        private Set saveComponents() throws IOException {
            ModeImpl mi = this.obtainModeImpl();
            TopComponent[] tcs = mi.getLoadedTopComponents();
            FileObject modeFo = this.folder.getPrimaryFile();
            String curId = null;
            FileObject curFO = null;
            SaveCookie curSC = null;
            PersistenceManager pm = PersistenceManager.getDefault();
            StringBuffer buffer = new StringBuffer();
            HashSet<FileObject> savedFO = new HashSet<FileObject>();
            int i = 0;
            while (i < tcs.length) {
                block11: {
                    curId = pm.lookupIdWithoutCreation(tcs[i]);
                    if (!pm.isPersistent(tcs[i], curId, mi.getWorkspace())) {
                        if (curId != null) {
                            this.deleteTcRef(curId);
                        }
                    } else {
                        try {
                            curId = pm.lookupTCStringId(tcs[i]);
                        }
                        catch (NotSerializableException nse) {
                            if (curId != null) {
                                this.deleteTcRef(curId);
                            }
                            break block11;
                        }
                        buffer.replace(0, buffer.length(), curId);
                        buffer.append('.');
                        buffer.append("wstcref");
                        curFO = FileUtil.createData((FileObject)modeFo, (String)buffer.toString());
                        curSC = (SaveCookie)DataObject.find((FileObject)curFO).getCookie(class$org$openide$cookies$SaveCookie == null ? CookiesImpl.class$("org.openide.cookies.SaveCookie") : class$org$openide$cookies$SaveCookie);
                        if (curSC != null) {
                            try {
                                curSC.save();
                            }
                            catch (IOException exc) {
                                ErrorManager.getDefault().log(4096, "WinSys - ModeData.saveComponents: Saving of " + curFO + " failed.");
                                ErrorManager.getDefault().notify(1, (Throwable)exc);
                            }
                            savedFO.add(curFO);
                        } else {
                            ErrorManager.getDefault().log(4096, "WinSys - ModeData.saveComponents: No save cookie for file obj " + curFO);
                            Thread.dumpStack();
                            this.deleteTcRef(curId);
                        }
                    }
                }
                ++i;
            }
            return savedFO;
        }

        private void removeUnusedComponents(Set savedFO) throws IOException {
            if (!this.wasCompsLoaded) {
                return;
            }
            ModeImpl mi = this.obtainModeImpl();
            if (mi.getPendingDockInto() > 0) {
                return;
            }
            TopComponent[] tcs = mi.getLoadedTopComponents();
            FileObject[] arr = this.folder.getPrimaryFile().getChildren();
            int i = 0;
            while (i < arr.length) {
                if ("wstcref".equals(arr[i].getExt()) && !savedFO.contains(arr[i])) {
                    FileLock lock = arr[i].lock();
                    arr[i].delete(lock);
                    lock.releaseLock();
                }
                ++i;
            }
        }

        private void deleteTcRef(String tcId) throws IOException {
            FileObject curFo = this.folder.getPrimaryFile().getFileObject(tcId, "wstcref");
            if (curFo != null) {
                FileLock lock = curFo.lock();
                curFo.delete(lock);
                lock.releaseLock();
            }
        }

        private static DataObject[] validateDataObjects(DataObject[] arr) {
            if (arr == null) {
                return new DataObject[0];
            }
            ArrayList<DataObject> l = new ArrayList<DataObject>(Arrays.asList(arr));
            Iterator it = l.iterator();
            while (it.hasNext()) {
                if (it.next() != null) continue;
                it.remove();
            }
            return l.toArray(new DataObject[0]);
        }

        public int getLoadedSections() {
            return this.currLoadedSections;
        }

        public int disposeDataSection(int data_id) throws IOException {
            Object object = this.DATA_ID_LOCK;
            synchronized (object) {
                this.loadedSections &= ~data_id;
            }
            throw new UnsupportedOperationException();
        }

        public int loadDataSection(int data_id) throws IOException {
            Object object = this.DATA_ID_LOCK;
            synchronized (object) {
                if (data_id == (this.loadedSections & data_id)) {
                    int n = this.loadedSections;
                    return n;
                }
                if ((data_id & 2) != 0) {
                    data_id |= 1;
                }
                this.loadedSections |= data_id;
                if ((data_id & 4) != 0) {
                    this.updateComponentIds();
                }
                try {
                    try {
                        InstanceCookie[] oldCookies = this.childrenCookies;
                        this.childrenCookies = this.createCookies();
                        this.updateAll(oldCookies, this.childrenCookies, data_id);
                    }
                    catch (ClassNotFoundException e) {
                        IOException ioe = new IOException();
                        throw (IOException)ErrorManager.getDefault().annotate((Throwable)ioe, (Throwable)e);
                    }
                    Object var6_7 = null;
                    this.currLoadedSections = this.loadedSections;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    this.currLoadedSections = this.loadedSections;
                    throw throwable;
                }
                int n = this.loadedSections;
                return n;
            }
        }

        private int loadDataSection(int data_id, ModeConfig mc, InstanceCookie[] oldC, InstanceCookie[] newC) throws IOException {
            Object object = this.DATA_ID_LOCK;
            synchronized (object) {
                if (data_id == (this.loadedSections & data_id)) {
                    int n = this.loadedSections;
                    return n;
                }
                this.loadedSections |= data_id;
                try {
                    this.updateComponents(mc, oldC, newC, data_id);
                    Object var8_7 = null;
                    this.currLoadedSections = this.loadedSections;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    this.currLoadedSections = this.loadedSections;
                    throw throwable;
                }
                int n = this.loadedSections;
                return n;
            }
        }

        private DataObject[] sortTCRefData(TopComponent[] tcs, DataObject[] arrUnsorted) throws IOException {
            if (tcs.length != arrUnsorted.length) {
                return arrUnsorted;
            }
            if (arrUnsorted.length <= 1) {
                return arrUnsorted;
            }
            ArrayList<DataObject> sorted = new ArrayList<DataObject>(arrUnsorted.length);
            int i = 0;
            while (i < tcs.length) {
                block7: {
                    String curId;
                    try {
                        curId = PersistenceManager.getDefault().lookupTCStringId(tcs[i]);
                    }
                    catch (NotSerializableException nse) {
                        break block7;
                    }
                    int j = 0;
                    while (j < arrUnsorted.length) {
                        if (arrUnsorted[j].getName().equals(curId)) {
                            sorted.add(arrUnsorted[j]);
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return sorted.toArray(new DataObject[0]);
        }

        public void destroy() throws IOException {
            this.deleteFiles(true);
        }

        public boolean isValid() {
            return this.folder.isValid() && this.folder.getPrimaryFile().isValid() && ((ModeData)this.folder).getModeConfigFO().isValid();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static /* synthetic */ void access$000(ModeConfig x0, ModeImpl x1) {
            CookiesImpl.doSetBounds(x0, x1);
        }
    }

    private static final class DominanceEntry {
        public String constraint;
        public int percSize;
        public Rectangle absBounds;
        public Rectangle relBounds;

        DominanceEntry() {
        }
    }

    private static final class ModeConfig {
        public String name;
        public String displayName;
        public String frameType;
        public String containerType;
        public String constraints;
        public String activeTc;
        public String nameBundle;
        public String moduleCodeNameBase;
        public String moduleCodeNameRelease;
        public String moduleSpecificationVersion;
        public String description;
        public String descriptionBundle;
        public int userDefined;
        public int fromBundle;
        public int modeState;
        public int frameState;
        public int restoredFrameState;
        public Rectangle bounds;
        public Rectangle maximizedBounds;
        public Rectangle relativeBounds;
        public ArrayList dominance;
        public URL iconURL;
        public boolean invalid;

        ModeConfig() {
        }

        public void clear() {
            this.bounds = null;
            this.maximizedBounds = null;
            this.relativeBounds = null;
            this.dominance = null;
        }
    }
}

