/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.windows.MainWindow;
import org.netbeans.core.windows.util.WindowUtils;

final class StateManager
extends ComponentAdapter
implements PropertyChangeListener {
    public static final int READY = 32;
    public static final int SERIALIZING = 64;
    public static final int DESERIALIZING = 128;
    public static final int SWITCHING = 256;
    public static final int VISIBLE = 1;
    public static final int INVISIBLE = 2;
    public static final int NOT_PRESENT = 4;
    private int mainState;
    private int visibilityState;
    private HashSet listeners;
    private boolean initialized = false;
    private static StateManager defaultInstance;

    private StateManager() {
    }

    public static synchronized StateManager getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new StateManager();
        }
        return defaultInstance;
    }

    private void initialize() {
        this.mainState = 32;
        if (NbTopManager.getUninitialized().isInteractive(1)) {
            MainWindow mainWindow = MainWindow.getDefault();
            this.visibilityState = mainWindow.isVisible() ? 1 : 2;
            mainWindow.addComponentListener(this);
            ((Component)mainWindow).addPropertyChangeListener("aboutToShow", this);
        } else {
            this.visibilityState = 4;
        }
    }

    public synchronized void addStateListener(StateListener sl) {
        if (!this.initialized) {
            this.initialized = true;
            this.initialize();
        }
        if (this.listeners == null) {
            this.listeners = new HashSet(10);
        }
        this.listeners.add(sl);
    }

    public synchronized void removeStateListener(StateListener sl) {
        if (this.listeners != null) {
            this.listeners.remove(sl);
        }
    }

    public int getState() {
        if (!this.initialized) {
            this.initialized = true;
            this.initialize();
        }
        return this.mainState | this.visibilityState;
    }

    void fireStateChanged(int state) {
        if (this.listeners == null) {
            return;
        }
        HashSet cloned = null;
        StateManager stateManager = this;
        synchronized (stateManager) {
            cloned = (HashSet)this.listeners.clone();
        }
        Iterator iter = cloned.iterator();
        while (iter.hasNext()) {
            ((StateListener)iter.next()).stateChanged(state);
        }
    }

    void setMainState(int state) {
        if (!this.initialized) {
            this.initialized = true;
            this.initialize();
        }
        if (state == this.mainState) {
            return;
        }
        this.mainState = state;
        this.fireStateChanged(this.mainState | this.visibilityState);
    }

    private void setVisibilityState(int state) {
        if (this.visibilityState == state) {
            return;
        }
        this.visibilityState = state;
        this.fireStateChanged(this.mainState | this.visibilityState);
    }

    public void componentHidden(ComponentEvent e) {
        this.setVisibilityState(2);
    }

    public void componentShown(ComponentEvent e) {
        this.setVisibilityState(1);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        MainWindow.getDefault().removePropertyChangeListener("aboutToShow", this);
        if (WindowUtils.isMdi()) {
            this.setVisibilityState(1);
        }
    }

    static interface StateListener {
        public void stateChanged(int var1);
    }
}

