/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.DeferredPerformer;
import org.netbeans.core.windows.WindowManagerImpl;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.InstanceDataObject;
import org.openide.util.NbBundle;
import org.openide.util.io.SafeException;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public final class PersistenceManager
implements PropertyChangeListener {
    public static final String ROOT_FOLDER = "Windows";
    public static final String COMPS_FOLDER = "Components";
    public static final String WINDOWMANAGER_FOLDER = "WindowManager";
    public static final String PERSISTENCE_TYPE = "PersistenceType";
    public static final String NEVER_PERSISTENT = "Never";
    public static final String ONLY_OPENED_PERSISTENT = "OnlyOpened";
    private static final String DEFAULT_TC_NAME = "untitled_tc";
    private FileObject rootFolder;
    private FileObject componentsFolder;
    private FileObject wmFolder;
    private WeakHashMap createdTCPairs;
    private Map createdStringIDPairs;
    private WeakHashMap mapDo2TcId;
    private Set invalidIds;
    private FileSystem rwFS;
    private boolean readProcessed = false;
    private Set removalCandidates;
    private boolean isSaveInProgress;
    private Object counterLock = new Object();
    private int writeXMLPlanned;
    private static PersistenceManager defaultInstance;
    static /* synthetic */ Class class$org$netbeans$core$windows$PersistenceManager;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$openide$loaders$InstanceDataObject;

    private PersistenceManager() {
    }

    public static synchronized PersistenceManager getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new PersistenceManager();
        }
        return defaultInstance;
    }

    public void setRootFolder(FileObject folder) {
        this.rootFolder = folder;
        this.clearCache();
    }

    public FileObject getRootFolder() {
        try {
            if (this.rootFolder == null) {
                this.rootFolder = FileUtil.createFolder((FileObject)this.getFileSystem().getRoot(), (String)ROOT_FOLDER);
            }
            return this.rootFolder;
        }
        catch (IOException exc) {
            String annotation = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$PersistenceManager == null ? (class$org$netbeans$core$windows$PersistenceManager = PersistenceManager.class$("org.netbeans.core.windows.PersistenceManager")) : class$org$netbeans$core$windows$PersistenceManager), (String)"EXC_RootFolder", (Object[])new Object[]{ROOT_FOLDER});
            ErrorManager.getDefault().annotate((Throwable)exc, annotation);
            ErrorManager.getDefault().notify(65536, (Throwable)exc);
            return null;
        }
    }

    public FileObject getComponentsFolder() {
        try {
            if (this.componentsFolder == null) {
                this.componentsFolder = FileUtil.createFolder((FileObject)this.getRootFolder(), (String)COMPS_FOLDER);
            }
            return this.componentsFolder;
        }
        catch (IOException exc) {
            String annotation = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$PersistenceManager == null ? (class$org$netbeans$core$windows$PersistenceManager = PersistenceManager.class$("org.netbeans.core.windows.PersistenceManager")) : class$org$netbeans$core$windows$PersistenceManager), (String)"EXC_CompsFolder", (Object[])new Object[]{COMPS_FOLDER});
            ErrorManager.getDefault().annotate((Throwable)exc, annotation);
            ErrorManager.getDefault().notify(65536, (Throwable)exc);
            return null;
        }
    }

    public FileObject getWindowManagerFolder() {
        try {
            if (this.wmFolder == null) {
                this.wmFolder = FileUtil.createFolder((FileObject)this.getRootFolder(), (String)WINDOWMANAGER_FOLDER);
                StringBuffer buf = new StringBuffer(WINDOWMANAGER_FOLDER);
                buf.append('.');
                buf.append("wswmgr");
                FileUtil.createData((FileObject)this.getRootFolder(), (String)buf.toString());
            }
            return this.wmFolder;
        }
        catch (IOException exc) {
            String annotation = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$PersistenceManager == null ? (class$org$netbeans$core$windows$PersistenceManager = PersistenceManager.class$("org.netbeans.core.windows.PersistenceManager")) : class$org$netbeans$core$windows$PersistenceManager), (String)"EXC_WindowManagerFolder", (Object[])new Object[]{WINDOWMANAGER_FOLDER});
            ErrorManager.getDefault().annotate((Throwable)exc, annotation);
            ErrorManager.getDefault().notify(65536, (Throwable)exc);
            return null;
        }
    }

    public void cleanXML() throws IOException {
        WindowManagerImpl wmi = (WindowManagerImpl)WindowManager.getDefault();
        Workspace[] ws = wmi.getWorkspaces();
        int i = 0;
        while (i < ws.length) {
            Set modes = ws[i].getModes();
            ++i;
        }
    }

    public void writeXML() throws IOException {
        if (!this.readProcessed) {
            return;
        }
        try {
            DataObject windowManagerFolder = DataObject.find((FileObject)this.getWindowManagerFolder());
            SaveCookie sc = (SaveCookie)windowManagerFolder.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = PersistenceManager.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
            this.setSaveInProgress(true);
            if (sc != null) {
                this.forceSaveOfTopComponents();
                PersistenceManager persistenceManager = this;
                synchronized (persistenceManager) {
                    sc.save();
                }
            } else {
                IOException ex = new IOException("Window system could not be saved: no save cookie found");
                ErrorManager emgr = ErrorManager.getDefault();
                emgr.annotate((Throwable)ex, 0, "DataObject: " + windowManagerFolder, null, null, null);
                emgr.annotate((Throwable)ex, 0, "Other files in that dir: " + Arrays.asList(this.getWindowManagerFolder().getParent().getChildren()), null, null, null);
                throw ex;
            }
            this.cleanupComponents();
            Object var6_7 = null;
            this.setSaveInProgress(false);
            ((WindowManagerImpl)WindowManager.getDefault()).checkPersistenceErrors(false);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.setSaveInProgress(false);
            ((WindowManagerImpl)WindowManager.getDefault()).checkPersistenceErrors(false);
            throw throwable;
        }
    }

    private boolean isWriteFinished() {
        boolean ret;
        Object object = this.counterLock;
        synchronized (object) {
            ret = this.writeXMLPlanned == 0;
        }
        return ret;
    }

    public void writeXMLWaiting() throws IOException {
        block7: {
            try {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.writeXML();
                    break block7;
                }
                Object object = this.counterLock;
                synchronized (object) {
                    ++this.writeXMLPlanned;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        try {
                            try {
                                PersistenceManager.this.writeXML();
                            }
                            catch (IOException exc) {
                                ErrorManager em = ErrorManager.getDefault();
                                em.notify(1, (Throwable)exc);
                                Object var4_2 = null;
                                Object object2 = PersistenceManager.this.counterLock;
                                synchronized (object2) {
                                    PersistenceManager.this.writeXMLPlanned--;
                                    return;
                                }
                            }
                            Object var4_1 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_3 = null;
                            Object object = PersistenceManager.this.counterLock;
                            synchronized (object) {
                                PersistenceManager.this.writeXMLPlanned--;
                                throw throwable;
                            }
                        }
                        Object object = PersistenceManager.this.counterLock;
                        synchronized (object) {
                            PersistenceManager.this.writeXMLPlanned--;
                            return;
                        }
                    }
                });
                while (DeferredPerformer.getDefault().isProcessing() || !this.isWriteFinished()) {
                    Thread.currentThread();
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException exc) {
                ErrorManager.getDefault().notify(1, (Throwable)exc);
            }
        }
    }

    public void setSaveInProgress(boolean isSaveInProgress) {
        this.isSaveInProgress = isSaveInProgress;
    }

    public boolean isSaveInProgress() {
        return this.isSaveInProgress;
    }

    public void readXML() throws IOException, ClassNotFoundException {
        this.readProcessed = true;
        try {
            DataObject windowManagerFolder = DataObject.find((FileObject)this.getWindowManagerFolder());
            InstanceCookie ic = (InstanceCookie)windowManagerFolder.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = PersistenceManager.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
            if (ic == null) {
                Object var6_3 = null;
                ((WindowManagerImpl)WindowManager.getDefault()).checkPersistenceErrors(true);
                return;
            }
            PersistenceManager persistenceManager = this;
            synchronized (persistenceManager) {
                ic.instanceCreate();
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            ((WindowManagerImpl)WindowManager.getDefault()).checkPersistenceErrors(true);
            throw throwable;
        }
        Object var6_4 = null;
        ((WindowManagerImpl)WindowManager.getDefault()).checkPersistenceErrors(true);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        TopComponent tc;
        WeakReference result;
        String tc_id;
        Object obj;
        InstanceCookie ic;
        if ("cookie".equals(evt.getPropertyName()) && (ic = (InstanceCookie)((DataObject)(obj = evt.getSource())).getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = PersistenceManager.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie)) == null && (tc_id = (String)this.mapDo2TcId().remove(obj)) != null && (result = (WeakReference)this.createdStringIDPairs().remove(tc_id)) != null && (tc = (TopComponent)result.get()) != null) {
            this.createdTCPairs().remove(tc);
        }
    }

    public String lookupTCStringId(TopComponent tc) throws IOException {
        String result = (String)this.createdTCPairs().get(tc);
        if (this.isInvalidId(result)) {
            return this.restorePair(tc, result, true);
        }
        if (result != null) {
            return result;
        }
        return this.createNewPair(tc);
    }

    public String lookupIdWithoutCreation(TopComponent tc) throws IOException {
        String result = (String)this.createdTCPairs().get(tc);
        if (this.isInvalidId(result)) {
            result = this.restorePair(tc, result, false);
        }
        return result;
    }

    public TopComponent lookupTCInstance(String stringId) throws IOException {
        WeakReference result = (WeakReference)this.createdStringIDPairs().get(stringId);
        if (result != null) {
            TopComponent tc = (TopComponent)result.get();
            if (tc != null) {
                return tc;
            }
            this.createdStringIDPairs().remove(stringId);
            this.removalCandidates().add(stringId);
        }
        Throwable resultExc = null;
        Object o = PersistenceManager.locateTCRef(this.getComponentsFolder(), stringId);
        if (o != null) {
            DataObject dob = o instanceof DataObject ? (DataObject)o : DataObject.find((FileObject)((FileObject)o));
            InstanceCookie ic = (InstanceCookie)dob.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = PersistenceManager.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
            if (ic != null) {
                try {
                    TopComponent tc = (TopComponent)ic.instanceCreate();
                    this.createdTCPairs().put(tc, stringId);
                    this.createdStringIDPairs().put(stringId, new WeakReference<TopComponent>(tc));
                    this.mapDo2TcId().put(dob, stringId);
                    dob.addPropertyChangeListener((PropertyChangeListener)this);
                    return tc;
                }
                catch (InvalidObjectException ioe) {
                    ErrorManager.getDefault().log(16, "[WinSys] Problem when deserializing. Reason: " + ioe.getMessage());
                    throw new SafeException((Exception)ioe);
                }
                catch (DataObjectNotFoundException dnfe) {
                    ErrorManager.getDefault().log(16, "[WinSys] Problem when deserializing. Object not found: " + dnfe.getMessage() + ". It was probably deleted.");
                    throw new SafeException((Exception)((Object)dnfe));
                }
                catch (ClassNotFoundException exc) {
                    resultExc = new IOException();
                    ErrorManager.getDefault().annotate(resultExc, (Throwable)exc);
                }
                catch (ClassCastException exc) {
                    resultExc = new IOException();
                    ErrorManager.getDefault().annotate(resultExc, (Throwable)exc);
                }
            } else {
                String excAnnotation = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$PersistenceManager == null ? (class$org$netbeans$core$windows$PersistenceManager = PersistenceManager.class$("org.netbeans.core.windows.PersistenceManager")) : class$org$netbeans$core$windows$PersistenceManager), (String)"EXC_BrokenTCSetting", (Object[])new Object[]{stringId});
                resultExc = new SafeException((Exception)new IOException(excAnnotation));
            }
        } else {
            String excAnnotation = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$PersistenceManager == null ? (class$org$netbeans$core$windows$PersistenceManager = PersistenceManager.class$("org.netbeans.core.windows.PersistenceManager")) : class$org$netbeans$core$windows$PersistenceManager), (String)"EXC_FailedLocateTC", (Object[])new Object[]{stringId});
            resultExc = new FileNotFoundException(excAnnotation);
        }
        throw resultExc;
    }

    public void deleteTCData(String stringId) throws IOException {
        Object o = PersistenceManager.locateTCRef(this.getComponentsFolder(), stringId);
        if (o != null && o instanceof DataObject) {
            ((DataObject)o).delete();
        } else if (o != null) {
            DataObject.find((FileObject)((FileObject)o)).delete();
        }
    }

    private static Object locateTCRef(FileObject folder, String name) throws IOException {
        FileObject fo = folder.getFileObject(name, "settings");
        if (fo != null) {
            return fo;
        }
        fo = folder.getFileObject(name, "ser");
        if (fo != null) {
            return fo;
        }
        fo = folder.getFileObject(name, "xml");
        if (fo != null) {
            return fo;
        }
        Enumeration e = folder.getChildren(false);
        while (e.hasMoreElements()) {
            fo = (FileObject)e.nextElement();
            DataObject dob = DataObject.find((FileObject)fo);
            if (!dob.getName().equals(name)) continue;
            return dob;
        }
        DataFolder dfolder = DataFolder.findFolder((FileObject)folder);
        e = dfolder.children();
        while (e.hasMoreElements()) {
            DataObject dob = (DataObject)e.nextElement();
            if (!dob.getName().equals(name)) continue;
            return dob;
        }
        return null;
    }

    public boolean isPersistent(TopComponent tc, String strId, Workspace workspace) {
        String prop = (String)tc.getClientProperty(PERSISTENCE_TYPE);
        if (NEVER_PERSISTENT.equals(prop) || ONLY_OPENED_PERSISTENT.equals(prop) && !tc.isOpened(workspace)) {
            if (strId != null) {
                this.removalCandidates().add(strId);
            }
            return false;
        }
        return true;
    }

    private void cleanupComponents() {
        String[] idArray;
        Map createdStringIDPairs;
        String curId = null;
        Map map = createdStringIDPairs = this.createdStringIDPairs();
        synchronized (map) {
            idArray = createdStringIDPairs.keySet().toArray(new String[0]);
        }
        Object curWr = null;
        int i = 0;
        while (i < idArray.length) {
            if (((WeakReference)createdStringIDPairs.get(idArray[i])).get() == null) {
                this.createdStringIDPairs().remove(idArray[i]);
                this.removalCandidates().add(idArray[i]);
            }
            ++i;
        }
        FileObject foundRef = null;
        Iterator iter = this.removalCandidates().iterator();
        while (iter.hasNext()) {
            curId = (String)iter.next();
            foundRef = this.findTcRef(this.getWindowManagerFolder(), curId);
            if (foundRef != null) continue;
            try {
                this.deleteTCData(curId);
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
        }
        this.removalCandidates().clear();
    }

    void forceSaveOfTopComponents() {
        HashMap createdStringIDPairs;
        Map origPairs;
        DataFolder compsFolder = DataFolder.findFolder((FileObject)this.getComponentsFolder());
        Map map = origPairs = this.createdStringIDPairs();
        synchronized (map) {
            createdStringIDPairs = new HashMap(origPairs);
        }
        TopComponent curTC = null;
        Map.Entry curEntry = null;
        Iterator iter = createdStringIDPairs.entrySet().iterator();
        while (iter.hasNext()) {
            curEntry = iter.next();
            curTC = (TopComponent)((WeakReference)curEntry.getValue()).get();
            if (curTC == null) continue;
            try {
                FileObject fo = compsFolder.getPrimaryFile().getFileObject((String)curEntry.getKey(), "settings");
                DataObject ido = null;
                if (fo != null) {
                    ido = DataObject.find((FileObject)fo);
                }
                if (ido == null) {
                    InstanceDataObject.create((DataFolder)compsFolder, (String)((String)curEntry.getKey()), (Object)curTC, null);
                    continue;
                }
                SaveCookie sc = (SaveCookie)ido.getCookie(class$org$openide$cookies$SaveCookie == null ? PersistenceManager.class$("org.openide.cookies.SaveCookie") : class$org$openide$cookies$SaveCookie);
                if (sc == null) continue;
                sc.save();
            }
            catch (NotSerializableException nse) {
                this.createdTCPairs().remove(curTC);
                iter.remove();
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify(16, (Throwable)exc);
            }
            catch (RuntimeException exc) {
                String annotation = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$PersistenceManager == null ? PersistenceManager.class$("org.netbeans.core.windows.PersistenceManager") : class$org$netbeans$core$windows$PersistenceManager), (String)"EXC_CannotSaveTCSettings", (Object)curTC.getName());
                ErrorManager.getDefault().annotate((Throwable)exc, annotation);
                ErrorManager.getDefault().notify(1, (Throwable)exc);
            }
            catch (LinkageError le) {
                String annotation = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$PersistenceManager == null ? PersistenceManager.class$("org.netbeans.core.windows.PersistenceManager") : class$org$netbeans$core$windows$PersistenceManager), (String)"EXC_CannotSaveTCSettings", (Object)curTC.getName());
                ErrorManager.getDefault().annotate((Throwable)le, annotation);
                ErrorManager.getDefault().notify(1, (Throwable)le);
            }
        }
    }

    private FileObject findTcRef(FileObject folder, String tcId) {
        FileObject result = folder.getFileObject(tcId, "wstcref");
        if (result != null) {
            return result;
        }
        FileObject[] childrenArray = folder.getChildren();
        int i = 0;
        while (i < childrenArray.length) {
            if (childrenArray[i].isFolder() && (result = this.findTcRef(childrenArray[i], tcId)) != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private Set removalCandidates() {
        if (this.removalCandidates == null) {
            this.removalCandidates = new HashSet(20);
        }
        return this.removalCandidates;
    }

    private FileSystem getFileSystem() {
        if (this.rwFS == null) {
            this.rwFS = Repository.getDefault().getDefaultFileSystem();
        }
        return this.rwFS;
    }

    private void clearCache() {
        this.componentsFolder = null;
        this.wmFolder = null;
    }

    private static String convertString2ValidFileName(String name) {
        String newName = name.replace('/', '_');
        newName = newName.replace('\\', '_');
        newName = newName.replace('[', '_');
        newName = newName.replace(']', '_');
        newName = newName.replace(' ', '_');
        return newName;
    }

    private static String escape(String name) throws IOException {
        try {
            Method escape = (class$org$openide$loaders$InstanceDataObject == null ? (class$org$openide$loaders$InstanceDataObject = PersistenceManager.class$("org.openide.loaders.InstanceDataObject")) : class$org$openide$loaders$InstanceDataObject).getDeclaredMethod("escapeAndCut", class$java$lang$String == null ? (class$java$lang$String = PersistenceManager.class$("java.lang.String")) : class$java$lang$String);
            ((AccessibleObject)escape).setAccessible(true);
            return (String)escape.invoke(null, (Object[])new String[]{name});
        }
        catch (Exception ex) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException("Escape support failed"), (Throwable)ex);
        }
    }

    private String createNewPair(TopComponent tc) throws IOException {
        DataFolder compsFolder = DataFolder.findFolder((FileObject)this.getComponentsFolder());
        String compName = tc.getName();
        if (compName == null || compName.length() == 0) {
            compName = DEFAULT_TC_NAME;
        }
        boolean isUsed = true;
        String srcName = compName;
        int i = 1;
        while (isUsed) {
            isUsed = false;
            String escaped = PersistenceManager.escape(srcName);
            String uniqueName = FileUtil.findFreeFileName((FileObject)compsFolder.getPrimaryFile(), (String)escaped, (String)"settings");
            if ((this.invalidIds == null || !this.invalidIds.contains(uniqueName)) && escaped.equals(uniqueName)) continue;
            isUsed = true;
            srcName = compName + "_" + i;
            ++i;
        }
        InstanceDataObject ido = InstanceDataObject.create((DataFolder)compsFolder, (String)srcName, (Object)tc, null);
        String fileName = ido.getPrimaryFile().getName();
        this.createdTCPairs().put(tc, fileName);
        this.createdStringIDPairs().put(fileName, new WeakReference<TopComponent>(tc));
        return fileName;
    }

    private String restorePair(TopComponent tc, String id, boolean create) throws IOException {
        FileObject fo = this.getComponentsFolder().getFileObject(id, "settings");
        if (fo != null) {
            this.createdTCPairs().put(tc, id);
            this.createdStringIDPairs().put(id, new WeakReference<TopComponent>(tc));
            this.validateId(id);
            return id;
        }
        if (create) {
            return this.createNewPair(tc);
        }
        return null;
    }

    private Map createdTCPairs() {
        if (this.createdTCPairs == null) {
            this.createdTCPairs = new WeakHashMap(30);
        }
        return this.createdTCPairs;
    }

    private Map createdStringIDPairs() {
        if (this.createdStringIDPairs == null) {
            this.createdStringIDPairs = Collections.synchronizedMap(new HashMap(30));
        }
        return this.createdStringIDPairs;
    }

    private Map mapDo2TcId() {
        if (this.mapDo2TcId == null) {
            this.mapDo2TcId = new WeakHashMap(30);
        }
        return this.mapDo2TcId;
    }

    void resetTCPairs() {
        if (this.createdTCPairs != null) {
            this.invalidIds = new HashSet(((AbstractMap)this.createdTCPairs).values());
        }
        this.createdStringIDPairs = null;
    }

    private boolean isInvalidId(String id) {
        return this.invalidIds == null ? false : this.invalidIds.contains(id);
    }

    private void validateId(String id) {
        if (this.invalidIds != null) {
            this.invalidIds.remove(id);
            if (this.invalidIds.size() == 0) {
                this.invalidIds = null;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

