/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.projects.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import org.netbeans.core.projects.cache.LayerCacheManager;
import org.netbeans.core.projects.cache.ParsingLayerCacheManager;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.xml.sax.SAXException;

public class XMLLayerCacheManagerImpl
extends ParsingLayerCacheManager {
    private static final String ALL_LAYERS = "all-layers.xml";
    private final File cacheFile;
    private static final String SPACES = "                                                                                        ";
    private static final int SPACES_LENGTH = "                                                                                        ".length();
    private static final int INDENT = 4;

    public XMLLayerCacheManagerImpl(File cacheDir) throws IOException {
        super(cacheDir);
        this.cacheFile = new File(cacheDir, ALL_LAYERS);
    }

    public boolean cacheExists() {
        return this.cacheFile.exists();
    }

    public void cleanupCache() throws IOException {
        if (this.cacheFile.exists() && !this.cacheFile.delete()) {
            throw new IOException("Could not delete: " + this.cacheFile);
        }
    }

    public boolean supportsLoad() {
        return true;
    }

    public FileSystem createEmptyFileSystem() throws IOException {
        return new XMLFileSystem();
    }

    public FileSystem createLoadedFileSystem() throws IOException {
        if (this.cacheFile.exists()) {
            try {
                LayerCacheManager.err.log("Loading freshly from " + this.cacheFile);
                return new XMLFileSystem(Utilities.toURL((File)this.cacheFile));
            }
            catch (SAXException saxe) {
                IOException ioe = new IOException(saxe.toString());
                LayerCacheManager.err.annotate((Throwable)ioe, (Throwable)saxe);
                throw ioe;
            }
        }
        throw new IllegalStateException();
    }

    public void load(FileSystem fs) throws IOException {
        try {
            LayerCacheManager.err.log("Loading from " + this.cacheFile);
            ((XMLFileSystem)fs).setXmlUrl(Utilities.toURL((File)this.cacheFile));
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.toString());
            LayerCacheManager.err.annotate((Throwable)ioe, (Throwable)e);
            throw ioe;
        }
    }

    protected boolean openURLs() {
        return false;
    }

    protected void store(FileSystem fs, ParsingLayerCacheManager.MemFolder root) throws IOException {
        LayerCacheManager.err.log("Writing XML cache to " + this.cacheFile);
        if (this.cacheFile.exists()) {
            this.cacheFile.delete();
        }
        FileOutputStream os = new FileOutputStream(this.cacheFile);
        try {
            XMLLayerCacheManagerImpl.writeOut(root, os, Boolean.getBoolean("netbeans.cache.layers.prettyprint"), this.getCacheDirectory());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((OutputStream)os).close();
            throw throwable;
        }
        ((OutputStream)os).close();
        this.load(fs);
    }

    private static void writeOut(ParsingLayerCacheManager.MemFolder root, OutputStream out, boolean pretty, File datadir) throws IOException {
        OutputStreamWriter wr = new OutputStreamWriter(out, "UTF-8");
        wr.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        wr.write("<?xml-stylesheet type=\"text/xml\" href=\"http://openide.netbeans.org/fs/filesystem.xsl\"?>\n");
        wr.write("<!DOCTYPE filesystem PUBLIC \"-//NetBeans//DTD Filesystem 1.1//EN\" \"http://www.netbeans.org/dtds/filesystem-1_1.dtd\">\n");
        wr.write("<!-- Module layer cache generated by NetBeans. Do not edit. -->\n");
        wr.write("<filesystem");
        if (XMLLayerCacheManagerImpl.writeAttrs(wr, root.attrs, 1, pretty)) {
            wr.write(">");
            if (pretty) {
                ((Writer)wr).write(10);
            }
        }
        XMLLayerCacheManagerImpl.writeFolder(wr, root, 1, pretty, datadir);
        wr.write("</filesystem>\n");
        ((Writer)wr).close();
    }

    private static String space(int n) {
        int size = n * 4;
        if (size <= SPACES_LENGTH) {
            return SPACES.substring(0, size);
        }
        StringBuffer buf = new StringBuffer(size);
        int i = 0;
        while (i < size) {
            buf.append(' ');
            ++i;
        }
        return buf.toString();
    }

    private static void writeFolder(Writer wr, ParsingLayerCacheManager.MemFolder elem, int depth, boolean pretty, File datadir) throws IOException {
        if (elem.children == null) {
            return;
        }
        Iterator it = elem.children.iterator();
        while (it.hasNext()) {
            String url;
            ParsingLayerCacheManager.MemFileOrFolder child = (ParsingLayerCacheManager.MemFileOrFolder)it.next();
            if (child instanceof ParsingLayerCacheManager.MemFolder) {
                if (pretty) {
                    wr.write(XMLLayerCacheManagerImpl.space(depth));
                }
                wr.write("<folder name=\"");
                wr.write(XMLUtil.toAttributeValue((String)child.name));
                wr.write(34);
                if (XMLLayerCacheManagerImpl.writeAttrs(wr, child.attrs, depth + 1, pretty)) {
                    wr.write(62);
                    if (pretty) {
                        wr.write(10);
                    }
                }
                XMLLayerCacheManagerImpl.writeFolder(wr, (ParsingLayerCacheManager.MemFolder)child, depth + 1, pretty, datadir);
                if (pretty) {
                    wr.write(XMLLayerCacheManagerImpl.space(depth));
                }
                wr.write("</folder>");
                if (!pretty) continue;
                wr.write(10);
                continue;
            }
            ParsingLayerCacheManager.MemFile file = (ParsingLayerCacheManager.MemFile)child;
            if (pretty) {
                wr.write(XMLLayerCacheManagerImpl.space(depth));
            }
            wr.write("<file name=\"");
            wr.write(XMLUtil.toAttributeValue((String)child.name));
            String string = url = file.ref != null ? file.ref.toExternalForm() : null;
            if (file.contents != null) {
                if (url != null) {
                    throw new IOException("url attr and contents too: url=" + url + " content=" + new String(file.contents) + " file name=" + child.name);
                }
                CRC32 crc = new CRC32();
                crc.update(file.contents);
                String hex = Long.toHexString(crc.getValue());
                while (hex.length() < 8) {
                    hex = "0" + hex;
                }
                File data = new File(datadir, "data_" + hex);
                url = Utilities.toURL((File)data).toString();
                if (!data.isFile()) {
                    Object var14_13;
                    FileOutputStream os = new FileOutputStream(data);
                    try {
                        ((OutputStream)os).write(file.contents);
                        var14_13 = null;
                    }
                    catch (Throwable throwable) {
                        var14_13 = null;
                        ((OutputStream)os).close();
                        throw throwable;
                    }
                    ((OutputStream)os).close();
                    {
                    }
                }
            }
            if (url != null) {
                wr.write("\" url=\"");
                wr.write(XMLUtil.toAttributeValue((String)url));
            }
            wr.write(34);
            if (XMLLayerCacheManagerImpl.writeAttrs(wr, child.attrs, depth + 1, pretty)) {
                wr.write("/>");
                if (!pretty) continue;
                wr.write(10);
                continue;
            }
            if (pretty) {
                wr.write(XMLLayerCacheManagerImpl.space(depth));
            }
            wr.write("</file>");
            if (!pretty) continue;
            wr.write(10);
        }
    }

    private static boolean writeAttrs(Writer wr, List attrs, int depth, boolean pretty) throws IOException {
        if (attrs == null) {
            return true;
        }
        Iterator attri = attrs.iterator();
        if (!attri.hasNext()) {
            return true;
        }
        wr.write(62);
        if (pretty) {
            wr.write(10);
        }
        while (attri.hasNext()) {
            ParsingLayerCacheManager.MemAttr a = (ParsingLayerCacheManager.MemAttr)attri.next();
            if (pretty) {
                wr.write(XMLLayerCacheManagerImpl.space(depth));
            }
            wr.write("<attr name=\"");
            wr.write(XMLUtil.toAttributeValue((String)a.name));
            wr.write("\" ");
            wr.write(a.type);
            wr.write("=\"");
            wr.write(XMLUtil.toAttributeValue((String)a.data));
            wr.write("\"/>");
            if (!pretty) continue;
            wr.write(10);
        }
        return false;
    }
}

