/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.projects;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.io.NbObjectOutputStream;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

final class XMLSettingsSupport {
    public static final String INSTANCE_DTD_ID = "-//NetBeans//DTD Session settings 1.0//EN";
    public static final String INSTANCE_DTD_WWW = "http://www.netbeans.org/dtds/sessionsettings-1_0.dtd";
    public static final String INSTANCE_DTD_LOCAL = "/org/openide/resources/sessionsettings-1_0.dtd";
    public static final String XML_EXT = "settings";
    private static final char[] HEXDIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7'};
    private static final int INDENT = 8;
    private static final int BLOCK = 100;
    private static final int BUFFSIZE = 108;
    static /* synthetic */ Class class$org$openide$ServiceType;

    XMLSettingsSupport() {
    }

    private static void storeInstanceOf(Set classes, PrintWriter pw) throws IOException {
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            Class clazz = (Class)it.next();
            pw.print("    <instanceof class=\"");
            pw.print(clazz.getName());
            pw.println("\"/>");
        }
    }

    public static void storeToXML10(Object inst, Writer os, ModuleInfo mi) throws IOException {
        PrintWriter pw = new PrintWriter(os);
        pw.println("<?xml version=\"1.0\"?>");
        pw.print("<!DOCTYPE settings PUBLIC \"");
        pw.print(INSTANCE_DTD_ID);
        pw.print("\" \"");
        pw.print(INSTANCE_DTD_WWW);
        pw.println("\">");
        pw.println("<settings version=\"1.0\">");
        XMLSettingsSupport.storeModule(mi, pw);
        XMLSettingsSupport.storeInstanceOf(XMLSettingsSupport.getSuperClasses(inst.getClass(), null), pw);
        XMLSettingsSupport.storeSerialData(inst, pw);
        pw.println("</settings>");
        pw.flush();
    }

    public static void storeToXML10(Class clazz, Writer os, ModuleInfo mi) throws IOException {
        PrintWriter pw = new PrintWriter(os);
        pw.println("<?xml version=\"1.0\"?>");
        pw.print("<!DOCTYPE settings PUBLIC \"");
        pw.print(INSTANCE_DTD_ID);
        pw.print("\" \"");
        pw.print(INSTANCE_DTD_WWW);
        pw.println("\">");
        pw.println("<settings version=\"1.0\">");
        XMLSettingsSupport.storeModule(mi, pw);
        XMLSettingsSupport.storeInstanceOf(XMLSettingsSupport.getSuperClasses(clazz, null), pw);
        pw.print("    <instance class=\"");
        pw.print(clazz.getName());
        pw.println("\"/>");
        pw.println("</settings>");
        pw.flush();
    }

    private static void storeModule(ModuleInfo mi, PrintWriter pw) throws IOException {
        if (mi == null) {
            return;
        }
        String modulName = mi.getCodeName();
        SpecificationVersion spec = mi.getSpecificationVersion();
        pw.print("    <module");
        if (modulName != null && modulName.length() != 0) {
            pw.print(" name=\"");
            pw.print(modulName);
            pw.print('\"');
        }
        if (spec != null) {
            pw.print(" spec=\"");
            pw.print(spec.toString());
            pw.print('\"');
        }
        pw.println("/>");
    }

    private static void storeSerialData(Object inst, PrintWriter pw) throws IOException {
        pw.print("    <serialdata class=\"");
        pw.print(inst.getClass().getName());
        pw.println("\">");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        SpecialObjectOutputStream oo = new SpecialObjectOutputStream(baos);
        oo.writeObject(inst);
        byte[] bdata = baos.toByteArray();
        char[] cdata = new char[108];
        int i = 0;
        while (i < 8) {
            cdata[i] = 32;
            ++i;
        }
        int i2 = 0;
        int blen = bdata.length;
        while (i2 < blen) {
            int mark = 8 + Math.min(2 * (blen - i2), 100);
            int j = 8;
            while (j < mark) {
                int b = bdata[i2++] + 256;
                cdata[j] = HEXDIGITS[b >> 4];
                cdata[j + 1] = HEXDIGITS[b & 0xF];
                j += 2;
            }
            pw.write(cdata, 0, j);
            pw.println();
        }
        pw.println("    </serialdata>");
        pw.flush();
    }

    private static Set getSuperClasses(Class clazz, Set classes) {
        if (classes == null) {
            classes = new HashSet<Class>();
        }
        if (clazz == null || !classes.add(clazz)) {
            return classes;
        }
        Class<?>[] cs = clazz.getInterfaces();
        if (cs != null) {
            int i = 0;
            while (i < cs.length) {
                XMLSettingsSupport.getSuperClasses(cs[i], classes);
                ++i;
            }
        } else {
            ErrorManager.getDefault().log(65536, "Error: if you encounter this message, please attach the class name to the issue http://www.netbeans.org/issues/show_bug.cgi?id=16257. Class.getInterfaces() == null for the class: " + clazz);
        }
        return XMLSettingsSupport.getSuperClasses(clazz.getSuperclass(), classes);
    }

    /*
     * Unable to fully structure code
     */
    private static Class getServiceTypeClass(Class type) {
        if ((XMLSettingsSupport.class$org$openide$ServiceType == null ? (XMLSettingsSupport.class$org$openide$ServiceType = XMLSettingsSupport.class$("org.openide.ServiceType")) : XMLSettingsSupport.class$org$openide$ServiceType).isAssignableFrom(type)) ** GOTO lbl4
        throw new IllegalArgumentException();
lbl-1000:
        // 1 sources

        {
            type = type.getSuperclass();
lbl4:
            // 2 sources

            ** while (type.getSuperclass() != (XMLSettingsSupport.class$org$openide$ServiceType == null ? XMLSettingsSupport.class$((String)"org.openide.ServiceType") : XMLSettingsSupport.class$org$openide$ServiceType))
        }
lbl5:
        // 1 sources

        return type;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class StopSAXException
    extends SAXException {
        public StopSAXException() {
            super("Parser stopped");
        }
    }

    static final class SettingsRecognizer
    extends DefaultHandler {
        private static final String ELM_SETTING = "settings";
        private static final String ATR_SETTING_VERSION = "version";
        private static final String ELM_MODULE = "module";
        private static final String ATR_MODULE_NAME = "name";
        private static final String ATR_MODULE_SPEC = "spec";
        private static final String ATR_MODULE_IMPL = "impl";
        private static final String ELM_INSTANCE = "instance";
        private static final String ATR_INSTANCE_CLASS = "class";
        private static final String ATR_INSTANCE_METHOD = "method";
        private static final String ELM_INSTANCEOF = "instanceof";
        private static final String ATR_INSTANCEOF_CLASS = "class";
        private static final String ELM_SERIALDATA = "serialdata";
        private static final String ATR_SERIALDATA_CLASS = "class";
        private boolean header;
        private Stack stack;
        private String version;
        private String instanceClass;
        private String instanceMethod;
        private Set instanceOf = new HashSet();
        private byte[] serialdata;
        private CharArrayWriter chaos = null;
        private String codeName;
        private String codeNameBase;
        private int codeNameRelease;
        private SpecificationVersion moduleSpec;
        private String moduleImpl;
        private final FileObject source;
        static /* synthetic */ Class class$org$openide$util$SharedClassObject;
        static /* synthetic */ Class class$org$openide$filesystems$FileObject;
        static /* synthetic */ Class class$java$lang$ClassLoader;

        public SettingsRecognizer(boolean header, FileObject source) {
            this.header = header;
            this.source = source;
        }

        public boolean isAllRead() {
            return !this.header;
        }

        public void setAllRead(boolean all) {
            if (!this.header) {
                return;
            }
            this.header = all;
        }

        public String getSettingsVerison() {
            return this.version;
        }

        public String getCodeName() {
            return this.codeName;
        }

        public String getCodeNameBase() {
            return this.codeNameBase;
        }

        public int getCodeNameRelease() {
            return this.codeNameRelease;
        }

        public SpecificationVersion getSpecificationVersion() {
            return this.moduleSpec;
        }

        public String getModuleImpl() {
            return this.moduleImpl;
        }

        public Set getInstanceOf() {
            return this.instanceOf;
        }

        public String getMethodName() {
            return this.instanceMethod;
        }

        private InputStream getSerializedInstance() {
            if (this.serialdata == null) {
                return null;
            }
            return new ByteArrayInputStream(this.serialdata);
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if (XMLSettingsSupport.INSTANCE_DTD_ID.equals(publicId)) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
            return null;
        }

        public void characters(char[] values, int start, int length) throws SAXException {
            if (this.header) {
                return;
            }
            String element = (String)this.stack.peek();
            if (ELM_SERIALDATA.equals(element)) {
                if (this.chaos == null) {
                    this.chaos = new CharArrayWriter(length);
                }
                this.chaos.write(values, start, length);
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attribs) throws SAXException {
            this.stack.push(qName);
            if ("settings".equals(qName)) {
                this.version = attribs.getValue(ATR_SETTING_VERSION);
            } else if (ELM_MODULE.equals(qName)) {
                this.codeName = attribs.getValue(ATR_MODULE_NAME);
                this.resolveModuleElm(this.codeName);
                this.moduleImpl = attribs.getValue(ATR_MODULE_IMPL);
                try {
                    String spec = attribs.getValue(ATR_MODULE_SPEC);
                    this.moduleSpec = spec == null ? null : new SpecificationVersion(spec);
                }
                catch (NumberFormatException nfe) {
                    throw new SAXException(nfe);
                }
            } else if (ELM_INSTANCEOF.equals(qName)) {
                this.instanceOf.add(Utilities.translate((String)attribs.getValue("class")));
            } else if (ELM_INSTANCE.equals(qName)) {
                this.instanceClass = attribs.getValue("class");
                this.instanceClass = Utilities.translate((String)this.instanceClass);
                this.instanceMethod = attribs.getValue(ATR_INSTANCE_METHOD);
            } else if (ELM_SERIALDATA.equals(qName)) {
                this.instanceClass = attribs.getValue("class");
                this.instanceClass = Utilities.translate((String)this.instanceClass);
                if (this.header) {
                    throw new StopSAXException();
                }
            }
        }

        private void resolveModuleElm(String codeName) {
            if (codeName != null) {
                int slash = codeName.indexOf("/");
                if (slash == -1) {
                    this.codeNameBase = codeName;
                    this.codeNameRelease = -1;
                } else {
                    this.codeNameBase = codeName.substring(0, slash);
                    try {
                        this.codeNameRelease = Integer.parseInt(codeName.substring(slash + 1));
                    }
                    catch (NumberFormatException ex) {
                        ErrorManager emgr = ErrorManager.getDefault();
                        emgr.annotate((Throwable)ex, "Content: \n" + SettingsRecognizer.getFileContent(this.source));
                        emgr.annotate((Throwable)ex, "Source: " + this.source);
                        emgr.notify(1, (Throwable)ex);
                        this.codeNameRelease = -1;
                    }
                }
            } else {
                this.codeNameBase = null;
                this.codeNameRelease = -1;
            }
        }

        /*
         * Loose catch block
         */
        public void endElement(String uri, String localName, String qName) throws SAXException {
            block9: {
                String element = (String)this.stack.pop();
                if (ELM_SERIALDATA.equals(element) && this.chaos != null) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(this.chaos.size() >> 1);
                    this.chars2Bytes(baos, this.chaos.toCharArray(), 0, this.chaos.size());
                    this.serialdata = baos.toByteArray();
                    Object var8_6 = null;
                    try {
                        baos.close();
                    }
                    catch (IOException ex2) {}
                    break block9;
                    {
                        catch (IOException ex) {
                            ErrorManager.getDefault().notify(16, (Throwable)ex);
                            Object var8_7 = null;
                            try {
                                baos.close();
                            }
                            catch (IOException ex2) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        try {
                            baos.close();
                        }
                        catch (IOException ex2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
        }

        private Object readSerial(InputStream is) throws IOException, ClassNotFoundException {
            if (is == null) {
                return null;
            }
            try {
                Object object;
                SpecialObjectInputStream oi = new SpecialObjectInputStream(is);
                try {
                    Object o;
                    object = o = oi.readObject();
                    Object var6_9 = null;
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    oi.close();
                    throw throwable;
                }
                oi.close();
                return object;
            }
            catch (IOException ex) {
                ErrorManager emgr = ErrorManager.getDefault();
                emgr.annotate((Throwable)ex, "Content: \n" + SettingsRecognizer.getFileContent(this.source));
                emgr.annotate((Throwable)ex, "Source: " + this.source);
                emgr.annotate((Throwable)ex, "Cannot read class: " + this.instanceClass);
                throw ex;
            }
            catch (ClassNotFoundException ex) {
                ErrorManager emgr = ErrorManager.getDefault();
                emgr.annotate((Throwable)ex, "Content: \n" + SettingsRecognizer.getFileContent(this.source));
                emgr.annotate((Throwable)ex, "Source: " + this.source);
                throw ex;
            }
        }

        public Object instanceCreate() throws IOException, ClassNotFoundException {
            Object inst = null;
            inst = this.readSerial(this.getSerializedInstance());
            if (inst == null) {
                Class clazz;
                if (this.instanceMethod != null) {
                    inst = this.createFromMethod(this.instanceClass, this.instanceMethod);
                } else if ((class$org$openide$util$SharedClassObject == null ? (class$org$openide$util$SharedClassObject = SettingsRecognizer.class$("org.openide.util.SharedClassObject")) : class$org$openide$util$SharedClassObject).isAssignableFrom(clazz = this.instanceClass())) {
                    inst = SharedClassObject.findObject((Class)clazz, (boolean)false);
                    if (null != inst) {
                        try {
                            Method method = (class$org$openide$util$SharedClassObject == null ? (class$org$openide$util$SharedClassObject = SettingsRecognizer.class$("org.openide.util.SharedClassObject")) : class$org$openide$util$SharedClassObject).getDeclaredMethod("reset", new Class[0]);
                            ((AccessibleObject)method).setAccessible(true);
                            method.invoke(inst, new Object[0]);
                        }
                        catch (Exception e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                    } else {
                        inst = SharedClassObject.findObject((Class)clazz, (boolean)true);
                    }
                } else {
                    try {
                        inst = clazz.newInstance();
                    }
                    catch (Exception ex) {
                        IOException ioe = new IOException();
                        ErrorManager emgr = ErrorManager.getDefault();
                        emgr.annotate((Throwable)ioe, (Throwable)ex);
                        emgr.annotate((Throwable)ioe, "Content: \n" + SettingsRecognizer.getFileContent(this.source));
                        emgr.annotate((Throwable)ioe, "Class: " + clazz);
                        emgr.annotate((Throwable)ioe, "Source: " + this.source);
                        throw ioe;
                    }
                }
            }
            return inst;
        }

        private static String getFileContent(FileObject fo) {
            try {
                int length;
                InputStreamReader isr = new InputStreamReader(fo.getInputStream());
                char[] cbuf = new char[1024];
                StringBuffer sbuf = new StringBuffer(1024);
                while ((length = isr.read(cbuf)) > 0) {
                    sbuf.append(cbuf, 0, length);
                }
                return sbuf.toString();
            }
            catch (Exception ex) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                return sw.toString();
            }
        }

        private Object createFromMethod(String srcClazz, String srcMethod) throws ClassNotFoundException, IOException {
            String targetMethod;
            String targetClass;
            int dotIndex = this.instanceMethod.lastIndexOf(46);
            if (dotIndex > 0) {
                targetClass = srcMethod.substring(0, dotIndex);
                targetMethod = srcMethod.substring(dotIndex + 1);
            } else {
                targetClass = srcClazz;
                targetMethod = srcMethod;
            }
            Class clazz = this.loadClass(targetClass);
            try {
                try {
                    Method method = clazz.getMethod(targetMethod, class$org$openide$filesystems$FileObject == null ? (class$org$openide$filesystems$FileObject = SettingsRecognizer.class$("org.openide.filesystems.FileObject")) : class$org$openide$filesystems$FileObject);
                    ((AccessibleObject)method).setAccessible(true);
                    return method.invoke(null, (Object[])new FileObject[]{this.source});
                }
                catch (NoSuchMethodException ex) {
                    Method method = clazz.getMethod(targetMethod, null);
                    ((AccessibleObject)method).setAccessible(true);
                    return method.invoke(null, new Object[0]);
                }
            }
            catch (Exception ex) {
                IOException ioe = new IOException("Wrong settings format.");
                ErrorManager emgr = ErrorManager.getDefault();
                emgr.annotate((Throwable)ioe, (Throwable)ex);
                emgr.annotate((Throwable)ioe, "Content: \n" + SettingsRecognizer.getFileContent(this.source));
                emgr.annotate((Throwable)ioe, "Source: " + this.source);
                throw ioe;
            }
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            if (this.instanceClass == null) {
                throw new ClassNotFoundException(this.source + ": missing 'class' attribute in 'instance' element");
            }
            return this.loadClass(this.instanceClass);
        }

        private Class loadClass(String clazz) throws ClassNotFoundException {
            return ((ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = SettingsRecognizer.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader)).loadClass(clazz);
        }

        public String instanceName() {
            if (this.instanceClass == null) {
                return "";
            }
            return this.instanceClass;
        }

        private int tr(char c) {
            if (c >= '0' && c <= '9') {
                return c - 48;
            }
            if (c >= 'A' && c <= 'F') {
                return c - 65 + 10;
            }
            if (c >= 'a' && c <= 'f') {
                return c - 97 + 10;
            }
            return -1;
        }

        private void chars2Bytes(OutputStream os, char[] chars, int off, int length) throws IOException {
            int i = off;
            block0: while (i < length) {
                int read;
                if ((read = this.tr(chars[i++])) < 0) continue;
                byte rbyte = (byte)(read << 4);
                while (i < length) {
                    if ((read = this.tr(chars[i++])) < 0) continue;
                    rbyte = (byte)(rbyte + (byte)read);
                    os.write(rbyte);
                    continue block0;
                }
            }
        }

        /*
         * Loose catch block
         */
        public void parse() throws IOException {
            block13: {
                this.stack = new Stack();
                InputStream in = null;
                XMLReader reader = XMLUtil.createXMLReader();
                reader.setContentHandler(this);
                reader.setErrorHandler(this);
                reader.setEntityResolver(this);
                in = this.source.getInputStream();
                reader.parse(new InputSource(in));
                Object var7_4 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                    break block13;
                }
                catch (IOException ex2) {}
                break block13;
                {
                    catch (StopSAXException ex) {
                        Object var7_5 = null;
                        try {
                            if (in != null) {
                                in.close();
                            }
                            break block13;
                        }
                        catch (IOException ex2) {}
                        break block13;
                    }
                    catch (SAXException ex) {
                        IOException ioe = new IOException(this.source.toString());
                        ErrorManager emgr = ErrorManager.getDefault();
                        emgr.annotate((Throwable)ioe, (Throwable)ex);
                        if (ex.getException() != null) {
                            emgr.annotate((Throwable)ioe, (Throwable)ex.getException());
                        }
                        emgr.annotate((Throwable)ioe, "Content: \n" + SettingsRecognizer.getFileContent(this.source));
                        emgr.annotate((Throwable)ioe, "Source: " + this.source);
                        throw ioe;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ex2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class SpecialObjectInputStream
    extends ObjectInputStream {
        static /* synthetic */ Class class$java$lang$ClassLoader;

        public SpecialObjectInputStream(InputStream is) throws IOException {
            super(is);
            try {
                this.enableResolveObject(true);
            }
            catch (SecurityException ex) {
                throw new IOException(ex.toString());
            }
        }

        protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            ClassLoader cl = SpecialObjectInputStream.getNBClassLoader();
            try {
                return Class.forName(v.getName(), false, cl);
            }
            catch (ClassNotFoundException cnfe) {
                String msg = "Offending classloader: " + cl;
                ErrorManager.getDefault().annotate((Throwable)cnfe, 1, msg, null, null, null);
                throw cnfe;
            }
        }

        protected Object resolveObject(Object obj) throws IOException {
            Object o = super.resolveObject(obj);
            if (System.getProperty("java.version").startsWith("1.3") && o instanceof URL) {
                URL u = (URL)o;
                try {
                    o = new URL(u.getProtocol(), u.getHost(), u.getPort(), u.getFile());
                }
                catch (MalformedURLException ex) {
                    // empty catch block
                }
            }
            return o;
        }

        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            String newN;
            ObjectStreamClass ose = super.readClassDescriptor();
            String name = ose.getName();
            if (name == (newN = Utilities.translate((String)name))) {
                return ose;
            }
            ClassLoader cl = SpecialObjectInputStream.getNBClassLoader();
            try {
                Class<?> origCl = Class.forName(name, false, cl);
                return ObjectStreamClass.lookup(origCl);
            }
            catch (ClassNotFoundException ex) {
                Class<?> clazz = Class.forName(newN, false, cl);
                ObjectStreamClass newOse = ObjectStreamClass.lookup(clazz);
                if (newOse == null) {
                    throw new NotSerializableException(newN);
                }
                return newOse;
            }
        }

        private static ClassLoader getNBClassLoader() {
            ClassLoader c = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = SpecialObjectInputStream.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            return c != null ? c : ClassLoader.getSystemClassLoader();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class SpecialObjectOutputStream
    extends NbObjectOutputStream {
        private boolean first = true;

        public SpecialObjectOutputStream(OutputStream os) throws IOException {
            super(os);
        }

        public Object replaceObject(Object obj) throws IOException {
            if (this.first) {
                if (obj == null) {
                    throw new NotSerializableException();
                }
                this.first = false;
            }
            return super.replaceObject(obj);
        }
    }
}

