/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.projects;

import java.awt.Image;
import java.awt.Toolkit;
import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.enum.EmptyEnumeration;

public class FixedFileSystem
extends AbstractFileSystem
implements AbstractFileSystem.List,
AbstractFileSystem.Change,
AbstractFileSystem.Attr,
AbstractFileSystem.Info {
    static FixedFileSystem deflt = null;
    private final Map instances = new HashMap();
    private String displayName;
    private transient long date = System.currentTimeMillis();
    private static final Instance autoFolder = new Instance(true, null, null, null, (String)null);
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public static FixedFileSystem getDefault() {
        return deflt;
    }

    public FixedFileSystem(String name, String displayName) {
        this.list = this;
        this.change = this;
        this.info = this;
        this.attr = this;
        try {
            this.setSystemName(name);
        }
        catch (PropertyVetoException pve) {
            throw new InternalError(pve.toString());
        }
        this.displayName = displayName;
    }

    public boolean isNonTrivial() {
        return !this.instances.isEmpty();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void add(String path, Instance inst) {
        boolean nue;
        if (path.length() == 0) {
            return;
        }
        int idx = path.lastIndexOf(47);
        String folder = idx == -1 ? "" : path.substring(0, idx);
        this.add(folder, autoFolder);
        Map map = this.instances;
        synchronized (map) {
            Object old = this.instances.get(path);
            if (inst == old) {
                return;
            }
            boolean bl = nue = old == null;
            if (nue) {
                this.instances.put(path, inst);
            }
        }
        this.refreshResource(folder, false);
        if (!nue) {
            this.refreshResource(path, false);
        }
        this.date = System.currentTimeMillis();
    }

    public void remove(String path) {
        Map map = this.instances;
        synchronized (map) {
            if (this.instances.remove(path) == null) {
                return;
            }
        }
        int idx = path.lastIndexOf(47);
        if (idx != -1) {
            this.refreshResource(path.substring(0, idx), false);
        } else {
            this.refreshResource("", false);
        }
    }

    public Instance get(String path) {
        return (Instance)this.instances.get(path);
    }

    public void addDefault(String folder, String file) {
        Instance inst = (Instance)this.instances.get(folder);
        if (inst == null) {
            inst = new Instance(true, null, null, null, (String)null);
            this.add(folder, inst);
        }
        String attrName = "OpenIDE-Folder-Order";
        String attrValue = null;
        Map attrs = inst.attributes;
        if (attrs != null) {
            attrValue = (String)attrs.get(attrName);
        }
        attrValue = attrValue == null ? file : attrValue + '/' + file;
        inst.writeAttribute(attrName, attrValue);
    }

    public String toString() {
        return "FixedFileSystem[" + this.getSystemName() + "]" + this.instances.keySet();
    }

    String annotateName(String resource) {
        Map map = this.instances;
        synchronized (map) {
            Instance inst = (Instance)this.instances.get(resource);
            String string = inst == null ? null : inst.displayName;
            return string;
        }
    }

    Image annotateIcon(String resource) {
        Instance inst;
        Map map = this.instances;
        synchronized (map) {
            inst = (Instance)this.instances.get(resource);
        }
        if (inst == null) {
            return null;
        }
        if (inst.icon != null) {
            return Toolkit.getDefaultToolkit().getImage(inst.icon);
        }
        if (inst.beanName == null) {
            return null;
        }
        try {
            Class<?> clazz = ((ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = FixedFileSystem.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader)).loadClass(inst.beanName);
            return Utilities.getBeanInfo(clazz).getIcon(1);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String[] children(String f) {
        Map map = this.instances;
        synchronized (map) {
            ArrayList<String> l = new ArrayList<String>(10);
            Iterator it = this.instances.keySet().iterator();
            while (it.hasNext()) {
                String path = (String)it.next();
                if (f.length() == 0) {
                    if (path.lastIndexOf(47) != -1) continue;
                    l.add(path);
                    continue;
                }
                if (!path.startsWith(f + '/') || path.lastIndexOf(47) != f.length()) continue;
                l.add(path.substring(f.length() + 1));
            }
            String[] stringArray = l.toArray(new String[l.size()]);
            return stringArray;
        }
    }

    public void createFolder(String name) throws IOException {
        throw new IOException("unsupported");
    }

    public void createData(String name) throws IOException {
        throw new IOException("unsupported");
    }

    public void rename(String oldName, String newName) throws IOException {
        throw new IOException("unsupported");
    }

    public void delete(String name) throws IOException {
        throw new IOException("unsupported");
    }

    public Object readAttribute(String name, String attrName) {
        if ("OpenIDE-Folder-SortMode".equals(attrName)) {
            return "O";
        }
        Instance inst = (Instance)this.instances.get(name);
        if (inst == null) {
            return null;
        }
        Map m = inst.attributes;
        if (m == null) {
            return null;
        }
        Object ret = m.get(attrName);
        if (ret instanceof AttributeCreator) {
            return ((AttributeCreator)ret).createValue(this, name, attrName);
        }
        return ret;
    }

    public void writeAttribute(String name, String attrName, Object value) throws IOException {
        throw new IOException("unsupported");
    }

    public synchronized Enumeration attributes(String name) {
        Instance inst = (Instance)this.instances.get(name);
        if (inst == null) {
            return EmptyEnumeration.EMPTY;
        }
        Map m = inst.attributes;
        if (m == null) {
            return EmptyEnumeration.EMPTY;
        }
        return Collections.enumeration(m.keySet());
    }

    public void renameAttributes(String oldName, String newName) {
    }

    public void deleteAttributes(String name) {
    }

    public Date lastModified(String name) {
        return new Date(this.date);
    }

    public boolean folder(String name) {
        Map map = this.instances;
        synchronized (map) {
            Instance inst = (Instance)this.instances.get(name);
            if (inst == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = inst.folder;
            return bl;
        }
    }

    public boolean readOnly(String name) {
        return true;
    }

    public String mimeType(String name) {
        Map map = this.instances;
        synchronized (map) {
            Instance inst = (Instance)this.instances.get(name);
            String string = inst == null ? null : inst.contentType;
            return string;
        }
    }

    public long size(String name) {
        Map map = this.instances;
        synchronized (map) {
            Instance inst = (Instance)this.instances.get(name);
            if (inst == null) {
                long l = 0L;
                return l;
            }
            if (inst.folder) {
                long l = 0L;
                return l;
            }
            if (inst.contents == null) {
                long l = 0L;
                return l;
            }
            long l = inst.contents.length;
            return l;
        }
    }

    public InputStream inputStream(String name) throws FileNotFoundException {
        Instance inst;
        Map map = this.instances;
        synchronized (map) {
            inst = (Instance)this.instances.get(name);
        }
        if (inst == null) {
            throw new FileNotFoundException(name);
        }
        if (inst.folder) {
            throw new FileNotFoundException(name);
        }
        byte[] contents = inst.contents;
        if (contents == null) {
            contents = new byte[]{};
        }
        return new ByteArrayInputStream(contents);
    }

    public OutputStream outputStream(String name) throws IOException {
        throw new IOException("unsupported");
    }

    public void lock(String name) throws IOException {
        throw new IOException("unsupported");
    }

    public void unlock(String name) {
    }

    public void markUnimportant(String name) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface AttributeCreator {
        public Object createValue(FixedFileSystem var1, String var2, String var3);
    }

    public static class Instance
    implements Serializable {
        final boolean folder;
        final String contentType;
        final byte[] contents;
        final String displayName;
        final URL icon;
        final String beanName;
        Map attributes;

        public Instance(boolean folder, String contentType, byte[] contents, String displayName, URL icon) {
            this.folder = folder;
            this.contentType = contentType;
            this.contents = contents;
            this.displayName = displayName;
            this.icon = icon;
            this.beanName = null;
        }

        public Instance(boolean folder, String contentType, byte[] contents, String displayName, String beanName) {
            this.folder = folder;
            this.contentType = contentType;
            this.contents = contents;
            this.displayName = displayName;
            this.beanName = beanName;
            this.icon = null;
        }

        public void writeAttribute(String name, Object value) {
            if (this.attributes == null) {
                this.attributes = new HashMap();
            }
            this.attributes.put(name, value);
        }
    }
}

