/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.perftool;

import java.util.Arrays;
import java.util.Stack;

public class StartLog {
    private static final StartImpl impl;
    private static final Stack actions;
    private static final Stack places;
    private static final boolean DEBUG_NESTING;

    public static void logStart(String action) {
        if (StartLog.willLog()) {
            impl.start(action, System.currentTimeMillis());
            actions.push(action);
            if (DEBUG_NESTING) {
                places.push(new Throwable("logStart called here:"));
            }
        }
    }

    public static void logProgress(String note) {
        if (StartLog.willLog()) {
            impl.progress(note, System.currentTimeMillis());
        }
    }

    public static void logEnd(String action) {
        if (StartLog.willLog()) {
            Throwable oldplace;
            String old = actions.empty() ? null : (String)actions.pop();
            Throwable throwable = oldplace = DEBUG_NESTING && !places.empty() ? (Throwable)places.pop() : null;
            if (!action.equals(old)) {
                if (oldplace != null) {
                    oldplace.printStackTrace();
                } else {
                    System.err.println("Either ending too soon, or no info about caller of unmatched start log.");
                    System.err.println("Try running with -J-Dorg.netbeans.log.startup.debug=true");
                }
                Error e = new Error("StartLog mismatch: ending '" + action + "' but expecting '" + old + "'; rest of stack: " + actions);
                e.printStackTrace();
                System.exit(1);
            }
            impl.end(action, System.currentTimeMillis());
        }
    }

    public static boolean willLog() {
        return impl.willLog();
    }

    public static long measuredStartupTime() {
        return ((PrintImpl)StartLog.impl).prog - ((PrintImpl)StartLog.impl).zero;
    }

    static {
        actions = new Stack();
        places = new Stack();
        DEBUG_NESTING = Boolean.getBoolean("org.netbeans.log.startup.debug");
        String logProp = System.getProperty("org.netbeans.log.startup");
        if (logProp == null) {
            impl = new StartImpl();
        } else if ("print".equals(logProp)) {
            impl = new PrintImpl();
        } else {
            throw new Error("Unknown org.netbeans.log.startup value: " + logProp);
        }
    }

    private static class PrintImpl
    extends StartImpl {
        long zero = System.currentTimeMillis();
        private Stack starts = new Stack();
        long prog;
        private int indent = 0;
        private char[] spaces = new char[0];

        PrintImpl() {
        }

        synchronized void start(String action, long time) {
            this.starts.push(new Long(time));
            this.prog = time;
            System.err.println(this.getIndentString(this.indent) + "@" + (time - this.zero) + " - " + action + " started");
            this.indent += 2;
        }

        synchronized void progress(String note, long time) {
            System.err.println(this.getIndentString(this.indent) + "@" + (time - this.zero) + " - " + note + " dT=" + (time - this.prog));
            this.prog = time;
        }

        synchronized void end(String action, long time) {
            this.indent -= 2;
            long start = (Long)this.starts.pop();
            this.prog = time;
            System.err.println(this.getIndentString(this.indent) + "@" + (time - this.zero) + " - " + action + " finished, took " + (time - start) + "ms");
        }

        boolean willLog() {
            return true;
        }

        private String getIndentString(int indent) {
            if (this.spaces.length < indent) {
                this.spaces = new char[Math.max(this.spaces.length * 2, indent + 10)];
                Arrays.fill(this.spaces, ' ');
            }
            return new String(this.spaces, 0, indent);
        }
    }

    private static class StartImpl {
        StartImpl() {
        }

        void start(String action, long time) {
        }

        void progress(String note, long time) {
        }

        void end(String action, long time) {
        }

        boolean willLog() {
            return false;
        }
    }
}

