/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import org.netbeans.core.NonGui;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class TopLogging {
    public static final String LOG_FILE_NAME = "ide.log";
    private static boolean disabledConsole = true;
    private PrintStream logPrintStream;
    private static TopLogging topLogging;
    private static final long LOG_MAX_SIZE;
    private static final int LOG_COUNT;
    static /* synthetic */ Class class$org$netbeans$core$TopLogging;

    public TopLogging(String logDir) throws IOException {
        topLogging = this;
        File logFileDir = new File(logDir);
        if (!logFileDir.exists() && !logFileDir.mkdirs()) {
            throw new IOException("Cannot make directory to contain log file");
        }
        File logFile = TopLogging.createLogFile(logFileDir, LOG_FILE_NAME);
        if (logFile.exists() && !logFile.canWrite() || logFile.isDirectory()) {
            throw new IOException("Cannot write to file");
        }
        BufferedOutputStream log = new BufferedOutputStream(new FileOutputStream(logFile.getAbsolutePath(), true));
        DateFormat df = DateFormat.getDateTimeInstance(0, 0);
        Date date = new Date();
        disabledConsole = !Boolean.getBoolean("netbeans.logger.console");
        this.logPrintStream = new PrintStream(new StreamDemultiplexor(System.err, log));
        this.logPrintStream.println("-------------------------------------------------------------------------------");
        this.logPrintStream.println(">Log Session: " + df.format(date));
        this.logPrintStream.println(">System Info: ");
        try {
            TopLogging.printSystemInfo(this.logPrintStream);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.logPrintStream.flush();
        }
        this.logPrintStream.println("-------------------------------------------------------------------------------");
        System.setErr(this.logPrintStream);
    }

    private static TopLogging getDefault() {
        if (topLogging == null) {
            try {
                new TopLogging(NonGui.getSystemDir());
            }
            catch (IOException x) {
                ErrorManager.getDefault().notify((Throwable)x);
            }
        }
        return topLogging;
    }

    private static File createLogFile(File parent, String chld) {
        long firstModified = 0L;
        File renameTo = null;
        File retFile = new File(parent, chld);
        if (!retFile.exists() || retFile.length() < LOG_MAX_SIZE) {
            return retFile;
        }
        int i = 1;
        while (i < LOG_COUNT) {
            String logName = chld + "." + i;
            File logFile = new File(parent, logName);
            if (!logFile.exists()) {
                renameTo = logFile;
                break;
            }
            long logModif = logFile.lastModified();
            if ((firstModified == 0L || logModif < firstModified) && logModif > 0L) {
                firstModified = logModif;
                renameTo = logFile;
            }
            ++i;
        }
        if (renameTo != null) {
            if (renameTo.exists()) {
                renameTo.delete();
            }
            retFile.renameTo(renameTo);
        }
        return retFile;
    }

    public static void printSystemInfo(PrintStream ps) {
        String buildNumber = System.getProperty("netbeans.buildnumber");
        String currentVersion = NbBundle.getMessage((Class)(class$org$netbeans$core$TopLogging == null ? (class$org$netbeans$core$TopLogging = TopLogging.class$("org.netbeans.core.TopLogging")) : class$org$netbeans$core$TopLogging), (String)"currentVersion", (Object)buildNumber);
        ps.println("  Product Version       = " + currentVersion);
        ps.println("  IDE Versioning        = " + System.getProperty("org.openide.major.version") + " spec=" + System.getProperty("org.openide.specification.version") + " impl=" + System.getProperty("org.openide.version"));
        ps.println("  Operating System      = " + System.getProperty("os.name", "unknown") + " version " + System.getProperty("os.version", "unknown") + " running on " + System.getProperty("os.arch", "unknown"));
        ps.println("  Java; VM; Vendor      = " + System.getProperty("java.version", "unknown") + "; " + System.getProperty("java.vm.name", "unknown") + " " + System.getProperty("java.vm.version", "") + "; " + System.getProperty("java.vendor", "unknown"));
        ps.println("  Java Home             = " + System.getProperty("java.home", "unknown"));
        ps.print("  System Locale; Encod. = " + Locale.getDefault());
        String branding = NbBundle.getBranding();
        if (branding != null) {
            ps.print(" (" + branding + ")");
        }
        ps.println("; " + System.getProperty("file.encoding", "unknown"));
        ps.println("  Home Dir; Current Dir = " + System.getProperty("user.home", "unknown") + "; " + System.getProperty("user.dir", "unknown"));
        ps.println("  IDE Install; User Dir = " + NonGui.getHomeDir() + "; " + NonGui.getUserDir());
        ps.println("  CLASSPATH             = " + System.getProperty("java.class.path", "unknown"));
        ps.println("  Boot & ext classpath  = " + TopLogging.createBootClassPath());
        ps.println("  Dynamic classpath     = " + System.getProperty("netbeans.dynamic.classpath", "unknown"));
    }

    private static String createBootClassPath() {
        String boot = System.getProperty("sun.boot.class.path");
        StringBuffer sb = boot != null ? new StringBuffer(boot) : new StringBuffer();
        String extensions = System.getProperty("java.ext.dirs");
        if (extensions != null) {
            StringTokenizer st = new StringTokenizer(extensions, File.pathSeparator);
            while (st.hasMoreTokens()) {
                File dir = new File(st.nextToken());
                File[] entries = dir.listFiles();
                if (entries == null) continue;
                int i = 0;
                while (i < entries.length) {
                    String name = entries[i].getName().toLowerCase(Locale.US);
                    if (name.endsWith(".zip") || name.endsWith(".jar")) {
                        if (sb.length() > 0) {
                            sb.append(File.pathSeparatorChar);
                        }
                        sb.append(entries[i].getPath());
                    }
                    ++i;
                }
            }
        }
        return sb.toString();
    }

    public void finalize() throws Throwable {
        this.logPrintStream.flush();
        this.logPrintStream.close();
    }

    static PrintStream getLogOutputStream() {
        if (System.getProperty("netbeans.user") == null) {
            return System.err;
        }
        return TopLogging.getDefault().logPrintStream;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LOG_MAX_SIZE = Long.getLong("org.netbeans.core.TopLogging.LOG_MAX_SIZE", 262144L);
        LOG_COUNT = Integer.getInteger("org.netbeans.core.TopLogging.LOG_COUNT", 3);
    }

    private static final class StreamDemultiplexor
    extends OutputStream
    implements Runnable {
        private RequestProcessor.Task logFlushTask;
        private static final RequestProcessor RP = new RequestProcessor("Flush ide.log");
        private static final Object FLUSH_LOCK = new String("org.netbeans.core.TopLogging.StreamDemultiplexor.FLUSH_LOCK");
        private static final int FLUSH_DELAY = Integer.getInteger("netbeans.logger.flush.delay", 15000);
        private final OutputStream stderr;
        private final OutputStream log;

        StreamDemultiplexor(PrintStream stderr, OutputStream log) {
            this.stderr = stderr;
            this.log = log;
        }

        public void write(int b) throws IOException {
            this.log.write(b);
            if (!disabledConsole) {
                this.stderr.write(b);
            }
            this.flushLog();
        }

        public void write(byte[] b) throws IOException {
            this.log.write(b);
            if (!disabledConsole) {
                this.stderr.write(b);
            }
            this.flushLog();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.log.write(b, off, len);
            if (!disabledConsole) {
                this.stderr.write(b, off, len);
            }
            this.flushLog();
        }

        public void flush() throws IOException {
            this.log.flush();
            this.stderr.flush();
        }

        public void close() throws IOException {
            this.log.close();
            this.stderr.close();
        }

        private void flushLog() {
            Object object = FLUSH_LOCK;
            synchronized (object) {
                if (this.logFlushTask == null) {
                    this.logFlushTask = RP.create((Runnable)this);
                    this.logFlushTask.schedule(FLUSH_DELAY);
                }
            }
        }

        public void run() {
            Object object = FLUSH_LOCK;
            synchronized (object) {
                try {
                    this.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.logFlushTask = null;
            }
        }
    }
}

