/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.BreakIterator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import org.netbeans.core.NbErrorManager;
import org.netbeans.core.NbPresenter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class NotifyException
extends JPanel
implements ActionListener {
    static final long serialVersionUID = 3680397500573480127L;
    private static NotifyException INSTANCE = null;
    private static final int MAXIMUM_TEXT_WIDTH = 40;
    private static final int SIZE_PREFERRED_WIDTH = 550;
    private static final int SIZE_PREFERRED_HEIGHT = 250;
    private static ArrayListPos exceptions;
    private NbErrorManager.Exc current;
    private DialogDescriptor descriptor;
    private Dialog dialog;
    private JButton next;
    private JButton previous;
    private JButton details;
    private JEditorPane output;
    private boolean showDetails;
    static /* synthetic */ Class class$org$netbeans$core$NotifyException;

    private NotifyException() {
        this.setPreferredSize(new Dimension(550, 250));
        exceptions = new ArrayListPos();
        ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$core$NotifyException == null ? (class$org$netbeans$core$NotifyException = NotifyException.class$("org.netbeans.core.NotifyException")) : class$org$netbeans$core$NotifyException));
        this.next = new JButton(bundle.getString("CTL_NextException"));
        this.previous = new JButton(bundle.getString("CTL_PreviousException"));
        this.details = new JButton();
        this.output = new JEditorPane();
        this.output.setEditable(false);
        this.output.setFont(new Font("Monospaced", 0, 12));
        this.output.setForeground(UIManager.getColor("Label.foreground"));
        this.output.setBackground(UIManager.getColor("Label.background"));
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane(this.output));
        this.setBorder(new BevelBorder(1));
        this.next.setMnemonic(bundle.getString("CTL_NextException_Mnemonic").charAt(0));
        this.previous.setMnemonic(bundle.getString("CTL_PreviousException_Mnemonic").charAt(0));
        this.next.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_NextException"));
        this.previous.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_PreviousException"));
        this.output.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_ExceptionStackTrace"));
        this.output.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ExceptionStackTrace"));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_NotifyExceptionPanel"));
        this.descriptor = new DialogDescriptor((Object)"", "");
        this.descriptor.setMessageType(0);
        this.descriptor.setOptions(new Object[]{this.previous, this.next, NotifyDescriptor.OK_OPTION});
        this.descriptor.setAdditionalOptions(new Object[]{this.details});
        this.descriptor.setClosingOptions(new Object[0]);
        this.descriptor.setButtonListener((ActionListener)this);
        this.descriptor.setModal(NbPresenter.currentModalDialog != null);
        this.dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
    }

    public static void notify(final NbErrorManager.Exc t) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String glm = t.getLocalizedMessage();
                int gs = t.getSeverity();
                boolean loc = t.isLocalized();
                if (gs == 16 && loc) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)glm, 2));
                } else if (gs == 256 && loc) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)glm, 1));
                } else if (gs == 65536 && loc) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)glm, 0));
                } else {
                    if (INSTANCE == null) {
                        INSTANCE = new NotifyException();
                    }
                    INSTANCE.updateState(t);
                }
            }
        });
    }

    private void updateState(NbErrorManager.Exc t) {
        exceptions.add(t);
        if (!exceptions.existsNextElement()) {
            this.current = t;
            this.update();
        } else {
            this.next.setVisible(true);
        }
        this.ensurePreferredSize();
        this.dialog.show();
    }

    private void ensurePreferredSize() {
        Dimension pref;
        Dimension sz = this.dialog.getSize();
        if (!sz.equals(pref = this.dialog.getPreferredSize())) {
            ((Component)this.dialog).setSize(pref.width, pref.height);
            this.dialog.validate();
            this.dialog.repaint();
        }
    }

    private void update() {
        boolean isLocalized = this.current.isLocalized();
        this.next.setVisible(exceptions.existsNextElement());
        this.previous.setVisible(exceptions.existsPreviousElement());
        if (this.showDetails) {
            this.details.setText(NbBundle.getBundle((Class)(class$org$netbeans$core$NotifyException == null ? (class$org$netbeans$core$NotifyException = NotifyException.class$("org.netbeans.core.NotifyException")) : class$org$netbeans$core$NotifyException)).getString("CTL_Exception_Hide_Details"));
            this.details.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$core$NotifyException == null ? (class$org$netbeans$core$NotifyException = NotifyException.class$("org.netbeans.core.NotifyException")) : class$org$netbeans$core$NotifyException)).getString("CTL_Exception_Hide_Details_Mnemonic").charAt(0));
            this.details.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$NotifyException == null ? (class$org$netbeans$core$NotifyException = NotifyException.class$("org.netbeans.core.NotifyException")) : class$org$netbeans$core$NotifyException)).getString("ACSD_Exception_Hide_Details"));
        } else {
            this.details.setText(NbBundle.getBundle((Class)(class$org$netbeans$core$NotifyException == null ? (class$org$netbeans$core$NotifyException = NotifyException.class$("org.netbeans.core.NotifyException")) : class$org$netbeans$core$NotifyException)).getString("CTL_Exception_Show_Details"));
            this.details.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$core$NotifyException == null ? (class$org$netbeans$core$NotifyException = NotifyException.class$("org.netbeans.core.NotifyException")) : class$org$netbeans$core$NotifyException)).getString("CTL_Exception_Show_Details_Mnemonic").charAt(0));
            this.details.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$NotifyException == null ? (class$org$netbeans$core$NotifyException = NotifyException.class$("org.netbeans.core.NotifyException")) : class$org$netbeans$core$NotifyException)).getString("ACSD_Exception_Show_Details"));
        }
        String title = NbBundle.getBundle((Class)(class$org$netbeans$core$NotifyException == null ? (class$org$netbeans$core$NotifyException = NotifyException.class$("org.netbeans.core.NotifyException")) : class$org$netbeans$core$NotifyException)).getString("CTL_Title_Exception");
        if (this.showDetails) {
            this.descriptor.setMessage((Object)this);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StringWriter wr = new StringWriter();
                    NotifyException.this.current.printStackTrace(new PrintWriter((Writer)wr, true));
                    NotifyException.this.output.setText(wr.toString());
                    NotifyException.this.output.getCaret().setDot(0);
                    NotifyException.this.output.requestFocus();
                }
            });
        } else if (isLocalized) {
            String msg = this.current.getLocalizedMessage();
            if (msg != null) {
                msg = Utilities.wrapString((String)msg, (int)40, (BreakIterator)BreakIterator.getCharacterInstance(), (boolean)false);
                this.descriptor.setMessage((Object)msg);
            }
        } else {
            ResourceBundle curBundle = NbBundle.getBundle((Class)(class$org$netbeans$core$NotifyException == null ? (class$org$netbeans$core$NotifyException = NotifyException.class$("org.netbeans.core.NotifyException")) : class$org$netbeans$core$NotifyException));
            if (this.current.getSeverity() == 16) {
                this.descriptor.setMessage((Object)MessageFormat.format(curBundle.getString("NTF_ExceptionWarning"), this.current.getClassName()));
                title = curBundle.getString("NTF_ExceptionWarningTitle");
            } else {
                this.descriptor.setMessage((Object)MessageFormat.format(curBundle.getString("NTF_ExceptionalException"), this.current.getClassName(), new File(System.getProperty("netbeans.user"), "system")));
                title = curBundle.getString("NTF_ExceptionalExceptionTitle");
            }
        }
        this.descriptor.setTitle(title);
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.next && exceptions.setNextElement() || ev.getSource() == this.previous && exceptions.setPreviousElement()) {
            this.current = (NbErrorManager.Exc)exceptions.get();
            this.update();
            return;
        }
        if (ev.getSource() == this.details) {
            this.showDetails = !this.showDetails;
            this.update();
            this.ensurePreferredSize();
            return;
        }
        if (ev.getSource() == NotifyDescriptor.OK_OPTION) {
            exceptions.removeAll();
            this.dialog.dispose();
            INSTANCE = null;
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class ArrayListPos
    extends ArrayList {
        protected int position = 0;

        protected ArrayListPos() {
        }

        protected boolean existsElement() {
            return this.size() > 0;
        }

        protected boolean existsNextElement() {
            return this.position + 1 < this.size();
        }

        protected boolean existsPreviousElement() {
            return this.position > 0 && this.size() > 0;
        }

        protected boolean setNextElement() {
            if (!this.existsNextElement()) {
                return false;
            }
            ++this.position;
            return true;
        }

        protected boolean setPreviousElement() {
            if (!this.existsPreviousElement()) {
                return false;
            }
            --this.position;
            return true;
        }

        protected Object get() {
            return this.existsElement() ? this.get(this.position) : null;
        }

        protected void removeAll() {
            this.clear();
            this.position = 0;
        }
    }
}

