/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.beaninfo.editors.DataFolderEditor;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.RepositoryNodeFactory;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.enum.SequenceEnumeration;
import org.openide.util.enum.SingletonEnumeration;
import org.openide.windows.TopComponent;

class DataFolderPanel
extends TopComponent
implements DocumentListener,
DataFilter,
EnhancedCustomPropertyEditor,
PropertyChangeListener,
VetoableChangeListener {
    static Dimension PREF_DIM = new Dimension(450, 250);
    private static MessageFormat defaultFolderName;
    private ChangeListener listener;
    private Reference system = new WeakReference<Object>(null);
    private Node rootNode;
    private DataFolder df;
    private DataFolderEditor editor;
    private static final String PATH_TOKEN_DELIMITER;
    private String last_suggestion = "";
    private JLabel packageLabel;
    private ExplorerPanel packagesPanel;
    private JButton createButton;
    private JTextField directoryName;
    private JLabel descriptionLabel;
    private JLabel dirLabel;
    private JTextField packageName;
    private BeanTreeView beanTreeView;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$netbeans$beaninfo$editors$DataFolderPanel;

    public DataFolderPanel(DataFolderEditor ed) {
        this();
        this.editor = ed;
    }

    public DataFolderPanel() {
        this.initComponents();
        this.setName(DataFolderPanel.getString("LAB_TargetLocationPanelName"));
        ((JComponent)((Object)this)).setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
        this.rootNode = this.createPackagesNode();
        this.packagesPanel.getExplorerManager().setRootContext(this.rootNode);
        this.packagesPanel.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
        this.packagesPanel.getExplorerManager().addVetoableChangeListener((VetoableChangeListener)this);
        this.packageName.getDocument().addDocumentListener(this);
        this.packageName.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this.descriptionLabel.setDisplayedMnemonic(DataFolderPanel.getString("LAB_TargetLocationDescription_mnemonic").charAt(0));
        this.packageLabel.setDisplayedMnemonic(DataFolderPanel.getString("LAB_package_mnemonic").charAt(0));
        this.dirLabel.setDisplayedMnemonic(DataFolderPanel.getString("LAB_directory_mnemonic").charAt(0));
        this.createButton.setMnemonic(DataFolderPanel.getString("CTL_Create_mnemonic").charAt(0));
        this.beanTreeView.getAccessibleContext().setAccessibleDescription(DataFolderPanel.getString("ACSD_DataFolderTree"));
        this.packageName.getAccessibleContext().setAccessibleDescription(DataFolderPanel.getString("ACSD_package"));
        this.directoryName.getAccessibleContext().setAccessibleDescription(DataFolderPanel.getString("ACSD_directory"));
        this.createButton.getAccessibleContext().setAccessibleDescription(DataFolderPanel.getString("ACSD_Create"));
        this.getAccessibleContext().setAccessibleDescription(DataFolderPanel.getString("ACSD_DataFolderPanel"));
    }

    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    public void requestFocus() {
    }

    private Node createPackagesNode() {
        return RepositoryNodeFactory.getDefault().repository((DataFilter)this);
    }

    private void initComponents() {
        this.packagesPanel = new ExplorerPanel();
        this.beanTreeView = new BeanTreeView();
        this.descriptionLabel = new JLabel();
        this.packageLabel = new JLabel();
        this.packageName = new JTextField();
        this.dirLabel = new JLabel();
        this.directoryName = new JTextField();
        this.createButton = new JButton();
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.packagesPanel.setLayout(new GridBagLayout());
        this.beanTreeView.setPopupAllowed(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.packagesPanel.add((Component)this.beanTreeView, gridBagConstraints);
        this.descriptionLabel.setLabelFor((Component)this.beanTreeView);
        this.descriptionLabel.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("LAB_TargetLocationDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.packagesPanel.add((Component)this.descriptionLabel, gridBagConstraints);
        this.packageLabel.setLabelFor(this.packageName);
        this.packageLabel.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("LAB_package"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 12);
        this.packagesPanel.add((Component)this.packageLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.packagesPanel.add((Component)this.packageName, gridBagConstraints);
        this.dirLabel.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("LAB_directory"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.packagesPanel.add((Component)this.dirLabel, gridBagConstraints);
        this.directoryName.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.packagesPanel.add((Component)this.directoryName, gridBagConstraints);
        this.createButton.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_Create"));
        this.createButton.setEnabled(false);
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataFolderPanel.this.createButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.packagesPanel.add((Component)this.createButton, gridBagConstraints);
        ((Container)((Object)this)).add((Component)this.packagesPanel, "Center");
    }

    private void createButtonActionPerformed(ActionEvent evt) {
        try {
            DataFolder newDf = (DataFolder)this.getPropertyValue();
            this.setTargetFolder(newDf);
            this.updateDirectory();
            this.updatePropertyEditor();
            this.enableCreateButton();
        }
        catch (IllegalStateException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public boolean acceptDataObject(DataObject obj) {
        return obj instanceof DataFolder;
    }

    public void vetoableChange(PropertyChangeEvent ev) throws PropertyVetoException {
        Node[] arr;
        if ("selectedNodes".equals(ev.getPropertyName()) && (arr = (Node[])ev.getNewValue()).length > 1) {
            throw new PropertyVetoException("Only single selection allowed", ev);
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if ("selectedNodes".equals(ev.getPropertyName())) {
            Node[] arr = this.packagesPanel.getExplorerManager().getSelectedNodes();
            if (!((Component)((Object)this)).isVisible()) {
                return;
            }
            if (arr.length == 1) {
                if (!this.isValid()) {
                    this.setTargetFolder(null);
                    this.implSetDataFolder(null);
                    return;
                }
                DataFolder df = (DataFolder)arr[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = DataFolderPanel.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
                if (df != null) {
                    this.setTargetFolder(df);
                    this.updatePropertyEditor();
                    this.enableCreateButton();
                    return;
                }
            }
            this.setTargetFolder(null);
            this.implSetDataFolder(null);
        }
    }

    private void fireStateChanged() {
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    public void changedUpdate(DocumentEvent p1) {
        if (p1.getDocument() == this.packageName.getDocument()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String text = DataFolderPanel.this.packageName.getText();
                    if (text != null) {
                        if (DataFolderPanel.this.isValid()) {
                            DataFolderPanel.this.setTargetFolder(text, false);
                            DataFolderPanel.this.updatePropertyEditor();
                        }
                        DataFolderPanel.this.updateDirectory();
                    }
                    DataFolderPanel.this.enableCreateButton();
                }
            });
            return;
        }
    }

    public void removeUpdate(DocumentEvent p1) {
        if (p1.getDocument() == this.packageName.getDocument()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String text;
                    FileSystem fs;
                    if (DataFolderPanel.this.packageName.getText().length() == 0 && (fs = (FileSystem)DataFolderPanel.this.system.get()) != null) {
                        DataFolder df = DataFolder.findFolder((FileObject)fs.getRoot());
                        DataFolderPanel.this.setTargetFolder(df);
                        DataFolderPanel.this.packageName.selectAll();
                    }
                    if ((text = DataFolderPanel.this.packageName.getText()) != null) {
                        if (DataFolderPanel.this.isValid()) {
                            DataFolderPanel.this.setTargetFolder(text, true);
                            DataFolderPanel.this.updatePropertyEditor();
                        }
                        DataFolderPanel.this.updateDirectory();
                    }
                    DataFolderPanel.this.enableCreateButton();
                }
            });
        }
    }

    public void insertUpdate(DocumentEvent p1) {
        this.changedUpdate(p1);
    }

    public HelpCtx getHelp() {
        return new HelpCtx(class$org$netbeans$beaninfo$editors$DataFolderPanel == null ? (class$org$netbeans$beaninfo$editors$DataFolderPanel = DataFolderPanel.class$("org.netbeans.beaninfo.editors.DataFolderPanel")) : class$org$netbeans$beaninfo$editors$DataFolderPanel);
    }

    public boolean isValid() {
        Node[] arr;
        String text = this.packageName.getText();
        return text.length() != 0 || (arr = this.packagesPanel.getExplorerManager().getSelectedNodes()).length != 1 || arr[0] != this.rootNode;
    }

    public void addChangeListener(ChangeListener l) {
        if (this.listener != null) {
            throw new IllegalStateException();
        }
        this.listener = l;
    }

    public void removeChangeListener(ChangeListener l) {
        this.listener = null;
    }

    private static String computeSuggestion(Node node, String pref, Node[] first) {
        Node[] arr = node.getChildren().getNodes();
        String match = null;
        int i = 0;
        while (i < arr.length) {
            String name = arr[i].getName();
            if (name.startsWith(pref)) {
                if (match == null) {
                    match = name;
                    if (first != null) {
                        first[0] = arr[i];
                    }
                } else {
                    int indx = pref.length();
                    int end = Math.min(name.length(), match.length());
                    while (indx < end && match.charAt(indx) == name.charAt(indx)) {
                        ++indx;
                    }
                    match = match.substring(0, indx);
                }
            }
            ++i;
        }
        if (match == null) {
            return null;
        }
        return match.substring(pref.length());
    }

    boolean setTargetFolder(DataFolder f) {
        boolean exact;
        Node n;
        String name;
        this.df = f;
        if (f != null) {
            FileObject fo = f.getPrimaryFile();
            name = fo.getPath();
            StringTokenizer st = new StringTokenizer(name, PATH_TOKEN_DELIMITER);
            try {
                FileSystem fs = fo.getFileSystem();
                if (fo.isRoot() && fo.getFileObject(name = this.packageName.getText().trim()) != null) {
                    name = "";
                }
                this.system = new WeakReference<FileSystem>(fs);
                SequenceEnumeration en = new SequenceEnumeration((Enumeration)new SingletonEnumeration((Object)fs.getSystemName()), (Enumeration)st);
                n = NodeOp.findPath((Node)this.rootNode, (Enumeration)en);
                exact = true;
            }
            catch (FileStateInvalidException ex) {
                n = this.rootNode;
                name = "";
                exact = false;
            }
            catch (NodeNotFoundException ex) {
                n = ex.getClosestNode();
                DataFolder df = (DataFolder)n.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = DataFolderPanel.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
                name = df != null ? df.getPrimaryFile().getPath() : "";
                exact = false;
            }
        } else {
            n = this.rootNode;
            name = null;
            exact = true;
        }
        ExplorerManager em = this.packagesPanel.getExplorerManager();
        em.removePropertyChangeListener((PropertyChangeListener)this);
        this.packageName.getDocument().removeDocumentListener(this);
        try {
            em.setSelectedNodes(new Node[]{n});
        }
        catch (PropertyVetoException ex) {
            throw new InternalError();
        }
        this.packageName.setText(name);
        this.updateDirectory();
        this.packageName.getDocument().addDocumentListener(this);
        em.addPropertyChangeListener((PropertyChangeListener)this);
        this.fireStateChanged();
        return exact;
    }

    private DataFolder getTargetFolder(boolean create) throws IOException {
        FileSystem fs;
        if (create && this.isValid() && (fs = (FileSystem)this.system.get()) != null) {
            DataFolder folder = DataFolder.findFolder((FileObject)fs.getRoot());
            String currentName = this.packageName.getText();
            if (currentName.length() > 0) {
                folder = DataFolder.create((DataFolder)folder, (String)currentName);
            }
            this.df = folder;
            return folder;
        }
        return this.df;
    }

    /*
     * Unable to fully structure code
     */
    private boolean setTargetFolder(String f, boolean afterDelete) {
        n = null;
        closest = null;
        selected = new HashSet<Node>();
        nodes = this.packagesPanel.getExplorerManager().getSelectedNodes();
        i = 0;
        while (i < nodes.length) {
            block19: {
                n1 = nodes[i];
                if (n1.getParentNode() != null) ** GOTO lbl11
                break block19;
lbl-1000:
                // 1 sources

                {
                    n1 = n1.getParentNode();
lbl11:
                    // 2 sources

                    ** while (n1.getParentNode().getParentNode() != null)
                }
lbl12:
                // 1 sources

                selected.add(n1);
            }
            ++i;
        }
        arr = this.rootNode.getChildren().getNodes();
        i = 0;
        while (i < arr.length) {
            root = arr[i];
            st = new StringTokenizer(f, DataFolderPanel.PATH_TOKEN_DELIMITER);
            try {
                n = NodeOp.findPath((Node)root, (Enumeration)st);
                break;
            }
            catch (NodeNotFoundException ex) {
                if (!st.hasMoreElements()) {
                    sugg = DataFolderPanel.computeSuggestion(ex.getClosestNode(), ex.getMissingChildName(), null);
                    if ((closest == null || selected.contains(root)) && sugg != null) {
                        closest = ex;
                    }
                }
                ++i;
            }
        }
        if (n != null) {
            closest = null;
        } else {
            if (closest == null) {
                return false;
            }
            n = closest.getClosestNode();
        }
        em = this.packagesPanel.getExplorerManager();
        em.removePropertyChangeListener((PropertyChangeListener)this);
        if (closest != null) {
            first = new Node[1];
            sugg = DataFolderPanel.computeSuggestion(closest.getClosestNode(), closest.getMissingChildName(), first);
            if (afterDelete && sugg != null && sugg.equals(this.last_suggestion)) {
                sugg = null;
            }
            this.last_suggestion = sugg;
            if (sugg != null) {
                this.packageName.getDocument().removeDocumentListener(this);
                this.packageName.setText(f + sugg);
                this.updateDirectory();
                c = this.packageName.getCaret();
                c.setDot(f.length() + sugg.length());
                c.moveDot(f.length());
                this.packageName.getDocument().addDocumentListener(this);
            }
            if (first[0] != null) {
                n = first[0];
            }
        }
        try {
            em.setSelectedNodes(new Node[]{n});
        }
        catch (PropertyVetoException ex) {
            throw new InternalError();
        }
        this.df = (DataFolder)n.getCookie(DataFolderPanel.class$org$openide$loaders$DataFolder == null ? (DataFolderPanel.class$org$openide$loaders$DataFolder = DataFolderPanel.class$("org.openide.loaders.DataFolder")) : DataFolderPanel.class$org$openide$loaders$DataFolder);
        if (this.df != null) {
            try {
                fs = this.df.getPrimaryFile().getFileSystem();
                this.system = new WeakReference<FileSystem>(fs);
            }
            catch (FileStateInvalidException ex) {
                // empty catch block
            }
        }
        em.addPropertyChangeListener((PropertyChangeListener)this);
        this.fireStateChanged();
        return closest == null;
    }

    private static String defaultFolderName(FileSystem fs) {
        if (defaultFolderName == null) {
            defaultFolderName = new MessageFormat(DataFolderPanel.getString("FMT_TemplateDefaultFolderName"));
        }
        String n = fs == null ? "" : fs.getDisplayName();
        return defaultFolderName.format(new Object[]{n});
    }

    private void updateDirectory() {
        FileObject folder;
        FileSystem fs = (FileSystem)this.system.get();
        if (fs == null) {
            this.directoryName.setText("");
            return;
        }
        String name = this.packageName.getText();
        if (name.equals(DataFolderPanel.defaultFolderName(fs))) {
            name = "";
        }
        if ((folder = fs.findResource(name)) != null) {
            File f = FileUtil.toFile((FileObject)folder);
            if (f != null) {
                this.directoryName.setText(f.getAbsolutePath());
            } else {
                this.directoryName.setText("");
            }
        } else {
            File f = FileUtil.toFile((FileObject)fs.getRoot());
            if (f != null) {
                File f2 = new File(f, name.replace('/', File.separatorChar));
                this.directoryName.setText(f2.getAbsolutePath());
            } else {
                this.directoryName.setText("");
            }
        }
    }

    private void implSetDataFolder(DataFolder df) {
        if (this.editor != null) {
            if (!this.isValid()) {
                this.editor.setDataFolder(null);
            } else {
                String name;
                if (df == null && this.system != null && this.system.get() != null) {
                    df = DataFolder.findFolder((FileObject)((FileSystem)this.system.get()).getRoot());
                }
                if ((name = df.getPrimaryFile().getPath()).equals(this.packageName.getText())) {
                    this.editor.setDataFolder(df);
                } else {
                    this.editor.setDataFolder(null);
                }
            }
        }
    }

    private void updatePropertyEditor() {
        try {
            DataFolder newF = this.getTargetFolder(false);
            this.implSetDataFolder(newF);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private void enableCreateButton() {
        String name = null;
        name = this.df != null ? this.df.getPrimaryFile().getPath() : "";
        if (name.equals(this.packageName.getText())) {
            this.createButton.setEnabled(false);
        } else {
            this.createButton.setEnabled(this.isValid());
        }
    }

    public Object getPropertyValue() throws IllegalStateException {
        if (this.isValid()) {
            try {
                this.df = this.getTargetFolder(true);
                return this.df;
            }
            catch (IOException x) {
                ErrorManager.getDefault().notify((Throwable)x);
                throw new IllegalStateException();
            }
        }
        throw new IllegalStateException();
    }

    private static String getString(String s) {
        return NbBundle.getBundle((Class)(class$org$netbeans$beaninfo$editors$DataFolderPanel == null ? (class$org$netbeans$beaninfo$editors$DataFolderPanel = DataFolderPanel.class$("org.netbeans.beaninfo.editors.DataFolderPanel")) : class$org$netbeans$beaninfo$editors$DataFolderPanel)).getString(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PATH_TOKEN_DELIMITER = "/" + File.separatorChar;
    }

    public static class ShadowLeafNode
    extends AbstractNode {
        public ShadowLeafNode() {
            super(Children.LEAF);
        }
    }

    public static class ShadowDirNode
    extends AbstractNode {
        public ShadowDirNode(Children children) {
            super(children);
        }
    }
}

